const char argparse_lua[] =
"local fun = require('fun')\n"
"\n"
"local function parse_param_prefix(param)\n"
"    if param == nil then return nil end\n"
"    local is_long  = (param:find(\"^[-][-]\") ~= nil)\n"
"    local is_short = not is_long and (param:find(\"^[-]\") ~= nil)\n"
"    local is_dash  = is_short and (param:find(\"^[-]$\") ~= nil)\n"
"    return is_long, is_short, is_dash\n"
"end\n"
"\n"
"-- Determine whether a value should be provided for a parameter.\n"
"--\n"
"-- The value can be passed after '=' within the same argument or\n"
"-- in a next argument.\n"
"--\n"
"-- @param convert_to a type of the parameter\n"
"local function parameter_has_value(convert_to)\n"
"    return convert_to ~= 'boolean' and convert_to ~= 'boolean+'\n"
"end\n"
"\n"
"local function result_set_add(t_out, key, val)\n"
"    if val == nil then\n"
"        table.insert(t_out, key)\n"
"    elseif t_out[key] == nil then\n"
"        t_out[key] = val\n"
"    elseif type(t_out[key]) == 'table' then\n"
"        table.insert(t_out[key], val)\n"
"    else\n"
"        t_out[key] = {t_out[key], val}\n"
"    end\n"
"end\n"
"\n"
"local function err_bad_parameter_value(name, got, expected)\n"
"    assert(type(got) == 'boolean' or type(got) == 'string')\n"
"    assert(type(got) ~= expected)\n"
"\n"
"    local reason\n"
"    if type(got) == 'boolean' then\n"
"        reason = ('Expected %s, got nothing'):format(expected)\n"
"    elseif not parameter_has_value(expected) then\n"
"        reason = ('No value expected, got \"%s\"'):format(got)\n"
"    else\n"
"        reason = ('Expected %s, got \"%s\"'):format(expected, got)\n"
"    end\n"
"    error(string.format('Bad value for parameter \"%s\". %s', name, reason))\n"
"end\n"
"\n"
"local function convert_parameter_simple(name, convert_from, convert_to)\n"
"    if convert_to == 'number' then\n"
"        local converted = tonumber(convert_from)\n"
"        if converted == nil then\n"
"            return err_bad_parameter_value(name, convert_from, convert_to)\n"
"        end\n"
"        return converted\n"
"    elseif convert_to == 'boolean' then\n"
"        if type(convert_from) ~= 'boolean' then\n"
"            return err_bad_parameter_value(name, convert_from, convert_to)\n"
"        end\n"
"    elseif convert_to == 'string' then\n"
"        if type(convert_from) ~= 'string' then\n"
"            return err_bad_parameter_value(name, convert_from, convert_to)\n"
"        end\n"
"    else\n"
"        error(\n"
"            ('Bad conversion format \"%s\" provided for %s')\n"
"            :format(convert_to, name)\n"
"        )\n"
"    end\n"
"    return convert_from\n"
"end\n"
"\n"
"local function convert_parameter(name, convert_from, convert_to)\n"
"    if convert_to == nil then\n"
"        return convert_from\n"
"    end\n"
"    if convert_to:find('+') then\n"
"        convert_to = convert_to:sub(1, -2)\n"
"        if type(convert_from) ~= 'table' then\n"
"            convert_from = { convert_from }\n"
"        end\n"
"        convert_from = fun.iter(convert_from):map(function(v)\n"
"            return convert_parameter_simple(name, v, convert_to)\n"
"        end):totable()\n"
"    else\n"
"        if type(convert_from) == 'table' then\n"
"            convert_from = table.remove(convert_from)\n"
"        end\n"
"        convert_from = convert_parameter_simple(name, convert_from, convert_to)\n"
"    end\n"
"    return convert_from\n"
"end\n"
"\n"
"local function parameters_parse(t_in, options)\n"
"    local t_out, t_in = {}, t_in or {}\n"
"\n"
"    -- Prepare a lookup table for options. An option name -> a\n"
"    -- type name to convert a parameter into or true (which means\n"
"    -- returning a value as is).\n"
"    local lookup = {}\n"
"    if options then\n"
"        for _, v in ipairs(options) do\n"
"            if type(v) ~= 'table' then\n"
"                v = {v}\n"
"            end\n"
"            lookup[v[1]] = (v[2] or true)\n"
"        end\n"
"    end\n"
"\n"
"    local skip_param = false\n"
"    for i, v in ipairs(t_in) do\n"
"        -- we've used this parameter as value\n"
"        if skip_param == true then\n"
"            skip_param = false\n"
"            goto nextparam\n"
"        end\n"
"        local is_long, is_short, is_dash = parse_param_prefix(v)\n"
"        if not is_dash and is_short then\n"
"            local commands = v:sub(2)\n"
"            if not (commands:match(\"^[%a]+$\")) then\n"
"                error((\"bad argument #%d: ID not valid\"):format(i))\n"
"            end\n"
"            for id in v:sub(2):gmatch(\"%a\") do\n"
"                result_set_add(t_out, id, true)\n"
"            end\n"
"        elseif is_long then\n"
"            local command = v:sub(3)\n"
"            if command:find('=') then\n"
"                local key, val = command:match(\"^([%a_][%w_-]+)%=(.*)$\")\n"
"                if key == nil or val == nil then\n"
"                    error((\"bad argument #%d: ID not valid\"):format(i))\n"
"                end\n"
"                -- Disallow an explicit value after '=' for a\n"
"                -- 'boolean' or 'boolean+' argument.\n"
"                if not parameter_has_value(lookup[key]) then\n"
"                    return err_bad_parameter_value(key, val, lookup[key])\n"
"                end\n"
"                result_set_add(t_out, key, val)\n"
"            else\n"
"                if command:match(\"^([%a_][%w_-]+)$\") == nil then\n"
"                    error((\"bad argument #%d: ID not valid\"):format(i))\n"
"                end\n"
"                local val = true\n"
"                -- Don't consume a value after a 'boolean' or\n"
"                -- 'boolean+' argument.\n"
"                if parameter_has_value(lookup[command]) then\n"
"                    -- in case next argument is value of this key (not --arg)\n"
"                    local next_arg = t_in[i + 1]\n"
"                    local is_long, is_short, is_dash = parse_param_prefix(next_arg)\n"
"                    if is_dash then\n"
"                        skip_param = true\n"
"                    elseif is_long == false and not is_short and not is_dash then\n"
"                        val = next_arg\n"
"                        skip_param = true\n"
"                    end\n"
"                end\n"
"                result_set_add(t_out, command, val)\n"
"            end\n"
"        else\n"
"            table.insert(t_out, v)\n"
"        end\n"
"::nextparam::\n"
"    end\n"
"    if options then\n"
"        local unknown = {}\n"
"        for k, v in pairs(t_out) do\n"
"            if lookup[k] == nil and type(k) == \"string\" then\n"
"                table.insert(unknown, k)\n"
"            elseif type(lookup[k]) == 'string' then\n"
"                t_out[k] = convert_parameter(k, v, lookup[k])\n"
"            end\n"
"        end\n"
"        if #unknown > 0 then\n"
"            error((\"unknown options: %s\"):format(table.concat(unknown, \", \")))\n"
"        end\n"
"    end\n"
"    return t_out\n"
"end\n"
"\n"
"return {\n"
"    parse = parameters_parse\n"
"}\n"
""
;
