/* simple-scan.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from simple-scan.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <gusb.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <colord.h>
#include <float.h>
#include <math.h>
#include <sane/sane.h>
#include <glib/gstdio.h>
#include <locale.h>
#include <unistd.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;
typedef struct _SimpleScanPrivate SimpleScanPrivate;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_FREEDESKTOP_SCREENSAVER (freedesktop_screensaver_get_type ())
#define FREEDESKTOP_SCREENSAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FREEDESKTOP_SCREENSAVER, FreedesktopScreensaver))
#define IS_FREEDESKTOP_SCREENSAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FREEDESKTOP_SCREENSAVER))
#define FREEDESKTOP_SCREENSAVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FREEDESKTOP_SCREENSAVER, FreedesktopScreensaverIface))

typedef struct _FreedesktopScreensaver FreedesktopScreensaver;
typedef struct _FreedesktopScreensaverIface FreedesktopScreensaverIface;

#define TYPE_FREEDESKTOP_SCREENSAVER_PROXY (freedesktop_screensaver_proxy_get_type ())
enum  {
	SIMPLE_SCAN_0_PROPERTY,
	SIMPLE_SCAN_NUM_PROPERTIES
};
static GParamSpec* simple_scan_properties[SIMPLE_SCAN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block12Data Block12Data;

#define TYPE_AUTHORIZE_DIALOG_RESPONSE (authorize_dialog_response_get_type ())
typedef struct _AuthorizeDialogResponse AuthorizeDialogResponse;
typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF,
	SCAN_TYPE_BATCH
} ScanType;

#define TYPE_SCAN_TYPE (scan_type_get_type ())
typedef enum  {
	SCAN_SIDE_FRONT,
	SCAN_SIDE_BACK,
	SCAN_SIDE_BOTH
} ScanSide;

#define TYPE_SCAN_SIDE (scan_side_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _SimpleScan {
	AdwApplication parent_instance;
	SimpleScanPrivate * priv;
};

struct _SimpleScanClass {
	AdwApplicationClass parent_class;
};

struct _FreedesktopScreensaverIface {
	GTypeInterface parent_iface;
	guint32 (*inhibit) (FreedesktopScreensaver* self, const gchar* application_name, const gchar* reason_for_inhibit, GError** error);
	void (*uninhibit) (FreedesktopScreensaver* self, guint32 cookie, GError** error);
};

struct _SimpleScanPrivate {
	ScanDevice* default_device;
	gboolean have_devices;
	GUsbContext* usb_context;
	AppWindow* app;
	Scanner* scanner;
	Book* book;
	Page* scanned_page;
	guint inhibit_cookie;
	FreedesktopScreensaver* fdss;
};

struct _ScanDevice {
	GObject parent_instance;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GObjectClass parent_class;
};

struct _Block12Data {
	int _ref_count_;
	SimpleScan* self;
	Scanner* scanner;
};

struct _AuthorizeDialogResponse {
	gchar* username;
	gchar* password;
	gboolean success;
};

struct _ScanPageInfo {
	GObject parent_instance;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GObjectClass parent_class;
};

struct _ScanOptions {
	GObject parent_instance;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	ScanSide side;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
	gint page_delay;
};

struct _ScanOptionsClass {
	GObjectClass parent_class;
};

static gint SimpleScan_private_offset;
static gpointer simple_scan_parent_class = NULL;
static gboolean simple_scan_show_version;
static gboolean simple_scan_debug_enabled;
static gchar* simple_scan_fix_pdf_filename;
static gboolean simple_scan_show_version = FALSE;
static gboolean simple_scan_debug_enabled = FALSE;
static gchar* simple_scan_fix_pdf_filename = NULL;
static GTimer* simple_scan_log_timer;
static GTimer* simple_scan_log_timer = NULL;
static FILE* simple_scan_log_file;
static FILE* simple_scan_log_file = NULL;

VALA_EXTERN GType simple_scan_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SimpleScan, g_object_unref)
VALA_EXTERN GType scan_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanDevice, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN GType scanner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Scanner, g_object_unref)
VALA_EXTERN GType book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Book, g_object_unref)
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN GType freedesktop_screensaver_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint freedesktop_screensaver_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN GType freedesktop_screensaver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FreedesktopScreensaver, g_object_unref)
VALA_EXTERN SimpleScan* simple_scan_new (ScanDevice* device);
VALA_EXTERN SimpleScan* simple_scan_construct (GType object_type,
                                   ScanDevice* device);
static void simple_scan_real_startup (GApplication* base);
VALA_EXTERN AppWindow* app_window_new (void);
VALA_EXTERN AppWindow* app_window_construct (GType object_type);
VALA_EXTERN Book* app_window_get_book (AppWindow* self);
VALA_EXTERN GType scan_options_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanOptions, g_object_unref)
static void simple_scan_scan_cb (SimpleScan* self,
                          AppWindow* ui,
                          const gchar* device,
                          ScanOptions* options);
static void _simple_scan_scan_cb_app_window_start_scan (AppWindow* _sender,
                                                 const gchar* device,
                                                 ScanOptions* options,
                                                 gpointer self);
static void simple_scan_cancel_cb (SimpleScan* self,
                            AppWindow* ui);
static void _simple_scan_cancel_cb_app_window_stop_scan (AppWindow* _sender,
                                                  gpointer self);
static void simple_scan_redetect_cb (SimpleScan* self,
                              AppWindow* ui);
static void _simple_scan_redetect_cb_app_window_redetect (AppWindow* _sender,
                                                   gpointer self);
VALA_EXTERN Scanner* scanner_get_instance (void);
static void simple_scan_update_scan_devices_cb (SimpleScan* self,
                                         Scanner* scanner,
                                         GList* devices);
static void _simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender,
                                                                 GList* devices,
                                                                 gpointer self);
static void simple_scan_authorize_cb (SimpleScan* self,
                               Scanner* scanner,
                               const gchar* resource);
static void _simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender,
                                                              const gchar* resource,
                                                              gpointer self);
static void simple_scan_scanner_new_page_cb (SimpleScan* self,
                                      Scanner* scanner);
static void _simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender,
                                                           gpointer self);
VALA_EXTERN GType scan_page_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanPageInfo, g_object_unref)
static void simple_scan_scanner_page_info_cb (SimpleScan* self,
                                       Scanner* scanner,
                                       ScanPageInfo* info);
static void _simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender,
                                                              ScanPageInfo* info,
                                                              gpointer self);
VALA_EXTERN GType scan_line_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanLine, g_object_unref)
static void simple_scan_scanner_line_cb (SimpleScan* self,
                                  Scanner* scanner,
                                  ScanLine* line);
static void _simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender,
                                                    ScanLine* line,
                                                    gpointer self);
static void simple_scan_scanner_page_done_cb (SimpleScan* self,
                                       Scanner* scanner);
static void _simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender,
                                                          gpointer self);
static void simple_scan_scanner_document_done_cb (SimpleScan* self,
                                           Scanner* scanner);
static void _simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender,
                                                                  gpointer self);
static void simple_scan_scanner_failed_cb (SimpleScan* self,
                                    Scanner* scanner,
                                    gint error_code,
                                    const gchar* error_string);
static void _simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender,
                                                         gint error_code,
                                                         const gchar* error_string,
                                                         gpointer self);
static void simple_scan_scanner_scanning_changed_cb (SimpleScan* self,
                                              Scanner* scanner);
static void _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender,
                                                                        gpointer self);
static void ___lambda48_ (SimpleScan* self);
VALA_EXTERN void scanner_redetect (Scanner* self);
static void ____lambda48__g_usb_context_device_added (GUsbContext* _sender,
                                               GUsbDevice* device,
                                               gpointer self);
static void ___lambda49_ (SimpleScan* self);
static void ____lambda49__g_usb_context_device_removed (GUsbContext* _sender,
                                                 GUsbDevice* device,
                                                 gpointer self);
VALA_EXTERN void app_window_set_scan_devices (AppWindow* self,
                                  GList* devices,
                                  const gchar* missing_driver);
VALA_EXTERN void app_window_set_selected_device (AppWindow* self,
                                     const gchar* device);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN void app_window_start (AppWindow* self);
VALA_EXTERN void scanner_start (Scanner* self);
static void simple_scan_real_activate (GApplication* base);
static void simple_scan_real_shutdown (GApplication* base);
VALA_EXTERN void scanner_free (Scanner* self);
VALA_EXTERN gchar* simple_scan_suggest_driver (SimpleScan* self);
static void _g_free0_ (gpointer var);
static void simple_scan_add_devices (SimpleScan* self,
                              GHashTable* map,
                              guint32* devices,
                              gint devices_length1,
                              const gchar* driver);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
VALA_EXTERN void app_window_authorize (AppWindow* self,
                           const gchar* resource,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
VALA_EXTERN GType authorize_dialog_response_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AuthorizeDialogResponse* authorize_dialog_response_dup (const AuthorizeDialogResponse* self);
VALA_EXTERN void authorize_dialog_response_free (AuthorizeDialogResponse* self);
VALA_EXTERN void authorize_dialog_response_copy (const AuthorizeDialogResponse* self,
                                     AuthorizeDialogResponse* dest);
VALA_EXTERN void authorize_dialog_response_destroy (AuthorizeDialogResponse* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (AuthorizeDialogResponse, authorize_dialog_response_destroy)
VALA_EXTERN void app_window_authorize_finish (AppWindow* self,
                                  GAsyncResult* _res_,
                                  AuthorizeDialogResponse* result);
static void __lambda47_ (Block12Data* _data12_,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN void scanner_authorize (Scanner* self,
                        const gchar* username,
                        const gchar* password);
static void ___lambda47__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Page* simple_scan_append_page (SimpleScan* self,
                               gint width,
                               gint height,
                               gint dpi);
VALA_EXTERN Page* book_get_page (Book* self,
                     gint page_number);
VALA_EXTERN gboolean page_get_has_data (Page* self);
VALA_EXTERN void app_window_set_selected_page (AppWindow* self,
                                   Page* value);
VALA_EXTERN void page_start (Page* self);
VALA_EXTERN GType scan_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ScanDirection page_get_scan_direction (Page* self);
VALA_EXTERN gint page_get_width (Page* self);
VALA_EXTERN gint page_get_height (Page* self);
VALA_EXTERN gint page_get_dpi (Page* self);
VALA_EXTERN gboolean page_get_has_crop (Page* self);
VALA_EXTERN const gchar* page_get_crop_name (Page* self);
VALA_EXTERN gint page_get_crop_x (Page* self);
VALA_EXTERN gint page_get_crop_y (Page* self);
VALA_EXTERN gint page_get_crop_width (Page* self);
VALA_EXTERN gint page_get_crop_height (Page* self);
VALA_EXTERN Page* page_new (gint width,
                gint height,
                gint dpi,
                ScanDirection scan_direction);
VALA_EXTERN Page* page_construct (GType object_type,
                      gint width,
                      gint height,
                      gint dpi,
                      ScanDirection scan_direction);
VALA_EXTERN void book_append_page (Book* self,
                       Page* page);
VALA_EXTERN void page_set_named_crop (Page* self,
                          const gchar* name);
VALA_EXTERN void page_set_custom_crop (Page* self,
                           gint width,
                           gint height);
VALA_EXTERN void page_move_crop (Page* self,
                     gint x,
                     gint y);
static gchar* simple_scan_get_profile_for_device (SimpleScan* self,
                                           const gchar* device_name);
VALA_EXTERN void page_set_page_info (Page* self,
                         ScanPageInfo* info);
VALA_EXTERN void page_set_color_profile (Page* self,
                             const gchar* value);
VALA_EXTERN void page_parse_scan_line (Page* self,
                           ScanLine* line);
VALA_EXTERN void page_finish (Page* self);
static void simple_scan_remove_empty_page (SimpleScan* self);
VALA_EXTERN guint book_get_n_pages (Book* self);
VALA_EXTERN void book_delete_page (Book* self,
                       Page* page);
VALA_EXTERN void app_window_show_error_dialog (AppWindow* self,
                                   const gchar* error_title,
                                   const gchar* error_text);
VALA_EXTERN gboolean scanner_is_scanning (Scanner* self);
VALA_EXTERN FreedesktopScreensaver* freedesktop_screensaver_get_proxy (GError** error);
VALA_EXTERN guint32 freedesktop_screensaver_inhibit (FreedesktopScreensaver* self,
                                         const gchar* application_name,
                                         const gchar* reason_for_inhibit,
                                         GError** error);
VALA_EXTERN void freedesktop_screensaver_uninhibit (FreedesktopScreensaver* self,
                                        guint32 cookie,
                                        GError** error);
VALA_EXTERN void app_window_set_scanning (AppWindow* self,
                              gboolean value);
VALA_EXTERN GType scan_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scan_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scan_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void scanner_scan (Scanner* self,
                   const gchar* device,
                   ScanOptions* options);
VALA_EXTERN void scanner_cancel (Scanner* self);
static void simple_scan_log_cb (const gchar* log_domain,
                         GLogLevelFlags log_level,
                         const gchar* message);
static void simple_scan_fix_pdf (const gchar* filename,
                          GError** error);
static gint simple_scan_main (gchar** args,
                       gint args_length1);
VALA_EXTERN ScanDevice* scan_device_new (void);
VALA_EXTERN ScanDevice* scan_device_construct (GType object_type);
static void _simple_scan_log_cb_glog_func (const gchar* log_domain,
                                    GLogLevelFlags log_levels,
                                    const gchar* message,
                                    gpointer self);
static void simple_scan_finalize (GObject * obj);
static GType simple_scan_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GOptionEntry SIMPLE_SCAN_options[4] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, &simple_scan_show_version, N_ ("Show release version"), NULL}, {"debug", 'd', (gint) 0, G_OPTION_ARG_NONE, &simple_scan_debug_enabled, N_ ("Print debugging messages"), NULL}, {"fix-pdf", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &simple_scan_fix_pdf_filename, N_ ("Fix PDF files generated with older versions of this app"), "FILENAME…"}, {NULL}};
static const guint32 SIMPLE_SCAN_brscan_devices[56] = {(guint32) 0x04f90110, (guint32) 0x04f90111, (guint32) 0x04f90112, (guint32) 0x04f9011d, (guint32) 0x04f9011e, (guint32) 0x04f9011f, (guint32) 0x04f9012b, (guint32) 0x04f90124, (guint32) 0x04f90153, (guint32) 0x04f90125, (guint32) 0x04f90113, (guint32) 0x04f90114, (guint32) 0x04f90115, (guint32) 0x04f90116, (guint32) 0x04f90119, (guint32) 0x04f9011a, (guint32) 0x04f9011b, (guint32) 0x04f9011c, (guint32) 0x04f9012e, (guint32) 0x04f9012f, (guint32) 0x04f90130, (guint32) 0x04f90128, (guint32) 0x04f90127, (guint32) 0x04f90142, (guint32) 0x04f90143, (guint32) 0x04f90140, (guint32) 0x04f90141, (guint32) 0x04f9014e, (guint32) 0x04f9014f, (guint32) 0x04f90150, (guint32) 0x04f90151, (guint32) 0x04f9010e, (guint32) 0x04f9013a, (guint32) 0x04f90120, (guint32) 0x04f9010f, (guint32) 0x04f90121, (guint32) 0x04f90122, (guint32) 0x04f90132, (guint32) 0x04f9013d, (guint32) 0x04f9013c, (guint32) 0x04f90136, (guint32) 0x04f90135, (guint32) 0x04f9013e, (guint32) 0x04f9013f, (guint32) 0x04f90144, (guint32) 0x04f90146, (guint32) 0x04f90148, (guint32) 0x04f9014a, (guint32) 0x04f9014b, (guint32) 0x04f9014c, (guint32) 0x04f90157, (guint32) 0x04f90158, (guint32) 0x04f9015d, (guint32) 0x04f9015e, (guint32) 0x04f9015f, (guint32) 0x04f90160};
static const guint32 SIMPLE_SCAN_brscan2_devices[31] = {(guint32) 0x04f901c9, (guint32) 0x04f901ca, (guint32) 0x04f901cb, (guint32) 0x04f901cc, (guint32) 0x04f901ec, (guint32) 0x04f901e4, (guint32) 0x04f901e3, (guint32) 0x04f901e2, (guint32) 0x04f901e1, (guint32) 0x04f901e0, (guint32) 0x04f901df, (guint32) 0x04f901de, (guint32) 0x04f901dd, (guint32) 0x04f901dc, (guint32) 0x04f901db, (guint32) 0x04f901da, (guint32) 0x04f901d9, (guint32) 0x04f901d8, (guint32) 0x04f901d7, (guint32) 0x04f901d6, (guint32) 0x04f901d5, (guint32) 0x04f901d4, (guint32) 0x04f901d3, (guint32) 0x04f901d2, (guint32) 0x04f901d1, (guint32) 0x04f901d0, (guint32) 0x04f901cf, (guint32) 0x04f901ce, (guint32) 0x04f9020d, (guint32) 0x04f9020c, (guint32) 0x04f9020a};
static const guint32 SIMPLE_SCAN_brscan3_devices[58] = {(guint32) 0x04f90222, (guint32) 0x04f90223, (guint32) 0x04f90224, (guint32) 0x04f90225, (guint32) 0x04f90229, (guint32) 0x04f9022a, (guint32) 0x04f9022c, (guint32) 0x04f90228, (guint32) 0x04f90236, (guint32) 0x04f90227, (guint32) 0x04f9022b, (guint32) 0x04f9022d, (guint32) 0x04f9022e, (guint32) 0x04f9022f, (guint32) 0x04f90230, (guint32) 0x04f9021b, (guint32) 0x04f9021a, (guint32) 0x04f90219, (guint32) 0x04f9023f, (guint32) 0x04f90216, (guint32) 0x04f9021d, (guint32) 0x04f9021c, (guint32) 0x04f90220, (guint32) 0x04f9021e, (guint32) 0x04f9023e, (guint32) 0x04f90235, (guint32) 0x04f9023a, (guint32) 0x04f901c9, (guint32) 0x04f901ca, (guint32) 0x04f901cb, (guint32) 0x04f901cc, (guint32) 0x04f901ec, (guint32) 0x04f9020d, (guint32) 0x04f9020c, (guint32) 0x04f90257, (guint32) 0x04f9025d, (guint32) 0x04f90254, (guint32) 0x04f9025b, (guint32) 0x04f9026b, (guint32) 0x04f90258, (guint32) 0x04f9025e, (guint32) 0x04f90256, (guint32) 0x04f90240, (guint32) 0x04f9025f, (guint32) 0x04f90260, (guint32) 0x04f90261, (guint32) 0x04f90278, (guint32) 0x04f9026f, (guint32) 0x04f9026e, (guint32) 0x04f9026d, (guint32) 0x04f90234, (guint32) 0x04f90239, (guint32) 0x04f90253, (guint32) 0x04f90255, (guint32) 0x04f90259, (guint32) 0x04f9025a, (guint32) 0x04f9025c, (guint32) 0x04f90276};
static const guint32 SIMPLE_SCAN_brscan4_devices[395] = {(guint32) 0x04f90314, (guint32) 0x04f90313, (guint32) 0x04f90312, (guint32) 0x04f90311, (guint32) 0x04f90310, (guint32) 0x04f9030f, (guint32) 0x04f90366, (guint32) 0x04f90365, (guint32) 0x04f90364, (guint32) 0x04f90350, (guint32) 0x04f9034f, (guint32) 0x04f9034e, (guint32) 0x04f9034b, (guint32) 0x04f90349, (guint32) 0x04f90347, (guint32) 0x04f90346, (guint32) 0x04f90343, (guint32) 0x04f90342, (guint32) 0x04f90341, (guint32) 0x04f90340, (guint32) 0x04f9033d, (guint32) 0x04f9033c, (guint32) 0x04f9033a, (guint32) 0x04f90339, (guint32) 0x04f90392, (guint32) 0x04f90373, (guint32) 0x04f9036e, (guint32) 0x04f9036d, (guint32) 0x04f9036c, (guint32) 0x04f9036b, (guint32) 0x04f9036a, (guint32) 0x04f90369, (guint32) 0x04f90368, (guint32) 0x04f90367, (guint32) 0x04f90338, (guint32) 0x04f90337, (guint32) 0x04f90335, (guint32) 0x04f90331, (guint32) 0x04f90330, (guint32) 0x04f90329, (guint32) 0x04f90328, (guint32) 0x04f90326, (guint32) 0x04f90324, (guint32) 0x04f90322, (guint32) 0x04f90321, (guint32) 0x04f90320, (guint32) 0x04f90372, (guint32) 0x04f90371, (guint32) 0x04f90370, (guint32) 0x04f9036f, (guint32) 0x04f90361, (guint32) 0x04f90360, (guint32) 0x04f9035e, (guint32) 0x04f9035d, (guint32) 0x04f9035c, (guint32) 0x04f9035b, (guint32) 0x04f90379, (guint32) 0x04f90378, (guint32) 0x04f90376, (guint32) 0x04f9037a, (guint32) 0x04f9037b, (guint32) 0x04f90377, (guint32) 0x04f9037f, (guint32) 0x04f9037e, (guint32) 0x04f9037d, (guint32) 0x04f9037c, (guint32) 0x04f9035a, (guint32) 0x04f90359, (guint32) 0x04f90358, (guint32) 0x04f90357, (guint32) 0x04f90356, (guint32) 0x04f90355, (guint32) 0x04f90354, (guint32) 0x04f90353, (guint32) 0x04f90351, (guint32) 0x04f90390, (guint32) 0x04f903b3, (guint32) 0x04f90396, (guint32) 0x04f90395, (guint32) 0x04f90394, (guint32) 0x04f90393, (guint32) 0x04f90380, (guint32) 0x04f90381, (guint32) 0x04f903bd, (guint32) 0x04f90383, (guint32) 0x04f90397, (guint32) 0x04f90386, (guint32) 0x04f90384, (guint32) 0x04f90385, (guint32) 0x04f90388, (guint32) 0x04f90389, (guint32) 0x04f9038b, (guint32) 0x04f9038a, (guint32) 0x04f9038c, (guint32) 0x04f9038e, (guint32) 0x04f9038f, (guint32) 0x04f9038d, (guint32) 0x04f903bc, (guint32) 0x04f903bb, (guint32) 0x04f903b6, (guint32) 0x04f903b5, (guint32) 0x04f903b4, (guint32) 0x04f9034a, (guint32) 0x04f9034c, (guint32) 0x04f903c5, (guint32) 0x04f903c1, (guint32) 0x04f903c0, (guint32) 0x04f903bf, (guint32) 0x04f903c7, (guint32) 0x04f903c6, (guint32) 0x04f903b2, (guint32) 0x04f903b1, (guint32) 0x04f903b0, (guint32) 0x04f903af, (guint32) 0x04f903ae, (guint32) 0x04f903ad, (guint32) 0x04f903ac, (guint32) 0x04f903ab, (guint32) 0x04f903aa, (guint32) 0x04f903a9, (guint32) 0x04f903a8, (guint32) 0x04f903a7, (guint32) 0x04f903a6, (guint32) 0x04f903a5, (guint32) 0x04f903a3, (guint32) 0x04f903a2, (guint32) 0x04f903a0, (guint32) 0x04f9039f, (guint32) 0x04f9039e, (guint32) 0x04f9039d, (guint32) 0x04f9039c, (guint32) 0x04f9039b, (guint32) 0x04f9039a, (guint32) 0x04f90399, (guint32) 0x04f90398, (guint32) 0x04f903ba, (guint32) 0x04f903b9, (guint32) 0x04f903b8, (guint32) 0x04f903b7, (guint32) 0x04f903ca, (guint32) 0x04f903c9, (guint32) 0x04f903c8, (guint32) 0x04f903f2, (guint32) 0x04f903f1, (guint32) 0x04f903f0, (guint32) 0x04f903ef, (guint32) 0x04f903ee, (guint32) 0x04f903ed, (guint32) 0x04f903eb, (guint32) 0x04f903ea, (guint32) 0x04f903e8, (guint32) 0x04f903e7, (guint32) 0x04f903e6, (guint32) 0x04f903e5, (guint32) 0x04f903e4, (guint32) 0x04f903e3, (guint32) 0x04f903e2, (guint32) 0x04f903e0, (guint32) 0x04f903d6, (guint32) 0x04f903d5, (guint32) 0x04f903d3, (guint32) 0x04f903d1, (guint32) 0x04f903d0, (guint32) 0x04f903cf, (guint32) 0x04f903cd, (guint32) 0x04f903cc, (guint32) 0x04f903cb, (guint32) 0x04f903f7, (guint32) 0x04f903f6, (guint32) 0x04f903f5, (guint32) 0x04f903f4, (guint32) 0x04f903f3, (guint32) 0x04f903fa, (guint32) 0x04f903e1, (guint32) 0x04f90290, (guint32) 0x04f9028f, (guint32) 0x04f9028d, (guint32) 0x04f9028a, (guint32) 0x04f90284, (guint32) 0x04f90283, (guint32) 0x04f90282, (guint32) 0x04f90281, (guint32) 0x04f9027e, (guint32) 0x04f9027d, (guint32) 0x04f9027c, (guint32) 0x04f9027b, (guint32) 0x04f90280, (guint32) 0x04f9027a, (guint32) 0x04f90279, (guint32) 0x04f9027f, (guint32) 0x04f90285, (guint32) 0x04f9029a, (guint32) 0x04f9029f, (guint32) 0x04f9029e, (guint32) 0x04f90289, (guint32) 0x04f90288, (guint32) 0x04f9043d, (guint32) 0x04f9043c, (guint32) 0x04f9043b, (guint32) 0x04f9043a, (guint32) 0x04f90439, (guint32) 0x04f90438, (guint32) 0x04f90437, (guint32) 0x04f90436, (guint32) 0x04f90435, (guint32) 0x04f90434, (guint32) 0x04f90433, (guint32) 0x04f90432, (guint32) 0x04f90431, (guint32) 0x04f90430, (guint32) 0x04f9042e, (guint32) 0x04f9042d, (guint32) 0x04f9042c, (guint32) 0x04f9042b, (guint32) 0x04f9042a, (guint32) 0x04f90429, (guint32) 0x04f90428, (guint32) 0x04f90427, (guint32) 0x04f90425, (guint32) 0x04f90424, (guint32) 0x04f90423, (guint32) 0x04f90422, (guint32) 0x04f90421, (guint32) 0x04f90420, (guint32) 0x04f9041f, (guint32) 0x04f9041e, (guint32) 0x04f9041d, (guint32) 0x04f9041c, (guint32) 0x04f9041b, (guint32) 0x04f9041a, (guint32) 0x04f90419, (guint32) 0x04f90418, (guint32) 0x04f90417, (guint32) 0x04f90413, (guint32) 0x04f90412, (guint32) 0x04f90411, (guint32) 0x04f90410, (guint32) 0x04f9040f, (guint32) 0x04f90408, (guint32) 0x04f90407, (guint32) 0x04f90406, (guint32) 0x04f90405, (guint32) 0x04f90404, (guint32) 0x04f90403, (guint32) 0x04f90400, (guint32) 0x04f903ff, (guint32) 0x04f903f8, (guint32) 0x04f9043e, (guint32) 0x04f9040e, (guint32) 0x04f9040d, (guint32) 0x04f9040b, (guint32) 0x04f9040a, (guint32) 0x04f90409, (guint32) 0x04f90402, (guint32) 0x04f903fe, (guint32) 0x04f903f9, (guint32) 0x04f9044b, (guint32) 0x04f9044a, (guint32) 0x04f90448, (guint32) 0x04f90446, (guint32) 0x04f90445, (guint32) 0x04f90442, (guint32) 0x04f90441, (guint32) 0x04f9043f, (guint32) 0x04f90454, (guint32) 0x04f9044f, (guint32) 0x04f9044d, (guint32) 0x04f90462, (guint32) 0x04f90461, (guint32) 0x04f90460, (guint32) 0x04f9044c, (guint32) 0x04f90443, (guint32) 0x04f9045f, (guint32) 0x04f90457, (guint32) 0x04f90456, (guint32) 0x04f90453, (guint32) 0x04f90452, (guint32) 0x04f90451, (guint32) 0x04f90450, (guint32) 0x04f9044e, (guint32) 0x04f90466, (guint32) 0x04f90465, (guint32) 0x04f90464, (guint32) 0x04f90463, (guint32) 0x04f90447, (guint32) 0x04f90444, (guint32) 0x04f90440, (guint32) 0x04f9045e, (guint32) 0x04f9045d, (guint32) 0x04f9045c, (guint32) 0x04f90470, (guint32) 0x04f9046f, (guint32) 0x04f9046e, (guint32) 0x04f9046d, (guint32) 0x04f90467, (guint32) 0x04f960a0, (guint32) 0x04f960a1, (guint32) 0x04f90293, (guint32) 0x04f902b7, (guint32) 0x04f90294, (guint32) 0x04f90296, (guint32) 0x04f90298, (guint32) 0x04f902ba, (guint32) 0x04f90299, (guint32) 0x04f902bb, (guint32) 0x04f902d4, (guint32) 0x04f90291, (guint32) 0x04f902ac, (guint32) 0x04f902b5, (guint32) 0x04f90292, (guint32) 0x04f902b6, (guint32) 0x04f90295, (guint32) 0x04f902b8, (guint32) 0x04f9029c, (guint32) 0x04f902cb, (guint32) 0x04f902ca, (guint32) 0x04f902a6, (guint32) 0x04f902a7, (guint32) 0x04f902ab, (guint32) 0x04f902a5, (guint32) 0x04f902a8, (guint32) 0x04f902a0, (guint32) 0x04f902c1, (guint32) 0x04f902c0, (guint32) 0x04f902bf, (guint32) 0x04f902be, (guint32) 0x04f902bd, (guint32) 0x04f902bc, (guint32) 0x04f902b2, (guint32) 0x04f90287, (guint32) 0x04f902cf, (guint32) 0x04f902ce, (guint32) 0x04f902cd, (guint32) 0x04f902c7, (guint32) 0x04f902c6, (guint32) 0x04f902c5, (guint32) 0x04f902c4, (guint32) 0x04f902b4, (guint32) 0x04f902b3, (guint32) 0x04f902c2, (guint32) 0x04f960a4, (guint32) 0x04f960a5, (guint32) 0x04f902cc, (guint32) 0x04f902c8, (guint32) 0x04f902c3, (guint32) 0x04f902d3, (guint32) 0x04f902b1, (guint32) 0x04f902b0, (guint32) 0x04f902af, (guint32) 0x04f902ae, (guint32) 0x04f902ad, (guint32) 0x04f902d1, (guint32) 0x04f902d0, (guint32) 0x04f902fb, (guint32) 0x04f902f1, (guint32) 0x04f902f0, (guint32) 0x04f902ef, (guint32) 0x04f902ed, (guint32) 0x04f902ec, (guint32) 0x04f902ee, (guint32) 0x04f902eb, (guint32) 0x04f902e9, (guint32) 0x04f902e8, (guint32) 0x04f902fa, (guint32) 0x04f902ea, (guint32) 0x04f902e6, (guint32) 0x04f902e5, (guint32) 0x04f902e4, (guint32) 0x04f902e3, (guint32) 0x04f902e2, (guint32) 0x04f902f9, (guint32) 0x04f902de, (guint32) 0x04f902e0, (guint32) 0x04f902df, (guint32) 0x04f902e1, (guint32) 0x04f902e7, (guint32) 0x04f902fc, (guint32) 0x04f902fd, (guint32) 0x04f902fe, (guint32) 0x04f902dd, (guint32) 0x04f902c9, (guint32) 0x04f902ff, (guint32) 0x04f90300, (guint32) 0x04f902f2, (guint32) 0x04f902f3, (guint32) 0x04f902f4, (guint32) 0x04f902f8, (guint32) 0x04f902f5, (guint32) 0x04f902f6, (guint32) 0x04f902f7, (guint32) 0x04f90318, (guint32) 0x04f960a6, (guint32) 0x04f960a7, (guint32) 0x04f960a8, (guint32) 0x04f960a9};
static const guint32 SIMPLE_SCAN_pixma_devices[199] = {(guint32) 0x04a91709, (guint32) 0x04a9170a, (guint32) 0x04a9170b, (guint32) 0x04a9170c, (guint32) 0x04a91712, (guint32) 0x04a91714, (guint32) 0x04a91715, (guint32) 0x04a91716, (guint32) 0x04a91717, (guint32) 0x04a91718, (guint32) 0x04a91719, (guint32) 0x04a9172b, (guint32) 0x04a9171c, (guint32) 0x04a91721, (guint32) 0x04a91722, (guint32) 0x04a91723, (guint32) 0x04a91724, (guint32) 0x04a91725, (guint32) 0x04a91727, (guint32) 0x04a91728, (guint32) 0x04a91729, (guint32) 0x04a9172c, (guint32) 0x04a9172e, (guint32) 0x04a9172f, (guint32) 0x04a91730, (guint32) 0x04a91731, (guint32) 0x04a91732, (guint32) 0x04a91733, (guint32) 0x04a91734, (guint32) 0x04a91735, (guint32) 0x04a91736, (guint32) 0x04a91737, (guint32) 0x04a9173a, (guint32) 0x04a9173b, (guint32) 0x04a9173c, (guint32) 0x04a9173d, (guint32) 0x04a9173e, (guint32) 0x04a9173f, (guint32) 0x04a91741, (guint32) 0x04a91742, (guint32) 0x04a91743, (guint32) 0x04a91746, (guint32) 0x04a91747, (guint32) 0x04a91748, (guint32) 0x04a91749, (guint32) 0x04a9174a, (guint32) 0x04a9174d, (guint32) 0x04a9174e, (guint32) 0x04a9174f, (guint32) 0x04a91750, (guint32) 0x04a91751, (guint32) 0x04a91752, (guint32) 0x04a91753, (guint32) 0x04a91754, (guint32) 0x04a91755, (guint32) 0x04a91757, (guint32) 0x04a91758, (guint32) 0x04a91759, (guint32) 0x04a9175B, (guint32) 0x04a9175C, (guint32) 0x04a9175D, (guint32) 0x04a9175E, (guint32) 0x04a9175A, (guint32) 0x04a91763, (guint32) 0x04a9175F, (guint32) 0x04a91765, (guint32) 0x04a91760, (guint32) 0x04a91761, (guint32) 0x04a91762, (guint32) 0x04a91764, (guint32) 0x04a91766, (guint32) 0x04a91767, (guint32) 0x04a91768, (guint32) 0x04a91769, (guint32) 0x04a9176a, (guint32) 0x04a9176b, (guint32) 0x04a9176c, (guint32) 0x04a9176d, (guint32) 0x04a9176e, (guint32) 0x04a9176f, (guint32) 0x04a91770, (guint32) 0x04a91771, (guint32) 0x04a91772, (guint32) 0x04a91774, (guint32) 0x04a91775, (guint32) 0x04a91776, (guint32) 0x04a91777, (guint32) 0x04a91778, (guint32) 0x04a91779, (guint32) 0x04a9177a, (guint32) 0x04a9177b, (guint32) 0x04a9177c, (guint32) 0x04a9177e, (guint32) 0x04a9177f, (guint32) 0x04a91780, (guint32) 0x04a91788, (guint32) 0x04a91787, (guint32) 0x04a91789, (guint32) 0x04a9178a, (guint32) 0x04a9178b, (guint32) 0x04a9178c, (guint32) 0x04a9178d, (guint32) 0x04a9178e, (guint32) 0x04a91792, (guint32) 0x04a91793, (guint32) 0x04a91794, (guint32) 0x04a91795, (guint32) 0x04a9179f, (guint32) 0x04a91800, (guint32) 0x04a91801, (guint32) 0x04a91802, (guint32) 0x04a9180b, (guint32) 0x04a9180c, (guint32) 0x04a9181e, (guint32) 0x04a9181d, (guint32) 0x04a91822, (guint32) 0x04a91825, (guint32) 0x04a91827, (guint32) 0x04a91828, (guint32) 0x04a9178f, (guint32) 0x04a91790, (guint32) 0x04a91820, (guint32) 0x04a91823, (guint32) 0x04a91824, (guint32) 0x04a9185c, (guint32) 0x04a91912, (guint32) 0x04a91913, (guint32) 0x04a91821, (guint32) 0x04a9183a, (guint32) 0x04a9183b, (guint32) 0x04a9183d, (guint32) 0x04a9183e, (guint32) 0x04a9183f, (guint32) 0x04a91840, (guint32) 0x04a91841, (guint32) 0x04a91842, (guint32) 0x04a91843, (guint32) 0x04a91844, (guint32) 0x04a91845, (guint32) 0x04a91846, (guint32) 0x04a91847, (guint32) 0x04a91854, (guint32) 0x04a91855, (guint32) 0x04a91856, (guint32) 0x04a91857, (guint32) 0x04a91858, (guint32) 0x04a91859, (guint32) 0x04a9185a, (guint32) 0x04a9185b, (guint32) 0x04a9185d, (guint32) 0x04a9185e, (guint32) 0x04a91863, (guint32) 0x04a91865, (guint32) 0x04a91866, (guint32) 0x04a91869, (guint32) 0x04a91873, (guint32) 0x04a9188b, (guint32) 0x04a9188c, (guint32) 0x04a9188d, (guint32) 0x04a9188e, (guint32) 0x04a9188f, (guint32) 0x04a91890, (guint32) 0x04a91891, (guint32) 0x04a91892, (guint32) 0x04a91893, (guint32) 0x04a91894, (guint32) 0x04a918a2, (guint32) 0x04a918a3, (guint32) 0x04a9261f, (guint32) 0x04a9262f, (guint32) 0x04a92630, (guint32) 0x04a92635, (guint32) 0x04a9263c, (guint32) 0x04a9263d, (guint32) 0x04a9263e, (guint32) 0x04a9263f, (guint32) 0x04a9264c, (guint32) 0x04a9264d, (guint32) 0x04a9265d, (guint32) 0x04a9265e, (guint32) 0x04a9265f, (guint32) 0x04a92660, (guint32) 0x04a926e6, (guint32) 0x04a91706, (guint32) 0x04a91708, (guint32) 0x04a91707, (guint32) 0x04a9170d, (guint32) 0x04a9170e, (guint32) 0x04a91713, (guint32) 0x04a9171a, (guint32) 0x04a9171b, (guint32) 0x04a91726, (guint32) 0x04a91901, (guint32) 0x04a9172d, (guint32) 0x04a91740, (guint32) 0x04a91908, (guint32) 0x04a9174b, (guint32) 0x04a91756, (guint32) 0x04a9190d};
static const guint32 SIMPLE_SCAN_samsung_devices[94] = {(guint32) 0x04e83425, (guint32) 0x04e8341c, (guint32) 0x04e8342a, (guint32) 0x04e8343d, (guint32) 0x04e83456, (guint32) 0x04e8345a, (guint32) 0x04e83427, (guint32) 0x04e8343a, (guint32) 0x04e83428, (guint32) 0x04e8343b, (guint32) 0x04e83455, (guint32) 0x04e83421, (guint32) 0x04e83439, (guint32) 0x04e83444, (guint32) 0x04e8343f, (guint32) 0x04e8344e, (guint32) 0x04e83431, (guint32) 0x04e8345c, (guint32) 0x04e8344d, (guint32) 0x04e83462, (guint32) 0x04e83464, (guint32) 0x04e83461, (guint32) 0x04e83460, (guint32) 0x04e8340e, (guint32) 0x04e83435, (guint32) 0x04e8340f, (guint32) 0x04e83441, (guint32) 0x04e8344f, (guint32) 0x04e83413, (guint32) 0x04e8341b, (guint32) 0x04e8342e, (guint32) 0x04e83426, (guint32) 0x04e8342b, (guint32) 0x04e83433, (guint32) 0x04e83440, (guint32) 0x04e83434, (guint32) 0x04e8345b, (guint32) 0x04e83457, (guint32) 0x04e8341f, (guint32) 0x04e83453, (guint32) 0x04e8344b, (guint32) 0x04e83409, (guint32) 0x04e83412, (guint32) 0x04e83419, (guint32) 0x04e8342c, (guint32) 0x04e8343c, (guint32) 0x04e83432, (guint32) 0x04e8342d, (guint32) 0x04e83430, (guint32) 0x04e8342f, (guint32) 0x04e83446, (guint32) 0x04e8341a, (guint32) 0x04e83437, (guint32) 0x04e83442, (guint32) 0x04e83466, (guint32) 0x04e8340d, (guint32) 0x04e8341d, (guint32) 0x04e83420, (guint32) 0x04e83429, (guint32) 0x04e83443, (guint32) 0x04e83438, (guint32) 0x04e8344c, (guint32) 0x04e8345d, (guint32) 0x04e83463, (guint32) 0x04e83465, (guint32) 0x04e83450, (guint32) 0x04e83468, (guint32) 0x04e83469, (guint32) 0x04e83467, (guint32) 0x04e8346b, (guint32) 0x04e8346a, (guint32) 0x04e8346e, (guint32) 0x04e83471, (guint32) 0x04e83472, (guint32) 0x04e8347d, (guint32) 0x04e8347c, (guint32) 0x04e8347e, (guint32) 0x04e83481, (guint32) 0x04e83482, (guint32) 0x04e83331, (guint32) 0x04e83332, (guint32) 0x04e83483, (guint32) 0x04e83484, (guint32) 0x04e83485, (guint32) 0x04e83478, (guint32) 0x04e83325, (guint32) 0x04e83327, (guint32) 0x04e8346f, (guint32) 0x04e83477, (guint32) 0x04e83324, (guint32) 0x04e83326, (guint32) 0x04e83486, (guint32) 0x04e83487, (guint32) 0x04e83489};
static const guint32 SIMPLE_SCAN_smfp_devices[5] = {(guint32) 0x03F0AA2A, (guint32) 0x03F0CE2A, (guint32) 0x03F0C02A, (guint32) 0x03F0EB2A, (guint32) 0x03F0F22A};
static const guint32 SIMPLE_SCAN_hpaio_devices[680] = {(guint32) 0x04f92311, (guint32) 0x04f99711, (guint32) 0x04f91311, (guint32) 0x04f91011, (guint32) 0x04f90f11, (guint32) 0x04f91911, (guint32) 0x04f90011, (guint32) 0x04f90111, (guint32) 0x04f90611, (guint32) 0x04f90511, (guint32) 0x04f90811, (guint32) 0x04f90711, (guint32) 0x04f90211, (guint32) 0x04f90311, (guint32) 0x04f90411, (guint32) 0x04f9062a, (guint32) 0x04f94912, (guint32) 0x04f99911, (guint32) 0x04f93802, (guint32) 0x04f97a11, (guint32) 0x04f98311, (guint32) 0x04f97b11, (guint32) 0x04f9a711, (guint32) 0x04f98d11, (guint32) 0x04f98a11, (guint32) 0x04f9bb11, (guint32) 0x04f9222a, (guint32) 0x04f9322a, (guint32) 0x04f93902, (guint32) 0x04f91002, (guint32) 0x04f9242a, (guint32) 0x04f9332a, (guint32) 0x04f9122a, (guint32) 0x04f90c2a, (guint32) 0x04f9132a, (guint32) 0x04f92c2a, (guint32) 0x04f97e11, (guint32) 0x04f97811, (guint32) 0x04f98e11, (guint32) 0x04f92d2a, (guint32) 0x04f93502, (guint32) 0x04f91102, (guint32) 0x04f96112, (guint32) 0x04f96212, (guint32) 0x04f95511, (guint32) 0x04f90f2a, (guint32) 0x04f9082a, (guint32) 0x04f97311, (guint32) 0x04f97c11, (guint32) 0x04f97d11, (guint32) 0x04f91d02, (guint32) 0x04f91202, (guint32) 0x04f91e02, (guint32) 0x04f91602, (guint32) 0x04f91302, (guint32) 0x04f91702, (guint32) 0x04f9152a, (guint32) 0x04f9142a, (guint32) 0x04f99611, (guint32) 0x04f91502, (guint32) 0x04f91902, (guint32) 0x04f91f02, (guint32) 0x04f90512, (guint32) 0x04f9aa11, (guint32) 0x04f9a311, (guint32) 0x04f91312, (guint32) 0x04f91802, (guint32) 0x04f92812, (guint32) 0x04f9bf11, (guint32) 0x04f9c011, (guint32) 0x04f9342a, (guint32) 0x04f99e17, (guint32) 0x04f99f17, (guint32) 0x04f9252a, (guint32) 0x04f9a417, (guint32) 0x04f91a02, (guint32) 0x04f99e11, (guint32) 0x04f99011, (guint32) 0x04f92602, (guint32) 0x04f9272a, (guint32) 0x04f92b02, (guint32) 0x04f91812, (guint32) 0x04f9b211, (guint32) 0x04f9352a, (guint32) 0x04f92b2a, (guint32) 0x04f9362a, (guint32) 0x04f9a517, (guint32) 0x04f91b02, (guint32) 0x04f92702, (guint32) 0x04f92c02, (guint32) 0x04f9282a, (guint32) 0x04f92104, (guint32) 0x04f9432a, (guint32) 0x04f92004, (guint32) 0x04f91a2a, (guint32) 0x04f92304, (guint32) 0x04f91b2a, (guint32) 0x04f9442a, (guint32) 0x04f98904, (guint32) 0x04f9a617, (guint32) 0x04f99a17, (guint32) 0x04f9312a, (guint32) 0x04f9452a, (guint32) 0x04f91c02, (guint32) 0x04f91811, (guint32) 0x04f99d17, (guint32) 0x04f92804, (guint32) 0x04f92904, (guint32) 0x04f91511, (guint32) 0x04f91411, (guint32) 0x04f9372a, (guint32) 0x04f90d14, (guint32) 0x04f91611, (guint32) 0x04f91711, (guint32) 0x04f90f14, (guint32) 0x04f91f2a, (guint32) 0x04f90304, (guint32) 0x04f90204, (guint32) 0x04f90804, (guint32) 0x04f92902, (guint32) 0x04f90704, (guint32) 0x04f91e2a, (guint32) 0x04f90404, (guint32) 0x04f90604, (guint32) 0x04f90904, (guint32) 0x04f91512, (guint32) 0x04f91c2a, (guint32) 0x04f90104, (guint32) 0x04f91d2a, (guint32) 0x04f90004, (guint32) 0x04f92604, (guint32) 0x04f92704, (guint32) 0x04f91804, (guint32) 0x04f91504, (guint32) 0x04f91f11, (guint32) 0x04f91204, (guint32) 0x04f91604, (guint32) 0x04f91704, (guint32) 0x04f91104, (guint32) 0x04f91e11, (guint32) 0x04f91304, (guint32) 0x04f91404, (guint32) 0x04f93104, (guint32) 0x04f91004, (guint32) 0x04f93004, (guint32) 0x04f93304, (guint32) 0x04f95004, (guint32) 0x04f92e11, (guint32) 0x04f90517, (guint32) 0x04f98811, (guint32) 0x04f91712, (guint32) 0x04f91317, (guint32) 0x04f94117, (guint32) 0x04f93217, (guint32) 0x04f93e17, (guint32) 0x04f90c17, (guint32) 0x04f9b511, (guint32) 0x04f94217, (guint32) 0x04f94317, (guint32) 0x04f92b17, (guint32) 0x04f93017, (guint32) 0x04f92d17, (guint32) 0x04f92c17, (guint32) 0x04f9112a, (guint32) 0x04f90b2a, (guint32) 0x04f98911, (guint32) 0x04f97c04, (guint32) 0x04f90912, (guint32) 0x04f93011, (guint32) 0x04f9032a, (guint32) 0x04f9002a, (guint32) 0x04f9102a, (guint32) 0x04f93402, (guint32) 0x04f95617, (guint32) 0x04f95717, (guint32) 0x04f9042a, (guint32) 0x04f90f17, (guint32) 0x04f94004, (guint32) 0x04f91e17, (guint32) 0x04f90317, (guint32) 0x04f90f12, (guint32) 0x04f92f11, (guint32) 0x04f9052a, (guint32) 0x04f94717, (guint32) 0x04f93202, (guint32) 0x04f90e2a, (guint32) 0x04f9262a, (guint32) 0x04f93302, (guint32) 0x04f90417, (guint32) 0x04f90212, (guint32) 0x04f91412, (guint32) 0x04f91017, (guint32) 0x04f97804, (guint32) 0x04f93b11, (guint32) 0x04f91117, (guint32) 0x04f93f11, (guint32) 0x04f94f17, (guint32) 0x04f94e17, (guint32) 0x04f93602, (guint32) 0x04f95817, (guint32) 0x04f91d17, (guint32) 0x04f93c11, (guint32) 0x04f97904, (guint32) 0x04f94d11, (guint32) 0x04f9072a, (guint32) 0x04f94c11, (guint32) 0x04f9c111, (guint32) 0x04f94417, (guint32) 0x04f95017, (guint32) 0x04f9022a, (guint32) 0x04f9012a, (guint32) 0x04f9092a, (guint32) 0x04f97f11, (guint32) 0x04f94811, (guint32) 0x04f93a17, (guint32) 0x04f90a2a, (guint32) 0x04f90312, (guint32) 0x04f99411, (guint32) 0x04f99b11, (guint32) 0x04f93917, (guint32) 0x04f94a17, (guint32) 0x04f93817, (guint32) 0x04f9b911, (guint32) 0x04f95417, (guint32) 0x04f95217, (guint32) 0x04f95317, (guint32) 0x04f95d17, (guint32) 0x04f98711, (guint32) 0x04f95c17, (guint32) 0x04f99a11, (guint32) 0x04f92811, (guint32) 0x04f97d04, (guint32) 0x04f92a11, (guint32) 0x04f92b11, (guint32) 0x04f90217, (guint32) 0x04f92911, (guint32) 0x04f92404, (guint32) 0x04f93511, (guint32) 0x04f90812, (guint32) 0x04f9c302, (guint32) 0x04f90b17, (guint32) 0x04f95917, (guint32) 0x04f95a17, (guint32) 0x04f95b17, (guint32) 0x04f94911, (guint32) 0x04f93611, (guint32) 0x04f97611, (guint32) 0x04f97a04, (guint32) 0x04f92517, (guint32) 0x04f92917, (guint32) 0x04f92a17, (guint32) 0x04f91e04, (guint32) 0x04f90717, (guint32) 0x04f92504, (guint32) 0x04f93711, (guint32) 0x04f9ac11, (guint32) 0x04f9be11, (guint32) 0x04f9c211, (guint32) 0x04f91c17, (guint32) 0x04f94e11, (guint32) 0x04f92e17, (guint32) 0x04f94511, (guint32) 0x04f98011, (guint32) 0x04f90412, (guint32) 0x04f93617, (guint32) 0x04f92f17, (guint32) 0x04f93117, (guint32) 0x04f9c911, (guint32) 0x04f9ca11, (guint32) 0x04f94611, (guint32) 0x04f93c17, (guint32) 0x04f93717, (guint32) 0x04f92617, (guint32) 0x04f91112, (guint32) 0x04f90612, (guint32) 0x04f96717, (guint32) 0x04f99511, (guint32) 0x04f97617, (guint32) 0x04f97317, (guint32) 0x04f98d17, (guint32) 0x04f91617, (guint32) 0x04f97a17, (guint32) 0x04f97517, (guint32) 0x04f99311, (guint32) 0x04f9a011, (guint32) 0x04f93317, (guint32) 0x04f93417, (guint32) 0x04f9a211, (guint32) 0x04f95611, (guint32) 0x04f95011, (guint32) 0x04f95111, (guint32) 0x04f90117, (guint32) 0x04f90817, (guint32) 0x04f95211, (guint32) 0x04f97004, (guint32) 0x04f90917, (guint32) 0x04f91917, (guint32) 0x04f93517, (guint32) 0x04f97104, (guint32) 0x04f91517, (guint32) 0x04f93112, (guint32) 0x04f97817, (guint32) 0x04f9ad11, (guint32) 0x04f9b011, (guint32) 0x04f98517, (guint32) 0x04f98a17, (guint32) 0x04f9c711, (guint32) 0x04f96117, (guint32) 0x04f96917, (guint32) 0x04f96812, (guint32) 0x04f96d12, (guint32) 0x04f97204, (guint32) 0x04f90a17, (guint32) 0x04f97404, (guint32) 0x04f96817, (guint32) 0x04f91b04, (guint32) 0x04f91a04, (guint32) 0x04f91c04, (guint32) 0x04f91904, (guint32) 0x04f97504, (guint32) 0x04f97604, (guint32) 0x04f90714, (guint32) 0x04f99c11, (guint32) 0x04f97b17, (guint32) 0x04f98817, (guint32) 0x04f95711, (guint32) 0x04f97704, (guint32) 0x04f97e04, (guint32) 0x04f93111, (guint32) 0x04f96017, (guint32) 0x04f93d11, (guint32) 0x04f95c11, (guint32) 0x04f97b04, (guint32) 0x04f96a17, (guint32) 0x04f92417, (guint32) 0x04f95411, (guint32) 0x04f91f04, (guint32) 0x04f96711, (guint32) 0x04f97417, (guint32) 0x04f99717, (guint32) 0x04f92317, (guint32) 0x04f96611, (guint32) 0x04f96c11, (guint32) 0x04f99d11, (guint32) 0x04f97711, (guint32) 0x04f94712, (guint32) 0x04f98c11, (guint32) 0x04f95712, (guint32) 0x04f92a12, (guint32) 0x04f96b11, (guint32) 0x04f9c511, (guint32) 0x04f92e12, (guint32) 0x04f9c411, (guint32) 0x04f99917, (guint32) 0x04f99c17, (guint32) 0x04f97411, (guint32) 0x04f96c17, (guint32) 0x04f95812, (guint32) 0x04f96512, (guint32) 0x04f96612, (guint32) 0x04f96412, (guint32) 0x04f9c611, (guint32) 0x04f9c811, (guint32) 0x04f91a17, (guint32) 0x04f92b12, (guint32) 0x04f92c12, (guint32) 0x04f97511, (guint32) 0x04f96217, (guint32) 0x04f97d17, (guint32) 0x04f96317, (guint32) 0x04f97917, (guint32) 0x04f97217, (guint32) 0x04f9a117, (guint32) 0x04f9c802, (guint32) 0x04f95811, (guint32) 0x04f9c402, (guint32) 0x04f92411, (guint32) 0x04f95d11, (guint32) 0x04f96417, (guint32) 0x04f96617, (guint32) 0x04f98917, (guint32) 0x04f95117, (guint32) 0x04f97111, (guint32) 0x04f91f12, (guint32) 0x04f96811, (guint32) 0x04f92012, (guint32) 0x04f98604, (guint32) 0x04f96d11, (guint32) 0x04f93a11, (guint32) 0x04f93012, (guint32) 0x04f98211, (guint32) 0x04f97211, (guint32) 0x04f9a111, (guint32) 0x04f9b411, (guint32) 0x04f99b17, (guint32) 0x04f9b111, (guint32) 0x04f9b611, (guint32) 0x04f9c311, (guint32) 0x04f91f17, (guint32) 0x04f96004, (guint32) 0x04f94f11, (guint32) 0x04f9cc11, (guint32) 0x04f96104, (guint32) 0x04f95b11, (guint32) 0x04f98104, (guint32) 0x04f9cd11, (guint32) 0x04f9a004, (guint32) 0x04f98704, (guint32) 0x04f94312, (guint32) 0x04f94212, (guint32) 0x04f96f17, (guint32) 0x04f97c17, (guint32) 0x04f99517, (guint32) 0x04f95911, (guint32) 0x04f95e12, (guint32) 0x04f90b14, (guint32) 0x04f9c502, (guint32) 0x04f92d11, (guint32) 0x04f93404, (guint32) 0x04f94b11, (guint32) 0x04f91014, (guint32) 0x04f96a11, (guint32) 0x04f97312, (guint32) 0x04f97011, (guint32) 0x04f95311, (guint32) 0x04f93312, (guint32) 0x04f94412, (guint32) 0x04f95412, (guint32) 0x04f95512, (guint32) 0x04f94512, (guint32) 0x04f98204, (guint32) 0x04f9a511, (guint32) 0x04f9af11, (guint32) 0x04f9ba11, (guint32) 0x04f98504, (guint32) 0x04f95d12, (guint32) 0x04f95c12, (guint32) 0x04f98404, (guint32) 0x04f97412, (guint32) 0x04f97212, (guint32) 0x04f98804, (guint32) 0x04f94612, (guint32) 0x04f92611, (guint32) 0x04f95a11, (guint32) 0x04f92612, (guint32) 0x04f9c602, (guint32) 0x04f96012, (guint32) 0x04f96911, (guint32) 0x04f9b002, (guint32) 0x04f94111, (guint32) 0x04f96511, (guint32) 0x04f94211, (guint32) 0x04f92512, (guint32) 0x04f9c702, (guint32) 0x04f92002, (guint32) 0x04f94311, (guint32) 0x04f9b802, (guint32) 0x04f95e11, (guint32) 0x04f93412, (guint32) 0x04f92112, (guint32) 0x04f94812, (guint32) 0x04f96f11, (guint32) 0x04f9a611, (guint32) 0x04f9bc11, (guint32) 0x04f93e02, (guint32) 0x04f92212, (guint32) 0x04f9b202, (guint32) 0x04f96e12, (guint32) 0x04f9dc11, (guint32) 0x04f92312, (guint32) 0x04f9b402, (guint32) 0x04f9c002, (guint32) 0x04f9b602, (guint32) 0x04f9d011, (guint32) 0x04f95612, (guint32) 0x04f93612, (guint32) 0x04f9c102, (guint32) 0x04f9de11, (guint32) 0x04f97717, (guint32) 0x04f97117, (guint32) 0x04f95b12, (guint32) 0x04f96411, (guint32) 0x04f9ba02, (guint32) 0x04f9c202, (guint32) 0x04f9be02, (guint32) 0x04f9bb02, (guint32) 0x04f93812, (guint32) 0x04f94012, (guint32) 0x04f93912, (guint32) 0x04f9d102, (guint32) 0x04f95312, (guint32) 0x04f92712, (guint32) 0x04f95912, (guint32) 0x04f97112, (guint32) 0x04f97012, (guint32) 0x04f96f12, (guint32) 0x04f97712, (guint32) 0x04f97612, (guint32) 0x04f9bc02, (guint32) 0x04f9d002, (guint32) 0x04f98417, (guint32) 0x04f92017, (guint32) 0x04f92117, (guint32) 0x04f98317, (guint32) 0x04f99617, (guint32) 0x04f90d12, (guint32) 0x04f9bd02, (guint32) 0x04f92217, (guint32) 0x04f90b12, (guint32) 0x04f91212, (guint32) 0x04f93c2a, (guint32) 0x04f9382a, (guint32) 0x04f9582a, (guint32) 0x04f9552a, (guint32) 0x04f93e2a, (guint32) 0x04f93f2a, (guint32) 0x04f9e311, (guint32) 0x04f9e111, (guint32) 0x04f9df11, (guint32) 0x04f9e511, (guint32) 0x04f9e611, (guint32) 0x04f9d911, (guint32) 0x04f9d711, (guint32) 0x04f9ce11, (guint32) 0x04f9e811, (guint32) 0x04f9842a, (guint32) 0x04f9e211, (guint32) 0x04f9db11, (guint32) 0x04f9da11, (guint32) 0x04f9d811, (guint32) 0x04f9422a, (guint32) 0x04f9542a, (guint32) 0x04f9602a, (guint32) 0x04f9522a, (guint32) 0x04f95a2a, (guint32) 0x04f9402a, (guint32) 0x04f9412a, (guint32) 0x04f95305, (guint32) 0x04f93a2a, (guint32) 0x04f94a2a, (guint32) 0x04f9512a, (guint32) 0x04f9d611, (guint32) 0x04f9d311, (guint32) 0x04f9d211, (guint32) 0x04f9d111, (guint32) 0x04f9d511, (guint32) 0x04f9d411, (guint32) 0x04f9ed11, (guint32) 0x04f9ee11, (guint32) 0x04f9e711, (guint32) 0x04f97a12, (guint32) 0x04f96312, (guint32) 0x04f97b12, (guint32) 0x04f9652a, (guint32) 0x04f9832a, (guint32) 0x04f9822a, (guint32) 0x04f9fa11, (guint32) 0x04f9f911, (guint32) 0x04f97d12, (guint32) 0x04f9862a, (guint32) 0x04f9f511, (guint32) 0x04f91254, (guint32) 0x04f91154, (guint32) 0x04f91054, (guint32) 0x04f9e911, (guint32) 0x04f90d54, (guint32) 0x04f90c54, (guint32) 0x04f903f0, (guint32) 0x04f90e54, (guint32) 0x04f9802a, (guint32) 0x04f91554, (guint32) 0x04f90954, (guint32) 0x04f9f211, (guint32) 0x04f90154, (guint32) 0x04f90f54, (guint32) 0x04f95605, (guint32) 0x04f95705, (guint32) 0x04f95805, (guint32) 0x04f9612a, (guint32) 0x04f91654, (guint32) 0x04f91754, (guint32) 0x04f90853, (guint32) 0x04f90a54, (guint32) 0x04f9632a, (guint32) 0x04f9642a, (guint32) 0x04f9622a, (guint32) 0x04f90b53, (guint32) 0x04f9b22a, (guint32) 0x04f9b32a, (guint32) 0x04f9b12a, (guint32) 0x04f9b02a, (guint32) 0x04f96b2a, (guint32) 0x04f96c2a, (guint32) 0x04f9672a, (guint32) 0x04f9682a, (guint32) 0x04f9a32a, (guint32) 0x04f9a42a, (guint32) 0x04f9a52a, (guint32) 0x04f9a62a, (guint32) 0x04f9fe11, (guint32) 0x04f9eb11, (guint32) 0x04f9fc11, (guint32) 0x04f9f611, (guint32) 0x04f9932a, (guint32) 0x04f90753, (guint32) 0x04f90053, (guint32) 0x04f9b62a, (guint32) 0x04f9b72a, (guint32) 0x04f90e53, (guint32) 0x04f9b42a, (guint32) 0x04f9b52a, (guint32) 0x04f9ba2a, (guint32) 0x04f9b92a, (guint32) 0x04f9be2a, (guint32) 0x04f9bf2a, (guint32) 0x04f9ac2a, (guint32) 0x04f9af2a, (guint32) 0x04f9ad2a, (guint32) 0x04f9ae2a, (guint32) 0x04f9c92a, (guint32) 0x04f9c72a, (guint32) 0x04f90f53, (guint32) 0x04f91253, (guint32) 0x04f91053, (guint32) 0x04f91353, (guint32) 0x04f91453, (guint32) 0x04f9ef2a, (guint32) 0x04f9ee2a, (guint32) 0x04f9e92a, (guint32) 0x04f9ec2a, (guint32) 0x04f9ed2a, (guint32) 0x04f98411, (guint32) 0x04f92454, (guint32) 0x04f92354, (guint32) 0x04f92554, (guint32) 0x04f92654, (guint32) 0x04f92854, (guint32) 0x04f92754, (guint32) 0x04f92954, (guint32) 0x04f91c54, (guint32) 0x04f91b54, (guint32) 0x04f91a54, (guint32) 0x04f91954, (guint32) 0x04f9e32a, (guint32) 0x04f9e02a, (guint32) 0x04f9e22a, (guint32) 0x04f9e12a, (guint32) 0x04f9f42a, (guint32) 0x04f9f32a, (guint32) 0x04f9f02a, (guint32) 0x04f9f12a, (guint32) 0x04f92b54, (guint32) 0x04f92a54, (guint32) 0x04f92d54, (guint32) 0x04f9ca2a, (guint32) 0x04f9d22a, (guint32) 0x04f9cc2a, (guint32) 0x04f9d32a, (guint32) 0x04f99d2a, (guint32) 0x04f99e2a, (guint32) 0x04f9de2a, (guint32) 0x04f9c12a, (guint32) 0x04f9c22a, (guint32) 0x04f9df2a, (guint32) 0x04f9c32a, (guint32) 0x04f9c42a, (guint32) 0x04f9c62a, (guint32) 0x04f9c52a, (guint32) 0x04f99f2a, (guint32) 0x04f9a12a, (guint32) 0x04f9a22a, (guint32) 0x04f90c70, (guint32) 0x04f90a70, (guint32) 0x04f90970, (guint32) 0x04f90870, (guint32) 0x04f95a05, (guint32) 0x04f95e05, (guint32) 0x04f95c05, (guint32) 0x04f95b05, (guint32) 0x04f95d05};
static const guint32 SIMPLE_SCAN_epkowa_devices[201] = {(guint32) 0x04b80101, (guint32) 0x04b80102, (guint32) 0x04b80103, (guint32) 0x04b80104, (guint32) 0x04b80105, (guint32) 0x04b80106, (guint32) 0x04b80107, (guint32) 0x04b80108, (guint32) 0x04b80109, (guint32) 0x04b8010a, (guint32) 0x04b8010b, (guint32) 0x04b8010c, (guint32) 0x04b8010d, (guint32) 0x04b8010e, (guint32) 0x04b8010f, (guint32) 0x04b80110, (guint32) 0x04b80112, (guint32) 0x04b80114, (guint32) 0x04b80116, (guint32) 0x04b80118, (guint32) 0x04b80119, (guint32) 0x04b8011a, (guint32) 0x04b8011b, (guint32) 0x04b8011c, (guint32) 0x04b8011d, (guint32) 0x04b8011e, (guint32) 0x04b8011f, (guint32) 0x04b80120, (guint32) 0x04b80121, (guint32) 0x04b80122, (guint32) 0x04b80126, (guint32) 0x04b80128, (guint32) 0x04b80129, (guint32) 0x04b8012a, (guint32) 0x04b8012b, (guint32) 0x04b8012c, (guint32) 0x04b8012d, (guint32) 0x04b8012e, (guint32) 0x04b8012f, (guint32) 0x04b80130, (guint32) 0x04b80131, (guint32) 0x04b80133, (guint32) 0x04b80135, (guint32) 0x04b80136, (guint32) 0x04b80137, (guint32) 0x04b80138, (guint32) 0x04b8013a, (guint32) 0x04b8013b, (guint32) 0x04b8013c, (guint32) 0x04b8013d, (guint32) 0x04b80142, (guint32) 0x04b80143, (guint32) 0x04b80144, (guint32) 0x04b80147, (guint32) 0x04b8014a, (guint32) 0x04b8014b, (guint32) 0x04b80151, (guint32) 0x04b80153, (guint32) 0x04b80801, (guint32) 0x04b80802, (guint32) 0x04b80805, (guint32) 0x04b80806, (guint32) 0x04b80807, (guint32) 0x04b80808, (guint32) 0x04b8080a, (guint32) 0x04b8080c, (guint32) 0x04b8080d, (guint32) 0x04b8080e, (guint32) 0x04b8080f, (guint32) 0x04b80810, (guint32) 0x04b80811, (guint32) 0x04b80813, (guint32) 0x04b80814, (guint32) 0x04b80815, (guint32) 0x04b80817, (guint32) 0x04b80818, (guint32) 0x04b80819, (guint32) 0x04b8081a, (guint32) 0x04b8081c, (guint32) 0x04b8081d, (guint32) 0x04b8081f, (guint32) 0x04b80820, (guint32) 0x04b80821, (guint32) 0x04b80827, (guint32) 0x04b80828, (guint32) 0x04b80829, (guint32) 0x04b8082a, (guint32) 0x04b8082b, (guint32) 0x04b8082e, (guint32) 0x04b8082f, (guint32) 0x04b80830, (guint32) 0x04b80831, (guint32) 0x04b80833, (guint32) 0x04b80834, (guint32) 0x04b80835, (guint32) 0x04b80836, (guint32) 0x04b80837, (guint32) 0x04b80838, (guint32) 0x04b80839, (guint32) 0x04b8083a, (guint32) 0x04b8083c, (guint32) 0x04b8083f, (guint32) 0x04b80841, (guint32) 0x04b80843, (guint32) 0x04b80844, (guint32) 0x04b80846, (guint32) 0x04b80847, (guint32) 0x04b80848, (guint32) 0x04b80849, (guint32) 0x04b8084a, (guint32) 0x04b8084c, (guint32) 0x04b8084d, (guint32) 0x04b8084f, (guint32) 0x04b80850, (guint32) 0x04b80851, (guint32) 0x04b80852, (guint32) 0x04b80853, (guint32) 0x04b80854, (guint32) 0x04b80855, (guint32) 0x04b80856, (guint32) 0x04b8085c, (guint32) 0x04b8085d, (guint32) 0x04b8085e, (guint32) 0x04b8085f, (guint32) 0x04b80860, (guint32) 0x04b80861, (guint32) 0x04b80862, (guint32) 0x04b80863, (guint32) 0x04b80864, (guint32) 0x04b80865, (guint32) 0x04b80866, (guint32) 0x04b80869, (guint32) 0x04b8086a, (guint32) 0x04b80870, (guint32) 0x04b80871, (guint32) 0x04b80872, (guint32) 0x04b80873, (guint32) 0x04b80878, (guint32) 0x04b80879, (guint32) 0x04b8087b, (guint32) 0x04b8087c, (guint32) 0x04b8087d, (guint32) 0x04b8087e, (guint32) 0x04b8087f, (guint32) 0x04b80880, (guint32) 0x04b80881, (guint32) 0x04b80883, (guint32) 0x04b80884, (guint32) 0x04b80885, (guint32) 0x04b8088f, (guint32) 0x04b80890, (guint32) 0x04b80891, (guint32) 0x04b80892, (guint32) 0x04b80893, (guint32) 0x04b80894, (guint32) 0x04b80895, (guint32) 0x04b80896, (guint32) 0x04b80897, (guint32) 0x04b80898, (guint32) 0x04b80899, (guint32) 0x04b8089a, (guint32) 0x04b8089b, (guint32) 0x04b8089c, (guint32) 0x04b8089d, (guint32) 0x04b8089e, (guint32) 0x04b8089f, (guint32) 0x04b808a0, (guint32) 0x04b808a1, (guint32) 0x04b808a5, (guint32) 0x04b808a6, (guint32) 0x04b808a8, (guint32) 0x04b808a9, (guint32) 0x04b808aa, (guint32) 0x04b808ab, (guint32) 0x04b808ac, (guint32) 0x04b808ad, (guint32) 0x04b808ae, (guint32) 0x04b808af, (guint32) 0x04b808b0, (guint32) 0x04b808b3, (guint32) 0x04b808b4, (guint32) 0x04b808b5, (guint32) 0x04b808b6, (guint32) 0x04b808b7, (guint32) 0x04b808b8, (guint32) 0x04b808b9, (guint32) 0x04b808bd, (guint32) 0x04b808be, (guint32) 0x04b808bf, (guint32) 0x04b808c0, (guint32) 0x04b808c1, (guint32) 0x04b808c3, (guint32) 0x04b808c4, (guint32) 0x04b808c5, (guint32) 0x04b808c6, (guint32) 0x04b808c7, (guint32) 0x04b808c8, (guint32) 0x04b808c9, (guint32) 0x04b808ca, (guint32) 0x04b808cd, (guint32) 0x04b808d0};
static const guint32 SIMPLE_SCAN_lexmark_nscan_devices[54] = {(guint32) 0x043d0279, (guint32) 0x043d027a, (guint32) 0x043d01D6, (guint32) 0x043d01D7, (guint32) 0x043d01D8, (guint32) 0x043d01DC, (guint32) 0x043d01DE, (guint32) 0x043d01E0, (guint32) 0x043d01FA, (guint32) 0x043d01FB, (guint32) 0x043d01FC, (guint32) 0x043d01FD, (guint32) 0x043d01FE, (guint32) 0x043d01FF, (guint32) 0x043d01F4, (guint32) 0x043d0120, (guint32) 0x043d0121, (guint32) 0x043d0128, (guint32) 0x043d014F, (guint32) 0x043d0149, (guint32) 0x043d0152, (guint32) 0x043d0168, (guint32) 0x043d0169, (guint32) 0x043d016A, (guint32) 0x043d012D, (guint32) 0x043d01C4, (guint32) 0x043d01C5, (guint32) 0x043d01C6, (guint32) 0x043d01CF, (guint32) 0x043d01D0, (guint32) 0x043d01D1, (guint32) 0x043d01DB, (guint32) 0x043d01ED, (guint32) 0x043d01F1, (guint32) 0x043d01F5, (guint32) 0x043d0222, (guint32) 0x043d0223, (guint32) 0x043d0227, (guint32) 0x043d0228, (guint32) 0x043d022A, (guint32) 0x043d022B, (guint32) 0x043d022F, (guint32) 0x043d0230, (guint32) 0x043d0231, (guint32) 0x043d0234, (guint32) 0x043d0235, (guint32) 0x043d0244, (guint32) 0x043d0245, (guint32) 0x043d0246, (guint32) 0x043d0247, (guint32) 0x043d0248, (guint32) 0x043d024A, (guint32) 0x043d024E, (guint32) 0x043d024F};

static inline gpointer
simple_scan_get_instance_private (SimpleScan* self)
{
	return G_STRUCT_MEMBER_P (self, SimpleScan_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SimpleScan*
simple_scan_construct (GType object_type,
                       ScanDevice* device)
{
	SimpleScan * self = NULL;
	ScanDevice* _tmp0_;
	self = (SimpleScan*) g_object_new (object_type, "application-id", "org.gnome.SimpleScan", "resource-base-path", "/org/gnome/SimpleScan", NULL);
	g_object_set ((GtkApplication*) self, "register-session", TRUE, NULL);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (self->priv->default_device);
	self->priv->default_device = _tmp0_;
	return self;
}

SimpleScan*
simple_scan_new (ScanDevice* device)
{
	return simple_scan_construct (TYPE_SIMPLE_SCAN, device);
}

static void
_simple_scan_scan_cb_app_window_start_scan (AppWindow* _sender,
                                            const gchar* device,
                                            ScanOptions* options,
                                            gpointer self)
{
	simple_scan_scan_cb ((SimpleScan*) self, _sender, device, options);
}

static void
_simple_scan_cancel_cb_app_window_stop_scan (AppWindow* _sender,
                                             gpointer self)
{
	simple_scan_cancel_cb ((SimpleScan*) self, _sender);
}

static void
_simple_scan_redetect_cb_app_window_redetect (AppWindow* _sender,
                                              gpointer self)
{
	simple_scan_redetect_cb ((SimpleScan*) self, _sender);
}

static void
_simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender,
                                                            GList* devices,
                                                            gpointer self)
{
	simple_scan_update_scan_devices_cb ((SimpleScan*) self, _sender, devices);
}

static void
_simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender,
                                                         const gchar* resource,
                                                         gpointer self)
{
	simple_scan_authorize_cb ((SimpleScan*) self, _sender, resource);
}

static void
_simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender,
                                                      gpointer self)
{
	simple_scan_scanner_new_page_cb ((SimpleScan*) self, _sender);
}

static void
_simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender,
                                                         ScanPageInfo* info,
                                                         gpointer self)
{
	simple_scan_scanner_page_info_cb ((SimpleScan*) self, _sender, info);
}

static void
_simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender,
                                               ScanLine* line,
                                               gpointer self)
{
	simple_scan_scanner_line_cb ((SimpleScan*) self, _sender, line);
}

static void
_simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender,
                                                     gpointer self)
{
	simple_scan_scanner_page_done_cb ((SimpleScan*) self, _sender);
}

static void
_simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender,
                                                             gpointer self)
{
	simple_scan_scanner_document_done_cb ((SimpleScan*) self, _sender);
}

static void
_simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender,
                                                    gint error_code,
                                                    const gchar* error_string,
                                                    gpointer self)
{
	simple_scan_scanner_failed_cb ((SimpleScan*) self, _sender, error_code, error_string);
}

static void
_simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender,
                                                                   gpointer self)
{
	simple_scan_scanner_scanning_changed_cb ((SimpleScan*) self, _sender);
}

static void
___lambda48_ (SimpleScan* self)
{
	Scanner* _tmp0_;
	_tmp0_ = self->priv->scanner;
	scanner_redetect (_tmp0_);
}

static void
____lambda48__g_usb_context_device_added (GUsbContext* _sender,
                                          GUsbDevice* device,
                                          gpointer self)
{
	___lambda48_ ((SimpleScan*) self);
}

static void
___lambda49_ (SimpleScan* self)
{
	Scanner* _tmp0_;
	_tmp0_ = self->priv->scanner;
	scanner_redetect (_tmp0_);
}

static void
____lambda49__g_usb_context_device_removed (GUsbContext* _sender,
                                            GUsbDevice* device,
                                            gpointer self)
{
	___lambda49_ ((SimpleScan*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
simple_scan_real_startup (GApplication* base)
{
	SimpleScan * self;
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	Book* _tmp2_;
	Book* _tmp3_;
	Book* _tmp4_;
	AppWindow* _tmp5_;
	AppWindow* _tmp6_;
	AppWindow* _tmp7_;
	Scanner* _tmp8_;
	Scanner* _tmp9_;
	Scanner* _tmp10_;
	Scanner* _tmp11_;
	Scanner* _tmp12_;
	Scanner* _tmp13_;
	Scanner* _tmp14_;
	Scanner* _tmp15_;
	Scanner* _tmp16_;
	Scanner* _tmp17_;
	ScanDevice* _tmp25_;
	AppWindow* _tmp33_;
	Scanner* _tmp34_;
	GError* _inner_error0_ = NULL;
	self = (SimpleScan*) base;
	G_APPLICATION_CLASS (simple_scan_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = app_window_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->app);
	self->priv->app = _tmp0_;
	_tmp1_ = self->priv->app;
	_tmp2_ = app_window_get_book (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->book);
	self->priv->book = _tmp4_;
	_tmp5_ = self->priv->app;
	g_signal_connect_object (_tmp5_, "start-scan", (GCallback) _simple_scan_scan_cb_app_window_start_scan, self, 0);
	_tmp6_ = self->priv->app;
	g_signal_connect_object (_tmp6_, "stop-scan", (GCallback) _simple_scan_cancel_cb_app_window_stop_scan, self, 0);
	_tmp7_ = self->priv->app;
	g_signal_connect_object (_tmp7_, "redetect", (GCallback) _simple_scan_redetect_cb_app_window_redetect, self, 0);
	_tmp8_ = scanner_get_instance ();
	_g_object_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp8_;
	_tmp9_ = self->priv->scanner;
	g_signal_connect_object (_tmp9_, "update-devices", (GCallback) _simple_scan_update_scan_devices_cb_scanner_update_devices, self, 0);
	_tmp10_ = self->priv->scanner;
	g_signal_connect_object (_tmp10_, "request-authorization", (GCallback) _simple_scan_authorize_cb_scanner_request_authorization, self, 0);
	_tmp11_ = self->priv->scanner;
	g_signal_connect_object (_tmp11_, "expect-page", (GCallback) _simple_scan_scanner_new_page_cb_scanner_expect_page, self, 0);
	_tmp12_ = self->priv->scanner;
	g_signal_connect_object (_tmp12_, "got-page-info", (GCallback) _simple_scan_scanner_page_info_cb_scanner_got_page_info, self, 0);
	_tmp13_ = self->priv->scanner;
	g_signal_connect_object (_tmp13_, "got-line", (GCallback) _simple_scan_scanner_line_cb_scanner_got_line, self, 0);
	_tmp14_ = self->priv->scanner;
	g_signal_connect_object (_tmp14_, "page-done", (GCallback) _simple_scan_scanner_page_done_cb_scanner_page_done, self, 0);
	_tmp15_ = self->priv->scanner;
	g_signal_connect_object (_tmp15_, "document-done", (GCallback) _simple_scan_scanner_document_done_cb_scanner_document_done, self, 0);
	_tmp16_ = self->priv->scanner;
	g_signal_connect_object (_tmp16_, "scan-failed", (GCallback) _simple_scan_scanner_failed_cb_scanner_scan_failed, self, 0);
	_tmp17_ = self->priv->scanner;
	g_signal_connect_object (_tmp17_, "scanning-changed", (GCallback) _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed, self, 0);
	{
		GUsbContext* _tmp18_ = NULL;
		GUsbContext* _tmp19_;
		GUsbContext* _tmp20_;
		GUsbContext* _tmp21_;
		GUsbContext* _tmp22_;
		_tmp19_ = g_usb_context_new (&_inner_error0_);
		_tmp18_ = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp20_ = _tmp18_;
		_tmp18_ = NULL;
		_g_object_unref0 (self->priv->usb_context);
		self->priv->usb_context = _tmp20_;
		_tmp21_ = self->priv->usb_context;
		g_signal_connect_object (_tmp21_, "device-added", (GCallback) ____lambda48__g_usb_context_device_added, self, 0);
		_tmp22_ = self->priv->usb_context;
		g_signal_connect_object (_tmp22_, "device-removed", (GCallback) ____lambda49__g_usb_context_device_removed, self, 0);
		_g_object_unref0 (_tmp18_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("simple-scan.vala:82: Failed to create USB context: %s\n", _tmp24_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp25_ = self->priv->default_device;
	if (_tmp25_ != NULL) {
		GList* device_list = NULL;
		ScanDevice* _tmp26_;
		ScanDevice* _tmp27_;
		AppWindow* _tmp28_;
		GList* _tmp29_;
		AppWindow* _tmp30_;
		ScanDevice* _tmp31_;
		const gchar* _tmp32_;
		device_list = NULL;
		_tmp26_ = self->priv->default_device;
		_tmp27_ = _g_object_ref0 (_tmp26_);
		device_list = g_list_append (device_list, _tmp27_);
		_tmp28_ = self->priv->app;
		_tmp29_ = device_list;
		app_window_set_scan_devices (_tmp28_, _tmp29_, NULL);
		_tmp30_ = self->priv->app;
		_tmp31_ = self->priv->default_device;
		_tmp32_ = _tmp31_->name;
		app_window_set_selected_device (_tmp30_, _tmp32_);
		(device_list == NULL) ? NULL : (device_list = (_g_list_free__g_object_unref0_ (device_list), NULL));
	}
	_tmp33_ = self->priv->app;
	app_window_start (_tmp33_);
	_tmp34_ = self->priv->scanner;
	scanner_start (_tmp34_);
}

static void
simple_scan_real_activate (GApplication* base)
{
	SimpleScan * self;
	AppWindow* _tmp0_;
	self = (SimpleScan*) base;
	G_APPLICATION_CLASS (simple_scan_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_tmp0_ = self->priv->app;
	gtk_window_present ((GtkWindow*) _tmp0_);
}

static void
simple_scan_real_shutdown (GApplication* base)
{
	SimpleScan * self;
	Scanner* _tmp0_;
	self = (SimpleScan*) base;
	G_APPLICATION_CLASS (simple_scan_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	_g_object_unref0 (self->priv->book);
	self->priv->book = NULL;
	_g_object_unref0 (self->priv->app);
	self->priv->app = NULL;
	_g_object_unref0 (self->priv->usb_context);
	self->priv->usb_context = NULL;
	_tmp0_ = self->priv->scanner;
	scanner_free (_tmp0_);
}

static void
simple_scan_update_scan_devices_cb (SimpleScan* self,
                                    Scanner* scanner,
                                    GList* devices)
{
	GList* devices_copy = NULL;
	GList* _tmp0_;
	ScanDevice* _tmp1_;
	GList* _tmp10_;
	gchar* missing_driver = NULL;
	AppWindow* _tmp12_;
	GList* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = g_list_copy_deep (devices, (GCopyFunc) g_object_ref, NULL);
	devices_copy = _tmp0_;
	_tmp1_ = self->priv->default_device;
	if (_tmp1_ != NULL) {
		gboolean default_in_list = FALSE;
		GList* _tmp2_;
		default_in_list = FALSE;
		_tmp2_ = devices_copy;
		{
			GList* device_collection = NULL;
			GList* device_it = NULL;
			device_collection = _tmp2_;
			for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
				ScanDevice* _tmp3_;
				ScanDevice* device = NULL;
				_tmp3_ = _g_object_ref0 ((ScanDevice*) device_it->data);
				device = _tmp3_;
				{
					ScanDevice* _tmp4_;
					const gchar* _tmp5_;
					ScanDevice* _tmp6_;
					const gchar* _tmp7_;
					_tmp4_ = device;
					_tmp5_ = _tmp4_->name;
					_tmp6_ = self->priv->default_device;
					_tmp7_ = _tmp6_->name;
					if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
						default_in_list = TRUE;
						_g_object_unref0 (device);
						break;
					}
					_g_object_unref0 (device);
				}
			}
		}
		if (!default_in_list) {
			ScanDevice* _tmp8_;
			ScanDevice* _tmp9_;
			_tmp8_ = self->priv->default_device;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			devices_copy = g_list_prepend (devices_copy, _tmp9_);
		}
	}
	_tmp10_ = devices_copy;
	self->priv->have_devices = g_list_length (_tmp10_) > ((guint) 0);
	missing_driver = NULL;
	if (!self->priv->have_devices) {
		gchar* _tmp11_;
		_tmp11_ = simple_scan_suggest_driver (self);
		_g_free0 (missing_driver);
		missing_driver = _tmp11_;
	}
	_tmp12_ = self->priv->app;
	_tmp13_ = devices_copy;
	_tmp14_ = missing_driver;
	app_window_set_scan_devices (_tmp12_, _tmp13_, _tmp14_);
	_g_free0 (missing_driver);
	(devices_copy == NULL) ? NULL : (devices_copy = (_g_list_free__g_object_unref0_ (devices_copy), NULL));
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

gchar*
simple_scan_suggest_driver (SimpleScan* self)
{
	GUsbContext* _tmp0_;
	GHashTable* driver_map = NULL;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	GHashTable* _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* _tmp12_;
	GHashTable* _tmp13_;
	GPtrArray* devices = NULL;
	GUsbContext* _tmp14_;
	GPtrArray* _tmp15_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->usb_context;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, _g_free0_);
	driver_map = _tmp3_;
	_tmp4_ = driver_map;
	simple_scan_add_devices (self, _tmp4_, SIMPLE_SCAN_brscan_devices, (gint) G_N_ELEMENTS (SIMPLE_SCAN_brscan_devices), "brscan");
	_tmp5_ = driver_map;
	simple_scan_add_devices (self, _tmp5_, SIMPLE_SCAN_brscan2_devices, (gint) G_N_ELEMENTS (SIMPLE_SCAN_brscan2_devices), "brscan2");
	_tmp6_ = driver_map;
	simple_scan_add_devices (self, _tmp6_, SIMPLE_SCAN_brscan3_devices, (gint) G_N_ELEMENTS (SIMPLE_SCAN_brscan3_devices), "brscan3");
	_tmp7_ = driver_map;
	simple_scan_add_devices (self, _tmp7_, SIMPLE_SCAN_brscan4_devices, (gint) G_N_ELEMENTS (SIMPLE_SCAN_brscan4_devices), "brscan4");
	_tmp8_ = driver_map;
	simple_scan_add_devices (self, _tmp8_, SIMPLE_SCAN_pixma_devices, (gint) G_N_ELEMENTS (SIMPLE_SCAN_pixma_devices), "pixma");
	_tmp9_ = driver_map;
	simple_scan_add_devices (self, _tmp9_, SIMPLE_SCAN_samsung_devices, (gint) G_N_ELEMENTS (SIMPLE_SCAN_samsung_devices), "samsung");
	_tmp10_ = driver_map;
	simple_scan_add_devices (self, _tmp10_, SIMPLE_SCAN_smfp_devices, (gint) G_N_ELEMENTS (SIMPLE_SCAN_smfp_devices), "smfp");
	_tmp11_ = driver_map;
	simple_scan_add_devices (self, _tmp11_, SIMPLE_SCAN_hpaio_devices, (gint) G_N_ELEMENTS (SIMPLE_SCAN_hpaio_devices), "hpaio");
	_tmp12_ = driver_map;
	simple_scan_add_devices (self, _tmp12_, SIMPLE_SCAN_epkowa_devices, (gint) G_N_ELEMENTS (SIMPLE_SCAN_epkowa_devices), "epkowa");
	_tmp13_ = driver_map;
	simple_scan_add_devices (self, _tmp13_, SIMPLE_SCAN_lexmark_nscan_devices, (gint) G_N_ELEMENTS (SIMPLE_SCAN_lexmark_nscan_devices), "lexmark_nscan");
	_tmp14_ = self->priv->usb_context;
	_tmp15_ = g_usb_context_get_devices (_tmp14_);
	devices = _tmp15_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				GUsbDevice* device = NULL;
				GPtrArray* _tmp21_;
				gpointer* _tmp22_;
				gint _tmp22__length1;
				GUsbDevice* _tmp23_;
				GUsbDevice* _tmp24_;
				gchar* driver = NULL;
				GHashTable* _tmp25_;
				GUsbDevice* _tmp26_;
				GUsbDevice* _tmp27_;
				gconstpointer _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = devices;
				_tmp19_ = vala_g_ptr_array_get_length (_tmp18_);
				_tmp20_ = _tmp19_;
				if (!(i < _tmp20_)) {
					break;
				}
				_tmp21_ = devices;
				_tmp22_ = _tmp21_->pdata;
				_tmp22__length1 = _tmp21_->len;
				_tmp23_ = _tmp22_[i];
				_tmp24_ = _g_object_ref0 (_tmp23_);
				device = _tmp24_;
				_tmp25_ = driver_map;
				_tmp26_ = device;
				_tmp27_ = device;
				_tmp28_ = g_hash_table_lookup (_tmp25_, (gpointer) ((guintptr) ((g_usb_device_get_vid (_tmp26_) << 16) | g_usb_device_get_pid (_tmp27_))));
				_tmp29_ = g_strdup ((const gchar*) _tmp28_);
				driver = _tmp29_;
				_tmp30_ = driver;
				if (_tmp30_ != NULL) {
					result = driver;
					_g_object_unref0 (device);
					_g_ptr_array_unref0 (devices);
					_g_hash_table_unref0 (driver_map);
					return result;
				}
				_g_free0 (driver);
				_g_object_unref0 (device);
			}
		}
	}
	result = NULL;
	_g_ptr_array_unref0 (devices);
	_g_hash_table_unref0 (driver_map);
	return result;
}

static void
simple_scan_add_devices (SimpleScan* self,
                         GHashTable* map,
                         guint32* devices,
                         gint devices_length1,
                         const gchar* driver)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	g_return_if_fail (driver != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint32 _tmp2_;
				gchar* _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < devices_length1)) {
					break;
				}
				_tmp2_ = devices[i];
				_tmp3_ = g_strdup (driver);
				g_hash_table_insert (map, (gpointer) ((guintptr) _tmp2_), _tmp3_);
			}
		}
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		SimpleScan* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->scanner);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
__lambda47_ (Block12Data* _data12_,
             GObject* obj,
             GAsyncResult* res)
{
	SimpleScan* self;
	AuthorizeDialogResponse data = {0};
	AppWindow* _tmp0_;
	AuthorizeDialogResponse _tmp1_ = {0};
	AuthorizeDialogResponse _tmp2_;
	self = _data12_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->app;
	app_window_authorize_finish (_tmp0_, res, &_tmp1_);
	data = _tmp1_;
	_tmp2_ = data;
	if (_tmp2_.success) {
		AuthorizeDialogResponse _tmp3_;
		const gchar* _tmp4_;
		AuthorizeDialogResponse _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = data;
		_tmp4_ = _tmp3_.username;
		_tmp5_ = data;
		_tmp6_ = _tmp5_.password;
		scanner_authorize (_data12_->scanner, _tmp4_, _tmp6_);
	}
	authorize_dialog_response_destroy (&data);
}

static void
___lambda47__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda47_ (self, source_object, res);
	block12_data_unref (self);
}

static void
simple_scan_authorize_cb (SimpleScan* self,
                          Scanner* scanner,
                          const gchar* resource)
{
	Block12Data* _data12_;
	Scanner* _tmp0_;
	AppWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (resource != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (scanner);
	_g_object_unref0 (_data12_->scanner);
	_data12_->scanner = _tmp0_;
	_tmp1_ = self->priv->app;
	app_window_authorize (_tmp1_, resource, ___lambda47__gasync_ready_callback, block12_data_ref (_data12_));
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static Page*
simple_scan_append_page (SimpleScan* self,
                         gint width,
                         gint height,
                         gint dpi)
{
	Page* page = NULL;
	Book* _tmp0_;
	Page* _tmp1_;
	gboolean _tmp2_ = FALSE;
	Page* _tmp3_;
	ScanDirection scan_direction = 0;
	gboolean do_crop = FALSE;
	gchar* named_crop = NULL;
	gint cx = 0;
	gint cy = 0;
	gint cw = 0;
	gint ch = 0;
	Page* _tmp10_;
	Page* _tmp42_;
	Book* _tmp43_;
	Page* _tmp44_;
	AppWindow* _tmp50_;
	Page* _tmp51_;
	Page* _tmp52_;
	Page* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = book_get_page (_tmp0_, -1);
	page = _tmp1_;
	_tmp3_ = page;
	if (_tmp3_ != NULL) {
		Page* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = page;
		_tmp5_ = page_get_has_data (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		AppWindow* _tmp7_;
		Page* _tmp8_;
		Page* _tmp9_;
		_tmp7_ = self->priv->app;
		_tmp8_ = page;
		app_window_set_selected_page (_tmp7_, _tmp8_);
		_tmp9_ = page;
		page_start (_tmp9_);
		result = page;
		return result;
	}
	scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
	do_crop = FALSE;
	named_crop = NULL;
	cx = 0;
	cy = 0;
	cw = 0;
	ch = 0;
	_tmp10_ = page;
	if (_tmp10_ != NULL) {
		Page* _tmp11_;
		ScanDirection _tmp12_;
		ScanDirection _tmp13_;
		Page* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		Page* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		Page* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		Page* _tmp23_;
		gboolean _tmp24_;
		gboolean _tmp25_;
		_tmp11_ = page;
		_tmp12_ = page_get_scan_direction (_tmp11_);
		_tmp13_ = _tmp12_;
		scan_direction = _tmp13_;
		_tmp14_ = page;
		_tmp15_ = page_get_width (_tmp14_);
		_tmp16_ = _tmp15_;
		width = _tmp16_;
		_tmp17_ = page;
		_tmp18_ = page_get_height (_tmp17_);
		_tmp19_ = _tmp18_;
		height = _tmp19_;
		_tmp20_ = page;
		_tmp21_ = page_get_dpi (_tmp20_);
		_tmp22_ = _tmp21_;
		dpi = _tmp22_;
		_tmp23_ = page;
		_tmp24_ = page_get_has_crop (_tmp23_);
		_tmp25_ = _tmp24_;
		do_crop = _tmp25_;
		if (do_crop) {
			Page* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			Page* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			Page* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			Page* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			Page* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			_tmp26_ = page;
			_tmp27_ = page_get_crop_name (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strdup (_tmp28_);
			_g_free0 (named_crop);
			named_crop = _tmp29_;
			_tmp30_ = page;
			_tmp31_ = page_get_crop_x (_tmp30_);
			_tmp32_ = _tmp31_;
			cx = _tmp32_;
			_tmp33_ = page;
			_tmp34_ = page_get_crop_y (_tmp33_);
			_tmp35_ = _tmp34_;
			cy = _tmp35_;
			_tmp36_ = page;
			_tmp37_ = page_get_crop_width (_tmp36_);
			_tmp38_ = _tmp37_;
			cw = _tmp38_;
			_tmp39_ = page;
			_tmp40_ = page_get_crop_height (_tmp39_);
			_tmp41_ = _tmp40_;
			ch = _tmp41_;
		}
	}
	_tmp42_ = page_new (width, height, dpi, scan_direction);
	_g_object_unref0 (page);
	page = _tmp42_;
	_tmp43_ = self->priv->book;
	_tmp44_ = page;
	book_append_page (_tmp43_, _tmp44_);
	if (do_crop) {
		const gchar* _tmp45_;
		Page* _tmp49_;
		_tmp45_ = named_crop;
		if (_tmp45_ != NULL) {
			Page* _tmp46_;
			const gchar* _tmp47_;
			_tmp46_ = page;
			_tmp47_ = named_crop;
			page_set_named_crop (_tmp46_, _tmp47_);
		} else {
			Page* _tmp48_;
			_tmp48_ = page;
			page_set_custom_crop (_tmp48_, cw, ch);
		}
		_tmp49_ = page;
		page_move_crop (_tmp49_, cx, cy);
	}
	_tmp50_ = self->priv->app;
	_tmp51_ = page;
	app_window_set_selected_page (_tmp50_, _tmp51_);
	_tmp52_ = page;
	page_start (_tmp52_);
	result = page;
	_g_free0 (named_crop);
	return result;
}

static void
simple_scan_scanner_new_page_cb (SimpleScan* self,
                                 Scanner* scanner)
{
	Page* _tmp0_;
	Page* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = simple_scan_append_page (self, 100, 100, 100);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}

static gchar*
simple_scan_get_profile_for_device (SimpleScan* self,
                                    const gchar* device_name)
{
	gchar* device_id = NULL;
	gchar* _tmp0_;
	CdClient* client = NULL;
	CdClient* _tmp1_;
	CdDevice* device = NULL;
	CdProfile* profile = NULL;
	CdDevice* _tmp15_;
	CdProfile* _tmp16_;
	CdProfile* _tmp17_;
	CdProfile* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	CdProfile* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	CdProfile* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device_name != NULL, NULL);
	_tmp0_ = g_strdup_printf ("sane:%s", device_name);
	device_id = _tmp0_;
	g_debug ("simple-scan.vala:1657: Getting color profile for device %s", device_name);
	_tmp1_ = cd_client_new ();
	client = _tmp1_;
	{
		CdClient* _tmp2_;
		_tmp2_ = client;
		cd_client_connect_sync (_tmp2_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("simple-scan.vala:1666: Failed to connect to colord: %s", _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		CdDevice* _tmp5_ = NULL;
		CdClient* _tmp6_;
		const gchar* _tmp7_;
		CdDevice* _tmp8_;
		CdDevice* _tmp9_;
		_tmp6_ = client;
		_tmp7_ = device_id;
		_tmp8_ = cd_client_find_device_by_property_sync (_tmp6_, CD_DEVICE_PROPERTY_SERIAL, _tmp7_, NULL, &_inner_error0_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (device);
		device = _tmp9_;
		_g_object_unref0 (_tmp5_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_debug ("simple-scan.vala:1677: Unable to find colord device %s: %s", device_name, _tmp11_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		CdDevice* _tmp12_;
		_tmp12_ = device;
		cd_device_connect_sync (_tmp12_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_debug ("simple-scan.vala:1687: Failed to get properties from the device %s: %s", device_name, _tmp14_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp15_ = device;
	_tmp16_ = cd_device_get_default_profile (_tmp15_);
	profile = _tmp16_;
	_tmp17_ = profile;
	if (_tmp17_ == NULL) {
		g_debug ("simple-scan.vala:1694: No default color profile for device: %s", device_name);
		result = NULL;
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	{
		CdProfile* _tmp18_;
		_tmp18_ = profile;
		cd_profile_connect_sync (_tmp18_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_debug ("simple-scan.vala:1704: Failed to get properties from the profile %s: %" \
"s", device_name, _tmp20_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp21_ = profile;
	_tmp22_ = cd_profile_get_filename (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == NULL) {
		g_debug ("simple-scan.vala:1710: No icc color profile for the device %s", device_name);
		result = NULL;
		_g_object_unref0 (profile);
		_g_object_unref0 (device);
		_g_object_unref0 (client);
		_g_free0 (device_id);
		return result;
	}
	_tmp24_ = profile;
	_tmp25_ = cd_profile_get_filename (_tmp24_);
	_tmp26_ = _tmp25_;
	g_debug ("simple-scan.vala:1714: Using color profile %s for device %s", _tmp26_, device_name);
	_tmp27_ = profile;
	_tmp28_ = cd_profile_get_filename (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_object_unref0 (profile);
	_g_object_unref0 (device);
	_g_object_unref0 (client);
	_g_free0 (device_id);
	return result;
}

static void
simple_scan_scanner_page_info_cb (SimpleScan* self,
                                  Scanner* scanner,
                                  ScanPageInfo* info)
{
	Page* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (info != NULL);
	g_debug ("simple-scan.vala:1723: Page is %d pixels wide, %d pixels high, %d bits" \
" per pixel", info->width, info->height, info->depth);
	_tmp0_ = simple_scan_append_page (self, 100, 100, 100);
	_g_object_unref0 (self->priv->scanned_page);
	self->priv->scanned_page = _tmp0_;
	_tmp1_ = self->priv->scanned_page;
	page_set_page_info (_tmp1_, info);
	_tmp2_ = self->priv->scanned_page;
	_tmp3_ = info->device;
	_tmp4_ = simple_scan_get_profile_for_device (self, _tmp3_);
	_tmp5_ = _tmp4_;
	page_set_color_profile (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
}

static void
simple_scan_scanner_line_cb (SimpleScan* self,
                             Scanner* scanner,
                             ScanLine* line)
{
	Page* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->scanned_page;
	page_parse_scan_line (_tmp0_, line);
}

static void
simple_scan_scanner_page_done_cb (SimpleScan* self,
                                  Scanner* scanner)
{
	Page* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = self->priv->scanned_page;
	page_finish (_tmp0_);
	_g_object_unref0 (self->priv->scanned_page);
	self->priv->scanned_page = NULL;
}

static void
simple_scan_remove_empty_page (SimpleScan* self)
{
	Page* page = NULL;
	Book* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book;
	_tmp1_ = self->priv->book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = book_get_page (_tmp0_, ((gint) _tmp3_) - 1);
	page = _tmp4_;
	_tmp5_ = page;
	_tmp6_ = page_get_has_data (_tmp5_);
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		Book* _tmp8_;
		Page* _tmp9_;
		_tmp8_ = self->priv->book;
		_tmp9_ = page;
		book_delete_page (_tmp8_, _tmp9_);
	}
	_g_object_unref0 (page);
}

static void
simple_scan_scanner_document_done_cb (SimpleScan* self,
                                      Scanner* scanner)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	simple_scan_remove_empty_page (self);
}

static void
simple_scan_scanner_failed_cb (SimpleScan* self,
                               Scanner* scanner,
                               gint error_code,
                               const gchar* error_string)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (error_string != NULL);
	simple_scan_remove_empty_page (self);
	_g_object_unref0 (self->priv->scanned_page);
	self->priv->scanned_page = NULL;
	if (error_code != ((gint) SANE_STATUS_CANCELLED)) {
		AppWindow* _tmp0_;
		_tmp0_ = self->priv->app;
		app_window_show_error_dialog (_tmp0_, _ ("Failed to scan"), error_string);
	}
}

static void
simple_scan_scanner_scanning_changed_cb (SimpleScan* self,
                                         Scanner* scanner)
{
	gboolean is_scanning = FALSE;
	AppWindow* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	is_scanning = scanner_is_scanning (scanner);
	if (is_scanning) {
		gchar* reason = NULL;
		gchar* _tmp0_;
		AppWindow* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = g_strdup (_ ("Scan in progress"));
		reason = _tmp0_;
		_tmp1_ = self->priv->app;
		_tmp2_ = reason;
		self->priv->inhibit_cookie = gtk_application_inhibit ((GtkApplication*) self, (GtkWindow*) _tmp1_, GTK_APPLICATION_INHIBIT_IDLE, _tmp2_);
		if (self->priv->inhibit_cookie == ((guint) 0)) {
			{
				FreedesktopScreensaver* _tmp3_ = NULL;
				FreedesktopScreensaver* _tmp4_;
				FreedesktopScreensaver* _tmp5_;
				FreedesktopScreensaver* _tmp6_;
				_tmp4_ = freedesktop_screensaver_get_proxy (&_inner_error0_);
				_tmp3_ = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp5_ = _tmp3_;
				_tmp3_ = NULL;
				_g_object_unref0 (self->priv->fdss);
				self->priv->fdss = _tmp5_;
				_tmp6_ = self->priv->fdss;
				if (_tmp6_ != NULL) {
					guint32 _tmp7_ = 0U;
					FreedesktopScreensaver* _tmp8_;
					const gchar* _tmp9_;
					_tmp8_ = self->priv->fdss;
					_tmp9_ = reason;
					_tmp7_ = freedesktop_screensaver_inhibit (_tmp8_, "Simple-Scan", _tmp9_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (_tmp3_);
						goto __catch0_g_error;
					}
					self->priv->inhibit_cookie = (guint) _tmp7_;
				}
				_g_object_unref0 (_tmp3_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (reason);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_free0 (reason);
	} else {
		if (self->priv->inhibit_cookie != ((guint) 0)) {
			FreedesktopScreensaver* _tmp10_;
			_tmp10_ = self->priv->fdss;
			if (_tmp10_ == NULL) {
				gtk_application_uninhibit ((GtkApplication*) self, self->priv->inhibit_cookie);
			} else {
				{
					FreedesktopScreensaver* _tmp11_;
					_tmp11_ = self->priv->fdss;
					freedesktop_screensaver_uninhibit (_tmp11_, (guint32) self->priv->inhibit_cookie, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_object_unref0 (self->priv->fdss);
				self->priv->fdss = NULL;
			}
			self->priv->inhibit_cookie = (guint) 0;
		}
	}
	_tmp12_ = self->priv->app;
	app_window_set_scanning (_tmp12_, is_scanning);
}

static void
simple_scan_scan_cb (SimpleScan* self,
                     AppWindow* ui,
                     const gchar* device,
                     ScanOptions* options)
{
	Scanner* _tmp0_;
	Scanner* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	g_return_if_fail (options != NULL);
	g_debug ("simple-scan.vala:1828: Requesting scan at %d dpi from device '%s'", options->dpi, device);
	_tmp0_ = self->priv->scanner;
	if (!scanner_is_scanning (_tmp0_)) {
		Page* _tmp1_;
		Page* _tmp2_;
		_tmp1_ = simple_scan_append_page (self, options->paper_width + 1, options->paper_height + 1, options->dpi + 1);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_tmp2_);
	}
	_tmp3_ = self->priv->scanner;
	scanner_scan (_tmp3_, device, options);
}

static void
simple_scan_cancel_cb (SimpleScan* self,
                       AppWindow* ui)
{
	Scanner* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	_tmp0_ = self->priv->scanner;
	scanner_cancel (_tmp0_);
}

static void
simple_scan_redetect_cb (SimpleScan* self,
                         AppWindow* ui)
{
	Scanner* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui != NULL);
	_tmp0_ = self->priv->scanner;
	scanner_redetect (_tmp0_);
}

static void
simple_scan_log_cb (const gchar* log_domain,
                    GLogLevelFlags log_level,
                    const gchar* message)
{
	gchar* prefix = NULL;
	FILE* _tmp7_;
	GTimer* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (message != NULL);
	switch (log_level & G_LOG_LEVEL_MASK) {
		case G_LOG_LEVEL_ERROR:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("ERROR:");
			_g_free0 (prefix);
			prefix = _tmp0_;
			break;
		}
		case G_LOG_LEVEL_CRITICAL:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("CRITICAL:");
			_g_free0 (prefix);
			prefix = _tmp1_;
			break;
		}
		case G_LOG_LEVEL_WARNING:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("WARNING:");
			_g_free0 (prefix);
			prefix = _tmp2_;
			break;
		}
		case G_LOG_LEVEL_MESSAGE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("MESSAGE:");
			_g_free0 (prefix);
			prefix = _tmp3_;
			break;
		}
		case G_LOG_LEVEL_INFO:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("INFO:");
			_g_free0 (prefix);
			prefix = _tmp4_;
			break;
		}
		case G_LOG_LEVEL_DEBUG:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("DEBUG:");
			_g_free0 (prefix);
			prefix = _tmp5_;
			break;
		}
		default:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("LOG:");
			_g_free0 (prefix);
			prefix = _tmp6_;
			break;
		}
	}
	_tmp7_ = simple_scan_log_file;
	_tmp8_ = simple_scan_log_timer;
	_tmp9_ = prefix;
	fprintf (_tmp7_, "[%+.2fs] %s %s\n", g_timer_elapsed (_tmp8_, NULL), _tmp9_, message);
	if (simple_scan_debug_enabled) {
		FILE* _tmp10_;
		GTimer* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = stderr;
		_tmp11_ = simple_scan_log_timer;
		_tmp12_ = prefix;
		fprintf (_tmp10_, "[%+.2fs] %s %s\n", g_timer_elapsed (_tmp11_, NULL), _tmp12_, message);
	}
	_g_free0 (prefix);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
simple_scan_fix_pdf (const gchar* filename,
                     GError** error)
{
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guint8* _tmp0_ = NULL;
	gsize _tmp1_ = 0;
	FILE* fixed_file = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	gint offset = 0;
	gint line_number = 0;
	gint xref_offset = 0;
	gint xref_line = 0;
	gint startxref_line = 0;
	gint fixed_size = 0;
	GString* line = NULL;
	GString* _tmp6_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gboolean _tmp66_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (filename != NULL);
	g_file_get_contents (filename, (gchar**) (&_tmp0_), &_tmp1_, &_inner_error0_);
	data = (g_free (data), NULL);
	data = _tmp0_;
	data_length1 = _tmp1_;
	_data_size_ = data_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		data = (g_free (data), NULL);
		return;
	}
	_tmp2_ = g_strconcat (filename, ".fixed", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_fopen (_tmp3_, "w");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	fixed_file = _tmp5_;
	offset = 0;
	line_number = 0;
	xref_offset = 0;
	xref_line = -1;
	startxref_line = -1;
	fixed_size = -1;
	_tmp6_ = g_string_new ("");
	line = _tmp6_;
	while (TRUE) {
		gint end_offset = 0;
		GString* _tmp7_;
		GString* _tmp11_;
		const gchar* _tmp12_;
		GString* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp15_ = FALSE;
		gint _tmp63_;
		if (!(offset < data_length1)) {
			break;
		}
		end_offset = offset;
		_tmp7_ = line;
		g_string_assign (_tmp7_, "");
		while (TRUE) {
			guint8 c = 0U;
			guint8 _tmp8_;
			GString* _tmp9_;
			gint _tmp10_;
			if (!(end_offset < data_length1)) {
				break;
			}
			_tmp8_ = data[end_offset];
			c = _tmp8_;
			_tmp9_ = line;
			g_string_append_c (_tmp9_, (gchar) c);
			_tmp10_ = end_offset;
			end_offset = _tmp10_ + 1;
			if (c == ((guint8) '\n')) {
				break;
			}
		}
		_tmp11_ = line;
		_tmp12_ = _tmp11_->str;
		if (g_strcmp0 (_tmp12_, "startxref\n") == 0) {
			startxref_line = line_number;
		}
		_tmp13_ = line;
		_tmp14_ = _tmp13_->str;
		if (g_strcmp0 (_tmp14_, "xref\n") == 0) {
			xref_line = line_number;
		}
		if (line_number < 2) {
			GString* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = line;
			_tmp17_ = _tmp16_->str;
			_tmp15_ = g_str_has_prefix (_tmp17_, "%%");
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			gint _tmp18_;
			FILE* _tmp19_;
			GString* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp18_ = xref_offset;
			xref_offset = _tmp18_ - 1;
			_tmp19_ = fixed_file;
			_tmp20_ = line;
			_tmp21_ = _tmp20_->str;
			_tmp22_ = string_substring (_tmp21_, (glong) 1, (glong) -1);
			_tmp23_ = _tmp22_;
			fprintf (_tmp19_, "%s", _tmp23_);
			_g_free0 (_tmp23_);
		} else {
			gboolean _tmp24_ = FALSE;
			if (line_number == (xref_line + 1)) {
				GString* _tmp25_;
				const gchar* _tmp26_;
				_tmp25_ = line;
				_tmp26_ = _tmp25_->str;
				_tmp24_ = g_str_has_prefix (_tmp26_, "1 ");
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				GString* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				FILE* _tmp31_;
				FILE* _tmp32_;
				_tmp27_ = line;
				_tmp28_ = _tmp27_->str;
				_tmp29_ = string_substring (_tmp28_, (glong) 2, (glong) -1);
				_tmp30_ = _tmp29_;
				fixed_size = atoi (_tmp30_) + 1;
				_g_free0 (_tmp30_);
				_tmp31_ = fixed_file;
				fprintf (_tmp31_, "0 %d\n", fixed_size);
				_tmp32_ = fixed_file;
				fprintf (_tmp32_, "0000000000 65535 f \n");
			} else {
				gboolean _tmp33_ = FALSE;
				if (line_number > xref_line) {
					GString* _tmp34_;
					const gchar* _tmp35_;
					_tmp34_ = line;
					_tmp35_ = _tmp34_->str;
					_tmp33_ = g_str_has_suffix (_tmp35_, " 0000 n\n");
				} else {
					_tmp33_ = FALSE;
				}
				if (_tmp33_) {
					FILE* _tmp36_;
					GString* _tmp37_;
					const gchar* _tmp38_;
					_tmp36_ = fixed_file;
					_tmp37_ = line;
					_tmp38_ = _tmp37_->str;
					fprintf (_tmp36_, "%010d 00000 n \n", atoi (_tmp38_) + xref_offset);
				} else {
					gboolean _tmp39_ = FALSE;
					if (startxref_line > 0) {
						_tmp39_ = line_number == (startxref_line + 1);
					} else {
						_tmp39_ = FALSE;
					}
					if (_tmp39_) {
						FILE* _tmp40_;
						GString* _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						_tmp40_ = fixed_file;
						_tmp41_ = line;
						_tmp42_ = _tmp41_->str;
						_tmp43_ = g_strdup_printf ("%d\n", atoi (_tmp42_) + xref_offset);
						_tmp44_ = _tmp43_;
						fprintf (_tmp40_, "%s", _tmp44_);
						_g_free0 (_tmp44_);
					} else {
						gboolean _tmp45_ = FALSE;
						if (fixed_size > 0) {
							GString* _tmp46_;
							const gchar* _tmp47_;
							_tmp46_ = line;
							_tmp47_ = _tmp46_->str;
							_tmp45_ = g_str_has_prefix (_tmp47_, "/Size ");
						} else {
							_tmp45_ = FALSE;
						}
						if (_tmp45_) {
							FILE* _tmp48_;
							gchar* _tmp49_;
							gchar* _tmp50_;
							_tmp48_ = fixed_file;
							_tmp49_ = g_strdup_printf ("/Size %d\n", fixed_size);
							_tmp50_ = _tmp49_;
							fprintf (_tmp48_, "%s", _tmp50_);
							_g_free0 (_tmp50_);
						} else {
							gboolean _tmp51_ = FALSE;
							if (line_number == (startxref_line + 2)) {
								GString* _tmp52_;
								const gchar* _tmp53_;
								_tmp52_ = line;
								_tmp53_ = _tmp52_->str;
								_tmp51_ = g_str_has_prefix (_tmp53_, "%%%%");
							} else {
								_tmp51_ = FALSE;
							}
							if (_tmp51_) {
								FILE* _tmp54_;
								GString* _tmp55_;
								const gchar* _tmp56_;
								gchar* _tmp57_;
								gchar* _tmp58_;
								_tmp54_ = fixed_file;
								_tmp55_ = line;
								_tmp56_ = _tmp55_->str;
								_tmp57_ = string_substring (_tmp56_, (glong) 2, (glong) -1);
								_tmp58_ = _tmp57_;
								fprintf (_tmp54_, "%s", _tmp58_);
								_g_free0 (_tmp58_);
							} else {
								{
									gint i = 0;
									i = offset;
									{
										gboolean _tmp59_ = FALSE;
										_tmp59_ = TRUE;
										while (TRUE) {
											FILE* _tmp61_;
											guint8 _tmp62_;
											if (!_tmp59_) {
												gint _tmp60_;
												_tmp60_ = i;
												i = _tmp60_ + 1;
											}
											_tmp59_ = FALSE;
											if (!(i < end_offset)) {
												break;
											}
											_tmp61_ = fixed_file;
											_tmp62_ = data[i];
											fputc ((gchar) _tmp62_, _tmp61_);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp63_ = line_number;
		line_number = _tmp63_ + 1;
		offset = end_offset;
	}
	_tmp64_ = g_strconcat (filename, "~", NULL);
	_tmp65_ = _tmp64_;
	_tmp66_ = g_rename (filename, _tmp65_) >= 0;
	_g_free0 (_tmp65_);
	if (_tmp66_) {
		gchar* _tmp67_;
		gchar* _tmp68_;
		_tmp67_ = g_strconcat (filename, ".fixed", NULL);
		_tmp68_ = _tmp67_;
		g_rename (_tmp68_, filename);
		_g_free0 (_tmp68_);
	}
	_g_string_free0 (line);
	_fclose0 (fixed_file);
	data = (g_free (data), NULL);
}

static void
_simple_scan_log_cb_glog_func (const gchar* log_domain,
                               GLogLevelFlags log_levels,
                               const gchar* message,
                               gpointer self)
{
	simple_scan_log_cb (log_domain, log_levels, message);
}

static gint
simple_scan_main (gchar** args,
                  gint args_length1)
{
	GOptionContext* c = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	const gchar* _tmp11_;
	ScanDevice* device = NULL;
	GTimer* _tmp27_;
	gchar* path = NULL;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	FILE* _tmp34_;
	FILE* _tmp35_;
	const gchar* _tmp38_;
	SimpleScan* app = NULL;
	ScanDevice* _tmp39_;
	SimpleScan* _tmp40_;
	SimpleScan* _tmp41_;
	GError* _inner_error0_ = NULL;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (_ ("[DEVICE…] — Scanning utility"));
	c = _tmp0_;
	_tmp1_ = c;
	g_option_context_add_main_entries (_tmp1_, SIMPLE_SCAN_options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = c;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		FILE* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		_tmp6_ = stderr;
		_tmp7_ = args[0];
		fprintf (_tmp6_, _ ("Run “%s --help” to see a full list of available command line options."), _tmp7_);
		_tmp8_ = stderr;
		fprintf (_tmp8_, "\n");
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (c);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp9_ = -1;
		_g_option_context_free0 (c);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	if (simple_scan_show_version) {
		FILE* _tmp10_;
		_tmp10_ = stderr;
		fprintf (_tmp10_, "simple-scan %s\n", VERSION);
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		return result;
	}
	_tmp11_ = simple_scan_fix_pdf_filename;
	if (_tmp11_ != NULL) {
		{
			const gchar* _tmp12_;
			_tmp12_ = simple_scan_fix_pdf_filename;
			simple_scan_fix_pdf (_tmp12_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			{
				gint i = 0;
				i = 1;
				{
					gboolean _tmp13_ = FALSE;
					_tmp13_ = TRUE;
					while (TRUE) {
						const gchar* _tmp15_;
						if (!_tmp13_) {
							gint _tmp14_;
							_tmp14_ = i;
							i = _tmp14_ + 1;
						}
						_tmp13_ = FALSE;
						if (!(i < args_length1)) {
							break;
						}
						_tmp15_ = args[i];
						simple_scan_fix_pdf (_tmp15_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
					}
				}
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			FILE* _tmp16_;
			GError* _tmp17_;
			const gchar* _tmp18_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = stderr;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			fprintf (_tmp16_, "Error fixing PDF file: %s\n", _tmp18_);
			result = EXIT_FAILURE;
			_g_error_free0 (e);
			_g_option_context_free0 (c);
			return result;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp19_ = -1;
			_g_option_context_free0 (c);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp19_;
		}
		result = EXIT_SUCCESS;
		_g_option_context_free0 (c);
		return result;
	}
	device = NULL;
	if (args_length1 > 1) {
		ScanDevice* _tmp20_;
		ScanDevice* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		ScanDevice* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp20_ = scan_device_new ();
		_g_object_unref0 (device);
		device = _tmp20_;
		_tmp21_ = device;
		_tmp22_ = args[1];
		_tmp23_ = g_strdup (_tmp22_);
		_g_free0 (_tmp21_->name);
		_tmp21_->name = _tmp23_;
		_tmp24_ = device;
		_tmp25_ = args[1];
		_tmp26_ = g_strdup (_tmp25_);
		_g_free0 (_tmp24_->label);
		_tmp24_->label = _tmp26_;
	}
	_tmp27_ = g_timer_new ();
	_g_timer_destroy0 (simple_scan_log_timer);
	simple_scan_log_timer = _tmp27_;
	_tmp28_ = g_get_user_cache_dir ();
	_tmp29_ = g_build_filename (_tmp28_, "simple-scan", NULL, NULL);
	path = _tmp29_;
	_tmp30_ = path;
	g_mkdir_with_parents (_tmp30_, 0700);
	_tmp31_ = g_get_user_cache_dir ();
	_tmp32_ = g_build_filename (_tmp31_, "simple-scan", "simple-scan.log", NULL, NULL);
	_g_free0 (path);
	path = _tmp32_;
	_tmp33_ = path;
	_tmp34_ = g_fopen (_tmp33_, "w");
	_fclose0 (simple_scan_log_file);
	simple_scan_log_file = _tmp34_;
	_tmp35_ = simple_scan_log_file;
	if (_tmp35_ == NULL) {
		FILE* _tmp36_;
		const gchar* _tmp37_;
		_tmp36_ = stderr;
		_tmp37_ = path;
		fprintf (_tmp36_, "Error: Unable to open %s file for writing\n", _tmp37_);
		result = EXIT_FAILURE;
		_g_free0 (path);
		_g_object_unref0 (device);
		_g_option_context_free0 (c);
		return result;
	}
	g_log_set_default_handler (_simple_scan_log_cb_glog_func, NULL);
	_tmp38_ = args[0];
	g_debug ("simple-scan.vala:2022: Starting %s %s, PID=%i", _tmp38_, VERSION, (gint) getpid ());
	gtk_init ();
	_tmp39_ = device;
	_tmp40_ = simple_scan_new (_tmp39_);
	app = _tmp40_;
	_tmp41_ = app;
	result = g_application_run ((GApplication*) _tmp41_, (gint) 0, NULL);
	_g_object_unref0 (app);
	_g_free0 (path);
	_g_object_unref0 (device);
	_g_option_context_free0 (c);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return simple_scan_main (argv, argc);
}

static void
simple_scan_class_init (SimpleScanClass * klass,
                        gpointer klass_data)
{
	simple_scan_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SimpleScan_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) simple_scan_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) simple_scan_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) simple_scan_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = simple_scan_finalize;
}

static void
simple_scan_instance_init (SimpleScan * self,
                           gpointer klass)
{
	self->priv = simple_scan_get_instance_private (self);
	self->priv->default_device = NULL;
	self->priv->have_devices = FALSE;
}

static void
simple_scan_finalize (GObject * obj)
{
	SimpleScan * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SIMPLE_SCAN, SimpleScan);
	_g_object_unref0 (self->priv->default_device);
	_g_object_unref0 (self->priv->usb_context);
	_g_object_unref0 (self->priv->app);
	_g_object_unref0 (self->priv->scanner);
	_g_object_unref0 (self->priv->book);
	_g_object_unref0 (self->priv->scanned_page);
	_g_object_unref0 (self->priv->fdss);
	G_OBJECT_CLASS (simple_scan_parent_class)->finalize (obj);
}

static GType
simple_scan_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SimpleScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleScan), 0, (GInstanceInitFunc) simple_scan_instance_init, NULL };
	GType simple_scan_type_id;
	simple_scan_type_id = g_type_register_static (adw_application_get_type (), "SimpleScan", &g_define_type_info, 0);
	SimpleScan_private_offset = g_type_add_instance_private (simple_scan_type_id, sizeof (SimpleScanPrivate));
	return simple_scan_type_id;
}

GType
simple_scan_get_type (void)
{
	static volatile gsize simple_scan_type_id__once = 0;
	if (g_once_init_enter (&simple_scan_type_id__once)) {
		GType simple_scan_type_id;
		simple_scan_type_id = simple_scan_get_type_once ();
		g_once_init_leave (&simple_scan_type_id__once, simple_scan_type_id);
	}
	return simple_scan_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

