/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_mdssvc.h"
#include "bin/default/librpc/gen_ndr/ndr_mdssvc_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* mdssvc - dcerpc server boilerplate generated by pidl */
static NTSTATUS mdssvc__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_MDSSVC_BIND
	return DCESRV_INTERFACE_MDSSVC_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void mdssvc__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_MDSSVC_UNBIND
	DCESRV_INTERFACE_MDSSVC_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS mdssvc__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_mdssvc.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_mdssvc.calls[opnum].struct_size, "struct %s", ndr_table_mdssvc.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_mdssvc.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS mdssvc__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* mdssvc_open */
		struct mdssvc_open *r2 = (struct mdssvc_open *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(mdssvc_open, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.device_id = r2->in.device_id;
		r2->out.unkn2 = r2->in.unkn2;
		r2->out.unkn3 = r2->in.unkn3;
		r2->out.share_path = talloc_zero_array(r2, const char, 1025);
		if (r2->out.share_path == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		_mdssvc_open(p, r2);
		break;
	}
	case 1: { /* mdssvc_unknown1 */
		struct mdssvc_unknown1 *r2 = (struct mdssvc_unknown1 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(mdssvc_unknown1, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.status = talloc_zero(r2, uint32_t);
		if (r2->out.status == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.flags = talloc_zero(r2, uint32_t);
		if (r2->out.flags == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.unkn7 = talloc_zero(r2, uint32_t);
		if (r2->out.unkn7 == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		_mdssvc_unknown1(p, r2);
		break;
	}
	case 2: { /* mdssvc_cmd */
		struct mdssvc_cmd *r2 = (struct mdssvc_cmd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(mdssvc_cmd, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.fragment = talloc_zero(r2, uint32_t);
		if (r2->out.fragment == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.response_blob = talloc_zero(r2, struct mdssvc_blob);
		if (r2->out.response_blob == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.unkn9 = talloc_zero(r2, uint32_t);
		if (r2->out.unkn9 == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		_mdssvc_cmd(p, r2);
		break;
	}
	case 3: { /* mdssvc_close */
		struct mdssvc_close *r2 = (struct mdssvc_close *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(mdssvc_close, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.out_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.out_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.status = talloc_zero(r2, uint32_t);
		if (r2->out.status == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		_mdssvc_close(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS mdssvc__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return mdssvc__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS mdssvc__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* mdssvc_open */
		struct mdssvc_open *r2 = (struct mdssvc_open *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function mdssvc_open replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(mdssvc_open, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in mdssvc_open\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* mdssvc_unknown1 */
		struct mdssvc_unknown1 *r2 = (struct mdssvc_unknown1 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function mdssvc_unknown1 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(mdssvc_unknown1, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in mdssvc_unknown1\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* mdssvc_cmd */
		struct mdssvc_cmd *r2 = (struct mdssvc_cmd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function mdssvc_cmd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(mdssvc_cmd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in mdssvc_cmd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* mdssvc_close */
		struct mdssvc_close *r2 = (struct mdssvc_close *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function mdssvc_close replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(mdssvc_close, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in mdssvc_close\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS mdssvc__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_mdssvc.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS mdssvc__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return mdssvc__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_mdssvc_interface = {
	.name      = "mdssvc",
	.syntax_id = {{0x885d85fb,0xc754,0x4062,{0xa0,0xe7},{0x68,0x72,0xce,0x00,0x64,0xf4}},2.0},
	.bind      = mdssvc__op_bind,
	.unbind    = mdssvc__op_unbind,
	.ndr_pull  = mdssvc__op_ndr_pull,
	.dispatch  = mdssvc__op_dispatch,
	.reply     = mdssvc__op_reply,
	.ndr_push  = mdssvc__op_ndr_push,
	.local     = mdssvc__op_local,
#ifdef DCESRV_INTERFACE_MDSSVC_FLAGS
	.flags     = DCESRV_INTERFACE_MDSSVC_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS mdssvc__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_MDSSVC_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_MDSSVC_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_mdssvc.endpoints->count;i++) {
		const char *name = ndr_table_mdssvc.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_mdssvc_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS mdssvc__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool mdssvc__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_mdssvc_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_mdssvc_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_mdssvc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool mdssvc__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_mdssvc_interface.name, name)==0) {
		memcpy(iface, &dcesrv_mdssvc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server mdssvc_ep_server = {
	/* fill in our name */
	.name = "mdssvc",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_MDSSVC_INIT_SERVER
	.init_server = DCESRV_INTERFACE_MDSSVC_INIT_SERVER,
#else
	.init_server = mdssvc__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_MDSSVC_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_MDSSVC_SHUTDOWN_SERVER,
#else
	.shutdown_server = mdssvc__op_shutdown_server,
#endif
	.interface_by_uuid = mdssvc__op_interface_by_uuid,
	.interface_by_name = mdssvc__op_interface_by_name
};

const struct dcesrv_endpoint_server *mdssvc_get_ep_server(void)
{
	return &mdssvc_ep_server;
}
