#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#define HAVE_LIBTOMMATH 1
#define HAVE_WIDE_INT_TYPE 1
#include <tcl.h>
#include <tk.h>

#if HAVE_LIBTOMMATH
#include <tclTomMath.h>
#endif 

char *get_tk_version(void) { return TK_VERSION; }
char *get_tcl_version(void) { return TCL_VERSION; }
char *get_tk_patch_level(void) { return TK_PATCH_LEVEL; }
char *get_tcl_patch_level(void) { return TCL_PATCH_LEVEL; }


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 215), // Tcl_Command()(Tcl_Interp *, char const *, int(*)(void *, Tcl_Interp *, int, char const * *), void *, void(*)(void *))
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 216), // Tcl_Interp *
/*  2 */ _CFFI_OP(_CFFI_OP_POINTER, 221), // char const *
/*  3 */ _CFFI_OP(_CFFI_OP_POINTER, 181), // int(*)(void *, Tcl_Interp *, int, char const * *)
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 231), // void *
/*  5 */ _CFFI_OP(_CFFI_OP_POINTER, 212), // void(*)(void *)
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // Tcl_Interp *()(void)
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(Tcl_Interp *)
/* 10 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(Tcl_Interp *, char const *, char const *, Tcl_Obj *, int)
/* 13 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 14 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 15 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 16 */ _CFFI_OP(_CFFI_OP_POINTER, 217), // Tcl_Obj *
/* 17 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(Tcl_Interp *, char const *, char const *, int)
/* 20 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 21 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 23 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(Tcl_WideInt)
/* 26 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(Tcl_WideInt), (
           ((Tcl_WideInt)-1) | 0 /* check that Tcl_WideInt is an integer type */
         ) <= 0)), // Tcl_WideInt
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(char const *, int)
/* 29 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 30 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(double)
/* 33 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(int)
/* 36 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(int, Tcl_Obj * const *)
/* 39 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 40 */ _CFFI_OP(_CFFI_OP_POINTER, 16), // Tcl_Obj * const *
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(long)
/* 43 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 9), // long
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(mp_int *)
/* 46 */ _CFFI_OP(_CFFI_OP_POINTER, 222), // mp_int *
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(unsigned char *, int)
/* 49 */ _CFFI_OP(_CFFI_OP_POINTER, 227), // unsigned char *
/* 50 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION, 16), // Tcl_Obj *()(unsigned short const *, int)
/* 53 */ _CFFI_OP(_CFFI_OP_POINTER, 230), // unsigned short const *
/* 54 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION, 218), // Tcl_ObjType const *()(char const *)
/* 57 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION, 220), // Tcl_ThreadId()(void)
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 127), // char *()(Tcl_Obj *)
/* 62 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 64 */ _CFFI_OP(_CFFI_OP_FUNCTION, 127), // char *()(Tcl_Obj *, int *)
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 66 */ _CFFI_OP(_CFFI_OP_POINTER, 17), // int *
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION, 127), // char *()(int, char const * const *)
/* 69 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 70 */ _CFFI_OP(_CFFI_OP_POINTER, 2), // char const * const *
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 127), // char *()(void)
/* 73 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION, 2), // char const *()(Tcl_Interp *)
/* 75 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION, 2), // char const *()(Tcl_Interp *, char const *, char const *, char const *, int)
/* 78 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 80 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 81 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 82 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION, 2), // char const *()(Tcl_Interp *, char const *, char const *, int)
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 86 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 87 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 88 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 89 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION, 2), // char const *()(Tcl_Interp *, char const *, int)
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 93 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *)
/* 96 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, Tcl_Obj *, Tcl_WideInt *)
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 100 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 101 */ _CFFI_OP(_CFFI_OP_POINTER, 26), // Tcl_WideInt *
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, Tcl_Obj *, int *)
/* 104 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 105 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, Tcl_Obj *, int *, Tcl_Obj * * *)
/* 109 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 111 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 112 */ _CFFI_OP(_CFFI_OP_POINTER, 118), // Tcl_Obj * * *
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, Tcl_Obj *, int, Tcl_Obj * *)
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 117 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 118 */ _CFFI_OP(_CFFI_OP_POINTER, 16), // Tcl_Obj * *
/* 119 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, Tcl_Obj *, mp_int *)
/* 121 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 122 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 123 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 124 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, char *, int *, char const * * *)
/* 126 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 127 */ _CFFI_OP(_CFFI_OP_POINTER, 221), // char *
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 129 */ _CFFI_OP(_CFFI_OP_POINTER, 185), // char const * * *
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, char const *)
/* 132 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 134 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, char const *, char const *, int)
/* 136 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 137 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 139 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, char const *, double *)
/* 142 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 144 */ _CFFI_OP(_CFFI_OP_POINTER, 33), // double *
/* 145 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 146 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, char const *, int *)
/* 147 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 148 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 149 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, char const *, long *)
/* 152 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 153 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 154 */ _CFFI_OP(_CFFI_OP_POINTER, 43), // long *
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Interp *, int, Tcl_Obj * *, int)
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 158 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 159 */ _CFFI_OP(_CFFI_OP_NOOP, 118),
/* 160 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 162 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(Tcl_Obj *)
/* 163 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 165 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(int)
/* 166 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(mp_int *)
/* 169 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 171 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(mp_int *, char const *, int)
/* 172 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 173 */ _CFFI_OP(_CFFI_OP_NOOP, 2),
/* 174 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 176 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(mp_int *, unsigned char *, unsigned long *)
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 49),
/* 179 */ _CFFI_OP(_CFFI_OP_POINTER, 228), // unsigned long *
/* 180 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(void *, Tcl_Interp *, int, char const * *)
/* 182 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 184 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 185 */ _CFFI_OP(_CFFI_OP_POINTER, 2), // char const * *
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // int()(void)
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 189 */ _CFFI_OP(_CFFI_OP_FUNCTION, 49), // unsigned char *()(Tcl_Obj *, int *)
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 191 */ _CFFI_OP(_CFFI_OP_NOOP, 66),
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION, 229), // unsigned short *()(Tcl_Obj *)
/* 194 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 195 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 196 */ _CFFI_OP(_CFFI_OP_FUNCTION, 231), // void()(Tcl_Interp *)
/* 197 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION, 231), // void()(Tcl_Interp *, Tcl_Obj *)
/* 200 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 201 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 202 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 203 */ _CFFI_OP(_CFFI_OP_FUNCTION, 231), // void()(Tcl_Obj *)
/* 204 */ _CFFI_OP(_CFFI_OP_NOOP, 16),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION, 231), // void()(char *)
/* 207 */ _CFFI_OP(_CFFI_OP_NOOP, 127),
/* 208 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION, 231), // void()(mp_int *)
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION, 231), // void()(void *)
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 215 */ _CFFI_OP(_CFFI_OP_POINTER, 223), // Tcl_Command
/* 216 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // Tcl_Interp
/* 217 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // Tcl_Obj
/* 218 */ _CFFI_OP(_CFFI_OP_POINTER, 219), // Tcl_ObjType const *
/* 219 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // Tcl_ObjType
/* 220 */ _CFFI_OP(_CFFI_OP_POINTER, 224), // Tcl_ThreadId
/* 221 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 222 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // mp_int
/* 223 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // struct $$Tcl_Command
/* 224 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // struct $$Tcl_ThreadId
/* 225 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // struct $2
/* 226 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // union $1
/* 227 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 10), // unsigned long
/* 229 */ _CFFI_OP(_CFFI_OP_POINTER, 230), // unsigned short *
/* 230 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 6), // unsigned short
/* 231 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_mp_int(mp_int *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->sign) | 0);  /* check that 'mp_int.sign' is an integer */
}
struct _cffi_align_typedef_mp_int { char x; mp_int y; };

static Tcl_Command _cffi_d_Tcl_CreateCommand(Tcl_Interp * x0, char const * x1, int(* x2)(void *, Tcl_Interp *, int, char const * *), void * x3, void(* x4)(void *))
{
  return Tcl_CreateCommand(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_CreateCommand(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  int(* x2)(void *, Tcl_Interp *, int, char const * *);
  void * x3;
  void(* x4)(void *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Tcl_Command result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Tcl_CreateCommand", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (int(*)(void *, Tcl_Interp *, int, char const * *))_cffi_to_c_pointer(arg2, _cffi_type(3));
  if (x2 == (int(*)(void *, Tcl_Interp *, int, char const * *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (void(*)(void *))_cffi_to_c_pointer(arg4, _cffi_type(5));
  if (x4 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_CreateCommand(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(215));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_CreateCommand _cffi_d_Tcl_CreateCommand
#endif

static Tcl_Interp * _cffi_d_Tcl_CreateInterp(void)
{
  return Tcl_CreateInterp();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_CreateInterp(PyObject *self, PyObject *noarg)
{
  Tcl_Interp * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_CreateInterp(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  return pyresult;
}
#else
#  define _cffi_f_Tcl_CreateInterp _cffi_d_Tcl_CreateInterp
#endif

static void _cffi_d_Tcl_DecrRefCount(Tcl_Obj * x0)
{
  Tcl_DecrRefCount(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_DecrRefCount(PyObject *self, PyObject *arg0)
{
  Tcl_Obj * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Tcl_DecrRefCount(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Tcl_DecrRefCount _cffi_d_Tcl_DecrRefCount
#endif

static int _cffi_d_Tcl_DeleteCommand(Tcl_Interp * x0, char const * x1)
{
  return Tcl_DeleteCommand(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_DeleteCommand(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_DeleteCommand", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_DeleteCommand(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_DeleteCommand _cffi_d_Tcl_DeleteCommand
#endif

static void _cffi_d_Tcl_DeleteInterp(Tcl_Interp * x0)
{
  Tcl_DeleteInterp(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_DeleteInterp(PyObject *self, PyObject *arg0)
{
  Tcl_Interp * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Tcl_DeleteInterp(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Tcl_DeleteInterp _cffi_d_Tcl_DeleteInterp
#endif

static int _cffi_d_Tcl_DoOneEvent(int x0)
{
  return Tcl_DoOneEvent(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_DoOneEvent(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_DoOneEvent(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_DoOneEvent _cffi_d_Tcl_DoOneEvent
#endif

static int _cffi_d_Tcl_Eval(Tcl_Interp * x0, char const * x1)
{
  return Tcl_Eval(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_Eval(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_Eval", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_Eval(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_Eval _cffi_d_Tcl_Eval
#endif

static int _cffi_d_Tcl_EvalFile(Tcl_Interp * x0, char const * x1)
{
  return Tcl_EvalFile(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_EvalFile(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_EvalFile", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_EvalFile(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_EvalFile _cffi_d_Tcl_EvalFile
#endif

static int _cffi_d_Tcl_EvalObjv(Tcl_Interp * x0, int x1, Tcl_Obj * * x2, int x3)
{
  return Tcl_EvalObjv(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_EvalObjv(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  int x1;
  Tcl_Obj * * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Tcl_EvalObjv", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(118), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (Tcl_Obj * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(118), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_EvalObjv(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_EvalObjv _cffi_d_Tcl_EvalObjv
#endif

static int _cffi_d_Tcl_ExprBoolean(Tcl_Interp * x0, char const * x1, int * x2)
{
  return Tcl_ExprBoolean(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_ExprBoolean(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Tcl_ExprBoolean", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_ExprBoolean(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_ExprBoolean _cffi_d_Tcl_ExprBoolean
#endif

static int _cffi_d_Tcl_ExprDouble(Tcl_Interp * x0, char const * x1, double * x2)
{
  return Tcl_ExprDouble(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_ExprDouble(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  double * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Tcl_ExprDouble", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(144), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(144), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_ExprDouble(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_ExprDouble _cffi_d_Tcl_ExprDouble
#endif

static int _cffi_d_Tcl_ExprLong(Tcl_Interp * x0, char const * x1, long * x2)
{
  return Tcl_ExprLong(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_ExprLong(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  long * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Tcl_ExprLong", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(154), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(154), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_ExprLong(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_ExprLong _cffi_d_Tcl_ExprLong
#endif

static int _cffi_d_Tcl_ExprString(Tcl_Interp * x0, char const * x1)
{
  return Tcl_ExprString(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_ExprString(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_ExprString", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_ExprString(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_ExprString _cffi_d_Tcl_ExprString
#endif

static void _cffi_d_Tcl_FindExecutable(char * x0)
{
  Tcl_FindExecutable(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_FindExecutable(PyObject *self, PyObject *arg0)
{
  char * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(127), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(127), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Tcl_FindExecutable(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Tcl_FindExecutable _cffi_d_Tcl_FindExecutable
#endif

static void _cffi_d_Tcl_Free(void * x0)
{
  Tcl_Free(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_Free(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(4), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Tcl_Free(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Tcl_Free _cffi_d_Tcl_Free
#endif

static int _cffi_d_Tcl_GetBignumFromObj(Tcl_Interp * x0, Tcl_Obj * x1, mp_int * x2)
{
  return Tcl_GetBignumFromObj(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetBignumFromObj(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  Tcl_Obj * x1;
  mp_int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Tcl_GetBignumFromObj", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (mp_int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetBignumFromObj(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetBignumFromObj _cffi_d_Tcl_GetBignumFromObj
#endif

static int _cffi_d_Tcl_GetBoolean(Tcl_Interp * x0, char const * x1, int * x2)
{
  return Tcl_GetBoolean(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetBoolean(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Tcl_GetBoolean", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetBoolean(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetBoolean _cffi_d_Tcl_GetBoolean
#endif

static int _cffi_d_Tcl_GetBooleanFromObj(Tcl_Interp * x0, Tcl_Obj * x1, int * x2)
{
  return Tcl_GetBooleanFromObj(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetBooleanFromObj(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  Tcl_Obj * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Tcl_GetBooleanFromObj", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetBooleanFromObj(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetBooleanFromObj _cffi_d_Tcl_GetBooleanFromObj
#endif

static unsigned char * _cffi_d_Tcl_GetByteArrayFromObj(Tcl_Obj * x0, int * x1)
{
  return Tcl_GetByteArrayFromObj(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetByteArrayFromObj(PyObject *self, PyObject *args)
{
  Tcl_Obj * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_GetByteArrayFromObj", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetByteArrayFromObj(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(49));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetByteArrayFromObj _cffi_d_Tcl_GetByteArrayFromObj
#endif

static int _cffi_d_Tcl_GetCharLength(Tcl_Obj * x0)
{
  return Tcl_GetCharLength(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetCharLength(PyObject *self, PyObject *arg0)
{
  Tcl_Obj * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetCharLength(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetCharLength _cffi_d_Tcl_GetCharLength
#endif

static Tcl_ThreadId _cffi_d_Tcl_GetCurrentThread(void)
{
  return Tcl_GetCurrentThread();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetCurrentThread(PyObject *self, PyObject *noarg)
{
  Tcl_ThreadId result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetCurrentThread(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(220));
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetCurrentThread _cffi_d_Tcl_GetCurrentThread
#endif

static int _cffi_d_Tcl_GetDouble(Tcl_Interp * x0, char const * x1, double * x2)
{
  return Tcl_GetDouble(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetDouble(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  double * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Tcl_GetDouble", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(144), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (double *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(144), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetDouble(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetDouble _cffi_d_Tcl_GetDouble
#endif

static int _cffi_d_Tcl_GetInt(Tcl_Interp * x0, char const * x1, int * x2)
{
  return Tcl_GetInt(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetInt(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Tcl_GetInt", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetInt(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetInt _cffi_d_Tcl_GetInt
#endif

static Tcl_Obj * _cffi_d_Tcl_GetObjResult(Tcl_Interp * x0)
{
  return Tcl_GetObjResult(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetObjResult(PyObject *self, PyObject *arg0)
{
  Tcl_Interp * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Tcl_Obj * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetObjResult(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetObjResult _cffi_d_Tcl_GetObjResult
#endif

static Tcl_ObjType const * _cffi_d_Tcl_GetObjType(char const * x0)
{
  return Tcl_GetObjType(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetObjType(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Tcl_ObjType const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetObjType(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(218));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetObjType _cffi_d_Tcl_GetObjType
#endif

static char * _cffi_d_Tcl_GetString(Tcl_Obj * x0)
{
  return Tcl_GetString(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetString(PyObject *self, PyObject *arg0)
{
  Tcl_Obj * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetString(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(127));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetString _cffi_d_Tcl_GetString
#endif

static char * _cffi_d_Tcl_GetStringFromObj(Tcl_Obj * x0, int * x1)
{
  return Tcl_GetStringFromObj(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetStringFromObj(PyObject *self, PyObject *args)
{
  Tcl_Obj * x0;
  int * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_GetStringFromObj", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetStringFromObj(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(127));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetStringFromObj _cffi_d_Tcl_GetStringFromObj
#endif

static char const * _cffi_d_Tcl_GetStringResult(Tcl_Interp * x0)
{
  return Tcl_GetStringResult(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetStringResult(PyObject *self, PyObject *arg0)
{
  Tcl_Interp * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetStringResult(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(2));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetStringResult _cffi_d_Tcl_GetStringResult
#endif

static unsigned short * _cffi_d_Tcl_GetUnicode(Tcl_Obj * x0)
{
  return Tcl_GetUnicode(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetUnicode(PyObject *self, PyObject *arg0)
{
  Tcl_Obj * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned short * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetUnicode(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(229));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetUnicode _cffi_d_Tcl_GetUnicode
#endif

static char const * _cffi_d_Tcl_GetVar(Tcl_Interp * x0, char const * x1, int x2)
{
  return Tcl_GetVar(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetVar(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Tcl_GetVar", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetVar(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(2));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetVar _cffi_d_Tcl_GetVar
#endif

static Tcl_Obj * _cffi_d_Tcl_GetVar2Ex(Tcl_Interp * x0, char const * x1, char const * x2, int x3)
{
  return Tcl_GetVar2Ex(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetVar2Ex(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  char const * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Tcl_Obj * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Tcl_GetVar2Ex", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetVar2Ex(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetVar2Ex _cffi_d_Tcl_GetVar2Ex
#endif

static int _cffi_d_Tcl_GetWideIntFromObj(Tcl_Interp * x0, Tcl_Obj * x1, Tcl_WideInt * x2)
{
  return Tcl_GetWideIntFromObj(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_GetWideIntFromObj(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  Tcl_Obj * x1;
  Tcl_WideInt * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Tcl_GetWideIntFromObj", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(101), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (Tcl_WideInt *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(101), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_GetWideIntFromObj(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_GetWideIntFromObj _cffi_d_Tcl_GetWideIntFromObj
#endif

static void _cffi_d_Tcl_IncrRefCount(Tcl_Obj * x0)
{
  Tcl_IncrRefCount(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_IncrRefCount(PyObject *self, PyObject *arg0)
{
  Tcl_Obj * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Tcl_IncrRefCount(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Tcl_IncrRefCount _cffi_d_Tcl_IncrRefCount
#endif

static int _cffi_d_Tcl_Init(Tcl_Interp * x0)
{
  return Tcl_Init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_Init(PyObject *self, PyObject *arg0)
{
  Tcl_Interp * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_Init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_Init _cffi_d_Tcl_Init
#endif

static int _cffi_d_Tcl_ListObjGetElements(Tcl_Interp * x0, Tcl_Obj * x1, int * x2, Tcl_Obj * * * x3)
{
  return Tcl_ListObjGetElements(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_ListObjGetElements(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  Tcl_Obj * x1;
  int * x2;
  Tcl_Obj * * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Tcl_ListObjGetElements", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(112), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (Tcl_Obj * * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(112), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_ListObjGetElements(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_ListObjGetElements _cffi_d_Tcl_ListObjGetElements
#endif

static int _cffi_d_Tcl_ListObjIndex(Tcl_Interp * x0, Tcl_Obj * x1, int x2, Tcl_Obj * * x3)
{
  return Tcl_ListObjIndex(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_ListObjIndex(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  Tcl_Obj * x1;
  int x2;
  Tcl_Obj * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Tcl_ListObjIndex", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(118), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (Tcl_Obj * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(118), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_ListObjIndex(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_ListObjIndex _cffi_d_Tcl_ListObjIndex
#endif

static int _cffi_d_Tcl_ListObjLength(Tcl_Interp * x0, Tcl_Obj * x1, int * x2)
{
  return Tcl_ListObjLength(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_ListObjLength(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  Tcl_Obj * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Tcl_ListObjLength", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_ListObjLength(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_ListObjLength _cffi_d_Tcl_ListObjLength
#endif

static char * _cffi_d_Tcl_Merge(int x0, char const * const * x1)
{
  return Tcl_Merge(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_Merge(PyObject *self, PyObject *args)
{
  int x0;
  char const * const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_Merge", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(70), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const * const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(70), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_Merge(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(127));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_Merge _cffi_d_Tcl_Merge
#endif

static Tcl_Obj * _cffi_d_Tcl_NewBignumObj(mp_int * x0)
{
  return Tcl_NewBignumObj(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_NewBignumObj(PyObject *self, PyObject *arg0)
{
  mp_int * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Tcl_Obj * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (mp_int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_NewBignumObj(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_NewBignumObj _cffi_d_Tcl_NewBignumObj
#endif

static Tcl_Obj * _cffi_d_Tcl_NewBooleanObj(int x0)
{
  return Tcl_NewBooleanObj(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_NewBooleanObj(PyObject *self, PyObject *arg0)
{
  int x0;
  Tcl_Obj * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_NewBooleanObj(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  return pyresult;
}
#else
#  define _cffi_f_Tcl_NewBooleanObj _cffi_d_Tcl_NewBooleanObj
#endif

static Tcl_Obj * _cffi_d_Tcl_NewByteArrayObj(unsigned char * x0, int x1)
{
  return Tcl_NewByteArrayObj(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_NewByteArrayObj(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Tcl_Obj * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_NewByteArrayObj", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_NewByteArrayObj(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_NewByteArrayObj _cffi_d_Tcl_NewByteArrayObj
#endif

static Tcl_Obj * _cffi_d_Tcl_NewDoubleObj(double x0)
{
  return Tcl_NewDoubleObj(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_NewDoubleObj(PyObject *self, PyObject *arg0)
{
  double x0;
  Tcl_Obj * result;
  PyObject *pyresult;

  x0 = (double)_cffi_to_c_double(arg0);
  if (x0 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_NewDoubleObj(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  return pyresult;
}
#else
#  define _cffi_f_Tcl_NewDoubleObj _cffi_d_Tcl_NewDoubleObj
#endif

static Tcl_Obj * _cffi_d_Tcl_NewListObj(int x0, Tcl_Obj * const * x1)
{
  return Tcl_NewListObj(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_NewListObj(PyObject *self, PyObject *args)
{
  int x0;
  Tcl_Obj * const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Tcl_Obj * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_NewListObj", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (Tcl_Obj * const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_NewListObj(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_NewListObj _cffi_d_Tcl_NewListObj
#endif

static Tcl_Obj * _cffi_d_Tcl_NewLongObj(long x0)
{
  return Tcl_NewLongObj(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_NewLongObj(PyObject *self, PyObject *arg0)
{
  long x0;
  Tcl_Obj * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, long);
  if (x0 == (long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_NewLongObj(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  return pyresult;
}
#else
#  define _cffi_f_Tcl_NewLongObj _cffi_d_Tcl_NewLongObj
#endif

static Tcl_Obj * _cffi_d_Tcl_NewStringObj(char const * x0, int x1)
{
  return Tcl_NewStringObj(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_NewStringObj(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Tcl_Obj * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_NewStringObj", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_NewStringObj(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_NewStringObj _cffi_d_Tcl_NewStringObj
#endif

static Tcl_Obj * _cffi_d_Tcl_NewUnicodeObj(unsigned short const * x0, int x1)
{
  return Tcl_NewUnicodeObj(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_NewUnicodeObj(PyObject *self, PyObject *args)
{
  unsigned short const * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Tcl_Obj * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_NewUnicodeObj", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(53), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (unsigned short const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(53), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_NewUnicodeObj(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_NewUnicodeObj _cffi_d_Tcl_NewUnicodeObj
#endif

static Tcl_Obj * _cffi_d_Tcl_NewWideIntObj(Tcl_WideInt x0)
{
  return Tcl_NewWideIntObj(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_NewWideIntObj(PyObject *self, PyObject *arg0)
{
  Tcl_WideInt x0;
  Tcl_Obj * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, Tcl_WideInt);
  if (x0 == (Tcl_WideInt)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_NewWideIntObj(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  return pyresult;
}
#else
#  define _cffi_f_Tcl_NewWideIntObj _cffi_d_Tcl_NewWideIntObj
#endif

static void _cffi_d_Tcl_SetObjResult(Tcl_Interp * x0, Tcl_Obj * x1)
{
  Tcl_SetObjResult(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_SetObjResult(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  Tcl_Obj * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Tcl_SetObjResult", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Tcl_SetObjResult(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Tcl_SetObjResult _cffi_d_Tcl_SetObjResult
#endif

static char const * _cffi_d_Tcl_SetVar(Tcl_Interp * x0, char const * x1, char const * x2, int x3)
{
  return Tcl_SetVar(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_SetVar(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  char const * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Tcl_SetVar", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_SetVar(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(2));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_SetVar _cffi_d_Tcl_SetVar
#endif

static char const * _cffi_d_Tcl_SetVar2(Tcl_Interp * x0, char const * x1, char const * x2, char const * x3, int x4)
{
  return Tcl_SetVar2(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_SetVar2(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  char const * x2;
  char const * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Tcl_SetVar2", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_SetVar2(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(2));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_SetVar2 _cffi_d_Tcl_SetVar2
#endif

static Tcl_Obj * _cffi_d_Tcl_SetVar2Ex(Tcl_Interp * x0, char const * x1, char const * x2, Tcl_Obj * x3, int x4)
{
  return Tcl_SetVar2Ex(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_SetVar2Ex(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  char const * x2;
  Tcl_Obj * x3;
  int x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Tcl_Obj * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Tcl_SetVar2Ex", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(16), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (Tcl_Obj *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(16), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, int);
  if (x4 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_SetVar2Ex(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(16));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_SetVar2Ex _cffi_d_Tcl_SetVar2Ex
#endif

static int _cffi_d_Tcl_SplitList(Tcl_Interp * x0, char * x1, int * x2, char const * * * x3)
{
  return Tcl_SplitList(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_SplitList(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char * x1;
  int * x2;
  char const * * * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Tcl_SplitList", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(127), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(127), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(66), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(66), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(129), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (char const * * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(129), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_SplitList(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_SplitList _cffi_d_Tcl_SplitList
#endif

static int _cffi_d_Tcl_UnsetVar2(Tcl_Interp * x0, char const * x1, char const * x2, int x3)
{
  return Tcl_UnsetVar2(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tcl_UnsetVar2(PyObject *self, PyObject *args)
{
  Tcl_Interp * x0;
  char const * x1;
  char const * x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Tcl_UnsetVar2", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tcl_UnsetVar2(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tcl_UnsetVar2 _cffi_d_Tcl_UnsetVar2
#endif

static int _cffi_d_Tk_GetNumMainWindows(void)
{
  return Tk_GetNumMainWindows();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tk_GetNumMainWindows(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tk_GetNumMainWindows(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_Tk_GetNumMainWindows _cffi_d_Tk_GetNumMainWindows
#endif

static int _cffi_d_Tk_Init(Tcl_Interp * x0)
{
  return Tk_Init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Tk_Init(PyObject *self, PyObject *arg0)
{
  Tcl_Interp * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (Tcl_Interp *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Tk_Init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Tk_Init _cffi_d_Tk_Init
#endif

static char * _cffi_d_get_tcl_patch_level(void)
{
  return get_tcl_patch_level();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_get_tcl_patch_level(PyObject *self, PyObject *noarg)
{
  char * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = get_tcl_patch_level(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(127));
  return pyresult;
}
#else
#  define _cffi_f_get_tcl_patch_level _cffi_d_get_tcl_patch_level
#endif

static char * _cffi_d_get_tcl_version(void)
{
  return get_tcl_version();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_get_tcl_version(PyObject *self, PyObject *noarg)
{
  char * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = get_tcl_version(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(127));
  return pyresult;
}
#else
#  define _cffi_f_get_tcl_version _cffi_d_get_tcl_version
#endif

static char * _cffi_d_get_tk_patch_level(void)
{
  return get_tk_patch_level();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_get_tk_patch_level(PyObject *self, PyObject *noarg)
{
  char * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = get_tk_patch_level(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(127));
  return pyresult;
}
#else
#  define _cffi_f_get_tk_patch_level _cffi_d_get_tk_patch_level
#endif

static char * _cffi_d_get_tk_version(void)
{
  return get_tk_version();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_get_tk_version(PyObject *self, PyObject *noarg)
{
  char * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = get_tk_version(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(127));
  return pyresult;
}
#else
#  define _cffi_f_get_tk_version _cffi_d_get_tk_version
#endif

static void _cffi_d_mp_clear(mp_int * x0)
{
  mp_clear(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mp_clear(PyObject *self, PyObject *arg0)
{
  mp_int * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (mp_int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { mp_clear(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_mp_clear _cffi_d_mp_clear
#endif

static int _cffi_d_mp_init(mp_int * x0)
{
  return mp_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mp_init(PyObject *self, PyObject *arg0)
{
  mp_int * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (mp_int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mp_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mp_init _cffi_d_mp_init
#endif

static int _cffi_d_mp_read_radix(mp_int * x0, char const * x1, int x2)
{
  return mp_read_radix(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mp_read_radix(PyObject *self, PyObject *args)
{
  mp_int * x0;
  char const * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mp_read_radix", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (mp_int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(2), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(2), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mp_read_radix(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mp_read_radix _cffi_d_mp_read_radix
#endif

static int _cffi_d_mp_to_unsigned_bin_n(mp_int * x0, unsigned char * x1, unsigned long * x2)
{
  return mp_to_unsigned_bin_n(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mp_to_unsigned_bin_n(PyObject *self, PyObject *args)
{
  mp_int * x0;
  unsigned char * x1;
  unsigned long * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "mp_to_unsigned_bin_n", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (mp_int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(179), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (unsigned long *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(179), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mp_to_unsigned_bin_n(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mp_to_unsigned_bin_n _cffi_d_mp_to_unsigned_bin_n
#endif

static int _cffi_d_mp_unsigned_bin_size(mp_int * x0)
{
  return mp_unsigned_bin_size(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_mp_unsigned_bin_size(PyObject *self, PyObject *arg0)
{
  mp_int * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (mp_int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = mp_unsigned_bin_size(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_mp_unsigned_bin_size _cffi_d_mp_unsigned_bin_size
#endif

static int _cffi_const_HAVE_LIBTOMMATH(unsigned long long *o)
{
  int n = (HAVE_LIBTOMMATH) <= 0;
  *o = (unsigned long long)((HAVE_LIBTOMMATH) | 0);  /* check that HAVE_LIBTOMMATH is an integer */
  return n;
}

static int _cffi_const_HAVE_WIDE_INT_TYPE(unsigned long long *o)
{
  int n = (HAVE_WIDE_INT_TYPE) <= 0;
  *o = (unsigned long long)((HAVE_WIDE_INT_TYPE) | 0);  /* check that HAVE_WIDE_INT_TYPE is an integer */
  return n;
}

static int _cffi_const_MP_NEG(unsigned long long *o)
{
  int n = (MP_NEG) <= 0;
  *o = (unsigned long long)((MP_NEG) | 0);  /* check that MP_NEG is an integer */
  return n;
}

static int _cffi_const_MP_OKAY(unsigned long long *o)
{
  int n = (MP_OKAY) <= 0;
  *o = (unsigned long long)((MP_OKAY) | 0);  /* check that MP_OKAY is an integer */
  return n;
}

static int _cffi_const_MP_ZPOS(unsigned long long *o)
{
  int n = (MP_ZPOS) <= 0;
  *o = (unsigned long long)((MP_ZPOS) | 0);  /* check that MP_ZPOS is an integer */
  return n;
}

static int _cffi_const_TCL_DONT_WAIT(unsigned long long *o)
{
  int n = (TCL_DONT_WAIT) <= 0;
  *o = (unsigned long long)((TCL_DONT_WAIT) | 0);  /* check that TCL_DONT_WAIT is an integer */
  return n;
}

static int _cffi_const_TCL_ERROR(unsigned long long *o)
{
  int n = (TCL_ERROR) <= 0;
  *o = (unsigned long long)((TCL_ERROR) | 0);  /* check that TCL_ERROR is an integer */
  return n;
}

static int _cffi_const_TCL_EVAL_DIRECT(unsigned long long *o)
{
  int n = (TCL_EVAL_DIRECT) <= 0;
  *o = (unsigned long long)((TCL_EVAL_DIRECT) | 0);  /* check that TCL_EVAL_DIRECT is an integer */
  return n;
}

static int _cffi_const_TCL_EVAL_GLOBAL(unsigned long long *o)
{
  int n = (TCL_EVAL_GLOBAL) <= 0;
  *o = (unsigned long long)((TCL_EVAL_GLOBAL) | 0);  /* check that TCL_EVAL_GLOBAL is an integer */
  return n;
}

static int _cffi_const_TCL_EXCEPTION(unsigned long long *o)
{
  int n = (TCL_EXCEPTION) <= 0;
  *o = (unsigned long long)((TCL_EXCEPTION) | 0);  /* check that TCL_EXCEPTION is an integer */
  return n;
}

static int _cffi_const_TCL_GLOBAL_ONLY(unsigned long long *o)
{
  int n = (TCL_GLOBAL_ONLY) <= 0;
  *o = (unsigned long long)((TCL_GLOBAL_ONLY) | 0);  /* check that TCL_GLOBAL_ONLY is an integer */
  return n;
}

static int _cffi_const_TCL_LEAVE_ERR_MSG(unsigned long long *o)
{
  int n = (TCL_LEAVE_ERR_MSG) <= 0;
  *o = (unsigned long long)((TCL_LEAVE_ERR_MSG) | 0);  /* check that TCL_LEAVE_ERR_MSG is an integer */
  return n;
}

static int _cffi_const_TCL_OK(unsigned long long *o)
{
  int n = (TCL_OK) <= 0;
  *o = (unsigned long long)((TCL_OK) | 0);  /* check that TCL_OK is an integer */
  return n;
}

static int _cffi_const_TCL_READABLE(unsigned long long *o)
{
  int n = (TCL_READABLE) <= 0;
  *o = (unsigned long long)((TCL_READABLE) | 0);  /* check that TCL_READABLE is an integer */
  return n;
}

static int _cffi_const_TCL_WRITABLE(unsigned long long *o)
{
  int n = (TCL_WRITABLE) <= 0;
  *o = (unsigned long long)((TCL_WRITABLE) | 0);  /* check that TCL_WRITABLE is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld__Tcl_Obj(Tcl_Obj *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->bytes; (void)tmp; }
  (void)((p->length) | 0);  /* check that 'Tcl_Obj.length' is an integer */
  { Tcl_ObjType const * *tmp = &p->typePtr; (void)tmp; }
  /* cannot generate 'union $1' in field 'internalRep': unknown type name */
}
struct _cffi_align__Tcl_Obj { char x; Tcl_Obj y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__Tcl_ObjType(Tcl_ObjType *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
}
struct _cffi_align__Tcl_ObjType { char x; Tcl_ObjType y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "HAVE_LIBTOMMATH", (void *)_cffi_const_HAVE_LIBTOMMATH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "HAVE_WIDE_INT_TYPE", (void *)_cffi_const_HAVE_WIDE_INT_TYPE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "MP_NEG", (void *)_cffi_const_MP_NEG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "MP_OKAY", (void *)_cffi_const_MP_OKAY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "MP_ZPOS", (void *)_cffi_const_MP_ZPOS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TCL_DONT_WAIT", (void *)_cffi_const_TCL_DONT_WAIT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TCL_ERROR", (void *)_cffi_const_TCL_ERROR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TCL_EVAL_DIRECT", (void *)_cffi_const_TCL_EVAL_DIRECT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TCL_EVAL_GLOBAL", (void *)_cffi_const_TCL_EVAL_GLOBAL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TCL_EXCEPTION", (void *)_cffi_const_TCL_EXCEPTION, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TCL_GLOBAL_ONLY", (void *)_cffi_const_TCL_GLOBAL_ONLY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TCL_LEAVE_ERR_MSG", (void *)_cffi_const_TCL_LEAVE_ERR_MSG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TCL_OK", (void *)_cffi_const_TCL_OK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TCL_READABLE", (void *)_cffi_const_TCL_READABLE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TCL_WRITABLE", (void *)_cffi_const_TCL_WRITABLE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Tcl_CreateCommand", (void *)_cffi_f_Tcl_CreateCommand, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 0), (void *)_cffi_d_Tcl_CreateCommand },
  { "Tcl_CreateInterp", (void *)_cffi_f_Tcl_CreateInterp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 7), (void *)_cffi_d_Tcl_CreateInterp },
  { "Tcl_DecrRefCount", (void *)_cffi_f_Tcl_DecrRefCount, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 203), (void *)_cffi_d_Tcl_DecrRefCount },
  { "Tcl_DeleteCommand", (void *)_cffi_f_Tcl_DeleteCommand, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 131), (void *)_cffi_d_Tcl_DeleteCommand },
  { "Tcl_DeleteInterp", (void *)_cffi_f_Tcl_DeleteInterp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 196), (void *)_cffi_d_Tcl_DeleteInterp },
  { "Tcl_DoOneEvent", (void *)_cffi_f_Tcl_DoOneEvent, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 165), (void *)_cffi_d_Tcl_DoOneEvent },
  { "Tcl_Eval", (void *)_cffi_f_Tcl_Eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 131), (void *)_cffi_d_Tcl_Eval },
  { "Tcl_EvalFile", (void *)_cffi_f_Tcl_EvalFile, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 131), (void *)_cffi_d_Tcl_EvalFile },
  { "Tcl_EvalObjv", (void *)_cffi_f_Tcl_EvalObjv, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 156), (void *)_cffi_d_Tcl_EvalObjv },
  { "Tcl_ExprBoolean", (void *)_cffi_f_Tcl_ExprBoolean, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 146), (void *)_cffi_d_Tcl_ExprBoolean },
  { "Tcl_ExprDouble", (void *)_cffi_f_Tcl_ExprDouble, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 141), (void *)_cffi_d_Tcl_ExprDouble },
  { "Tcl_ExprLong", (void *)_cffi_f_Tcl_ExprLong, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 151), (void *)_cffi_d_Tcl_ExprLong },
  { "Tcl_ExprString", (void *)_cffi_f_Tcl_ExprString, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 131), (void *)_cffi_d_Tcl_ExprString },
  { "Tcl_FindExecutable", (void *)_cffi_f_Tcl_FindExecutable, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 206), (void *)_cffi_d_Tcl_FindExecutable },
  { "Tcl_Free", (void *)_cffi_f_Tcl_Free, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 212), (void *)_cffi_d_Tcl_Free },
  { "Tcl_GetBignumFromObj", (void *)_cffi_f_Tcl_GetBignumFromObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 120), (void *)_cffi_d_Tcl_GetBignumFromObj },
  { "Tcl_GetBoolean", (void *)_cffi_f_Tcl_GetBoolean, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 146), (void *)_cffi_d_Tcl_GetBoolean },
  { "Tcl_GetBooleanFromObj", (void *)_cffi_f_Tcl_GetBooleanFromObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 103), (void *)_cffi_d_Tcl_GetBooleanFromObj },
  { "Tcl_GetByteArrayFromObj", (void *)_cffi_f_Tcl_GetByteArrayFromObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 189), (void *)_cffi_d_Tcl_GetByteArrayFromObj },
  { "Tcl_GetCharLength", (void *)_cffi_f_Tcl_GetCharLength, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 162), (void *)_cffi_d_Tcl_GetCharLength },
  { "Tcl_GetCurrentThread", (void *)_cffi_f_Tcl_GetCurrentThread, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 59), (void *)_cffi_d_Tcl_GetCurrentThread },
  { "Tcl_GetDouble", (void *)_cffi_f_Tcl_GetDouble, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 141), (void *)_cffi_d_Tcl_GetDouble },
  { "Tcl_GetInt", (void *)_cffi_f_Tcl_GetInt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 146), (void *)_cffi_d_Tcl_GetInt },
  { "Tcl_GetObjResult", (void *)_cffi_f_Tcl_GetObjResult, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 9), (void *)_cffi_d_Tcl_GetObjResult },
  { "Tcl_GetObjType", (void *)_cffi_f_Tcl_GetObjType, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 56), (void *)_cffi_d_Tcl_GetObjType },
  { "Tcl_GetString", (void *)_cffi_f_Tcl_GetString, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 61), (void *)_cffi_d_Tcl_GetString },
  { "Tcl_GetStringFromObj", (void *)_cffi_f_Tcl_GetStringFromObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 64), (void *)_cffi_d_Tcl_GetStringFromObj },
  { "Tcl_GetStringResult", (void *)_cffi_f_Tcl_GetStringResult, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 74), (void *)_cffi_d_Tcl_GetStringResult },
  { "Tcl_GetUnicode", (void *)_cffi_f_Tcl_GetUnicode, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 193), (void *)_cffi_d_Tcl_GetUnicode },
  { "Tcl_GetVar", (void *)_cffi_f_Tcl_GetVar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 90), (void *)_cffi_d_Tcl_GetVar },
  { "Tcl_GetVar2Ex", (void *)_cffi_f_Tcl_GetVar2Ex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 19), (void *)_cffi_d_Tcl_GetVar2Ex },
  { "Tcl_GetWideIntFromObj", (void *)_cffi_f_Tcl_GetWideIntFromObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 98), (void *)_cffi_d_Tcl_GetWideIntFromObj },
  { "Tcl_IncrRefCount", (void *)_cffi_f_Tcl_IncrRefCount, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 203), (void *)_cffi_d_Tcl_IncrRefCount },
  { "Tcl_Init", (void *)_cffi_f_Tcl_Init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 95), (void *)_cffi_d_Tcl_Init },
  { "Tcl_ListObjGetElements", (void *)_cffi_f_Tcl_ListObjGetElements, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 108), (void *)_cffi_d_Tcl_ListObjGetElements },
  { "Tcl_ListObjIndex", (void *)_cffi_f_Tcl_ListObjIndex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 114), (void *)_cffi_d_Tcl_ListObjIndex },
  { "Tcl_ListObjLength", (void *)_cffi_f_Tcl_ListObjLength, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 103), (void *)_cffi_d_Tcl_ListObjLength },
  { "Tcl_Merge", (void *)_cffi_f_Tcl_Merge, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 68), (void *)_cffi_d_Tcl_Merge },
  { "Tcl_NewBignumObj", (void *)_cffi_f_Tcl_NewBignumObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 45), (void *)_cffi_d_Tcl_NewBignumObj },
  { "Tcl_NewBooleanObj", (void *)_cffi_f_Tcl_NewBooleanObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 35), (void *)_cffi_d_Tcl_NewBooleanObj },
  { "Tcl_NewByteArrayObj", (void *)_cffi_f_Tcl_NewByteArrayObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 48), (void *)_cffi_d_Tcl_NewByteArrayObj },
  { "Tcl_NewDoubleObj", (void *)_cffi_f_Tcl_NewDoubleObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 32), (void *)_cffi_d_Tcl_NewDoubleObj },
  { "Tcl_NewListObj", (void *)_cffi_f_Tcl_NewListObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 38), (void *)_cffi_d_Tcl_NewListObj },
  { "Tcl_NewLongObj", (void *)_cffi_f_Tcl_NewLongObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 42), (void *)_cffi_d_Tcl_NewLongObj },
  { "Tcl_NewStringObj", (void *)_cffi_f_Tcl_NewStringObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 28), (void *)_cffi_d_Tcl_NewStringObj },
  { "Tcl_NewUnicodeObj", (void *)_cffi_f_Tcl_NewUnicodeObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 52), (void *)_cffi_d_Tcl_NewUnicodeObj },
  { "Tcl_NewWideIntObj", (void *)_cffi_f_Tcl_NewWideIntObj, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 25), (void *)_cffi_d_Tcl_NewWideIntObj },
  { "Tcl_SetObjResult", (void *)_cffi_f_Tcl_SetObjResult, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 199), (void *)_cffi_d_Tcl_SetObjResult },
  { "Tcl_SetVar", (void *)_cffi_f_Tcl_SetVar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 84), (void *)_cffi_d_Tcl_SetVar },
  { "Tcl_SetVar2", (void *)_cffi_f_Tcl_SetVar2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_Tcl_SetVar2 },
  { "Tcl_SetVar2Ex", (void *)_cffi_f_Tcl_SetVar2Ex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 12), (void *)_cffi_d_Tcl_SetVar2Ex },
  { "Tcl_SplitList", (void *)_cffi_f_Tcl_SplitList, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 125), (void *)_cffi_d_Tcl_SplitList },
  { "Tcl_UnsetVar2", (void *)_cffi_f_Tcl_UnsetVar2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 135), (void *)_cffi_d_Tcl_UnsetVar2 },
  { "Tk_GetNumMainWindows", (void *)_cffi_f_Tk_GetNumMainWindows, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 187), (void *)_cffi_d_Tk_GetNumMainWindows },
  { "Tk_Init", (void *)_cffi_f_Tk_Init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 95), (void *)_cffi_d_Tk_Init },
  { "get_tcl_patch_level", (void *)_cffi_f_get_tcl_patch_level, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 72), (void *)_cffi_d_get_tcl_patch_level },
  { "get_tcl_version", (void *)_cffi_f_get_tcl_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 72), (void *)_cffi_d_get_tcl_version },
  { "get_tk_patch_level", (void *)_cffi_f_get_tk_patch_level, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 72), (void *)_cffi_d_get_tk_patch_level },
  { "get_tk_version", (void *)_cffi_f_get_tk_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 72), (void *)_cffi_d_get_tk_version },
  { "mp_clear", (void *)_cffi_f_mp_clear, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 209), (void *)_cffi_d_mp_clear },
  { "mp_init", (void *)_cffi_f_mp_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 168), (void *)_cffi_d_mp_init },
  { "mp_read_radix", (void *)_cffi_f_mp_read_radix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 171), (void *)_cffi_d_mp_read_radix },
  { "mp_to_unsigned_bin_n", (void *)_cffi_f_mp_to_unsigned_bin_n, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 176), (void *)_cffi_d_mp_to_unsigned_bin_n },
  { "mp_unsigned_bin_size", (void *)_cffi_f_mp_unsigned_bin_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 168), (void *)_cffi_d_mp_unsigned_bin_size },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "sign", offsetof(mp_int, sign),
            sizeof(((mp_int *)0)->sign),
            _CFFI_OP(_CFFI_OP_NOOP, 17) },
  { "bytes", offsetof(Tcl_Obj, bytes),
             sizeof(((Tcl_Obj *)0)->bytes),
             _CFFI_OP(_CFFI_OP_NOOP, 127) },
  { "length", offsetof(Tcl_Obj, length),
              sizeof(((Tcl_Obj *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 17) },
  { "typePtr", offsetof(Tcl_Obj, typePtr),
               sizeof(((Tcl_Obj *)0)->typePtr),
               _CFFI_OP(_CFFI_OP_NOOP, 218) },
  { "internalRep", offsetof(Tcl_Obj, internalRep),
                   sizeof(((Tcl_Obj *)0)->internalRep),
                   _CFFI_OP(_CFFI_OP_NOOP, 226) },
  { "name", offsetof(Tcl_ObjType, name),
            sizeof(((Tcl_ObjType *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 2) },
  { "longValue", (size_t)-1,
                 (size_t)-1,
                 _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "doubleValue", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 33) },
  { "twoPtrValue", (size_t)-1,
                   (size_t)-1,
                   _CFFI_OP(_CFFI_OP_NOOP, 225) },
  { "ptr1", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "ptr2", (size_t)-1,
            (size_t)-1,
            _CFFI_OP(_CFFI_OP_NOOP, 4) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$$Tcl_Command", 223, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$$Tcl_ThreadId", 224, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$1", 226, _CFFI_F_UNION|_CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 6, 3 /* unnamed */ },
  { "$2", 225, _CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 9, 2 /* unnamed */ },
  { "$Tcl_Interp", 216, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "$mp_int", 222, 0,
    sizeof(mp_int), offsetof(struct _cffi_align_typedef_mp_int, y), 0, 1 },
  { "Tcl_Obj", 217, 0,
    sizeof(Tcl_Obj), offsetof(struct _cffi_align__Tcl_Obj, y), 1, 4 },
  { "Tcl_ObjType", 219, 0,
    sizeof(Tcl_ObjType), offsetof(struct _cffi_align__Tcl_ObjType, y), 5, 1 },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "ClientData", 4 },
  { "Tcl_CmdDeleteProc", 212 },
  { "Tcl_CmdProc", 181 },
  { "Tcl_Command", 215 },
  { "Tcl_Interp", 216 },
  { "Tcl_Obj", 217 },
  { "Tcl_ObjType", 219 },
  { "Tcl_ThreadId", 220 },
  { "Tcl_UniChar", 230 },
  { "Tcl_WideInt", 26 },
  { "mp_int", 222 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  NULL,  /* no enums */
  _cffi_typenames,
  79,  /* num_globals */
  8,  /* num_struct_unions */
  0,  /* num_enums */
  11,  /* num_typenames */
  NULL,  /* no includes */
  232,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit_tklib_cffi(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit_tklib_cffi(void) { return NULL; }
#  else
     inittklib_cffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit_tklib_cffi(void)
{
  return _cffi_init("_tkinter.tklib_cffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
inittklib_cffi(void)
{
  _cffi_init("_tkinter.tklib_cffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
