/**
 * @file bcsc_d.h
 *
 * @copyright 2004-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author Mathieu Faverge
 * @author Pierre Ramet
 * @author Xavier Lacoste
 * @author Vincent Bridonneau
 * @date 2024-07-05
 *
 * @generated from /build/pastix/src/pastix-6.4.0/bcsc/bcsc_z.h, normal z -> d, Tue Dec 16 21:22:40 2025
 *
 **/
#ifndef _bcsc_d_h_
#define _bcsc_d_h_

/**
 * @addtogroup bcsc_internal
 * @{
 *
 *    @name PastixDouble initialization functions
 *    @{
 */
void bcsc_dinit( const spmatrix_t     *spm,
                 const pastix_order_t *ord,
                 const SolverMatrix   *solvmtx,
                 int                   initAt,
                 pastix_bcsc_t        *bcsc,
                 pastix_int_t          valuesize );

#if defined(PASTIX_WITH_MPI)
void bcsc_dstore_data( const spmatrix_t     *spm,
                       const pastix_order_t *ord,
                       const pastix_int_t   *col2cblk,
                       bcsc_handle_comm_t   *bcsc_comm );
#endif

/**
 *   @}
 * @}
 *
 * @addtogroup bcsc
 * @{
 *
 *    @name PastixDouble vector(s) operations
 *    @{
 */
void bvec_daxpy_seq( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     double        alpha,
                     const double *x,
                     double       *y );
void bvec_daxpy_smp( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     double        alpha,
                     const double *x,
                     double       *y );

void bvec_dcopy_seq( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     const double *x,
                     double       *y );
void bvec_dcopy_smp( pastix_data_t            *pastix_data,
                     pastix_int_t              n,
                     const double *x,
                     double       *y );

#if defined(PRECISION_z) || defined(PRECISION_c)
double bvec_ddot_seq( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const double *x,
                                   const double *y );
double bvec_ddot_smp( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const double *x,
                                   const double *y );
#endif

double bvec_ddot_seq( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const double *x,
                                   const double *y );
double bvec_ddot_smp( pastix_data_t            *pastix_data,
                                   pastix_int_t              n,
                                   const double *x,
                                   const double *y );

void bvec_dgemv_seq( pastix_data_t            *pastix_data,
                     pastix_int_t              m,
                     pastix_int_t              n,
                     double        alpha,
                     const double *A,
                     pastix_int_t              lda,
                     const double *x,
                     double        beta,
                     double       *y );
void bvec_dgemv_smp( pastix_data_t            *pastix_data,
                     pastix_int_t              m,
                     pastix_int_t              n,
                     double        alpha,
                     const double *A,
                     pastix_int_t              lda,
                     const double *x,
                     double        beta,
                     double       *y );

double bvec_dnrm2_seq( pastix_data_t            *pastix_data,
                       pastix_int_t              n,
                       const double *x );
double bvec_dnrm2_smp( pastix_data_t            *pastix_data,
                       pastix_int_t              n,
                       const double *x );

void bvec_dscal_seq( pastix_data_t      *pastix_data,
                     pastix_int_t        n,
                     double  alpha,
                     double *x );
void bvec_dscal_smp( pastix_data_t      *pastix_data,
                     pastix_int_t        n,
                     double  alpha,
                     double *x );

#if defined( PASTIX_WITH_MPI )
int bvec_dexchange_data_rep( pastix_data_t      *pastix_data,
                             pastix_int_t        nrhs,
                             double *b,
                             pastix_int_t        ldb,
                             pastix_rhs_t        Pb );
int bvec_dallocate_buf_dst( bvec_handle_comm_t *rhs_comm );
int bvec_dexchange_data_dst( pastix_data_t      *pastix_data,
                             pastix_dir_t        dir,
                             pastix_int_t        nrhs,
                             double *b,
                             pastix_int_t        ldb,
                             pastix_rhs_t        Pb,
                             const pastix_int_t *glob2loc );
#endif

int bvec_dlapmr( pastix_data_t      *pastix_data,
                 pastix_dir_t        dir,
                 pastix_int_t        m,
                 pastix_int_t        n,
                 double *A,
                 pastix_int_t        lda,
                 pastix_rhs_t        PA );

/**
 *    @}
 *
 *    @name PastixDouble matrix operations
 *    @{
 */
double bcsc_dnorm( pastix_normtype_t    ntype,
                   const pastix_bcsc_t *bcsc );

void bcsc_dspsv( pastix_data_t      *pastix_data,
                 double *b,
                 float *work );

void bcsc_dspmv( const pastix_data_t      *pastix_data,
                 pastix_trans_t            trans,
                 double        alpha,
                 const double *x,
                 double        beta,
                 double       *y );

void bcsc_dspmv_seq( const pastix_data_t      *pastix_data,
                     pastix_trans_t            trans,
                     double        alpha,
                     const double *x,
                     double        beta,
                     double       *y );
void bcsc_dspmv_smp( const pastix_data_t      *pastix_data,
                     pastix_trans_t            trans,
                     double        alpha,
                     const double *x,
                     double        beta,
                     double       *y );

/**
 *    @}
 *
 *    @name PastixDouble MPI vector operations
 *    @{
 */
const double *bvec_dgather_remote( const pastix_data_t      *pastix_data,
                                               const double *y );
void bvec_dnullify_remote( const pastix_data_t *pastix_data,
                           double  *y );
void bvec_dallreduce( const pastix_data_t *pastix_data,
                      double  *y );
/**
 *    @}
 * @}
 */
#endif /* _bcsc_d_h_ */
