/* Application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Application.vala, do not modify */

/*
* Copyright 2017-2020 elementary, Inc. (https://elementary.io)
*           2014-2016 Fabio Zaramella <ffabio.96.x@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License version 3 as published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <libportal/portal.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include <locale.h>

#define SCREENSHOT_APPLICATION_SAVE_FOLDER _ ("Screenshots")
#define SCREENSHOT_APPLICATION_CAPTURE_AREA N_ ("Capture area")
#define SCREENSHOT_APPLICATION_CAPTURE_STRING N_ ("Capture the whole screen")
#define SCREENSHOT_APPLICATION_CAPTURE_WIN N_ ("Capture active window")
#define SCREENSHOT_APPLICATION_DELAY N_ ("Take screenshot after specified delay")
#define SCREENSHOT_APPLICATION_SECONDS N_ ("Seconds")
#define SCREENSHOT_APPLICATION_INCLUDE_POINTER N_ ("Include the pointer with the screenshot")
#define SCREENSHOT_APPLICATION_REDACT_TEXT N_ ("Redact system text")
#define SCREENSHOT_APPLICATION_CLIPBOARD N_ ("Save screenshot to clipboard")
#define GETTEXT_PACKAGE "io.elementary.screenshot"
#define LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SCREENSHOT_TYPE_APPLICATION (screenshot_application_get_type ())
#define SCREENSHOT_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREENSHOT_TYPE_APPLICATION, ScreenshotApplication))
#define SCREENSHOT_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCREENSHOT_TYPE_APPLICATION, ScreenshotApplicationClass))
#define SCREENSHOT_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREENSHOT_TYPE_APPLICATION))
#define SCREENSHOT_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCREENSHOT_TYPE_APPLICATION))
#define SCREENSHOT_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCREENSHOT_TYPE_APPLICATION, ScreenshotApplicationClass))

typedef struct _ScreenshotApplication ScreenshotApplication;
typedef struct _ScreenshotApplicationClass ScreenshotApplicationClass;
typedef struct _ScreenshotApplicationPrivate ScreenshotApplicationPrivate;
enum  {
	SCREENSHOT_APPLICATION_0_PROPERTY,
	SCREENSHOT_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* screenshot_application_properties[SCREENSHOT_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef enum  {
	SCREENSHOT_CAPTURE_TYPE_SCREEN,
	SCREENSHOT_CAPTURE_TYPE_CURRENT_WINDOW,
	SCREENSHOT_CAPTURE_TYPE_AREA
} ScreenshotCaptureType;

#define SCREENSHOT_TYPE_CAPTURE_TYPE (screenshot_capture_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ScreenshotApplicationTakeScreenshotData ScreenshotApplicationTakeScreenshotData;

#define SCREENSHOT_TYPE_SCREENSHOT_BACKEND (screenshot_screenshot_backend_get_type ())
#define SCREENSHOT_SCREENSHOT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREENSHOT_TYPE_SCREENSHOT_BACKEND, ScreenshotScreenshotBackend))
#define SCREENSHOT_SCREENSHOT_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCREENSHOT_TYPE_SCREENSHOT_BACKEND, ScreenshotScreenshotBackendClass))
#define SCREENSHOT_IS_SCREENSHOT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREENSHOT_TYPE_SCREENSHOT_BACKEND))
#define SCREENSHOT_IS_SCREENSHOT_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCREENSHOT_TYPE_SCREENSHOT_BACKEND))
#define SCREENSHOT_SCREENSHOT_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCREENSHOT_TYPE_SCREENSHOT_BACKEND, ScreenshotScreenshotBackendClass))

typedef struct _ScreenshotScreenshotBackend ScreenshotScreenshotBackend;
typedef struct _ScreenshotScreenshotBackendClass ScreenshotScreenshotBackendClass;
typedef struct _ScreenshotApplicationTakeScreenshotBackendData ScreenshotApplicationTakeScreenshotBackendData;

#define SCREENSHOT_TYPE_SAVE_DIALOG (screenshot_save_dialog_get_type ())
#define SCREENSHOT_SAVE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREENSHOT_TYPE_SAVE_DIALOG, ScreenshotSaveDialog))
#define SCREENSHOT_SAVE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCREENSHOT_TYPE_SAVE_DIALOG, ScreenshotSaveDialogClass))
#define SCREENSHOT_IS_SAVE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREENSHOT_TYPE_SAVE_DIALOG))
#define SCREENSHOT_IS_SAVE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCREENSHOT_TYPE_SAVE_DIALOG))
#define SCREENSHOT_SAVE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCREENSHOT_TYPE_SAVE_DIALOG, ScreenshotSaveDialogClass))

typedef struct _ScreenshotSaveDialog ScreenshotSaveDialog;
typedef struct _ScreenshotSaveDialogClass ScreenshotSaveDialogClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _ScreenshotApplication {
	GtkApplication parent_instance;
	ScreenshotApplicationPrivate * priv;
};

struct _ScreenshotApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ScreenshotApplicationPrivate {
	GSettings* settings;
};

struct _Block1Data {
	int _ref_count_;
	ScreenshotApplication* self;
	GraniteSettings* granite_settings;
	GtkSettings* gtk_settings;
};

struct _ScreenshotApplicationTakeScreenshotData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScreenshotApplication* self;
	XdpPortal* portal;
	XdpPortal* _tmp0_;
	gchar* file_uri;
	XdpPortal* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _ScreenshotApplicationTakeScreenshotBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScreenshotApplication* self;
	ScreenshotCaptureType capture_type;
	ScreenshotScreenshotBackend* backend;
	ScreenshotScreenshotBackend* _tmp0_;
	GdkPixbuf* pixbuf;
	ScreenshotScreenshotBackend* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GError* e;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

static gint ScreenshotApplication_private_offset;
static gpointer screenshot_application_parent_class = NULL;
static gboolean screenshot_application_win;
static gboolean screenshot_application_area;
static gboolean screenshot_application_screen;
static gint screenshot_application_delay;
static gboolean screenshot_application_grab_pointer;
static gboolean screenshot_application_redact;
static gboolean screenshot_application_clipboard;
static gboolean screenshot_application_area = FALSE;
static gboolean screenshot_application_clipboard = FALSE;
static gboolean screenshot_application_grab_pointer = FALSE;
static gboolean screenshot_application_redact = FALSE;
static gboolean screenshot_application_screen = FALSE;
static gboolean screenshot_application_win = FALSE;
static gint screenshot_application_delay = 1;

VALA_EXTERN GType screenshot_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScreenshotApplication, g_object_unref)
VALA_EXTERN ScreenshotApplication* screenshot_application_new (void);
VALA_EXTERN ScreenshotApplication* screenshot_application_construct (GType object_type);
static void screenshot_application_real_startup (GApplication* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_);
static void ___lambda4__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void __lambda5_ (ScreenshotApplication* self);
static void ___lambda5__g_simple_action_activate (GSimpleAction* _sender,
                                           GVariant* parameter,
                                           gpointer self);
static void screenshot_application_real_activate (GApplication* base);
static void screenshot_application_take_screenshot (ScreenshotApplication* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void screenshot_application_take_screenshot_finish (ScreenshotApplication* self,
                                                    GAsyncResult* _res_);
VALA_EXTERN GType screenshot_capture_type_get_type (void) G_GNUC_CONST ;
static void screenshot_application_take_screenshot_backend (ScreenshotApplication* self,
                                                     ScreenshotCaptureType capture_type,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void screenshot_application_take_screenshot_backend_finish (ScreenshotApplication* self,
                                                            GAsyncResult* _res_);
static void screenshot_application_take_screenshot_data_free (gpointer _data);
static gboolean screenshot_application_take_screenshot_co (ScreenshotApplicationTakeScreenshotData* _data_);
static void screenshot_application_take_screenshot_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void screenshot_application_show_save_dialog (ScreenshotApplication* self,
                                              GdkPixbuf* pixbuf);
static void screenshot_application_take_screenshot_backend_data_free (gpointer _data);
static gboolean screenshot_application_take_screenshot_backend_co (ScreenshotApplicationTakeScreenshotBackendData* _data_);
VALA_EXTERN GType screenshot_screenshot_backend_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScreenshotScreenshotBackend, g_object_unref)
VALA_EXTERN ScreenshotScreenshotBackend* screenshot_screenshot_backend_new (void);
VALA_EXTERN ScreenshotScreenshotBackend* screenshot_screenshot_backend_construct (GType object_type);
VALA_EXTERN void screenshot_screenshot_backend_capture (ScreenshotScreenshotBackend* self,
                                            ScreenshotCaptureType type,
                                            gint delay,
                                            gboolean include_pointer,
                                            gboolean redact,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
VALA_EXTERN GdkPixbuf* screenshot_screenshot_backend_capture_finish (ScreenshotScreenshotBackend* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static void screenshot_application_take_screenshot_backend_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void screenshot_application_show_error_dialog (ScreenshotApplication* self,
                                               const gchar* error_message);
VALA_EXTERN GType screenshot_save_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScreenshotSaveDialog, g_object_unref)
VALA_EXTERN ScreenshotSaveDialog* screenshot_save_dialog_new (GdkPixbuf* pixbuf,
                                                  GSettings* settings);
VALA_EXTERN ScreenshotSaveDialog* screenshot_save_dialog_construct (GType object_type,
                                                        GdkPixbuf* pixbuf,
                                                        GSettings* settings);
static void __lambda15_ (ScreenshotApplication* self,
                  ScreenshotSaveDialog* dialog,
                  gboolean response,
                  const gchar* folder_dir,
                  const gchar* output_name,
                  const gchar* format);
static void screenshot_application_save_file (ScreenshotApplication* self,
                                       GdkPixbuf* pixbuf,
                                       const gchar* file_name,
                                       const gchar* format,
                                       gchar* folder_dir,
                                       GError** error);
VALA_EXTERN GdkPixbuf* screenshot_save_dialog_get_pixbuf (ScreenshotSaveDialog* self);
static void ___lambda15__screenshot_save_dialog_save_response (ScreenshotSaveDialog* _sender,
                                                        gboolean response,
                                                        const gchar* folder_dir,
                                                        const gchar* output_name,
                                                        const gchar* format,
                                                        gpointer self);
VALA_EXTERN void screenshot_application_create_dir_if_missing (const gchar* path);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static gint screenshot_application_main (gchar** args,
                                  gint args_length1);
static GObject * screenshot_application_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void screenshot_application_finalize (GObject * obj);
static GType screenshot_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry SCREENSHOT_APPLICATION_OPTION_ENTRIES[8] = {{"window", 'w', (gint) 0, G_OPTION_ARG_NONE, &screenshot_application_win, SCREENSHOT_APPLICATION_CAPTURE_WIN, NULL}, {"area", 'r', (gint) 0, G_OPTION_ARG_NONE, &screenshot_application_area, SCREENSHOT_APPLICATION_CAPTURE_AREA, NULL}, {"screen", 's', (gint) 0, G_OPTION_ARG_NONE, &screenshot_application_screen, SCREENSHOT_APPLICATION_CAPTURE_STRING, NULL}, {"delay", 'd', (gint) 0, G_OPTION_ARG_INT, &screenshot_application_delay, SCREENSHOT_APPLICATION_DELAY, SCREENSHOT_APPLICATION_SECONDS}, {"grab-pointer", 'p', (gint) 0, G_OPTION_ARG_NONE, &screenshot_application_grab_pointer, SCREENSHOT_APPLICATION_INCLUDE_POINTER, NULL}, {"redact", 'e', (gint) 0, G_OPTION_ARG_NONE, &screenshot_application_redact, SCREENSHOT_APPLICATION_REDACT_TEXT, NULL}, {"clipboard", 'c', (gint) 0, G_OPTION_ARG_NONE, &screenshot_application_clipboard, SCREENSHOT_APPLICATION_CLIPBOARD, NULL}, {NULL}};

static inline gpointer
screenshot_application_get_instance_private (ScreenshotApplication* self)
{
	return G_STRUCT_MEMBER_P (self, ScreenshotApplication_private_offset);
}

ScreenshotApplication*
screenshot_application_construct (GType object_type)
{
	ScreenshotApplication * self = NULL;
	self = (ScreenshotApplication*) g_object_new (object_type, "application-id", "io.elementary.screenshot", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}

ScreenshotApplication*
screenshot_application_new (void)
{
	return screenshot_application_construct (SCREENSHOT_TYPE_APPLICATION);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ScreenshotApplication* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->gtk_settings);
		_g_object_unref0 (_data1_->granite_settings);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda4_ (Block1Data* _data1_)
{
	ScreenshotApplication* self;
	GraniteSettingsColorScheme _tmp0_;
	GraniteSettingsColorScheme _tmp1_;
	self = _data1_->self;
	_tmp0_ = granite_settings_get_prefers_color_scheme (_data1_->granite_settings);
	_tmp1_ = _tmp0_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp1_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
}

static void
___lambda4__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda4_ (self);
}

static void
__lambda5_ (ScreenshotApplication* self)
{
	g_application_quit ((GApplication*) self);
}

static void
___lambda5__g_simple_action_activate (GSimpleAction* _sender,
                                      GVariant* parameter,
                                      gpointer self)
{
	__lambda5_ ((ScreenshotApplication*) self);
}

static void
screenshot_application_real_startup (GApplication* base)
{
	ScreenshotApplication * self;
	Block1Data* _data1_;
	GraniteSettings* _tmp0_;
	GraniteSettings* _tmp1_;
	GtkSettings* _tmp2_;
	GtkSettings* _tmp3_;
	GraniteSettingsColorScheme _tmp4_;
	GraniteSettingsColorScheme _tmp5_;
	GSimpleAction* quit_action = NULL;
	GSimpleAction* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	self = (ScreenshotApplication*) base;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	G_APPLICATION_CLASS (screenshot_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	granite_init ();
	_tmp0_ = granite_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data1_->granite_settings = _tmp1_;
	_tmp2_ = gtk_settings_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_data1_->gtk_settings = _tmp3_;
	_tmp4_ = granite_settings_get_prefers_color_scheme (_data1_->granite_settings);
	_tmp5_ = _tmp4_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp5_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
	g_signal_connect_data ((GObject*) _data1_->granite_settings, "notify::prefers-color-scheme", (GCallback) ___lambda4__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp6_ = g_simple_action_new ("quit", NULL);
	quit_action = _tmp6_;
	g_signal_connect_object (quit_action, "activate", (GCallback) ___lambda5__g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) self, (GAction*) quit_action);
	_tmp7_ = g_strdup ("<Control>q");
	_tmp8_ = g_strdup ("Escape");
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp10_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (quit_action);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
screenshot_application_real_activate (GApplication* base)
{
	ScreenshotApplication * self;
	gint action = 0;
	self = (ScreenshotApplication*) base;
	action = 0;
	if (screenshot_application_screen) {
		action = 1;
	}
	if (screenshot_application_win) {
		action = 2;
	}
	if (screenshot_application_area) {
		action = 3;
	}
	if (action == 0) {
		screenshot_application_take_screenshot (self, NULL, NULL);
	} else {
		screenshot_application_take_screenshot_backend (self, action - 1, NULL, NULL);
	}
}

static void
screenshot_application_take_screenshot_data_free (gpointer _data)
{
	ScreenshotApplicationTakeScreenshotData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ScreenshotApplicationTakeScreenshotData, _data_);
}

static void
screenshot_application_take_screenshot (ScreenshotApplication* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ScreenshotApplicationTakeScreenshotData* _data_;
	ScreenshotApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ScreenshotApplicationTakeScreenshotData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, screenshot_application_take_screenshot_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	screenshot_application_take_screenshot_co (_data_);
}

static void
screenshot_application_take_screenshot_finish (ScreenshotApplication* self,
                                               GAsyncResult* _res_)
{
	ScreenshotApplicationTakeScreenshotData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
screenshot_application_take_screenshot_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	ScreenshotApplicationTakeScreenshotData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	screenshot_application_take_screenshot_co (_data_);
}

static gboolean
screenshot_application_take_screenshot_co (ScreenshotApplicationTakeScreenshotData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_application_hold ((GApplication*) _data_->self);
	_data_->_tmp0_ = xdp_portal_new ();
	_data_->portal = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->portal;
		_data_->_state_ = 1;
		xdp_portal_take_screenshot (_data_->_tmp1_, NULL, XDP_SCREENSHOT_FLAG_INTERACTIVE, NULL, screenshot_application_take_screenshot_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = xdp_portal_take_screenshot_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->file_uri = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->file_uri;
		_data_->_tmp5_ = g_filename_from_uri (_data_->_tmp4_, NULL, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->file_uri);
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = gdk_pixbuf_new_from_file (_data_->_tmp3_, &_data_->_inner_error0_);
		_data_->pixbuf = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->_tmp3_);
			_g_free0 (_data_->file_uri);
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->pixbuf;
		screenshot_application_show_save_dialog (_data_->self, _data_->_tmp7_);
		_g_object_unref0 (_data_->pixbuf);
		_g_free0 (_data_->_tmp3_);
		_g_free0 (_data_->file_uri);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning ("Application.vala:117: Failed to take screenshot via portal: %s", _data_->_tmp9_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	{
		g_application_release ((GApplication*) _data_->self);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->portal);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->portal);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
screenshot_application_take_screenshot_backend_data_free (gpointer _data)
{
	ScreenshotApplicationTakeScreenshotBackendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ScreenshotApplicationTakeScreenshotBackendData, _data_);
}

static void
screenshot_application_take_screenshot_backend (ScreenshotApplication* self,
                                                ScreenshotCaptureType capture_type,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	ScreenshotApplicationTakeScreenshotBackendData* _data_;
	ScreenshotApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ScreenshotApplicationTakeScreenshotBackendData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, screenshot_application_take_screenshot_backend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->capture_type = capture_type;
	screenshot_application_take_screenshot_backend_co (_data_);
}

static void
screenshot_application_take_screenshot_backend_finish (ScreenshotApplication* self,
                                                       GAsyncResult* _res_)
{
	ScreenshotApplicationTakeScreenshotBackendData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
screenshot_application_take_screenshot_backend_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	ScreenshotApplicationTakeScreenshotBackendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	screenshot_application_take_screenshot_backend_co (_data_);
}

static gboolean
screenshot_application_take_screenshot_backend_co (ScreenshotApplicationTakeScreenshotBackendData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_application_hold ((GApplication*) _data_->self);
	_data_->_tmp0_ = screenshot_screenshot_backend_new ();
	_data_->backend = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->backend;
		_data_->_state_ = 1;
		screenshot_screenshot_backend_capture (_data_->_tmp1_, _data_->capture_type, screenshot_application_delay, screenshot_application_grab_pointer, screenshot_application_redact, screenshot_application_take_screenshot_backend_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = screenshot_screenshot_backend_capture_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->pixbuf = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->pixbuf;
		if (_data_->_tmp3_ != NULL) {
			_data_->_tmp4_ = _data_->pixbuf;
			screenshot_application_show_save_dialog (_data_->self, _data_->_tmp4_);
		}
		_g_object_unref0 (_data_->pixbuf);
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		screenshot_application_show_error_dialog (_data_->self, _data_->_tmp6_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	{
		g_application_release ((GApplication*) _data_->self);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->backend);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->backend);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
__lambda15_ (ScreenshotApplication* self,
             ScreenshotSaveDialog* dialog,
             gboolean response,
             const gchar* folder_dir,
             const gchar* output_name,
             const gchar* format)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (folder_dir != NULL);
	g_return_if_fail (output_name != NULL);
	g_return_if_fail (format != NULL);
	gtk_window_destroy ((GtkWindow*) dialog);
	if (response) {
		gchar** formats = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint formats_length1;
		gint _formats_size_;
		gchar* output = NULL;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp0_ = g_strdup (".png");
		_tmp1_ = g_strdup (".jpg");
		_tmp2_ = g_strdup (".jpeg");
		_tmp3_ = g_strdup (".bmp");
		_tmp4_ = g_strdup (".tiff");
		_tmp5_ = g_new0 (gchar*, 5 + 1);
		_tmp5_[0] = _tmp0_;
		_tmp5_[1] = _tmp1_;
		_tmp5_[2] = _tmp2_;
		_tmp5_[3] = _tmp3_;
		_tmp5_[4] = _tmp4_;
		formats = _tmp5_;
		formats_length1 = 5;
		_formats_size_ = formats_length1;
		_tmp6_ = g_strdup (output_name);
		output = _tmp6_;
		_tmp7_ = formats;
		_tmp7__length1 = formats_length1;
		{
			gchar** type_collection = NULL;
			gint type_collection_length1 = 0;
			gint _type_collection_size_ = 0;
			gint type_it = 0;
			type_collection = _tmp7_;
			type_collection_length1 = _tmp7__length1;
			for (type_it = 0; type_it < type_collection_length1; type_it = type_it + 1) {
				gchar* _tmp8_;
				gchar* type = NULL;
				_tmp8_ = g_strdup (type_collection[type_it]);
				type = _tmp8_;
				{
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = output;
					_tmp10_ = type;
					_tmp11_ = string_replace (_tmp9_, _tmp10_, "");
					_g_free0 (output);
					output = _tmp11_;
					_g_free0 (type);
				}
			}
		}
		{
			GdkPixbuf* _tmp12_;
			GdkPixbuf* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = screenshot_save_dialog_get_pixbuf (dialog);
			_tmp13_ = _tmp12_;
			_tmp14_ = output;
			_tmp15_ = g_strdup (folder_dir);
			screenshot_application_save_file (self, _tmp13_, _tmp14_, format, _tmp15_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			screenshot_application_show_error_dialog (self, _tmp17_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (output);
			formats = (_vala_array_free (formats, formats_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (output);
		formats = (_vala_array_free (formats, formats_length1, (GDestroyNotify) g_free), NULL);
	} else {
		screenshot_application_take_screenshot (self, NULL, NULL);
	}
}

static void
___lambda15__screenshot_save_dialog_save_response (ScreenshotSaveDialog* _sender,
                                                   gboolean response,
                                                   const gchar* folder_dir,
                                                   const gchar* output_name,
                                                   const gchar* format,
                                                   gpointer self)
{
	__lambda15_ ((ScreenshotApplication*) self, _sender, response, folder_dir, output_name, format);
}

static void
screenshot_application_show_save_dialog (ScreenshotApplication* self,
                                         GdkPixbuf* pixbuf)
{
	ScreenshotSaveDialog* save_dialog = NULL;
	GSettings* _tmp0_;
	ScreenshotSaveDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = screenshot_save_dialog_new (pixbuf, _tmp0_);
	g_object_ref_sink (_tmp1_);
	save_dialog = _tmp1_;
	gtk_window_set_application ((GtkWindow*) save_dialog, (GtkApplication*) self);
	g_signal_connect_object (save_dialog, "save-response", (GCallback) ___lambda15__screenshot_save_dialog_save_response, self, 0);
	gtk_window_present ((GtkWindow*) save_dialog);
	_g_object_unref0 (save_dialog);
}

static void
screenshot_application_save_file (ScreenshotApplication* self,
                                  GdkPixbuf* pixbuf,
                                  const gchar* file_name,
                                  const gchar* format,
                                  gchar* folder_dir,
                                  GError** error)
{
	gchar* full_file_name = NULL;
	gchar* _tmp0_;
	gchar* folder_from_settings = NULL;
	gchar* _tmp1_;
	gint attempt = 0;
	const gchar* _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	g_return_if_fail (file_name != NULL);
	g_return_if_fail (format != NULL);
	g_return_if_fail (folder_dir != NULL);
	if (pixbuf == NULL) {
		g_critical ("Application.vala:173: Pixbuf is null");
		_g_free0 (folder_dir);
		return;
	}
	_tmp0_ = g_strdup ("");
	full_file_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	folder_from_settings = _tmp1_;
	if (g_strcmp0 (folder_dir, "") == 0) {
		GSettings* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->settings;
		_tmp3_ = g_settings_get_string (_tmp2_, "folder-dir");
		_g_free0 (folder_from_settings);
		folder_from_settings = _tmp3_;
		_tmp4_ = folder_from_settings;
		if (g_strcmp0 (_tmp4_, "") != 0) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = folder_from_settings;
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (folder_dir);
			folder_dir = _tmp6_;
		} else {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp7_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
			_tmp8_ = g_strdup_printf ("%c", (gint) G_DIR_SEPARATOR);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat (_tmp11_, SCREENSHOT_APPLICATION_SAVE_FOLDER, NULL);
			_g_free0 (folder_dir);
			folder_dir = _tmp12_;
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
		}
		screenshot_application_create_dir_if_missing (folder_dir);
	}
	attempt = 0;
	{
		gboolean _tmp13_ = FALSE;
		_tmp13_ = TRUE;
		while (TRUE) {
			gint _tmp24_;
			if (!_tmp13_) {
				const gchar* _tmp14_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				gboolean _tmp17_;
				_tmp14_ = full_file_name;
				_tmp15_ = g_file_new_for_path (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = !g_file_query_exists (_tmp16_, NULL);
				_g_object_unref0 (_tmp16_);
				if (_tmp17_) {
					break;
				}
			}
			_tmp13_ = FALSE;
			if (attempt == 0) {
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp18_ = g_strdup_printf ("%s.%s", file_name, format);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_build_filename (folder_dir, _tmp19_, NULL);
				_g_free0 (full_file_name);
				full_file_name = _tmp20_;
				_g_free0 (_tmp19_);
			} else {
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp21_ = g_strdup_printf ("%s (%d).%s", file_name, attempt, format);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_build_filename (folder_dir, _tmp22_, NULL);
				_g_free0 (full_file_name);
				full_file_name = _tmp23_;
				_g_free0 (_tmp22_);
			}
			_tmp24_ = attempt;
			attempt = _tmp24_ + 1;
		}
	}
	_tmp25_ = full_file_name;
	gdk_pixbuf_save (pixbuf, _tmp25_, format, &_inner_error0_, NULL);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (folder_from_settings);
		_g_free0 (full_file_name);
		_g_free0 (folder_dir);
		return;
	}
	_g_free0 (folder_from_settings);
	_g_free0 (full_file_name);
	_g_free0 (folder_dir);
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
screenshot_application_show_error_dialog (ScreenshotApplication* self,
                                          const gchar* error_message)
{
	GraniteMessageDialog* dialog = NULL;
	GraniteMessageDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_message != NULL);
	_tmp0_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Could not capture screenshot"), _ ("Image not saved"), "dialog-error", GTK_BUTTONS_CLOSE);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_window_set_application ((GtkWindow*) dialog, (GtkApplication*) self);
	granite_message_dialog_show_error_details (dialog, error_message);
	g_signal_connect_object ((GtkDialog*) dialog, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) dialog, 0);
	gtk_window_present ((GtkWindow*) dialog);
	_g_object_unref0 (dialog);
}

static GError*
vala_g_io_error_from_errno (gint err_no)
{
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError* result;
	_tmp0_ = g_strerror (err_no);
	_tmp1_ = g_error_new (g_io_error_quark (), g_io_error_from_errno (err_no), "%s", _tmp0_);
	result = (GError*) _tmp1_;
	return result;
}

void
screenshot_application_create_dir_if_missing (const gchar* path)
{
	g_return_if_fail (path != NULL);
	if (mkdir (path, (mode_t) 0775) != 0) {
		gint err_no = 0;
		err_no = errno;
		if (err_no != EEXIST) {
			GError* _tmp0_;
			GError* _tmp1_;
			const gchar* _tmp2_;
			_tmp0_ = vala_g_io_error_from_errno (err_no);
			_tmp1_ = _tmp0_;
			_tmp2_ = _tmp1_->message;
			g_debug ("Application.vala:223: %s", _tmp2_);
			_g_error_free0 (_tmp1_);
		}
	}
}

static gint
screenshot_application_main (gchar** args,
                             gint args_length1)
{
	ScreenshotApplication* _tmp0_;
	ScreenshotApplication* _tmp1_;
	gint _tmp2_;
	gint result;
	_tmp0_ = screenshot_application_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return screenshot_application_main (argv, argc);
}

static GObject *
screenshot_application_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScreenshotApplication * self;
	parent_class = G_OBJECT_CLASS (screenshot_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCREENSHOT_TYPE_APPLICATION, ScreenshotApplication);
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_application_add_main_option_entries ((GApplication*) self, SCREENSHOT_APPLICATION_OPTION_ENTRIES);
	return obj;
}

static void
screenshot_application_class_init (ScreenshotApplicationClass * klass,
                                   gpointer klass_data)
{
	screenshot_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScreenshotApplication_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) screenshot_application_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) screenshot_application_real_activate;
	G_OBJECT_CLASS (klass)->constructor = screenshot_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = screenshot_application_finalize;
}

static void
screenshot_application_instance_init (ScreenshotApplication * self,
                                      gpointer klass)
{
	GSettings* _tmp0_;
	self->priv = screenshot_application_get_instance_private (self);
	_tmp0_ = g_settings_new ("io.elementary.screenshot");
	self->priv->settings = _tmp0_;
}

static void
screenshot_application_finalize (GObject * obj)
{
	ScreenshotApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCREENSHOT_TYPE_APPLICATION, ScreenshotApplication);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (screenshot_application_parent_class)->finalize (obj);
}

static GType
screenshot_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScreenshotApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) screenshot_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScreenshotApplication), 0, (GInstanceInitFunc) screenshot_application_instance_init, NULL };
	GType screenshot_application_type_id;
	screenshot_application_type_id = g_type_register_static (gtk_application_get_type (), "ScreenshotApplication", &g_define_type_info, 0);
	ScreenshotApplication_private_offset = g_type_add_instance_private (screenshot_application_type_id, sizeof (ScreenshotApplicationPrivate));
	return screenshot_application_type_id;
}

GType
screenshot_application_get_type (void)
{
	static volatile gsize screenshot_application_type_id__once = 0;
	if (g_once_init_enter (&screenshot_application_type_id__once)) {
		GType screenshot_application_type_id;
		screenshot_application_type_id = screenshot_application_get_type_once ();
		g_once_init_leave (&screenshot_application_type_id__once, screenshot_application_type_id);
	}
	return screenshot_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

