/* ViewCollection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ViewCollection.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/
/* A ViewCollection holds DataView objects, which are view instances wrapping DataSource objects.*/
/* Thus, multiple views can exist of a single SourceCollection, each view displaying all or some*/
/* of that SourceCollection.  A view collection also has a notion of order*/
/* (first/last/next/previous) that can be overridden by child classes.  It also understands hidden*/
/* objects, which are withheld entirely from the collection until they're made visible.  Currently*/
/* the only way to hide objects is with a ViewFilter.*/
/**/
/* A ViewCollection may also be locked.  When locked, it will not (a) remove hidden items from the*/
/* collection and (b) remove DataViews representing unlinked DataSources.  This allows for the*/
/* ViewCollection to be "frozen" while manipulating items within it.  When the collection is*/
/* unlocked, all changes are applied at once.*/
/**/
/* The default implementation provides a browser which orders the view in the order they're*/
/* stored in DataCollection, which is not specified.*/

#include "io.elementary.photos.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define VIEW_COLLECTION_TYPE_MONITOR_IMPL (view_collection_monitor_impl_get_type ())
#define VIEW_COLLECTION_MONITOR_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImpl))
#define VIEW_COLLECTION_MONITOR_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImplClass))
#define VIEW_COLLECTION_IS_MONITOR_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIEW_COLLECTION_TYPE_MONITOR_IMPL))
#define VIEW_COLLECTION_IS_MONITOR_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIEW_COLLECTION_TYPE_MONITOR_IMPL))
#define VIEW_COLLECTION_MONITOR_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImplClass))

typedef struct _ViewCollectionMonitorImpl ViewCollectionMonitorImpl;
typedef struct _ViewCollectionMonitorImplClass ViewCollectionMonitorImplClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _data_set_unref0(var) ((var == NULL) ? NULL : (var = (data_set_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _view_filter_unref0(var) ((var == NULL) ? NULL : (var = (view_filter_unref (var), NULL)))
typedef struct _ViewCollectionMonitorImplPrivate ViewCollectionMonitorImplPrivate;
#define _view_collection_monitor_unref0(var) ((var == NULL) ? NULL : (var = (view_collection_monitor_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define VIEW_COLLECTION_TYPE_TOGGLE_LISTS (view_collection_toggle_lists_get_type ())
#define VIEW_COLLECTION_TOGGLE_LISTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleLists))
#define VIEW_COLLECTION_TOGGLE_LISTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleListsClass))
#define VIEW_COLLECTION_IS_TOGGLE_LISTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIEW_COLLECTION_TYPE_TOGGLE_LISTS))
#define VIEW_COLLECTION_IS_TOGGLE_LISTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIEW_COLLECTION_TYPE_TOGGLE_LISTS))
#define VIEW_COLLECTION_TOGGLE_LISTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleListsClass))

typedef struct _ViewCollectionToggleLists ViewCollectionToggleLists;
typedef struct _ViewCollectionToggleListsClass ViewCollectionToggleListsClass;
typedef struct _ViewCollectionToggleListsPrivate ViewCollectionToggleListsPrivate;
typedef struct _ViewCollectionParamSpecMonitor ViewCollectionParamSpecMonitor;
#define _view_manager_unref0(var) ((var == NULL) ? NULL : (var = (view_manager_unref (var), NULL)))
enum  {
	VIEW_COLLECTION_TOGGLE_LISTS_0_PROPERTY,
	VIEW_COLLECTION_TOGGLE_LISTS_NUM_PROPERTIES
};
static GParamSpec* view_collection_toggle_lists_properties[VIEW_COLLECTION_TOGGLE_LISTS_NUM_PROPERTIES];
enum  {
	VIEW_COLLECTION_ITEMS_SELECTED_SIGNAL,
	VIEW_COLLECTION_ITEMS_UNSELECTED_SIGNAL,
	VIEW_COLLECTION_ITEMS_STATE_CHANGED_SIGNAL,
	VIEW_COLLECTION_SELECTION_GROUP_ALTERED_SIGNAL,
	VIEW_COLLECTION_ITEMS_SHOWN_SIGNAL,
	VIEW_COLLECTION_ITEMS_HIDDEN_SIGNAL,
	VIEW_COLLECTION_ITEMS_VISIBILITY_CHANGED_SIGNAL,
	VIEW_COLLECTION_ITEM_VIEW_ALTERED_SIGNAL,
	VIEW_COLLECTION_ITEM_GEOMETRY_ALTERED_SIGNAL,
	VIEW_COLLECTION_VIEWS_ALTERED_SIGNAL,
	VIEW_COLLECTION_GEOMETRIES_ALTERED_SIGNAL,
	VIEW_COLLECTION_VIEW_FILTER_INSTALLED_SIGNAL,
	VIEW_COLLECTION_VIEW_FILTER_REMOVED_SIGNAL,
	VIEW_COLLECTION_NUM_SIGNALS
};
static guint view_collection_signals[VIEW_COLLECTION_NUM_SIGNALS] = {0};
typedef struct _ParamSpecViewFilter ParamSpecViewFilter;
enum  {
	VIEW_FILTER_REFRESH_SIGNAL,
	VIEW_FILTER_NUM_SIGNALS
};
static guint view_filter_signals[VIEW_FILTER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ViewCollectionPrivate {
	GeeHashMultiMap* monitors;
	ViewCollection* mirroring;
	CreateView mirroring_ctor;
	gpointer mirroring_ctor_target;
	CreateViewPredicate should_mirror;
	gpointer should_mirror_target;
	GeeSet* filters;
	DataSet* selected;
	DataSet* visible;
	GeeHashSet* frozen_views_altered;
	GeeHashSet* frozen_geometries_altered;
	GeeHashMap* source_map;
};

struct _ViewCollectionMonitorImpl {
	ViewCollectionMonitor parent_instance;
	ViewCollectionMonitorImplPrivate * priv;
	ViewCollection* owner;
	SourceCollection* sources;
	ViewManager* manager;
	Alteration* prereq;
};

struct _ViewCollectionMonitorImplClass {
	ViewCollectionMonitorClass parent_class;
};

struct _ViewCollectionToggleLists {
	GObject parent_instance;
	ViewCollectionToggleListsPrivate * priv;
	GeeArrayList* selected;
	GeeArrayList* unselected;
};

struct _ViewCollectionToggleListsClass {
	GObjectClass parent_class;
};

struct _ViewCollectionParamSpecMonitor {
	GParamSpec parent_instance;
};

struct _ParamSpecViewFilter {
	GParamSpec parent_instance;
};

static gint ViewCollection_private_offset;
static gpointer view_collection_parent_class = NULL;
static gpointer view_collection_monitor_parent_class = NULL;
static gpointer view_collection_monitor_impl_parent_class = NULL;
static gpointer view_collection_toggle_lists_parent_class = NULL;
static gpointer view_filter_parent_class = NULL;

static GType view_collection_monitor_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void view_collection_real_notify_items_selected_unselected (ViewCollection* self,
                                                            GeeCollection* selected,
                                                            GeeCollection* unselected);
static void view_collection_real_notify_selection_group_altered (ViewCollection* self);
static void view_collection_real_notify_item_view_altered (ViewCollection* self,
                                                    DataView* view);
static void view_collection_real_notify_views_altered (ViewCollection* self,
                                                GeeCollection* views);
static void view_collection_real_notify_item_geometry_altered (ViewCollection* self,
                                                        DataView* view);
static void view_collection_real_notify_geometries_altered (ViewCollection* self,
                                                     GeeCollection* views);
static void view_collection_real_notify_items_shown (ViewCollection* self,
                                              GeeCollection* shown);
static void view_collection_real_notify_items_hidden (ViewCollection* self,
                                               GeeCollection* hidden);
static void view_collection_real_notify_items_visibility_changed (ViewCollection* self,
                                                           GeeCollection* changed);
static void view_collection_real_notify_view_filter_installed (ViewCollection* self,
                                                        ViewFilter* filter);
static void view_collection_real_notify_view_filter_removed (ViewCollection* self,
                                                      ViewFilter* filter);
static void view_collection_real_clear (DataCollection* base);
static void view_collection_real_close (DataCollection* base);
static void view_collection_on_view_filter_refresh (ViewCollection* self);
static void _view_collection_on_view_filter_refresh_view_filter_refresh (ViewFilter* _sender,
                                                                  gpointer self);
static ViewCollectionMonitorImpl* view_collection_monitor_impl_new (ViewCollection* owner,
                                                             SourceCollection* sources,
                                                             ViewManager* manager,
                                                             Alteration* prereq);
static ViewCollectionMonitorImpl* view_collection_monitor_impl_construct (GType object_type,
                                                                   ViewCollection* owner,
                                                                   SourceCollection* sources,
                                                                   ViewManager* manager,
                                                                   Alteration* prereq);
static void view_collection_add_sources (ViewCollection* self,
                                  SourceCollection* sources,
                                  GeeIterable* added,
                                  ProgressMonitor progress_monitor,
                                  gpointer progress_monitor_target);
static void view_collection_on_mirror_contents_added (ViewCollection* self,
                                               GeeIterable* added);
static void _view_collection_on_mirror_contents_added_data_collection_items_added (DataCollection* _sender,
                                                                            GeeIterable* added,
                                                                            gpointer self);
static void view_collection_on_mirror_contents_removed (ViewCollection* self,
                                                 GeeIterable* removed);
static void _view_collection_on_mirror_contents_removed_data_collection_items_removed (DataCollection* _sender,
                                                                                GeeIterable* removed,
                                                                                gpointer self);
static void view_collection_filter_altered_items (ViewCollection* self,
                                           GeeCollection* views);
static gboolean view_collection_is_in_filter (ViewCollection* self,
                                       DataView* view);
static gboolean view_collection_real_valid_type (DataCollection* base,
                                          DataObject* object);
static void view_collection_on_sources_added (ViewCollection* self,
                                       DataCollection* sources,
                                       GeeIterable* added);
static DataView* _view_manager_create_view_create_view (DataSource* source,
                                                 gpointer self);
static gboolean view_collection_real_add (DataCollection* base,
                                   DataObject* object);
static GeeCollection* view_collection_real_add_many (DataCollection* base,
                                              GeeCollection* objects,
                                              ProgressMonitor monitor,
                                              gpointer monitor_target);
static void view_collection_on_sources_removed (ViewCollection* self,
                                         GeeIterable* removed);
static void view_collection_on_sources_altered (ViewCollection* self,
                                         DataCollection* collection,
                                         GeeMap* items);
static gboolean view_collection_is_visible (ViewCollection* self,
                                     DataView* view);
static void view_collection_real_notify_items_added (DataCollection* base,
                                              GeeIterable* added);
static gboolean view_collection_add_many_visible (ViewCollection* self,
                                           GeeCollection* many);
static void view_collection_add_many_selected (ViewCollection* self,
                                        GeeCollection* views);
static void view_collection_real_notify_items_removed (DataCollection* base,
                                                GeeIterable* removed);
static void view_collection_remove_many_selected (ViewCollection* self,
                                           GeeCollection* views);
static void view_collection_show_items (ViewCollection* self,
                                 GeeList* to_show);
static void view_collection_hide_items (ViewCollection* self,
                                 GeeList* to_hide);
static void view_collection_real_items_altered (DataCollection* base,
                                         GeeMap* map);
static void view_collection_real_set_comparator (DataCollection* base,
                                          Comparator comparator,
                                          gpointer comparator_target,
                                          ComparatorPredicate predicate,
                                          gpointer predicate_target);
static void view_collection_real_reset_comparator (DataCollection* base);
static GeeCollection* view_collection_real_get_all (DataCollection* base);
static gint view_collection_real_get_count (DataCollection* base);
static DataObject* view_collection_real_get_at (DataCollection* base,
                                         gint index);
static gint view_collection_real_index_of (DataCollection* base,
                                    DataObject* object);
static gboolean view_collection_real_contains (DataCollection* base,
                                        DataObject* object);
static DataView* view_collection_real_get_first (ViewCollection* self);
static DataView* view_collection_real_get_first_unrejected (ViewCollection* self);
static DataView* view_collection_real_get_last (ViewCollection* self);
static DataView* view_collection_real_get_next (ViewCollection* self,
                                         DataView* view);
static DataView* view_collection_real_get_previous (ViewCollection* self,
                                             DataView* view);
static gboolean view_collection_select_item (ViewCollection* self,
                                      DataObject* object,
                                      GObject* user);
static gboolean _view_collection_select_item_marked_action (DataObject* object,
                                                     GObject* user,
                                                     gpointer self);
static gboolean view_collection_unselect_item (ViewCollection* self,
                                        DataObject* object,
                                        GObject* user);
static gboolean _view_collection_unselect_item_marked_action (DataObject* object,
                                                       GObject* user,
                                                       gpointer self);
static GType view_collection_toggle_lists_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ViewCollectionToggleLists* view_collection_toggle_lists_new (void);
static ViewCollectionToggleLists* view_collection_toggle_lists_construct (GType object_type);
static gboolean view_collection_toggle_item (ViewCollection* self,
                                      DataObject* object,
                                      GObject* user);
static gboolean _view_collection_toggle_item_marked_action (DataObject* object,
                                                     GObject* user,
                                                     gpointer self);
static void view_collection_real_notify_thawed (DataCollection* base);
static void view_collection_real_items_selected (ViewCollection* self,
                                          GeeIterable* selected);
static void view_collection_real_items_unselected (ViewCollection* self,
                                            GeeIterable* unselected);
static void view_collection_real_items_state_changed (ViewCollection* self,
                                               GeeIterable* changed);
static void view_collection_real_selection_group_altered (ViewCollection* self);
static void view_collection_real_items_shown (ViewCollection* self,
                                       GeeCollection* visible);
static void view_collection_real_items_hidden (ViewCollection* self,
                                        GeeCollection* hidden);
static void view_collection_real_items_visibility_changed (ViewCollection* self,
                                                    GeeCollection* changed);
static void view_collection_real_item_view_altered (ViewCollection* self,
                                             DataView* view);
static void view_collection_real_item_geometry_altered (ViewCollection* self,
                                                 DataView* view);
static void view_collection_real_views_altered (ViewCollection* self,
                                         GeeCollection* views);
static void view_collection_real_geometries_altered (ViewCollection* self,
                                              GeeCollection* views);
static void view_collection_real_view_filter_installed (ViewCollection* self,
                                                 ViewFilter* filer);
static void g_cclosure_user_marshal_VOID__VIEW_FILTER (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void view_collection_real_view_filter_removed (ViewCollection* self,
                                               ViewFilter* filer);
static void view_collection_monitor_finalize (ViewCollectionMonitor * obj);
static GType view_collection_monitor_get_type_once (void);
static void _view_collection_on_sources_added_data_collection_items_added (DataCollection* _sender,
                                                                    GeeIterable* added,
                                                                    gpointer self);
static void _view_collection_on_sources_removed_data_collection_items_removed (DataCollection* _sender,
                                                                        GeeIterable* removed,
                                                                        gpointer self);
static void _view_collection_on_sources_altered_data_collection_items_altered (DataCollection* _sender,
                                                                        GeeMap* items,
                                                                        gpointer self);
static void view_collection_monitor_impl_finalize (ViewCollectionMonitor * obj);
static GType view_collection_monitor_impl_get_type_once (void);
static void view_collection_toggle_lists_finalize (GObject * obj);
static GType view_collection_toggle_lists_get_type_once (void);
static void view_collection_finalize (DataCollection * obj);
static GType view_collection_get_type_once (void);
static gboolean view_filter_real_predicate (ViewFilter* self,
                                     DataView* view);
static void view_filter_real_refresh (ViewFilter* self);
static void view_filter_finalize (ViewFilter * obj);
static GType view_filter_get_type_once (void);

static inline gpointer
view_collection_get_instance_private (ViewCollection* self)
{
	return G_STRUCT_MEMBER_P (self, ViewCollection_private_offset);
}

ViewCollection*
view_collection_construct (GType object_type,
                           const gchar* name)
{
	ViewCollection* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ViewCollection*) data_collection_construct (object_type, name);
	return self;
}

ViewCollection*
view_collection_new (const gchar* name)
{
	return view_collection_construct (TYPE_VIEW_COLLECTION, name);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
view_collection_real_notify_items_selected_unselected (ViewCollection* self,
                                                       GeeCollection* selected,
                                                       GeeCollection* unselected)
{
	gboolean _tmp0_ = FALSE;
	gboolean has_selected = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean has_unselected = FALSE;
	GeeCollection* sum = NULL;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp14_;
	if (selected != NULL) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = gee_collection_get_size (selected);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	has_selected = _tmp0_;
	if (unselected != NULL) {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = gee_collection_get_size (unselected);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	has_unselected = _tmp3_;
	if (has_selected) {
		g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_SELECTED_SIGNAL], 0, (GeeIterable*) selected);
	}
	if (has_unselected) {
		g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_UNSELECTED_SIGNAL], 0, (GeeIterable*) unselected);
	}
	if (has_selected) {
		_tmp6_ = !has_unselected;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GeeCollection* _tmp7_;
		_tmp7_ = _g_object_ref0 (selected);
		_g_object_unref0 (sum);
		sum = _tmp7_;
	} else {
		gboolean _tmp8_ = FALSE;
		if (!has_selected) {
			_tmp8_ = has_unselected;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GeeCollection* _tmp9_;
			_tmp9_ = _g_object_ref0 (unselected);
			_g_object_unref0 (sum);
			sum = _tmp9_;
		} else {
			gboolean _tmp10_ = FALSE;
			if (!has_selected) {
				_tmp10_ = !has_unselected;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				_g_object_unref0 (sum);
				sum = NULL;
			} else {
				GeeHashSet* _tmp11_;
				GeeCollection* _tmp12_;
				GeeCollection* _tmp13_;
				_tmp11_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (sum);
				sum = (GeeCollection*) _tmp11_;
				_tmp12_ = sum;
				gee_collection_add_all (_tmp12_, selected);
				_tmp13_ = sum;
				gee_collection_add_all (_tmp13_, unselected);
			}
		}
	}
	_tmp14_ = sum;
	if (_tmp14_ != NULL) {
		GeeCollection* _tmp15_;
		_tmp15_ = sum;
		g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_STATE_CHANGED_SIGNAL], 0, (GeeIterable*) _tmp15_);
		view_collection_notify_selection_group_altered (self);
	}
	_g_object_unref0 (sum);
}

void
view_collection_notify_items_selected_unselected (ViewCollection* self,
                                                  GeeCollection* selected,
                                                  GeeCollection* unselected)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_selected_unselected) {
		_klass_->notify_items_selected_unselected (self, selected, unselected);
	}
}

static void
view_collection_real_notify_selection_group_altered (ViewCollection* self)
{
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_SELECTION_GROUP_ALTERED_SIGNAL], 0);
}

void
view_collection_notify_selection_group_altered (ViewCollection* self)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_selection_group_altered) {
		_klass_->notify_selection_group_altered (self);
	}
}

static void
view_collection_real_notify_item_view_altered (ViewCollection* self,
                                               DataView* view)
{
	g_return_if_fail (view != NULL);
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEM_VIEW_ALTERED_SIGNAL], 0, view);
}

void
view_collection_notify_item_view_altered (ViewCollection* self,
                                          DataView* view)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_item_view_altered) {
		_klass_->notify_item_view_altered (self, view);
	}
}

static void
view_collection_real_notify_views_altered (ViewCollection* self,
                                           GeeCollection* views)
{
	g_return_if_fail (views != NULL);
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_VIEWS_ALTERED_SIGNAL], 0, views);
}

void
view_collection_notify_views_altered (ViewCollection* self,
                                      GeeCollection* views)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_views_altered) {
		_klass_->notify_views_altered (self, views);
	}
}

static void
view_collection_real_notify_item_geometry_altered (ViewCollection* self,
                                                   DataView* view)
{
	g_return_if_fail (view != NULL);
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEM_GEOMETRY_ALTERED_SIGNAL], 0, view);
}

void
view_collection_notify_item_geometry_altered (ViewCollection* self,
                                              DataView* view)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_item_geometry_altered) {
		_klass_->notify_item_geometry_altered (self, view);
	}
}

static void
view_collection_real_notify_geometries_altered (ViewCollection* self,
                                                GeeCollection* views)
{
	g_return_if_fail (views != NULL);
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_GEOMETRIES_ALTERED_SIGNAL], 0, views);
}

void
view_collection_notify_geometries_altered (ViewCollection* self,
                                           GeeCollection* views)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_geometries_altered) {
		_klass_->notify_geometries_altered (self, views);
	}
}

static void
view_collection_real_notify_items_shown (ViewCollection* self,
                                         GeeCollection* shown)
{
	g_return_if_fail (shown != NULL);
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_SHOWN_SIGNAL], 0, shown);
}

void
view_collection_notify_items_shown (ViewCollection* self,
                                    GeeCollection* shown)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_shown) {
		_klass_->notify_items_shown (self, shown);
	}
}

static void
view_collection_real_notify_items_hidden (ViewCollection* self,
                                          GeeCollection* hidden)
{
	g_return_if_fail (hidden != NULL);
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_HIDDEN_SIGNAL], 0, hidden);
}

void
view_collection_notify_items_hidden (ViewCollection* self,
                                     GeeCollection* hidden)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_hidden) {
		_klass_->notify_items_hidden (self, hidden);
	}
}

static void
view_collection_real_notify_items_visibility_changed (ViewCollection* self,
                                                      GeeCollection* changed)
{
	g_return_if_fail (changed != NULL);
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_ITEMS_VISIBILITY_CHANGED_SIGNAL], 0, changed);
}

void
view_collection_notify_items_visibility_changed (ViewCollection* self,
                                                 GeeCollection* changed)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_visibility_changed) {
		_klass_->notify_items_visibility_changed (self, changed);
	}
}

static void
view_collection_real_notify_view_filter_installed (ViewCollection* self,
                                                   ViewFilter* filter)
{
	g_return_if_fail (filter != NULL);
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_VIEW_FILTER_INSTALLED_SIGNAL], 0, filter);
}

void
view_collection_notify_view_filter_installed (ViewCollection* self,
                                              ViewFilter* filter)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_view_filter_installed) {
		_klass_->notify_view_filter_installed (self, filter);
	}
}

static void
view_collection_real_notify_view_filter_removed (ViewCollection* self,
                                                 ViewFilter* filter)
{
	g_return_if_fail (filter != NULL);
	g_signal_emit (self, view_collection_signals[VIEW_COLLECTION_VIEW_FILTER_REMOVED_SIGNAL], 0, filter);
}

void
view_collection_notify_view_filter_removed (ViewCollection* self,
                                            ViewFilter* filter)
{
	ViewCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_view_filter_removed) {
		_klass_->notify_view_filter_removed (self, filter);
	}
}

static void
view_collection_real_clear (DataCollection* base)
{
	ViewCollection * self;
	gboolean _tmp0_ = FALSE;
	GeeHashMultiMap* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (ViewCollection*) base;
	_tmp1_ = self->priv->monitors;
	_tmp2_ = gee_multi_map_get_size ((GeeMultiMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		_tmp0_ = TRUE;
	} else {
		ViewCollection* _tmp4_;
		_tmp4_ = self->priv->mirroring;
		_tmp0_ = _tmp4_ != NULL;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = data_collection_to_string ((DataCollection*) self);
		_tmp6_ = _tmp5_;
		g_warning ("ViewCollection.vala:216: Cannot clear %s: monitoring or mirroring in e" \
"ffect", _tmp6_);
		_g_free0 (_tmp6_);
		return;
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->clear (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
}

static void
_view_collection_on_view_filter_refresh_view_filter_refresh (ViewFilter* _sender,
                                                             gpointer self)
{
	view_collection_on_view_filter_refresh ((ViewCollection*) self);
}

static void
view_collection_real_close (DataCollection* base)
{
	ViewCollection * self;
	GeeSet* _tmp7_;
	self = (ViewCollection*) base;
	view_collection_halt_all_monitoring (self);
	view_collection_halt_mirroring (self);
	{
		GeeIterator* _f_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->filters;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_f_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			ViewFilter* f = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			ViewFilter* _tmp5_;
			guint _tmp6_;
			_tmp2_ = _f_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _f_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			f = (ViewFilter*) _tmp4_;
			_tmp5_ = f;
			g_signal_parse_name ("refresh", TYPE_VIEW_FILTER, &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _view_collection_on_view_filter_refresh_view_filter_refresh, self);
			_view_filter_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	_tmp7_ = self->priv->filters;
	gee_collection_clear ((GeeCollection*) _tmp7_);
	DATA_COLLECTION_CLASS (view_collection_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
}

ViewCollectionMonitor*
view_collection_monitor_source_collection (ViewCollection* self,
                                           SourceCollection* sources,
                                           ViewManager* manager,
                                           Alteration* prereq,
                                           GeeCollection* initial,
                                           ProgressMonitor progress_monitor,
                                           gpointer progress_monitor_target)
{
	ViewCollectionMonitorImpl* monitor = NULL;
	ViewCollectionMonitorImpl* _tmp0_;
	GeeHashMultiMap* _tmp1_;
	ViewCollectionMonitorImpl* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ViewCollectionMonitor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sources != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	view_collection_halt_mirroring (self);
	data_collection_freeze_notifications ((DataCollection*) self);
	_tmp0_ = view_collection_monitor_impl_new (self, sources, manager, prereq);
	monitor = _tmp0_;
	_tmp1_ = self->priv->monitors;
	_tmp2_ = monitor;
	gee_multi_map_set ((GeeMultiMap*) _tmp1_, sources, _tmp2_);
	if (initial != NULL) {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = gee_collection_get_size (initial);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_ > 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GeeArrayList* created_views = NULL;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp15_;
		GeeCollection* _tmp16_;
		GeeCollection* _tmp17_;
		_tmp6_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		created_views = _tmp6_;
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp7_;
			_tmp7_ = gee_iterable_iterator ((GeeIterable*) initial);
			_source_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				DataSource* source = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				GeeArrayList* _tmp11_;
				DataSource* _tmp12_;
				DataView* _tmp13_;
				DataView* _tmp14_;
				_tmp8_ = _source_it;
				if (!gee_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = _source_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				source = (DataSource*) _tmp10_;
				_tmp11_ = created_views;
				_tmp12_ = source;
				_tmp13_ = view_manager_create_view (manager, _tmp12_);
				_tmp14_ = _tmp13_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp14_);
				_g_object_unref0 (_tmp14_);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
		_tmp15_ = created_views;
		_tmp16_ = data_collection_add_many ((DataCollection*) self, (GeeCollection*) _tmp15_, progress_monitor, progress_monitor_target);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp17_);
		_g_object_unref0 (created_views);
	} else {
		GeeCollection* _tmp18_;
		GeeIterable* _tmp19_;
		_tmp18_ = data_collection_get_all ((DataCollection*) sources);
		_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable);
		view_collection_add_sources (self, sources, _tmp19_, progress_monitor, progress_monitor_target);
		_g_object_unref0 (_tmp19_);
	}
	data_collection_thaw_notifications ((DataCollection*) self);
	result = (ViewCollectionMonitor*) monitor;
	return result;
}

static gpointer
_view_collection_monitor_ref0 (gpointer self)
{
	return self ? view_collection_monitor_ref (self) : NULL;
}

void
view_collection_halt_monitoring (ViewCollection* self,
                                 ViewCollectionMonitor* m)
{
	ViewCollectionMonitorImpl* monitor = NULL;
	ViewCollectionMonitorImpl* _tmp0_;
	gboolean removed = FALSE;
	GeeHashMultiMap* _tmp1_;
	SourceCollection* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = _view_collection_monitor_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImpl));
	monitor = _tmp0_;
	_tmp1_ = self->priv->monitors;
	_tmp2_ = monitor->sources;
	removed = gee_multi_map_remove ((GeeMultiMap*) _tmp1_, _tmp2_, monitor);
	_vala_assert (removed, "removed");
	_view_collection_monitor_unref0 (monitor);
}

void
view_collection_halt_all_monitoring (ViewCollection* self)
{
	GeeHashMultiMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->monitors;
	gee_multi_map_clear ((GeeMultiMap*) _tmp0_);
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static void
_view_collection_on_mirror_contents_added_data_collection_items_added (DataCollection* _sender,
                                                                       GeeIterable* added,
                                                                       gpointer self)
{
	view_collection_on_mirror_contents_added ((ViewCollection*) self, added);
}

static void
_view_collection_on_mirror_contents_removed_data_collection_items_removed (DataCollection* _sender,
                                                                           GeeIterable* removed,
                                                                           gpointer self)
{
	view_collection_on_mirror_contents_removed ((ViewCollection*) self, removed);
}

void
view_collection_mirror (ViewCollection* self,
                        ViewCollection* to_mirror,
                        CreateView mirroring_ctor,
                        gpointer mirroring_ctor_target,
                        CreateViewPredicate should_mirror,
                        gpointer should_mirror_target)
{
	ViewCollection* _tmp0_;
	gpointer _tmp1_ = NULL;
	Comparator _tmp2_;
	gpointer _tmp3_ = NULL;
	ComparatorPredicate _tmp4_;
	ViewCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	ViewCollection* _tmp8_;
	ViewCollection* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_mirror != NULL);
	view_collection_halt_mirroring (self);
	view_collection_halt_all_monitoring (self);
	data_collection_clear ((DataCollection*) self);
	_tmp0_ = _data_collection_ref0 (to_mirror);
	_data_collection_unref0 (self->priv->mirroring);
	self->priv->mirroring = _tmp0_;
	self->priv->mirroring_ctor = mirroring_ctor;
	self->priv->mirroring_ctor_target = mirroring_ctor_target;
	self->priv->should_mirror = should_mirror;
	self->priv->should_mirror_target = should_mirror_target;
	_tmp2_ = data_collection_get_comparator ((DataCollection*) to_mirror, &_tmp1_);
	_tmp4_ = data_collection_get_comparator_predicate ((DataCollection*) to_mirror, &_tmp3_);
	data_collection_set_comparator ((DataCollection*) self, _tmp2_, _tmp1_, _tmp4_, _tmp3_);
	_tmp5_ = self->priv->mirroring;
	_tmp6_ = data_collection_get_all ((DataCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	view_collection_on_mirror_contents_added (self, (GeeIterable*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->mirroring;
	g_signal_connect ((DataCollection*) _tmp8_, "items-added", (GCallback) _view_collection_on_mirror_contents_added_data_collection_items_added, self);
	_tmp9_ = self->priv->mirroring;
	g_signal_connect ((DataCollection*) _tmp9_, "items-removed", (GCallback) _view_collection_on_mirror_contents_removed_data_collection_items_removed, self);
}

void
view_collection_halt_mirroring (ViewCollection* self)
{
	ViewCollection* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mirroring;
	if (_tmp0_ != NULL) {
		ViewCollection* _tmp1_;
		guint _tmp2_;
		ViewCollection* _tmp3_;
		guint _tmp4_;
		_tmp1_ = self->priv->mirroring;
		g_signal_parse_name ("items-added", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((DataCollection*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _view_collection_on_mirror_contents_added_data_collection_items_added, self);
		_tmp3_ = self->priv->mirroring;
		g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((DataCollection*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _view_collection_on_mirror_contents_removed_data_collection_items_removed, self);
	}
	_data_collection_unref0 (self->priv->mirroring);
	self->priv->mirroring = NULL;
}

void
view_collection_copy_into (ViewCollection* self,
                           ViewCollection* to_copy,
                           CreateView copying_ctor,
                           gpointer copying_ctor_target,
                           CreateViewPredicate should_copy,
                           gpointer should_copy_target)
{
	GeeArrayList* copy_view = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp19_;
	GeeCollection* _tmp20_;
	GeeCollection* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_copy != NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	copy_view = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp1_ = data_collection_get_all ((DataCollection*) to_copy);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DataView* view = NULL;
			DataObject* _tmp8_;
			DataView* _tmp9_;
			DataView* _tmp10_;
			DataSource* _tmp11_;
			DataSource* _tmp12_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_VIEW, DataView));
			view = _tmp9_;
			_tmp10_ = view;
			_tmp11_ = data_view_get_source (_tmp10_);
			_tmp12_ = _tmp11_;
			if (should_copy (_tmp12_, should_copy_target)) {
				GeeArrayList* _tmp13_;
				DataView* _tmp14_;
				DataSource* _tmp15_;
				DataSource* _tmp16_;
				DataView* _tmp17_;
				DataView* _tmp18_;
				_tmp13_ = copy_view;
				_tmp14_ = view;
				_tmp15_ = data_view_get_source (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = copying_ctor (_tmp16_, copying_ctor_target);
				_tmp18_ = _tmp17_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, (DataObject*) _tmp18_);
				_g_object_unref0 (_tmp18_);
			}
			_g_object_unref0 (view);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp19_ = copy_view;
	_tmp20_ = data_collection_add_many ((DataCollection*) self, (GeeCollection*) _tmp19_, NULL, NULL);
	_tmp21_ = _tmp20_;
	_g_object_unref0 (_tmp21_);
	_g_object_unref0 (copy_view);
}

gboolean
view_collection_is_view_filter_installed (ViewCollection* self,
                                          ViewFilter* f)
{
	GeeSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (f != NULL, FALSE);
	_tmp0_ = self->priv->filters;
	result = gee_collection_contains ((GeeCollection*) _tmp0_, f);
	return result;
}

void
view_collection_install_view_filter (ViewCollection* self,
                                     ViewFilter* f)
{
	GeeSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	if (view_collection_is_view_filter_installed (self, f)) {
		return;
	}
	_tmp0_ = self->priv->filters;
	gee_collection_add ((GeeCollection*) _tmp0_, f);
	g_signal_connect (f, "refresh", (GCallback) _view_collection_on_view_filter_refresh_view_filter_refresh, self);
	view_collection_on_view_filter_refresh (self);
	view_collection_notify_view_filter_installed (self, f);
}

void
view_collection_remove_view_filter (ViewCollection* self,
                                    ViewFilter* f)
{
	GeeSet* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	if (!view_collection_is_view_filter_installed (self, f)) {
		return;
	}
	_tmp0_ = self->priv->filters;
	gee_collection_remove ((GeeCollection*) _tmp0_, f);
	g_signal_parse_name ("refresh", TYPE_VIEW_FILTER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (f, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _view_collection_on_view_filter_refresh_view_filter_refresh, self);
	view_collection_on_view_filter_refresh (self);
	view_collection_notify_view_filter_removed (self, f);
}

static void
view_collection_on_view_filter_refresh (ViewCollection* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	view_collection_filter_altered_items (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static gboolean
view_collection_is_in_filter (ViewCollection* self,
                              DataView* view)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (view != NULL, FALSE);
	{
		GeeIterator* _f_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->filters;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_f_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			ViewFilter* f = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			ViewFilter* _tmp5_;
			_tmp2_ = _f_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _f_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			f = (ViewFilter*) _tmp4_;
			_tmp5_ = f;
			if (!view_filter_predicate (_tmp5_, view)) {
				result = FALSE;
				_view_filter_unref0 (f);
				_g_object_unref0 (_f_it);
				return result;
			}
			_view_filter_unref0 (f);
		}
		_g_object_unref0 (_f_it);
	}
	result = TRUE;
	return result;
}

static gboolean
view_collection_real_valid_type (DataCollection* base,
                                 DataObject* object)
{
	ViewCollection * self;
	gboolean result;
	self = (ViewCollection*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	result = IS_DATA_VIEW (object);
	return result;
}

static void
view_collection_on_sources_added (ViewCollection* self,
                                  DataCollection* sources,
                                  GeeIterable* added)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (sources != NULL);
	g_return_if_fail (added != NULL);
	view_collection_add_sources (self, G_TYPE_CHECK_INSTANCE_CAST (sources, TYPE_SOURCE_COLLECTION, SourceCollection), added, NULL, NULL);
}

static DataView*
_view_manager_create_view_create_view (DataSource* source,
                                       gpointer self)
{
	DataView* result;
	result = view_manager_create_view ((ViewManager*) self, source);
	return result;
}

static void
view_collection_add_sources (ViewCollection* self,
                             SourceCollection* sources,
                             GeeIterable* added,
                             ProgressMonitor progress_monitor,
                             gpointer progress_monitor_target)
{
	DataView* created_view = NULL;
	GeeArrayList* created_views = NULL;
	DataView* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sources != NULL);
	g_return_if_fail (added != NULL);
	created_view = NULL;
	created_views = NULL;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (added);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			CreateView factory = NULL;
			gpointer factory_target;
			GDestroyNotify factory_target_destroy_notify;
			CreateView _tmp17_;
			gpointer _tmp17__target;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			factory = NULL;
			factory_target = NULL;
			factory_target_destroy_notify = NULL;
			{
				GeeIterator* _monitor_it = NULL;
				GeeHashMultiMap* _tmp4_;
				GeeCollection* _tmp5_;
				GeeCollection* _tmp6_;
				GeeIterator* _tmp7_;
				GeeIterator* _tmp8_;
				_tmp4_ = self->priv->monitors;
				_tmp5_ = gee_multi_map_get ((GeeMultiMap*) _tmp4_, sources);
				_tmp6_ = _tmp5_;
				_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp6_);
				_monitor_it = _tmp8_;
				while (TRUE) {
					GeeIterator* _tmp9_;
					ViewCollectionMonitorImpl* monitor = NULL;
					GeeIterator* _tmp10_;
					gpointer _tmp11_;
					ViewCollectionMonitorImpl* _tmp12_;
					ViewManager* _tmp13_;
					DataSource* _tmp14_;
					_tmp9_ = _monitor_it;
					if (!gee_iterator_next (_tmp9_)) {
						break;
					}
					_tmp10_ = _monitor_it;
					_tmp11_ = gee_iterator_get (_tmp10_);
					monitor = (ViewCollectionMonitorImpl*) _tmp11_;
					_tmp12_ = monitor;
					_tmp13_ = _tmp12_->manager;
					_tmp14_ = source;
					if (view_manager_include_in_view (_tmp13_, _tmp14_)) {
						ViewCollectionMonitorImpl* _tmp15_;
						ViewManager* _tmp16_;
						_tmp15_ = monitor;
						_tmp16_ = _tmp15_->manager;
						(factory_target_destroy_notify == NULL) ? NULL : (factory_target_destroy_notify (factory_target), NULL);
						factory = NULL;
						factory_target = NULL;
						factory_target_destroy_notify = NULL;
						factory = _view_manager_create_view_create_view;
						factory_target = view_manager_ref (_tmp16_);
						factory_target_destroy_notify = view_manager_unref;
						_view_collection_monitor_unref0 (monitor);
						break;
					}
					_view_collection_monitor_unref0 (monitor);
				}
				_g_object_unref0 (_monitor_it);
			}
			_tmp17_ = factory;
			_tmp17__target = factory_target;
			if (_tmp17_ != NULL) {
				DataView* new_view = NULL;
				CreateView _tmp18_;
				gpointer _tmp18__target;
				DataSource* _tmp19_;
				DataView* _tmp20_;
				GeeArrayList* _tmp21_;
				_tmp18_ = factory;
				_tmp18__target = factory_target;
				_tmp19_ = source;
				_tmp20_ = _tmp18_ (_tmp19_, _tmp18__target);
				new_view = _tmp20_;
				_tmp21_ = created_views;
				if (_tmp21_ != NULL) {
					GeeArrayList* _tmp22_;
					DataView* _tmp23_;
					_tmp22_ = created_views;
					_tmp23_ = new_view;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
				} else {
					DataView* _tmp24_;
					_tmp24_ = created_view;
					if (_tmp24_ == NULL) {
						DataView* _tmp25_;
						DataView* _tmp26_;
						_tmp25_ = new_view;
						_tmp26_ = _g_object_ref0 (_tmp25_);
						_g_object_unref0 (created_view);
						created_view = _tmp26_;
					} else {
						GeeArrayList* _tmp27_;
						GeeArrayList* _tmp28_;
						DataView* _tmp29_;
						GeeArrayList* _tmp30_;
						DataView* _tmp31_;
						_tmp27_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						_g_object_unref0 (created_views);
						created_views = _tmp27_;
						_tmp28_ = created_views;
						_tmp29_ = created_view;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp29_);
						_g_object_unref0 (created_view);
						created_view = NULL;
						_tmp30_ = created_views;
						_tmp31_ = new_view;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp31_);
					}
				}
				_g_object_unref0 (new_view);
			}
			(factory_target_destroy_notify == NULL) ? NULL : (factory_target_destroy_notify (factory_target), NULL);
			factory = NULL;
			factory_target = NULL;
			factory_target_destroy_notify = NULL;
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp32_ = created_view;
	if (_tmp32_ != NULL) {
		DataView* _tmp33_;
		_tmp33_ = created_view;
		data_collection_add ((DataCollection*) self, (DataObject*) _tmp33_);
	} else {
		gboolean _tmp34_ = FALSE;
		GeeArrayList* _tmp35_;
		_tmp35_ = created_views;
		if (_tmp35_ != NULL) {
			GeeArrayList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			_tmp36_ = created_views;
			_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp34_ = _tmp38_ > 0;
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			GeeArrayList* _tmp39_;
			GeeCollection* _tmp40_;
			GeeCollection* _tmp41_;
			_tmp39_ = created_views;
			_tmp40_ = data_collection_add_many ((DataCollection*) self, (GeeCollection*) _tmp39_, progress_monitor, progress_monitor_target);
			_tmp41_ = _tmp40_;
			_g_object_unref0 (_tmp41_);
		}
	}
	_g_object_unref0 (created_views);
	_g_object_unref0 (created_view);
}

static gboolean
view_collection_real_add (DataCollection* base,
                          DataObject* object)
{
	ViewCollection * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean result;
	self = (ViewCollection*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	data_view_internal_set_visible (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView), TRUE);
	if (!DATA_COLLECTION_CLASS (view_collection_parent_class)->add (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), object)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = data_collection_get_singleton (object);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	view_collection_filter_altered_items (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	result = TRUE;
	return result;
}

static GeeCollection*
view_collection_real_add_many (DataCollection* base,
                               GeeCollection* objects,
                               ProgressMonitor monitor,
                               gpointer monitor_target)
{
	ViewCollection * self;
	GeeCollection* return_list = NULL;
	GeeCollection* _tmp5_;
	GeeCollection* result;
	self = (ViewCollection*) base;
	g_return_val_if_fail (objects != NULL, NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) objects);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataObject* _tmp4_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			data_view_internal_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_VIEW, DataView), TRUE);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp5_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), objects, monitor, monitor_target);
	return_list = _tmp5_;
	view_collection_filter_altered_items (self, G_TYPE_CHECK_INSTANCE_CAST (return_list, GEE_TYPE_COLLECTION, GeeCollection));
	result = return_list;
	return result;
}

static void
view_collection_on_sources_removed (ViewCollection* self,
                                    GeeIterable* removed)
{
	Marker* marker = NULL;
	gboolean _tmp12_ = FALSE;
	Marker* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (removed != NULL);
	marker = NULL;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (removed);
		_source_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataView* view = NULL;
			GeeHashMap* _tmp4_;
			DataSource* _tmp5_;
			gpointer _tmp6_;
			DataView* _tmp7_;
			_tmp1_ = _source_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _source_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			source = (DataSource*) _tmp3_;
			_tmp4_ = self->priv->source_map;
			_tmp5_ = source;
			_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
			view = (DataView*) _tmp6_;
			_tmp7_ = view;
			if (_tmp7_ != NULL) {
				Marker* _tmp8_;
				Marker* _tmp10_;
				DataView* _tmp11_;
				_tmp8_ = marker;
				if (_tmp8_ == NULL) {
					Marker* _tmp9_;
					_tmp9_ = data_collection_start_marking ((DataCollection*) self);
					_g_object_unref0 (marker);
					marker = _tmp9_;
				}
				_tmp10_ = marker;
				_tmp11_ = view;
				marker_mark (_tmp10_, (DataObject*) _tmp11_);
			}
			_g_object_unref0 (view);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	_tmp13_ = marker;
	if (_tmp13_ != NULL) {
		Marker* _tmp14_;
		_tmp14_ = marker;
		_tmp12_ = marker_get_count (_tmp14_) != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		Marker* _tmp15_;
		_tmp15_ = marker;
		data_collection_remove_marked ((DataCollection*) self, _tmp15_);
	}
	_g_object_unref0 (marker);
}

static void
view_collection_on_sources_altered (ViewCollection* self,
                                    DataCollection* collection,
                                    GeeMap* items)
{
	GeeArrayList* to_add = NULL;
	GeeArrayList* to_remove = NULL;
	gboolean ordering_changed = FALSE;
	GeeArrayList* _tmp68_;
	GeeArrayList* _tmp72_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (collection != NULL);
	g_return_if_fail (items != NULL);
	to_add = NULL;
	to_remove = NULL;
	ordering_changed = FALSE;
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (items);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Alteration* alteration = NULL;
			DataObject* _tmp8_;
			gpointer _tmp9_;
			DataSource* source = NULL;
			DataObject* _tmp10_;
			DataSource* _tmp11_;
			ViewCollectionMonitorImpl* monitor = NULL;
			gboolean ignored = FALSE;
			gboolean _tmp32_ = FALSE;
			ViewCollectionMonitorImpl* _tmp33_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = gee_map_get (items, _tmp8_);
			alteration = (Alteration*) _tmp9_;
			_tmp10_ = object;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_SOURCE, DataSource));
			source = _tmp11_;
			monitor = NULL;
			ignored = TRUE;
			{
				GeeIterator* _monitor_impl_it = NULL;
				GeeHashMultiMap* _tmp12_;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				GeeIterator* _tmp15_;
				GeeIterator* _tmp16_;
				_tmp12_ = self->priv->monitors;
				_tmp13_ = gee_multi_map_get ((GeeMultiMap*) _tmp12_, G_TYPE_CHECK_INSTANCE_CAST (collection, TYPE_SOURCE_COLLECTION, SourceCollection));
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_monitor_impl_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_;
					ViewCollectionMonitorImpl* monitor_impl = NULL;
					GeeIterator* _tmp18_;
					gpointer _tmp19_;
					gboolean _tmp20_ = FALSE;
					ViewCollectionMonitorImpl* _tmp21_;
					Alteration* _tmp22_;
					ViewCollectionMonitorImpl* _tmp26_;
					ViewManager* _tmp27_;
					DataSource* _tmp28_;
					_tmp17_ = _monitor_impl_it;
					if (!gee_iterator_next (_tmp17_)) {
						break;
					}
					_tmp18_ = _monitor_impl_it;
					_tmp19_ = gee_iterator_get (_tmp18_);
					monitor_impl = (ViewCollectionMonitorImpl*) _tmp19_;
					_tmp21_ = monitor_impl;
					_tmp22_ = _tmp21_->prereq;
					if (_tmp22_ != NULL) {
						Alteration* _tmp23_;
						ViewCollectionMonitorImpl* _tmp24_;
						Alteration* _tmp25_;
						_tmp23_ = alteration;
						_tmp24_ = monitor_impl;
						_tmp25_ = _tmp24_->prereq;
						_tmp20_ = !alteration_contains_any (_tmp23_, _tmp25_);
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						_view_collection_monitor_unref0 (monitor_impl);
						continue;
					}
					ignored = FALSE;
					_tmp26_ = monitor_impl;
					_tmp27_ = _tmp26_->manager;
					_tmp28_ = source;
					if (view_manager_include_in_view (_tmp27_, _tmp28_)) {
						ViewCollectionMonitorImpl* _tmp29_;
						ViewCollectionMonitorImpl* _tmp30_;
						_tmp29_ = monitor_impl;
						_tmp30_ = _view_collection_monitor_ref0 (_tmp29_);
						_view_collection_monitor_unref0 (monitor);
						monitor = _tmp30_;
						_view_collection_monitor_unref0 (monitor_impl);
						break;
					}
					_view_collection_monitor_unref0 (monitor_impl);
				}
				_g_object_unref0 (_monitor_impl_it);
			}
			if (ignored) {
				ViewCollectionMonitorImpl* _tmp31_;
				_tmp31_ = monitor;
				_vala_assert (_tmp31_ == NULL, "monitor == null");
				_view_collection_monitor_unref0 (monitor);
				_g_object_unref0 (source);
				_alteration_unref0 (alteration);
				_g_object_unref0 (object);
				continue;
			}
			_tmp33_ = monitor;
			if (_tmp33_ != NULL) {
				DataSource* _tmp34_;
				_tmp34_ = source;
				_tmp32_ = !view_collection_has_view_for_source (self, _tmp34_);
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				GeeArrayList* _tmp35_;
				GeeArrayList* _tmp37_;
				ViewCollectionMonitorImpl* _tmp38_;
				ViewManager* _tmp39_;
				DataSource* _tmp40_;
				DataView* _tmp41_;
				DataView* _tmp42_;
				_tmp35_ = to_add;
				if (_tmp35_ == NULL) {
					GeeArrayList* _tmp36_;
					_tmp36_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (to_add);
					to_add = _tmp36_;
				}
				_tmp37_ = to_add;
				_tmp38_ = monitor;
				_tmp39_ = _tmp38_->manager;
				_tmp40_ = source;
				_tmp41_ = view_manager_create_view (_tmp39_, _tmp40_);
				_tmp42_ = _tmp41_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, _tmp42_);
				_g_object_unref0 (_tmp42_);
			} else {
				gboolean _tmp43_ = FALSE;
				ViewCollectionMonitorImpl* _tmp44_;
				_tmp44_ = monitor;
				if (_tmp44_ == NULL) {
					DataSource* _tmp45_;
					_tmp45_ = source;
					_tmp43_ = view_collection_has_view_for_source (self, _tmp45_);
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					GeeArrayList* _tmp46_;
					GeeArrayList* _tmp48_;
					DataSource* _tmp49_;
					DataView* _tmp50_;
					DataView* _tmp51_;
					_tmp46_ = to_remove;
					if (_tmp46_ == NULL) {
						GeeArrayList* _tmp47_;
						_tmp47_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						_g_object_unref0 (to_remove);
						to_remove = _tmp47_;
					}
					_tmp48_ = to_remove;
					_tmp49_ = source;
					_tmp50_ = view_collection_get_view_for_source (self, _tmp49_);
					_tmp51_ = _tmp50_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp51_);
					_g_object_unref0 (_tmp51_);
				} else {
					gboolean _tmp52_ = FALSE;
					ViewCollectionMonitorImpl* _tmp53_;
					_tmp53_ = monitor;
					if (_tmp53_ != NULL) {
						DataSource* _tmp54_;
						_tmp54_ = source;
						_tmp52_ = view_collection_has_view_for_source (self, _tmp54_);
					} else {
						_tmp52_ = FALSE;
					}
					if (_tmp52_) {
						DataView* view = NULL;
						DataSource* _tmp55_;
						DataView* _tmp56_;
						DataSet* _tmp57_;
						DataView* _tmp58_;
						gboolean _tmp62_ = FALSE;
						DataSet* _tmp63_;
						_tmp55_ = source;
						_tmp56_ = view_collection_get_view_for_source (self, _tmp55_);
						view = _tmp56_;
						_tmp57_ = self->priv->selected;
						_tmp58_ = view;
						if (data_set_contains (_tmp57_, (DataObject*) _tmp58_)) {
							DataSet* _tmp59_;
							DataView* _tmp60_;
							Alteration* _tmp61_;
							_tmp59_ = self->priv->selected;
							_tmp60_ = view;
							_tmp61_ = alteration;
							data_set_resort_object (_tmp59_, (DataObject*) _tmp60_, _tmp61_);
						}
						_tmp63_ = self->priv->visible;
						if (_tmp63_ != NULL) {
							DataView* _tmp64_;
							_tmp64_ = view;
							_tmp62_ = view_collection_is_visible (self, _tmp64_);
						} else {
							_tmp62_ = FALSE;
						}
						if (_tmp62_) {
							DataSet* _tmp65_;
							DataView* _tmp66_;
							Alteration* _tmp67_;
							_tmp65_ = self->priv->visible;
							_tmp66_ = view;
							_tmp67_ = alteration;
							if (data_set_resort_object (_tmp65_, (DataObject*) _tmp66_, _tmp67_)) {
								ordering_changed = TRUE;
							}
						}
						_g_object_unref0 (view);
					}
				}
			}
			_view_collection_monitor_unref0 (monitor);
			_g_object_unref0 (source);
			_alteration_unref0 (alteration);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp68_ = to_add;
	if (_tmp68_ != NULL) {
		GeeArrayList* _tmp69_;
		GeeCollection* _tmp70_;
		GeeCollection* _tmp71_;
		_tmp69_ = to_add;
		_tmp70_ = data_collection_add_many ((DataCollection*) self, (GeeCollection*) _tmp69_, NULL, NULL);
		_tmp71_ = _tmp70_;
		_g_object_unref0 (_tmp71_);
	}
	_tmp72_ = to_remove;
	if (_tmp72_ != NULL) {
		GeeArrayList* _tmp73_;
		Marker* _tmp74_;
		Marker* _tmp75_;
		_tmp73_ = to_remove;
		_tmp74_ = data_collection_mark_many ((DataCollection*) self, (GeeCollection*) _tmp73_);
		_tmp75_ = _tmp74_;
		data_collection_remove_marked ((DataCollection*) self, _tmp75_);
		_g_object_unref0 (_tmp75_);
	}
	if (ordering_changed) {
		data_collection_notify_ordering_changed ((DataCollection*) self);
	}
	_g_object_unref0 (to_remove);
	_g_object_unref0 (to_add);
}

static void
view_collection_on_mirror_contents_added (ViewCollection* self,
                                          GeeIterable* added)
{
	GeeArrayList* to_add = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	to_add = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (added);
		_object_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataObject* object = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			DataSource* source = NULL;
			DataObject* _tmp5_;
			DataSource* _tmp6_;
			DataSource* _tmp7_;
			DataSource* _tmp8_;
			gboolean _tmp9_ = FALSE;
			CreateViewPredicate _tmp10_;
			gpointer _tmp10__target;
			_tmp2_ = _object_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _object_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			object = (DataObject*) _tmp4_;
			_tmp5_ = object;
			_tmp6_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_VIEW, DataView));
			_tmp7_ = _tmp6_;
			_tmp8_ = _g_object_ref0 (_tmp7_);
			source = _tmp8_;
			_tmp10_ = self->priv->should_mirror;
			_tmp10__target = self->priv->should_mirror_target;
			if (_tmp10_ == NULL) {
				_tmp9_ = TRUE;
			} else {
				CreateViewPredicate _tmp11_;
				gpointer _tmp11__target;
				DataSource* _tmp12_;
				_tmp11_ = self->priv->should_mirror;
				_tmp11__target = self->priv->should_mirror_target;
				_tmp12_ = source;
				_tmp9_ = _tmp11_ (_tmp12_, _tmp11__target);
			}
			if (_tmp9_) {
				GeeArrayList* _tmp13_;
				CreateView _tmp14_;
				gpointer _tmp14__target;
				DataSource* _tmp15_;
				DataView* _tmp16_;
				DataView* _tmp17_;
				_tmp13_ = to_add;
				_tmp14_ = self->priv->mirroring_ctor;
				_tmp14__target = self->priv->mirroring_ctor_target;
				_tmp15_ = source;
				_tmp16_ = _tmp14_ (_tmp15_, _tmp14__target);
				_tmp17_ = _tmp16_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp17_);
				_g_object_unref0 (_tmp17_);
			}
			_g_object_unref0 (source);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp18_ = to_add;
	_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ > 0) {
		GeeArrayList* _tmp21_;
		GeeCollection* _tmp22_;
		GeeCollection* _tmp23_;
		_tmp21_ = to_add;
		_tmp22_ = data_collection_add_many ((DataCollection*) self, (GeeCollection*) _tmp21_, NULL, NULL);
		_tmp23_ = _tmp22_;
		_g_object_unref0 (_tmp23_);
	}
	_g_object_unref0 (to_add);
}

static void
view_collection_on_mirror_contents_removed (ViewCollection* self,
                                            GeeIterable* removed)
{
	Marker* marker = NULL;
	Marker* _tmp0_;
	Marker* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = data_collection_start_marking ((DataCollection*) self);
	marker = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (removed);
		_object_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataObject* object = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			DataView* view = NULL;
			DataObject* _tmp5_;
			DataView* _tmp6_;
			DataView* our_view = NULL;
			DataView* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			DataView* _tmp10_;
			DataView* _tmp11_;
			Marker* _tmp12_;
			DataView* _tmp13_;
			_tmp2_ = _object_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _object_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			object = (DataObject*) _tmp4_;
			_tmp5_ = object;
			_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_VIEW, DataView));
			view = _tmp6_;
			_tmp7_ = view;
			_tmp8_ = data_view_get_source (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = view_collection_get_view_for_source (self, _tmp9_);
			our_view = _tmp10_;
			_tmp11_ = our_view;
			_vala_assert (_tmp11_ != NULL, "our_view != null");
			_tmp12_ = marker;
			_tmp13_ = our_view;
			marker_mark (_tmp12_, (DataObject*) _tmp13_);
			_g_object_unref0 (our_view);
			_g_object_unref0 (view);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp14_ = marker;
	data_collection_remove_marked ((DataCollection*) self, _tmp14_);
	_g_object_unref0 (marker);
}

static void
view_collection_real_notify_items_added (DataCollection* base,
                                         GeeIterable* added)
{
	ViewCollection * self;
	GeeArrayList* added_visible = NULL;
	GeeArrayList* added_selected = NULL;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp27_;
	self = (ViewCollection*) base;
	g_return_if_fail (added != NULL);
	added_visible = NULL;
	added_selected = NULL;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (added);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataView* view = NULL;
			DataObject* _tmp4_;
			DataView* _tmp5_;
			GeeHashMap* _tmp6_;
			DataView* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			DataView* _tmp10_;
			gboolean _tmp11_ = FALSE;
			DataView* _tmp12_;
			gboolean _tmp18_ = FALSE;
			DataView* _tmp19_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_VIEW, DataView));
			view = _tmp5_;
			_tmp6_ = self->priv->source_map;
			_tmp7_ = view;
			_tmp8_ = data_view_get_source (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = view;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp9_, _tmp10_);
			_tmp12_ = view;
			if (data_view_is_selected (_tmp12_)) {
				DataView* _tmp13_;
				_tmp13_ = view;
				_tmp11_ = data_view_is_visible (_tmp13_);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				GeeArrayList* _tmp14_;
				GeeArrayList* _tmp16_;
				DataView* _tmp17_;
				_tmp14_ = added_selected;
				if (_tmp14_ == NULL) {
					GeeArrayList* _tmp15_;
					_tmp15_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (added_selected);
					added_selected = _tmp15_;
				}
				_tmp16_ = added_selected;
				_tmp17_ = view;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
			}
			_tmp19_ = view;
			if (data_view_is_visible (_tmp19_)) {
				DataSet* _tmp20_;
				_tmp20_ = self->priv->visible;
				_tmp18_ = _tmp20_ != NULL;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				GeeArrayList* _tmp21_;
				GeeArrayList* _tmp23_;
				DataView* _tmp24_;
				_tmp21_ = added_visible;
				if (_tmp21_ == NULL) {
					GeeArrayList* _tmp22_;
					_tmp22_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (added_visible);
					added_visible = _tmp22_;
				}
				_tmp23_ = added_visible;
				_tmp24_ = view;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
			}
			_g_object_unref0 (view);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp25_ = added_visible;
	if (_tmp25_ != NULL) {
		gboolean is_added = FALSE;
		GeeArrayList* _tmp26_;
		_tmp26_ = added_visible;
		is_added = view_collection_add_many_visible (self, (GeeCollection*) _tmp26_);
		_vala_assert (is_added, "is_added");
	}
	_tmp27_ = added_selected;
	if (_tmp27_ != NULL) {
		GeeArrayList* _tmp28_;
		GeeArrayList* _tmp29_;
		_tmp28_ = added_selected;
		view_collection_add_many_selected (self, (GeeCollection*) _tmp28_);
		_tmp29_ = added_selected;
		view_collection_notify_items_selected_unselected (self, (GeeCollection*) _tmp29_, NULL);
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->notify_items_added (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), added);
	_g_object_unref0 (added_selected);
	_g_object_unref0 (added_visible);
}

static void
view_collection_real_notify_items_removed (DataCollection* base,
                                           GeeIterable* removed)
{
	ViewCollection * self;
	GeeArrayList* selected_removed = NULL;
	GeeArrayList* _tmp28_;
	self = (ViewCollection*) base;
	g_return_if_fail (removed != NULL);
	selected_removed = NULL;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (removed);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataView* view = NULL;
			DataObject* _tmp4_;
			DataView* _tmp5_;
			GeeHashMap* _tmp6_;
			DataView* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = object;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_VIEW, DataView));
			view = _tmp5_;
			_tmp6_ = self->priv->source_map;
			_tmp7_ = view;
			_tmp8_ = data_view_get_source (_tmp7_);
			_tmp9_ = _tmp8_;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _tmp9_)) {
				gboolean is_removed = FALSE;
				GeeHashMap* _tmp10_;
				DataView* _tmp11_;
				DataSource* _tmp12_;
				DataSource* _tmp13_;
				DataView* _tmp14_;
				gboolean _tmp23_ = FALSE;
				DataView* _tmp24_;
				_tmp10_ = self->priv->source_map;
				_tmp11_ = view;
				_tmp12_ = data_view_get_source (_tmp11_);
				_tmp13_ = _tmp12_;
				is_removed = gee_abstract_map_unset ((GeeAbstractMap*) _tmp10_, _tmp13_, NULL);
				_vala_assert (is_removed, "is_removed");
				_tmp14_ = view;
				if (data_view_is_selected (_tmp14_)) {
					DataSet* _tmp15_;
					DataView* _tmp16_;
					DataView* _tmp17_;
					DataView* _tmp18_;
					_tmp15_ = self->priv->selected;
					_tmp16_ = view;
					_tmp17_ = view;
					_vala_assert (data_set_contains (_tmp15_, (DataObject*) _tmp16_) == data_view_is_visible (_tmp17_), "selected.contains (view) == view.is_visible ()");
					_tmp18_ = view;
					if (data_view_is_visible (_tmp18_)) {
						GeeArrayList* _tmp19_;
						GeeArrayList* _tmp21_;
						DataView* _tmp22_;
						_tmp19_ = selected_removed;
						if (_tmp19_ == NULL) {
							GeeArrayList* _tmp20_;
							_tmp20_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
							_g_object_unref0 (selected_removed);
							selected_removed = _tmp20_;
						}
						_tmp21_ = selected_removed;
						_tmp22_ = view;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
					}
				}
				_tmp24_ = view;
				if (data_view_is_visible (_tmp24_)) {
					DataSet* _tmp25_;
					_tmp25_ = self->priv->visible;
					_tmp23_ = _tmp25_ != NULL;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					DataSet* _tmp26_;
					DataView* _tmp27_;
					_tmp26_ = self->priv->visible;
					_tmp27_ = view;
					is_removed = data_set_remove (_tmp26_, (DataObject*) _tmp27_);
					_vala_assert (is_removed, "is_removed");
				}
			}
			_g_object_unref0 (view);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp28_ = selected_removed;
	if (_tmp28_ != NULL) {
		GeeArrayList* _tmp29_;
		_tmp29_ = selected_removed;
		view_collection_remove_many_selected (self, (GeeCollection*) _tmp29_);
		view_collection_notify_selection_group_altered (self);
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->notify_items_removed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), removed);
	_g_object_unref0 (selected_removed);
}

static void
view_collection_filter_altered_items (ViewCollection* self,
                                      GeeCollection* views)
{
	GeeArrayList* to_show = NULL;
	GeeArrayList* to_hide = NULL;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (views != NULL);
	to_show = NULL;
	to_hide = NULL;
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) views);
		_view_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataView* view = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataView* _tmp4_;
			_tmp1_ = _view_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _view_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			view = (DataView*) _tmp3_;
			_tmp4_ = view;
			if (view_collection_is_in_filter (self, _tmp4_)) {
				DataView* _tmp5_;
				_tmp5_ = view;
				if (!data_view_is_visible (_tmp5_)) {
					GeeArrayList* _tmp6_;
					GeeArrayList* _tmp8_;
					DataView* _tmp9_;
					_tmp6_ = to_show;
					if (_tmp6_ == NULL) {
						GeeArrayList* _tmp7_;
						_tmp7_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						_g_object_unref0 (to_show);
						to_show = _tmp7_;
					}
					_tmp8_ = to_show;
					_tmp9_ = view;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				}
			} else {
				DataView* _tmp10_;
				_tmp10_ = view;
				if (data_view_is_visible (_tmp10_)) {
					GeeArrayList* _tmp11_;
					GeeArrayList* _tmp13_;
					DataView* _tmp14_;
					_tmp11_ = to_hide;
					if (_tmp11_ == NULL) {
						GeeArrayList* _tmp12_;
						_tmp12_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
						_g_object_unref0 (to_hide);
						to_hide = _tmp12_;
					}
					_tmp13_ = to_hide;
					_tmp14_ = view;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
				}
			}
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
	_tmp15_ = to_show;
	if (_tmp15_ != NULL) {
		GeeArrayList* _tmp16_;
		_tmp16_ = to_show;
		view_collection_show_items (self, (GeeList*) _tmp16_);
	}
	_tmp17_ = to_hide;
	if (_tmp17_ != NULL) {
		GeeArrayList* _tmp18_;
		_tmp18_ = to_hide;
		view_collection_hide_items (self, (GeeList*) _tmp18_);
	}
	_g_object_unref0 (to_hide);
	_g_object_unref0 (to_show);
}

static void
view_collection_real_items_altered (DataCollection* base,
                                    GeeMap* map)
{
	ViewCollection * self;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeCollection* _tmp2_;
	self = (ViewCollection*) base;
	g_return_if_fail (map != NULL);
	_tmp0_ = gee_map_get_keys (map);
	_tmp1_ = _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
	view_collection_filter_altered_items (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	DATA_COLLECTION_CLASS (view_collection_parent_class)->items_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), map);
}

static void
view_collection_real_set_comparator (DataCollection* base,
                                     Comparator comparator,
                                     gpointer comparator_target,
                                     ComparatorPredicate predicate,
                                     gpointer predicate_target)
{
	ViewCollection * self;
	DataSet* _tmp0_;
	DataSet* _tmp1_;
	self = (ViewCollection*) base;
	_tmp0_ = self->priv->selected;
	data_set_set_comparator (_tmp0_, comparator, comparator_target, predicate, predicate_target);
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		_tmp2_ = self->priv->visible;
		data_set_set_comparator (_tmp2_, comparator, comparator_target, predicate, predicate_target);
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->set_comparator (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), comparator, comparator_target, predicate, predicate_target);
}

static void
view_collection_real_reset_comparator (DataCollection* base)
{
	ViewCollection * self;
	DataSet* _tmp0_;
	DataSet* _tmp1_;
	self = (ViewCollection*) base;
	_tmp0_ = self->priv->selected;
	data_set_reset_comparator (_tmp0_);
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		_tmp2_ = self->priv->visible;
		data_set_reset_comparator (_tmp2_);
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->reset_comparator (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
}

static GeeCollection*
view_collection_real_get_all (DataCollection* base)
{
	ViewCollection * self;
	GeeCollection* _tmp0_ = NULL;
	DataSet* _tmp1_;
	GeeCollection* result;
	self = (ViewCollection*) base;
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		GeeList* _tmp3_;
		_tmp2_ = self->priv->visible;
		_tmp3_ = data_set_get_all (_tmp2_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (GeeCollection*) _tmp3_;
	} else {
		GeeCollection* _tmp4_;
		_tmp4_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

GeeCollection*
view_collection_get_all_unfiltered (ViewCollection* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	result = _tmp0_;
	return result;
}

static gint
view_collection_real_get_count (DataCollection* base)
{
	ViewCollection * self;
	gint _tmp0_ = 0;
	DataSet* _tmp1_;
	gint result;
	self = (ViewCollection*) base;
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		_tmp2_ = self->priv->visible;
		_tmp0_ = data_set_get_count (_tmp2_);
	} else {
		_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	}
	result = _tmp0_;
	return result;
}

gint
view_collection_get_unfiltered_count (ViewCollection* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
	return result;
}

static DataObject*
view_collection_real_get_at (DataCollection* base,
                             gint index)
{
	ViewCollection * self;
	DataObject* _tmp0_ = NULL;
	DataSet* _tmp1_;
	DataObject* result;
	self = (ViewCollection*) base;
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		DataObject* _tmp3_;
		_tmp2_ = self->priv->visible;
		_tmp3_ = data_set_get_at (_tmp2_, index);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		DataObject* _tmp4_;
		_tmp4_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_at (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), index);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

static gint
view_collection_real_index_of (DataCollection* base,
                               DataObject* object)
{
	ViewCollection * self;
	gint _tmp0_ = 0;
	DataSet* _tmp1_;
	gint result;
	self = (ViewCollection*) base;
	g_return_val_if_fail (object != NULL, 0);
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		_tmp2_ = self->priv->visible;
		_tmp0_ = data_set_index_of (_tmp2_, object);
	} else {
		_tmp0_ = DATA_COLLECTION_CLASS (view_collection_parent_class)->index_of (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), object);
	}
	result = _tmp0_;
	return result;
}

static gboolean
view_collection_real_contains (DataCollection* base,
                               DataObject* object)
{
	ViewCollection * self;
	gboolean result;
	self = (ViewCollection*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	if (!DATA_COLLECTION_CLASS (view_collection_parent_class)->contains (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), object)) {
		result = FALSE;
		return result;
	}
	result = view_collection_is_visible (self, G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	return result;
}

static DataView*
view_collection_real_get_first (ViewCollection* self)
{
	DataView* _tmp0_ = NULL;
	DataView* result;
	if (data_collection_get_count ((DataCollection*) self) > 0) {
		DataObject* _tmp1_;
		_tmp1_ = data_collection_get_at ((DataCollection*) self, 0);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_VIEW, DataView);
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

DataView*
view_collection_get_first (ViewCollection* self)
{
	ViewCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->get_first) {
		return _klass_->get_first (self);
	}
	return NULL;
}

/**
     * A helper method for places in the app that need a
     * non-rejected media source (namely Events, when looking to
     * automatically choose a thumbnail).
     *
     * Note: If every view in this collection is rejected, we
     * return the first view; this is intentional.  This prevents
     * pathological events that have nothing but rejected images
     * in them from breaking.
     */
static DataView*
view_collection_real_get_first_unrejected (ViewCollection* self)
{
	DataView* dv = NULL;
	DataView* _tmp0_;
	gint num_views = 0;
	DataView* _tmp11_;
	DataView* result;
	if (data_collection_get_count ((DataCollection*) self) < 1) {
		result = NULL;
		return result;
	}
	_tmp0_ = view_collection_get_first (self);
	dv = _tmp0_;
	num_views = data_collection_get_count ((DataCollection*) self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		DataView* _tmp2_;
		MediaSource* tmp = NULL;
		DataView* _tmp4_;
		DataSource* _tmp5_;
		DataSource* _tmp6_;
		MediaSource* _tmp7_;
		MediaSource* _tmp8_;
		_tmp2_ = dv;
		if (_tmp2_ != NULL) {
			DataView* _tmp3_;
			_tmp3_ = dv;
			_tmp1_ = data_collection_index_of ((DataCollection*) self, (DataObject*) _tmp3_) < (num_views - 1);
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp4_ = dv;
		_tmp5_ = data_view_get_source (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _g_object_ref0 (IS_MEDIA_SOURCE (_tmp6_) ? ((MediaSource*) _tmp6_) : NULL);
		tmp = _tmp7_;
		_tmp8_ = tmp;
		if (_tmp8_ != NULL) {
			result = dv;
			_g_object_unref0 (tmp);
			return result;
		} else {
			DataView* _tmp9_;
			DataView* _tmp10_;
			_tmp9_ = dv;
			_tmp10_ = view_collection_get_next (self, _tmp9_);
			_g_object_unref0 (dv);
			dv = _tmp10_;
		}
		_g_object_unref0 (tmp);
	}
	_tmp11_ = view_collection_get_first (self);
	result = _tmp11_;
	_g_object_unref0 (dv);
	return result;
}

DataView*
view_collection_get_first_unrejected (ViewCollection* self)
{
	ViewCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->get_first_unrejected) {
		return _klass_->get_first_unrejected (self);
	}
	return NULL;
}

static DataView*
view_collection_real_get_last (ViewCollection* self)
{
	DataView* _tmp0_ = NULL;
	DataView* result;
	if (data_collection_get_count ((DataCollection*) self) > 0) {
		DataObject* _tmp1_;
		_tmp1_ = data_collection_get_at ((DataCollection*) self, data_collection_get_count ((DataCollection*) self) - 1);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_VIEW, DataView);
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

DataView*
view_collection_get_last (ViewCollection* self)
{
	ViewCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->get_last) {
		return _klass_->get_last (self);
	}
	return NULL;
}

static DataView*
view_collection_real_get_next (ViewCollection* self,
                               DataView* view)
{
	gint index = 0;
	gint _tmp0_;
	DataObject* _tmp1_;
	DataView* result;
	g_return_val_if_fail (view != NULL, NULL);
	if (data_collection_get_count ((DataCollection*) self) == 0) {
		result = NULL;
		return result;
	}
	index = data_collection_index_of ((DataCollection*) self, (DataObject*) view);
	if (index < 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = index;
	index = _tmp0_ + 1;
	if (index >= data_collection_get_count ((DataCollection*) self)) {
		index = 0;
	}
	_tmp1_ = data_collection_get_at ((DataCollection*) self, index);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_VIEW, DataView);
	return result;
}

DataView*
view_collection_get_next (ViewCollection* self,
                          DataView* view)
{
	ViewCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->get_next) {
		return _klass_->get_next (self, view);
	}
	return NULL;
}

static DataView*
view_collection_real_get_previous (ViewCollection* self,
                                   DataView* view)
{
	gint index = 0;
	gint _tmp0_;
	DataObject* _tmp1_;
	DataView* result;
	g_return_val_if_fail (view != NULL, NULL);
	if (data_collection_get_count ((DataCollection*) self) == 0) {
		result = NULL;
		return result;
	}
	index = data_collection_index_of ((DataCollection*) self, (DataObject*) view);
	if (index < 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = index;
	index = _tmp0_ - 1;
	if (index < 0) {
		index = data_collection_get_count ((DataCollection*) self) - 1;
	}
	_tmp1_ = data_collection_get_at ((DataCollection*) self, index);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_VIEW, DataView);
	return result;
}

DataView*
view_collection_get_previous (ViewCollection* self,
                              DataView* view)
{
	ViewCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = VIEW_COLLECTION_GET_CLASS (self);
	if (_klass_->get_previous) {
		return _klass_->get_previous (self, view);
	}
	return NULL;
}

gboolean
view_collection_get_immediate_neighbors (ViewCollection* self,
                                         DataSource* home,
                                         DataSource** next,
                                         DataSource** prev,
                                         const gchar* type_selector)
{
	DataSource* _vala_next = NULL;
	DataSource* _vala_prev = NULL;
	DataView* home_view = NULL;
	DataView* _tmp0_;
	DataView* _tmp1_;
	DataView* next_view = NULL;
	DataView* _tmp2_;
	DataView* _tmp3_;
	DataView* prev_view = NULL;
	DataView* _tmp18_;
	DataView* _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (home != NULL, FALSE);
	_g_object_unref0 (_vala_next);
	_vala_next = NULL;
	_g_object_unref0 (_vala_prev);
	_vala_prev = NULL;
	_tmp0_ = view_collection_get_view_for_source (self, home);
	home_view = _tmp0_;
	_tmp1_ = home_view;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (home_view);
		if (next) {
			*next = _vala_next;
		} else {
			_g_object_unref0 (_vala_next);
		}
		if (prev) {
			*prev = _vala_prev;
		} else {
			_g_object_unref0 (_vala_prev);
		}
		return result;
	}
	_tmp2_ = home_view;
	_tmp3_ = view_collection_get_next (self, _tmp2_);
	next_view = _tmp3_;
	while (TRUE) {
		DataView* _tmp4_;
		DataView* _tmp5_;
		gboolean _tmp6_ = FALSE;
		DataView* _tmp16_;
		DataView* _tmp17_;
		_tmp4_ = next_view;
		_tmp5_ = home_view;
		if (!(_tmp4_ != _tmp5_)) {
			break;
		}
		if (type_selector == NULL) {
			_tmp6_ = TRUE;
		} else {
			DataView* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = next_view;
			_tmp8_ = data_view_get_source (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = data_source_get_typename (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp6_ = g_strcmp0 (_tmp11_, type_selector) == 0;
			_g_free0 (_tmp11_);
		}
		if (_tmp6_) {
			DataView* _tmp12_;
			DataSource* _tmp13_;
			DataSource* _tmp14_;
			DataSource* _tmp15_;
			_tmp12_ = next_view;
			_tmp13_ = data_view_get_source (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_g_object_unref0 (_vala_next);
			_vala_next = _tmp15_;
			break;
		}
		_tmp16_ = next_view;
		_tmp17_ = view_collection_get_next (self, _tmp16_);
		_g_object_unref0 (next_view);
		next_view = _tmp17_;
	}
	_tmp18_ = home_view;
	_tmp19_ = view_collection_get_previous (self, _tmp18_);
	prev_view = _tmp19_;
	while (TRUE) {
		DataView* _tmp20_;
		DataView* _tmp21_;
		gboolean _tmp22_ = FALSE;
		DataView* _tmp32_;
		DataView* _tmp33_;
		_tmp20_ = prev_view;
		_tmp21_ = home_view;
		if (!(_tmp20_ != _tmp21_)) {
			break;
		}
		if (type_selector == NULL) {
			_tmp22_ = TRUE;
		} else {
			DataView* _tmp23_;
			DataSource* _tmp24_;
			DataSource* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp23_ = prev_view;
			_tmp24_ = data_view_get_source (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = data_source_get_typename (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp22_ = g_strcmp0 (_tmp27_, type_selector) == 0;
			_g_free0 (_tmp27_);
		}
		if (_tmp22_) {
			DataView* _tmp28_;
			DataSource* _tmp29_;
			DataSource* _tmp30_;
			DataSource* _tmp31_;
			_tmp28_ = prev_view;
			_tmp29_ = data_view_get_source (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _g_object_ref0 (_tmp30_);
			_g_object_unref0 (_vala_prev);
			_vala_prev = _tmp31_;
			break;
		}
		_tmp32_ = prev_view;
		_tmp33_ = view_collection_get_previous (self, _tmp32_);
		_g_object_unref0 (prev_view);
		prev_view = _tmp33_;
	}
	result = TRUE;
	_g_object_unref0 (prev_view);
	_g_object_unref0 (next_view);
	_g_object_unref0 (home_view);
	if (next) {
		*next = _vala_next;
	} else {
		_g_object_unref0 (_vala_next);
	}
	if (prev) {
		*prev = _vala_prev;
	} else {
		_g_object_unref0 (_vala_prev);
	}
	return result;
}

GeeSet*
view_collection_get_extended_neighbors (ViewCollection* self,
                                        DataSource* home,
                                        const gchar* typename)
{
	GeeSet* neighbors = NULL;
	GeeHashSet* _tmp0_;
	DataSource* next = NULL;
	DataSource* prev = NULL;
	DataSource* _tmp1_ = NULL;
	DataSource* _tmp2_ = NULL;
	gboolean _tmp3_;
	DataSource* _tmp4_;
	DataSource* _tmp13_;
	GeeSet* _tmp22_;
	GeeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (home != NULL, NULL);
	_tmp0_ = gee_hash_set_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	neighbors = (GeeSet*) _tmp0_;
	_tmp3_ = view_collection_get_immediate_neighbors (self, home, &_tmp1_, &_tmp2_, typename);
	_g_object_unref0 (next);
	next = _tmp1_;
	_g_object_unref0 (prev);
	prev = _tmp2_;
	if (!_tmp3_) {
		result = neighbors;
		_g_object_unref0 (prev);
		_g_object_unref0 (next);
		return result;
	}
	_tmp4_ = next;
	if (_tmp4_ != NULL) {
		GeeSet* _tmp5_;
		DataSource* _tmp6_;
		DataSource* next_next = NULL;
		DataSource* next_prev = NULL;
		DataSource* _tmp7_;
		DataSource* _tmp8_ = NULL;
		DataSource* _tmp9_ = NULL;
		DataSource* _tmp10_;
		_tmp5_ = neighbors;
		_tmp6_ = next;
		gee_collection_add ((GeeCollection*) _tmp5_, _tmp6_);
		_tmp7_ = next;
		view_collection_get_immediate_neighbors (self, _tmp7_, &_tmp8_, &_tmp9_, typename);
		_g_object_unref0 (next_next);
		next_next = _tmp8_;
		_g_object_unref0 (next_prev);
		next_prev = _tmp9_;
		_tmp10_ = next_next;
		if (_tmp10_ != NULL) {
			GeeSet* _tmp11_;
			DataSource* _tmp12_;
			_tmp11_ = neighbors;
			_tmp12_ = next_next;
			gee_collection_add ((GeeCollection*) _tmp11_, _tmp12_);
		}
		_g_object_unref0 (next_prev);
		_g_object_unref0 (next_next);
	}
	_tmp13_ = prev;
	if (_tmp13_ != NULL) {
		GeeSet* _tmp14_;
		DataSource* _tmp15_;
		DataSource* next_prev = NULL;
		DataSource* prev_prev = NULL;
		DataSource* _tmp16_;
		DataSource* _tmp17_ = NULL;
		DataSource* _tmp18_ = NULL;
		DataSource* _tmp19_;
		_tmp14_ = neighbors;
		_tmp15_ = prev;
		gee_collection_add ((GeeCollection*) _tmp14_, _tmp15_);
		_tmp16_ = prev;
		view_collection_get_immediate_neighbors (self, _tmp16_, &_tmp17_, &_tmp18_, typename);
		_g_object_unref0 (next_prev);
		next_prev = _tmp17_;
		_g_object_unref0 (prev_prev);
		prev_prev = _tmp18_;
		_tmp19_ = prev_prev;
		if (_tmp19_ != NULL) {
			GeeSet* _tmp20_;
			DataSource* _tmp21_;
			_tmp20_ = neighbors;
			_tmp21_ = prev_prev;
			gee_collection_add ((GeeCollection*) _tmp20_, _tmp21_);
		}
		_g_object_unref0 (prev_prev);
		_g_object_unref0 (next_prev);
	}
	_tmp22_ = neighbors;
	gee_collection_remove ((GeeCollection*) _tmp22_, home);
	result = neighbors;
	_g_object_unref0 (prev);
	_g_object_unref0 (next);
	return result;
}

static void
view_collection_add_many_selected (ViewCollection* self,
                                   GeeCollection* views)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean added = FALSE;
	DataSet* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (views != NULL);
	_tmp0_ = gee_collection_get_size (views);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	{
		GeeIterator* _view_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) views);
		_view_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			DataView* view = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			DataView* _tmp6_;
			_tmp3_ = _view_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _view_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			view = (DataView*) _tmp5_;
			_tmp6_ = view;
			_vala_assert (data_view_is_visible (_tmp6_), "view.is_visible ()");
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_it);
	}
	_tmp7_ = self->priv->selected;
	added = data_set_add_many (_tmp7_, views);
	_vala_assert (added, "added");
}

static void
view_collection_remove_many_selected (ViewCollection* self,
                                      GeeCollection* views)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean removed = FALSE;
	DataSet* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (views != NULL);
	_tmp0_ = gee_collection_get_size (views);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		return;
	}
	_tmp2_ = self->priv->selected;
	removed = data_set_remove_many (_tmp2_, views);
	_vala_assert (removed, "removed");
}

static gboolean
_view_collection_select_item_marked_action (DataObject* object,
                                            GObject* user,
                                            gpointer self)
{
	gboolean result;
	result = view_collection_select_item ((ViewCollection*) self, object, user);
	return result;
}

void
view_collection_select_marked (ViewCollection* self,
                               Marker* marker)
{
	GeeArrayList* selected = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (marker != NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	selected = _tmp0_;
	_tmp1_ = selected;
	data_collection_act_on_marked ((DataCollection*) self, marker, _view_collection_select_item_marked_action, self, NULL, NULL, (GObject*) _tmp1_);
	_tmp2_ = selected;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		_tmp5_ = selected;
		view_collection_add_many_selected (self, (GeeCollection*) _tmp5_);
		_tmp6_ = selected;
		view_collection_notify_items_selected_unselected (self, (GeeCollection*) _tmp6_, NULL);
	}
	_g_object_unref0 (selected);
}

void
view_collection_select_all (ViewCollection* self)
{
	Marker* marker = NULL;
	Marker* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data_collection_start_marking ((DataCollection*) self);
	marker = _tmp0_;
	marker_mark_all (marker);
	view_collection_select_marked (self, marker);
	_g_object_unref0 (marker);
}

static gboolean
view_collection_select_item (ViewCollection* self,
                             DataObject* object,
                             GObject* user)
{
	DataView* view = NULL;
	DataView* _tmp0_;
	DataView* _tmp1_;
	DataView* _tmp5_;
	DataView* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	view = _tmp0_;
	_tmp1_ = view;
	if (data_view_is_selected (_tmp1_)) {
		DataView* _tmp2_;
		_tmp2_ = view;
		if (data_view_is_visible (_tmp2_)) {
			DataSet* _tmp3_;
			DataView* _tmp4_;
			_tmp3_ = self->priv->selected;
			_tmp4_ = view;
			_vala_assert (data_set_contains (_tmp3_, (DataObject*) _tmp4_), "selected.contains (view)");
		}
		result = TRUE;
		_g_object_unref0 (view);
		return result;
	}
	_tmp5_ = view;
	data_view_internal_set_selected (_tmp5_, TRUE);
	_tmp6_ = view;
	if (data_view_is_visible (_tmp6_)) {
		DataView* _tmp7_;
		_tmp7_ = view;
		gee_abstract_collection_add ((GeeAbstractCollection*) G_TYPE_CHECK_INSTANCE_CAST (user, GEE_TYPE_ARRAY_LIST, GeeArrayList), _tmp7_);
	}
	result = TRUE;
	_g_object_unref0 (view);
	return result;
}

static gboolean
_view_collection_unselect_item_marked_action (DataObject* object,
                                              GObject* user,
                                              gpointer self)
{
	gboolean result;
	result = view_collection_unselect_item ((ViewCollection*) self, object, user);
	return result;
}

void
view_collection_unselect_marked (ViewCollection* self,
                                 Marker* marker)
{
	GeeArrayList* unselected = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (marker != NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	unselected = _tmp0_;
	_tmp1_ = unselected;
	data_collection_act_on_marked ((DataCollection*) self, marker, _view_collection_unselect_item_marked_action, self, NULL, NULL, (GObject*) _tmp1_);
	_tmp2_ = unselected;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		_tmp5_ = unselected;
		view_collection_remove_many_selected (self, (GeeCollection*) _tmp5_);
		_tmp6_ = unselected;
		view_collection_notify_items_selected_unselected (self, NULL, (GeeCollection*) _tmp6_);
	}
	_g_object_unref0 (unselected);
}

void
view_collection_unselect_all (ViewCollection* self)
{
	DataSet* _tmp0_;
	Marker* marker = NULL;
	Marker* _tmp1_;
	Marker* _tmp2_;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	Marker* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected;
	if (data_set_get_count (_tmp0_) == 0) {
		return;
	}
	_tmp1_ = data_collection_start_marking ((DataCollection*) self);
	marker = _tmp1_;
	_tmp2_ = marker;
	_tmp3_ = view_collection_get_selected (self);
	_tmp4_ = _tmp3_;
	marker_mark_many (_tmp2_, (GeeCollection*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = marker;
	view_collection_unselect_marked (self, _tmp5_);
	_g_object_unref0 (marker);
}

void
view_collection_unselect_all_but (ViewCollection* self,
                                  DataView* exception)
{
	Marker* marker = NULL;
	Marker* _tmp0_;
	Marker* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (exception != NULL);
	_tmp0_ = data_collection_start_marking ((DataCollection*) self);
	marker = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp1_ = data_collection_get_all ((DataCollection*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DataView* view = NULL;
			DataObject* _tmp8_;
			DataView* _tmp9_;
			DataView* _tmp10_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_VIEW, DataView));
			view = _tmp9_;
			_tmp10_ = view;
			if (_tmp10_ != exception) {
				Marker* _tmp11_;
				DataView* _tmp12_;
				_tmp11_ = marker;
				_tmp12_ = view;
				marker_mark (_tmp11_, (DataObject*) _tmp12_);
			}
			_g_object_unref0 (view);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp13_ = marker;
	view_collection_unselect_marked (self, _tmp13_);
	_g_object_unref0 (marker);
}

static gboolean
view_collection_unselect_item (ViewCollection* self,
                               DataObject* object,
                               GObject* user)
{
	DataView* view = NULL;
	DataView* _tmp0_;
	DataView* _tmp1_;
	DataView* _tmp4_;
	DataView* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	view = _tmp0_;
	_tmp1_ = view;
	if (!data_view_is_selected (_tmp1_)) {
		DataSet* _tmp2_;
		DataView* _tmp3_;
		_tmp2_ = self->priv->selected;
		_tmp3_ = view;
		_vala_assert (!data_set_contains (_tmp2_, (DataObject*) _tmp3_), "!selected.contains (view)");
		result = TRUE;
		_g_object_unref0 (view);
		return result;
	}
	_tmp4_ = view;
	data_view_internal_set_selected (_tmp4_, FALSE);
	_tmp5_ = view;
	gee_abstract_collection_add ((GeeAbstractCollection*) G_TYPE_CHECK_INSTANCE_CAST (user, GEE_TYPE_ARRAY_LIST, GeeArrayList), _tmp5_);
	result = TRUE;
	_g_object_unref0 (view);
	return result;
}

void
view_collection_unselect_and_select_marked (ViewCollection* self,
                                            Marker* unselect,
                                            Marker* select)
{
	GeeArrayList* unselected = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* selected = NULL;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unselect != NULL);
	g_return_if_fail (select != NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	unselected = _tmp0_;
	data_collection_act_on_marked ((DataCollection*) self, unselect, _view_collection_unselect_item_marked_action, self, NULL, NULL, (GObject*) unselected);
	view_collection_remove_many_selected (self, (GeeCollection*) unselected);
	_tmp1_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	selected = _tmp1_;
	data_collection_act_on_marked ((DataCollection*) self, select, _view_collection_select_item_marked_action, self, NULL, NULL, (GObject*) selected);
	view_collection_add_many_selected (self, (GeeCollection*) selected);
	view_collection_notify_items_selected_unselected (self, (GeeCollection*) selected, (GeeCollection*) unselected);
	_g_object_unref0 (selected);
	_g_object_unref0 (unselected);
}

static gboolean
_view_collection_toggle_item_marked_action (DataObject* object,
                                            GObject* user,
                                            gpointer self)
{
	gboolean result;
	result = view_collection_toggle_item ((ViewCollection*) self, object, user);
	return result;
}

void
view_collection_toggle_marked (ViewCollection* self,
                               Marker* marker)
{
	ViewCollectionToggleLists* lists = NULL;
	ViewCollectionToggleLists* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (marker != NULL);
	_tmp0_ = view_collection_toggle_lists_new ();
	lists = _tmp0_;
	data_collection_act_on_marked ((DataCollection*) self, marker, _view_collection_toggle_item_marked_action, self, NULL, NULL, (GObject*) lists);
	_tmp1_ = lists->selected;
	view_collection_add_many_selected (self, (GeeCollection*) _tmp1_);
	_tmp2_ = lists->unselected;
	view_collection_remove_many_selected (self, (GeeCollection*) _tmp2_);
	_tmp3_ = lists->selected;
	_tmp4_ = lists->unselected;
	view_collection_notify_items_selected_unselected (self, (GeeCollection*) _tmp3_, (GeeCollection*) _tmp4_);
	_g_object_unref0 (lists);
}

static gboolean
view_collection_toggle_item (ViewCollection* self,
                             DataObject* object,
                             GObject* user)
{
	DataView* view = NULL;
	DataView* _tmp0_;
	ViewCollectionToggleLists* lists = NULL;
	ViewCollectionToggleLists* _tmp1_;
	DataView* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	view = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (user, VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleLists));
	lists = _tmp1_;
	_tmp2_ = view;
	if (data_view_internal_toggle (_tmp2_)) {
		DataView* _tmp3_;
		_tmp3_ = view;
		if (data_view_is_visible (_tmp3_)) {
			ViewCollectionToggleLists* _tmp4_;
			GeeArrayList* _tmp5_;
			DataView* _tmp6_;
			_tmp4_ = lists;
			_tmp5_ = _tmp4_->selected;
			_tmp6_ = view;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
		}
	} else {
		ViewCollectionToggleLists* _tmp7_;
		GeeArrayList* _tmp8_;
		DataView* _tmp9_;
		_tmp7_ = lists;
		_tmp8_ = _tmp7_->unselected;
		_tmp9_ = view;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
	}
	result = TRUE;
	_g_object_unref0 (lists);
	_g_object_unref0 (view);
	return result;
}

gint
view_collection_get_selected_count (ViewCollection* self)
{
	DataSet* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->selected;
	result = data_set_get_count (_tmp0_);
	return result;
}

GeeList*
view_collection_get_selected (ViewCollection* self)
{
	DataSet* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selected;
	_tmp1_ = data_set_get_all (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_LIST, GeeList);
	return result;
}

DataView*
view_collection_get_selected_at (ViewCollection* self,
                                 gint index)
{
	DataSet* _tmp0_;
	DataObject* _tmp1_;
	DataView* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selected;
	_tmp1_ = data_set_get_at (_tmp0_, index);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_VIEW, DataView);
	return result;
}

static gboolean
view_collection_is_visible (ViewCollection* self,
                            DataView* view)
{
	gboolean _tmp0_ = FALSE;
	DataSet* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (view != NULL, FALSE);
	_tmp1_ = self->priv->visible;
	if (_tmp1_ != NULL) {
		DataSet* _tmp2_;
		_tmp2_ = self->priv->visible;
		_tmp0_ = data_set_contains (_tmp2_, (DataObject*) view);
	} else {
		_tmp0_ = TRUE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
view_collection_add_many_visible (ViewCollection* self,
                                  GeeCollection* many)
{
	DataSet* _tmp0_;
	DataSet* _tmp1_;
	DataSet* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (many != NULL, FALSE);
	_tmp0_ = self->priv->visible;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->visible;
	if (!data_set_add_many (_tmp1_, many)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->visible;
	if (data_set_get_count (_tmp2_) == DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection))) {
		_data_set_unref0 (self->priv->visible);
		self->priv->visible = NULL;
	}
	result = TRUE;
	return result;
}

static void
view_collection_hide_items (ViewCollection* self,
                            GeeList* to_hide)
{
	GeeArrayList* unselected = NULL;
	GeeArrayList* _tmp0_;
	gint count = 0;
	gint _tmp1_;
	gint _tmp2_;
	DataSet* _tmp14_;
	gboolean removed = FALSE;
	DataSet* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp22_;
	gint _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_hide != NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	unselected = _tmp0_;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) to_hide);
	_tmp2_ = _tmp1_;
	count = _tmp2_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				DataView* view = NULL;
				gpointer _tmp5_;
				DataView* _tmp6_;
				DataView* _tmp7_;
				DataView* _tmp13_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = ctr;
					ctr = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp5_ = gee_list_get (to_hide, ctr);
				view = (DataView*) _tmp5_;
				_tmp6_ = view;
				_vala_assert (data_view_is_visible (_tmp6_), "view.is_visible ()");
				_tmp7_ = view;
				if (data_view_is_selected (_tmp7_)) {
					DataView* _tmp8_;
					GeeArrayList* _tmp9_;
					DataView* _tmp10_;
					_tmp8_ = view;
					data_view_internal_set_selected (_tmp8_, FALSE);
					_tmp9_ = unselected;
					_tmp10_ = view;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
				} else {
					DataSet* _tmp11_;
					DataView* _tmp12_;
					_tmp11_ = self->priv->selected;
					_tmp12_ = view;
					_vala_assert (!data_set_contains (_tmp11_, (DataObject*) _tmp12_), "!selected.contains (view)");
				}
				_tmp13_ = view;
				data_view_internal_set_visible (_tmp13_, FALSE);
				_g_object_unref0 (view);
			}
		}
	}
	_tmp14_ = self->priv->visible;
	if (_tmp14_ == NULL) {
		DataSet* _tmp15_;
		_tmp15_ = data_collection_get_dataset_copy ((DataCollection*) self);
		_data_set_unref0 (self->priv->visible);
		self->priv->visible = _tmp15_;
	}
	_tmp16_ = self->priv->visible;
	removed = data_set_remove_many (_tmp16_, (GeeCollection*) to_hide);
	_vala_assert (removed, "removed");
	_tmp17_ = unselected;
	view_collection_remove_many_selected (self, (GeeCollection*) _tmp17_);
	_tmp18_ = unselected;
	_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ > 0) {
		GeeArrayList* _tmp21_;
		_tmp21_ = unselected;
		view_collection_notify_items_selected_unselected (self, NULL, (GeeCollection*) _tmp21_);
	}
	_tmp22_ = gee_collection_get_size ((GeeCollection*) to_hide);
	_tmp23_ = _tmp22_;
	if (_tmp23_ > 0) {
		view_collection_notify_items_hidden (self, (GeeCollection*) to_hide);
		view_collection_notify_items_visibility_changed (self, (GeeCollection*) to_hide);
	}
	_g_object_unref0 (unselected);
}

static void
view_collection_show_items (ViewCollection* self,
                            GeeList* to_show)
{
	GeeArrayList* added_selected = NULL;
	GeeArrayList* _tmp0_;
	gint count = 0;
	gint _tmp1_;
	gint _tmp2_;
	gboolean added = FALSE;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_show != NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	added_selected = _tmp0_;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) to_show);
	_tmp2_ = _tmp1_;
	count = _tmp2_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				DataView* view = NULL;
				gpointer _tmp5_;
				DataView* _tmp6_;
				DataView* _tmp7_;
				DataView* _tmp8_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = ctr;
					ctr = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp5_ = gee_list_get (to_show, ctr);
				view = (DataView*) _tmp5_;
				_tmp6_ = view;
				_vala_assert (!data_view_is_visible (_tmp6_), "!view.is_visible ()");
				_tmp7_ = view;
				data_view_internal_set_visible (_tmp7_, TRUE);
				_tmp8_ = view;
				if (data_view_is_selected (_tmp8_)) {
					DataSet* _tmp9_;
					DataView* _tmp10_;
					GeeArrayList* _tmp11_;
					DataView* _tmp12_;
					_tmp9_ = self->priv->selected;
					_tmp10_ = view;
					_vala_assert (!data_set_contains (_tmp9_, (DataObject*) _tmp10_), "!selected.contains (view)");
					_tmp11_ = added_selected;
					_tmp12_ = view;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
				}
				_g_object_unref0 (view);
			}
		}
	}
	added = view_collection_add_many_visible (self, (GeeCollection*) to_show);
	_vala_assert (added, "added");
	_tmp13_ = added_selected;
	view_collection_add_many_selected (self, (GeeCollection*) _tmp13_);
	_tmp14_ = gee_collection_get_size ((GeeCollection*) to_show);
	_tmp15_ = _tmp14_;
	if (_tmp15_ > 0) {
		view_collection_notify_items_shown (self, (GeeCollection*) to_show);
		view_collection_notify_items_visibility_changed (self, (GeeCollection*) to_show);
	}
	_g_object_unref0 (added_selected);
}

gboolean
view_collection_has_view_for_source (ViewCollection* self,
                                     DataSource* source)
{
	DataView* _tmp0_;
	DataView* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = view_collection_get_view_for_source (self, source);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

DataView*
view_collection_get_view_for_source (ViewCollection* self,
                                     DataSource* source)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	DataView* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = self->priv->source_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, source);
	result = (DataView*) _tmp1_;
	return result;
}

gboolean
view_collection_has_view_for_source_with_filtered (ViewCollection* self,
                                                   DataSource* source)
{
	DataView* _tmp0_;
	DataView* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = view_collection_get_view_for_source_filtered (self, source);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

DataView*
view_collection_get_view_for_source_filtered (ViewCollection* self,
                                              DataSource* source)
{
	DataView* view = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
	DataView* _tmp3_;
	DataView* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = self->priv->source_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, source);
	view = (DataView*) _tmp1_;
	_tmp3_ = view;
	if (_tmp3_ != NULL) {
		DataView* _tmp4_;
		_tmp4_ = view;
		_tmp2_ = !view_collection_is_in_filter (self, _tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = NULL;
		_g_object_unref0 (view);
		return result;
	}
	result = view;
	return result;
}

GeeCollection*
view_collection_get_sources (ViewCollection* self)
{
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->source_map;
	_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_set_get_read_only_view (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = (GeeCollection*) _tmp5_;
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

gboolean
view_collection_has_source_of_type (ViewCollection* self,
                                    GType t)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_assert (g_type_is_a (t, TYPE_DATA_SOURCE), "t.is_a (typeof (DataSource))");
	{
		GeeIterator* _source_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->source_map;
		_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_source_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			DataSource* source = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			DataSource* _tmp9_;
			_tmp6_ = _source_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _source_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			source = (DataSource*) _tmp8_;
			_tmp9_ = source;
			if (g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) _tmp9_), t)) {
				result = TRUE;
				_g_object_unref0 (source);
				_g_object_unref0 (_source_it);
				return result;
			}
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	result = FALSE;
	return result;
}

gint
view_collection_get_sources_of_type_count (ViewCollection* self,
                                           GType t)
{
	gint count = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_vala_assert (g_type_is_a (t, TYPE_DATA_SOURCE), "t.is_a (typeof (DataSource))");
	count = 0;
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = data_collection_get_all ((DataCollection*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_object_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			DataObject* object = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			DataObject* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			_tmp4_ = _object_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _object_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			object = (DataObject*) _tmp6_;
			_tmp7_ = object;
			_tmp8_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_VIEW, DataView));
			_tmp9_ = _tmp8_;
			if (g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) _tmp9_), t)) {
				gint _tmp10_;
				_tmp10_ = count;
				count = _tmp10_ + 1;
			}
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	result = count;
	return result;
}

GeeList*
view_collection_get_sources_of_type (ViewCollection* self,
                                     GType t)
{
	GeeList* sources = NULL;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (g_type_is_a (t, TYPE_DATA_SOURCE), "t.is_a (typeof (DataSource))");
	sources = NULL;
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = data_collection_get_all ((DataCollection*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_object_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			DataObject* object = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			DataSource* source = NULL;
			DataObject* _tmp7_;
			DataSource* _tmp8_;
			DataSource* _tmp9_;
			DataSource* _tmp10_;
			DataSource* _tmp11_;
			_tmp4_ = _object_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _object_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			object = (DataObject*) _tmp6_;
			_tmp7_ = object;
			_tmp8_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_VIEW, DataView));
			_tmp9_ = _tmp8_;
			_tmp10_ = _g_object_ref0 (_tmp9_);
			source = _tmp10_;
			_tmp11_ = source;
			if (g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) _tmp11_), t)) {
				GeeList* _tmp12_;
				GeeList* _tmp14_;
				DataSource* _tmp15_;
				_tmp12_ = sources;
				if (_tmp12_ == NULL) {
					GeeArrayList* _tmp13_;
					_tmp13_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (sources);
					sources = (GeeList*) _tmp13_;
				}
				_tmp14_ = sources;
				_tmp15_ = source;
				gee_collection_add ((GeeCollection*) _tmp14_, _tmp15_);
			}
			_g_object_unref0 (source);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	result = sources;
	return result;
}

GeeList*
view_collection_get_selected_sources (ViewCollection* self)
{
	GeeList* sources = NULL;
	GeeArrayList* _tmp0_;
	gint count = 0;
	DataSet* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	sources = (GeeList*) _tmp0_;
	_tmp1_ = self->priv->selected;
	count = data_set_get_count (_tmp1_);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GeeList* _tmp4_;
				DataSet* _tmp5_;
				DataObject* _tmp6_;
				DataView* _tmp7_;
				DataSource* _tmp8_;
				DataSource* _tmp9_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = ctr;
					ctr = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp4_ = sources;
				_tmp5_ = self->priv->selected;
				_tmp6_ = data_set_get_at (_tmp5_, ctr);
				_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_VIEW, DataView);
				_tmp8_ = data_view_get_source (_tmp7_);
				_tmp9_ = _tmp8_;
				gee_collection_add ((GeeCollection*) _tmp4_, _tmp9_);
				_g_object_unref0 (_tmp7_);
			}
		}
	}
	result = sources;
	return result;
}

DataSource*
view_collection_get_selected_source_at (ViewCollection* self,
                                        gint index)
{
	DataObject* object = NULL;
	DataSet* _tmp0_;
	DataObject* _tmp1_;
	DataSource* _tmp2_ = NULL;
	DataObject* _tmp3_;
	DataSource* _tmp7_;
	DataSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selected;
	_tmp1_ = data_set_get_at (_tmp0_, index);
	object = _tmp1_;
	_tmp3_ = object;
	if (_tmp3_ != NULL) {
		DataObject* _tmp4_;
		DataSource* _tmp5_;
		DataSource* _tmp6_;
		_tmp4_ = object;
		_tmp5_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_VIEW, DataView));
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp7_ = _g_object_ref0 (_tmp2_);
	result = _tmp7_;
	_g_object_unref0 (object);
	return result;
}

GeeList*
view_collection_get_selected_sources_of_type (ViewCollection* self,
                                              GType t)
{
	GeeList* sources = NULL;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	sources = NULL;
	{
		GeeList* _view_list = NULL;
		GeeList* _tmp0_;
		gint _view_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _view_index = 0;
		_tmp0_ = view_collection_get_selected (self);
		_view_list = _tmp0_;
		_tmp1_ = _view_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_view_size = _tmp3_;
		_view_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DataView* view = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			DataSource* source = NULL;
			DataView* _tmp8_;
			DataSource* _tmp9_;
			DataSource* _tmp10_;
			DataSource* _tmp11_;
			DataSource* _tmp12_;
			_view_index = _view_index + 1;
			_tmp4_ = _view_index;
			_tmp5_ = _view_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _view_list;
			_tmp7_ = gee_list_get (_tmp6_, _view_index);
			view = (DataView*) _tmp7_;
			_tmp8_ = view;
			_tmp9_ = data_view_get_source (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			source = _tmp11_;
			_tmp12_ = source;
			if (g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) _tmp12_), t)) {
				GeeList* _tmp13_;
				GeeList* _tmp15_;
				DataSource* _tmp16_;
				_tmp13_ = sources;
				if (_tmp13_ == NULL) {
					GeeArrayList* _tmp14_;
					_tmp14_ = gee_array_list_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (sources);
					sources = (GeeList*) _tmp14_;
				}
				_tmp15_ = sources;
				_tmp16_ = source;
				gee_collection_add ((GeeCollection*) _tmp15_, _tmp16_);
			}
			_g_object_unref0 (source);
			_g_object_unref0 (view);
		}
		_g_object_unref0 (_view_list);
	}
	result = sources;
	return result;
}

gint
view_collection_index_of_source (ViewCollection* self,
                                 DataSource* source)
{
	DataView* view = NULL;
	DataView* _tmp0_;
	gint _tmp1_ = 0;
	DataView* _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (source != NULL, 0);
	_tmp0_ = view_collection_get_view_for_source (self, source);
	view = _tmp0_;
	_tmp2_ = view;
	if (_tmp2_ != NULL) {
		DataView* _tmp3_;
		_tmp3_ = view;
		_tmp1_ = data_collection_index_of ((DataCollection*) self, (DataObject*) _tmp3_);
	} else {
		_tmp1_ = -1;
	}
	result = _tmp1_;
	_g_object_unref0 (view);
	return result;
}

void
view_collection_internal_notify_view_altered (ViewCollection* self,
                                              DataView* view)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	if (!data_collection_are_notifications_frozen ((DataCollection*) self)) {
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		view_collection_notify_item_view_altered (self, view);
		_tmp0_ = data_collection_get_singleton ((DataObject*) view);
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
		view_collection_notify_views_altered (self, _tmp1_);
		_g_object_unref0 (_tmp1_);
	} else {
		GeeHashSet* _tmp2_;
		GeeHashSet* _tmp4_;
		_tmp2_ = self->priv->frozen_views_altered;
		if (_tmp2_ == NULL) {
			GeeHashSet* _tmp3_;
			_tmp3_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->frozen_views_altered);
			self->priv->frozen_views_altered = _tmp3_;
		}
		_tmp4_ = self->priv->frozen_views_altered;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, view);
	}
}

void
view_collection_internal_notify_geometry_altered (ViewCollection* self,
                                                  DataView* view)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	if (!data_collection_are_notifications_frozen ((DataCollection*) self)) {
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		view_collection_notify_item_geometry_altered (self, view);
		_tmp0_ = data_collection_get_singleton ((DataObject*) view);
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
		view_collection_notify_geometries_altered (self, _tmp1_);
		_g_object_unref0 (_tmp1_);
	} else {
		GeeHashSet* _tmp2_;
		GeeHashSet* _tmp4_;
		_tmp2_ = self->priv->frozen_geometries_altered;
		if (_tmp2_ == NULL) {
			GeeHashSet* _tmp3_;
			_tmp3_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->frozen_geometries_altered);
			self->priv->frozen_geometries_altered = _tmp3_;
		}
		_tmp4_ = self->priv->frozen_geometries_altered;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, view);
	}
}

static void
view_collection_real_notify_thawed (DataCollection* base)
{
	ViewCollection * self;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp8_;
	self = (ViewCollection*) base;
	_tmp0_ = self->priv->frozen_views_altered;
	if (_tmp0_ != NULL) {
		GeeHashSet* _tmp7_;
		{
			GeeIterator* _view_it = NULL;
			GeeHashSet* _tmp1_;
			GeeIterator* _tmp2_;
			_tmp1_ = self->priv->frozen_views_altered;
			_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp1_);
			_view_it = _tmp2_;
			while (TRUE) {
				GeeIterator* _tmp3_;
				DataView* view = NULL;
				GeeIterator* _tmp4_;
				gpointer _tmp5_;
				DataView* _tmp6_;
				_tmp3_ = _view_it;
				if (!gee_iterator_next (_tmp3_)) {
					break;
				}
				_tmp4_ = _view_it;
				_tmp5_ = gee_iterator_get (_tmp4_);
				view = (DataView*) _tmp5_;
				_tmp6_ = view;
				view_collection_notify_item_view_altered (self, _tmp6_);
				_g_object_unref0 (view);
			}
			_g_object_unref0 (_view_it);
		}
		_tmp7_ = self->priv->frozen_views_altered;
		view_collection_notify_views_altered (self, (GeeCollection*) _tmp7_);
		_g_object_unref0 (self->priv->frozen_views_altered);
		self->priv->frozen_views_altered = NULL;
	}
	_tmp8_ = self->priv->frozen_geometries_altered;
	if (_tmp8_ != NULL) {
		GeeHashSet* _tmp15_;
		{
			GeeIterator* _view_it = NULL;
			GeeHashSet* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp9_ = self->priv->frozen_geometries_altered;
			_tmp10_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp9_);
			_view_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				DataView* view = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				DataView* _tmp14_;
				_tmp11_ = _view_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _view_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				view = (DataView*) _tmp13_;
				_tmp14_ = view;
				view_collection_notify_item_geometry_altered (self, _tmp14_);
				_g_object_unref0 (view);
			}
			_g_object_unref0 (_view_it);
		}
		_tmp15_ = self->priv->frozen_geometries_altered;
		view_collection_notify_geometries_altered (self, (GeeCollection*) _tmp15_);
		_g_object_unref0 (self->priv->frozen_geometries_altered);
		self->priv->frozen_geometries_altered = NULL;
	}
	DATA_COLLECTION_CLASS (view_collection_parent_class)->notify_thawed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
}

gboolean
view_collection_are_items_filtered_out (ViewCollection* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = DATA_COLLECTION_CLASS (view_collection_parent_class)->get_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection)) != data_collection_get_count ((DataCollection*) self);
	return result;
}

static void
view_collection_real_items_selected (ViewCollection* self,
                                     GeeIterable* selected)
{
	g_return_if_fail (selected != NULL);
}

static void
view_collection_real_items_unselected (ViewCollection* self,
                                       GeeIterable* unselected)
{
	g_return_if_fail (unselected != NULL);
}

static void
view_collection_real_items_state_changed (ViewCollection* self,
                                          GeeIterable* changed)
{
	g_return_if_fail (changed != NULL);
}

static void
view_collection_real_selection_group_altered (ViewCollection* self)
{
}

static void
view_collection_real_items_shown (ViewCollection* self,
                                  GeeCollection* visible)
{
	g_return_if_fail (visible != NULL);
}

static void
view_collection_real_items_hidden (ViewCollection* self,
                                   GeeCollection* hidden)
{
	g_return_if_fail (hidden != NULL);
}

static void
view_collection_real_items_visibility_changed (ViewCollection* self,
                                               GeeCollection* changed)
{
	g_return_if_fail (changed != NULL);
}

static void
view_collection_real_item_view_altered (ViewCollection* self,
                                        DataView* view)
{
	g_return_if_fail (view != NULL);
}

static void
view_collection_real_item_geometry_altered (ViewCollection* self,
                                            DataView* view)
{
	g_return_if_fail (view != NULL);
}

static void
view_collection_real_views_altered (ViewCollection* self,
                                    GeeCollection* views)
{
	g_return_if_fail (views != NULL);
}

static void
view_collection_real_geometries_altered (ViewCollection* self,
                                         GeeCollection* views)
{
	g_return_if_fail (views != NULL);
}

static void
view_collection_real_view_filter_installed (ViewCollection* self,
                                            ViewFilter* filer)
{
	g_return_if_fail (filer != NULL);
}

static void
g_cclosure_user_marshal_VOID__VIEW_FILTER (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__VIEW_FILTER) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__VIEW_FILTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__VIEW_FILTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_view_filter (param_values + 1), data2);
}

static void
view_collection_real_view_filter_removed (ViewCollection* self,
                                          ViewFilter* filer)
{
	g_return_if_fail (filer != NULL);
}

ViewCollectionMonitor*
view_collection_monitor_construct (GType object_type)
{
	ViewCollectionMonitor* self = NULL;
	self = (ViewCollectionMonitor*) g_type_create_instance (object_type);
	return self;
}

ViewCollectionMonitor*
view_collection_monitor_new (void)
{
	return view_collection_monitor_construct (VIEW_COLLECTION_TYPE_MONITOR);
}

static void
view_collection_value_monitor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
view_collection_value_monitor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		view_collection_monitor_unref (value->data[0].v_pointer);
	}
}

static void
view_collection_value_monitor_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = view_collection_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
view_collection_value_monitor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
view_collection_value_monitor_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ViewCollectionMonitor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = view_collection_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
view_collection_value_monitor_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	ViewCollectionMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = view_collection_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
view_collection_param_spec_monitor (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	ViewCollectionParamSpecMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VIEW_COLLECTION_TYPE_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
view_collection_value_get_monitor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIEW_COLLECTION_TYPE_MONITOR), NULL);
	return value->data[0].v_pointer;
}

void
view_collection_value_set_monitor (GValue* value,
                                   gpointer v_object)
{
	ViewCollectionMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIEW_COLLECTION_TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIEW_COLLECTION_TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		view_collection_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_collection_monitor_unref (old);
	}
}

void
view_collection_value_take_monitor (GValue* value,
                                    gpointer v_object)
{
	ViewCollectionMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIEW_COLLECTION_TYPE_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIEW_COLLECTION_TYPE_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_collection_monitor_unref (old);
	}
}

static void
view_collection_monitor_class_init (ViewCollectionMonitorClass * klass,
                                    gpointer klass_data)
{
	view_collection_monitor_parent_class = g_type_class_peek_parent (klass);
	((ViewCollectionMonitorClass *) klass)->finalize = view_collection_monitor_finalize;
}

static void
view_collection_monitor_instance_init (ViewCollectionMonitor * self,
                                       gpointer klass)
{
	self->ref_count = 1;
}

static void
view_collection_monitor_finalize (ViewCollectionMonitor * obj)
{
	ViewCollectionMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIEW_COLLECTION_TYPE_MONITOR, ViewCollectionMonitor);
	g_signal_handlers_destroy (self);
}

static GType
view_collection_monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { view_collection_value_monitor_init, view_collection_value_monitor_free_value, view_collection_value_monitor_copy_value, view_collection_value_monitor_peek_pointer, "p", view_collection_value_monitor_collect_value, "p", view_collection_value_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollectionMonitor), 0, (GInstanceInitFunc) view_collection_monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType view_collection_monitor_type_id;
	view_collection_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ViewCollectionMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return view_collection_monitor_type_id;
}

GType
view_collection_monitor_get_type (void)
{
	static volatile gsize view_collection_monitor_type_id__once = 0;
	if (g_once_init_enter (&view_collection_monitor_type_id__once)) {
		GType view_collection_monitor_type_id;
		view_collection_monitor_type_id = view_collection_monitor_get_type_once ();
		g_once_init_leave (&view_collection_monitor_type_id__once, view_collection_monitor_type_id);
	}
	return view_collection_monitor_type_id__once;
}

gpointer
view_collection_monitor_ref (gpointer instance)
{
	ViewCollectionMonitor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
view_collection_monitor_unref (gpointer instance)
{
	ViewCollectionMonitor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIEW_COLLECTION_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_view_collection_on_sources_added_data_collection_items_added (DataCollection* _sender,
                                                               GeeIterable* added,
                                                               gpointer self)
{
	view_collection_on_sources_added ((ViewCollection*) self, _sender, added);
}

static void
_view_collection_on_sources_removed_data_collection_items_removed (DataCollection* _sender,
                                                                   GeeIterable* removed,
                                                                   gpointer self)
{
	view_collection_on_sources_removed ((ViewCollection*) self, removed);
}

static void
_view_collection_on_sources_altered_data_collection_items_altered (DataCollection* _sender,
                                                                   GeeMap* items,
                                                                   gpointer self)
{
	view_collection_on_sources_altered ((ViewCollection*) self, _sender, items);
}

static gpointer
_view_manager_ref0 (gpointer self)
{
	return self ? view_manager_ref (self) : NULL;
}

static gpointer
_alteration_ref0 (gpointer self)
{
	return self ? alteration_ref (self) : NULL;
}

static ViewCollectionMonitorImpl*
view_collection_monitor_impl_construct (GType object_type,
                                        ViewCollection* owner,
                                        SourceCollection* sources,
                                        ViewManager* manager,
                                        Alteration* prereq)
{
	ViewCollectionMonitorImpl* self = NULL;
	ViewCollection* _tmp0_;
	SourceCollection* _tmp1_;
	ViewManager* _tmp2_;
	Alteration* _tmp3_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (sources != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	self = (ViewCollectionMonitorImpl*) view_collection_monitor_construct (object_type);
	_tmp0_ = _data_collection_ref0 (owner);
	_data_collection_unref0 (self->owner);
	self->owner = _tmp0_;
	_tmp1_ = _data_collection_ref0 (sources);
	_data_collection_unref0 (self->sources);
	self->sources = _tmp1_;
	_tmp2_ = _view_manager_ref0 (manager);
	_view_manager_unref0 (self->manager);
	self->manager = _tmp2_;
	_tmp3_ = _alteration_ref0 (prereq);
	_alteration_unref0 (self->prereq);
	self->prereq = _tmp3_;
	g_signal_connect ((DataCollection*) sources, "items-added", (GCallback) _view_collection_on_sources_added_data_collection_items_added, owner);
	g_signal_connect ((DataCollection*) sources, "items-removed", (GCallback) _view_collection_on_sources_removed_data_collection_items_removed, owner);
	g_signal_connect ((DataCollection*) sources, "items-altered", (GCallback) _view_collection_on_sources_altered_data_collection_items_altered, owner);
	return self;
}

static ViewCollectionMonitorImpl*
view_collection_monitor_impl_new (ViewCollection* owner,
                                  SourceCollection* sources,
                                  ViewManager* manager,
                                  Alteration* prereq)
{
	return view_collection_monitor_impl_construct (VIEW_COLLECTION_TYPE_MONITOR_IMPL, owner, sources, manager, prereq);
}

static void
view_collection_monitor_impl_class_init (ViewCollectionMonitorImplClass * klass,
                                         gpointer klass_data)
{
	view_collection_monitor_impl_parent_class = g_type_class_peek_parent (klass);
	((ViewCollectionMonitorClass *) klass)->finalize = view_collection_monitor_impl_finalize;
}

static void
view_collection_monitor_impl_instance_init (ViewCollectionMonitorImpl * self,
                                            gpointer klass)
{
}

static void
view_collection_monitor_impl_finalize (ViewCollectionMonitor * obj)
{
	ViewCollectionMonitorImpl * self;
	SourceCollection* _tmp0_;
	ViewCollection* _tmp1_;
	guint _tmp2_;
	SourceCollection* _tmp3_;
	ViewCollection* _tmp4_;
	guint _tmp5_;
	SourceCollection* _tmp6_;
	ViewCollection* _tmp7_;
	guint _tmp8_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIEW_COLLECTION_TYPE_MONITOR_IMPL, ViewCollectionMonitorImpl);
	_tmp0_ = self->sources;
	_tmp1_ = self->owner;
	g_signal_parse_name ("items-added", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _view_collection_on_sources_added_data_collection_items_added, _tmp1_);
	_tmp3_ = self->sources;
	_tmp4_ = self->owner;
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _view_collection_on_sources_removed_data_collection_items_removed, _tmp4_);
	_tmp6_ = self->sources;
	_tmp7_ = self->owner;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _view_collection_on_sources_altered_data_collection_items_altered, _tmp7_);
	_data_collection_unref0 (self->owner);
	_data_collection_unref0 (self->sources);
	_view_manager_unref0 (self->manager);
	_alteration_unref0 (self->prereq);
	VIEW_COLLECTION_MONITOR_CLASS (view_collection_monitor_impl_parent_class)->finalize (obj);
}

static GType
view_collection_monitor_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionMonitorImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_monitor_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollectionMonitorImpl), 0, (GInstanceInitFunc) view_collection_monitor_impl_instance_init, NULL };
	GType view_collection_monitor_impl_type_id;
	view_collection_monitor_impl_type_id = g_type_register_static (VIEW_COLLECTION_TYPE_MONITOR, "ViewCollectionMonitorImpl", &g_define_type_info, 0);
	return view_collection_monitor_impl_type_id;
}

static GType
view_collection_monitor_impl_get_type (void)
{
	static volatile gsize view_collection_monitor_impl_type_id__once = 0;
	if (g_once_init_enter (&view_collection_monitor_impl_type_id__once)) {
		GType view_collection_monitor_impl_type_id;
		view_collection_monitor_impl_type_id = view_collection_monitor_impl_get_type_once ();
		g_once_init_leave (&view_collection_monitor_impl_type_id__once, view_collection_monitor_impl_type_id);
	}
	return view_collection_monitor_impl_type_id__once;
}

static ViewCollectionToggleLists*
view_collection_toggle_lists_construct (GType object_type)
{
	ViewCollectionToggleLists * self = NULL;
	self = (ViewCollectionToggleLists*) g_object_new (object_type, NULL);
	return self;
}

static ViewCollectionToggleLists*
view_collection_toggle_lists_new (void)
{
	return view_collection_toggle_lists_construct (VIEW_COLLECTION_TYPE_TOGGLE_LISTS);
}

static void
view_collection_toggle_lists_class_init (ViewCollectionToggleListsClass * klass,
                                         gpointer klass_data)
{
	view_collection_toggle_lists_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = view_collection_toggle_lists_finalize;
}

static void
view_collection_toggle_lists_instance_init (ViewCollectionToggleLists * self,
                                            gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	_tmp0_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->selected = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->unselected = _tmp1_;
}

static void
view_collection_toggle_lists_finalize (GObject * obj)
{
	ViewCollectionToggleLists * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIEW_COLLECTION_TYPE_TOGGLE_LISTS, ViewCollectionToggleLists);
	_g_object_unref0 (self->selected);
	_g_object_unref0 (self->unselected);
	G_OBJECT_CLASS (view_collection_toggle_lists_parent_class)->finalize (obj);
}

static GType
view_collection_toggle_lists_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionToggleListsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_toggle_lists_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollectionToggleLists), 0, (GInstanceInitFunc) view_collection_toggle_lists_instance_init, NULL };
	GType view_collection_toggle_lists_type_id;
	view_collection_toggle_lists_type_id = g_type_register_static (G_TYPE_OBJECT, "ViewCollectionToggleLists", &g_define_type_info, 0);
	return view_collection_toggle_lists_type_id;
}

static GType
view_collection_toggle_lists_get_type (void)
{
	static volatile gsize view_collection_toggle_lists_type_id__once = 0;
	if (g_once_init_enter (&view_collection_toggle_lists_type_id__once)) {
		GType view_collection_toggle_lists_type_id;
		view_collection_toggle_lists_type_id = view_collection_toggle_lists_get_type_once ();
		g_once_init_leave (&view_collection_toggle_lists_type_id__once, view_collection_toggle_lists_type_id);
	}
	return view_collection_toggle_lists_type_id__once;
}

static void
view_collection_class_init (ViewCollectionClass * klass,
                            gpointer klass_data)
{
	view_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = view_collection_finalize;
	g_type_class_adjust_private_offset (klass, &ViewCollection_private_offset);
	((ViewCollectionClass *) klass)->notify_items_selected_unselected = (void (*) (ViewCollection*, GeeCollection*, GeeCollection*)) view_collection_real_notify_items_selected_unselected;
	((ViewCollectionClass *) klass)->notify_selection_group_altered = (void (*) (ViewCollection*)) view_collection_real_notify_selection_group_altered;
	((ViewCollectionClass *) klass)->notify_item_view_altered = (void (*) (ViewCollection*, DataView*)) view_collection_real_notify_item_view_altered;
	((ViewCollectionClass *) klass)->notify_views_altered = (void (*) (ViewCollection*, GeeCollection*)) view_collection_real_notify_views_altered;
	((ViewCollectionClass *) klass)->notify_item_geometry_altered = (void (*) (ViewCollection*, DataView*)) view_collection_real_notify_item_geometry_altered;
	((ViewCollectionClass *) klass)->notify_geometries_altered = (void (*) (ViewCollection*, GeeCollection*)) view_collection_real_notify_geometries_altered;
	((ViewCollectionClass *) klass)->notify_items_shown = (void (*) (ViewCollection*, GeeCollection*)) view_collection_real_notify_items_shown;
	((ViewCollectionClass *) klass)->notify_items_hidden = (void (*) (ViewCollection*, GeeCollection*)) view_collection_real_notify_items_hidden;
	((ViewCollectionClass *) klass)->notify_items_visibility_changed = (void (*) (ViewCollection*, GeeCollection*)) view_collection_real_notify_items_visibility_changed;
	((ViewCollectionClass *) klass)->notify_view_filter_installed = (void (*) (ViewCollection*, ViewFilter*)) view_collection_real_notify_view_filter_installed;
	((ViewCollectionClass *) klass)->notify_view_filter_removed = (void (*) (ViewCollection*, ViewFilter*)) view_collection_real_notify_view_filter_removed;
	((DataCollectionClass *) klass)->clear = (void (*) (DataCollection*)) view_collection_real_clear;
	((DataCollectionClass *) klass)->close = (void (*) (DataCollection*)) view_collection_real_close;
	((DataCollectionClass *) klass)->valid_type = (gboolean (*) (DataCollection*, DataObject*)) view_collection_real_valid_type;
	((DataCollectionClass *) klass)->add = (gboolean (*) (DataCollection*, DataObject*)) view_collection_real_add;
	((DataCollectionClass *) klass)->add_many = (GeeCollection* (*) (DataCollection*, GeeCollection*, ProgressMonitor, gpointer)) view_collection_real_add_many;
	((DataCollectionClass *) klass)->notify_items_added = (void (*) (DataCollection*, GeeIterable*)) view_collection_real_notify_items_added;
	((DataCollectionClass *) klass)->notify_items_removed = (void (*) (DataCollection*, GeeIterable*)) view_collection_real_notify_items_removed;
	((DataCollectionClass *) klass)->items_altered = (void (*) (DataCollection*, GeeMap*)) view_collection_real_items_altered;
	((DataCollectionClass *) klass)->set_comparator = (void (*) (DataCollection*, Comparator, gpointer, ComparatorPredicate, gpointer)) view_collection_real_set_comparator;
	((DataCollectionClass *) klass)->reset_comparator = (void (*) (DataCollection*)) view_collection_real_reset_comparator;
	((DataCollectionClass *) klass)->get_all = (GeeCollection* (*) (DataCollection*)) view_collection_real_get_all;
	((DataCollectionClass *) klass)->get_count = (gint (*) (DataCollection*)) view_collection_real_get_count;
	((DataCollectionClass *) klass)->get_at = (DataObject* (*) (DataCollection*, gint)) view_collection_real_get_at;
	((DataCollectionClass *) klass)->index_of = (gint (*) (DataCollection*, DataObject*)) view_collection_real_index_of;
	((DataCollectionClass *) klass)->contains = (gboolean (*) (DataCollection*, DataObject*)) view_collection_real_contains;
	((ViewCollectionClass *) klass)->get_first = (DataView* (*) (ViewCollection*)) view_collection_real_get_first;
	((ViewCollectionClass *) klass)->get_first_unrejected = (DataView* (*) (ViewCollection*)) view_collection_real_get_first_unrejected;
	((ViewCollectionClass *) klass)->get_last = (DataView* (*) (ViewCollection*)) view_collection_real_get_last;
	((ViewCollectionClass *) klass)->get_next = (DataView* (*) (ViewCollection*, DataView*)) view_collection_real_get_next;
	((ViewCollectionClass *) klass)->get_previous = (DataView* (*) (ViewCollection*, DataView*)) view_collection_real_get_previous;
	((DataCollectionClass *) klass)->notify_thawed = (void (*) (DataCollection*)) view_collection_real_notify_thawed;
	((ViewCollectionClass *) klass)->items_selected = view_collection_real_items_selected;
	((ViewCollectionClass *) klass)->items_unselected = view_collection_real_items_unselected;
	((ViewCollectionClass *) klass)->items_state_changed = view_collection_real_items_state_changed;
	((ViewCollectionClass *) klass)->selection_group_altered = view_collection_real_selection_group_altered;
	((ViewCollectionClass *) klass)->items_shown = view_collection_real_items_shown;
	((ViewCollectionClass *) klass)->items_hidden = view_collection_real_items_hidden;
	((ViewCollectionClass *) klass)->items_visibility_changed = view_collection_real_items_visibility_changed;
	((ViewCollectionClass *) klass)->item_view_altered = view_collection_real_item_view_altered;
	((ViewCollectionClass *) klass)->item_geometry_altered = view_collection_real_item_geometry_altered;
	((ViewCollectionClass *) klass)->views_altered = view_collection_real_views_altered;
	((ViewCollectionClass *) klass)->geometries_altered = view_collection_real_geometries_altered;
	((ViewCollectionClass *) klass)->view_filter_installed = view_collection_real_view_filter_installed;
	((ViewCollectionClass *) klass)->view_filter_removed = view_collection_real_view_filter_removed;
	view_collection_signals[VIEW_COLLECTION_ITEMS_SELECTED_SIGNAL] = g_signal_new ("items-selected", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_selected), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
	view_collection_signals[VIEW_COLLECTION_ITEMS_UNSELECTED_SIGNAL] = g_signal_new ("items-unselected", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_unselected), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
	view_collection_signals[VIEW_COLLECTION_ITEMS_STATE_CHANGED_SIGNAL] = g_signal_new ("items-state-changed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_state_changed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
	view_collection_signals[VIEW_COLLECTION_SELECTION_GROUP_ALTERED_SIGNAL] = g_signal_new ("selection-group-altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, selection_group_altered), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	view_collection_signals[VIEW_COLLECTION_ITEMS_SHOWN_SIGNAL] = g_signal_new ("items-shown", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_shown), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	view_collection_signals[VIEW_COLLECTION_ITEMS_HIDDEN_SIGNAL] = g_signal_new ("items-hidden", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_hidden), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	view_collection_signals[VIEW_COLLECTION_ITEMS_VISIBILITY_CHANGED_SIGNAL] = g_signal_new ("items-visibility-changed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, items_visibility_changed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	view_collection_signals[VIEW_COLLECTION_ITEM_VIEW_ALTERED_SIGNAL] = g_signal_new ("item-view-altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, item_view_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_VIEW);
	view_collection_signals[VIEW_COLLECTION_ITEM_GEOMETRY_ALTERED_SIGNAL] = g_signal_new ("item-geometry-altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, item_geometry_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_DATA_VIEW);
	view_collection_signals[VIEW_COLLECTION_VIEWS_ALTERED_SIGNAL] = g_signal_new ("views-altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, views_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	view_collection_signals[VIEW_COLLECTION_GEOMETRIES_ALTERED_SIGNAL] = g_signal_new ("geometries-altered", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, geometries_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	view_collection_signals[VIEW_COLLECTION_VIEW_FILTER_INSTALLED_SIGNAL] = g_signal_new ("view-filter-installed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, view_filter_installed), NULL, NULL, g_cclosure_user_marshal_VOID__VIEW_FILTER, G_TYPE_NONE, 1, TYPE_VIEW_FILTER);
	view_collection_signals[VIEW_COLLECTION_VIEW_FILTER_REMOVED_SIGNAL] = g_signal_new ("view-filter-removed", TYPE_VIEW_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewCollectionClass, view_filter_removed), NULL, NULL, g_cclosure_user_marshal_VOID__VIEW_FILTER, G_TYPE_NONE, 1, TYPE_VIEW_FILTER);
}

static void
view_collection_instance_init (ViewCollection * self,
                               gpointer klass)
{
	GeeHashMultiMap* _tmp0_;
	GeeHashSet* _tmp1_;
	DataSet* _tmp2_;
	GeeHashMap* _tmp3_;
	self->priv = view_collection_get_instance_private (self);
	_tmp0_ = gee_hash_multi_map_new (TYPE_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, VIEW_COLLECTION_TYPE_MONITOR_IMPL, (GBoxedCopyFunc) view_collection_monitor_ref, (GDestroyNotify) view_collection_monitor_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->monitors = _tmp0_;
	self->priv->mirroring = NULL;
	self->priv->mirroring_ctor = NULL;
	self->priv->mirroring_ctor_target = NULL;
	self->priv->should_mirror = NULL;
	self->priv->should_mirror_target = NULL;
	_tmp1_ = gee_hash_set_new (TYPE_VIEW_FILTER, (GBoxedCopyFunc) view_filter_ref, (GDestroyNotify) view_filter_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->filters = (GeeSet*) _tmp1_;
	_tmp2_ = data_set_new ();
	self->priv->selected = _tmp2_;
	self->priv->visible = NULL;
	self->priv->frozen_views_altered = NULL;
	self->priv->frozen_geometries_altered = NULL;
	_tmp3_ = gee_hash_map_new (TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->source_map = _tmp3_;
}

static void
view_collection_finalize (DataCollection * obj)
{
	ViewCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIEW_COLLECTION, ViewCollection);
	_g_object_unref0 (self->priv->monitors);
	_data_collection_unref0 (self->priv->mirroring);
	_g_object_unref0 (self->priv->filters);
	_data_set_unref0 (self->priv->selected);
	_data_set_unref0 (self->priv->visible);
	_g_object_unref0 (self->priv->frozen_views_altered);
	_g_object_unref0 (self->priv->frozen_geometries_altered);
	_g_object_unref0 (self->priv->source_map);
	DATA_COLLECTION_CLASS (view_collection_parent_class)->finalize (obj);
}

static GType
view_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ViewCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewCollection), 0, (GInstanceInitFunc) view_collection_instance_init, NULL };
	GType view_collection_type_id;
	view_collection_type_id = g_type_register_static (TYPE_DATA_COLLECTION, "ViewCollection", &g_define_type_info, 0);
	ViewCollection_private_offset = g_type_add_instance_private (view_collection_type_id, sizeof (ViewCollectionPrivate));
	return view_collection_type_id;
}

GType
view_collection_get_type (void)
{
	static volatile gsize view_collection_type_id__once = 0;
	if (g_once_init_enter (&view_collection_type_id__once)) {
		GType view_collection_type_id;
		view_collection_type_id = view_collection_get_type_once ();
		g_once_init_leave (&view_collection_type_id__once, view_collection_type_id);
	}
	return view_collection_type_id__once;
}

static gboolean
view_filter_real_predicate (ViewFilter* self,
                            DataView* view)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `view_filter_predicate'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
view_filter_predicate (ViewFilter* self,
                       DataView* view)
{
	ViewFilterClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = VIEW_FILTER_GET_CLASS (self);
	if (_klass_->predicate) {
		return _klass_->predicate (self, view);
	}
	return FALSE;
}

ViewFilter*
view_filter_construct (GType object_type)
{
	ViewFilter* self = NULL;
	self = (ViewFilter*) g_type_create_instance (object_type);
	return self;
}

static void
view_filter_real_refresh (ViewFilter* self)
{
}

static void
value_view_filter_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_view_filter_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		view_filter_unref (value->data[0].v_pointer);
	}
}

static void
value_view_filter_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = view_filter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_view_filter_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_view_filter_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ViewFilter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = view_filter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_view_filter_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	ViewFilter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = view_filter_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_view_filter (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecViewFilter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIEW_FILTER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_view_filter (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_FILTER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_view_filter (GValue* value,
                       gpointer v_object)
{
	ViewFilter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_FILTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_FILTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		view_filter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_filter_unref (old);
	}
}

void
value_take_view_filter (GValue* value,
                        gpointer v_object)
{
	ViewFilter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIEW_FILTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIEW_FILTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		view_filter_unref (old);
	}
}

static void
view_filter_class_init (ViewFilterClass * klass,
                        gpointer klass_data)
{
	view_filter_parent_class = g_type_class_peek_parent (klass);
	((ViewFilterClass *) klass)->finalize = view_filter_finalize;
	((ViewFilterClass *) klass)->predicate = (gboolean (*) (ViewFilter*, DataView*)) view_filter_real_predicate;
	((ViewFilterClass *) klass)->refresh = view_filter_real_refresh;
	view_filter_signals[VIEW_FILTER_REFRESH_SIGNAL] = g_signal_new ("refresh", TYPE_VIEW_FILTER, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ViewFilterClass, refresh), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
view_filter_instance_init (ViewFilter * self,
                           gpointer klass)
{
	self->ref_count = 1;
}

static void
view_filter_finalize (ViewFilter * obj)
{
	ViewFilter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIEW_FILTER, ViewFilter);
	g_signal_handlers_destroy (self);
}

static GType
view_filter_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_view_filter_init, value_view_filter_free_value, value_view_filter_copy_value, value_view_filter_peek_pointer, "p", value_view_filter_collect_value, "p", value_view_filter_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ViewFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) view_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ViewFilter), 0, (GInstanceInitFunc) view_filter_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType view_filter_type_id;
	view_filter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ViewFilter", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return view_filter_type_id;
}

GType
view_filter_get_type (void)
{
	static volatile gsize view_filter_type_id__once = 0;
	if (g_once_init_enter (&view_filter_type_id__once)) {
		GType view_filter_type_id;
		view_filter_type_id = view_filter_get_type_once ();
		g_once_init_leave (&view_filter_type_id__once, view_filter_type_id);
	}
	return view_filter_type_id__once;
}

gpointer
view_filter_ref (gpointer instance)
{
	ViewFilter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
view_filter_unref (gpointer instance)
{
	ViewFilter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIEW_FILTER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

