/* KeyboardManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from KeyboardManager.vala, do not modify */

/*
 * Copyright 2016 Santiago León
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <meta/display.h>
#include <glib.h>
#include <gio/gio.h>
#include <meta/compositor.h>
#include <meta/meta-backend.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-context.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER (greeter_compositor_keyboard_manager_get_type ())
#define GREETER_COMPOSITOR_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManager))
#define GREETER_COMPOSITOR_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManagerClass))
#define GREETER_COMPOSITOR_IS_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER))
#define GREETER_COMPOSITOR_IS_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER))
#define GREETER_COMPOSITOR_KEYBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManagerClass))

typedef struct _GreeterCompositorKeyboardManager GreeterCompositorKeyboardManager;
typedef struct _GreeterCompositorKeyboardManagerClass GreeterCompositorKeyboardManagerClass;
typedef struct _GreeterCompositorKeyboardManagerPrivate GreeterCompositorKeyboardManagerPrivate;
enum  {
	GREETER_COMPOSITOR_KEYBOARD_MANAGER_0_PROPERTY,
	GREETER_COMPOSITOR_KEYBOARD_MANAGER_DISPLAY_PROPERTY,
	GREETER_COMPOSITOR_KEYBOARD_MANAGER_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_keyboard_manager_properties[GREETER_COMPOSITOR_KEYBOARD_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _GreeterCompositorKeyboardManager {
	GObject parent_instance;
	GreeterCompositorKeyboardManagerPrivate * priv;
};

struct _GreeterCompositorKeyboardManagerClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorKeyboardManagerPrivate {
	MetaDisplay* _display;
};

static gint GreeterCompositorKeyboardManager_private_offset;
static gpointer greeter_compositor_keyboard_manager_parent_class = NULL;
static GreeterCompositorKeyboardManager* greeter_compositor_keyboard_manager_instance;
static GreeterCompositorKeyboardManager* greeter_compositor_keyboard_manager_instance = NULL;
static GVariantType* greeter_compositor_keyboard_manager_sources_variant_type;
static GVariantType* greeter_compositor_keyboard_manager_sources_variant_type = NULL;
static GSettings* greeter_compositor_keyboard_manager_settings;
static GSettings* greeter_compositor_keyboard_manager_settings = NULL;

VALA_EXTERN GType greeter_compositor_keyboard_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorKeyboardManager, g_object_unref)
VALA_EXTERN void greeter_compositor_keyboard_manager_init (MetaDisplay* display);
static GreeterCompositorKeyboardManager* greeter_compositor_keyboard_manager_new (MetaDisplay* display);
static GreeterCompositorKeyboardManager* greeter_compositor_keyboard_manager_construct (GType object_type,
                                                                                 MetaDisplay* display);
static gboolean __lambda56_ (MetaDisplay* display);
VALA_EXTERN gboolean greeter_compositor_keyboard_manager_handle_modifiers_accelerator_activated (MetaDisplay* display,
                                                                                     gboolean backward);
static gboolean ___lambda56__meta_display_modifiers_accelerator_activated (MetaDisplay* _sender,
                                                                    gpointer self);
static void greeter_compositor_keyboard_manager_set_keyboard_layout (GSettings* settings,
                                                              const gchar* key,
                                                              GreeterCompositorKeyboardManager* self);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static MetaDisplay* greeter_compositor_keyboard_manager_get_display (GreeterCompositorKeyboardManager* self);
static void greeter_compositor_keyboard_manager_set_display (GreeterCompositorKeyboardManager* self,
                                                      MetaDisplay* value);
static GObject * greeter_compositor_keyboard_manager_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static void _greeter_compositor_keyboard_manager_set_keyboard_layout_g_settings_changed (GSettings* _sender,
                                                                                  const gchar* key,
                                                                                  gpointer self);
static void greeter_compositor_keyboard_manager_finalize (GObject * obj);
static GType greeter_compositor_keyboard_manager_get_type_once (void);
static void _vala_greeter_compositor_keyboard_manager_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_greeter_compositor_keyboard_manager_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
greeter_compositor_keyboard_manager_get_instance_private (GreeterCompositorKeyboardManager* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorKeyboardManager_private_offset);
}

static gboolean
__lambda56_ (MetaDisplay* display)
{
	gboolean result;
	g_return_val_if_fail (display != NULL, FALSE);
	result = greeter_compositor_keyboard_manager_handle_modifiers_accelerator_activated (display, FALSE);
	return result;
}

static gboolean
___lambda56__meta_display_modifiers_accelerator_activated (MetaDisplay* _sender,
                                                           gpointer self)
{
	gboolean result;
	result = __lambda56_ (_sender);
	return result;
}

void
greeter_compositor_keyboard_manager_init (MetaDisplay* display)
{
	GreeterCompositorKeyboardManager* _tmp0_;
	GreeterCompositorKeyboardManager* _tmp1_;
	g_return_if_fail (display != NULL);
	_tmp0_ = greeter_compositor_keyboard_manager_instance;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = greeter_compositor_keyboard_manager_new (display);
	_g_object_unref0 (greeter_compositor_keyboard_manager_instance);
	greeter_compositor_keyboard_manager_instance = _tmp1_;
	g_signal_connect (display, "modifiers-accelerator-activated", (GCallback) ___lambda56__meta_display_modifiers_accelerator_activated, NULL);
}

static GreeterCompositorKeyboardManager*
greeter_compositor_keyboard_manager_construct (GType object_type,
                                               MetaDisplay* display)
{
	GreeterCompositorKeyboardManager * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GreeterCompositorKeyboardManager*) g_object_new (object_type, "display", display, NULL);
	return self;
}

static GreeterCompositorKeyboardManager*
greeter_compositor_keyboard_manager_new (MetaDisplay* display)
{
	return greeter_compositor_keyboard_manager_construct (GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, display);
}

gboolean
greeter_compositor_keyboard_manager_handle_modifiers_accelerator_activated (MetaDisplay* display,
                                                                            gboolean backward)
{
	MetaCompositor* _tmp0_;
	MetaBackend* _tmp1_;
	MetaBackend* _tmp2_;
	MetaBackend* _tmp3_;
	GVariant* sources = NULL;
	GSettings* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	const GVariantType* _tmp7_;
	guint n_sources = 0U;
	GVariant* _tmp8_;
	guint current = 0U;
	GSettings* _tmp9_;
	gboolean result;
	g_return_val_if_fail (display != NULL, FALSE);
	_tmp0_ = meta_display_get_compositor (display);
	g_object_get (_tmp0_, "backend", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	meta_backend_ungrab_keyboard (_tmp3_, meta_display_get_current_time (display));
	_g_object_unref0 (_tmp3_);
	_tmp4_ = greeter_compositor_keyboard_manager_settings;
	_tmp5_ = g_settings_get_value (_tmp4_, "sources");
	sources = _tmp5_;
	_tmp6_ = sources;
	_tmp7_ = greeter_compositor_keyboard_manager_sources_variant_type;
	if (!g_variant_is_of_type (_tmp6_, _tmp7_)) {
		result = TRUE;
		_g_variant_unref0 (sources);
		return result;
	}
	_tmp8_ = sources;
	n_sources = (guint) g_variant_n_children (_tmp8_);
	if (n_sources < ((guint) 2)) {
		result = TRUE;
		_g_variant_unref0 (sources);
		return result;
	}
	_tmp9_ = greeter_compositor_keyboard_manager_settings;
	current = g_settings_get_uint (_tmp9_, "current");
	if (!backward) {
		GSettings* _tmp10_;
		_tmp10_ = greeter_compositor_keyboard_manager_settings;
		g_settings_set_uint (_tmp10_, "current", (current + 1) % n_sources);
	} else {
		GSettings* _tmp11_;
		_tmp11_ = greeter_compositor_keyboard_manager_settings;
		g_settings_set_uint (_tmp11_, "current", (current - 1) % n_sources);
	}
	result = TRUE;
	_g_variant_unref0 (sources);
	return result;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
greeter_compositor_keyboard_manager_set_keyboard_layout (GSettings* settings,
                                                         const gchar* key,
                                                         GreeterCompositorKeyboardManager* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "sources") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, "xkb-options") == 0;
	}
	if (_tmp0_) {
		gchar** layouts = NULL;
		gchar** _tmp1_;
		gint layouts_length1;
		gint _layouts_size_;
		gchar** variants = NULL;
		gchar** _tmp2_;
		gint variants_length1;
		gint _variants_size_;
		GVariant* sources = NULL;
		GVariant* _tmp3_;
		GVariant* _tmp4_;
		const GVariantType* _tmp5_;
		gchar** xkb_options = NULL;
		gchar** _tmp23_;
		gchar** _tmp24_;
		gint xkb_options_length1;
		gint _xkb_options_size_;
		gchar* layout = NULL;
		gchar** _tmp25_;
		gint _tmp25__length1;
		gchar* _tmp26_;
		gchar* variant = NULL;
		gchar** _tmp27_;
		gint _tmp27__length1;
		gchar* _tmp28_;
		gchar* options = NULL;
		gchar** _tmp29_;
		gint _tmp29__length1;
		gchar* _tmp30_;
		MetaDisplay* _tmp31_;
		MetaContext* _tmp32_;
		MetaBackend* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp1_ = g_new0 (gchar*, 0 + 1);
		layouts = _tmp1_;
		layouts_length1 = 0;
		_layouts_size_ = layouts_length1;
		_tmp2_ = g_new0 (gchar*, 0 + 1);
		variants = _tmp2_;
		variants_length1 = 0;
		_variants_size_ = variants_length1;
		_tmp3_ = g_settings_get_value (settings, "sources");
		sources = _tmp3_;
		_tmp4_ = sources;
		_tmp5_ = greeter_compositor_keyboard_manager_sources_variant_type;
		if (!g_variant_is_of_type (_tmp4_, _tmp5_)) {
			_g_variant_unref0 (sources);
			variants = (_vala_array_free (variants, variants_length1, (GDestroyNotify) g_free), NULL);
			layouts = (_vala_array_free (layouts, layouts_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					GVariant* _tmp8_;
					const gchar* type = NULL;
					const gchar* name = NULL;
					GVariant* _tmp9_;
					const gchar* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					const gchar* _tmp12_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = sources;
					if (!(((gsize) i) < g_variant_n_children (_tmp8_))) {
						break;
					}
					type = NULL;
					name = NULL;
					_tmp9_ = sources;
					g_variant_get_child (_tmp9_, (gsize) i, "(&s&s)", &_tmp10_, &_tmp11_, NULL);
					type = _tmp10_;
					name = _tmp11_;
					_tmp12_ = type;
					if (g_strcmp0 (_tmp12_, "xkb") == 0) {
						gchar** arr = NULL;
						const gchar* _tmp13_;
						gchar** _tmp14_;
						gchar** _tmp15_;
						gint arr_length1;
						gint _arr_size_;
						gchar** _tmp16_;
						gint _tmp16__length1;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						const gchar* _tmp19_ = NULL;
						gchar** _tmp20_;
						gint _tmp20__length1;
						const gchar* _tmp21_;
						gchar* _tmp22_;
						_tmp13_ = name;
						_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "+", 2);
						arr = _tmp15_;
						arr_length1 = _vala_array_length (_tmp14_);
						_arr_size_ = arr_length1;
						_tmp16_ = arr;
						_tmp16__length1 = arr_length1;
						_tmp17_ = _tmp16_[0];
						_tmp18_ = g_strdup (_tmp17_);
						_vala_array_add5 (&layouts, &layouts_length1, &_layouts_size_, _tmp18_);
						_tmp20_ = arr;
						_tmp20__length1 = arr_length1;
						_tmp21_ = _tmp20_[1];
						_tmp19_ = _tmp21_;
						if (_tmp19_ == NULL) {
							_tmp19_ = "";
						}
						_tmp22_ = g_strdup (_tmp19_);
						_vala_array_add6 (&variants, &variants_length1, &_variants_size_, _tmp22_);
						arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
					}
				}
			}
		}
		_tmp24_ = _tmp23_ = g_settings_get_strv (settings, "xkb-options");
		xkb_options = _tmp24_;
		xkb_options_length1 = _vala_array_length (_tmp23_);
		_xkb_options_size_ = xkb_options_length1;
		_tmp25_ = layouts;
		_tmp25__length1 = layouts_length1;
		_tmp26_ = _vala_g_strjoinv (",", _tmp25_, (gint) _tmp25__length1);
		layout = _tmp26_;
		_tmp27_ = variants;
		_tmp27__length1 = variants_length1;
		_tmp28_ = _vala_g_strjoinv (",", _tmp27_, (gint) _tmp27__length1);
		variant = _tmp28_;
		_tmp29_ = xkb_options;
		_tmp29__length1 = xkb_options_length1;
		_tmp30_ = _vala_g_strjoinv (",", _tmp29_, (gint) _tmp29__length1);
		options = _tmp30_;
		_tmp31_ = self->priv->_display;
		_tmp32_ = meta_display_get_context (_tmp31_);
		_tmp33_ = meta_context_get_backend (_tmp32_);
		_tmp34_ = layout;
		_tmp35_ = variant;
		_tmp36_ = options;
		meta_backend_set_keymap (_tmp33_, _tmp34_, _tmp35_, _tmp36_, "");
		_g_free0 (options);
		_g_free0 (variant);
		_g_free0 (layout);
		xkb_options = (_vala_array_free (xkb_options, xkb_options_length1, (GDestroyNotify) g_free), NULL);
		_g_variant_unref0 (sources);
		variants = (_vala_array_free (variants, variants_length1, (GDestroyNotify) g_free), NULL);
		layouts = (_vala_array_free (layouts, layouts_length1, (GDestroyNotify) g_free), NULL);
	} else {
		if (g_strcmp0 (key, "current") == 0) {
			MetaDisplay* _tmp37_;
			MetaContext* _tmp38_;
			MetaBackend* _tmp39_;
			_tmp37_ = self->priv->_display;
			_tmp38_ = meta_display_get_context (_tmp37_);
			_tmp39_ = meta_context_get_backend (_tmp38_);
			meta_backend_lock_layout_group (_tmp39_, g_settings_get_uint (settings, "current"));
		}
	}
}

static MetaDisplay*
greeter_compositor_keyboard_manager_get_display (GreeterCompositorKeyboardManager* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_keyboard_manager_set_display (GreeterCompositorKeyboardManager* self,
                                                 MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_keyboard_manager_get_display (self);
	if (old_value != value) {
		self->priv->_display = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_keyboard_manager_properties[GREETER_COMPOSITOR_KEYBOARD_MANAGER_DISPLAY_PROPERTY]);
	}
}

static void
_greeter_compositor_keyboard_manager_set_keyboard_layout_g_settings_changed (GSettings* _sender,
                                                                             const gchar* key,
                                                                             gpointer self)
{
	greeter_compositor_keyboard_manager_set_keyboard_layout (_sender, key, (GreeterCompositorKeyboardManager*) self);
}

static GObject *
greeter_compositor_keyboard_manager_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorKeyboardManager * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	parent_class = G_OBJECT_CLASS (greeter_compositor_keyboard_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManager);
	_tmp0_ = greeter_compositor_keyboard_manager_settings;
	g_signal_connect_object (_tmp0_, "changed", (GCallback) _greeter_compositor_keyboard_manager_set_keyboard_layout_g_settings_changed, self, 0);
	_tmp1_ = greeter_compositor_keyboard_manager_settings;
	greeter_compositor_keyboard_manager_set_keyboard_layout (_tmp1_, "sources", self);
	_tmp2_ = greeter_compositor_keyboard_manager_settings;
	greeter_compositor_keyboard_manager_set_keyboard_layout (_tmp2_, "current", self);
	return obj;
}

static void
greeter_compositor_keyboard_manager_class_init (GreeterCompositorKeyboardManagerClass * klass,
                                                gpointer klass_data)
{
	GVariantType* _tmp0_;
	GSettingsSchema* schema = NULL;
	GSettingsSchemaSource* _tmp1_;
	GSettingsSchema* _tmp2_;
	GSettingsSchema* _tmp3_;
	GSettingsSchema* _tmp4_;
	GSettings* _tmp5_;
	greeter_compositor_keyboard_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorKeyboardManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_keyboard_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_keyboard_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_keyboard_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_keyboard_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_KEYBOARD_MANAGER_DISPLAY_PROPERTY, greeter_compositor_keyboard_manager_properties[GREETER_COMPOSITOR_KEYBOARD_MANAGER_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_variant_type_new ("a(ss)");
	_g_variant_type_free0 (greeter_compositor_keyboard_manager_sources_variant_type);
	greeter_compositor_keyboard_manager_sources_variant_type = _tmp0_;
	_tmp1_ = g_settings_schema_source_get_default ();
	_tmp2_ = g_settings_schema_source_lookup (_tmp1_, "org.gnome.desktop.input-sources", TRUE);
	schema = _tmp2_;
	_tmp3_ = schema;
	if (_tmp3_ == NULL) {
		g_critical ("KeyboardManager.vala:29: org.gnome.desktop.input-sources not found.");
	}
	_tmp4_ = schema;
	_tmp5_ = g_settings_new_full (_tmp4_, NULL, NULL);
	_g_object_unref0 (greeter_compositor_keyboard_manager_settings);
	greeter_compositor_keyboard_manager_settings = _tmp5_;
	_g_settings_schema_unref0 (schema);
}

static void
greeter_compositor_keyboard_manager_instance_init (GreeterCompositorKeyboardManager * self,
                                                   gpointer klass)
{
	self->priv = greeter_compositor_keyboard_manager_get_instance_private (self);
}

static void
greeter_compositor_keyboard_manager_finalize (GObject * obj)
{
	GreeterCompositorKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManager);
	G_OBJECT_CLASS (greeter_compositor_keyboard_manager_parent_class)->finalize (obj);
}

static GType
greeter_compositor_keyboard_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorKeyboardManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_keyboard_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorKeyboardManager), 0, (GInstanceInitFunc) greeter_compositor_keyboard_manager_instance_init, NULL };
	GType greeter_compositor_keyboard_manager_type_id;
	greeter_compositor_keyboard_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorKeyboardManager", &g_define_type_info, 0);
	GreeterCompositorKeyboardManager_private_offset = g_type_add_instance_private (greeter_compositor_keyboard_manager_type_id, sizeof (GreeterCompositorKeyboardManagerPrivate));
	return greeter_compositor_keyboard_manager_type_id;
}

GType
greeter_compositor_keyboard_manager_get_type (void)
{
	static volatile gsize greeter_compositor_keyboard_manager_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_keyboard_manager_type_id__once)) {
		GType greeter_compositor_keyboard_manager_type_id;
		greeter_compositor_keyboard_manager_type_id = greeter_compositor_keyboard_manager_get_type_once ();
		g_once_init_leave (&greeter_compositor_keyboard_manager_type_id__once, greeter_compositor_keyboard_manager_type_id);
	}
	return greeter_compositor_keyboard_manager_type_id__once;
}

static void
_vala_greeter_compositor_keyboard_manager_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	GreeterCompositorKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_KEYBOARD_MANAGER_DISPLAY_PROPERTY:
		g_value_set_object (value, greeter_compositor_keyboard_manager_get_display (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_keyboard_manager_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	GreeterCompositorKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_KEYBOARD_MANAGER, GreeterCompositorKeyboardManager);
	switch (property_id) {
		case GREETER_COMPOSITOR_KEYBOARD_MANAGER_DISPLAY_PROPERTY:
		greeter_compositor_keyboard_manager_set_display (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

