/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/core/v1"
	corev1 "k8s.io/client-go/applyconfigurations/core/v1"
	gentype "k8s.io/client-go/gentype"
	typedcorev1 "k8s.io/client-go/kubernetes/typed/core/v1"
)

// fakeComponentStatuses implements ComponentStatusInterface
type fakeComponentStatuses struct {
	*gentype.FakeClientWithListAndApply[*v1.ComponentStatus, *v1.ComponentStatusList, *corev1.ComponentStatusApplyConfiguration]
	Fake *FakeCoreV1
}

func newFakeComponentStatuses(fake *FakeCoreV1) typedcorev1.ComponentStatusInterface {
	return &fakeComponentStatuses{
		gentype.NewFakeClientWithListAndApply[*v1.ComponentStatus, *v1.ComponentStatusList, *corev1.ComponentStatusApplyConfiguration](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("componentstatuses"),
			v1.SchemeGroupVersion.WithKind("ComponentStatus"),
			func() *v1.ComponentStatus { return &v1.ComponentStatus{} },
			func() *v1.ComponentStatusList { return &v1.ComponentStatusList{} },
			func(dst, src *v1.ComponentStatusList) { dst.ListMeta = src.ListMeta },
			func(list *v1.ComponentStatusList) []*v1.ComponentStatus { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.ComponentStatusList, items []*v1.ComponentStatus) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
