/* Autogenerated file, DO NOT EDIT manually! generated by oa-metricset-codegen.py */
// SPDX-License-Identifier: MIT
/*
 * Copyright © 2024 Intel Corporation
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "xe_oa_metrics_acmgt1.h"
#include "xe_oa_equations.h"
#include "xe_oa_registers_acmgt1.h"

static bool acmgt1_render_basic_Sampler20Bottleneck_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_render_basic_Sampler20Busy_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_render_basic_SamplerBottleneck_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_render_basic_SamplersBusy_availability(const struct intel_xe_perf *perf) {
    if (intel_xe_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_render_basic_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic - aggregation approximation";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "f5b8f05e-c84c-4f1c-bb05-68fbea73879b";
    metric_set->counters = calloc(30, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_render_basic_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__render_basic__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__render_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = acmgt1__render_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "ThreadDispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__render_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__render_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__render_basic__gti_read_throughput__read,
                .max_uint64 = acmgt1__render_basic__gti_read_throughput__max,
                .group = "Memory",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__render_basic__gti_write_throughput__read,
                .max_uint64 = acmgt1__render_basic__gti_write_throughput__max,
                .group = "Memory",
            },

            {
                .name = "FS EM Pipe Active",
                .symbol_name = "PsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__ps_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "FS FPU Pipe Active",
                .symbol_name = "PsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__ps_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "FS Send Pipe Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "Sampler20 Bottleneck",
                .symbol_name = "Sampler20Bottleneck",
                .desc = "The percentage of time in which Slice2 Sampler0 has been slowing down the pipe when processing XVE requests.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__sampler20_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_render_basic_Sampler20Bottleneck_availability,
            },

            {
                .name = "Sampler Slice2 Xe Core0 is busy",
                .symbol_name = "Sampler20Busy",
                .desc = "The percentage of time when sampler slice2 Xe core0 is busy",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__sampler20_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_render_basic_Sampler20Busy_availability,
            },

            {
                .name = "Samplers Bottleneck",
                .symbol_name = "SamplerBottleneck",
                .desc = "The percentage of time in which samplers have been slowing down the pipe when processing XVE requests.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__sampler_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_render_basic_SamplerBottleneck_availability,
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = acmgt1__render_basic__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = acmgt1__render_basic__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Samplers Busy",
                .symbol_name = "SamplersBusy",
                .desc = "The percentage of time in which samplers or L1 cache are not idle.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__samplers_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_render_basic_SamplersBusy_availability,
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = acmgt1__render_basic__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = acmgt1__render_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__render_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__render_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__render_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmReads",
                .desc = "The total number of reads from shared local memory.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__render_basic__slm_reads__read,
                .max_uint64 = acmgt1__render_basic__slm_reads__max,
                .group = "L1Cache",
            },

            {
                .name = "SLM Writes",
                .symbol_name = "SlmWrites",
                .desc = "The total number of writes into shared local memory.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__render_basic__slm_writes__read,
                .max_uint64 = acmgt1__render_basic__slm_writes__max,
                .group = "L1Cache",
            },

            {
                .name = "VS EM Pipe Active",
                .symbol_name = "VsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__vs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "VS FPU Pipe Active",
                .symbol_name = "VsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__vs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XveActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "EM And FPU Pipes Active",
                .symbol_name = "XveFpuEmActive",
                .desc = "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__xve_fpu_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XveStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Thread Occupancy",
                .symbol_name = "XveThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied XVEs.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__xve_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 30);
}


static void
acmgt1_add_test_oa_metric_set(struct intel_xe_perf *perf)
{
    struct intel_xe_perf_metric_set *metric_set;
    struct intel_xe_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TestOa";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "57f210de-b537-464a-af7b-7dfe2f3780c1";
    metric_set->counters = calloc(13, sizeof(struct intel_xe_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = XE_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_test_oa_add_registers(perf, metric_set);
    intel_xe_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_xe_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__test_oa__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__test_oa__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "TestCounter0",
                .symbol_name = "Counter0",
                .desc = "HW test counter 0. Factor: 0.0",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter1",
                .symbol_name = "Counter1",
                .desc = "HW test counter 1. Factor: 1.0",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter2",
                .symbol_name = "Counter2",
                .desc = "HW test counter 2. Factor: 1.0",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter3",
                .symbol_name = "Counter3",
                .desc = "HW test counter 3. Factor: 0.5",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter4",
                .symbol_name = "Counter4",
                .desc = "HW test counter 4. Factor: 0.3333",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter5",
                .symbol_name = "Counter5",
                .desc = "HW test counter 5. Factor: 0.3333",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter6",
                .symbol_name = "Counter6",
                .desc = "HW test counter 6. Factor: 0.16666",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter7",
                .symbol_name = "Counter7",
                .desc = "HW test counter 7. Factor: 0.6666",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter8",
                .symbol_name = "Counter8",
                .desc = "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter8__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter9 - OAR enable",
                .symbol_name = "Counter9",
                .desc = "HW test counter 9. Should be equal to 1 in query.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter9__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__test_oa__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_XE_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_XE_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_XE_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__test_oa__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_xe_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 13);
}

void
intel_xe_perf_load_metrics_acmgt1(struct intel_xe_perf *perf)
{
    acmgt1_add_render_basic_metric_set(perf);
    acmgt1_add_test_oa_metric_set(perf);
}
