/* imap-response-code.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-response-code.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_RESPONSE_CODE_0_PROPERTY,
	GEARY_IMAP_RESPONSE_CODE_NUM_PROPERTIES
};
static GParamSpec* geary_imap_response_code_properties[GEARY_IMAP_RESPONSE_CODE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer geary_imap_response_code_parent_class = NULL;

static gchar* geary_imap_response_code_real_to_string (GearyImapParameter* base);
static void geary_imap_response_code_real_serialize (GearyImapParameter* base,
                                              GearyImapSerializer* ser,
                                              GCancellable* cancellable,
                                              GError** error);
static GType geary_imap_response_code_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GearyImapResponseCode*
geary_imap_response_code_construct (GType object_type)
{
	GearyImapResponseCode * self = NULL;
	self = (GearyImapResponseCode*) geary_imap_list_parameter_construct (object_type);
	return self;
}

GearyImapResponseCode*
geary_imap_response_code_new (void)
{
	return geary_imap_response_code_construct (GEARY_IMAP_TYPE_RESPONSE_CODE);
}

GearyImapResponseCodeType*
geary_imap_response_code_get_response_code_type (GearyImapResponseCode* self,
                                                 GError** error)
{
	GearyImapStringParameter* _tmp0_ = NULL;
	GearyImapStringParameter* _tmp1_;
	GearyImapResponseCodeType* _tmp2_ = NULL;
	GearyImapResponseCodeType* _tmp3_;
	GearyImapResponseCodeType* _tmp4_;
	GError* _inner_error0_ = NULL;
	GearyImapResponseCodeType* result;
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE (self), NULL);
	_tmp1_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 0, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = geary_imap_response_code_type_new_from_parameter (_tmp0_, &_inner_error0_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Converts the {@link ResponseCode} into a UIDNEXT {@link UID}, if possible.
     *
     * @throws ImapError.INVALID if not UIDNEXT.
     */
GearyImapUID*
geary_imap_response_code_get_uid_next (GearyImapResponseCode* self,
                                       GError** error)
{
	GearyImapResponseCodeType* _tmp0_ = NULL;
	GearyImapResponseCodeType* _tmp1_;
	GearyImapStringParameter* _tmp6_ = NULL;
	GearyImapStringParameter* _tmp7_;
	gint64 _tmp8_ = 0LL;
	GearyImapUID* _tmp9_ = NULL;
	GearyImapUID* _tmp10_;
	GearyImapUID* _tmp11_;
	GError* _inner_error0_ = NULL;
	GearyImapUID* result;
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE (self), NULL);
	_tmp1_ = geary_imap_response_code_get_response_code_type (self, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!geary_imap_response_code_type_is_value (_tmp0_, GEARY_IMAP_RESPONSE_CODE_TYPE_UIDNEXT)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not UIDNEXT: %s", _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	_tmp6_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = geary_imap_string_parameter_as_int64 (_tmp6_, G_MININT64, G_MAXINT64, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = geary_imap_uid_new_checked (_tmp8_, &_inner_error0_);
	_tmp9_ = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = _tmp9_;
	_tmp9_ = NULL;
	result = _tmp11_;
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Converts the {@link ResponseCode} into a {@link UIDValidity}, if possible.
     *
     * @throws ImapError.INVALID if not UIDVALIDITY.
     */
GearyImapUIDValidity*
geary_imap_response_code_get_uid_validity (GearyImapResponseCode* self,
                                           GError** error)
{
	GearyImapResponseCodeType* _tmp0_ = NULL;
	GearyImapResponseCodeType* _tmp1_;
	GearyImapStringParameter* _tmp6_ = NULL;
	GearyImapStringParameter* _tmp7_;
	gint64 _tmp8_ = 0LL;
	GearyImapUIDValidity* _tmp9_ = NULL;
	GearyImapUIDValidity* _tmp10_;
	GearyImapUIDValidity* _tmp11_;
	GError* _inner_error0_ = NULL;
	GearyImapUIDValidity* result;
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE (self), NULL);
	_tmp1_ = geary_imap_response_code_get_response_code_type (self, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!geary_imap_response_code_type_is_value (_tmp0_, GEARY_IMAP_RESPONSE_CODE_TYPE_UIDVALIDITY)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not UIDVALIDITY: %s", _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	_tmp6_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = geary_imap_string_parameter_as_int64 (_tmp6_, G_MININT64, G_MAXINT64, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = geary_imap_uid_validity_new_checked (_tmp8_, &_inner_error0_);
	_tmp9_ = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = _tmp9_;
	_tmp9_ = NULL;
	result = _tmp11_;
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Converts the {@link ResponseCode} into an UNSEEN value, if possible.
     *
     * @throws ImapError.INVALID if not UNSEEN.
     */
gint
geary_imap_response_code_get_unseen (GearyImapResponseCode* self,
                                     GError** error)
{
	GearyImapResponseCodeType* _tmp0_ = NULL;
	GearyImapResponseCodeType* _tmp1_;
	GearyImapStringParameter* _tmp10_ = NULL;
	GearyImapStringParameter* _tmp11_;
	gint32 _tmp14_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE (self), 0);
	_tmp1_ = geary_imap_response_code_get_response_code_type (self, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint _tmp2_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp2_;
		} else {
			gint _tmp3_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	if (!geary_imap_response_code_type_is_value (_tmp0_, GEARY_IMAP_RESPONSE_CODE_TYPE_UNSEEN)) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp4_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not UNSEEN: %s", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint _tmp8_ = -1;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return _tmp8_;
		} else {
			gint _tmp9_ = -1;
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp9_;
		}
	}
	_tmp11_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	_tmp10_ = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint _tmp12_ = -1;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return _tmp12_;
		} else {
			gint _tmp13_ = -1;
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp13_;
		}
	}
	_tmp14_ = geary_imap_string_parameter_as_int32 (_tmp10_, (gint32) 0, (gint32) G_MAXINT, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint _tmp15_ = -1;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp10_);
			_g_object_unref0 (_tmp0_);
			return _tmp15_;
		} else {
			gint _tmp16_ = -1;
			_g_object_unref0 (_tmp10_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp16_;
		}
	}
	result = (gint) _tmp14_;
	_g_object_unref0 (_tmp10_);
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Converts the {@link ResponseCode} into PERMANENTFLAGS {@link MessageFlags}, if possible.
     *
     * @throws ImapError.INVALID if not PERMANENTFLAGS.
     */
GearyImapMessageFlags*
geary_imap_response_code_get_permanent_flags (GearyImapResponseCode* self,
                                              GError** error)
{
	GearyImapResponseCodeType* _tmp0_ = NULL;
	GearyImapResponseCodeType* _tmp1_;
	GearyImapListParameter* _tmp6_ = NULL;
	GearyImapListParameter* _tmp7_;
	GearyImapMessageFlags* _tmp8_ = NULL;
	GearyImapMessageFlags* _tmp9_;
	GearyImapMessageFlags* _tmp10_;
	GError* _inner_error0_ = NULL;
	GearyImapMessageFlags* result;
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE (self), NULL);
	_tmp1_ = geary_imap_response_code_get_response_code_type (self, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!geary_imap_response_code_type_is_value (_tmp0_, GEARY_IMAP_RESPONSE_CODE_TYPE_PERMANENT_FLAGS)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not PERMANENTFLAGS: %s", _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = geary_imap_list_parameter_get_as_list (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	_tmp6_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp9_ = geary_imap_message_flags_from_list (_tmp6_, &_inner_error0_);
	_tmp8_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = _tmp8_;
	_tmp8_ = NULL;
	result = _tmp10_;
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Parses the {@link ResponseCode} into {@link Capabilities}, if possible.
     *
     * @throws ImapError.INVALID if Capability was not specified.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapCapabilities*
geary_imap_response_code_get_capabilities (GearyImapResponseCode* self,
                                           gint revision,
                                           GError** error)
{
	GearyImapResponseCodeType* _tmp0_ = NULL;
	GearyImapResponseCodeType* _tmp1_;
	GearyImapStringParameter** params = NULL;
	gint _tmp6_;
	gint _tmp7_;
	GearyImapStringParameter** _tmp8_;
	gint params_length1;
	gint _params_size_;
	gint count = 0;
	GearyImapStringParameter** _tmp19_;
	gint _tmp19__length1;
	GearyImapCapabilities* _tmp20_;
	GError* _inner_error0_ = NULL;
	GearyImapCapabilities* result;
	g_return_val_if_fail (GEARY_IMAP_IS_RESPONSE_CODE (self), NULL);
	_tmp1_ = geary_imap_response_code_get_response_code_type (self, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!geary_imap_response_code_type_is_value (_tmp0_, GEARY_IMAP_RESPONSE_CODE_TYPE_CAPABILITY)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not CAPABILITY response code: %s", _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
	_tmp7_ = _tmp6_;
	_tmp8_ = g_new0 (GearyImapStringParameter*, _tmp7_ + 1);
	params = _tmp8_;
	params_length1 = _tmp7_;
	_params_size_ = params_length1;
	count = 0;
	{
		gint ctr = 0;
		ctr = 1;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				GearyImapStringParameter* param = NULL;
				GearyImapStringParameter* _tmp13_;
				GearyImapStringParameter* _tmp14_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = ctr;
					ctr = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
				_tmp12_ = _tmp11_;
				if (!(ctr < _tmp12_)) {
					break;
				}
				_tmp13_ = geary_imap_list_parameter_get_if_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), ctr);
				param = _tmp13_;
				_tmp14_ = param;
				if (_tmp14_ != NULL) {
					GearyImapStringParameter** _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					GearyImapStringParameter* _tmp17_;
					GearyImapStringParameter* _tmp18_;
					_tmp15_ = params;
					_tmp15__length1 = params_length1;
					_tmp16_ = count;
					count = _tmp16_ + 1;
					_tmp17_ = param;
					_tmp18_ = _g_object_ref0 (_tmp17_);
					_g_object_unref0 (_tmp15_[_tmp16_]);
					_tmp15_[_tmp16_] = _tmp18_;
				}
				_g_object_unref0 (param);
			}
		}
	}
	_tmp19_ = params;
	_tmp19__length1 = params_length1;
	_tmp20_ = geary_imap_capabilities_new (_tmp19_ + 0, count - 0, revision);
	result = _tmp20_;
	params = (_vala_array_free (params, params_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Parses the {@link ResponseCode} into UIDPLUS' COPYUID response, if possible.
     *
     * Note that the {@link UID}s are returned from the server in the order the messages
     * were copied.
     *
     * See [[http://tools.ietf.org/html/rfc4315#section-3]]
     *
     * @throws ImapError.INVALID if not COPYUID.
     */
void
geary_imap_response_code_get_copyuid (GearyImapResponseCode* self,
                                      GearyImapUIDValidity** uidvalidity,
                                      GeeList** source_uids,
                                      GeeList** destination_uids,
                                      GError** error)
{
	GearyImapUIDValidity* _vala_uidvalidity = NULL;
	GeeList* _vala_source_uids = NULL;
	GeeList* _vala_destination_uids = NULL;
	GearyImapResponseCodeType* _tmp0_ = NULL;
	GearyImapResponseCodeType* _tmp1_;
	GearyImapNumberParameter* _tmp6_ = NULL;
	GearyImapNumberParameter* _tmp7_;
	gint64 _tmp8_ = 0LL;
	GearyImapUIDValidity* _tmp9_ = NULL;
	GearyImapUIDValidity* _tmp10_;
	GearyImapUIDValidity* _tmp11_;
	GearyImapStringParameter* _tmp12_ = NULL;
	GearyImapStringParameter* _tmp13_;
	GeeList* _tmp14_ = NULL;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GeeList* _tmp17_;
	GeeList* _tmp18_;
	GearyImapStringParameter* _tmp19_ = NULL;
	GearyImapStringParameter* _tmp20_;
	GeeList* _tmp21_ = NULL;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GeeList* _tmp24_;
	GeeList* _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_RESPONSE_CODE (self));
	_tmp1_ = geary_imap_response_code_get_response_code_type (self, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			return;
		} else {
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (!geary_imap_response_code_type_is_value (_tmp0_, GEARY_IMAP_RESPONSE_CODE_TYPE_COPYUID)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp2_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not COPYUID response code: %s", _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			return;
		} else {
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = geary_imap_list_parameter_get_as_number (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	_tmp6_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			return;
		} else {
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp8_ = geary_imap_string_parameter_as_int64 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter), G_MININT64, G_MAXINT64, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			return;
		} else {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = geary_imap_uid_validity_new_checked (_tmp8_, &_inner_error0_);
	_tmp9_ = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			return;
		} else {
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp11_ = _tmp9_;
	_tmp9_ = NULL;
	_g_object_unref0 (_vala_uidvalidity);
	_vala_uidvalidity = _tmp11_;
	_tmp13_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 2, &_inner_error0_);
	_tmp12_ = _tmp13_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			return;
		} else {
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp15_ = geary_imap_string_parameter_get_ascii (_tmp12_);
	_tmp16_ = _tmp15_;
	_tmp17_ = geary_imap_message_set_uid_parse (_tmp16_, &_inner_error0_);
	_tmp14_ = _tmp17_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			return;
		} else {
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp18_ = _tmp14_;
	_tmp14_ = NULL;
	_g_object_unref0 (_vala_source_uids);
	_vala_source_uids = _tmp18_;
	_tmp20_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 3, &_inner_error0_);
	_tmp19_ = _tmp20_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			return;
		} else {
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp22_ = geary_imap_string_parameter_get_ascii (_tmp19_);
	_tmp23_ = _tmp22_;
	_tmp24_ = geary_imap_message_set_uid_parse (_tmp23_, &_inner_error0_);
	_tmp21_ = _tmp24_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp19_);
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			return;
		} else {
			_g_object_unref0 (_tmp19_);
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (_vala_uidvalidity);
			_g_object_unref0 (_vala_source_uids);
			_g_object_unref0 (_vala_destination_uids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp25_ = _tmp21_;
	_tmp21_ = NULL;
	_g_object_unref0 (_vala_destination_uids);
	_vala_destination_uids = _tmp25_;
	_g_object_unref0 (_tmp21_);
	_g_object_unref0 (_tmp19_);
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp0_);
	if (uidvalidity) {
		*uidvalidity = _vala_uidvalidity;
	} else {
		_g_object_unref0 (_vala_uidvalidity);
	}
	if (source_uids) {
		*source_uids = _vala_source_uids;
	} else {
		_g_object_unref0 (_vala_source_uids);
	}
	if (destination_uids) {
		*destination_uids = _vala_destination_uids;
	} else {
		_g_object_unref0 (_vala_destination_uids);
	}
}

static gchar*
geary_imap_response_code_real_to_string (GearyImapParameter* base)
{
	GearyImapResponseCode * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_RESPONSE_CODE, GearyImapResponseCode);
	_tmp0_ = geary_imap_list_parameter_stringize_list (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("[%s]", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
geary_imap_response_code_real_serialize (GearyImapParameter* base,
                                         GearyImapSerializer* ser,
                                         GCancellable* cancellable,
                                         GError** error)
{
	GearyImapResponseCode * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_RESPONSE_CODE, GearyImapResponseCode);
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	geary_imap_serializer_push_ascii (ser, '[', cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	geary_imap_list_parameter_serialize_list (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), ser, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	geary_imap_serializer_push_ascii (ser, ']', cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
geary_imap_response_code_class_init (GearyImapResponseCodeClass * klass,
                                     gpointer klass_data)
{
	geary_imap_response_code_parent_class = g_type_class_peek_parent (klass);
	((GearyImapParameterClass *) klass)->to_string = (gchar* (*) (GearyImapParameter*)) geary_imap_response_code_real_to_string;
	((GearyImapParameterClass *) klass)->serialize = (void (*) (GearyImapParameter*, GearyImapSerializer*, GCancellable*, GError**)) geary_imap_response_code_real_serialize;
}

static void
geary_imap_response_code_instance_init (GearyImapResponseCode * self,
                                        gpointer klass)
{
}

/**
 * A response code and additional information that optionally accompanies a {@link StatusResponse}.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-7.1]] for more information.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_response_code_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapResponseCodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_response_code_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapResponseCode), 0, (GInstanceInitFunc) geary_imap_response_code_instance_init, NULL };
	GType geary_imap_response_code_type_id;
	geary_imap_response_code_type_id = g_type_register_static (GEARY_IMAP_TYPE_LIST_PARAMETER, "GearyImapResponseCode", &g_define_type_info, 0);
	return geary_imap_response_code_type_id;
}

GType
geary_imap_response_code_get_type (void)
{
	static gsize geary_imap_response_code_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_response_code_type_id__once)) {
		GType geary_imap_response_code_type_id;
		geary_imap_response_code_type_id = geary_imap_response_code_get_type_once ();
		g_once_init_leave (&geary_imap_response_code_type_id__once, geary_imap_response_code_type_id);
	}
	return geary_imap_response_code_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

