/* geary-composed-email.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from geary-composed-email.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>

#define GEARY_COMPOSED_EMAIL_IMG_SRC_TEMPLATE "src=\"%s\""
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_COMPOSED_EMAIL_0_PROPERTY,
	GEARY_COMPOSED_EMAIL_FROM_PROPERTY,
	GEARY_COMPOSED_EMAIL_SENDER_PROPERTY,
	GEARY_COMPOSED_EMAIL_REPLY_TO_PROPERTY,
	GEARY_COMPOSED_EMAIL_TO_PROPERTY,
	GEARY_COMPOSED_EMAIL_CC_PROPERTY,
	GEARY_COMPOSED_EMAIL_BCC_PROPERTY,
	GEARY_COMPOSED_EMAIL_MESSAGE_ID_PROPERTY,
	GEARY_COMPOSED_EMAIL_IN_REPLY_TO_PROPERTY,
	GEARY_COMPOSED_EMAIL_REFERENCES_PROPERTY,
	GEARY_COMPOSED_EMAIL_SUBJECT_PROPERTY,
	GEARY_COMPOSED_EMAIL_DATE_PROPERTY,
	GEARY_COMPOSED_EMAIL_BODY_TEXT_PROPERTY,
	GEARY_COMPOSED_EMAIL_BODY_HTML_PROPERTY,
	GEARY_COMPOSED_EMAIL_MAILER_PROPERTY,
	GEARY_COMPOSED_EMAIL_REPLY_TO_EMAIL_PROPERTY,
	GEARY_COMPOSED_EMAIL_ATTACHED_FILES_PROPERTY,
	GEARY_COMPOSED_EMAIL_INLINE_FILES_PROPERTY,
	GEARY_COMPOSED_EMAIL_CID_FILES_PROPERTY,
	GEARY_COMPOSED_EMAIL_IMG_SRC_PREFIX_PROPERTY,
	GEARY_COMPOSED_EMAIL_NUM_PROPERTIES
};
static GParamSpec* geary_composed_email_properties[GEARY_COMPOSED_EMAIL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyComposedEmailPrivate {
	GearyRFC822MailboxAddresses* _from;
	GearyRFC822MailboxAddress* _sender;
	GearyRFC822MailboxAddresses* _reply_to;
	GearyRFC822MailboxAddresses* _to;
	GearyRFC822MailboxAddresses* _cc;
	GearyRFC822MailboxAddresses* _bcc;
	GearyRFC822MessageID* _message_id;
	GearyRFC822MessageIDList* _in_reply_to;
	GearyRFC822MessageIDList* _references;
	GearyRFC822Subject* _subject;
	GearyRFC822Date* _date;
	gchar* _body_text;
	gchar* _body_html;
	gchar* _mailer;
	GearyEmail* _reply_to_email;
	GeeSet* _attached_files;
	GeeMap* _inline_files;
	GeeMap* _cid_files;
	gchar* _img_src_prefix;
};

static gint GearyComposedEmail_private_offset;
static gpointer geary_composed_email_parent_class = NULL;
static GearyEmailHeaderSetIface * geary_composed_email_geary_email_header_set_parent_iface = NULL;

static void geary_composed_email_set_attached_files (GearyComposedEmail* self,
                                              GeeSet* value);
static guint _geary_files_nullable_hash_gee_hash_data_func (gconstpointer v,
                                                     gpointer self);
static gboolean _geary_files_nullable_equal_gee_equal_data_func (gconstpointer a,
                                                          gconstpointer b,
                                                          gpointer self);
static void geary_composed_email_set_inline_files (GearyComposedEmail* self,
                                            GeeMap* value);
static void geary_composed_email_set_cid_files (GearyComposedEmail* self,
                                         GeeMap* value);
static gpointer geary_composed_email_empty_to_null (GearyComposedEmail* self,
                                             GType t_type,
                                             GBoxedCopyFunc t_dup_func,
                                             GDestroyNotify t_destroy_func,
                                             gconstpointer list);
static void geary_composed_email_finalize (GObject * obj);
static GType geary_composed_email_get_type_once (void);
static void _vala_geary_composed_email_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_geary_composed_email_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
geary_composed_email_get_instance_private (GearyComposedEmail* self)
{
	return G_STRUCT_MEMBER_P (self, GearyComposedEmail_private_offset);
}

static GearyRFC822MailboxAddresses*
geary_composed_email_real_get_from (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyComposedEmail* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_tmp0_ = self->priv->_from;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddress*
geary_composed_email_real_get_sender (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddress* result;
	GearyComposedEmail* self;
	GearyRFC822MailboxAddress* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_tmp0_ = self->priv->_sender;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_composed_email_real_get_reply_to (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyComposedEmail* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_tmp0_ = self->priv->_reply_to;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_composed_email_real_get_to (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyComposedEmail* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_tmp0_ = self->priv->_to;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_composed_email_real_get_cc (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyComposedEmail* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_tmp0_ = self->priv->_cc;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_composed_email_real_get_bcc (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyComposedEmail* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_tmp0_ = self->priv->_bcc;
	result = _tmp0_;
	return result;
}

static GearyRFC822MessageID*
geary_composed_email_real_get_message_id (GearyEmailHeaderSet* base)
{
	GearyRFC822MessageID* result;
	GearyComposedEmail* self;
	GearyRFC822MessageID* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_tmp0_ = self->priv->_message_id;
	result = _tmp0_;
	return result;
}

static GearyRFC822MessageIDList*
geary_composed_email_real_get_in_reply_to (GearyEmailHeaderSet* base)
{
	GearyRFC822MessageIDList* result;
	GearyComposedEmail* self;
	GearyRFC822MessageIDList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_tmp0_ = self->priv->_in_reply_to;
	result = _tmp0_;
	return result;
}

static GearyRFC822MessageIDList*
geary_composed_email_real_get_references (GearyEmailHeaderSet* base)
{
	GearyRFC822MessageIDList* result;
	GearyComposedEmail* self;
	GearyRFC822MessageIDList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_tmp0_ = self->priv->_references;
	result = _tmp0_;
	return result;
}

static GearyRFC822Subject*
geary_composed_email_real_get_subject (GearyEmailHeaderSet* base)
{
	GearyRFC822Subject* result;
	GearyComposedEmail* self;
	GearyRFC822Subject* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_tmp0_ = self->priv->_subject;
	result = _tmp0_;
	return result;
}

static GearyRFC822Date*
geary_composed_email_real_get_date (GearyEmailHeaderSet* base)
{
	GearyRFC822Date* result;
	GearyComposedEmail* self;
	GearyRFC822Date* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_tmp0_ = self->priv->_date;
	result = _tmp0_;
	return result;
}

const gchar*
geary_composed_email_get_body_text (GearyComposedEmail* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	_tmp0_ = self->priv->_body_text;
	result = _tmp0_;
	return result;
}

void
geary_composed_email_set_body_text (GearyComposedEmail* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_COMPOSED_EMAIL (self));
	old_value = geary_composed_email_get_body_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_body_text);
		self->priv->_body_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_BODY_TEXT_PROPERTY]);
	}
}

const gchar*
geary_composed_email_get_body_html (GearyComposedEmail* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	_tmp0_ = self->priv->_body_html;
	result = _tmp0_;
	return result;
}

void
geary_composed_email_set_body_html (GearyComposedEmail* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_COMPOSED_EMAIL (self));
	old_value = geary_composed_email_get_body_html (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_body_html);
		self->priv->_body_html = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_BODY_HTML_PROPERTY]);
	}
}

const gchar*
geary_composed_email_get_mailer (GearyComposedEmail* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	_tmp0_ = self->priv->_mailer;
	result = _tmp0_;
	return result;
}

void
geary_composed_email_set_mailer (GearyComposedEmail* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_COMPOSED_EMAIL (self));
	old_value = geary_composed_email_get_mailer (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mailer);
		self->priv->_mailer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_MAILER_PROPERTY]);
	}
}

GearyEmail*
geary_composed_email_get_reply_to_email (GearyComposedEmail* self)
{
	GearyEmail* result;
	GearyEmail* _tmp0_;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	_tmp0_ = self->priv->_reply_to_email;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_composed_email_set_reply_to_email (GearyComposedEmail* self,
                                         GearyEmail* value)
{
	GearyEmail* old_value;
	g_return_if_fail (GEARY_IS_COMPOSED_EMAIL (self));
	old_value = geary_composed_email_get_reply_to_email (self);
	if (old_value != value) {
		GearyEmail* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_reply_to_email);
		self->priv->_reply_to_email = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_REPLY_TO_EMAIL_PROPERTY]);
	}
}

GeeSet*
geary_composed_email_get_attached_files (GearyComposedEmail* self)
{
	GeeSet* result;
	GeeSet* _tmp0_;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	_tmp0_ = self->priv->_attached_files;
	result = _tmp0_;
	return result;
}

static void
geary_composed_email_set_attached_files (GearyComposedEmail* self,
                                         GeeSet* value)
{
	GeeSet* old_value;
	g_return_if_fail (GEARY_IS_COMPOSED_EMAIL (self));
	old_value = geary_composed_email_get_attached_files (self);
	if (old_value != value) {
		GeeSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_attached_files);
		self->priv->_attached_files = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_ATTACHED_FILES_PROPERTY]);
	}
}

static guint
_geary_files_nullable_hash_gee_hash_data_func (gconstpointer v,
                                               gpointer self)
{
	guint result;
	result = geary_files_nullable_hash ((GFile*) v);
	return result;
}

static gboolean
_geary_files_nullable_equal_gee_equal_data_func (gconstpointer a,
                                                 gconstpointer b,
                                                 gpointer self)
{
	gboolean result;
	result = geary_files_nullable_equal ((GFile*) a, (GFile*) b);
	return result;
}

GeeMap*
geary_composed_email_get_inline_files (GearyComposedEmail* self)
{
	GeeMap* result;
	GeeMap* _tmp0_;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	_tmp0_ = self->priv->_inline_files;
	result = _tmp0_;
	return result;
}

static void
geary_composed_email_set_inline_files (GearyComposedEmail* self,
                                       GeeMap* value)
{
	GeeMap* old_value;
	g_return_if_fail (GEARY_IS_COMPOSED_EMAIL (self));
	old_value = geary_composed_email_get_inline_files (self);
	if (old_value != value) {
		GeeMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_inline_files);
		self->priv->_inline_files = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_INLINE_FILES_PROPERTY]);
	}
}

GeeMap*
geary_composed_email_get_cid_files (GearyComposedEmail* self)
{
	GeeMap* result;
	GeeMap* _tmp0_;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	_tmp0_ = self->priv->_cid_files;
	result = _tmp0_;
	return result;
}

static void
geary_composed_email_set_cid_files (GearyComposedEmail* self,
                                    GeeMap* value)
{
	GeeMap* old_value;
	g_return_if_fail (GEARY_IS_COMPOSED_EMAIL (self));
	old_value = geary_composed_email_get_cid_files (self);
	if (old_value != value) {
		GeeMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cid_files);
		self->priv->_cid_files = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_CID_FILES_PROPERTY]);
	}
}

const gchar*
geary_composed_email_get_img_src_prefix (GearyComposedEmail* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	_tmp0_ = self->priv->_img_src_prefix;
	result = _tmp0_;
	return result;
}

void
geary_composed_email_set_img_src_prefix (GearyComposedEmail* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_COMPOSED_EMAIL (self));
	old_value = geary_composed_email_get_img_src_prefix (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_img_src_prefix);
		self->priv->_img_src_prefix = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_IMG_SRC_PREFIX_PROPERTY]);
	}
}

GearyComposedEmail*
geary_composed_email_construct (GType object_type,
                                GDateTime* date,
                                GearyRFC822MailboxAddresses* from)
{
	GearyComposedEmail * self = NULL;
	GearyComposedEmail* _tmp0_;
	GearyComposedEmail* _tmp1_;
	GearyRFC822MailboxAddresses* _tmp2_;
	g_return_val_if_fail (date != NULL, NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (from), NULL);
	self = (GearyComposedEmail*) geary_base_object_construct (object_type);
	_tmp0_ = geary_composed_email_set_date (self, date);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	_tmp2_ = _g_object_ref0 (from);
	_g_object_unref0 (self->priv->_from);
	self->priv->_from = _tmp2_;
	return self;
}

GearyComposedEmail*
geary_composed_email_new (GDateTime* date,
                          GearyRFC822MailboxAddresses* from)
{
	return geary_composed_email_construct (GEARY_TYPE_COMPOSED_EMAIL, date, from);
}

GearyComposedEmail*
geary_composed_email_set_date (GearyComposedEmail* self,
                               GDateTime* date)
{
	GearyRFC822Date* _tmp0_;
	GearyComposedEmail* _tmp1_;
	GearyComposedEmail* result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	g_return_val_if_fail (date != NULL, NULL);
	_tmp0_ = geary_rf_c822_date_new (date);
	_g_object_unref0 (self->priv->_date);
	self->priv->_date = _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

GearyComposedEmail*
geary_composed_email_set_sender (GearyComposedEmail* self,
                                 GearyRFC822MailboxAddress* sender)
{
	GearyRFC822MailboxAddress* _tmp0_;
	GearyComposedEmail* _tmp1_;
	GearyComposedEmail* result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	g_return_val_if_fail ((sender == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESS (sender), NULL);
	_tmp0_ = _g_object_ref0 (sender);
	_g_object_unref0 (self->priv->_sender);
	self->priv->_sender = _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

GearyComposedEmail*
geary_composed_email_set_to (GearyComposedEmail* self,
                             GearyRFC822MailboxAddresses* recipients)
{
	gpointer _tmp0_;
	GearyComposedEmail* _tmp1_;
	GearyComposedEmail* result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	g_return_val_if_fail ((recipients == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESSES (recipients), NULL);
	_tmp0_ = geary_composed_email_empty_to_null (self, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, recipients);
	_g_object_unref0 (self->priv->_to);
	self->priv->_to = (GearyRFC822MailboxAddresses*) _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

GearyComposedEmail*
geary_composed_email_set_cc (GearyComposedEmail* self,
                             GearyRFC822MailboxAddresses* recipients)
{
	gpointer _tmp0_;
	GearyComposedEmail* _tmp1_;
	GearyComposedEmail* result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	g_return_val_if_fail ((recipients == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESSES (recipients), NULL);
	_tmp0_ = geary_composed_email_empty_to_null (self, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, recipients);
	_g_object_unref0 (self->priv->_cc);
	self->priv->_cc = (GearyRFC822MailboxAddresses*) _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

GearyComposedEmail*
geary_composed_email_set_bcc (GearyComposedEmail* self,
                              GearyRFC822MailboxAddresses* recipients)
{
	gpointer _tmp0_;
	GearyComposedEmail* _tmp1_;
	GearyComposedEmail* result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	g_return_val_if_fail ((recipients == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESSES (recipients), NULL);
	_tmp0_ = geary_composed_email_empty_to_null (self, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, recipients);
	_g_object_unref0 (self->priv->_bcc);
	self->priv->_bcc = (GearyRFC822MailboxAddresses*) _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

GearyComposedEmail*
geary_composed_email_set_reply_to (GearyComposedEmail* self,
                                   GearyRFC822MailboxAddresses* recipients)
{
	gpointer _tmp0_;
	GearyComposedEmail* _tmp1_;
	GearyComposedEmail* result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	g_return_val_if_fail ((recipients == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESSES (recipients), NULL);
	_tmp0_ = geary_composed_email_empty_to_null (self, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, recipients);
	_g_object_unref0 (self->priv->_reply_to);
	self->priv->_reply_to = (GearyRFC822MailboxAddresses*) _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

GearyComposedEmail*
geary_composed_email_set_message_id (GearyComposedEmail* self,
                                     GearyRFC822MessageID* id)
{
	GearyRFC822MessageID* _tmp0_;
	GearyComposedEmail* _tmp1_;
	GearyComposedEmail* result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	g_return_val_if_fail ((id == NULL) || GEARY_RF_C822_IS_MESSAGE_ID (id), NULL);
	_tmp0_ = _g_object_ref0 (id);
	_g_object_unref0 (self->priv->_message_id);
	self->priv->_message_id = _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

GearyComposedEmail*
geary_composed_email_set_in_reply_to (GearyComposedEmail* self,
                                      GearyRFC822MessageIDList* messages)
{
	gpointer _tmp0_;
	GearyComposedEmail* _tmp1_;
	GearyComposedEmail* result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	g_return_val_if_fail ((messages == NULL) || GEARY_RF_C822_IS_MESSAGE_ID_LIST (messages), NULL);
	_tmp0_ = geary_composed_email_empty_to_null (self, GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, messages);
	_g_object_unref0 (self->priv->_in_reply_to);
	self->priv->_in_reply_to = (GearyRFC822MessageIDList*) _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

GearyComposedEmail*
geary_composed_email_set_references (GearyComposedEmail* self,
                                     GearyRFC822MessageIDList* messages)
{
	gpointer _tmp0_;
	GearyComposedEmail* _tmp1_;
	GearyComposedEmail* result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	g_return_val_if_fail ((messages == NULL) || GEARY_RF_C822_IS_MESSAGE_ID_LIST (messages), NULL);
	_tmp0_ = geary_composed_email_empty_to_null (self, GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, messages);
	_g_object_unref0 (self->priv->_references);
	self->priv->_references = (GearyRFC822MessageIDList*) _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

GearyComposedEmail*
geary_composed_email_set_subject (GearyComposedEmail* self,
                                  const gchar* subject)
{
	GearyRFC822Subject* _tmp0_ = NULL;
	GearyRFC822Subject* _tmp2_;
	GearyComposedEmail* _tmp3_;
	GearyComposedEmail* result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	if (geary_string_is_empty_or_whitespace (subject)) {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	} else {
		GearyRFC822Subject* _tmp1_;
		_tmp1_ = geary_rf_c822_subject_new (subject);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_subject);
	self->priv->_subject = _tmp2_;
	_tmp3_ = _g_object_ref0 (self);
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Determines if an IMG SRC value is present in the HTML part.
     *
     * Returns true if `value` is present as an IMG SRC value.
     */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
geary_composed_email_contains_inline_img_src (GearyComposedEmail* self,
                                              const gchar* value)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = self->priv->_body_html;
	_tmp1_ = g_strdup_printf (GEARY_COMPOSED_EMAIL_IMG_SRC_TEMPLATE, value);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_contains (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

/**
     * Replaces matching IMG SRC values in the HTML part.
     *
     * Will also remove the random prefix set by the composer for
     * security reasons.
     *
     * Returns true if `orig` has been replaced by `replacement`.
     */
static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gboolean
geary_composed_email_replace_inline_img_src (GearyComposedEmail* self,
                                             const gchar* orig,
                                             const gchar* replacement)
{
	gint index = 0;
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), FALSE);
	g_return_val_if_fail (orig != NULL, FALSE);
	g_return_val_if_fail (replacement != NULL, FALSE);
	index = -1;
	_tmp0_ = self->priv->_body_html;
	if (_tmp0_ != NULL) {
		gchar* prefixed_orig = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp1_ = self->priv->_img_src_prefix;
		_tmp2_ = g_strconcat (_tmp1_, orig, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf (GEARY_COMPOSED_EMAIL_IMG_SRC_TEMPLATE, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		prefixed_orig = _tmp5_;
		_tmp6_ = self->priv->_body_html;
		_tmp7_ = prefixed_orig;
		index = string_index_of (_tmp6_, _tmp7_, 0);
		if (index != -1) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp8_ = self->priv->_body_html;
			_tmp9_ = string_substring (_tmp8_, (glong) 0, (glong) index);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup_printf (GEARY_COMPOSED_EMAIL_IMG_SRC_TEMPLATE, replacement);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat (_tmp10_, _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_body_html;
			_tmp16_ = prefixed_orig;
			_tmp17_ = strlen (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = string_substring (_tmp15_, (glong) (index + _tmp18_), (glong) -1);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp14_, _tmp20_, NULL);
			_tmp22_ = _tmp21_;
			geary_composed_email_set_body_html (self, _tmp22_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
		}
		_g_free0 (prefixed_orig);
	}
	result = index != -1;
	return result;
}

static gpointer
geary_composed_email_empty_to_null (GearyComposedEmail* self,
                                    GType t_type,
                                    GBoxedCopyFunc t_dup_func,
                                    GDestroyNotify t_destroy_func,
                                    gconstpointer list)
{
	gpointer ret = NULL;
	gpointer _tmp0_;
	GearyRFC822MailboxAddresses* addresses = NULL;
	GearyRFC822MailboxAddresses* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GearyRFC822MailboxAddresses* _tmp3_;
	gpointer result;
	g_return_val_if_fail (GEARY_IS_COMPOSED_EMAIL (self), NULL);
	_tmp0_ = ((list != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) list) : ((gpointer) list);
	ret = _tmp0_;
	_tmp1_ = _g_object_ref0 (GEARY_RF_C822_IS_MAILBOX_ADDRESSES (list) ? ((GearyRFC822MailboxAddresses*) list) : NULL);
	addresses = _tmp1_;
	_tmp3_ = addresses;
	if (_tmp3_ != NULL) {
		GearyRFC822MailboxAddresses* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = addresses;
		_tmp5_ = geary_rf_c822_mailbox_addresses_get_size (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		((ret == NULL) || (t_destroy_func == NULL)) ? NULL : (ret = (t_destroy_func (ret), NULL));
		ret = NULL;
	} else {
		GearyRFC822MessageIDList* ids = NULL;
		GearyRFC822MessageIDList* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GearyRFC822MessageIDList* _tmp9_;
		_tmp7_ = _g_object_ref0 (GEARY_RF_C822_IS_MESSAGE_ID_LIST (list) ? ((GearyRFC822MessageIDList*) list) : NULL);
		ids = _tmp7_;
		_tmp9_ = ids;
		if (_tmp9_ != NULL) {
			GearyRFC822MessageIDList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp10_ = ids;
			_tmp11_ = geary_rf_c822_message_id_list_get_size (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp8_ = _tmp12_ == 0;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			((ret == NULL) || (t_destroy_func == NULL)) ? NULL : (ret = (t_destroy_func (ret), NULL));
			ret = NULL;
		}
		_g_object_unref0 (ids);
	}
	result = ret;
	_g_object_unref0 (addresses);
	return result;
}

static void
geary_composed_email_class_init (GearyComposedEmailClass * klass,
                                 gpointer klass_data)
{
	geary_composed_email_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyComposedEmail_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_composed_email_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_composed_email_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_composed_email_finalize;
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_FROM_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_FROM_PROPERTY] = g_param_spec_object ("from", "from", "from", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_SENDER_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_SENDER_PROPERTY] = g_param_spec_object ("sender", "sender", "sender", GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_REPLY_TO_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_REPLY_TO_PROPERTY] = g_param_spec_object ("reply-to", "reply-to", "reply-to", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_TO_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_TO_PROPERTY] = g_param_spec_object ("to", "to", "to", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_CC_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_CC_PROPERTY] = g_param_spec_object ("cc", "cc", "cc", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_BCC_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_BCC_PROPERTY] = g_param_spec_object ("bcc", "bcc", "bcc", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_MESSAGE_ID_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_MESSAGE_ID_PROPERTY] = g_param_spec_object ("message-id", "message-id", "message-id", GEARY_RF_C822_TYPE_MESSAGE_ID, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_IN_REPLY_TO_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_IN_REPLY_TO_PROPERTY] = g_param_spec_object ("in-reply-to", "in-reply-to", "in-reply-to", GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_REFERENCES_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_REFERENCES_PROPERTY] = g_param_spec_object ("references", "references", "references", GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_SUBJECT_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_SUBJECT_PROPERTY] = g_param_spec_object ("subject", "subject", "subject", GEARY_RF_C822_TYPE_SUBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_DATE_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_DATE_PROPERTY] = g_param_spec_object ("date", "date", "date", GEARY_RF_C822_TYPE_DATE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_BODY_TEXT_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_BODY_TEXT_PROPERTY] = g_param_spec_string ("body-text", "body-text", "body-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_BODY_HTML_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_BODY_HTML_PROPERTY] = g_param_spec_string ("body-html", "body-html", "body-html", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_MAILER_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_MAILER_PROPERTY] = g_param_spec_string ("mailer", "mailer", "mailer", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_REPLY_TO_EMAIL_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_REPLY_TO_EMAIL_PROPERTY] = g_param_spec_object ("reply-to-email", "reply-to-email", "reply-to-email", GEARY_TYPE_EMAIL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_ATTACHED_FILES_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_ATTACHED_FILES_PROPERTY] = g_param_spec_object ("attached-files", "attached-files", "attached-files", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_INLINE_FILES_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_INLINE_FILES_PROPERTY] = g_param_spec_object ("inline-files", "inline-files", "inline-files", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_CID_FILES_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_CID_FILES_PROPERTY] = g_param_spec_object ("cid-files", "cid-files", "cid-files", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_COMPOSED_EMAIL_IMG_SRC_PREFIX_PROPERTY, geary_composed_email_properties[GEARY_COMPOSED_EMAIL_IMG_SRC_PREFIX_PROPERTY] = g_param_spec_string ("img-src-prefix", "img-src-prefix", "img-src-prefix", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
geary_composed_email_geary_email_header_set_interface_init (GearyEmailHeaderSetIface * iface,
                                                            gpointer iface_data)
{
	geary_composed_email_geary_email_header_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_from = geary_composed_email_real_get_from;
	iface->get_sender = geary_composed_email_real_get_sender;
	iface->get_reply_to = geary_composed_email_real_get_reply_to;
	iface->get_to = geary_composed_email_real_get_to;
	iface->get_cc = geary_composed_email_real_get_cc;
	iface->get_bcc = geary_composed_email_real_get_bcc;
	iface->get_message_id = geary_composed_email_real_get_message_id;
	iface->get_in_reply_to = geary_composed_email_real_get_in_reply_to;
	iface->get_references = geary_composed_email_real_get_references;
	iface->get_subject = geary_composed_email_real_get_subject;
	iface->get_date = geary_composed_email_real_get_date;
}

static void
geary_composed_email_instance_init (GearyComposedEmail * self,
                                    gpointer klass)
{
	GeeHashSet* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gchar* _tmp3_;
	self->priv = geary_composed_email_get_instance_private (self);
	self->priv->_from = NULL;
	self->priv->_sender = NULL;
	self->priv->_reply_to = NULL;
	self->priv->_to = NULL;
	self->priv->_cc = NULL;
	self->priv->_bcc = NULL;
	self->priv->_message_id = NULL;
	self->priv->_in_reply_to = NULL;
	self->priv->_references = NULL;
	self->priv->_subject = NULL;
	self->priv->_date = NULL;
	self->priv->_body_text = NULL;
	self->priv->_body_html = NULL;
	self->priv->_mailer = NULL;
	self->priv->_reply_to_email = NULL;
	_tmp0_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _geary_files_nullable_hash_gee_hash_data_func, NULL, NULL, _geary_files_nullable_equal_gee_equal_data_func, NULL, NULL);
	self->priv->_attached_files = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEARY_MEMORY_TYPE_BUFFER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_inline_files = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MAP, GeeMap);
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEARY_MEMORY_TYPE_BUFFER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_cid_files = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_MAP, GeeMap);
	_tmp3_ = g_strdup ("");
	self->priv->_img_src_prefix = _tmp3_;
}

static void
geary_composed_email_finalize (GObject * obj)
{
	GearyComposedEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	_g_object_unref0 (self->priv->_from);
	_g_object_unref0 (self->priv->_sender);
	_g_object_unref0 (self->priv->_reply_to);
	_g_object_unref0 (self->priv->_to);
	_g_object_unref0 (self->priv->_cc);
	_g_object_unref0 (self->priv->_bcc);
	_g_object_unref0 (self->priv->_message_id);
	_g_object_unref0 (self->priv->_in_reply_to);
	_g_object_unref0 (self->priv->_references);
	_g_object_unref0 (self->priv->_subject);
	_g_object_unref0 (self->priv->_date);
	_g_free0 (self->priv->_body_text);
	_g_free0 (self->priv->_body_html);
	_g_free0 (self->priv->_mailer);
	_g_object_unref0 (self->priv->_reply_to_email);
	_g_object_unref0 (self->priv->_attached_files);
	_g_object_unref0 (self->priv->_inline_files);
	_g_object_unref0 (self->priv->_cid_files);
	_g_free0 (self->priv->_img_src_prefix);
	G_OBJECT_CLASS (geary_composed_email_parent_class)->finalize (obj);
}

/**
 * Encapsulates a message created by the user in the composer.
 */
 G_GNUC_NO_INLINE static GType
geary_composed_email_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyComposedEmailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_composed_email_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyComposedEmail), 0, (GInstanceInitFunc) geary_composed_email_instance_init, NULL };
	static const GInterfaceInfo geary_email_header_set_info = { (GInterfaceInitFunc) geary_composed_email_geary_email_header_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_composed_email_type_id;
	geary_composed_email_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyComposedEmail", &g_define_type_info, 0);
	g_type_add_interface_static (geary_composed_email_type_id, GEARY_TYPE_EMAIL_HEADER_SET, &geary_email_header_set_info);
	GearyComposedEmail_private_offset = g_type_add_instance_private (geary_composed_email_type_id, sizeof (GearyComposedEmailPrivate));
	return geary_composed_email_type_id;
}

GType
geary_composed_email_get_type (void)
{
	static gsize geary_composed_email_type_id__once = 0;
	if (g_once_init_enter (&geary_composed_email_type_id__once)) {
		GType geary_composed_email_type_id;
		geary_composed_email_type_id = geary_composed_email_get_type_once ();
		g_once_init_leave (&geary_composed_email_type_id__once, geary_composed_email_type_id);
	}
	return geary_composed_email_type_id__once;
}

static void
_vala_geary_composed_email_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GearyComposedEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	switch (property_id) {
		case GEARY_COMPOSED_EMAIL_FROM_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_COMPOSED_EMAIL_SENDER_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_COMPOSED_EMAIL_REPLY_TO_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_reply_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_COMPOSED_EMAIL_TO_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_COMPOSED_EMAIL_CC_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_COMPOSED_EMAIL_BCC_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_COMPOSED_EMAIL_MESSAGE_ID_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_message_id (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_COMPOSED_EMAIL_IN_REPLY_TO_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_COMPOSED_EMAIL_REFERENCES_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_COMPOSED_EMAIL_SUBJECT_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_COMPOSED_EMAIL_DATE_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_COMPOSED_EMAIL_BODY_TEXT_PROPERTY:
		g_value_set_string (value, geary_composed_email_get_body_text (self));
		break;
		case GEARY_COMPOSED_EMAIL_BODY_HTML_PROPERTY:
		g_value_set_string (value, geary_composed_email_get_body_html (self));
		break;
		case GEARY_COMPOSED_EMAIL_MAILER_PROPERTY:
		g_value_set_string (value, geary_composed_email_get_mailer (self));
		break;
		case GEARY_COMPOSED_EMAIL_REPLY_TO_EMAIL_PROPERTY:
		g_value_set_object (value, geary_composed_email_get_reply_to_email (self));
		break;
		case GEARY_COMPOSED_EMAIL_ATTACHED_FILES_PROPERTY:
		g_value_set_object (value, geary_composed_email_get_attached_files (self));
		break;
		case GEARY_COMPOSED_EMAIL_INLINE_FILES_PROPERTY:
		g_value_set_object (value, geary_composed_email_get_inline_files (self));
		break;
		case GEARY_COMPOSED_EMAIL_CID_FILES_PROPERTY:
		g_value_set_object (value, geary_composed_email_get_cid_files (self));
		break;
		case GEARY_COMPOSED_EMAIL_IMG_SRC_PREFIX_PROPERTY:
		g_value_set_string (value, geary_composed_email_get_img_src_prefix (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_composed_email_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GearyComposedEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_COMPOSED_EMAIL, GearyComposedEmail);
	switch (property_id) {
		case GEARY_COMPOSED_EMAIL_BODY_TEXT_PROPERTY:
		geary_composed_email_set_body_text (self, g_value_get_string (value));
		break;
		case GEARY_COMPOSED_EMAIL_BODY_HTML_PROPERTY:
		geary_composed_email_set_body_html (self, g_value_get_string (value));
		break;
		case GEARY_COMPOSED_EMAIL_MAILER_PROPERTY:
		geary_composed_email_set_mailer (self, g_value_get_string (value));
		break;
		case GEARY_COMPOSED_EMAIL_REPLY_TO_EMAIL_PROPERTY:
		geary_composed_email_set_reply_to_email (self, g_value_get_object (value));
		break;
		case GEARY_COMPOSED_EMAIL_ATTACHED_FILES_PROPERTY:
		geary_composed_email_set_attached_files (self, g_value_get_object (value));
		break;
		case GEARY_COMPOSED_EMAIL_INLINE_FILES_PROPERTY:
		geary_composed_email_set_inline_files (self, g_value_get_object (value));
		break;
		case GEARY_COMPOSED_EMAIL_CID_FILES_PROPERTY:
		geary_composed_email_set_cid_files (self, g_value_get_object (value));
		break;
		case GEARY_COMPOSED_EMAIL_IMG_SRC_PREFIX_PROPERTY:
		geary_composed_email_set_img_src_prefix (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

