/* WorkspaceClone.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WorkspaceClone.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include <meta/meta-background-group.h>
#include "gala.h"
#include <glib-object.h>
#include <cogl/cogl.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <clutter/clutter.h>
#include <meta/display.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <meta/workspace.h>
#include <mtk/mtk.h>
#include <meta/common.h>
#include <meta/window.h>
#include <gtk/gtk.h>
#include <meta/meta-monitor-manager.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#define GALA_WORKSPACE_CLONE_BOTTOM_OFFSET 100
#define GALA_WORKSPACE_CLONE_TOP_OFFSET 20
#define GALA_WORKSPACE_CLONE_HOVER_ACTIVATE_DELAY 400
#define GALA_WORKSPACE_ROW_WORKSPACE_GAP 24
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;
typedef struct _GalaBackgroundManagerPrivate GalaBackgroundManagerPrivate;

#define GALA_TYPE_FRAMED_BACKGROUND (gala_framed_background_get_type ())
#define GALA_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground))
#define GALA_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))
#define GALA_IS_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_IS_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_FRAMED_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))

typedef struct _GalaFramedBackground GalaFramedBackground;
typedef struct _GalaFramedBackgroundClass GalaFramedBackgroundClass;
typedef struct _GalaFramedBackgroundPrivate GalaFramedBackgroundPrivate;
enum  {
	GALA_FRAMED_BACKGROUND_0_PROPERTY,
	GALA_FRAMED_BACKGROUND_NUM_PROPERTIES
};
static GParamSpec* gala_framed_background_properties[GALA_FRAMED_BACKGROUND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GALA_TYPE_WORKSPACE_CLONE (gala_workspace_clone_get_type ())
#define GALA_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone))
#define GALA_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))
#define GALA_IS_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_IS_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_WORKSPACE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))

typedef struct _GalaWorkspaceClone GalaWorkspaceClone;
typedef struct _GalaWorkspaceCloneClass GalaWorkspaceCloneClass;
typedef struct _GalaWorkspaceClonePrivate GalaWorkspaceClonePrivate;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;

#define GALA_TYPE_WINDOW_LIST_MODEL (gala_window_list_model_get_type ())
#define GALA_WINDOW_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModel))
#define GALA_WINDOW_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModelClass))
#define GALA_IS_WINDOW_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_LIST_MODEL))
#define GALA_IS_WINDOW_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_LIST_MODEL))
#define GALA_WINDOW_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModelClass))

typedef struct _GalaWindowListModel GalaWindowListModel;
typedef struct _GalaWindowListModelClass GalaWindowListModelClass;
enum  {
	GALA_WORKSPACE_CLONE_0_PROPERTY,
	GALA_WORKSPACE_CLONE_WM_PROPERTY,
	GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY,
	GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY,
	GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY,
	GALA_WORKSPACE_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_NUM_PROPERTIES];
typedef enum  {
	GALA_WINDOW_LIST_MODEL_SORT_MODE_NONE,
	GALA_WINDOW_LIST_MODEL_SORT_MODE_STACKING
} GalaWindowListModelSortMode;

#define GALA_WINDOW_LIST_MODEL_TYPE_SORT_MODE (gala_window_list_model_sort_mode_get_type ())
enum  {
	GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL,
	GALA_WORKSPACE_CLONE_NUM_SIGNALS
};
static guint gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_NUM_SIGNALS] = {0};

struct _GalaBackgroundManager {
	MetaBackgroundGroup parent_instance;
	GalaBackgroundManagerPrivate * priv;
};

struct _GalaBackgroundManagerClass {
	MetaBackgroundGroupClass parent_class;
};

struct _GalaFramedBackground {
	GalaBackgroundManager parent_instance;
	GalaFramedBackgroundPrivate * priv;
};

struct _GalaFramedBackgroundClass {
	GalaBackgroundManagerClass parent_class;
};

struct _GalaFramedBackgroundPrivate {
	CoglPipeline* pipeline;
	cairo_surface_t* cached_surface;
	cairo_t* cached_context;
	CoglTexture2D* cached_texture;
	gint last_width;
	gint last_height;
};

struct _GalaWorkspaceClone {
	GalaActorTarget parent_instance;
	GalaWorkspaceClonePrivate * priv;
};

struct _GalaWorkspaceCloneClass {
	GalaActorTargetClass parent_class;
};

struct _GalaWorkspaceClonePrivate {
	GalaWindowManager* _wm;
	MetaWorkspace* _workspace;
	gfloat _monitor_scale;
	GalaWindowCloneContainer* _window_container;
	GalaBackgroundManager* background;
	GalaWindowListModel* windows;
	guint hover_activate_timeout;
};

static gint GalaFramedBackground_private_offset;
static gpointer gala_framed_background_parent_class = NULL;
static gint GalaWorkspaceClone_private_offset;
static gpointer gala_workspace_clone_parent_class = NULL;

VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
 G_GNUC_INTERNAL GType gala_framed_background_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaFramedBackground, g_object_unref)
 G_GNUC_INTERNAL GalaFramedBackground* gala_framed_background_new (MetaDisplay* display);
 G_GNUC_INTERNAL GalaFramedBackground* gala_framed_background_construct (GType object_type,
                                                        MetaDisplay* display);
static void gala_framed_background_real_paint (ClutterActor* base,
                                        ClutterPaintContext* context);
static GObject * gala_framed_background_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN MetaDisplay* gala_background_manager_get_display (GalaBackgroundManager* self);
static void gala_framed_background_finalize (GObject * obj);
static GType gala_framed_background_get_type_once (void);
VALA_EXTERN GType gala_workspace_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceClone, g_object_unref)
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
VALA_EXTERN GType gala_window_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowListModel, g_object_unref)
VALA_EXTERN GalaWindowCloneContainer* gala_workspace_clone_get_window_container (GalaWorkspaceClone* self);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_new (GalaWindowManager* wm,
                                              MetaWorkspace* workspace,
                                              gfloat monitor_scale);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_construct (GType object_type,
                                                    GalaWindowManager* wm,
                                                    MetaWorkspace* workspace,
                                                    gfloat monitor_scale);
VALA_EXTERN void gala_workspace_clone_update_size (GalaWorkspaceClone* self,
                                       MtkRectangle* monitor_geometry);
VALA_EXTERN void gala_background_manager_set_size (GalaBackgroundManager* self,
                                       gfloat width,
                                       gfloat height);
static void gala_workspace_clone_update_targets (GalaWorkspaceClone* self);
VALA_EXTERN MetaWorkspace* gala_workspace_clone_get_workspace (GalaWorkspaceClone* self);
VALA_EXTERN void gala_window_list_model_set_monitor_filter (GalaWindowListModel* self,
                                                gint value);
VALA_EXTERN gfloat gala_workspace_clone_get_monitor_scale (GalaWorkspaceClone* self);
VALA_EXTERN void gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                                  gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                                    gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                                   gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                     gint value);
static void gala_workspace_clone_activate (GalaWorkspaceClone* self,
                                    gboolean close_view);
VALA_EXTERN GalaWindowManager* gala_workspace_clone_get_wm (GalaWorkspaceClone* self);
static void gala_workspace_clone_set_wm (GalaWorkspaceClone* self,
                                  GalaWindowManager* value);
static void gala_workspace_clone_set_workspace (GalaWorkspaceClone* self,
                                         MetaWorkspace* value);
VALA_EXTERN void gala_workspace_clone_set_monitor_scale (GalaWorkspaceClone* self,
                                             gfloat value);
static void gala_workspace_clone_set_window_container (GalaWorkspaceClone* self,
                                                GalaWindowCloneContainer* value);
static GObject * gala_workspace_clone_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _gala_workspace_clone___lambda60_ (GalaWorkspaceClone* self);
static void __gala_workspace_clone___lambda60__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                      ClutterActor* actor,
                                                                      gpointer self);
VALA_EXTERN GType gala_window_list_model_sort_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaWindowListModel* gala_window_list_model_new (MetaDisplay* display,
                                                 GalaWindowListModelSortMode sort_mode,
                                                 gboolean normal_filter,
                                                 gint monitor_filter,
                                                 MetaWorkspace* workspace_filter,
                                                 GtkFilter* custom_filter);
VALA_EXTERN GalaWindowListModel* gala_window_list_model_construct (GType object_type,
                                                       MetaDisplay* display,
                                                       GalaWindowListModelSortMode sort_mode,
                                                       gboolean normal_filter,
                                                       gint monitor_filter,
                                                       MetaWorkspace* workspace_filter,
                                                       GtkFilter* custom_filter);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           GalaWindowListModel* windows,
                                                           gfloat monitor_scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 GalaWindowListModel* windows,
                                                                 gfloat monitor_scale,
                                                                 gboolean overview_mode);
static void _gala_workspace_clone___lambda61_ (GalaWorkspaceClone* self,
                                        MetaWindow* window);
static void __gala_workspace_clone___lambda61__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                     MetaWindow* window,
                                                                                     gpointer self);
static void _gala_workspace_clone___lambda62_ (GalaWorkspaceClone* self);
static void __gala_workspace_clone___lambda62__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                                                     gpointer self);
static void _gala_workspace_clone___lambda63_ (GalaWorkspaceClone* self,
                                        ClutterActor* target,
                                        gboolean hovered);
static gboolean ___lambda64_ (GalaWorkspaceClone* self);
static gboolean ____lambda64__gsource_func (gpointer self);
static void __gala_workspace_clone___lambda63__gala_drag_drop_action_crossed (GalaDragDropAction* _sender,
                                                                       ClutterActor* target,
                                                                       gboolean hovered,
                                                                       gpointer self);
static void _gala_workspace_clone_update_targets_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                 gpointer self);
static void _gala_workspace_clone_update_targets_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void gala_workspace_clone_finalize (GObject * obj);
static GType gala_workspace_clone_get_type_once (void);
static void _vala_gala_workspace_clone_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_workspace_clone_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
gala_framed_background_get_instance_private (GalaFramedBackground* self)
{
	return G_STRUCT_MEMBER_P (self, GalaFramedBackground_private_offset);
}

 G_GNUC_INTERNAL GalaFramedBackground*
gala_framed_background_construct (GType object_type,
                                  MetaDisplay* display)
{
	GalaFramedBackground * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaFramedBackground*) g_object_new (object_type, "display", display, "monitor-index", meta_display_get_primary_monitor (display), "control-position", FALSE, "rounded-corners", TRUE, NULL);
	return self;
}

 G_GNUC_INTERNAL GalaFramedBackground*
gala_framed_background_new (MetaDisplay* display)
{
	return gala_framed_background_construct (GALA_TYPE_FRAMED_BACKGROUND, display);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_framed_background_real_paint (ClutterActor* base,
                                   ClutterPaintContext* context)
{
	GalaFramedBackground * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp18_;
	cairo_surface_t* _tmp19_;
	cairo_t* ctx = NULL;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	gfloat _tmp24_;
	gfloat _tmp25_;
	gfloat _tmp26_;
	gfloat _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	CoglColor color = {0};
	CoglPipeline* _tmp49_;
	CoglColor _tmp50_;
	CoglFramebuffer* _tmp51_;
	CoglPipeline* _tmp52_;
	gfloat _tmp53_;
	gfloat _tmp54_;
	gfloat _tmp55_;
	gfloat _tmp56_;
	GError* _inner_error0_ = NULL;
	self = (GalaFramedBackground*) base;
	g_return_if_fail (context != NULL);
	CLUTTER_ACTOR_CLASS (gala_framed_background_parent_class)->paint ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager), context);
	_tmp2_ = self->priv->cached_surface;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		gfloat _tmp3_;
		gfloat _tmp4_;
		_tmp3_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp4_ = _tmp3_;
		_tmp1_ = self->priv->last_width != ((gint) _tmp4_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gfloat _tmp5_;
		gfloat _tmp6_;
		_tmp5_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp6_ = _tmp5_;
		_tmp0_ = self->priv->last_height != ((gint) _tmp6_);
	}
	if (_tmp0_) {
		gfloat _tmp7_;
		gfloat _tmp8_;
		gfloat _tmp9_;
		gfloat _tmp10_;
		cairo_surface_t* _tmp11_;
		cairo_surface_t* _tmp12_;
		cairo_t* _tmp13_;
		gfloat _tmp14_;
		gfloat _tmp15_;
		gfloat _tmp16_;
		gfloat _tmp17_;
		_g_object_unref0 (self->priv->cached_texture);
		self->priv->cached_texture = NULL;
		_tmp7_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) _tmp8_, (gint) _tmp10_);
		_cairo_surface_destroy0 (self->priv->cached_surface);
		self->priv->cached_surface = _tmp11_;
		_tmp12_ = self->priv->cached_surface;
		_tmp13_ = cairo_create (_tmp12_);
		_cairo_destroy0 (self->priv->cached_context);
		self->priv->cached_context = _tmp13_;
		_tmp14_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp15_ = _tmp14_;
		self->priv->last_width = (gint) _tmp15_;
		_tmp16_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp17_ = _tmp16_;
		self->priv->last_height = (gint) _tmp17_;
	}
	_tmp18_ = self->priv->cached_surface;
	_tmp19_ = _cairo_surface_reference0 (_tmp18_);
	surface = _tmp19_;
	_tmp20_ = self->priv->cached_context;
	_tmp21_ = _cairo_reference0 (_tmp20_);
	ctx = _tmp21_;
	_tmp22_ = ctx;
	cairo_set_source_rgba (_tmp22_, (gdouble) 255, (gdouble) 255, (gdouble) 255, (gdouble) 255);
	_tmp23_ = ctx;
	_tmp24_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp27_ = _tmp26_;
	gala_drawing_utilities_cairo_rounded_rectangle (_tmp23_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp25_, (gdouble) _tmp27_, (gdouble) 9);
	_tmp28_ = ctx;
	cairo_set_operator (_tmp28_, CAIRO_OPERATOR_SOURCE);
	_tmp29_ = ctx;
	cairo_stroke (_tmp29_);
	_tmp30_ = ctx;
	cairo_restore (_tmp30_);
	_tmp31_ = ctx;
	cairo_paint (_tmp31_);
	{
		CoglTexture2D* _tmp32_;
		_tmp32_ = self->priv->cached_texture;
		if (_tmp32_ == NULL) {
			CoglTexture2D* texture = NULL;
			CoglFramebuffer* _tmp33_;
			CoglContext* _tmp34_;
			gfloat _tmp35_;
			gfloat _tmp36_;
			gfloat _tmp37_;
			gfloat _tmp38_;
			cairo_surface_t* _tmp39_;
			cairo_surface_t* _tmp40_;
			guchar* _tmp41_;
			CoglTexture2D* _tmp42_;
			CoglPipeline* _tmp43_;
			CoglTexture2D* _tmp44_;
			CoglTexture2D* _tmp45_;
			CoglTexture2D* _tmp46_;
			_tmp33_ = clutter_paint_context_get_framebuffer (context);
			_tmp34_ = cogl_framebuffer_get_context (_tmp33_);
			_tmp35_ = clutter_actor_get_width ((ClutterActor*) self);
			_tmp36_ = _tmp35_;
			_tmp37_ = clutter_actor_get_height ((ClutterActor*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = surface;
			_tmp40_ = surface;
			_tmp41_ = cairo_image_surface_get_data (_tmp40_);
			_tmp42_ = (CoglTexture2D*) cogl_texture_2d_new_from_data (_tmp34_, (gint) _tmp36_, (gint) _tmp38_, COGL_PIXEL_FORMAT_BGRA_8888_PRE, cairo_image_surface_get_stride (_tmp39_), _tmp41_, &_inner_error0_);
			texture = _tmp42_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp43_ = self->priv->pipeline;
			_tmp44_ = texture;
			cogl_pipeline_set_layer_texture (_tmp43_, 0, (CoglTexture*) _tmp44_);
			_tmp45_ = texture;
			_tmp46_ = _g_object_ref0 (_tmp45_);
			_g_object_unref0 (self->priv->cached_texture);
			self->priv->cached_texture = _tmp46_;
			_g_object_unref0 (texture);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp47_;
		const gchar* _tmp48_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		g_critical ("WorkspaceClone.vala:75: FramedBackground: Couldn't create texture: %s", _tmp48_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cairo_destroy0 (ctx);
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	cogl_color_init_from_4f (&color, 1.0f, 1.0f, 1.0f, 25.0f / 255.0f);
	cogl_color_premultiply (&color);
	_tmp49_ = self->priv->pipeline;
	_tmp50_ = color;
	cogl_pipeline_set_color (_tmp49_, &_tmp50_);
	_tmp51_ = clutter_paint_context_get_framebuffer (context);
	_tmp52_ = self->priv->pipeline;
	_tmp53_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp56_ = _tmp55_;
	cogl_framebuffer_draw_rectangle (_tmp51_, _tmp52_, (gfloat) 0, (gfloat) 0, _tmp54_, _tmp56_);
	_cairo_destroy0 (ctx);
	_cairo_surface_destroy0 (surface);
}

static GObject *
gala_framed_background_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaFramedBackground * self;
	CoglContext* ctx = NULL;
	ClutterBackend* _tmp0_;
	CoglContext* _tmp1_;
	CoglContext* _tmp2_;
	CoglPipeline* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaDisplay* _tmp5_;
	MetaDisplay* _tmp6_;
	MetaDisplay* _tmp7_;
	GalaShadowEffect* _tmp8_;
	GalaShadowEffect* _tmp9_;
	parent_class = G_OBJECT_CLASS (gala_framed_background_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground);
	_tmp0_ = clutter_get_default_backend ();
	_tmp1_ = clutter_backend_get_cogl_context (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = ctx;
	_tmp3_ = cogl_pipeline_new (_tmp2_);
	_g_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp3_;
	_tmp4_ = gala_background_manager_get_display ((GalaBackgroundManager*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gala_background_manager_get_display ((GalaBackgroundManager*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = gala_shadow_effect_new ("workspace", meta_display_get_monitor_scale (_tmp5_, meta_display_get_primary_monitor (_tmp7_)));
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	return obj;
}

static void
gala_framed_background_class_init (GalaFramedBackgroundClass * klass,
                                   gpointer klass_data)
{
	gala_framed_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaFramedBackground_private_offset);
	((ClutterActorClass *) klass)->paint = (void (*) (ClutterActor*, ClutterPaintContext*)) gala_framed_background_real_paint;
	G_OBJECT_CLASS (klass)->constructor = gala_framed_background_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_framed_background_finalize;
}

static void
gala_framed_background_instance_init (GalaFramedBackground * self,
                                      gpointer klass)
{
	self->priv = gala_framed_background_get_instance_private (self);
}

static void
gala_framed_background_finalize (GObject * obj)
{
	GalaFramedBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground);
	_g_object_unref0 (self->priv->pipeline);
	_cairo_surface_destroy0 (self->priv->cached_surface);
	_cairo_destroy0 (self->priv->cached_context);
	_g_object_unref0 (self->priv->cached_texture);
	G_OBJECT_CLASS (gala_framed_background_parent_class)->finalize (obj);
}

/**
 * Utility class which adds a border and a shadow to a Background
 */
 G_GNUC_NO_INLINE static GType
gala_framed_background_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaFramedBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_framed_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaFramedBackground), 0, (GInstanceInitFunc) gala_framed_background_instance_init, NULL };
	GType gala_framed_background_type_id;
	gala_framed_background_type_id = g_type_register_static (GALA_TYPE_BACKGROUND_MANAGER, "GalaFramedBackground", &g_define_type_info, 0);
	GalaFramedBackground_private_offset = g_type_add_instance_private (gala_framed_background_type_id, sizeof (GalaFramedBackgroundPrivate));
	return gala_framed_background_type_id;
}

 G_GNUC_INTERNAL GType
gala_framed_background_get_type (void)
{
	static gsize gala_framed_background_type_id__once = 0;
	if (g_once_init_enter (&gala_framed_background_type_id__once)) {
		GType gala_framed_background_type_id;
		gala_framed_background_type_id = gala_framed_background_get_type_once ();
		g_once_init_leave (&gala_framed_background_type_id__once, gala_framed_background_type_id);
	}
	return gala_framed_background_type_id__once;
}

static inline gpointer
gala_workspace_clone_get_instance_private (GalaWorkspaceClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWorkspaceClone_private_offset);
}

GalaWorkspaceClone*
gala_workspace_clone_construct (GType object_type,
                                GalaWindowManager* wm,
                                MetaWorkspace* workspace,
                                gfloat monitor_scale)
{
	GalaWorkspaceClone * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (workspace != NULL, NULL);
	self = (GalaWorkspaceClone*) g_object_new (object_type, "wm", wm, "workspace", workspace, "monitor-scale", monitor_scale, NULL);
	return self;
}

GalaWorkspaceClone*
gala_workspace_clone_new (GalaWindowManager* wm,
                          MetaWorkspace* workspace,
                          gfloat monitor_scale)
{
	return gala_workspace_clone_construct (GALA_TYPE_WORKSPACE_CLONE, wm, workspace, monitor_scale);
}

void
gala_workspace_clone_update_size (GalaWorkspaceClone* self,
                                  MtkRectangle* monitor_geometry)
{
	gboolean _tmp0_ = FALSE;
	GalaWindowCloneContainer* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	MtkRectangle _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor_geometry != NULL);
	_tmp1_ = self->priv->_window_container;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = *monitor_geometry;
	if (_tmp3_ != ((gfloat) _tmp4_.width)) {
		_tmp0_ = TRUE;
	} else {
		GalaWindowCloneContainer* _tmp5_;
		gfloat _tmp6_;
		gfloat _tmp7_;
		MtkRectangle _tmp8_;
		_tmp5_ = self->priv->_window_container;
		_tmp6_ = clutter_actor_get_height ((ClutterActor*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = *monitor_geometry;
		_tmp0_ = _tmp7_ != ((gfloat) _tmp8_.height);
	}
	if (_tmp0_) {
		GalaWindowCloneContainer* _tmp9_;
		MtkRectangle _tmp10_;
		MtkRectangle _tmp11_;
		GalaBackgroundManager* _tmp12_;
		GalaWindowCloneContainer* _tmp13_;
		gfloat _tmp14_;
		gfloat _tmp15_;
		GalaWindowCloneContainer* _tmp16_;
		gfloat _tmp17_;
		gfloat _tmp18_;
		_tmp9_ = self->priv->_window_container;
		_tmp10_ = *monitor_geometry;
		_tmp11_ = *monitor_geometry;
		clutter_actor_set_size ((ClutterActor*) _tmp9_, (gfloat) _tmp10_.width, (gfloat) _tmp11_.height);
		_tmp12_ = self->priv->background;
		_tmp13_ = self->priv->_window_container;
		_tmp14_ = clutter_actor_get_width ((ClutterActor*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->_window_container;
		_tmp17_ = clutter_actor_get_height ((ClutterActor*) _tmp16_);
		_tmp18_ = _tmp17_;
		gala_background_manager_set_size (_tmp12_, _tmp15_, _tmp18_);
	}
}

static void
gala_workspace_clone_update_targets (GalaWorkspaceClone* self)
{
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	gint primary = 0;
	GalaWindowListModel* _tmp2_;
	MtkRectangle monitor = {0};
	MtkRectangle _tmp3_ = {0};
	gfloat scale = 0.0F;
	MtkRectangle _tmp4_;
	gfloat _tmp5_;
	MtkRectangle _tmp6_;
	gfloat pivot_y = 0.0F;
	gfloat _tmp7_;
	MtkRectangle _tmp8_;
	MtkRectangle _tmp9_;
	GalaBackgroundManager* _tmp10_;
	gint initial_width = 0;
	MtkRectangle _tmp11_;
	gfloat target_width = 0.0F;
	MtkRectangle _tmp12_;
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GalaPropertyTarget* _tmp15_;
	GalaPropertyTarget* _tmp16_;
	GalaBackgroundManager* _tmp17_;
	GValue _tmp18_ = {0};
	GValue _tmp19_ = {0};
	GalaPropertyTarget* _tmp20_;
	GalaPropertyTarget* _tmp21_;
	GalaBackgroundManager* _tmp22_;
	GValue _tmp23_ = {0};
	GValue _tmp24_ = {0};
	GalaPropertyTarget* _tmp25_;
	GalaPropertyTarget* _tmp26_;
	GalaWindowCloneContainer* _tmp27_;
	gfloat _tmp28_;
	GalaWindowCloneContainer* _tmp29_;
	GalaWindowCloneContainer* _tmp30_;
	MtkRectangle _tmp31_;
	MtkRectangle _tmp32_;
	GalaWindowCloneContainer* _tmp33_;
	gfloat _tmp34_;
	g_return_if_fail (self != NULL);
	gala_actor_target_remove_all_targets ((GalaActorTarget*) self);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	display = _tmp1_;
	primary = meta_display_get_primary_monitor (display);
	_tmp2_ = self->priv->windows;
	gala_window_list_model_set_monitor_filter (_tmp2_, primary);
	meta_display_get_monitor_geometry (display, primary, &_tmp3_);
	monitor = _tmp3_;
	_tmp4_ = monitor;
	_tmp5_ = self->priv->_monitor_scale;
	_tmp6_ = monitor;
	scale = ((gfloat) (_tmp4_.height - gala_utils_scale_to_int (GALA_WORKSPACE_CLONE_TOP_OFFSET + GALA_WORKSPACE_CLONE_BOTTOM_OFFSET, _tmp5_))) / _tmp6_.height;
	_tmp7_ = self->priv->_monitor_scale;
	_tmp8_ = monitor;
	_tmp9_ = monitor;
	pivot_y = gala_utils_scale_to_int (GALA_WORKSPACE_CLONE_TOP_OFFSET, _tmp7_) / (_tmp8_.height - (_tmp9_.height * scale));
	_tmp10_ = self->priv->background;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp10_, 0.5f, pivot_y);
	_tmp11_ = monitor;
	initial_width = _tmp11_.width;
	_tmp12_ = monitor;
	target_width = (_tmp12_.width * scale) + (GALA_WORKSPACE_ROW_WORKSPACE_GAP * 2);
	g_value_init (&_tmp13_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp13_, (gfloat) initial_width);
	g_value_init (&_tmp14_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp14_, (gfloat) target_width);
	_tmp15_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GObject*) self, "width", G_TYPE_FLOAT, &_tmp13_, &_tmp14_);
	_tmp16_ = _tmp15_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	G_IS_VALUE (&_tmp14_) ? (g_value_unset (&_tmp14_), NULL) : NULL;
	G_IS_VALUE (&_tmp13_) ? (g_value_unset (&_tmp13_), NULL) : NULL;
	_tmp17_ = self->priv->background;
	g_value_init (&_tmp18_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp18_, 1.);
	g_value_init (&_tmp19_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp19_, (gdouble) scale);
	_tmp20_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GObject*) _tmp17_, "scale-x", G_TYPE_DOUBLE, &_tmp18_, &_tmp19_);
	_tmp21_ = _tmp20_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	G_IS_VALUE (&_tmp19_) ? (g_value_unset (&_tmp19_), NULL) : NULL;
	G_IS_VALUE (&_tmp18_) ? (g_value_unset (&_tmp18_), NULL) : NULL;
	_tmp22_ = self->priv->background;
	g_value_init (&_tmp23_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp23_, 1.);
	g_value_init (&_tmp24_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp24_, (gdouble) scale);
	_tmp25_ = gala_property_target_new (GALA_GESTURE_ACTION_MULTITASKING_VIEW, (GObject*) _tmp22_, "scale-y", G_TYPE_DOUBLE, &_tmp23_, &_tmp24_);
	_tmp26_ = _tmp25_;
	gala_actor_target_add_target ((GalaActorTarget*) self, (GalaGestureTarget*) _tmp26_);
	_g_object_unref0 (_tmp26_);
	G_IS_VALUE (&_tmp24_) ? (g_value_unset (&_tmp24_), NULL) : NULL;
	G_IS_VALUE (&_tmp23_) ? (g_value_unset (&_tmp23_), NULL) : NULL;
	_tmp27_ = self->priv->_window_container;
	_tmp28_ = self->priv->_monitor_scale;
	gala_window_clone_container_set_padding_top (_tmp27_, gala_utils_scale_to_int (GALA_WORKSPACE_CLONE_TOP_OFFSET, _tmp28_));
	_tmp29_ = self->priv->_window_container;
	_tmp30_ = self->priv->_window_container;
	_tmp31_ = monitor;
	_tmp32_ = monitor;
	gala_window_clone_container_set_padding_right (_tmp30_, ((gint) (_tmp31_.width - (_tmp32_.width * scale))) / 2);
	gala_window_clone_container_set_padding_left (_tmp29_, ((gint) (_tmp31_.width - (_tmp32_.width * scale))) / 2);
	_tmp33_ = self->priv->_window_container;
	_tmp34_ = self->priv->_monitor_scale;
	gala_window_clone_container_set_padding_bottom (_tmp33_, gala_utils_scale_to_int (GALA_WORKSPACE_CLONE_BOTTOM_OFFSET, _tmp34_));
}

static void
gala_workspace_clone_activate (GalaWorkspaceClone* self,
                               gboolean close_view)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (close_view) {
		MetaWorkspace* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->_workspace;
		g_object_get (_tmp1_, "active", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GalaWindowManager* _tmp4_;
		_tmp4_ = self->priv->_wm;
		gala_window_manager_perform_action (_tmp4_, GALA_ACTION_TYPE_SHOW_MULTITASKING_VIEW);
	} else {
		MetaWorkspace* _tmp5_;
		_tmp5_ = self->priv->_workspace;
		meta_workspace_activate (_tmp5_, (guint32) META_CURRENT_TIME);
	}
}

GalaWindowManager*
gala_workspace_clone_get_wm (GalaWorkspaceClone* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_wm (GalaWorkspaceClone* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WM_PROPERTY]);
	}
}

MetaWorkspace*
gala_workspace_clone_get_workspace (GalaWorkspaceClone* self)
{
	MetaWorkspace* result;
	MetaWorkspace* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_workspace;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_workspace (GalaWorkspaceClone* self,
                                    MetaWorkspace* value)
{
	MetaWorkspace* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_workspace (self);
	if (old_value != value) {
		MetaWorkspace* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_workspace);
		self->priv->_workspace = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY]);
	}
}

gfloat
gala_workspace_clone_get_monitor_scale (GalaWorkspaceClone* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
gala_workspace_clone_set_monitor_scale (GalaWorkspaceClone* self,
                                        gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY]);
	}
}

GalaWindowCloneContainer*
gala_workspace_clone_get_window_container (GalaWorkspaceClone* self)
{
	GalaWindowCloneContainer* result;
	GalaWindowCloneContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window_container;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_window_container (GalaWorkspaceClone* self,
                                           GalaWindowCloneContainer* value)
{
	GalaWindowCloneContainer* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_window_container (self);
	if (old_value != value) {
		GalaWindowCloneContainer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window_container);
		self->priv->_window_container = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY]);
	}
}

static void
_gala_workspace_clone___lambda60_ (GalaWorkspaceClone* self)
{
	gala_workspace_clone_activate (self, TRUE);
}

static void
__gala_workspace_clone___lambda60__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                 ClutterActor* actor,
                                                                 gpointer self)
{
	_gala_workspace_clone___lambda60_ ((GalaWorkspaceClone*) self);
}

static void
_gala_workspace_clone___lambda61_ (GalaWorkspaceClone* self,
                                   MetaWindow* window)
{
	g_return_if_fail (window != NULL);
	g_signal_emit (self, gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL], 0, window);
}

static void
__gala_workspace_clone___lambda61__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                MetaWindow* window,
                                                                                gpointer self)
{
	_gala_workspace_clone___lambda61_ ((GalaWorkspaceClone*) self, window);
}

static void
_gala_workspace_clone___lambda62_ (GalaWorkspaceClone* self)
{
	gala_workspace_clone_activate (self, TRUE);
}

static void
__gala_workspace_clone___lambda62__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                                                gpointer self)
{
	_gala_workspace_clone___lambda62_ ((GalaWorkspaceClone*) self);
}

static gboolean
___lambda64_ (GalaWorkspaceClone* self)
{
	gboolean result;
	gala_workspace_clone_activate (self, FALSE);
	self->priv->hover_activate_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda64__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda64_ ((GalaWorkspaceClone*) self);
	return result;
}

static void
_gala_workspace_clone___lambda63_ (GalaWorkspaceClone* self,
                                   ClutterActor* target,
                                   gboolean hovered)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	if (!hovered) {
		_tmp0_ = self->priv->hover_activate_timeout != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_source_remove (self->priv->hover_activate_timeout);
		self->priv->hover_activate_timeout = (guint) 0;
		return;
	}
	if (hovered) {
		_tmp1_ = self->priv->hover_activate_timeout == ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->hover_activate_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GALA_WORKSPACE_CLONE_HOVER_ACTIVATE_DELAY, ____lambda64__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
__gala_workspace_clone___lambda63__gala_drag_drop_action_crossed (GalaDragDropAction* _sender,
                                                                  ClutterActor* target,
                                                                  gboolean hovered,
                                                                  gpointer self)
{
	_gala_workspace_clone___lambda63_ ((GalaWorkspaceClone*) self, target, hovered);
}

static void
_gala_workspace_clone_update_targets_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                            gpointer self)
{
	gala_workspace_clone_update_targets ((GalaWorkspaceClone*) self);
}

static void
_gala_workspace_clone_update_targets_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	gala_workspace_clone_update_targets ((GalaWorkspaceClone*) self);
}

static GObject *
gala_workspace_clone_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWorkspaceClone * self;
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MtkRectangle monitor_geometry = {0};
	MetaDisplay* _tmp2_;
	MetaDisplay* _tmp3_;
	MtkRectangle _tmp4_ = {0};
	ClutterClickAction* background_click_action = NULL;
	ClutterClickAction* _tmp5_;
	ClutterClickAction* _tmp6_;
	MetaDisplay* _tmp7_;
	GalaFramedBackground* _tmp8_;
	GalaBackgroundManager* _tmp9_;
	ClutterClickAction* _tmp10_;
	MetaDisplay* _tmp11_;
	MetaDisplay* _tmp12_;
	MetaWorkspace* _tmp13_;
	GalaWindowListModel* _tmp14_;
	GalaWindowManager* _tmp15_;
	GalaWindowListModel* _tmp16_;
	gfloat _tmp17_;
	MtkRectangle _tmp18_;
	MtkRectangle _tmp19_;
	GalaWindowCloneContainer* _tmp20_ = NULL;
	GalaWindowCloneContainer* _tmp21_;
	GalaWindowCloneContainer* _tmp22_;
	GalaWindowCloneContainer* _tmp23_;
	GalaWindowCloneContainer* _tmp24_;
	GalaDragDropAction* background_drop_action = NULL;
	GalaDragDropAction* _tmp25_;
	GalaBackgroundManager* _tmp26_;
	GalaDragDropAction* _tmp27_;
	GalaDragDropAction* _tmp28_;
	GalaBackgroundManager* _tmp29_;
	GalaWindowCloneContainer* _tmp30_;
	MetaMonitorManager* monitor_manager = NULL;
	MetaDisplay* _tmp31_;
	MetaContext* _tmp32_;
	MetaBackend* _tmp33_;
	MetaMonitorManager* _tmp34_;
	MetaMonitorManager* _tmp35_;
	parent_class = G_OBJECT_CLASS (gala_workspace_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = display;
	meta_display_get_monitor_geometry (_tmp2_, meta_display_get_primary_monitor (_tmp3_), &_tmp4_);
	monitor_geometry = _tmp4_;
	_tmp5_ = (ClutterClickAction*) clutter_click_action_new ();
	g_object_ref_sink (_tmp5_);
	background_click_action = _tmp5_;
	_tmp6_ = background_click_action;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) __gala_workspace_clone___lambda60__clutter_click_action_clicked, self, 0);
	_tmp7_ = display;
	_tmp8_ = gala_framed_background_new (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = (GalaBackgroundManager*) _tmp8_;
	_tmp9_ = self->priv->background;
	_tmp10_ = background_click_action;
	clutter_actor_add_action ((ClutterActor*) _tmp9_, (ClutterAction*) _tmp10_);
	_tmp11_ = display;
	_tmp12_ = display;
	_tmp13_ = self->priv->_workspace;
	_tmp14_ = gala_window_list_model_new (_tmp11_, GALA_WINDOW_LIST_MODEL_SORT_MODE_STACKING, TRUE, meta_display_get_primary_monitor (_tmp12_), _tmp13_, NULL);
	_g_object_unref0 (self->priv->windows);
	self->priv->windows = _tmp14_;
	_tmp15_ = self->priv->_wm;
	_tmp16_ = self->priv->windows;
	_tmp17_ = self->priv->_monitor_scale;
	_tmp18_ = monitor_geometry;
	_tmp19_ = monitor_geometry;
	_tmp20_ = gala_window_clone_container_new (_tmp15_, _tmp16_, _tmp17_, FALSE);
	clutter_actor_set_width ((ClutterActor*) _tmp20_, (gfloat) _tmp18_.width);
	clutter_actor_set_height ((ClutterActor*) _tmp20_, (gfloat) _tmp19_.height);
	g_object_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	gala_workspace_clone_set_window_container (self, _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = self->priv->_window_container;
	g_signal_connect_object (_tmp22_, "window-selected", (GCallback) __gala_workspace_clone___lambda61__gala_window_clone_container_window_selected, self, 0);
	_tmp23_ = self->priv->_window_container;
	g_signal_connect_object (_tmp23_, "requested-close", (GCallback) __gala_workspace_clone___lambda62__gala_window_clone_container_requested_close, self, 0);
	_tmp24_ = self->priv->_window_container;
	g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp24_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp25_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp25_);
	background_drop_action = _tmp25_;
	_tmp26_ = self->priv->background;
	_tmp27_ = background_drop_action;
	clutter_actor_add_action ((ClutterActor*) _tmp26_, (ClutterAction*) _tmp27_);
	_tmp28_ = background_drop_action;
	g_signal_connect_object (_tmp28_, "crossed", (GCallback) __gala_workspace_clone___lambda63__gala_drag_drop_action_crossed, self, 0);
	_tmp29_ = self->priv->background;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp29_);
	_tmp30_ = self->priv->_window_container;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp30_);
	_tmp31_ = display;
	_tmp32_ = meta_display_get_context (_tmp31_);
	_tmp33_ = meta_context_get_backend (_tmp32_);
	_tmp34_ = meta_backend_get_monitor_manager (_tmp33_);
	monitor_manager = _tmp34_;
	_tmp35_ = monitor_manager;
	g_signal_connect_object (_tmp35_, "monitors-changed", (GCallback) _gala_workspace_clone_update_targets_meta_monitor_manager_monitors_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::monitor-scale", (GCallback) _gala_workspace_clone_update_targets_g_object_notify, self, 0);
	gala_workspace_clone_update_targets (self);
	_g_object_unref0 (background_drop_action);
	_g_object_unref0 (background_click_action);
	return obj;
}

static void
gala_workspace_clone_class_init (GalaWorkspaceCloneClass * klass,
                                 gpointer klass_data)
{
	gala_workspace_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWorkspaceClone_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_workspace_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_workspace_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_workspace_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_workspace_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_WM_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY] = g_param_spec_object ("workspace", "workspace", "workspace", meta_workspace_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY] = g_param_spec_object ("window-container", "window-container", "window-container", GALA_TYPE_WINDOW_CLONE_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * A window has been selected, the MultitaskingView should consider activating
	     * and closing the view.
	     */
	gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL] = g_signal_new ("window-selected", GALA_TYPE_WORKSPACE_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
}

static void
gala_workspace_clone_instance_init (GalaWorkspaceClone * self,
                                    gpointer klass)
{
	self->priv = gala_workspace_clone_get_instance_private (self);
	self->priv->hover_activate_timeout = (guint) 0;
}

static void
gala_workspace_clone_finalize (GObject * obj)
{
	GalaWorkspaceClone * self;
	GalaBackgroundManager* _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	_tmp0_ = self->priv->background;
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->_window_container;
	clutter_actor_destroy ((ClutterActor*) _tmp1_);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_workspace);
	_g_object_unref0 (self->priv->_window_container);
	_g_object_unref0 (self->priv->background);
	_g_object_unref0 (self->priv->windows);
	G_OBJECT_CLASS (gala_workspace_clone_parent_class)->finalize (obj);
}

/**
 * This is the container which manages a clone of the background which will
 * be scaled and animated inwards, a WindowCloneContainer for the windows on
 * this workspace and also holds the instance for this workspace's IconGroup.
 * The latter is not added to the WorkspaceClone itself though but to a container
 * of the MultitaskingView.
 */
 G_GNUC_NO_INLINE static GType
gala_workspace_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWorkspaceCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_workspace_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWorkspaceClone), 0, (GInstanceInitFunc) gala_workspace_clone_instance_init, NULL };
	GType gala_workspace_clone_type_id;
	gala_workspace_clone_type_id = g_type_register_static (GALA_TYPE_ACTOR_TARGET, "GalaWorkspaceClone", &g_define_type_info, 0);
	GalaWorkspaceClone_private_offset = g_type_add_instance_private (gala_workspace_clone_type_id, sizeof (GalaWorkspaceClonePrivate));
	return gala_workspace_clone_type_id;
}

GType
gala_workspace_clone_get_type (void)
{
	static gsize gala_workspace_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_workspace_clone_type_id__once)) {
		GType gala_workspace_clone_type_id;
		gala_workspace_clone_type_id = gala_workspace_clone_get_type_once ();
		g_once_init_leave (&gala_workspace_clone_type_id__once, gala_workspace_clone_type_id);
	}
	return gala_workspace_clone_type_id__once;
}

static void
_vala_gala_workspace_clone_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWorkspaceClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	switch (property_id) {
		case GALA_WORKSPACE_CLONE_WM_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_wm (self));
		break;
		case GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_workspace (self));
		break;
		case GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_workspace_clone_get_monitor_scale (self));
		break;
		case GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_window_container (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_workspace_clone_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWorkspaceClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	switch (property_id) {
		case GALA_WORKSPACE_CLONE_WM_PROPERTY:
		gala_workspace_clone_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY:
		gala_workspace_clone_set_workspace (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_MONITOR_SCALE_PROPERTY:
		gala_workspace_clone_set_monitor_scale (self, g_value_get_float (value));
		break;
		case GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY:
		gala_workspace_clone_set_window_container (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

