/* web-service-details.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from web-service-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Alban Crequy <alban.crequy@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_WEB_SERVICE_FIELD_DETAILS_0_PROPERTY,
	FOLKS_WEB_SERVICE_FIELD_DETAILS_NUM_PROPERTIES
};
static GParamSpec* folks_web_service_field_details_properties[FOLKS_WEB_SERVICE_FIELD_DETAILS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksWebServiceDetailsChangeWebServiceAddressesData FolksWebServiceDetailsChangeWebServiceAddressesData;

struct _FolksWebServiceDetailsChangeWebServiceAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksWebServiceDetails* self;
	GeeMultiMap* web_service_addresses;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gpointer folks_web_service_field_details_parent_class = NULL;

static gboolean folks_web_service_field_details_real_equal (FolksAbstractFieldDetails* base,
                                                     FolksAbstractFieldDetails* that);
static guint folks_web_service_field_details_real_hash (FolksAbstractFieldDetails* base);
static GType folks_web_service_field_details_get_type_once (void);
static void folks_web_service_details_real_change_web_service_addresses_data_free (gpointer _data);
static void folks_web_service_details_real_change_web_service_addresses (FolksWebServiceDetails* self,
                                                                  GeeMultiMap* web_service_addresses,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_);
static gboolean folks_web_service_details_real_change_web_service_addresses_co (FolksWebServiceDetailsChangeWebServiceAddressesData* _data_);
static GType folks_web_service_details_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
   * Create a new WebServiceFieldDetails.
   *
   * @param value the value of the field, a non-empty web service address
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A ``null`` value is equivalent to
   * an empty map of parameters.
   *
   * @return a new WebServiceFieldDetails
   *
   * @since 0.6.0
   */
FolksWebServiceFieldDetails*
folks_web_service_field_details_construct (GType object_type,
                                           const gchar* value,
                                           GeeMultiMap* parameters)
{
	FolksWebServiceFieldDetails * self = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	if (g_strcmp0 (value, "") == 0) {
		g_warning ("web-service-details.vala:52: %s", "Empty web service address passed to " "WebServiceFieldDetails.");
	}
	self = (FolksWebServiceFieldDetails*) g_object_new (object_type, "t-type", G_TYPE_STRING, "t-dup-func", (GBoxedCopyFunc) g_strdup, "t-destroy-func", (GDestroyNotify) g_free, "value", value, "parameters", parameters, NULL);
	return self;
}

FolksWebServiceFieldDetails*
folks_web_service_field_details_new (const gchar* value,
                                     GeeMultiMap* parameters)
{
	return folks_web_service_field_details_construct (FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, value, parameters);
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean
folks_web_service_field_details_real_equal (FolksAbstractFieldDetails* base,
                                            FolksAbstractFieldDetails* that)
{
	FolksWebServiceFieldDetails * self;
	gboolean result;
	self = (FolksWebServiceFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	result = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_web_service_field_details_parent_class)->equal (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails), that);
	return result;
}

/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint
folks_web_service_field_details_real_hash (FolksAbstractFieldDetails* base)
{
	FolksWebServiceFieldDetails * self;
	guint result;
	self = (FolksWebServiceFieldDetails*) base;
	result = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_web_service_field_details_parent_class)->hash (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
	return result;
}

static void
folks_web_service_field_details_class_init (FolksWebServiceFieldDetailsClass * klass,
                                            gpointer klass_data)
{
	folks_web_service_field_details_parent_class = g_type_class_peek_parent (klass);
	((FolksAbstractFieldDetailsClass *) klass)->equal = (gboolean (*) (FolksAbstractFieldDetails*, FolksAbstractFieldDetails*)) folks_web_service_field_details_real_equal;
	((FolksAbstractFieldDetailsClass *) klass)->hash = (guint (*) (FolksAbstractFieldDetails*)) folks_web_service_field_details_real_hash;
}

static void
folks_web_service_field_details_instance_init (FolksWebServiceFieldDetails * self,
                                               gpointer klass)
{
}

/**
 * Object representing a web service contact that can have some parameters
 * associated with it.
 *
 * See {@link Folks.AbstractFieldDetails}.
 *
 * @since 0.6.0
 */
static GType
folks_web_service_field_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksWebServiceFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_web_service_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksWebServiceFieldDetails), 0, (GInstanceInitFunc) folks_web_service_field_details_instance_init, NULL };
	GType folks_web_service_field_details_type_id;
	folks_web_service_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksWebServiceFieldDetails", &g_define_type_info, 0);
	return folks_web_service_field_details_type_id;
}

GType
folks_web_service_field_details_get_type (void)
{
	static volatile gsize folks_web_service_field_details_type_id__once = 0;
	if (g_once_init_enter (&folks_web_service_field_details_type_id__once)) {
		GType folks_web_service_field_details_type_id;
		folks_web_service_field_details_type_id = folks_web_service_field_details_get_type_once ();
		g_once_init_leave (&folks_web_service_field_details_type_id__once, folks_web_service_field_details_type_id);
	}
	return folks_web_service_field_details_type_id__once;
}

static void
folks_web_service_details_real_change_web_service_addresses_data_free (gpointer _data)
{
	FolksWebServiceDetailsChangeWebServiceAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->web_service_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksWebServiceDetailsChangeWebServiceAddressesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_web_service_details_real_change_web_service_addresses (FolksWebServiceDetails* self,
                                                             GeeMultiMap* web_service_addresses,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_)
{
	FolksWebServiceDetailsChangeWebServiceAddressesData* _data_;
	FolksWebServiceDetails* _tmp0_;
	GeeMultiMap* _tmp1_;
	g_return_if_fail (web_service_addresses != NULL);
	_data_ = g_slice_new0 (FolksWebServiceDetailsChangeWebServiceAddressesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_web_service_details_real_change_web_service_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (web_service_addresses);
	_g_object_unref0 (_data_->web_service_addresses);
	_data_->web_service_addresses = _tmp1_;
	folks_web_service_details_real_change_web_service_addresses_co (_data_);
}

static void
folks_web_service_details_real_change_web_service_addresses_finish (FolksWebServiceDetails* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error)
{
	FolksWebServiceDetailsChangeWebServiceAddressesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's web service addresses.
   *
   * It's preferred to call this rather than setting
   * {@link WebServiceDetails.web_service_addresses} directly, as this method
   * gives error notification and will only return once the addresses have been
   * written to the relevant backing store (or the operation's failed).
   *
   * @param web_service_addresses the set of addresses
   * @throws PropertyError if setting the addresses failed
   * @since 0.6.2
   */
static gboolean
folks_web_service_details_real_change_web_service_addresses_co (FolksWebServiceDetailsChangeWebServiceAddressesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Web service addresses are not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_web_service_details_change_web_service_addresses (FolksWebServiceDetails* self,
                                                        GeeMultiMap* web_service_addresses,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	FolksWebServiceDetailsIface* _iface_;
	_iface_ = FOLKS_WEB_SERVICE_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_web_service_addresses) {
		_iface_->change_web_service_addresses (self, web_service_addresses, _callback_, _user_data_);
	}
}

void
folks_web_service_details_change_web_service_addresses_finish (FolksWebServiceDetails* self,
                                                               GAsyncResult* _res_,
                                                               GError** error)
{
	FolksWebServiceDetailsIface* _iface_;
	_iface_ = FOLKS_WEB_SERVICE_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_web_service_addresses_finish) {
		_iface_->change_web_service_addresses_finish (self, _res_, error);
	}
}

GeeMultiMap*
folks_web_service_details_get_web_service_addresses (FolksWebServiceDetails* self)
{
	FolksWebServiceDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_WEB_SERVICE_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_web_service_addresses) {
		return _iface_->get_web_service_addresses (self);
	}
	return NULL;
}

void
folks_web_service_details_set_web_service_addresses (FolksWebServiceDetails* self,
                                                     GeeMultiMap* value)
{
	FolksWebServiceDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_WEB_SERVICE_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_web_service_addresses) {
		_iface_->set_web_service_addresses (self, value);
	}
}

static void
folks_web_service_details_default_init (FolksWebServiceDetailsIface * iface,
                                        gpointer iface_data)
{
	/**
	   * A mapping of web service to an (unordered) set of web service addresses.
	   *
	   * Each mapping is from an arbitrary web service identifier to a set of web
	   * service addresses for the contact, listed in no particular order.
	   *
	   * Web service addresses are guaranteed to be unique per web service, but
	   * not necessarily unique amongst all web services.
	   *
	   * @since 0.6.0
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("web-service-addresses", "web-service-addresses", "web-service-addresses", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_web_service_addresses = folks_web_service_details_real_change_web_service_addresses;
	iface->change_web_service_addresses_finish = folks_web_service_details_real_change_web_service_addresses_finish;
}

/**
 * Web service contact details.
 *
 * @since 0.5.0
 */
static GType
folks_web_service_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksWebServiceDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_web_service_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_web_service_details_type_id;
	folks_web_service_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksWebServiceDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_web_service_details_type_id, G_TYPE_OBJECT);
	return folks_web_service_details_type_id;
}

GType
folks_web_service_details_get_type (void)
{
	static volatile gsize folks_web_service_details_type_id__once = 0;
	if (g_once_init_enter (&folks_web_service_details_type_id__once)) {
		GType folks_web_service_details_type_id;
		folks_web_service_details_type_id = folks_web_service_details_get_type_once ();
		g_once_init_leave (&folks_web_service_details_type_id__once, folks_web_service_details_type_id);
	}
	return folks_web_service_details_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

