/* name-details.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from name-details.vala, do not modify */

/*
 * Copyright (C) 2011, 2013 Collabora Ltd.
 * Copyright (C) 2011, 2013 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_STRUCTURED_NAME_0_PROPERTY,
	FOLKS_STRUCTURED_NAME_FAMILY_NAME_PROPERTY,
	FOLKS_STRUCTURED_NAME_GIVEN_NAME_PROPERTY,
	FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES_PROPERTY,
	FOLKS_STRUCTURED_NAME_PREFIXES_PROPERTY,
	FOLKS_STRUCTURED_NAME_SUFFIXES_PROPERTY,
	FOLKS_STRUCTURED_NAME_NUM_PROPERTIES
};
static GParamSpec* folks_structured_name_properties[FOLKS_STRUCTURED_NAME_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksNameDetailsChangeStructuredNameData FolksNameDetailsChangeStructuredNameData;
typedef struct _FolksNameDetailsChangeFullNameData FolksNameDetailsChangeFullNameData;
typedef struct _FolksNameDetailsChangeNicknameData FolksNameDetailsChangeNicknameData;

struct _FolksStructuredNamePrivate {
	gchar* _family_name;
	gchar* _given_name;
	gchar* _additional_names;
	gchar* _prefixes;
	gchar* _suffixes;
};

struct _FolksNameDetailsChangeStructuredNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksNameDetails* self;
	FolksStructuredName* name;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _FolksNameDetailsChangeFullNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksNameDetails* self;
	gchar* full_name;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _FolksNameDetailsChangeNicknameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksNameDetails* self;
	gchar* nickname;
	GError* _tmp0_;
	GError* _inner_error0_;
};

static gint FolksStructuredName_private_offset;
static gpointer folks_structured_name_parent_class = NULL;

static gchar* _folks_structured_name_extract_initials (FolksStructuredName* self,
                                                const gchar* names);
static void folks_structured_name_finalize (GObject * obj);
static GType folks_structured_name_get_type_once (void);
static void _vala_folks_structured_name_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_folks_structured_name_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void folks_name_details_real_change_structured_name_data_free (gpointer _data);
static void folks_name_details_real_change_structured_name (FolksNameDetails* self,
                                                     FolksStructuredName* name,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean folks_name_details_real_change_structured_name_co (FolksNameDetailsChangeStructuredNameData* _data_);
static void folks_name_details_real_change_full_name_data_free (gpointer _data);
static void folks_name_details_real_change_full_name (FolksNameDetails* self,
                                               const gchar* full_name,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean folks_name_details_real_change_full_name_co (FolksNameDetailsChangeFullNameData* _data_);
static void folks_name_details_real_change_nickname_data_free (gpointer _data);
static void folks_name_details_real_change_nickname (FolksNameDetails* self,
                                              const gchar* nickname,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean folks_name_details_real_change_nickname_co (FolksNameDetailsChangeNicknameData* _data_);
static GType folks_name_details_get_type_once (void);

static inline gpointer
folks_structured_name_get_instance_private (FolksStructuredName* self)
{
	return G_STRUCT_MEMBER_P (self, FolksStructuredName_private_offset);
}

/**
   * Create a StructuredName.
   *
   * You can pass ``null`` if a component is not set.
   *
   * @param family_name the family (last) name
   * @param given_name the given (first) name
   * @param additional_names additional names
   * @param prefixes prefixes of the name
   * @param suffixes suffixes of the name
   * @return a new StructuredName
   *
   * @since 0.3.5
   */
FolksStructuredName*
folks_structured_name_construct (GType object_type,
                                 const gchar* family_name,
                                 const gchar* given_name,
                                 const gchar* additional_names,
                                 const gchar* prefixes,
                                 const gchar* suffixes)
{
	FolksStructuredName * self = NULL;
	self = (FolksStructuredName*) g_object_new (object_type, "family-name", family_name, "given-name", given_name, "additional-names", additional_names, "prefixes", prefixes, "suffixes", suffixes, NULL);
	return self;
}

FolksStructuredName*
folks_structured_name_new (const gchar* family_name,
                           const gchar* given_name,
                           const gchar* additional_names,
                           const gchar* prefixes,
                           const gchar* suffixes)
{
	return folks_structured_name_construct (FOLKS_TYPE_STRUCTURED_NAME, family_name, given_name, additional_names, prefixes, suffixes);
}

/**
   * Create a StructuredName.
   *
   * Shorthand for the common case of just having the family and given
   * name of a contact. It's equivalent to calling
   * {@link StructuredName.StructuredName} and passing ``null`` for all
   * the other components.
   *
   * @param family_name the family (last) name
   * @param given_name the given (first) name
   * @return a new StructuredName
   *
   * @since 0.3.5
   */
FolksStructuredName*
folks_structured_name_construct_simple (GType object_type,
                                        const gchar* family_name,
                                        const gchar* given_name)
{
	FolksStructuredName * self = NULL;
	self = (FolksStructuredName*) g_object_new (object_type, "family-name", family_name, "given-name", given_name, NULL);
	return self;
}

FolksStructuredName*
folks_structured_name_new_simple (const gchar* family_name,
                                  const gchar* given_name)
{
	return folks_structured_name_construct_simple (FOLKS_TYPE_STRUCTURED_NAME, family_name, given_name);
}

/**
   * Whether none of the components is set.
   *
   * @return ``true`` if all the components are the empty string, ``false``
   * otherwise.
   *
   * @since 0.3.5
   */
gboolean
folks_structured_name_is_empty (FolksStructuredName* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp4_ = self->priv->_family_name;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->_given_name;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->_additional_names;
		_tmp2_ = g_strcmp0 (_tmp6_, "") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp7_;
		_tmp7_ = self->priv->_prefixes;
		_tmp1_ = g_strcmp0 (_tmp7_, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp8_;
		_tmp8_ = self->priv->_suffixes;
		_tmp0_ = g_strcmp0 (_tmp8_, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
   * Whether two StructuredNames are the same.
   *
   * @param other the other structured name to compare with
   * @return ``true`` if all the components are the same, ``false``
   * otherwise.
   *
   * @since 0.5.0
   */
gboolean
folks_structured_name_equal (FolksStructuredName* self,
                             FolksStructuredName* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp4_ = self->priv->_family_name;
	_tmp5_ = folks_structured_name_get_family_name (other);
	_tmp6_ = _tmp5_;
	if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = self->priv->_given_name;
		_tmp8_ = folks_structured_name_get_given_name (other);
		_tmp9_ = _tmp8_;
		_tmp3_ = g_strcmp0 (_tmp7_, _tmp9_) == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = self->priv->_additional_names;
		_tmp11_ = folks_structured_name_get_additional_names (other);
		_tmp12_ = _tmp11_;
		_tmp2_ = g_strcmp0 (_tmp10_, _tmp12_) == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = self->priv->_prefixes;
		_tmp14_ = folks_structured_name_get_prefixes (other);
		_tmp15_ = _tmp14_;
		_tmp1_ = g_strcmp0 (_tmp13_, _tmp15_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp16_ = self->priv->_suffixes;
		_tmp17_ = folks_structured_name_get_suffixes (other);
		_tmp18_ = _tmp17_;
		_tmp0_ = g_strcmp0 (_tmp16_, _tmp18_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gchar*
_folks_structured_name_extract_initials (FolksStructuredName* self,
                                         const gchar* names)
{
	GString* output = NULL;
	GString* _tmp0_;
	gboolean at_start_of_word = FALSE;
	gint index = 0;
	gunichar c = 0U;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (names != NULL, NULL);
	_tmp0_ = g_string_new ("");
	output = _tmp0_;
	at_start_of_word = TRUE;
	index = 0;
	while (TRUE) {
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = string_get_next_char (names, &index, &_tmp1_);
		c = _tmp1_;
		if (!(_tmp2_ == TRUE)) {
			break;
		}
		if (g_unichar_isspace (c)) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = c == ((gunichar) '-');
		}
		if (_tmp3_) {
			at_start_of_word = TRUE;
		} else {
			if (at_start_of_word) {
				GString* _tmp4_;
				_tmp4_ = output;
				g_string_append_unichar (_tmp4_, c);
				at_start_of_word = FALSE;
			}
		}
	}
	_tmp5_ = output;
	_tmp6_ = _tmp5_->str;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	_g_string_free0 (output);
	return result;
}

/**
   * Formatted version of the structured name.
   *
   * @return name formatted according to the current locale
   * @since 0.4.0
   */
gchar*
folks_structured_name_to_string (FolksStructuredName* self)
{
	gchar* name_fmt = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (_ ("%g%t%m%t%f"));
	name_fmt = _tmp0_;
	_tmp1_ = folks_structured_name_to_string_with_format (self, name_fmt);
	result = _tmp1_;
	_g_free0 (name_fmt);
	return result;
}

/**
   * Formatted version of the structured name.
   *
   * This allows a custom format string to be specified, using the placeholders
   * described on [[http://lh.2xlibre.net/values/name_fmt/]]. This ``name_fmt``
   * must almost always be translated to the current locale. (Ideally it would
   * be translated to the locale of the persona whose name is being formatted,
   * but such locale information isn’t available.)
   *
   * @param name_fmt format string for the name
   * @return name formatted according to the given format
   * @since 0.9.7
   */
gchar*
folks_structured_name_to_string_with_format (FolksStructuredName* self,
                                             const gchar* name_fmt)
{
	GString* output = NULL;
	GString* _tmp0_;
	gboolean in_field_descriptor = FALSE;
	gboolean field_descriptor_romanised = FALSE;
	gboolean field_descriptor_empty = FALSE;
	gint index = 0;
	gunichar c = 0U;
	GString* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name_fmt != NULL, NULL);
	_tmp0_ = g_string_new ("");
	output = _tmp0_;
	in_field_descriptor = FALSE;
	field_descriptor_romanised = FALSE;
	field_descriptor_empty = TRUE;
	index = 0;
	while (TRUE) {
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		_tmp2_ = string_get_next_char (name_fmt, &index, &_tmp1_);
		c = _tmp1_;
		if (!(_tmp2_ == TRUE)) {
			break;
		}
		if (c == ((gunichar) '%')) {
			in_field_descriptor = !in_field_descriptor;
			if (in_field_descriptor) {
				field_descriptor_romanised = FALSE;
				continue;
			}
		}
		if (in_field_descriptor) {
			gchar* val = NULL;
			gchar* _tmp3_;
			GString* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			if (c == ((gunichar) 'R')) {
				field_descriptor_romanised = TRUE;
				continue;
			}
			_tmp3_ = g_strdup ("");
			val = _tmp3_;
			if (c == ((gunichar) 'f')) {
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = self->priv->_family_name;
				_tmp5_ = g_strdup (_tmp4_);
				_g_free0 (val);
				val = _tmp5_;
			} else {
				if (c == ((gunichar) 'F')) {
					const gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp6_ = self->priv->_family_name;
					_tmp7_ = g_utf8_strup (_tmp6_, (gssize) -1);
					_g_free0 (val);
					val = _tmp7_;
				} else {
					if (c == ((gunichar) 'g')) {
						const gchar* _tmp8_;
						gchar* _tmp9_;
						_tmp8_ = self->priv->_given_name;
						_tmp9_ = g_strdup (_tmp8_);
						_g_free0 (val);
						val = _tmp9_;
					} else {
						if (c == ((gunichar) 'G')) {
							const gchar* _tmp10_;
							gchar* _tmp11_;
							_tmp10_ = self->priv->_given_name;
							_tmp11_ = _folks_structured_name_extract_initials (self, _tmp10_);
							_g_free0 (val);
							val = _tmp11_;
						} else {
							if (c == ((gunichar) 'm')) {
								const gchar* _tmp12_;
								gchar* _tmp13_;
								_tmp12_ = self->priv->_additional_names;
								_tmp13_ = g_strdup (_tmp12_);
								_g_free0 (val);
								val = _tmp13_;
							} else {
								if (c == ((gunichar) 'M')) {
									const gchar* _tmp14_;
									gchar* _tmp15_;
									_tmp14_ = self->priv->_additional_names;
									_tmp15_ = _folks_structured_name_extract_initials (self, _tmp14_);
									_g_free0 (val);
									val = _tmp15_;
								} else {
									gboolean _tmp16_ = FALSE;
									gboolean _tmp17_ = FALSE;
									if (c == ((gunichar) 's')) {
										_tmp17_ = TRUE;
									} else {
										_tmp17_ = c == ((gunichar) 'S');
									}
									if (_tmp17_) {
										_tmp16_ = TRUE;
									} else {
										_tmp16_ = c == ((gunichar) 'd');
									}
									if (_tmp16_) {
										const gchar* _tmp18_;
										gchar* _tmp19_;
										_tmp18_ = self->priv->_prefixes;
										_tmp19_ = g_strdup (_tmp18_);
										_g_free0 (val);
										val = _tmp19_;
									} else {
										if (c == ((gunichar) 't')) {
											const gchar* _tmp20_ = NULL;
											gchar* _tmp21_;
											if (field_descriptor_empty == FALSE) {
												_tmp20_ = " ";
											} else {
												_tmp20_ = "";
											}
											_tmp21_ = g_strdup (_tmp20_);
											_g_free0 (val);
											val = _tmp21_;
										} else {
											gboolean _tmp22_ = FALSE;
											gboolean _tmp23_ = FALSE;
											if (c == ((gunichar) 'l')) {
												_tmp23_ = TRUE;
											} else {
												_tmp23_ = c == ((gunichar) 'o');
											}
											if (_tmp23_) {
												_tmp22_ = TRUE;
											} else {
												_tmp22_ = c == ((gunichar) 'p');
											}
											if (_tmp22_) {
												gchar* _tmp24_;
												_tmp24_ = g_strdup ("");
												_g_free0 (val);
												val = _tmp24_;
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp25_ = output;
			_tmp26_ = val;
			g_string_append (_tmp25_, _tmp26_);
			in_field_descriptor = FALSE;
			_tmp27_ = val;
			field_descriptor_empty = g_strcmp0 (_tmp27_, "") == 0;
			_g_free0 (val);
		} else {
			GString* _tmp28_;
			_tmp28_ = output;
			g_string_append_unichar (_tmp28_, c);
		}
	}
	_tmp29_ = output;
	_tmp30_ = _tmp29_->str;
	_tmp31_ = g_strdup (_tmp30_);
	result = _tmp31_;
	_g_string_free0 (output);
	return result;
}

const gchar*
folks_structured_name_get_family_name (FolksStructuredName* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_family_name;
	result = _tmp0_;
	return result;
}

void
folks_structured_name_set_family_name (FolksStructuredName* self,
                                       const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_family_name);
	self->priv->_family_name = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_structured_name_properties[FOLKS_STRUCTURED_NAME_FAMILY_NAME_PROPERTY]);
}

const gchar*
folks_structured_name_get_given_name (FolksStructuredName* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_given_name;
	result = _tmp0_;
	return result;
}

void
folks_structured_name_set_given_name (FolksStructuredName* self,
                                      const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_given_name);
	self->priv->_given_name = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_structured_name_properties[FOLKS_STRUCTURED_NAME_GIVEN_NAME_PROPERTY]);
}

const gchar*
folks_structured_name_get_additional_names (FolksStructuredName* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_additional_names;
	result = _tmp0_;
	return result;
}

void
folks_structured_name_set_additional_names (FolksStructuredName* self,
                                            const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_additional_names);
	self->priv->_additional_names = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_structured_name_properties[FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES_PROPERTY]);
}

const gchar*
folks_structured_name_get_prefixes (FolksStructuredName* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_prefixes;
	result = _tmp0_;
	return result;
}

void
folks_structured_name_set_prefixes (FolksStructuredName* self,
                                    const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_prefixes);
	self->priv->_prefixes = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_structured_name_properties[FOLKS_STRUCTURED_NAME_PREFIXES_PROPERTY]);
}

const gchar*
folks_structured_name_get_suffixes (FolksStructuredName* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_suffixes;
	result = _tmp0_;
	return result;
}

void
folks_structured_name_set_suffixes (FolksStructuredName* self,
                                    const gchar* value)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value != NULL) {
		_tmp0_ = value;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_suffixes);
	self->priv->_suffixes = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, folks_structured_name_properties[FOLKS_STRUCTURED_NAME_SUFFIXES_PROPERTY]);
}

static void
folks_structured_name_class_init (FolksStructuredNameClass * klass,
                                  gpointer klass_data)
{
	folks_structured_name_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksStructuredName_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_structured_name_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_structured_name_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_structured_name_finalize;
	/**
	   * The family name.
	   *
	   * The family name (also known as surname or last name) of a contact.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_FAMILY_NAME_PROPERTY, folks_structured_name_properties[FOLKS_STRUCTURED_NAME_FAMILY_NAME_PROPERTY] = g_param_spec_string ("family-name", "family-name", "family-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The given name.
	   *
	   * The family name (also known as first name) of a contact.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_GIVEN_NAME_PROPERTY, folks_structured_name_properties[FOLKS_STRUCTURED_NAME_GIVEN_NAME_PROPERTY] = g_param_spec_string ("given-name", "given-name", "given-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * Additional names.
	   *
	   * The additional names of a contact, for instance the contact's
	   * middle name.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES_PROPERTY, folks_structured_name_properties[FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES_PROPERTY] = g_param_spec_string ("additional-names", "additional-names", "additional-names", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The prefixes of a name.
	   *
	   * The prefixes used in front of the name (for instance "Mr", "Mrs",
	   * "Doctor" or honorific titles).
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_PREFIXES_PROPERTY, folks_structured_name_properties[FOLKS_STRUCTURED_NAME_PREFIXES_PROPERTY] = g_param_spec_string ("prefixes", "prefixes", "prefixes", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The suffixes of a name.
	   *
	   * The suffixes used after a name (for instance "PhD" or "Junior").
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_SUFFIXES_PROPERTY, folks_structured_name_properties[FOLKS_STRUCTURED_NAME_SUFFIXES_PROPERTY] = g_param_spec_string ("suffixes", "suffixes", "suffixes", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
folks_structured_name_instance_init (FolksStructuredName * self,
                                     gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = folks_structured_name_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_family_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_given_name = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_additional_names = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_prefixes = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_suffixes = _tmp4_;
}

static void
folks_structured_name_finalize (GObject * obj)
{
	FolksStructuredName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName);
	_g_free0 (self->priv->_family_name);
	_g_free0 (self->priv->_given_name);
	_g_free0 (self->priv->_additional_names);
	_g_free0 (self->priv->_prefixes);
	_g_free0 (self->priv->_suffixes);
	G_OBJECT_CLASS (folks_structured_name_parent_class)->finalize (obj);
}

/**
 * Structured name representation for human names.
 *
 * Represents a full name split in its constituent parts (given name,
 * family name, etc.). This structure corresponds to the "N" field in
 * vCards. The parts of the name are never ``null``: an empty string
 * indicates that a property is not set.
 *
 * @since 0.3.5
 */
static GType
folks_structured_name_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksStructuredNameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_structured_name_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksStructuredName), 0, (GInstanceInitFunc) folks_structured_name_instance_init, NULL };
	GType folks_structured_name_type_id;
	folks_structured_name_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksStructuredName", &g_define_type_info, 0);
	FolksStructuredName_private_offset = g_type_add_instance_private (folks_structured_name_type_id, sizeof (FolksStructuredNamePrivate));
	return folks_structured_name_type_id;
}

GType
folks_structured_name_get_type (void)
{
	static volatile gsize folks_structured_name_type_id__once = 0;
	if (g_once_init_enter (&folks_structured_name_type_id__once)) {
		GType folks_structured_name_type_id;
		folks_structured_name_type_id = folks_structured_name_get_type_once ();
		g_once_init_leave (&folks_structured_name_type_id__once, folks_structured_name_type_id);
	}
	return folks_structured_name_type_id__once;
}

static void
_vala_folks_structured_name_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	FolksStructuredName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName);
	switch (property_id) {
		case FOLKS_STRUCTURED_NAME_FAMILY_NAME_PROPERTY:
		g_value_set_string (value, folks_structured_name_get_family_name (self));
		break;
		case FOLKS_STRUCTURED_NAME_GIVEN_NAME_PROPERTY:
		g_value_set_string (value, folks_structured_name_get_given_name (self));
		break;
		case FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES_PROPERTY:
		g_value_set_string (value, folks_structured_name_get_additional_names (self));
		break;
		case FOLKS_STRUCTURED_NAME_PREFIXES_PROPERTY:
		g_value_set_string (value, folks_structured_name_get_prefixes (self));
		break;
		case FOLKS_STRUCTURED_NAME_SUFFIXES_PROPERTY:
		g_value_set_string (value, folks_structured_name_get_suffixes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_structured_name_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	FolksStructuredName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName);
	switch (property_id) {
		case FOLKS_STRUCTURED_NAME_FAMILY_NAME_PROPERTY:
		folks_structured_name_set_family_name (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_GIVEN_NAME_PROPERTY:
		folks_structured_name_set_given_name (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES_PROPERTY:
		folks_structured_name_set_additional_names (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_PREFIXES_PROPERTY:
		folks_structured_name_set_prefixes (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_SUFFIXES_PROPERTY:
		folks_structured_name_set_suffixes (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
folks_name_details_real_change_structured_name_data_free (gpointer _data)
{
	FolksNameDetailsChangeStructuredNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksNameDetailsChangeStructuredNameData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
folks_name_details_real_change_structured_name (FolksNameDetails* self,
                                                FolksStructuredName* name,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	FolksNameDetailsChangeStructuredNameData* _data_;
	FolksNameDetails* _tmp0_;
	FolksStructuredName* _tmp1_;
	_data_ = g_slice_new0 (FolksNameDetailsChangeStructuredNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_name_details_real_change_structured_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (name);
	_g_object_unref0 (_data_->name);
	_data_->name = _tmp1_;
	folks_name_details_real_change_structured_name_co (_data_);
}

static void
folks_name_details_real_change_structured_name_finish (FolksNameDetails* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	FolksNameDetailsChangeStructuredNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's structured name.
   *
   * It's preferred to call this rather than setting
   * {@link NameDetails.structured_name} directly, as this method gives error
   * notification and will only return once the name has been written to the
   * relevant backing store (or the operation's failed).
   *
   * @param name the structured name (``null`` to unset it)
   * @throws PropertyError if setting the structured name failed
   * @since 0.6.2
   */
static gboolean
folks_name_details_real_change_structured_name_co (FolksNameDetailsChangeStructuredNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Structured name is not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_name_details_change_structured_name (FolksNameDetails* self,
                                           FolksStructuredName* name,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	FolksNameDetailsIface* _iface_;
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_structured_name) {
		_iface_->change_structured_name (self, name, _callback_, _user_data_);
	}
}

void
folks_name_details_change_structured_name_finish (FolksNameDetails* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	FolksNameDetailsIface* _iface_;
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_structured_name_finish) {
		_iface_->change_structured_name_finish (self, _res_, error);
	}
}

static void
folks_name_details_real_change_full_name_data_free (gpointer _data)
{
	FolksNameDetailsChangeFullNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksNameDetailsChangeFullNameData, _data_);
}

static void
folks_name_details_real_change_full_name (FolksNameDetails* self,
                                          const gchar* full_name,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	FolksNameDetailsChangeFullNameData* _data_;
	FolksNameDetails* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (full_name != NULL);
	_data_ = g_slice_new0 (FolksNameDetailsChangeFullNameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_name_details_real_change_full_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (full_name);
	_g_free0 (_data_->full_name);
	_data_->full_name = _tmp1_;
	folks_name_details_real_change_full_name_co (_data_);
}

static void
folks_name_details_real_change_full_name_finish (FolksNameDetails* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	FolksNameDetailsChangeFullNameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's full name.
   *
   * It's preferred to call this rather than setting
   * {@link NameDetails.full_name} directly, as this method gives error
   * notification and will only return once the name has been written to the
   * relevant backing store (or the operation's failed).
   *
   * @param full_name the full name (empty string to unset it)
   * @throws PropertyError if setting the full name failed
   * @since 0.6.2
   */
static gboolean
folks_name_details_real_change_full_name_co (FolksNameDetailsChangeFullNameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Full name is not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_name_details_change_full_name (FolksNameDetails* self,
                                     const gchar* full_name,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	FolksNameDetailsIface* _iface_;
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_full_name) {
		_iface_->change_full_name (self, full_name, _callback_, _user_data_);
	}
}

void
folks_name_details_change_full_name_finish (FolksNameDetails* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	FolksNameDetailsIface* _iface_;
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_full_name_finish) {
		_iface_->change_full_name_finish (self, _res_, error);
	}
}

static void
folks_name_details_real_change_nickname_data_free (gpointer _data)
{
	FolksNameDetailsChangeNicknameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->nickname);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksNameDetailsChangeNicknameData, _data_);
}

static void
folks_name_details_real_change_nickname (FolksNameDetails* self,
                                         const gchar* nickname,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	FolksNameDetailsChangeNicknameData* _data_;
	FolksNameDetails* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (nickname != NULL);
	_data_ = g_slice_new0 (FolksNameDetailsChangeNicknameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_name_details_real_change_nickname_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (nickname);
	_g_free0 (_data_->nickname);
	_data_->nickname = _tmp1_;
	folks_name_details_real_change_nickname_co (_data_);
}

static void
folks_name_details_real_change_nickname_finish (FolksNameDetails* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	FolksNameDetailsChangeNicknameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Change the contact's nickname.
   *
   * It's preferred to call this rather than setting
   * {@link NameDetails.nickname} directly, as this method gives error
   * notification and will only return once the name has been written to the
   * relevant backing store (or the operation's failed).
   *
   * @param nickname the nickname (empty string to unset it)
   * @throws PropertyError if setting the nickname failed
   * @since 0.6.2
   */
static gboolean
folks_name_details_real_change_nickname_co (FolksNameDetailsChangeNicknameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _ ("Nickname is not writeable on this contact."));
	_data_->_inner_error0_ = _data_->_tmp0_;
	if (_data_->_inner_error0_->domain == FOLKS_PROPERTY_ERROR) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
folks_name_details_change_nickname (FolksNameDetails* self,
                                    const gchar* nickname,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	FolksNameDetailsIface* _iface_;
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_nickname) {
		_iface_->change_nickname (self, nickname, _callback_, _user_data_);
	}
}

void
folks_name_details_change_nickname_finish (FolksNameDetails* self,
                                           GAsyncResult* _res_,
                                           GError** error)
{
	FolksNameDetailsIface* _iface_;
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->change_nickname_finish) {
		_iface_->change_nickname_finish (self, _res_, error);
	}
}

FolksStructuredName*
folks_name_details_get_structured_name (FolksNameDetails* self)
{
	FolksNameDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_structured_name) {
		return _iface_->get_structured_name (self);
	}
	return NULL;
}

void
folks_name_details_set_structured_name (FolksNameDetails* self,
                                        FolksStructuredName* value)
{
	FolksNameDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_structured_name) {
		_iface_->set_structured_name (self, value);
	}
}

const gchar*
folks_name_details_get_full_name (FolksNameDetails* self)
{
	FolksNameDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_full_name) {
		return _iface_->get_full_name (self);
	}
	return NULL;
}

void
folks_name_details_set_full_name (FolksNameDetails* self,
                                  const gchar* value)
{
	FolksNameDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_full_name) {
		_iface_->set_full_name (self, value);
	}
}

const gchar*
folks_name_details_get_nickname (FolksNameDetails* self)
{
	FolksNameDetailsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->get_nickname) {
		return _iface_->get_nickname (self);
	}
	return NULL;
}

void
folks_name_details_set_nickname (FolksNameDetails* self,
                                 const gchar* value)
{
	FolksNameDetailsIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = FOLKS_NAME_DETAILS_GET_INTERFACE (self);
	if (_iface_->set_nickname) {
		_iface_->set_nickname (self, value);
	}
}

static void
folks_name_details_default_init (FolksNameDetailsIface * iface,
                                 gpointer iface_data)
{
	/**
	   * The contact name split in its constituent parts.
	   *
	   * Note that most of the time the structured name is not set (i.e.
	   * it's ``null``) or just some of the components are set.
	   * The components are immutable. To get notification of changes of
	   * the structured name, you just have to connect to the ``notify`` signal
	   * of this property.
	   *
	   * @since 0.3.5
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The full name of the contact.
	   *
	   * The full name is the name of the contact written in the way the contact
	   * prefers. For instance for English names this is usually the given name
	   * followed by the family name, but Chinese names are usually the family
	   * name followed by the given name.
	   * The full name could or could not contain additional names (like a
	   * middle name), prefixes or suffixes.
	   *
	   * The full name must not be ``null``: the empty string represents an unset
	   * full name.
	   *
	   * @since 0.3.5
	   */
	g_object_interface_install_property (iface, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The nickname of the contact.
	   *
	   * The nickname is the name that the contact chose for himself. This is
	   * different from {@link AliasDetails.alias} as aliases can be chosen by
	   * the user and not by the contacts themselves.
	   *
	   * Consequently, setting the nickname only makes sense in the context of an
	   * address book when updating the information a contact has specified about
	   * themselves.
	   *
	   * The nickname must not be ``null``: the empty string represents an unset
	   * nickname.
	   *
	   * @since 0.3.5
	   */
	g_object_interface_install_property (iface, g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	iface->change_structured_name = folks_name_details_real_change_structured_name;
	iface->change_structured_name_finish = folks_name_details_real_change_structured_name_finish;
	iface->change_full_name = folks_name_details_real_change_full_name;
	iface->change_full_name_finish = folks_name_details_real_change_full_name_finish;
	iface->change_nickname = folks_name_details_real_change_nickname;
	iface->change_nickname_finish = folks_name_details_real_change_nickname_finish;
}

/**
 * Interface for classes which represent contacts with names, such as
 * {@link Persona} and {@link Individual}.
 *
 * @since 0.3.5
 */
static GType
folks_name_details_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksNameDetailsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_name_details_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType folks_name_details_type_id;
	folks_name_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksNameDetails", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (folks_name_details_type_id, G_TYPE_OBJECT);
	return folks_name_details_type_id;
}

GType
folks_name_details_get_type (void)
{
	static volatile gsize folks_name_details_type_id__once = 0;
	if (g_once_init_enter (&folks_name_details_type_id__once)) {
		GType folks_name_details_type_id;
		folks_name_details_type_id = folks_name_details_get_type_once ();
		g_once_init_leave (&folks_name_details_type_id__once, folks_name_details_type_id);
	}
	return folks_name_details_type_id__once;
}

