/* A packrat parser generated by PackCC 1.8.0 */

#include "general.h"

#ifdef _MSC_VER
#undef _CRT_SECURE_NO_WARNINGS
#define _CRT_SECURE_NO_WARNINGS
#endif /* _MSC_VER */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef _MSC_VER
#if defined __GNUC__ && defined _WIN32 /* MinGW */
#ifndef PCC_USE_SYSTEM_STRNLEN
#define strnlen(str, maxlen) pcc_strnlen(str, maxlen)
static size_t pcc_strnlen(const char *str, size_t maxlen) {
    size_t i;
    for (i = 0; i < maxlen && str[i]; i++);
    return i;
}
#endif /* !PCC_USE_SYSTEM_STRNLEN */
#endif /* defined __GNUC__ && defined _WIN32 */
#endif /* !_MSC_VER */

#include "./peg/toml.h"

#include "toml_pre.h"
#if !defined __has_attribute || defined _MSC_VER
#define __attribute__(x)
#endif

#ifdef _MSC_VER
#define MARK_FUNC_AS_USED __pragma(warning(suppress:4505))
#else
#define MARK_FUNC_AS_USED __attribute__((__unused__))
#endif

#ifdef _MSC_VER
#define MARK_VAR_AS_USED __pragma(warning(suppress:4189))
#else
#define MARK_VAR_AS_USED __attribute__((__unused__))
#endif

#ifndef PCC_BUFFER_MIN_SIZE
#define PCC_BUFFER_MIN_SIZE 256
#endif /* !PCC_BUFFER_MIN_SIZE */

#ifndef PCC_ARRAY_MIN_SIZE
#define PCC_ARRAY_MIN_SIZE 2
#endif /* !PCC_ARRAY_MIN_SIZE */

#ifndef PCC_POOL_MIN_SIZE
#define PCC_POOL_MIN_SIZE 65536
#endif /* !PCC_POOL_MIN_SIZE */

#define PCC_DBG_EVALUATE 0
#define PCC_DBG_MATCH    1
#define PCC_DBG_NOMATCH  2

#define PCC_VOID_VALUE (~(size_t)0)

typedef enum pcc_bool_tag {
    PCC_FALSE = 0,
    PCC_TRUE
} pcc_bool_t;

typedef struct pcc_char_array_tag {
    char *buf;
    size_t max;
    size_t len;
} pcc_char_array_t;

typedef struct pcc_range_tag {
    size_t start;
    size_t end;
} pcc_range_t;

typedef int pcc_value_t;

typedef struct parserCtx *pcc_auxil_t;

typedef ptoml_context_t pcc_context_t;

typedef struct pcc_value_table_tag {
    pcc_value_t *buf;
    size_t max;
    size_t len;
} pcc_value_table_t;

typedef struct pcc_value_refer_table_tag {
    pcc_value_t **buf;
    size_t max;
    size_t len;
} pcc_value_refer_table_t;

typedef struct pcc_capture_tag {
    pcc_range_t range;
    char *string; /* mutable */
} pcc_capture_t;

typedef struct pcc_capture_table_tag {
    pcc_capture_t *buf;
    size_t max;
    size_t len;
} pcc_capture_table_t;

typedef struct pcc_capture_const_table_tag {
    const pcc_capture_t **buf;
    size_t max;
    size_t len;
} pcc_capture_const_table_t;

typedef struct pcc_thunk_tag pcc_thunk_t;
typedef struct pcc_thunk_array_tag pcc_thunk_array_t;

typedef void (*pcc_action_t)(pcc_context_t *, pcc_thunk_t *, pcc_value_t *);

typedef enum pcc_thunk_type_tag {
    PCC_THUNK_LEAF,
    PCC_THUNK_NODE
} pcc_thunk_type_t;

typedef struct pcc_thunk_leaf_tag {
    pcc_value_refer_table_t values;
    pcc_capture_const_table_t capts;
    pcc_capture_t capt0;
    pcc_action_t action;
} pcc_thunk_leaf_t;

typedef struct pcc_thunk_node_tag {
    const pcc_thunk_array_t *thunks; /* just a reference */
    pcc_value_t *value; /* just a reference */
} pcc_thunk_node_t;

typedef union pcc_thunk_data_tag {
    pcc_thunk_leaf_t leaf;
    pcc_thunk_node_t node;
} pcc_thunk_data_t;

struct pcc_thunk_tag {
    pcc_thunk_type_t type;
    pcc_thunk_data_t data;
};

struct pcc_thunk_array_tag {
    pcc_thunk_t **buf;
    size_t max;
    size_t len;
};

typedef struct pcc_thunk_chunk_tag {
    pcc_value_table_t values;
    pcc_capture_table_t capts;
    pcc_thunk_array_t thunks;
    size_t pos; /* the starting position in the character buffer */
} pcc_thunk_chunk_t;

typedef struct pcc_lr_entry_tag pcc_lr_entry_t;

typedef enum pcc_lr_answer_type_tag {
    PCC_LR_ANSWER_LR,
    PCC_LR_ANSWER_CHUNK
} pcc_lr_answer_type_t;

typedef union pcc_lr_answer_data_tag {
    pcc_lr_entry_t *lr;
    pcc_thunk_chunk_t *chunk;
} pcc_lr_answer_data_t;

typedef struct pcc_lr_answer_tag pcc_lr_answer_t;

struct pcc_lr_answer_tag {
    pcc_lr_answer_type_t type;
    pcc_lr_answer_data_t data;
    size_t pos; /* the absolute position in the input */
    pcc_lr_answer_t *hold;
};

typedef pcc_thunk_chunk_t *(*pcc_rule_t)(pcc_context_t *);

typedef struct pcc_rule_set_tag {
    pcc_rule_t *buf;
    size_t max;
    size_t len;
} pcc_rule_set_t;

typedef struct pcc_lr_head_tag pcc_lr_head_t;

struct pcc_lr_head_tag {
    pcc_rule_t rule;
    pcc_rule_set_t invol;
    pcc_rule_set_t eval;
    pcc_lr_head_t *hold;
};

typedef struct pcc_lr_memo_tag {
    pcc_rule_t rule;
    pcc_lr_answer_t *answer;
} pcc_lr_memo_t;

typedef struct pcc_lr_memo_map_tag {
    pcc_lr_memo_t *buf;
    size_t max;
    size_t len;
} pcc_lr_memo_map_t;

typedef struct pcc_lr_table_entry_tag {
    pcc_lr_head_t *head; /* just a reference */
    pcc_lr_memo_map_t memos;
    pcc_lr_answer_t *hold_a;
    pcc_lr_head_t *hold_h;
} pcc_lr_table_entry_t;

typedef struct pcc_lr_table_tag {
    pcc_lr_table_entry_t **buf;
    size_t max;
    size_t len;
    size_t ofs;
} pcc_lr_table_t;

struct pcc_lr_entry_tag {
    pcc_rule_t rule;
    pcc_thunk_chunk_t *seed; /* just a reference */
    pcc_lr_head_t *head; /* just a reference */
};

typedef struct pcc_lr_stack_tag {
    pcc_lr_entry_t **buf;
    size_t max;
    size_t len;
} pcc_lr_stack_t;

typedef struct pcc_memory_entry_tag pcc_memory_entry_t;
typedef struct pcc_memory_pool_tag pcc_memory_pool_t;

struct pcc_memory_entry_tag {
    pcc_memory_entry_t *next;
};

struct pcc_memory_pool_tag {
    pcc_memory_pool_t *next;
    size_t allocated;
    size_t unused;
};

typedef struct pcc_memory_recycler_tag {
    pcc_memory_pool_t *pool_list;
    pcc_memory_entry_t *entry_list;
    size_t element_size;
} pcc_memory_recycler_t;

struct ptoml_context_tag {
    size_t pos; /* the position in the input of the first character currently buffered */
    size_t cur; /* the current parsing position in the character buffer */
    size_t level;
    pcc_char_array_t buffer;
    pcc_lr_table_t lrtable;
    pcc_lr_stack_t lrstack;
    pcc_thunk_array_t thunks;
    pcc_auxil_t auxil;
    pcc_memory_recycler_t thunk_chunk_recycler;
    pcc_memory_recycler_t lr_head_recycler;
    pcc_memory_recycler_t lr_answer_recycler;
};

#ifndef PCC_ERROR
#define PCC_ERROR(auxil) pcc_error()
MARK_FUNC_AS_USED
static void pcc_error(void) {
    fprintf(stderr, "Syntax error\n");
    exit(1);
}
#endif /* !PCC_ERROR */

#ifndef PCC_GETCHAR
#define PCC_GETCHAR(auxil) getchar()
#endif /* !PCC_GETCHAR */

#ifndef PCC_MALLOC
#define PCC_MALLOC(auxil, size) pcc_malloc_e(size)
static void *pcc_malloc_e(size_t size) {
    void *const p = malloc(size);
    if (p == NULL) {
        fprintf(stderr, "Out of memory\n");
        exit(1);
    }
    return p;
}
#endif /* !PCC_MALLOC */

#ifndef PCC_REALLOC
#define PCC_REALLOC(auxil, ptr, size) pcc_realloc_e(ptr, size)
static void *pcc_realloc_e(void *ptr, size_t size) {
    void *const p = realloc(ptr, size);
    if (p == NULL) {
        fprintf(stderr, "Out of memory\n");
        exit(1);
    }
    return p;
}
#endif /* !PCC_REALLOC */

#ifndef PCC_FREE
#define PCC_FREE(auxil, ptr) free(ptr)
#endif /* !PCC_FREE */

#ifndef PCC_DEBUG
#define PCC_DEBUG(auxil, event, rule, level, pos, buffer, length) ((void)0)
#endif /* !PCC_DEBUG */

static char *pcc_strndup_e(pcc_auxil_t auxil, const char *str, size_t len) {
    const size_t m = strnlen(str, len);
    char *const s = (char *)PCC_MALLOC(auxil, m + 1);
    memcpy(s, str, m);
    s[m] = '\0';
    return s;
}

static void pcc_char_array__init(pcc_auxil_t auxil, pcc_char_array_t *array) {
    array->len = 0;
    array->max = 0;
    array->buf = NULL;
}

static void pcc_char_array__add(pcc_auxil_t auxil, pcc_char_array_t *array, char ch) {
    if (array->max <= array->len) {
        const size_t n = array->len + 1;
        size_t m = array->max;
        if (m == 0) m = PCC_BUFFER_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        array->buf = (char *)PCC_REALLOC(auxil, array->buf, m);
        array->max = m;
    }
    array->buf[array->len++] = ch;
}

static void pcc_char_array__term(pcc_auxil_t auxil, pcc_char_array_t *array) {
    PCC_FREE(auxil, array->buf);
}

static void pcc_value_table__init(pcc_auxil_t auxil, pcc_value_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

MARK_FUNC_AS_USED
static void pcc_value_table__resize(pcc_auxil_t auxil, pcc_value_table_t *table, size_t len) {
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_value_t *)PCC_REALLOC(auxil, table->buf, sizeof(pcc_value_t) * m);
        table->max = m;
    }
    table->len = len;
}

MARK_FUNC_AS_USED
static void pcc_value_table__clear(pcc_auxil_t auxil, pcc_value_table_t *table) {
    memset(table->buf, 0, sizeof(pcc_value_t) * table->len);
}

static void pcc_value_table__term(pcc_auxil_t auxil, pcc_value_table_t *table) {
    PCC_FREE(auxil, table->buf);
}

static void pcc_value_refer_table__init(pcc_auxil_t auxil, pcc_value_refer_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_value_refer_table__resize(pcc_auxil_t auxil, pcc_value_refer_table_t *table, size_t len) {
    size_t i;
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_value_t **)PCC_REALLOC(auxil, table->buf, sizeof(pcc_value_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_value_refer_table__term(pcc_auxil_t auxil, pcc_value_refer_table_t *table) {
    PCC_FREE(auxil, table->buf);
}

static void pcc_capture_table__init(pcc_auxil_t auxil, pcc_capture_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

MARK_FUNC_AS_USED
static void pcc_capture_table__resize(pcc_auxil_t auxil, pcc_capture_table_t *table, size_t len) {
    size_t i;
    for (i = len; i < table->len; i++) PCC_FREE(auxil, table->buf[i].string);
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_capture_t *)PCC_REALLOC(auxil, table->buf, sizeof(pcc_capture_t) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) {
        table->buf[i].range.start = 0;
        table->buf[i].range.end = 0;
        table->buf[i].string = NULL;
    }
    table->len = len;
}

static void pcc_capture_table__term(pcc_auxil_t auxil, pcc_capture_table_t *table) {
    while (table->len > 0) {
        table->len--;
        PCC_FREE(auxil, table->buf[table->len].string);
    }
    PCC_FREE(auxil, table->buf);
}

static void pcc_capture_const_table__init(pcc_auxil_t auxil, pcc_capture_const_table_t *table) {
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_capture_const_table__resize(pcc_auxil_t auxil, pcc_capture_const_table_t *table, size_t len) {
    size_t i;
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (const pcc_capture_t **)PCC_REALLOC(auxil, (pcc_capture_t **)table->buf, sizeof(const pcc_capture_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_capture_const_table__term(pcc_auxil_t auxil, pcc_capture_const_table_t *table) {
    PCC_FREE(auxil, (void *)table->buf);
}

MARK_FUNC_AS_USED
static pcc_thunk_t *pcc_thunk__create_leaf(pcc_auxil_t auxil, pcc_action_t action, size_t valuec, size_t captc) {
    pcc_thunk_t *const thunk = (pcc_thunk_t *)PCC_MALLOC(auxil, sizeof(pcc_thunk_t));
    thunk->type = PCC_THUNK_LEAF;
    pcc_value_refer_table__init(auxil, &thunk->data.leaf.values);
    pcc_value_refer_table__resize(auxil, &thunk->data.leaf.values, valuec);
    pcc_capture_const_table__init(auxil, &thunk->data.leaf.capts);
    pcc_capture_const_table__resize(auxil, &thunk->data.leaf.capts, captc);
    thunk->data.leaf.capt0.range.start = 0;
    thunk->data.leaf.capt0.range.end = 0;
    thunk->data.leaf.capt0.string = NULL;
    thunk->data.leaf.action = action;
    return thunk;
}

static pcc_thunk_t *pcc_thunk__create_node(pcc_auxil_t auxil, const pcc_thunk_array_t *thunks, pcc_value_t *value) {
    pcc_thunk_t *const thunk = (pcc_thunk_t *)PCC_MALLOC(auxil, sizeof(pcc_thunk_t));
    thunk->type = PCC_THUNK_NODE;
    thunk->data.node.thunks = thunks;
    thunk->data.node.value = value;
    return thunk;
}

static void pcc_thunk__destroy(pcc_auxil_t auxil, pcc_thunk_t *thunk) {
    if (thunk == NULL) return;
    switch (thunk->type) {
    case PCC_THUNK_LEAF:
        PCC_FREE(auxil, thunk->data.leaf.capt0.string);
        pcc_capture_const_table__term(auxil, &thunk->data.leaf.capts);
        pcc_value_refer_table__term(auxil, &thunk->data.leaf.values);
        break;
    case PCC_THUNK_NODE:
        break;
    default: /* unknown */
        break;
    }
    PCC_FREE(auxil, thunk);
}

static void pcc_thunk_array__init(pcc_auxil_t auxil, pcc_thunk_array_t *array) {
    array->len = 0;
    array->max = 0;
    array->buf = NULL;
}

static void pcc_thunk_array__add(pcc_auxil_t auxil, pcc_thunk_array_t *array, pcc_thunk_t *thunk) {
    if (array->max <= array->len) {
        const size_t n = array->len + 1;
        size_t m = array->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        array->buf = (pcc_thunk_t **)PCC_REALLOC(auxil, array->buf, sizeof(pcc_thunk_t *) * m);
        array->max = m;
    }
    array->buf[array->len++] = thunk;
}

static void pcc_thunk_array__revert(pcc_auxil_t auxil, pcc_thunk_array_t *array, size_t len) {
    while (array->len > len) {
        array->len--;
        pcc_thunk__destroy(auxil, array->buf[array->len]);
    }
}

static void pcc_thunk_array__term(pcc_auxil_t auxil, pcc_thunk_array_t *array) {
    while (array->len > 0) {
        array->len--;
        pcc_thunk__destroy(auxil, array->buf[array->len]);
    }
    PCC_FREE(auxil, array->buf);
}

static void pcc_memory_recycler__init(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler, size_t element_size) {
    recycler->pool_list = NULL;
    recycler->entry_list = NULL;
    recycler->element_size = element_size;
}

static void *pcc_memory_recycler__supply(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler) {
    if (recycler->entry_list) {
        pcc_memory_entry_t *const tmp = recycler->entry_list;
        recycler->entry_list = tmp->next;
        return tmp;
    }
    if (!recycler->pool_list || recycler->pool_list->unused == 0) {
        size_t size = PCC_POOL_MIN_SIZE;
        if (recycler->pool_list) {
            size = recycler->pool_list->allocated << 1;
            if (size == 0) size = recycler->pool_list->allocated;
        }
        {
            pcc_memory_pool_t *const pool = (pcc_memory_pool_t *)PCC_MALLOC(
                auxil, sizeof(pcc_memory_pool_t) + recycler->element_size * size
            );
            pool->allocated = size;
            pool->unused = size;
            pool->next = recycler->pool_list;
            recycler->pool_list = pool;
        }
    }
    recycler->pool_list->unused--;
    return (char *)recycler->pool_list + sizeof(pcc_memory_pool_t) + recycler->element_size * recycler->pool_list->unused;
}

static void pcc_memory_recycler__recycle(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler, void *ptr) {
    pcc_memory_entry_t *const tmp = (pcc_memory_entry_t *)ptr;
    tmp->next = recycler->entry_list;
    recycler->entry_list = tmp;
}

static void pcc_memory_recycler__term(pcc_auxil_t auxil, pcc_memory_recycler_t *recycler) {
    while (recycler->pool_list) {
        pcc_memory_pool_t *const tmp = recycler->pool_list;
        recycler->pool_list = tmp->next;
        PCC_FREE(auxil, tmp);
    }
}

MARK_FUNC_AS_USED
static pcc_thunk_chunk_t *pcc_thunk_chunk__create(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = (pcc_thunk_chunk_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->thunk_chunk_recycler);
    pcc_value_table__init(ctx->auxil, &chunk->values);
    pcc_capture_table__init(ctx->auxil, &chunk->capts);
    pcc_thunk_array__init(ctx->auxil, &chunk->thunks);
    chunk->pos = 0;
    return chunk;
}

static void pcc_thunk_chunk__destroy(pcc_context_t *ctx, pcc_thunk_chunk_t *chunk) {
    if (chunk == NULL) return;
    pcc_thunk_array__term(ctx->auxil, &chunk->thunks);
    pcc_capture_table__term(ctx->auxil, &chunk->capts);
    pcc_value_table__term(ctx->auxil, &chunk->values);
    pcc_memory_recycler__recycle(ctx->auxil, &ctx->thunk_chunk_recycler, chunk);
}

static void pcc_rule_set__init(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    set->len = 0;
    set->max = 0;
    set->buf = NULL;
}

static size_t pcc_rule_set__index(pcc_auxil_t auxil, const pcc_rule_set_t *set, pcc_rule_t rule) {
    size_t i;
    for (i = 0; i < set->len; i++) {
        if (set->buf[i] == rule) return i;
    }
    return PCC_VOID_VALUE;
}

static pcc_bool_t pcc_rule_set__add(pcc_auxil_t auxil, pcc_rule_set_t *set, pcc_rule_t rule) {
    const size_t i = pcc_rule_set__index(auxil, set, rule);
    if (i != PCC_VOID_VALUE) return PCC_FALSE;
    if (set->max <= set->len) {
        const size_t n = set->len + 1;
        size_t m = set->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        set->buf = (pcc_rule_t *)PCC_REALLOC(auxil, set->buf, sizeof(pcc_rule_t) * m);
        set->max = m;
    }
    set->buf[set->len++] = rule;
    return PCC_TRUE;
}

static pcc_bool_t pcc_rule_set__remove(pcc_auxil_t auxil, pcc_rule_set_t *set, pcc_rule_t rule) {
    const size_t i = pcc_rule_set__index(auxil, set, rule);
    if (i == PCC_VOID_VALUE) return PCC_FALSE;
    memmove(set->buf + i, set->buf + (i + 1), sizeof(pcc_rule_t) * (set->len - (i + 1)));
    return PCC_TRUE;
}

static void pcc_rule_set__clear(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    set->len = 0;
}

static void pcc_rule_set__copy(pcc_auxil_t auxil, pcc_rule_set_t *set, const pcc_rule_set_t *src) {
    size_t i;
    pcc_rule_set__clear(auxil, set);
    for (i = 0; i < src->len; i++) {
        pcc_rule_set__add(auxil, set, src->buf[i]);
    }
}

static void pcc_rule_set__term(pcc_auxil_t auxil, pcc_rule_set_t *set) {
    PCC_FREE(auxil, set->buf);
}

static pcc_lr_head_t *pcc_lr_head__create(pcc_context_t *ctx, pcc_rule_t rule) {
    pcc_lr_head_t *const head = (pcc_lr_head_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->lr_head_recycler);
    head->rule = rule;
    pcc_rule_set__init(ctx->auxil, &head->invol);
    pcc_rule_set__init(ctx->auxil, &head->eval);
    head->hold = NULL;
    return head;
}

static void pcc_lr_head__destroy(pcc_context_t *ctx, pcc_lr_head_t *head) {
    if (head == NULL) return;
    pcc_lr_head__destroy(ctx, head->hold);
    pcc_rule_set__term(ctx->auxil, &head->eval);
    pcc_rule_set__term(ctx->auxil, &head->invol);
    pcc_memory_recycler__recycle(ctx->auxil, &ctx->lr_head_recycler, head);
}

static void pcc_lr_entry__destroy(pcc_auxil_t auxil, pcc_lr_entry_t *lr);

static pcc_lr_answer_t *pcc_lr_answer__create(pcc_context_t *ctx, pcc_lr_answer_type_t type, size_t pos) {
    pcc_lr_answer_t *answer = (pcc_lr_answer_t *)pcc_memory_recycler__supply(ctx->auxil, &ctx->lr_answer_recycler);
    answer->type = type;
    answer->pos = pos;
    answer->hold = NULL;
    switch (answer->type) {
    case PCC_LR_ANSWER_LR:
        answer->data.lr = NULL;
        break;
    case PCC_LR_ANSWER_CHUNK:
        answer->data.chunk = NULL;
        break;
    default: /* unknown */
        PCC_FREE(ctx->auxil, answer);
        answer = NULL;
    }
    return answer;
}

static void pcc_lr_answer__set_chunk(pcc_context_t *ctx, pcc_lr_answer_t *answer, pcc_thunk_chunk_t *chunk) {
    pcc_lr_answer_t *const a = pcc_lr_answer__create(ctx, answer->type, answer->pos);
    switch (answer->type) {
    case PCC_LR_ANSWER_LR:
        a->data.lr = answer->data.lr;
        break;
    case PCC_LR_ANSWER_CHUNK:
        a->data.chunk = answer->data.chunk;
        break;
    default: /* unknown */
        break;
    }
    a->hold = answer->hold;
    answer->hold = a;
    answer->type = PCC_LR_ANSWER_CHUNK;
    answer->data.chunk = chunk;
}

static void pcc_lr_answer__destroy(pcc_context_t *ctx, pcc_lr_answer_t *answer) {
    while (answer != NULL) {
        pcc_lr_answer_t *const a = answer->hold;
        switch (answer->type) {
        case PCC_LR_ANSWER_LR:
            pcc_lr_entry__destroy(ctx->auxil, answer->data.lr);
            break;
        case PCC_LR_ANSWER_CHUNK:
            pcc_thunk_chunk__destroy(ctx, answer->data.chunk);
            break;
        default: /* unknown */
            break;
        }
        pcc_memory_recycler__recycle(ctx->auxil, &ctx->lr_answer_recycler, answer);
        answer = a;
    }
}

static void pcc_lr_memo_map__init(pcc_auxil_t auxil, pcc_lr_memo_map_t *map) {
    map->len = 0;
    map->max = 0;
    map->buf = NULL;
}

static size_t pcc_lr_memo_map__index(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule) {
    size_t i;
    for (i = 0; i < map->len; i++) {
        if (map->buf[i].rule == rule) return i;
    }
    return PCC_VOID_VALUE;
}

static void pcc_lr_memo_map__put(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule, pcc_lr_answer_t *answer) {
    const size_t i = pcc_lr_memo_map__index(ctx, map, rule);
    if (i != PCC_VOID_VALUE) {
        pcc_lr_answer__destroy(ctx, map->buf[i].answer);
        map->buf[i].answer = answer;
    }
    else {
        if (map->max <= map->len) {
            const size_t n = map->len + 1;
            size_t m = map->max;
            if (m == 0) m = PCC_ARRAY_MIN_SIZE;
            while (m < n && m != 0) m <<= 1;
            if (m == 0) m = n;
            map->buf = (pcc_lr_memo_t *)PCC_REALLOC(ctx->auxil, map->buf, sizeof(pcc_lr_memo_t) * m);
            map->max = m;
        }
        map->buf[map->len].rule = rule;
        map->buf[map->len].answer = answer;
        map->len++;
    }
}

static pcc_lr_answer_t *pcc_lr_memo_map__get(pcc_context_t *ctx, pcc_lr_memo_map_t *map, pcc_rule_t rule) {
    const size_t i = pcc_lr_memo_map__index(ctx, map, rule);
    return (i != PCC_VOID_VALUE) ? map->buf[i].answer : NULL;
}

static void pcc_lr_memo_map__term(pcc_context_t *ctx, pcc_lr_memo_map_t *map) {
    while (map->len > 0) {
        map->len--;
        pcc_lr_answer__destroy(ctx, map->buf[map->len].answer);
    }
    PCC_FREE(ctx->auxil, map->buf);
}

static pcc_lr_table_entry_t *pcc_lr_table_entry__create(pcc_context_t *ctx) {
    pcc_lr_table_entry_t *const entry = (pcc_lr_table_entry_t *)PCC_MALLOC(ctx->auxil, sizeof(pcc_lr_table_entry_t));
    entry->head = NULL;
    pcc_lr_memo_map__init(ctx->auxil, &entry->memos);
    entry->hold_a = NULL;
    entry->hold_h = NULL;
    return entry;
}

static void pcc_lr_table_entry__destroy(pcc_context_t *ctx, pcc_lr_table_entry_t *entry) {
    if (entry == NULL) return;
    pcc_lr_head__destroy(ctx, entry->hold_h);
    pcc_lr_answer__destroy(ctx, entry->hold_a);
    pcc_lr_memo_map__term(ctx, &entry->memos);
    PCC_FREE(ctx->auxil, entry);
}

static void pcc_lr_table__init(pcc_auxil_t auxil, pcc_lr_table_t *table) {
    table->ofs = 0;
    table->len = 0;
    table->max = 0;
    table->buf = NULL;
}

static void pcc_lr_table__resize(pcc_context_t *ctx, pcc_lr_table_t *table, size_t len) {
    size_t i;
    for (i = len; i < table->len; i++) pcc_lr_table_entry__destroy(ctx, table->buf[i]);
    if (table->max < len) {
        size_t m = table->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < len && m != 0) m <<= 1;
        if (m == 0) m = len;
        table->buf = (pcc_lr_table_entry_t **)PCC_REALLOC(ctx->auxil, table->buf, sizeof(pcc_lr_table_entry_t *) * m);
        table->max = m;
    }
    for (i = table->len; i < len; i++) table->buf[i] = NULL;
    table->len = len;
}

static void pcc_lr_table__set_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_head_t *head) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    table->buf[index]->head = head;
}

static void pcc_lr_table__hold_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_head_t *head) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    head->hold = table->buf[index]->hold_h;
    table->buf[index]->hold_h = head;
}

static void pcc_lr_table__set_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_rule_t rule, pcc_lr_answer_t *answer) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    pcc_lr_memo_map__put(ctx, &table->buf[index]->memos, rule, answer);
}

static void pcc_lr_table__hold_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_lr_answer_t *answer) {
    index += table->ofs;
    if (index >= table->len) pcc_lr_table__resize(ctx, table, index + 1);
    if (table->buf[index] == NULL) table->buf[index] = pcc_lr_table_entry__create(ctx);
    answer->hold = table->buf[index]->hold_a;
    table->buf[index]->hold_a = answer;
}

static pcc_lr_head_t *pcc_lr_table__get_head(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index) {
    index += table->ofs;
    if (index >= table->len || table->buf[index] == NULL) return NULL;
    return table->buf[index]->head;
}

static pcc_lr_answer_t *pcc_lr_table__get_answer(pcc_context_t *ctx, pcc_lr_table_t *table, size_t index, pcc_rule_t rule) {
    index += table->ofs;
    if (index >= table->len || table->buf[index] == NULL) return NULL;
    return pcc_lr_memo_map__get(ctx, &table->buf[index]->memos, rule);
}

static void pcc_lr_table__shift(pcc_context_t *ctx, pcc_lr_table_t *table, size_t count) {
    size_t i;
    if (count > table->len - table->ofs) count = table->len - table->ofs;
    for (i = 0; i < count; i++) pcc_lr_table_entry__destroy(ctx, table->buf[table->ofs++]);
    if (table->ofs > (table->max >> 1)) {
        memmove(table->buf, table->buf + table->ofs, sizeof(pcc_lr_table_entry_t *) * (table->len - table->ofs));
        table->len -= table->ofs;
        table->ofs = 0;
    }
}

static void pcc_lr_table__term(pcc_context_t *ctx, pcc_lr_table_t *table) {
    while (table->len > table->ofs) {
        table->len--;
        pcc_lr_table_entry__destroy(ctx, table->buf[table->len]);
    }
    PCC_FREE(ctx->auxil, table->buf);
}

static pcc_lr_entry_t *pcc_lr_entry__create(pcc_auxil_t auxil, pcc_rule_t rule) {
    pcc_lr_entry_t *const lr = (pcc_lr_entry_t *)PCC_MALLOC(auxil, sizeof(pcc_lr_entry_t));
    lr->rule = rule;
    lr->seed = NULL;
    lr->head = NULL;
    return lr;
}

static void pcc_lr_entry__destroy(pcc_auxil_t auxil, pcc_lr_entry_t *lr) {
    PCC_FREE(auxil, lr);
}

static void pcc_lr_stack__init(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    stack->len = 0;
    stack->max = 0;
    stack->buf = NULL;
}

static void pcc_lr_stack__push(pcc_auxil_t auxil, pcc_lr_stack_t *stack, pcc_lr_entry_t *lr) {
    if (stack->max <= stack->len) {
        const size_t n = stack->len + 1;
        size_t m = stack->max;
        if (m == 0) m = PCC_ARRAY_MIN_SIZE;
        while (m < n && m != 0) m <<= 1;
        if (m == 0) m = n;
        stack->buf = (pcc_lr_entry_t **)PCC_REALLOC(auxil, stack->buf, sizeof(pcc_lr_entry_t *) * m);
        stack->max = m;
    }
    stack->buf[stack->len++] = lr;
}

static pcc_lr_entry_t *pcc_lr_stack__pop(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    return stack->buf[--stack->len];
}

static void pcc_lr_stack__term(pcc_auxil_t auxil, pcc_lr_stack_t *stack) {
    PCC_FREE(auxil, stack->buf);
}

static pcc_context_t *pcc_context__create(pcc_auxil_t auxil) {
    pcc_context_t *const ctx = (pcc_context_t *)PCC_MALLOC(auxil, sizeof(pcc_context_t));
    ctx->pos = 0;
    ctx->cur = 0;
    ctx->level = 0;
    pcc_char_array__init(auxil, &ctx->buffer);
    pcc_lr_table__init(auxil, &ctx->lrtable);
    pcc_lr_stack__init(auxil, &ctx->lrstack);
    pcc_thunk_array__init(auxil, &ctx->thunks);
    pcc_memory_recycler__init(auxil, &ctx->thunk_chunk_recycler, sizeof(pcc_thunk_chunk_t));
    pcc_memory_recycler__init(auxil, &ctx->lr_head_recycler, sizeof(pcc_lr_head_t));
    pcc_memory_recycler__init(auxil, &ctx->lr_answer_recycler, sizeof(pcc_lr_answer_t));
    ctx->auxil = auxil;
    return ctx;
}

static void pcc_context__destroy(pcc_context_t *ctx) {
    if (ctx == NULL) return;
    pcc_thunk_array__term(ctx->auxil, &ctx->thunks);
    pcc_lr_stack__term(ctx->auxil, &ctx->lrstack);
    pcc_lr_table__term(ctx, &ctx->lrtable);
    pcc_char_array__term(ctx->auxil, &ctx->buffer);
    pcc_memory_recycler__term(ctx->auxil, &ctx->thunk_chunk_recycler);
    pcc_memory_recycler__term(ctx->auxil, &ctx->lr_head_recycler);
    pcc_memory_recycler__term(ctx->auxil, &ctx->lr_answer_recycler);
    PCC_FREE(ctx->auxil, ctx);
}

static size_t pcc_refill_buffer(pcc_context_t *ctx, size_t num) {
    if (ctx->buffer.len >= ctx->cur + num) return ctx->buffer.len - ctx->cur;
    while (ctx->buffer.len < ctx->cur + num) {
        const int c = PCC_GETCHAR(ctx->auxil);
        if (c < 0) break;
        pcc_char_array__add(ctx->auxil, &ctx->buffer, (char)c);
    }
    return ctx->buffer.len - ctx->cur;
}

MARK_FUNC_AS_USED
static void pcc_commit_buffer(pcc_context_t *ctx) {
    memmove(ctx->buffer.buf, ctx->buffer.buf + ctx->cur, ctx->buffer.len - ctx->cur);
    ctx->buffer.len -= ctx->cur;
    ctx->pos += ctx->cur;
    pcc_lr_table__shift(ctx, &ctx->lrtable, ctx->cur);
    ctx->cur = 0;
}

MARK_FUNC_AS_USED
static const char *pcc_get_capture_string(pcc_context_t *ctx, const pcc_capture_t *capt) {
    if (capt->string == NULL)
        ((pcc_capture_t *)capt)->string =
            pcc_strndup_e(ctx->auxil, ctx->buffer.buf + capt->range.start, capt->range.end - capt->range.start);
    return capt->string;
}

static size_t pcc_get_char_as_utf32(pcc_context_t *ctx, int *out) { /* with checking UTF-8 validity */
    int c, u;
    size_t n;
    if (pcc_refill_buffer(ctx, 1) < 1) return 0;
    c = (int)(unsigned char)ctx->buffer.buf[ctx->cur];
    n = (c < 0x80) ? 1 :
        ((c & 0xe0) == 0xc0) ? 2 :
        ((c & 0xf0) == 0xe0) ? 3 :
        ((c & 0xf8) == 0xf0) ? 4 : 0;
    if (n < 1) return 0;
    if (pcc_refill_buffer(ctx, n) < n) return 0;
    switch (n) {
    case 1:
        u = c;
        break;
    case 2:
        u = c & 0x1f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x80) return 0;
        break;
    case 3:
        u = c & 0x0f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 2];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x800) return 0;
        break;
    case 4:
        u = c & 0x07;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 1];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 2];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        c = (int)(unsigned char)ctx->buffer.buf[ctx->cur + 3];
        if ((c & 0xc0) != 0x80) return 0;
        u <<= 6; u |= c & 0x3f;
        if (u < 0x10000 || u > 0x10ffff) return 0;
        break;
    default:
        return 0;
    }
    if (out) *out = u;
    return n;
}

MARK_FUNC_AS_USED
static pcc_bool_t pcc_apply_rule(pcc_context_t *ctx, pcc_rule_t rule, pcc_thunk_array_t *thunks, pcc_value_t *value) {
    static pcc_value_t null;
    pcc_thunk_chunk_t *c = NULL;
    const size_t p = ctx->pos + ctx->cur;
    pcc_bool_t b = PCC_TRUE;
    pcc_lr_answer_t *a = pcc_lr_table__get_answer(ctx, &ctx->lrtable, p, rule);
    pcc_lr_head_t *h = pcc_lr_table__get_head(ctx, &ctx->lrtable, p);
    if (h != NULL) {
        if (a == NULL && rule != h->rule && pcc_rule_set__index(ctx->auxil, &h->invol, rule) == PCC_VOID_VALUE) {
            b = PCC_FALSE;
            c = NULL;
        }
        else if (pcc_rule_set__remove(ctx->auxil, &h->eval, rule)) {
            b = PCC_FALSE;
            c = rule(ctx);
            a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_CHUNK, ctx->pos + ctx->cur);
            a->data.chunk = c;
            pcc_lr_table__hold_answer(ctx, &ctx->lrtable, p, a);
        }
    }
    if (b) {
        if (a != NULL) {
            ctx->cur = a->pos - ctx->pos;
            switch (a->type) {
            case PCC_LR_ANSWER_LR:
                if (a->data.lr->head == NULL) {
                    a->data.lr->head = pcc_lr_head__create(ctx, rule);
                    pcc_lr_table__hold_head(ctx, &ctx->lrtable, p, a->data.lr->head);
                }
                {
                    size_t i = ctx->lrstack.len;
                    while (i > 0) {
                        i--;
                        if (ctx->lrstack.buf[i]->head == a->data.lr->head) break;
                        ctx->lrstack.buf[i]->head = a->data.lr->head;
                        pcc_rule_set__add(ctx->auxil, &a->data.lr->head->invol, ctx->lrstack.buf[i]->rule);
                    }
                }
                c = a->data.lr->seed;
                break;
            case PCC_LR_ANSWER_CHUNK:
                c = a->data.chunk;
                break;
            default: /* unknown */
                break;
            }
        }
        else {
            pcc_lr_entry_t *const e = pcc_lr_entry__create(ctx->auxil, rule);
            pcc_lr_stack__push(ctx->auxil, &ctx->lrstack, e);
            a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_LR, p);
            a->data.lr = e;
            pcc_lr_table__set_answer(ctx, &ctx->lrtable, p, rule, a);
            c = rule(ctx);
            pcc_lr_stack__pop(ctx->auxil, &ctx->lrstack);
            a->pos = ctx->pos + ctx->cur;
            if (e->head == NULL) {
                pcc_lr_answer__set_chunk(ctx, a, c);
            }
            else {
                e->seed = c;
                h = a->data.lr->head;
                if (h->rule != rule) {
                    c = a->data.lr->seed;
                    a = pcc_lr_answer__create(ctx, PCC_LR_ANSWER_CHUNK, ctx->pos + ctx->cur);
                    a->data.chunk = c;
                    pcc_lr_table__hold_answer(ctx, &ctx->lrtable, p, a);
                }
                else {
                    pcc_lr_answer__set_chunk(ctx, a, a->data.lr->seed);
                    if (a->data.chunk == NULL) {
                        c = NULL;
                    }
                    else {
                        pcc_lr_table__set_head(ctx, &ctx->lrtable, p, h);
                        for (;;) {
                            ctx->cur = p - ctx->pos;
                            pcc_rule_set__copy(ctx->auxil, &h->eval, &h->invol);
                            c = rule(ctx);
                            if (c == NULL || ctx->pos + ctx->cur <= a->pos) break;
                            pcc_lr_answer__set_chunk(ctx, a, c);
                            a->pos = ctx->pos + ctx->cur;
                        }
                        pcc_thunk_chunk__destroy(ctx, c);
                        pcc_lr_table__set_head(ctx, &ctx->lrtable, p, NULL);
                        ctx->cur = a->pos - ctx->pos;
                        c = a->data.chunk;
                    }
                }
            }
        }
    }
    if (c == NULL) return PCC_FALSE;
    if (value == NULL) value = &null;
    memset(value, 0, sizeof(pcc_value_t)); /* in case */
    pcc_thunk_array__add(ctx->auxil, thunks, pcc_thunk__create_node(ctx->auxil, &c->thunks, value));
    return PCC_TRUE;
}

MARK_FUNC_AS_USED
static void pcc_do_action(pcc_context_t *ctx, const pcc_thunk_array_t *thunks, pcc_value_t *value) {
    size_t i;
    for (i = 0; i < thunks->len; i++) {
        pcc_thunk_t *const thunk = thunks->buf[i];
        switch (thunk->type) {
        case PCC_THUNK_LEAF:
            thunk->data.leaf.action(ctx, thunk, value);
            break;
        case PCC_THUNK_NODE:
            pcc_do_action(ctx, thunk->data.node.thunks, thunk->data.node.value);
            break;
        default: /* unknown */
            break;
        }
    }
}

static void pcc_action_keyval_0(ptoml_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    keyvalStart(auxil, _0s);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_keyval_1(ptoml_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    keyvalKeyEnd(auxil);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_keyval_2(ptoml_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    keyvalValEnd(auxil);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_simpleKey_0(ptoml_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    queueKey (auxil, _0);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_val_0(ptoml_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
#define _1 pcc_get_capture_string(__pcc_ctx, __pcc_in->data.leaf.capts.buf[0])
#define _1s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.start))
#define _1e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capts.buf[0]->range.end))
    notifyValue(auxil, _0, _0s);
#undef _1e
#undef _1s
#undef _1
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_stdTable_0(ptoml_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    tableKeyStart(auxil, false, _0s);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_stdTable_1(ptoml_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    tableKeyEnd(auxil);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_arrayTable_0(ptoml_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    tableKeyStart(auxil, true, _0s);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static void pcc_action_arrayTable_1(ptoml_context_t *__pcc_ctx, pcc_thunk_t *__pcc_in, pcc_value_t *__pcc_out) {
#define auxil (__pcc_ctx->auxil)
#define __ (*__pcc_out)
#define _0 pcc_get_capture_string(__pcc_ctx, &__pcc_in->data.leaf.capt0)
#define _0s ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.start))
#define _0e ((const size_t)(__pcc_ctx->pos + __pcc_in->data.leaf.capt0.range.end))
    tableKeyEnd(auxil);
#undef _0e
#undef _0s
#undef _0
#undef __
#undef auxil
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_toml(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_expression(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ws(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_wschar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_newline(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_commentStartSymbol(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_nonAscii(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_nonEol(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_comment(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_keyval(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_key(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleKey(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_unquotedKey(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_quotedKey(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_dottedKey(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_dotSep(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_keyvalSep(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_val(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_string(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_basicString(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_quotationMark(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_basicChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_basicUnescaped(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_escaped(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_escape(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_escapeSeqChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mlBasicString(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mlBasicStringDelim(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mlBasicBody(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mlbContent(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mlbChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mlbQuotes(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mlbUnescaped(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mlbEscapedNl(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_literalString(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_apostrophe(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_literalChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mlLiteralString(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mlLiteralStringDelim(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mlLiteralBody(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mllContent(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mllChar(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_mllQuotes(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_integer(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_minus(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_plus(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_underscore(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_digit1_9(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_digit0_7(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_digit0_1(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_hexPrefix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_octPrefix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_binPrefix(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_decInt(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_unsignedDecInt(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_hexInt(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_octInt(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_binInt(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_float(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_floatIntPart(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_frac(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_decimalPoint(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_zeroPrefixableInt(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_exp(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_floatExpPart(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_specialFloat(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inf(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_nan(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_boolean(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_true(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_false(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_dateTime(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_dateFullyear(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_dateMonth(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_dateMday(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_timeDelim(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_timeHour(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_timeMinute(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_timeSecond(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_timeSecfrac(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_timeNumoffset(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_timeOffset(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_partialTime(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_fullDate(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_fullTime(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_offsetDateTime(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_localDateTime(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_localDate(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_localTime(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_array(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayOpen(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayClose(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayValues(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_arraySep(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_wsCommentNewline(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_table(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_stdTable(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_stdTableOpen(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_stdTableClose(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inlineTable(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inlineTableOpen(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inlineTableClose(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inlineTableSep(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_inlineTableKeyvals(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayTable(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayTableOpen(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayTableClose(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_ALPHA(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_DIGIT(pcc_context_t *ctx);
static pcc_thunk_chunk_t *pcc_evaluate_rule_HEXDIG(pcc_context_t *ctx);

static pcc_thunk_chunk_t *pcc_evaluate_rule_toml(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "toml", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_newline, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_expression, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_newline, &chunk->thunks, NULL)) goto L0002;
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            const size_t p = ctx->cur;
            {
                int u;
                const size_t n = pcc_get_char_as_utf32(ctx, &u);
                if (n == 0) goto L0005;
                ctx->cur += n;
            }
            ctx->cur = p;
            goto L0004;
        L0005:;
            ctx->cur = p;
        }
        goto L0003;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0006;
            ctx->cur += n;
        }
        goto L0003;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0003:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "toml", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "toml", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_expression(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_keyval, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0002;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_comment, &chunk->thunks, NULL)) goto L0003;
            goto L0004;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0004:;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0005;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_table, &chunk->thunks, NULL)) goto L0005;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0005;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_comment, &chunk->thunks, NULL)) goto L0006;
            goto L0007;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0007:;
        }
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0008;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_comment, &chunk->thunks, NULL)) goto L0009;
            goto L0010;
        L0009:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        L0010:;
        }
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "expression", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ws(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ws", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_wschar, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ws", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_wschar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "wschar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ' '
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\t'
        ) goto L0003;
        ctx->cur++;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "wschar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "wschar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_newline(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "newline", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 2) < 2 ||
            (ctx->buffer.buf + ctx->cur)[0] != '\r' ||
            (ctx->buffer.buf + ctx->cur)[1] != '\n'
        ) goto L0002;
        ctx->cur += 2;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\n'
        ) goto L0003;
        ctx->cur++;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "newline", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "newline", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_commentStartSymbol(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "commentStartSymbol", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '#'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "commentStartSymbol", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "commentStartSymbol", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_nonAscii(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "nonAscii", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0002;
            if (!(
                (u >= 0x000080 && u <= 0x00d7ff)
            )) goto L0002;
            ctx->cur += n;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0003;
            if (!(
                (u >= 0x00e000 && u <= 0x00110f) ||
                u == 0x000046 ||
                u == 0x000046 ||
                u == 0x000046
            )) goto L0003;
            ctx->cur += n;
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "nonAscii", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "nonAscii", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_nonEol(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "nonEol", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\t'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0003;
            if (!(
                (u >= 0x000020 && u <= 0x00007f)
            )) goto L0003;
            ctx->cur += n;
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonAscii, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "nonEol", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "nonEol", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_comment(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "comment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_commentStartSymbol, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonEol, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "comment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "comment", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_keyval(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "keyval", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_keyval_0, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_key, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_keyval_1, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_keyvalSep, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_val, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_keyval_2, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "keyval", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "keyval", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_key(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "key", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_dottedKey, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleKey, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "key", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "key", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_simpleKey(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "simpleKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        size_t q;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_quotedKey, &chunk->thunks, NULL)) goto L0002;
            goto L0001;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_unquotedKey, &chunk->thunks, NULL)) goto L0003;
            goto L0001;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0000;
        L0001:;
        }
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_simpleKey_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "simpleKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "simpleKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_unquotedKey(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "unquotedKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ALPHA, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (
                    pcc_refill_buffer(ctx, 1) < 1 ||
                    ctx->buffer.buf[ctx->cur] != '-'
                ) goto L0005;
                ctx->cur++;
                goto L0002;
            L0005:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (
                    pcc_refill_buffer(ctx, 1) < 1 ||
                    ctx->buffer.buf[ctx->cur] != '_'
                ) goto L0006;
                ctx->cur++;
                goto L0002;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "unquotedKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "unquotedKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_quotedKey(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "quotedKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_basicString, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_literalString, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "quotedKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "quotedKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_dottedKey(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "dottedKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleKey, &chunk->thunks, NULL)) goto L0000;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_dotSep, &chunk->thunks, NULL)) goto L0001;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_simpleKey, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "dottedKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "dottedKey", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_dotSep(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "dotSep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '.'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "dotSep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "dotSep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_keyvalSep(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "keyvalSep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '='
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "keyvalSep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "keyvalSep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_val(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "val", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    pcc_capture_table__resize(ctx->auxil, &chunk->capts, 1);
    {
        const size_t p = ctx->cur;
        size_t q;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_string, &chunk->thunks, NULL)) goto L0002;
            goto L0001;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_boolean, &chunk->thunks, NULL)) goto L0003;
            goto L0001;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_array, &chunk->thunks, NULL)) goto L0004;
            goto L0001;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inlineTable, &chunk->thunks, NULL)) goto L0005;
            goto L0001;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_dateTime, &chunk->thunks, NULL)) goto L0006;
            goto L0001;
        L0006:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_float, &chunk->thunks, NULL)) goto L0007;
            goto L0001;
        L0007:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_integer, &chunk->thunks, NULL)) goto L0008;
            goto L0001;
        L0008:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0000;
        L0001:;
        }
        q = ctx->cur;
        chunk->capts.buf[0].range.start = p;
        chunk->capts.buf[0].range.end = q;
    }
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_val_0, 0, 1);
        thunk->data.leaf.capts.buf[0] = &(chunk->capts.buf[0]);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "val", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "val", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_string(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "string", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlBasicString, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_basicString, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlLiteralString, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_literalString, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "string", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "string", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_basicString(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "basicString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_quotationMark, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_basicChar, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_quotationMark, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "basicString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "basicString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_quotationMark(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "quotationMark", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\"'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "quotationMark", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "quotationMark", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_basicChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "basicChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_basicUnescaped, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_escaped, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "basicChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "basicChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_basicUnescaped(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "basicUnescaped", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_wschar, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '!'
        ) goto L0003;
        ctx->cur++;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0004;
            if (!(
                (u >= 0x000023 && u <= 0x00005b)
            )) goto L0004;
            ctx->cur += n;
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0005;
            if (!(
                (u >= 0x00005d && u <= 0x00007e)
            )) goto L0005;
            ctx->cur += n;
        }
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonAscii, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "basicUnescaped", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "basicUnescaped", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_escaped(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "escaped", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_escape, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_escapeSeqChar, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "escaped", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "escaped", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_escape(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "escape", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\\'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "escape", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "escape", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_escapeSeqChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "escapeSeqChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0002;
            if (!(
                u == 0x000022 ||
                u == 0x000062 ||
                u == 0x000066 ||
                u == 0x00006e ||
                u == 0x000072 ||
                u == 0x000074
            )) goto L0002;
            ctx->cur += n;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != 'u'
        ) goto L0003;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0003;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0003;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0003;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != 'U'
        ) goto L0004;
        ctx->cur++;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0004;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0004;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0004;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0004;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0004;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0004;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0004;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "escapeSeqChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "escapeSeqChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mlBasicString(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mlBasicString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlBasicStringDelim, &chunk->thunks, NULL)) goto L0000;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_newline, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlBasicBody, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlBasicStringDelim, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mlBasicString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mlBasicString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mlBasicStringDelim(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mlBasicStringDelim", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_quotationMark, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_quotationMark, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_quotationMark, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mlBasicStringDelim", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mlBasicStringDelim", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mlBasicBody(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mlBasicBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlbContent, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlbQuotes, &chunk->thunks, NULL)) goto L0002;
            {
                const size_t p0 = ctx->cur;
                const size_t n0 = chunk->thunks.len;
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlbContent, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
                if (i < 1) {
                    ctx->cur = p0;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                    goto L0002;
                }
            }
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlbQuotes, &chunk->thunks, NULL)) goto L0004;
        goto L0005;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0005:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mlBasicBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mlbContent(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mlbContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlbChar, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_newline, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlbEscapedNl, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mlbContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mlbContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mlbChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mlbChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlbUnescaped, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_escaped, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mlbChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mlbChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mlbQuotes(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mlbQuotes", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_quotationMark, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_quotationMark, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_quotationMark, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mlbQuotes", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mlbQuotes", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mlbUnescaped(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mlbUnescaped", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_wschar, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '!'
        ) goto L0003;
        ctx->cur++;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0004;
            if (!(
                (u >= 0x000023 && u <= 0x00005b)
            )) goto L0004;
            ctx->cur += n;
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0005;
            if (!(
                (u >= 0x00005d && u <= 0x00007e)
            )) goto L0005;
            ctx->cur += n;
        }
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonAscii, &chunk->thunks, NULL)) goto L0006;
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mlbUnescaped", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mlbUnescaped", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mlbEscapedNl(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mlbEscapedNl", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_escape, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_newline, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_wschar, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_newline, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mlbEscapedNl", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mlbEscapedNl", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_literalString(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "literalString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_apostrophe, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_literalChar, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_apostrophe, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "literalString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "literalString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_apostrophe(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "apostrophe", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '\''
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "apostrophe", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "apostrophe", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_literalChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "literalChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\t'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0003;
            if (!(
                (u >= 0x000020 && u <= 0x000026)
            )) goto L0003;
            ctx->cur += n;
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0004;
            if (!(
                (u >= 0x000028 && u <= 0x00007e)
            )) goto L0004;
            ctx->cur += n;
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonAscii, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "literalChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "literalChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mlLiteralString(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mlLiteralString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlLiteralStringDelim, &chunk->thunks, NULL)) goto L0000;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_newline, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlLiteralBody, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mlLiteralStringDelim, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mlLiteralString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mlLiteralString", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mlLiteralStringDelim(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mlLiteralStringDelim", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_apostrophe, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_apostrophe, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_apostrophe, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mlLiteralStringDelim", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mlLiteralStringDelim", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mlLiteralBody(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mlLiteralBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mllContent, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mllQuotes, &chunk->thunks, NULL)) goto L0002;
            {
                const size_t p0 = ctx->cur;
                const size_t n0 = chunk->thunks.len;
                int i;
                for (i = 0;; i++) {
                    const size_t p = ctx->cur;
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mllContent, &chunk->thunks, NULL)) goto L0003;
                    if (ctx->cur == p) break;
                    continue;
                L0003:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    break;
                }
                if (i < 1) {
                    ctx->cur = p0;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                    goto L0002;
                }
            }
            if (ctx->cur == p) break;
            continue;
        L0002:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mllQuotes, &chunk->thunks, NULL)) goto L0004;
        goto L0005;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0005:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mlLiteralBody", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mllContent(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mllContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_mllChar, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_newline, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mllContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mllContent", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mllChar(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mllChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '\t'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0003;
            if (!(
                (u >= 0x000020 && u <= 0x000026)
            )) goto L0003;
            ctx->cur += n;
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0004;
            if (!(
                (u >= 0x000028 && u <= 0x00007e)
            )) goto L0004;
            ctx->cur += n;
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nonAscii, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mllChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mllChar", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_mllQuotes(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "mllQuotes", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_apostrophe, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_apostrophe, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_apostrophe, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "mllQuotes", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "mllQuotes", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_integer(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "integer", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_decInt, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_hexInt, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_octInt, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_binInt, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "integer", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "integer", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_minus(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "minus", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '-'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "minus", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "minus", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_plus(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "plus", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '+'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "plus", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "plus", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_underscore(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "underscore", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '_'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "underscore", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "underscore", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_digit1_9(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "digit1_9", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000031 && u <= 0x000039)
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "digit1_9", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "digit1_9", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_digit0_7(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "digit0_7", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000030 && u <= 0x000037)
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "digit0_7", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "digit0_7", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_digit0_1(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "digit0_1", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000030 && u <= 0x000031)
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "digit0_1", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "digit0_1", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_hexPrefix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "hexPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '0'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'x'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "hexPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "hexPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_octPrefix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "octPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '0'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'o'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "octPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "octPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_binPrefix(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "binPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '0'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'b'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "binPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "binPrefix", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_decInt(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "decInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_minus, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_plus, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        goto L0005;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0005:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_unsignedDecInt, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "decInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "decInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_unsignedDecInt(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "unsignedDecInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_digit1_9, &chunk->thunks, NULL)) goto L0002;
        {
            const size_t p0 = ctx->cur;
            const size_t n0 = chunk->thunks.len;
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                {
                    MARK_VAR_AS_USED
                    const size_t p = ctx->cur;
                    MARK_VAR_AS_USED
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0005;
                    goto L0004;
                L0005:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_underscore, &chunk->thunks, NULL)) goto L0006;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0006;
                    goto L0004;
                L0006:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                    goto L0003;
                L0004:;
                }
                if (ctx->cur == p) break;
                continue;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
            if (i < 1) {
                ctx->cur = p0;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
                goto L0002;
            }
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0007;
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "unsignedDecInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "unsignedDecInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_hexInt(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "hexInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_hexPrefix, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_underscore, &chunk->thunks, NULL)) goto L0004;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_HEXDIG, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "hexInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "hexInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_octInt(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "octInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_octPrefix, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_digit0_7, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_digit0_7, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_underscore, &chunk->thunks, NULL)) goto L0004;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_digit0_7, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "octInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "octInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_binInt(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "binInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_binPrefix, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_digit0_1, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_digit0_1, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_underscore, &chunk->thunks, NULL)) goto L0004;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_digit0_1, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "binInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "binInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_float(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "float", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_floatIntPart, &chunk->thunks, NULL)) goto L0002;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exp, &chunk->thunks, NULL)) goto L0004;
            goto L0003;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_frac, &chunk->thunks, NULL)) goto L0005;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_exp, &chunk->thunks, NULL)) goto L0006;
                goto L0007;
            L0006:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            L0007:;
            }
            goto L0003;
        L0005:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0002;
        L0003:;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_specialFloat, &chunk->thunks, NULL)) goto L0008;
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "float", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "float", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_floatIntPart(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "floatIntPart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_decInt, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "floatIntPart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "floatIntPart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_frac(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "frac", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_decimalPoint, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_zeroPrefixableInt, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "frac", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "frac", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_decimalPoint(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "decimalPoint", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '.'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "decimalPoint", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "decimalPoint", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_zeroPrefixableInt(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "zeroPrefixableInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_underscore, &chunk->thunks, NULL)) goto L0004;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "zeroPrefixableInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "zeroPrefixableInt", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_exp(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "exp", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            u == 0x000065 ||
            u == 0x000045
        )) goto L0000;
        ctx->cur += n;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_floatExpPart, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "exp", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "exp", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_floatExpPart(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "floatExpPart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_minus, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_plus, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        goto L0005;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0005:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_zeroPrefixableInt, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "floatExpPart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "floatExpPart", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_specialFloat(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "specialFloat", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            MARK_VAR_AS_USED
            const size_t p = ctx->cur;
            MARK_VAR_AS_USED
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_minus, &chunk->thunks, NULL)) goto L0003;
            goto L0002;
        L0003:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_plus, &chunk->thunks, NULL)) goto L0004;
            goto L0002;
        L0004:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            goto L0001;
        L0002:;
        }
        goto L0005;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0005:;
    }
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inf, &chunk->thunks, NULL)) goto L0007;
        goto L0006;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_nan, &chunk->thunks, NULL)) goto L0008;
        goto L0006;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0006:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "specialFloat", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "specialFloat", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inf(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inf", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'i'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'n'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'f'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inf", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inf", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_nan(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "nan", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'n'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'a'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'n'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "nan", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "nan", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_boolean(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "boolean", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_true, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_false, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "boolean", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "boolean", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_true(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "true", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 't'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'r'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'u'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'e'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "true", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "true", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_false(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "false", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'f'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'a'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'l'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 's'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != 'e'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "false", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "false", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_dateTime(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "dateTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_offsetDateTime, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_localDateTime, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_localDate, &chunk->thunks, NULL)) goto L0004;
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_localTime, &chunk->thunks, NULL)) goto L0005;
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "dateTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "dateTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_dateFullyear(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "dateFullyear", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "dateFullyear", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "dateFullyear", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_dateMonth(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "dateMonth", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "dateMonth", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "dateMonth", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_dateMday(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "dateMday", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "dateMday", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "dateMday", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_timeDelim(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "timeDelim", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0002;
            if (!(
                u == 0x000074 ||
                u == 0x000054
            )) goto L0002;
            ctx->cur += n;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != ' '
        ) goto L0003;
        ctx->cur++;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "timeDelim", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "timeDelim", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_timeHour(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "timeHour", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "timeHour", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "timeHour", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_timeMinute(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "timeMinute", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "timeMinute", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "timeMinute", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_timeSecond(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "timeSecond", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "timeSecond", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "timeSecond", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_timeSecfrac(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "timeSecfrac", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '.'
    ) goto L0000;
    ctx->cur++;
    {
        const size_t p0 = ctx->cur;
        const size_t n0 = chunk->thunks.len;
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0001;
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
        if (i < 1) {
            ctx->cur = p0;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n0);
            goto L0000;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "timeSecfrac", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "timeSecfrac", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_timeNumoffset(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "timeNumoffset", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '+'
        ) goto L0002;
        ctx->cur++;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (
            pcc_refill_buffer(ctx, 1) < 1 ||
            ctx->buffer.buf[ctx->cur] != '-'
        ) goto L0003;
        ctx->cur++;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_timeHour, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ':'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_timeMinute, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "timeNumoffset", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "timeNumoffset", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_timeOffset(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "timeOffset", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0002;
            if (!(
                u == 0x00007a ||
                u == 0x00005a
            )) goto L0002;
            ctx->cur += n;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_timeNumoffset, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "timeOffset", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "timeOffset", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_partialTime(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "partialTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_timeHour, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ':'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_timeMinute, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ':'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_timeSecond, &chunk->thunks, NULL)) goto L0000;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_timeSecfrac, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "partialTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "partialTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_fullDate(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "fullDate", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_dateFullyear, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '-'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_dateMonth, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '-'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_dateMday, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "fullDate", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "fullDate", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_fullTime(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "fullTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_partialTime, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_timeOffset, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "fullTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "fullTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_offsetDateTime(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "offsetDateTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_fullDate, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_timeDelim, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_fullTime, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "offsetDateTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "offsetDateTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_localDateTime(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "localDateTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_fullDate, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_timeDelim, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_partialTime, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "localDateTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "localDateTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_localDate(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "localDate", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_fullDate, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "localDate", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "localDate", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_localTime(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "localTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_partialTime, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "localTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "localTime", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_array(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "array", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_arrayOpen, &chunk->thunks, NULL)) goto L0000;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_arrayValues, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_wsCommentNewline, &chunk->thunks, NULL)) goto L0000;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_arrayClose, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "array", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "array", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayOpen(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "arrayOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '['
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "arrayOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "arrayOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayClose(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "arrayClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ']'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "arrayClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "arrayClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayValues(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "arrayValues", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_wsCommentNewline, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_val, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_wsCommentNewline, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_arraySep, &chunk->thunks, NULL)) goto L0002;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_arrayValues, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_wsCommentNewline, &chunk->thunks, NULL)) goto L0003;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_val, &chunk->thunks, NULL)) goto L0003;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_wsCommentNewline, &chunk->thunks, NULL)) goto L0003;
        {
            int i;
            for (i = 0;; i++) {
                const size_t p = ctx->cur;
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_arraySep, &chunk->thunks, NULL)) goto L0004;
                if (ctx->cur == p) break;
                continue;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                break;
            }
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "arrayValues", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "arrayValues", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_arraySep(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "arraySep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ','
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "arraySep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "arraySep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_wsCommentNewline(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "wsCommentNewline", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int i;
        for (i = 0;; i++) {
            const size_t p = ctx->cur;
            const size_t n = chunk->thunks.len;
            {
                MARK_VAR_AS_USED
                const size_t p = ctx->cur;
                MARK_VAR_AS_USED
                const size_t n = chunk->thunks.len;
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_wschar, &chunk->thunks, NULL)) goto L0003;
                goto L0002;
            L0003:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                {
                    MARK_VAR_AS_USED
                    const size_t p = ctx->cur;
                    MARK_VAR_AS_USED
                    const size_t n = chunk->thunks.len;
                    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_comment, &chunk->thunks, NULL)) goto L0005;
                    goto L0006;
                L0005:;
                    ctx->cur = p;
                    pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                L0006:;
                }
                if (!pcc_apply_rule(ctx, pcc_evaluate_rule_newline, &chunk->thunks, NULL)) goto L0004;
                goto L0002;
            L0004:;
                ctx->cur = p;
                pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
                goto L0001;
            L0002:;
            }
            if (ctx->cur == p) break;
            continue;
        L0001:;
            ctx->cur = p;
            pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
            break;
        }
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "wsCommentNewline", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_table(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "table", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_stdTable, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_arrayTable, &chunk->thunks, NULL)) goto L0003;
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "table", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "table", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_stdTable(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "stdTable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_stdTableOpen, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_stdTable_0, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_key, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_stdTable_1, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_stdTableClose, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "stdTable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "stdTable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_stdTableOpen(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "stdTableOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '['
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "stdTableOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "stdTableOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_stdTableClose(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "stdTableClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ']'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "stdTableClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "stdTableClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inlineTable(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inlineTable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inlineTableOpen, &chunk->thunks, NULL)) goto L0000;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inlineTableKeyvals, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inlineTableClose, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inlineTable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inlineTable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inlineTableOpen(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inlineTableOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '{'
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inlineTableOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inlineTableOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inlineTableClose(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inlineTableClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '}'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inlineTableClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inlineTableClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inlineTableSep(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inlineTableSep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ','
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inlineTableSep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inlineTableSep", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_inlineTableKeyvals(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "inlineTableKeyvals", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_keyval, &chunk->thunks, NULL)) goto L0000;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inlineTableSep, &chunk->thunks, NULL)) goto L0001;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_inlineTableKeyvals, &chunk->thunks, NULL)) goto L0001;
        goto L0002;
    L0001:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
    L0002:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "inlineTableKeyvals", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "inlineTableKeyvals", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayTable(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "arrayTable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_arrayTableOpen, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_arrayTable_0, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_key, &chunk->thunks, NULL)) goto L0000;
    {
        pcc_thunk_t *const thunk = pcc_thunk__create_leaf(ctx->auxil, pcc_action_arrayTable_1, 0, 0);
        thunk->data.leaf.capt0.range.start = chunk->pos;
        thunk->data.leaf.capt0.range.end = ctx->cur;
        pcc_thunk_array__add(ctx->auxil, &chunk->thunks, thunk);
    }
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_arrayTableClose, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "arrayTable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "arrayTable", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayTableOpen(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "arrayTableOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '['
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != '['
    ) goto L0000;
    ctx->cur++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "arrayTableOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "arrayTableOpen", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_arrayTableClose(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "arrayTableClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    if (!pcc_apply_rule(ctx, pcc_evaluate_rule_ws, &chunk->thunks, NULL)) goto L0000;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ']'
    ) goto L0000;
    ctx->cur++;
    if (
        pcc_refill_buffer(ctx, 1) < 1 ||
        ctx->buffer.buf[ctx->cur] != ']'
    ) goto L0000;
    ctx->cur++;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "arrayTableClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "arrayTableClose", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_ALPHA(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "ALPHA", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0002;
            if (!(
                (u >= 0x000041 && u <= 0x00005a)
            )) goto L0002;
            ctx->cur += n;
        }
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0003;
            if (!(
                (u >= 0x000061 && u <= 0x00007a)
            )) goto L0003;
            ctx->cur += n;
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "ALPHA", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "ALPHA", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_DIGIT(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "DIGIT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        int u;
        const size_t n = pcc_get_char_as_utf32(ctx, &u);
        if (n == 0) goto L0000;
        if (!(
            (u >= 0x000030 && u <= 0x000039)
        )) goto L0000;
        ctx->cur += n;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "DIGIT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "DIGIT", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

static pcc_thunk_chunk_t *pcc_evaluate_rule_HEXDIG(pcc_context_t *ctx) {
    pcc_thunk_chunk_t *const chunk = pcc_thunk_chunk__create(ctx);
    chunk->pos = ctx->cur;
    PCC_DEBUG(ctx->auxil, PCC_DBG_EVALUATE, "HEXDIG", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->buffer.len - chunk->pos));
    ctx->level++;
    {
        MARK_VAR_AS_USED
        const size_t p = ctx->cur;
        MARK_VAR_AS_USED
        const size_t n = chunk->thunks.len;
        if (!pcc_apply_rule(ctx, pcc_evaluate_rule_DIGIT, &chunk->thunks, NULL)) goto L0002;
        goto L0001;
    L0002:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0003;
            if (!(
                u == 0x000061 ||
                u == 0x000041
            )) goto L0003;
            ctx->cur += n;
        }
        goto L0001;
    L0003:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0004;
            if (!(
                u == 0x000062 ||
                u == 0x000042
            )) goto L0004;
            ctx->cur += n;
        }
        goto L0001;
    L0004:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0005;
            if (!(
                u == 0x000063 ||
                u == 0x000043
            )) goto L0005;
            ctx->cur += n;
        }
        goto L0001;
    L0005:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0006;
            if (!(
                u == 0x000064 ||
                u == 0x000044
            )) goto L0006;
            ctx->cur += n;
        }
        goto L0001;
    L0006:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0007;
            if (!(
                u == 0x000065 ||
                u == 0x000045
            )) goto L0007;
            ctx->cur += n;
        }
        goto L0001;
    L0007:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        {
            int u;
            const size_t n = pcc_get_char_as_utf32(ctx, &u);
            if (n == 0) goto L0008;
            if (!(
                u == 0x000066 ||
                u == 0x000046
            )) goto L0008;
            ctx->cur += n;
        }
        goto L0001;
    L0008:;
        ctx->cur = p;
        pcc_thunk_array__revert(ctx->auxil, &chunk->thunks, n);
        goto L0000;
    L0001:;
    }
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_MATCH, "HEXDIG", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    return chunk;
L0000:;
    ctx->level--;
    PCC_DEBUG(ctx->auxil, PCC_DBG_NOMATCH, "HEXDIG", ctx->level, chunk->pos, (ctx->buffer.buf + chunk->pos), (ctx->cur - chunk->pos));
    pcc_thunk_chunk__destroy(ctx, chunk);
    return NULL;
}

ptoml_context_t *ptoml_create(struct parserCtx *auxil) {
    return pcc_context__create(auxil);
}

int ptoml_parse(ptoml_context_t *ctx, int *ret) {
    if (pcc_apply_rule(ctx, pcc_evaluate_rule_toml, &ctx->thunks, ret))
        pcc_do_action(ctx, &ctx->thunks, ret);
    else
        PCC_ERROR(ctx->auxil);
    pcc_commit_buffer(ctx);
    pcc_thunk_array__revert(ctx->auxil, &ctx->thunks, 0);
    return pcc_refill_buffer(ctx, 1) >= 1;
}

void ptoml_destroy(ptoml_context_t *ctx) {
    pcc_context__destroy(ctx);
}

#include "toml_post.h"
