/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// CertificateStatusApplyConfiguration represents a declarative configuration of the CertificateStatus type for use
// with apply.
type CertificateStatusApplyConfiguration struct {
	Conditions               []CertificateConditionApplyConfiguration `json:"conditions,omitempty"`
	LastFailureTime          *metav1.Time                             `json:"lastFailureTime,omitempty"`
	NotBefore                *metav1.Time                             `json:"notBefore,omitempty"`
	NotAfter                 *metav1.Time                             `json:"notAfter,omitempty"`
	RenewalTime              *metav1.Time                             `json:"renewalTime,omitempty"`
	Revision                 *int                                     `json:"revision,omitempty"`
	NextPrivateKeySecretName *string                                  `json:"nextPrivateKeySecretName,omitempty"`
	FailedIssuanceAttempts   *int                                     `json:"failedIssuanceAttempts,omitempty"`
}

// CertificateStatusApplyConfiguration constructs a declarative configuration of the CertificateStatus type for use with
// apply.
func CertificateStatus() *CertificateStatusApplyConfiguration {
	return &CertificateStatusApplyConfiguration{}
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *CertificateStatusApplyConfiguration) WithConditions(values ...*CertificateConditionApplyConfiguration) *CertificateStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithLastFailureTime sets the LastFailureTime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LastFailureTime field is set to the value of the last call.
func (b *CertificateStatusApplyConfiguration) WithLastFailureTime(value metav1.Time) *CertificateStatusApplyConfiguration {
	b.LastFailureTime = &value
	return b
}

// WithNotBefore sets the NotBefore field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NotBefore field is set to the value of the last call.
func (b *CertificateStatusApplyConfiguration) WithNotBefore(value metav1.Time) *CertificateStatusApplyConfiguration {
	b.NotBefore = &value
	return b
}

// WithNotAfter sets the NotAfter field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NotAfter field is set to the value of the last call.
func (b *CertificateStatusApplyConfiguration) WithNotAfter(value metav1.Time) *CertificateStatusApplyConfiguration {
	b.NotAfter = &value
	return b
}

// WithRenewalTime sets the RenewalTime field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RenewalTime field is set to the value of the last call.
func (b *CertificateStatusApplyConfiguration) WithRenewalTime(value metav1.Time) *CertificateStatusApplyConfiguration {
	b.RenewalTime = &value
	return b
}

// WithRevision sets the Revision field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Revision field is set to the value of the last call.
func (b *CertificateStatusApplyConfiguration) WithRevision(value int) *CertificateStatusApplyConfiguration {
	b.Revision = &value
	return b
}

// WithNextPrivateKeySecretName sets the NextPrivateKeySecretName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NextPrivateKeySecretName field is set to the value of the last call.
func (b *CertificateStatusApplyConfiguration) WithNextPrivateKeySecretName(value string) *CertificateStatusApplyConfiguration {
	b.NextPrivateKeySecretName = &value
	return b
}

// WithFailedIssuanceAttempts sets the FailedIssuanceAttempts field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FailedIssuanceAttempts field is set to the value of the last call.
func (b *CertificateStatusApplyConfiguration) WithFailedIssuanceAttempts(value int) *CertificateStatusApplyConfiguration {
	b.FailedIssuanceAttempts = &value
	return b
}
