/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	acmev1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
	metav1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/meta/v1"
)

// ChallengeSpecApplyConfiguration represents a declarative configuration of the ChallengeSpec type for use
// with apply.
type ChallengeSpecApplyConfiguration struct {
	URL              *string                                   `json:"url,omitempty"`
	AuthorizationURL *string                                   `json:"authorizationURL,omitempty"`
	DNSName          *string                                   `json:"dnsName,omitempty"`
	Wildcard         *bool                                     `json:"wildcard,omitempty"`
	Type             *acmev1.ACMEChallengeType                 `json:"type,omitempty"`
	Token            *string                                   `json:"token,omitempty"`
	Key              *string                                   `json:"key,omitempty"`
	Solver           *ACMEChallengeSolverApplyConfiguration    `json:"solver,omitempty"`
	IssuerRef        *metav1.IssuerReferenceApplyConfiguration `json:"issuerRef,omitempty"`
}

// ChallengeSpecApplyConfiguration constructs a declarative configuration of the ChallengeSpec type for use with
// apply.
func ChallengeSpec() *ChallengeSpecApplyConfiguration {
	return &ChallengeSpecApplyConfiguration{}
}

// WithURL sets the URL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the URL field is set to the value of the last call.
func (b *ChallengeSpecApplyConfiguration) WithURL(value string) *ChallengeSpecApplyConfiguration {
	b.URL = &value
	return b
}

// WithAuthorizationURL sets the AuthorizationURL field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AuthorizationURL field is set to the value of the last call.
func (b *ChallengeSpecApplyConfiguration) WithAuthorizationURL(value string) *ChallengeSpecApplyConfiguration {
	b.AuthorizationURL = &value
	return b
}

// WithDNSName sets the DNSName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DNSName field is set to the value of the last call.
func (b *ChallengeSpecApplyConfiguration) WithDNSName(value string) *ChallengeSpecApplyConfiguration {
	b.DNSName = &value
	return b
}

// WithWildcard sets the Wildcard field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Wildcard field is set to the value of the last call.
func (b *ChallengeSpecApplyConfiguration) WithWildcard(value bool) *ChallengeSpecApplyConfiguration {
	b.Wildcard = &value
	return b
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *ChallengeSpecApplyConfiguration) WithType(value acmev1.ACMEChallengeType) *ChallengeSpecApplyConfiguration {
	b.Type = &value
	return b
}

// WithToken sets the Token field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Token field is set to the value of the last call.
func (b *ChallengeSpecApplyConfiguration) WithToken(value string) *ChallengeSpecApplyConfiguration {
	b.Token = &value
	return b
}

// WithKey sets the Key field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Key field is set to the value of the last call.
func (b *ChallengeSpecApplyConfiguration) WithKey(value string) *ChallengeSpecApplyConfiguration {
	b.Key = &value
	return b
}

// WithSolver sets the Solver field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Solver field is set to the value of the last call.
func (b *ChallengeSpecApplyConfiguration) WithSolver(value *ACMEChallengeSolverApplyConfiguration) *ChallengeSpecApplyConfiguration {
	b.Solver = value
	return b
}

// WithIssuerRef sets the IssuerRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IssuerRef field is set to the value of the last call.
func (b *ChallengeSpecApplyConfiguration) WithIssuerRef(value *metav1.IssuerReferenceApplyConfiguration) *ChallengeSpecApplyConfiguration {
	b.IssuerRef = value
	return b
}
