// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <bdep/types-parsers.hxx>
//
// End prologue.

#include <bdep/config-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace bdep
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (X& b, const X& a)
      {
        b = a;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (bool& b, const bool&)
      {
        b = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::string& b, const std::string& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }

      static void
      merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }

      static void
      merge (std::vector<X>& b, const std::vector<X>& a)
      {
        b.insert (b.end (), a.begin (), a.end ());
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }

      static void
      merge (std::set<X, C>& b, const std::set<X, C>& a)
      {
        b.insert (a.begin (), a.end ());
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
      {
        for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b[i->first] = i->second;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
      {
        for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                 i->second));
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace bdep
{
  // cmd_config_subcommands
  //

  cmd_config_subcommands::
  cmd_config_subcommands ()
  : add_ (),
    create_ (),
    link_ (),
    unlink_ (),
    list_ (),
    move_ (),
    rename_ (),
    remove_ (),
    set_ ()
  {
  }

  bool cmd_config_subcommands::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_config_subcommands::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_config_subcommands::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_config_subcommands::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_config_subcommands::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_config_subcommands::
  merge (const cmd_config_subcommands& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.add_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->add_, a.add_);
    }

    if (a.create_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->create_, a.create_);
    }

    if (a.link_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->link_, a.link_);
    }

    if (a.unlink_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->unlink_, a.unlink_);
    }

    if (a.list_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->list_, a.list_);
    }

    if (a.move_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->move_, a.move_);
    }

    if (a.rename_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->rename_, a.rename_);
    }

    if (a.remove_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->remove_, a.remove_);
    }

    if (a.set_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->set_, a.set_);
    }
  }

  ::bdep::cli::usage_para cmd_config_subcommands::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mCONFIG SUBCOMMANDS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1madd\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mcreate\033[0m" << ::std::endl
       << "    The \033[1madd\033[0m subcommand adds an existing \033[1mbpkg(1)\033[0m build configuration in" << ::std::endl
       << "    directory \033[4mcfg-dir\033[0m to the project's build configuration set. The \033[1mcreate\033[0m" << ::std::endl
       << "    subcommand creates a new configuration in directory \033[4mcfg-dir\033[0m by executing" << ::std::endl
       << "    the \033[1mbpkg-cfg-create(1)\033[0m command and passing to it \033[4mcfg-args\033[0m, if any. It then" << ::std::endl
       << "    proceeds as \033[1madd\033[0m by adding the new configuration to the project's build" << ::std::endl
       << "    configuration set." << ::std::endl
       << ::std::endl
       << "    In both subcommands, if \033[4mcfg-name\033[0m is specified, then the added configuration" << ::std::endl
       << "    is given this name. Several \033[1mbdep\033[0m commands can use such names as a more" << ::std::endl
       << "    convenient way to specify build configurations (see" << ::std::endl
       << "    \033[1mbdep-projects-configs(1)\033[0m for details)." << ::std::endl
       << ::std::endl
       << "    As a shortcut, if \033[4mcfg-name\033[0m is not specified and \033[4mcfg-dir\033[0m is a simple path" << ::std::endl
       << "    that starts with \033[1m@\033[0m, then it is treated as the name and the configuration" << ::std::endl
       << "    directory is assumed to be \033[4mprj-dir\033[0m\033[1m-\033[0m\033[4mcfg-name\033[0m\033[0m. Note that in case of create\033[0m," << ::std::endl
       << "    \033[4mcfg-dir\033[0m must be preceded with \033[1m--\033[0m (double dash) option to disambiguate it" << ::std::endl
       << "    from \033[1m@\033[0m\033[4mcfg-name\033[0m\033[0m. For example, assuming the project directory is \033[1mhello\033[0m:" << ::std::endl
       << ::std::endl
       << "    $ bdep config add @clang                        # ../hello-clang" << ::std::endl
       << "    $ bdep config create -- @gcc cc config.cxx=g++  # ../hello-gcc" << ::std::endl
       << ::std::endl
       << "    A configuration also has a type that is specified with the \033[1m--type\033[0m option" << ::std::endl
       << "    (or \033[1m--config-type\033[0m from \033[1mbdep-new(1)\033[0m). If the type is not specified" << ::std::endl
       << "    explicitly, then \033[1mtarget\033[0m is assumed. See \033[1mbpkg-cfg-create(1)\033[0m for background" << ::std::endl
       << "    on configuration types." << ::std::endl
       << ::std::endl
       << "    Unless the \033[1m--no-default\033[0m option is specified, the first added or created" << ::std::endl
       << "    build configuration of each type is designated as the default. Several" << ::std::endl
       << "    \033[1mbdep\033[0m commands use such a configuration by default if no configuration was" << ::std::endl
       << "    specified explicitly (see \033[1mbdep-projects-configs(1)\033[0m for details). To make a" << ::std::endl
       << "    subsequently added configuration the default use the \033[1m--default\033[0m option. Note" << ::std::endl
       << "    also that in case of multiple default configurations any given package" << ::std::endl
       << "    within a project can only be initialized in one such configuration." << ::std::endl
       << ::std::endl
       << "    The default build configuration of each type is also designated as" << ::std::endl
       << "    forwarded unless the \033[1m--no-forward\033[0m option is specified or another" << ::std::endl
       << "    configuration of this type is already designated as forwarded. When a" << ::std::endl
       << "    project is initialized in a forwarded build configuration, its source" << ::std::endl
       << "    directory is configured to forward to this configuration (see \033[1mb(1)\033[0m for" << ::std::endl
       << "    details on forwarded configurations). To designate a non-default" << ::std::endl
       << "    configuration as forwarded use the \033[1m--forward\033[0m option. Note also that it is" << ::std::endl
       << "    possible to have multiple forwarded configurations, however, any given" << ::std::endl
       << "    package within a project can only be initialized in one such configuration." << ::std::endl
       << ::std::endl
       << "    Unless the \033[1m--no-auto-sync\033[0m option is specified, an added or created build" << ::std::endl
       << "    configuration will be automatically synchronized on every build system" << ::std::endl
       << "    invocation. Note that this flag affects the entire build configuration and" << ::std::endl
       << "    if multiple projects share the same configuration, then they must have a" << ::std::endl
       << "    consistent auto-synchronization setting." << ::std::endl
       << "\033[1mlink\033[0m" << ::std::endl
       << "    The \033[1mlink\033[0m subcommand links the first specified build configuration with the" << ::std::endl
       << "    second by executing the \033[1mbpkg-cfg-link(1)\033[0m command. See \033[1mbpkg-cfg-create(1)\033[0m" << ::std::endl
       << "    for background on linked configurations." << ::std::endl
       << "\033[1munlink\033[0m" << ::std::endl
       << "    The \033[1munlink\033[0m subcommand unlinks the first specified build configuration from" << ::std::endl
       << "    the second by executing the \033[1mbpkg-cfg-unlink(1)\033[0m command. See" << ::std::endl
       << "    \033[1mbpkg-cfg-create(1)\033[0m for background on linked configurations." << ::std::endl
       << "\033[1mlist\033[0m" << ::std::endl
       << "    The \033[1mlist\033[0m subcommand prints the list of build configurations associated with" << ::std::endl
       << "    the project. Unless one or more configurations are specified explicitly," << ::std::endl
       << "    \033[1mlist\033[0m prints all the associate configurations. Note that the output is" << ::std::endl
       << "    written to \033[1mstdout\033[0m, not \033[1mstderr\033[0m." << ::std::endl
       << ::std::endl
       << "    If the output format is \033[1mjson\033[0m (see the \033[1m--stdout-format\033[0m common option), then" << ::std::endl
       << "    the output is a JSON array of objects which are the serialized" << ::std::endl
       << "    representation of the following C++ \033[1mstruct\033[0m \033[1mconfiguration\033[0m:" << ::std::endl
       << ::std::endl
       << "    struct package" << ::std::endl
       << "    {" << ::std::endl
       << "      string name;" << ::std::endl
       << "    };" << ::std::endl
       << ::std::endl
       << "    struct configuration" << ::std::endl
       << "    {" << ::std::endl
       << "      uint64_t         id;" << ::std::endl
       << "      string           path;" << ::std::endl
       << "      optional<string> name;" << ::std::endl
       << "      string           type;" << ::std::endl
       << "      bool             default;" << ::std::endl
       << "      bool             forward;" << ::std::endl
       << "      bool             auto_sync;" << ::std::endl
       << "      vector<package>  packages;" << ::std::endl
       << "    };" << ::std::endl
       << ::std::endl
       << "    For example:" << ::std::endl
       << ::std::endl
       << "    [" << ::std::endl
       << "      {" << ::std::endl
       << "        \"id\": 1," << ::std::endl
       << "        \"path\": \"/tmp/hello-gcc\"," << ::std::endl
       << "        \"name\": \"gcc\"," << ::std::endl
       << "        \"type\": \"target\"," << ::std::endl
       << "        \"default\": true," << ::std::endl
       << "        \"forward\": true," << ::std::endl
       << "        \"auto_sync\": true," << ::std::endl
       << "        \"packages\": [" << ::std::endl
       << "          {" << ::std::endl
       << "            \"name\": \"hello\"" << ::std::endl
       << "          }" << ::std::endl
       << "        ]" << ::std::endl
       << "      }" << ::std::endl
       << "    ]" << ::std::endl
       << ::std::endl
       << "    See the JSON OUTPUT section in \033[1mbdep-common-options(1)\033[0m for details on the" << ::std::endl
       << "    overall properties of this format and the semantics of the \033[1mstruct\033[0m" << ::std::endl
       << "    serialization." << ::std::endl
       << ::std::endl
       << "    The \033[1mid\033[0m member is a numeric configuration id that can be used to identify" << ::std::endl
       << "    the configuration instead of the name or path (see the \033[1m--config-id\033[0m option)." << ::std::endl
       << "    The \033[1mpath\033[0m member is an absolute path to the configuration directory. The" << ::std::endl
       << "    \033[1mpackages\033[0m member contains the array of packages belonging to this project" << ::std::endl
       << "    that have been initialized in this configuration. See the \033[1mcreate\033[0m subcommand" << ::std::endl
       << "    for the meaning of other members (\033[1mname\033[0m, \033[1mtype\033[0m, \033[1mdefault\033[0m, etc)." << ::std::endl
       << "\033[1mmove\033[0m" << ::std::endl
       << "    The \033[1mmove\033[0m subcommand assigns the specified build configuration a new" << ::std::endl
       << "    directory. It is normally used after moving/renaming the configuration" << ::std::endl
       << "    directory. Note that an explicit \033[1mbdep-sync(1)\033[0m command is required for this" << ::std::endl
       << "    change to take effect. See \033[1mbdep-projects-configs(1)\033[0m for various ways to" << ::std::endl
       << "    specify a build configuration." << ::std::endl
       << "\033[1mrename\033[0m" << ::std::endl
       << "    The \033[1mrename\033[0m subcommand gives the specified build configuration a new name." << ::std::endl
       << "    See \033[1mbdep-projects-configs(1)\033[0m for various ways to specify a build" << ::std::endl
       << "    configuration." << ::std::endl
       << "\033[1mremove\033[0m" << ::std::endl
       << "    The \033[1mremove\033[0m subcommand removes one or more build configurations from the" << ::std::endl
       << "    project's build configuration set. Note that only configurations that have" << ::std::endl
       << "    no initialized packages can be removed. See \033[1mbdep-projects-configs(1)\033[0m for" << ::std::endl
       << "    various ways to specify build configurations." << ::std::endl
       << "\033[1mset\033[0m" << ::std::endl
       << "    The \033[1mset\033[0m subcommand modifies various properties of one or more build" << ::std::endl
       << "    configurations associated with the project. See \033[1mbdep-projects-configs(1)\033[0m" << ::std::endl
       << "    for various ways to specify build configurations." << ::std::endl
       << ::std::endl
       << "    The properties that can be modified include the default (\033[1m--\033[0m[\033[1mno-\033[0m]\033[1mdefault\033[0m\033[0m)," << ::std::endl
       << "    forward (\033[1m--\033[0m[\033[1mno-\033[0m]\033[1mforward\033[0m\033[0m), and auto-synchronization (\033[1m--\033[0m[\033[1mno-\033[0m]\033[1mauto-sync\033[0m\033[0m)" << ::std::endl
       << "    flags. Note that changing any of these flags requires an explicit" << ::std::endl
       << "    \033[1mbdep-sync(1)\033[0m command to take effect." << ::std::endl;

    p = ::bdep::cli::usage_para::text;

    return p;
  }

  struct _cli_cmd_config_subcommands_desc_type: ::bdep::cli::options
  {
    _cli_cmd_config_subcommands_desc_type ()
    {
      ::bdep::cmd_config_subcommands::fill (*this);
    }
  };

  void cmd_config_subcommands::
  fill (::bdep::cli::options& os)
  {
    // add
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("add", a, true, dv);
      os.push_back (o);
    }

    // create
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("create", a, true, dv);
      os.push_back (o);
    }

    // link
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("link", a, true, dv);
      os.push_back (o);
    }

    // unlink
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("unlink", a, true, dv);
      os.push_back (o);
    }

    // list
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("list", a, true, dv);
      os.push_back (o);
    }

    // move
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("move", a, true, dv);
      os.push_back (o);
    }

    // rename
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("rename", a, true, dv);
      os.push_back (o);
    }

    // remove
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("remove", a, true, dv);
      os.push_back (o);
    }

    // set
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("set", a, true, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_config_subcommands::
  description ()
  {
    static _cli_cmd_config_subcommands_desc_type _cli_cmd_config_subcommands_desc_;
    return _cli_cmd_config_subcommands_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_config_subcommands&, ::bdep::cli::scanner&)>
  _cli_cmd_config_subcommands_map;

  static _cli_cmd_config_subcommands_map _cli_cmd_config_subcommands_map_;

  struct _cli_cmd_config_subcommands_map_init
  {
    _cli_cmd_config_subcommands_map_init ()
    {
      _cli_cmd_config_subcommands_map_["add"] =
      &::bdep::cli::thunk< cmd_config_subcommands, &cmd_config_subcommands::add_ >;
      _cli_cmd_config_subcommands_map_["create"] =
      &::bdep::cli::thunk< cmd_config_subcommands, &cmd_config_subcommands::create_ >;
      _cli_cmd_config_subcommands_map_["link"] =
      &::bdep::cli::thunk< cmd_config_subcommands, &cmd_config_subcommands::link_ >;
      _cli_cmd_config_subcommands_map_["unlink"] =
      &::bdep::cli::thunk< cmd_config_subcommands, &cmd_config_subcommands::unlink_ >;
      _cli_cmd_config_subcommands_map_["list"] =
      &::bdep::cli::thunk< cmd_config_subcommands, &cmd_config_subcommands::list_ >;
      _cli_cmd_config_subcommands_map_["move"] =
      &::bdep::cli::thunk< cmd_config_subcommands, &cmd_config_subcommands::move_ >;
      _cli_cmd_config_subcommands_map_["rename"] =
      &::bdep::cli::thunk< cmd_config_subcommands, &cmd_config_subcommands::rename_ >;
      _cli_cmd_config_subcommands_map_["remove"] =
      &::bdep::cli::thunk< cmd_config_subcommands, &cmd_config_subcommands::remove_ >;
      _cli_cmd_config_subcommands_map_["set"] =
      &::bdep::cli::thunk< cmd_config_subcommands, &cmd_config_subcommands::set_ >;
    }
  };

  static _cli_cmd_config_subcommands_map_init _cli_cmd_config_subcommands_map_init_;

  bool cmd_config_subcommands::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_config_subcommands_map::const_iterator i (_cli_cmd_config_subcommands_map_.find (o));

    if (i != _cli_cmd_config_subcommands_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cmd_config_subcommands::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // cmd_config_options
  //

  cmd_config_options::
  cmd_config_options ()
  {
  }

  bool cmd_config_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_config_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_config_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_config_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_config_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_config_options::
  merge (const cmd_config_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    // configuration_add_options base
    //
    ::bdep::configuration_add_options::merge (a);

    // project_options base
    //
    ::bdep::project_options::merge (a);
  }

  ::bdep::cli::usage_para cmd_config_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mCONFIG OPTIONS\033[0m" << ::std::endl;

    p = ::bdep::cli::usage_para::text;

    // configuration_add_options base
    //
    p = ::bdep::configuration_add_options::print_usage (os, p);

    // project_options base
    //
    p = ::bdep::project_options::print_usage (os, p);

    return p;
  }

  struct _cli_cmd_config_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_config_options_desc_type ()
    {
      ::bdep::cmd_config_options::fill (*this);
    }
  };

  void cmd_config_options::
  fill (::bdep::cli::options& os)
  {
    // configuration_add_options base
    //
    ::bdep::configuration_add_options::fill (os);

    // project_options base
    //
    ::bdep::project_options::fill (os);
  }

  const ::bdep::cli::options& cmd_config_options::
  description ()
  {
    static _cli_cmd_config_options_desc_type _cli_cmd_config_options_desc_;
    return _cli_cmd_config_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_config_options&, ::bdep::cli::scanner&)>
  _cli_cmd_config_options_map;

  static _cli_cmd_config_options_map _cli_cmd_config_options_map_;

  struct _cli_cmd_config_options_map_init
  {
    _cli_cmd_config_options_map_init ()
    {
    }
  };

  static _cli_cmd_config_options_map_init _cli_cmd_config_options_map_init_;

  bool cmd_config_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_config_options_map::const_iterator i (_cli_cmd_config_options_map_.find (o));

    if (i != _cli_cmd_config_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    // configuration_add_options base
    //
    if (::bdep::configuration_add_options::_parse (o, s))
      return true;

    // project_options base
    //
    if (::bdep::project_options::_parse (o, s))
      return true;

    return false;
  }

  bool cmd_config_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace bdep
{
  ::bdep::cli::usage_para
  print_bdep_config_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbdep config add\033[0m    [\033[4moptions\033[0m] [\033[4mprj-spec\033[0m] [\033[1m@\033[0m\033[4mcfg-name\033[0m] \033[4mcfg-dir\033[0m" << ::std::endl
       << "\033[1mbdep config create\033[0m [\033[4moptions\033[0m] [\033[4mprj-spec\033[0m] [\033[1m@\033[0m\033[4mcfg-name\033[0m] \033[4mcfg-dir\033[0m [\033[4mcfg-args\033[0m]" << ::std::endl
       << "\033[1mbdep config link\033[0m   [\033[4moptions\033[0m] [\033[4mprj-spec\033[0m] \033[4mcfg-spec\033[0m \033[4mcfg-spec\033[0m" << ::std::endl
       << "\033[1mbdep config unlink\033[0m [\033[4moptions\033[0m] [\033[4mprj-spec\033[0m] \033[4mcfg-spec\033[0m \033[4mcfg-spec\033[0m" << ::std::endl
       << "\033[1mbdep config list\033[0m   [\033[4moptions\033[0m] [\033[4mprj-spec\033[0m] [\033[4mcfg-spec\033[0m...]" << ::std::endl
       << "\033[1mbdep config move\033[0m   [\033[4moptions\033[0m] [\033[4mprj-spec\033[0m] \033[4mcfg-spec\033[0m \033[4mcfg-dir\033[0m" << ::std::endl
       << "\033[1mbdep config rename\033[0m [\033[4moptions\033[0m] [\033[4mprj-spec\033[0m] \033[4mcfg-spec\033[0m \033[4mcfg-name\033[0m" << ::std::endl
       << "\033[1mbdep config remove\033[0m [\033[4moptions\033[0m] [\033[4mprj-spec\033[0m] \033[4mcfg-spec\033[0m... | \033[1m--all\033[0m|\033[1m-a\033[0m" << ::std::endl
       << "\033[1mbdep config set\033[0m    [\033[4moptions\033[0m] [\033[4mprj-spec\033[0m] \033[4mcfg-spec\033[0m... | \033[1m--all\033[0m|\033[1m-a\033[0m" << ::std::endl
       << "                   [\033[1m--\033[0m[\033[1mno-\033[0m]\033[1mdefault\033[0m]" << ::std::endl
       << "                   [\033[1m--\033[0m[\033[1mno-\033[0m]\033[1mforward\033[0m]" << ::std::endl
       << "                   [\033[1m--\033[0m[\033[1mno-\033[0m]\033[1mauto-sync\033[0m]\033[0m" << ::std::endl
       << ::std::endl
       << "\033[4mcfg-spec\033[0m = \033[1m@\033[0m\033[4mcfg-name\033[0m | \033[1m--config\033[0m|\033[1m-c\033[0m \033[4mcfg-dir\033[0m" << ::std::endl
       << "\033[4mprj-spec\033[0m = \033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mprj-dir\033[0m" << ::std::endl
       << "\033[4mcfg-args\033[0m = [\033[1m--\033[0m [\033[4mbpkg-options\033[0m]] [\033[1m--existing\033[0m|\033[1m-e\033[0m | (\033[4mmodule\033[0m | \033[4mcfg-var\033[0m)...]\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mconfig\033[0m command provides the following subcommands for managing project's" << ::std::endl
       << "build configurations. If no project directory is specified, then the current" << ::std::endl
       << "working directory is assumed." << ::std::endl;

    p = ::bdep::cmd_config_subcommands::print_usage (os, ::bdep::cli::usage_para::text);

    p = ::bdep::cmd_config_options::print_usage (os, p);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mDEFAULT OPTIONS FILES\033[0m" << ::std::endl
       << ::std::endl
       << "See \033[1mbdep-default-options-files(1)\033[0m for an overview of the default options files." << ::std::endl
       << "For the \033[1mconfig\033[0m command the search start directory is the project directory. The" << ::std::endl
       << "following options files are searched for in each directory and, if found," << ::std::endl
       << "loaded in the order listed:" << ::std::endl
       << ::std::endl
       << "bdep.options" << ::std::endl
       << "bdep-config.options" << ::std::endl
       << "bdep-config-add.options          # if the create subcommand" << ::std::endl
       << "bdep-config-<subcommand>.options # (subcommand-dependent)" << ::std::endl
       << ::std::endl
       << "The following \033[1mconfig\033[0m command options cannot be specified in the default options" << ::std::endl
       << "files:" << ::std::endl
       << ::std::endl
       << "--directory|-d" << ::std::endl
       << "--wipe" << ::std::endl;

    p = ::bdep::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

