Apache Axiom 1.2.13 Release Note
================================

Axiom 1.2.13 contains fixes for over thirty [JIRA issues][1] as well as lots of other improvements,
mainly related to XOP/MTOM processing, namespace handling, DOM support, documentation and code
quality.

The most prominent change in 1.2.13 is that Axiom no longer uses its own MIME parser, but instead
relies on [Apache James Mime4J][2] for XOP/MTOM processing. This was done in order to support
streaming of the content of MIME parts in XOP/MTOM messages: they can now be processed without
writing them to memory or disk first. This also applies to the root/SOAP part, which in previous
versions was always read into memory before parsing could start. For more information, see below.

Changes in this release
-----------------------

### Handling of illegal namespace declarations

Both XML 1.0 and XML 1.1 forbid binding a namespace prefix to the empty namespace name. Only the
default namespace can have an empty namespace name. In XML 1.0, prefixed namespace bindings may not
be empty, as explained in [section 5 of the Namespaces in XML 1.0 specification][3]:

> In a namespace declaration for a prefix (i.e., where the NSAttName is a PrefixedAttName), the
> attribute value MUST NOT be empty.

In Axiom 1.2.12, the `declareNamespace` methods in `OMElement` didn't enforce this constraint and
namespace declarations violating this requirement were silently dropped during serialization. This
behavior is problematic because it may result in subtle issues such as unbound namespace prefixes.
In Axiom 1.2.13 these methods have been changed so that they throw an exception if an attempt is
made to bind the empty namespace name to a prefix.

In XML 1.1, prefixed namespace bindings may be empty, but rather than binding the empty namespace
name to a prefix, such a namespace declaration "undeclares" the prefix, as explained in [section 5
of the Namespaces in XML 1.1 specification][4]:

> The namespace prefix, unless it is `xml` or `xmlns`, must have been declared in a namespace
> declaration attribute in either the start-tag of the element where the prefix is used or in an
> ancestor element (i.e. an element in whose content the prefixed markup occurs). Furthermore, the
> attribute value in the innermost such declaration must not be an empty string.

Although the same syntax is used in both cases, adding a namespace declaration to bind a prefix to a
(non empty) namespace URI and adding a namespace declaration to undeclare a prefix are two
fundamentally different operations from the point of view of the application. Therefore, to support
prefix undeclaring for XML 1.1 infosets, a new method `undeclarePrefix` has been added to
`OMElement` in Axiom 1.2.13.

As a corollary of the above, neither XML 1.0 nor XML 1.1 allows creating prefixed elements or
attributes with an empty namespace name. In Axiom 1.2.12, when attempting to create such invalid
information items, the behavior was inconsistent: in some cases, the prefix was silently dropped, in
other cases the invalid information item was actually created, resulting in problems during
serialization. Axiom 1.2.13 consistently throws an exception when an attempt is made to create such
an invalid information item.

### OMNamespace normalization

Methods that return an `OMNamespace` object may in principle use two different ways to represent the
absence of a namespace: as a `null` value or as an `OMNamespace` instance that has both prefix and
namespaceURI properties set to the empty string. This applies in particular to
`OMElement#getNamespace()`, `OMElement#getDefaultNamespace()` and `OMAttriute#getNamespace()`. The
API of Axiom 1.2.12 didn't clearly specify which representation was used, although in most cases a
`null` value was used. As a consequence application code had to take into account the possibility
that such methods returned `OMNamespace` instances with an empty prefix and namespace URI.

In Axiom 1.2.13 the situation has been clarified and the aforementioned APIs now always return
`null` to indicate the absence of a namespace. Note that this may have an impact on flawed
application code that doesn't handle `null` in the same way as an `OMNamespace` instance with an
empty prefix and namespace URI. Such application code needs to be fixed to work correctly with Axiom
1.2.13.

### New abstract APIs

Axiom 1.2.13 introduces a couple of new abstract APIs which give implementations of the Axiom API
the freedom to do additional optimizations. Application code should be migrated to take advantage of
these new APIs:

*   Instead of instantiating an `OMSource` object directly, `OMContainer#getSAXSource(boolean)`
    should be used.

*   `org.apache.axiom.om.impl.dom.DOOMAbstractFactory` has been deprecated because it ties
    application code that requires an object model factory supporting DOM to a particular Axiom
    implementation (DOOM). Instead use `OMAbstractFactory.getMetaFactory(String)` with
    `OMAbstractFactory.FEATURE_DOM` as parameter value to get a meta factory for an Axiom
    implementation that supports DOM.

*   The `DocumentBuilderFactory` implementation provided by DOOM should no longer be instantiated
    directly. Instead, application code should request a meta factory for DOM (see previous item),
    cast it to `DOMMetaFactory` and invoke `newDocumentBuilderFactory` via that interface.

The last two changes imply that `axiom-dom` should no longer be used as a compile time dependency,
but only as a runtime dependency.

Also note that some of the superseded APIs may disappear in Axiom 1.3.

### Usage of Apache James Mime4J as MIME parser

Starting with version 1.2.13, Axiom uses [Apache James Mime4J][2] as MIME parser implementation
instead of its own custom parser implementation. The public API as defined by the `Attachments`
class remains unchanged, with the following exceptions:

*   The `getIncomingAttachmentsAsSingleStream` method is no longer supported.

*   The `fileThreshold` specified during the construction of the `Attachments` object is now
    interpreted relative to the size of the decoded content of the attachment instead of the size of
    the encoded content. Note that this only makes a difference if the attachment has a content
    transfer encoding other than `binary`.

Several internal classes related to the old MIME parsing code have been removed, are no longer
public or have been changed in an incompatible way:

*   `MIMEBodyPartInputStream`
*   `BoundaryDelimitedStream`
*   `BoundaryPushbackInputStream`
*   `MultipartAttachmentStreams`
*   `PartFactory` and related classes

Although these classes were public, they are not considered part of the public API. Application code
that depends on these classes needs to be rewritten before upgrading to Axiom 1.2.13.

When upgrading to 1.2.13, projects that use Axiom's XOP/MTOM features must make sure that Apache
James Mime4J is added to the dependencies. For projects that use Maven (or tools that support Maven
repositories and metadata) this happens automatically. Projects that use other build tools must
explicity add the `apache-mime4j-core` library to the list of dependencies.

Axiom uses Mime4J in strict mode. This means that some non conforming MIME messages that would have
been processed successfully by previous Axiom versions may be rejected by Axiom 1.2.13. Please note
that Axiom doesn't make any guarantees about its ability to process invalid messages.

### Support for MIME part streaming

Axiom 1.2.13 has support for MIME part streaming. Pre-existing APIs continue to work as documented,
but there are some minor changes in behavior that may be visible to code that makes assumptions that
are not covered by the API contract:

*   The `DataHandler` instances returned by `Attachments` for MIME parts read from a stream now
    always implement `DataHandlerExt`, while in 1.2.12 this was only the case for parts buffered
    using temporary files. For memory buffered MIME parts, a call to `purgeDataSource` has the
    effect of releasing the allocated memory.

[1]: http://s.apache.org/axiom-changes-1.2.13
[2]: http://james.apache.org/mime4j/
[3]: http://www.w3.org/TR/2009/REC-xml-names-20091208/#ns-using
[4]: http://www.w3.org/TR/2006/REC-xml-names11-20060816/#ns-using
