/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.serializer.push.stax;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.ext.stax.datahandler.DataHandlerWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.impl.common.serializer.push.OutputException;
import org.apache.axiom.om.impl.common.serializer.push.Serializer;
import org.apache.axiom.om.impl.common.serializer.push.stax.StAXOutputException;
import org.apache.axiom.util.stax.XMLStreamWriterUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StAXSerializer
extends Serializer {
    private static final Log log = LogFactory.getLog(StAXSerializer.class);
    private final XMLStreamWriter writer;
    private DataHandlerWriter dataHandlerWriter;

    public StAXSerializer(OMSerializable root, XMLStreamWriter writer) {
        super(root, true, false);
        this.writer = writer;
    }

    protected void serializePushOMDataSource(OMDataSource dataSource) throws OutputException {
        try {
            dataSource.serialize(this.writer);
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    public void writeStartDocument(String version) throws OutputException {
        try {
            this.writer.writeStartDocument(version);
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    public void writeStartDocument(String encoding, String version) throws OutputException {
        try {
            this.writer.writeStartDocument(encoding, version);
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    public void writeDTD(String rootName, String publicId, String systemId, String internalSubset) throws OutputException {
        try {
            XMLStreamWriterUtils.writeDTD(this.writer, rootName, publicId, systemId, internalSubset);
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    protected void beginStartElement(String prefix, String namespaceURI, String localName) throws OutputException {
        try {
            this.writer.writeStartElement(prefix, localName, namespaceURI);
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    protected void addNamespace(String prefix, String namespaceURI) throws OutputException {
        try {
            if (prefix.length() != 0) {
                this.writer.writeNamespace(prefix, namespaceURI);
            } else {
                this.writer.writeDefaultNamespace(namespaceURI);
            }
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    protected void addAttribute(String prefix, String namespaceURI, String localName, String type, String value) throws OutputException {
        try {
            this.writer.writeAttribute(prefix, namespaceURI, localName, value);
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    protected void finishStartElement() throws OutputException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isAssociated(String prefix, String namespace) throws OutputException {
        try {
            String writerNS;
            NamespaceContext nsContext;
            if ("xml".equals(prefix)) {
                return true;
            }
            prefix = prefix == null ? "" : prefix;
            String string = namespace = namespace == null ? "" : namespace;
            if (namespace.length() > 0) {
                NamespaceContext nsContext2;
                String writerPrefix = this.writer.getPrefix(namespace);
                if (prefix.equals(writerPrefix)) {
                    return true;
                }
                if (writerPrefix == null || (nsContext2 = this.writer.getNamespaceContext()) == null) return false;
                String writerNS2 = nsContext2.getNamespaceURI(prefix);
                return namespace.equals(writerNS2);
            }
            if (prefix.length() > 0) {
                throw new OMException("Invalid namespace declaration: Prefixed namespace bindings may not be empty.");
            }
            try {
                String writerPrefix = this.writer.getPrefix("");
                if (writerPrefix == null || writerPrefix.length() != 0) return (nsContext = this.writer.getNamespaceContext()) == null || (writerNS = nsContext.getNamespaceURI("")) == null || writerNS.length() <= 0;
                return true;
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) return nsContext == null || (writerNS = nsContext.getNamespaceURI("")) == null || writerNS.length() <= 0;
                log.debug((Object)("Caught exception from getPrefix(\"\"). Processing continues: " + t));
            }
            nsContext = this.writer.getNamespaceContext();
            return nsContext == null || (writerNS = nsContext.getNamespaceURI("")) == null || writerNS.length() <= 0;
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    public void writeEndElement() throws OutputException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    public void writeText(int type, String data) throws OutputException {
        try {
            if (type == 12) {
                this.writer.writeCData(data);
            } else {
                this.writer.writeCharacters(data);
            }
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    public void writeComment(String data) throws OutputException {
        try {
            this.writer.writeComment(data);
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    public void writeProcessingInstruction(String target, String data) throws OutputException {
        try {
            this.writer.writeProcessingInstruction(target, data);
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    public void writeEntityRef(String name) throws OutputException {
        try {
            this.writer.writeEntityRef(name);
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    private DataHandlerWriter getDataHandlerWriter() {
        if (this.dataHandlerWriter == null) {
            this.dataHandlerWriter = XMLStreamWriterUtils.getDataHandlerWriter(this.writer);
        }
        return this.dataHandlerWriter;
    }

    public void writeDataHandler(DataHandler dataHandler, String contentID, boolean optimize) throws OutputException {
        try {
            this.getDataHandlerWriter().writeDataHandler(dataHandler, contentID, optimize);
        }
        catch (IOException ex) {
            throw new StAXOutputException(new XMLStreamException("Error while reading data handler", ex));
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    public void writeDataHandler(DataHandlerProvider dataHandlerProvider, String contentID, boolean optimize) throws OutputException {
        try {
            this.getDataHandlerWriter().writeDataHandler(dataHandlerProvider, contentID, optimize);
        }
        catch (IOException ex) {
            throw new StAXOutputException(new XMLStreamException("Error while reading data handler", ex));
        }
        catch (XMLStreamException ex) {
            throw new StAXOutputException(ex);
        }
    }

    public void writeEndDocument() throws OutputException {
    }
}

