/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.objects.checker;

import java.util.List;
import org.apache.wicket.core.util.objects.checker.AbstractObjectChecker;
import org.apache.wicket.core.util.objects.checker.IObjectChecker;
import org.apache.wicket.model.LoadableDetachableModel;

public class NotDetachedModelChecker
extends AbstractObjectChecker {
    public NotDetachedModelChecker() {
    }

    public NotDetachedModelChecker(List<Class<?>> exclusions) {
        super(exclusions);
    }

    @Override
    public IObjectChecker.Result doCheck(Object obj) {
        LoadableDetachableModel model;
        IObjectChecker.Result result = IObjectChecker.Result.SUCCESS;
        if (obj instanceof LoadableDetachableModel && (model = (LoadableDetachableModel)obj).isAttached()) {
            result = new IObjectChecker.Result(IObjectChecker.Result.Status.FAILURE, "Not detached model found!");
        }
        return result;
    }
}

