/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.bean.validation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.bean.validation.BeanValidationConfiguration;
import org.apache.wicket.bean.validation.BeanValidationContext;
import org.apache.wicket.bean.validation.ConstraintIterator;
import org.apache.wicket.bean.validation.GroupsModel;
import org.apache.wicket.bean.validation.IPropertyResolver;
import org.apache.wicket.bean.validation.ITagModifier;
import org.apache.wicket.bean.validation.Property;
import org.apache.wicket.bean.validation.ValidationModelResolver;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IPropertyReflectionAwareModel;
import org.apache.wicket.validation.INullAcceptingValidator;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;

public class PropertyValidator<T>
extends Behavior
implements INullAcceptingValidator<T> {
    private static final Class<?>[] EMPTY = new Class[0];
    private FormComponent<T> component;
    private Property property_;
    private final IModel<Class<?>[]> groups_;
    private boolean requiredFlagSet;

    public PropertyValidator(Class<?> ... groups) {
        this((Property)null, groups);
    }

    public PropertyValidator(IModel<Class<?>[]> groups) {
        this(null, groups);
    }

    public PropertyValidator(Property property, Class<?> ... groups) {
        this(property, (IModel<Class<?>[]>)new GroupsModel(groups));
    }

    public PropertyValidator(Property property, IModel<Class<?>[]> groups) {
        this.property_ = property;
        this.groups_ = groups;
    }

    private String createUnresolvablePropertyMessage(FormComponent<T> component) {
        String baseMessage = "Could not resolve Bean Property from component: " + String.valueOf(component) + ". (Hints:) Possible causes are a typo in the PropertyExpression, a null reference or a model that does not work in combination with a " + IPropertyResolver.class.getSimpleName() + ".";
        IPropertyReflectionAwareModel<?> model = ValidationModelResolver.resolvePropertyModelFrom(component);
        if (model != null) {
            baseMessage = baseMessage + " Model : " + String.valueOf(model);
        }
        return baseMessage;
    }

    private Property getProperty() {
        if (this.property_ == null) {
            BeanValidationContext config = BeanValidationConfiguration.get();
            this.property_ = config.resolveProperty(this.component);
            if (this.property_ == null) {
                throw new IllegalStateException(this.createUnresolvablePropertyMessage(this.component));
            }
        }
        return this.property_;
    }

    private Class<?>[] getGroups() {
        if (this.groups_ == null) {
            return EMPTY;
        }
        return (Class[])this.groups_.getObject();
    }

    public void bind(Component component) {
        if (this.component != null) {
            throw new IllegalStateException("This validator has already been added to component: " + String.valueOf(this.component) + ". This validator does not support reusing instances, please create a new one");
        }
        if (!(component instanceof FormComponent)) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " can only be added to FormComponents");
        }
        this.component = (FormComponent)component;
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (!this.requiredFlagSet) {
            this.requiredFlagSet = true;
            if (this.isRequired()) {
                this.component.setRequired(true);
            }
        }
    }

    public void detach(Component component) {
        super.detach(component);
        if (this.groups_ != null) {
            this.groups_.detach();
        }
    }

    protected boolean isRequired() {
        BeanValidationContext config = BeanValidationConfiguration.get();
        HashSet groups = new HashSet(Arrays.asList(this.getGroups()));
        ConstraintIterator it = new ConstraintIterator(config.getValidator(), this.getProperty(), new Class[0]);
        while (it.hasNext()) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)it.next();
            if (!config.isRequiredConstraint(constraint)) continue;
            if (this.canApplyToDefaultGroup(constraint) && groups.size() == 0) {
                return true;
            }
            for (Class constraintGroup : constraint.getGroups()) {
                if (!groups.contains(constraintGroup)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canApplyToDefaultGroup(ConstraintDescriptor<?> constraint) {
        Set groups = constraint.getGroups();
        return groups.size() == 0 || groups.contains(Default.class);
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        BeanValidationContext config = BeanValidationConfiguration.get();
        Validator validator = config.getValidator();
        Property property = this.getProperty();
        ConstraintIterator it = new ConstraintIterator(validator, property, this.getGroups());
        while (it.hasNext()) {
            ConstraintDescriptor desc = (ConstraintDescriptor)it.next();
            ITagModifier<? extends Annotation> modifier = config.getTagModifier(desc.getAnnotation().annotationType());
            if (modifier == null) continue;
            modifier.modify((FormComponent)component, tag, desc.getAnnotation());
        }
    }

    public void validate(IValidatable<T> validatable) {
        BeanValidationContext config = BeanValidationConfiguration.get();
        Validator validator = config.getValidator();
        Property property = this.getProperty();
        Set violations = validator.validateValue(property.getOwner(), property.getName(), validatable.getValue(), (Class[])this.getGroups());
        for (ConstraintViolation violation : violations) {
            validatable.error((IValidationError)config.getViolationTranslator().convert(violation));
        }
    }
}

