/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.internal;

import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.fit.internal.ClassLoaderUtils;
import org.apache.uima.impl.UimaVersion;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceManagerFactory.class);
    private static ResourceManagerCreator resourceManagerCreator = new DefaultResourceManagerCreator();

    private ResourceManagerFactory() {
    }

    public static ResourceManager newResourceManager() throws ResourceInitializationException {
        return resourceManagerCreator.newResourceManager();
    }

    public static synchronized void setResourceManagerCreator(ResourceManagerCreator resourceManagerCreator) {
        ResourceManagerFactory.resourceManagerCreator = resourceManagerCreator;
    }

    public static ResourceManagerCreator getResourceManagerCreator() {
        return resourceManagerCreator;
    }

    public static interface ResourceManagerCreator {
        public ResourceManager newResourceManager() throws ResourceInitializationException;
    }

    public static class DefaultResourceManagerCreator
    implements ResourceManagerCreator {
        @Override
        public ResourceManager newResourceManager() throws ResourceInitializationException {
            boolean uimaCoreIgnoresContextClassloader;
            ResourceManager resMgr;
            UimaContext activeContext = UimaContextHolder.getContext();
            if (activeContext != null) {
                LOG.trace("Using resource manager from active UIMA context");
                return ((UimaContextAdmin)activeContext).getResourceManager();
            }
            if (Thread.currentThread().getContextClassLoader() != null) {
                LOG.trace("Detected thread context classloader: preparing resource manager to use it");
                resMgr = new ResourceManager_impl(null);
            } else {
                resMgr = UIMAFramework.newDefaultResourceManager();
            }
            short maj = UimaVersion.getMajorVersion();
            short min = UimaVersion.getMinorVersion();
            short rev = UimaVersion.getBuildRevision();
            boolean bl = uimaCoreIgnoresContextClassloader = maj == 2 && (min < 10 || min == 10 && rev < 3) || maj == 3 && min == 0 && rev < 1;
            if (uimaCoreIgnoresContextClassloader) {
                LOG.trace("Detected UIMA version " + maj + "." + min + "." + rev + " which ignores the thread context classloader, setting it explicitly");
                resMgr.setExtensionClassLoader(ClassLoaderUtils.findClassloader(), true);
            }
            return resMgr;
        }
    }
}

