/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.tools.docanalyzer.AnnotationViewerDialog;
import org.apache.uima.tools.docanalyzer.PrefsMediator;
import org.apache.uima.tools.images.Images;
import org.apache.uima.tools.util.gui.AboutDialog;
import org.apache.uima.tools.util.gui.Caption;
import org.apache.uima.tools.util.gui.FileSelector;
import org.apache.uima.tools.util.gui.SpringUtilities;
import org.apache.uima.tools.util.htmlview.AnnotationViewGenerator;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;

public class AnnotationViewerMain
extends JFrame {
    private static final long serialVersionUID = -3201723535833938833L;
    private static final String HELP_MESSAGE = "Instructions for using Annotation Viewer:\n\n1) In the \"Input Directory\" field, either type or use the browse\nbutton to select a directory containing the analyzed documents\n (in XMI or XCAS format) that you want to view.\n\n2) In the \"TypeSystem or AE Descriptor File\" field, either type or use the browse\nbutton to select the TypeSystem or AE descriptor for the AE that generated the\nXMI or XCAS files.  (This is needed for type system infornation only.\nAnalysis will not be redone.)\n\n3) Click the \"View\" button at the buttom of the window.\n\nA list of the analyzed documents will be displayed.\n\n\n4) Select the view type -- either the Java annotation viewer, HTML,\nor XML.  The Java annotation viewer is recommended.\n\n5) Double-click on a document to view it.\n";
    private File uimaHomeDir;
    private FileSelector inputFileSelector;
    private FileSelector taeDescriptorFileSelector;
    private JButton viewButton;
    private JDialog aboutDialog;
    private Preferences prefs = Preferences.userRoot().node("org/apache/uima/tools/AnnotationViewer");

    public AnnotationViewerMain() {
        super("Annotation Viewer");
        this.uimaHomeDir = new File(System.getProperty("uima.home", "C:/Program Files/apache-uima"));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Could not set look and feel: " + e.getMessage());
        }
        try {
            this.setIconImage(Images.getImage("/org/apache/uima/tools/images/Micro_16.gif"));
        }
        catch (IOException e) {
            System.err.println("Image could not be loaded: " + e.getMessage());
        }
        this.getContentPane().setBackground(Color.WHITE);
        this.aboutDialog = new AboutDialog(this, "About Annotation Viewer");
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        JMenu helpMenu = new JMenu("Help");
        JMenuItem aboutMenuItem = new JMenuItem("About");
        JMenuItem helpMenuItem = new JMenuItem("Help");
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        fileMenu.add(exitMenuItem);
        helpMenu.add(aboutMenuItem);
        helpMenu.add(helpMenuItem);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        Caption labelInputDir = new Caption("Input Directory: ");
        Caption labelStyleMapFile = new Caption("TypeSystem or AE Descriptor File: ");
        JPanel controlPanel = new JPanel();
        controlPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        controlPanel.setLayout(new SpringLayout());
        File inputDir = new File(this.uimaHomeDir, "examples/data/processed");
        this.inputFileSelector = new FileSelector("", "Input Directory", 1, inputDir);
        this.inputFileSelector.setSelected(inputDir.getAbsolutePath());
        this.taeDescriptorFileSelector = new FileSelector("", "TAE Descriptor File", 0, this.uimaHomeDir);
        File descriptorFile = new File(this.uimaHomeDir, "examples/descriptors/analysis_engine/PersonTitleAnnotator.xml");
        this.taeDescriptorFileSelector.setSelected(descriptorFile.getAbsolutePath());
        controlPanel.add(labelInputDir);
        controlPanel.add(this.inputFileSelector);
        controlPanel.add(labelStyleMapFile);
        controlPanel.add(this.taeDescriptorFileSelector);
        SpringUtilities.makeCompactGrid(controlPanel, 2, 2, 4, 4, 4, 4);
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AnnotationViewerMain.this.savePreferences();
                System.exit(0);
            }
        });
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AnnotationViewerMain.this.aboutDialog.setVisible(true);
            }
        });
        helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JOptionPane.showMessageDialog(AnnotationViewerMain.this, AnnotationViewerMain.HELP_MESSAGE, "Annotation Viewer Help", -1);
            }
        });
        Container contentPanel = this.getContentPane();
        contentPanel.add((Component)controlPanel, "Center");
        JLabel banner = new JLabel(Images.getImageIcon("/org/apache/uima/tools/images/UIMA_banner2tlp.png"));
        contentPanel.add((Component)banner, "North");
        this.viewButton = new JButton("View");
        JPanel lowerButtonsPanel = new JPanel();
        lowerButtonsPanel.add(this.viewButton);
        contentPanel.add((Component)lowerButtonsPanel, "South");
        this.setContentPane(contentPanel);
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ee) {
                try {
                    AnnotationViewerMain.this.viewDocuments();
                }
                catch (Exception e) {
                    AnnotationViewerMain.this.displayError(e);
                }
            }
        });
        if (System.getProperty("uima.noprefs") == null) {
            this.restorePreferences();
        }
    }

    public void viewDocuments() throws InvalidXMLException, IOException, ResourceInitializationException {
        File styleMapFile;
        CAS cas;
        File descriptorFile = new File(this.taeDescriptorFileSelector.getSelected());
        if (!descriptorFile.exists() || descriptorFile.isDirectory()) {
            this.displayError("Descriptor File \"" + descriptorFile.getPath() + "\" does not exist.");
            return;
        }
        File inputDir = new File(this.inputFileSelector.getSelected());
        if (!inputDir.exists() || !inputDir.isDirectory()) {
            this.displayError("Input Directory \"" + inputDir.getPath() + "\" does not exist.");
            return;
        }
        XMLizable descriptor = UIMAFramework.getXMLParser().parse(new XMLInputSource(descriptorFile));
        if (descriptor instanceof AnalysisEngineDescription) {
            cas = CasCreationUtils.createCas((AnalysisEngineDescription)((AnalysisEngineDescription)descriptor));
            styleMapFile = this.getStyleMapFile((AnalysisEngineDescription)descriptor, descriptorFile.getPath());
        } else if (descriptor instanceof TypeSystemDescription) {
            TypeSystemDescription tsDesc = (TypeSystemDescription)descriptor;
            tsDesc.resolveImports();
            cas = CasCreationUtils.createCas((TypeSystemDescription)tsDesc, null, (FsIndexDescription[])new FsIndexDescription[0]);
            styleMapFile = this.getStyleMapFile((TypeSystemDescription)descriptor, descriptorFile.getPath());
        } else {
            this.displayError("Invalid Descriptor File \"" + descriptorFile.getPath() + "\"Must be either an AnalysisEngine or TypeSystem descriptor.");
            return;
        }
        PrefsMediator prefsMed = new PrefsMediator();
        prefsMed.setOutputDir(inputDir.toString());
        AnnotationViewerDialog viewerDialog = new AnnotationViewerDialog(this, "Analyzed Documents", prefsMed, styleMapFile, null, cas.getTypeSystem(), null, false, cas);
        viewerDialog.pack();
        viewerDialog.setModal(true);
        viewerDialog.setVisible(true);
    }

    private File getStyleMapFile(AnalysisEngineDescription tad, String descFileName) throws IOException {
        File styleMapFile = this.getStyleMapFileName(descFileName);
        if (!styleMapFile.exists()) {
            String xml = AnnotationViewGenerator.autoGenerateStyleMap(tad.getAnalysisEngineMetaData());
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(styleMapFile)));
            writer.println(xml);
            writer.close();
        }
        return styleMapFile;
    }

    private File getStyleMapFile(TypeSystemDescription tsd, String descFileName) throws IOException {
        File styleMapFile = this.getStyleMapFileName(descFileName);
        if (!styleMapFile.exists()) {
            String xml = AnnotationViewGenerator.autoGenerateStyleMap(tsd);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(styleMapFile)));
            writer.println(xml);
            writer.close();
        }
        return styleMapFile;
    }

    public File getStyleMapFileName(String aDescriptorFileName) {
        int index = aDescriptorFileName.lastIndexOf(".");
        String baseName = index > 0 ? aDescriptorFileName.substring(0, index) : aDescriptorFileName;
        return new File(baseName + "StyleMap.xml");
    }

    public static void main(String[] args) {
        final AnnotationViewerMain frame = new AnnotationViewerMain();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.savePreferences();
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    public void savePreferences() {
        this.prefs.put("inDir", this.inputFileSelector.getSelected());
        this.prefs.put("taeDescriptorFile", this.taeDescriptorFileSelector.getSelected());
    }

    public void restorePreferences() {
        File defaultInputDir = new File(this.uimaHomeDir, "examples/data/processed");
        File defaultTaeDescriptorFile = new File(this.uimaHomeDir, "examples/descriptors/analysis_engine/PersonTitleAnnotator.xml");
        this.inputFileSelector.setSelected(this.prefs.get("inDir", defaultInputDir.toString()));
        this.taeDescriptorFileSelector.setSelected(this.prefs.get("taeDescriptorFile", defaultTaeDescriptorFile.toString()));
    }

    public void displayError(String aErrorString) {
        StringBuffer buf = new StringBuffer(aErrorString.length());
        int CHARS_PER_LINE = 80;
        int charCount = 0;
        StringTokenizer tokenizer = new StringTokenizer(aErrorString, " \n", true);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.equals("\n")) {
                buf.append("\n");
                charCount = 0;
                continue;
            }
            if (charCount > 0 && charCount + tok.length() > 80) {
                buf.append("\n").append(tok);
                charCount = tok.length();
                continue;
            }
            buf.append(tok);
            charCount += tok.length();
        }
        JOptionPane.showMessageDialog(this, buf.toString(), "Error", 0);
    }

    public void displayError(Throwable aThrowable) {
        aThrowable.printStackTrace();
        String message = aThrowable.toString();
        while (aThrowable instanceof UIMAException || aThrowable instanceof UIMARuntimeException) {
            if (aThrowable instanceof UIMAException) {
                aThrowable = ((UIMAException)aThrowable).getCause();
            } else if (aThrowable instanceof UIMARuntimeException) {
                aThrowable = ((UIMARuntimeException)aThrowable).getCause();
            }
            if (aThrowable == null) continue;
            message = message + "\nCausedBy: " + aThrowable.toString();
        }
        this.displayError(message);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(640, 200);
    }
}

