/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CasInitializer;
import org.apache.uima.collection.CasInitializerDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.base_cpm.BaseCollectionReader;
import org.apache.uima.collection.base_cpm.CasDataCollectionReader;
import org.apache.uima.collection.base_cpm.CasDataConsumer;
import org.apache.uima.collection.base_cpm.CasDataInitializer;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.collection.impl.cpm.CPMException;
import org.apache.uima.collection.impl.cpm.container.CasObjectNetworkCasProcessorImpl;
import org.apache.uima.collection.impl.cpm.container.NetworkCasProcessorImpl;
import org.apache.uima.collection.impl.cpm.container.deployer.DeployFactory;
import org.apache.uima.collection.impl.cpm.utils.CPMUtils;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptionImpl;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptorFactory;
import org.apache.uima.collection.impl.metadata.cpe.CpeIntegratedCasProcessorImpl;
import org.apache.uima.collection.metadata.CasProcessorConfigurationParameterSettings;
import org.apache.uima.collection.metadata.CasProcessorDeploymentParam;
import org.apache.uima.collection.metadata.CasProcessorDeploymentParams;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCasProcessors;
import org.apache.uima.collection.metadata.CpeCollectionReader;
import org.apache.uima.collection.metadata.CpeCollectionReaderCasInitializer;
import org.apache.uima.collection.metadata.CpeCollectionReaderIterator;
import org.apache.uima.collection.metadata.CpeConfiguration;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.collection.metadata.CpeResourceManagerConfiguration;
import org.apache.uima.collection.metadata.CpeSofaMapping;
import org.apache.uima.collection.metadata.CpeSofaMappings;
import org.apache.uima.collection.metadata.NameValuePair;
import org.apache.uima.internal.util.Class_TCCL;
import org.apache.uima.resource.ConfigurableResource_ImplBase;
import org.apache.uima.resource.ConfigurationManager;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.impl.NameValuePair_impl;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.XMLInputSource;

public class CPEFactory {
    public static final String CPM_HOME = "${CPM_HOME}";
    private int processorCount = 0;
    private String DEFAULT_CONFIG_FILE = "defaultCpeDescriptor.xml";
    private boolean defaultConfig = true;
    public HashMap casProcessorConfigMap = new HashMap();
    private CpeDescription cpeDescriptor = null;
    private boolean initialized = false;
    private UimaContextAdmin uimaContext;
    private boolean firstTime = true;
    private HashMap cpMap = new HashMap();

    public CPEFactory(ResourceManager aResourceManager) {
        if (aResourceManager == null) {
            aResourceManager = UIMAFramework.newDefaultResourceManager();
        }
        this.uimaContext = UIMAFramework.newUimaContext((Logger)UIMAFramework.getLogger(), (ResourceManager)aResourceManager, (ConfigurationManager)UIMAFramework.newConfigurationManager());
    }

    public CPEFactory(CpeDescription aDescriptor, ResourceManager aResourceManager) throws ResourceInitializationException {
        if (aDescriptor == null) {
            throw new UIMARuntimeException((Throwable)new InvalidObjectException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_no_cpe_descriptor__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        if (aResourceManager == null) {
            aResourceManager = UIMAFramework.newDefaultResourceManager();
        }
        this.setCpeDescriptor(aDescriptor);
        if (aDescriptor != null && aDescriptor instanceof CpeDescriptionImpl) {
            this.defaultConfig = false;
        }
        this.uimaContext = UIMAFramework.newUimaContext((Logger)UIMAFramework.getLogger(), (ResourceManager)aResourceManager, (ConfigurationManager)UIMAFramework.newConfigurationManager());
        CpeResourceManagerConfiguration resMgrCfgDesc = aDescriptor.getResourceManagerConfiguration();
        if (resMgrCfgDesc != null) {
            try {
                if (resMgrCfgDesc.get().length() > 0) {
                    String descriptorPath = CPMUtils.convertToAbsolutePath(System.getProperty("CPM_HOME"), CPM_HOME, resMgrCfgDesc.get());
                    ResourceManagerConfiguration resMgrCfg = UIMAFramework.getXMLParser().parseResourceManagerConfiguration(new XMLInputSource(descriptorPath));
                    aResourceManager.initializeExternalResources(resMgrCfg, "/", null);
                }
            }
            catch (InvalidXMLException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    public void parse(String aDescriptor) throws InstantiationException {
        this.defaultConfig = false;
        if (aDescriptor == null || aDescriptor.trim().length() == 0) {
            throw new UIMARuntimeException((Throwable)new FileNotFoundException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_no_cpe_descriptor__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        try {
            this.setCpeDescriptor(CpeDescriptorFactory.produceDescriptor(new FileInputStream(new File(aDescriptor))));
        }
        catch (Exception e) {
            throw new UIMARuntimeException("invalid_descriptor_file", new Object[]{aDescriptor}, (Throwable)e);
        }
    }

    public void parse(InputStream aDescriptorStream) throws InstantiationException {
        this.defaultConfig = false;
        if (aDescriptorStream == null) {
            throw new UIMARuntimeException((Throwable)new IOException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_cpe_descriptor_stream__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        try {
            this.setCpeDescriptor(CpeDescriptorFactory.produceDescriptor(aDescriptorStream));
        }
        catch (Exception e) {
            throw new UIMARuntimeException((Throwable)e);
        }
    }

    public void parse() {
        this.defaultConfig = true;
        InputStream defaultDescriptorStream = this.getClass().getResourceAsStream(this.DEFAULT_CONFIG_FILE);
        try {
            this.setCpeDescriptor(CpeDescriptorFactory.produceDescriptor(defaultDescriptorStream));
        }
        catch (Exception e) {
            throw new UIMARuntimeException((Throwable)e);
        }
        finally {
            try {
                defaultDescriptorStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void checkForErrors() throws ResourceConfigurationException {
        if (this.cpeDescriptor == null) {
            throw new ResourceConfigurationException((Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_no_cpe_descriptor__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
    }

    public BaseCollectionReader getCollectionReader() throws ResourceConfigurationException {
        this.checkForErrors();
        BaseCollectionReader colreader = null;
        try {
            CpeCollectionReader reader = this.getCpeDescriptor().getAllCollectionCollectionReaders()[0];
            if (reader == null) {
                throw new ResourceConfigurationException("element_not_found", new Object[]{"<collectionReader>", "<cpeDescriptor>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_required_element__WARNING", new Object[]{Thread.currentThread().getName(), "<collectionReader>"})));
            }
            CpeCollectionReaderIterator cit = reader.getCollectionIterator();
            if (cit == null || cit.getDescriptor() == null || cit.getDescriptor().getInclude() == null && cit.getDescriptor().getImport() == null) {
                throw new ResourceConfigurationException("element_not_found", new Object[]{"<include>", "<collectionIterator>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_required_element__WARNING", new Object[]{Thread.currentThread().getName(), "<include> or <import>"})));
            }
            if (cit.getDescriptor().getInclude() != null && cit.getDescriptor().getInclude().get() == null) {
                throw new ResourceConfigurationException("element_not_found", new Object[]{"<href>", "<collectionIterator>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), "<href>", "<collectionIterator>"})));
            }
            URL descriptorUrl = cit.getDescriptor().findAbsoluteUrl(this.getResourceManager());
            XMLInputSource in1 = new XMLInputSource(descriptorUrl);
            CollectionReaderDescription colReaderSp = UIMAFramework.getXMLParser().parseCollectionReaderDescription(in1);
            this.overrideParameterSettings((ResourceSpecifier)colReaderSp, cit.getConfigurationParameterSettings(), "Collection Reader");
            CpeSofaMappings sofanamemappings = cit.getSofaNameMappings();
            HashMap<String, String> sofamap = new HashMap<String, String>();
            if (sofanamemappings != null) {
                CpeSofaMapping[] sofaNameMappingArray = sofanamemappings.getSofaNameMappings();
                for (int i = 0; sofaNameMappingArray != null && i < sofaNameMappingArray.length; ++i) {
                    CpeSofaMapping aSofaMap = sofaNameMappingArray[i];
                    if (aSofaMap.getComponentSofaName() == null) {
                        aSofaMap.setComponentSofaName("_InitialView");
                    }
                    sofamap.put(aSofaMap.getComponentSofaName(), aSofaMap.getCpeSofaName());
                }
            }
            UimaContextAdmin collectionReaderContext = this.uimaContext.createChild("_CollectionReader", sofamap);
            HashMap<String, UimaContextAdmin> additionalParams = new HashMap<String, UimaContextAdmin>();
            additionalParams.put("UIMA_CONTEXT", collectionReaderContext);
            colreader = (BaseCollectionReader)UIMAFramework.produceResource(BaseCollectionReader.class, (ResourceSpecifier)colReaderSp, (ResourceManager)this.getResourceManager(), additionalParams);
            CpeCollectionReaderCasInitializer casInit = reader.getCasInitializer();
            if (casInit != null) {
                if (casInit.getDescriptor() == null) {
                    throw new ResourceConfigurationException("element_not_found", new Object[]{"<descriptor>", "<casInitializer>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_required_element__WARNING", new Object[]{Thread.currentThread().getName(), "<descriptor>"})));
                }
                if (casInit.getDescriptor().getInclude() == null && casInit.getDescriptor().getImport() == null) {
                    throw new ResourceConfigurationException("element_not_found", new Object[]{"<include>", "<casInitializer>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_required_element__WARNING", new Object[]{Thread.currentThread().getName(), "<include> or <import>"})));
                }
                if (casInit.getDescriptor().getInclude() != null && (casInit.getDescriptor().getInclude().get() == null || casInit.getDescriptor().getInclude().get().length() == 0)) {
                    throw new ResourceConfigurationException("element_not_found", new Object[]{"<href>", "<casInitializer>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), "<href>", "<casInitializer>"})));
                }
                URL casInitDescUrl = casInit.getDescriptor().findAbsoluteUrl(this.getResourceManager());
                XMLInputSource in4 = new XMLInputSource(casInitDescUrl);
                CasInitializerDescription casIniSp = UIMAFramework.getXMLParser().parseCasInitializerDescription(in4);
                this.overrideParameterSettings((ResourceSpecifier)casIniSp, casInit.getConfigurationParameterSettings(), "Cas Initializer");
                CpeSofaMappings sofaNamemappings = casInit.getSofaNameMappings();
                sofamap = new HashMap();
                if (sofaNamemappings != null) {
                    CpeSofaMapping[] sofaNameMappingArray = sofaNamemappings.getSofaNameMappings();
                    for (int i = 0; sofaNameMappingArray != null && i < sofaNameMappingArray.length; ++i) {
                        CpeSofaMapping aSofaMap = sofaNameMappingArray[i];
                        if (aSofaMap.getComponentSofaName() == null) {
                            aSofaMap.setComponentSofaName("_InitialView");
                        }
                        sofamap.put(aSofaMap.getComponentSofaName(), aSofaMap.getCpeSofaName());
                    }
                }
                UimaContextAdmin initializerContext = this.uimaContext.createChild("_CasInitializer", sofamap);
                additionalParams.put("UIMA_CONTEXT", initializerContext);
                Object initializer = this.produceInitializer((ResourceSpecifier)casIniSp, additionalParams);
                if (initializer instanceof CasDataInitializer) {
                    ((CasDataCollectionReader)colreader).setCasInitializer((CasDataInitializer)initializer);
                } else if (initializer instanceof CasInitializer) {
                    ((CollectionReader)colreader).setCasInitializer((CasInitializer)initializer);
                } else {
                    throw new ResourceConfigurationException("invalid_element_type", new Object[]{"CasDataInitializer", initializer.getClass().getName()}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_incompatible_component__WARNING", new Object[]{Thread.currentThread().getName(), "CasInitializer", "CasDataInitializer", initializer.getClass().getName()})));
                }
            }
            long numDocs2Process = this.getCPEConfig().getNumToProcess();
            if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_docs_to_process__CONFIG", new Object[]{Thread.currentThread().getName(), String.valueOf(numDocs2Process)});
            }
            ((ConfigurableResource_ImplBase)colreader).setConfigParameterValue("processSize", (Object)((int)numDocs2Process));
            CpeConfiguration cpeType = this.getCpeDescriptor().getCpeConfiguration();
            if (cpeType != null && cpeType.getStartingEntityId() != null && cpeType.getStartingEntityId().trim().length() > 0) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_start_doc_id__FINEST", new Object[]{Thread.currentThread().getName(), cpeType.getStartingEntityId()});
                }
                colreader.getProcessingResourceMetaData().getConfigurationParameterSettings().setParameterValue("startNumber", (Object)cpeType.getStartingEntityId().trim());
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Retrieved Documents Starting with DocId ::" + colreader.getProcessingResourceMetaData().getConfigurationParameterSettings().getParameterValue("startNumber"));
                }
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Retrieved processSize ::" + ((ConfigurableResource_ImplBase)colreader).getConfigParameterValue("processSize"));
            }
            return colreader;
        }
        catch (ResourceConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceConfigurationException((Throwable)e);
        }
    }

    public CasProcessor[] getCasProcessors() throws ResourceConfigurationException {
        this.checkForErrors();
        try {
            if (this.getCpeDescriptor().getCpeCasProcessors() == null) {
                throw new ResourceConfigurationException("element_not_found", new Object[]{"<casProcessors>", "<cpeDescriptor>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_cpe_descriptor__WARNING", new Object[]{Thread.currentThread().getName()})));
            }
            CpeCasProcessors ct = this.getCpeDescriptor().getCpeCasProcessors();
            CpeCasProcessor[] casProcessorList = ct.getAllCpeCasProcessors();
            Vector<CasProcessor> v = new Vector<CasProcessor>();
            if (casProcessorList == null || casProcessorList.length == 0) {
                throw new ResourceConfigurationException("element_not_found", new Object[]{"<casProcessor>", "<casProcessors>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_cpe_descriptor__WARNING", new Object[]{Thread.currentThread().getName()})));
            }
            Hashtable<String, String> namesMap = new Hashtable<String, String>();
            for (int i = 0; i < casProcessorList.length; ++i) {
                String name;
                CpeCasProcessor processorType = casProcessorList[i];
                if (processorType == null) {
                    throw new ResourceConfigurationException("element_not_found", new Object[]{"<casProcessor>", "<casProcessors>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_cpe_descriptor__WARNING", new Object[]{Thread.currentThread().getName()})));
                }
                if (namesMap.containsKey(processorType.getName())) {
                    throw new ResourceConfigurationException("invalid_cpe_descriptor", new Object[]{"casProcessor", "name"}, (Throwable)new CPMException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_duplicate_name__WARNING", new Object[]{Thread.currentThread().getName(), processorType.getName()})));
                }
                namesMap.put(processorType.getName(), processorType.getName());
                String deploymentType = processorType.getDeployment();
                if (deploymentType == null) {
                    throw new ResourceConfigurationException("required_attribute_missing", new Object[]{"deployment", "<casProcessor>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), processorType.getName(), "deployment", "casProcessor"})));
                }
                CasProcessor casProcessor = null;
                String deployModel = "";
                boolean cpInMap = false;
                if (this.cpMap.containsKey(processorType.getName())) {
                    cpInMap = true;
                    casProcessor = (CasProcessor)this.cpMap.get(processorType.getName());
                    if (!casProcessor.getProcessingResourceMetaData().getOperationalProperties().isMultipleDeploymentAllowed()) continue;
                }
                if ("local".equals(deploymentType.toLowerCase())) {
                    casProcessor = this.produceLocalCasProcessor(processorType);
                    deployModel = "local";
                } else if ("integrated".equals(deploymentType.toLowerCase())) {
                    casProcessor = this.produceIntegratedCasProcessor(processorType);
                    deployModel = "integrated";
                } else if ("remote".equals(deploymentType.toLowerCase())) {
                    casProcessor = this.produceRemoteCasProcessor(processorType);
                    deployModel = "remote";
                } else {
                    throw new ResourceConfigurationException("required_attribute_missing", new Object[]{"deployment", "<casProcessor>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_Exception_invalid_deployment__WARNING", new Object[]{Thread.currentThread().getName(), processorType.getName(), deploymentType})));
                }
                if (!cpInMap) {
                    this.cpMap.put(processorType.getName(), casProcessor);
                }
                if (!this.casProcessorConfigMap.containsKey(name = casProcessor.getProcessingResourceMetaData().getName())) {
                    this.casProcessorConfigMap.put(name, processorType);
                } else if (this.firstTime && "integrated".equalsIgnoreCase(deployModel)) {
                    throw new ResourceConfigurationException((Throwable)new CPMException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_duplicate_name__WARNING", new Object[]{Thread.currentThread().getName(), processorType.getName()})));
                }
                v.add(casProcessor);
            }
            Object[] processors = new CasProcessor[v.size()];
            v.copyInto(processors);
            Object[] objectArray = processors;
            return objectArray;
        }
        catch (ResourceConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceConfigurationException((Throwable)e);
        }
        finally {
            this.firstTime = false;
        }
    }

    public boolean isDefinitionInstanceOf(Class aResourceClass, ResourceSpecifier resourceSpecifier, String aDescriptor) throws ResourceConfigurationException {
        boolean validDefinition = false;
        String implementationClass = null;
        try {
            String frameworkName = null;
            if (resourceSpecifier instanceof AnalysisEngineDescription) {
                frameworkName = ((AnalysisEngineDescription)resourceSpecifier).getFrameworkImplementation();
                implementationClass = ((AnalysisEngineDescription)resourceSpecifier).getImplementationName();
            } else if (resourceSpecifier instanceof CasConsumerDescription) {
                frameworkName = ((CasConsumerDescription)resourceSpecifier).getFrameworkImplementation();
                implementationClass = ((CasConsumerDescription)resourceSpecifier).getImplementationName();
            } else {
                return false;
            }
            if (frameworkName.startsWith("org.apache.uima.cpp")) {
                validDefinition = true;
            } else {
                Class currentClass = Class_TCCL.forName((String)implementationClass, (ResourceManager)this.getResourceManager());
                if (aResourceClass.isAssignableFrom(currentClass)) {
                    validDefinition = true;
                }
            }
        }
        catch (Exception e) {
            throw new ResourceConfigurationException("class_not_found", new Object[]{implementationClass, aDescriptor}, (Throwable)e);
        }
        return validDefinition;
    }

    public CasProcessor produceCasDataConsumer(Class aResourceClass, ResourceSpecifier aSpecifier, Map aAdditionalParams) throws ResourceInitializationException {
        String className = null;
        try {
            CasDataConsumer casProcessor;
            Class<?> currentClass;
            className = ((CasConsumerDescription)aSpecifier).getImplementationName();
            ClassLoader cl = null;
            ResourceManager rm = this.getResourceManager();
            if (rm != null) {
                cl = rm.getExtensionClassLoader();
            }
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            if (aResourceClass.isAssignableFrom(currentClass = Class.forName(className, true, cl)) && (casProcessor = (CasDataConsumer)currentClass.newInstance()).initialize(aSpecifier, aAdditionalParams)) {
                return casProcessor;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException("class_not_found", new Object[]{className, aSpecifier.getSourceUrlString()}, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceInitializationException("could_not_instantiate", new Object[]{className, aSpecifier.getSourceUrlString()}, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ResourceInitializationException("could_not_instantiate", new Object[]{className, aSpecifier.getSourceUrlString()}, (Throwable)e);
        }
        return null;
    }

    private Object produceInitializer(ResourceSpecifier aSpecifier, Map aAdditionalParams) throws ResourceInitializationException {
        String className = null;
        try {
            className = ((CasInitializerDescription)aSpecifier).getImplementationName();
            Class currentClass = Class_TCCL.forName((String)className, (ResourceManager)this.getResourceManager());
            Object initializer = currentClass.newInstance();
            if (initializer instanceof CasInitializer) {
                ((CasInitializer)initializer).initialize(aSpecifier, aAdditionalParams);
                return initializer;
            }
            if (initializer instanceof CasDataInitializer) {
                ((CasDataInitializer)initializer).initialize(aSpecifier, aAdditionalParams);
                return initializer;
            }
            throw new InstantiationException("Unexpected CasInitializer-" + initializer.getClass().getName());
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException("class_not_found", new Object[]{className, aSpecifier.getSourceUrlString()}, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ResourceInitializationException("could_not_instantiate", new Object[]{className, aSpecifier.getSourceUrlString()}, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ResourceInitializationException("could_not_instantiate", new Object[]{className, aSpecifier.getSourceUrlString()}, (Throwable)e);
        }
    }

    public URL getDescriptorURL(CpeCasProcessor aCasProcessorCfg) throws ResourceConfigurationException {
        if (aCasProcessorCfg.getCpeComponentDescriptor() == null) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"descriptor", "casProcessor"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorCfg.getName(), "descriptor"})));
        }
        return aCasProcessorCfg.getCpeComponentDescriptor().findAbsoluteUrl(this.getResourceManager());
    }

    public ResourceSpecifier getSpecifier(URL aDescriptorUrl) throws Exception {
        XMLInputSource in = new XMLInputSource(aDescriptorUrl);
        return UIMAFramework.getXMLParser().parseResourceSpecifier(in);
    }

    private CasProcessor produceLocalCasProcessor(CpeCasProcessor aCasProcessorCfg) throws ResourceConfigurationException {
        if (aCasProcessorCfg == null) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"casProcessor", "casProcessors"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_cpe_descriptor_no_cp__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        NetworkCasProcessorImpl casProcessor = new NetworkCasProcessorImpl(aCasProcessorCfg);
        return casProcessor;
    }

    private org.apache.uima.resource.metadata.NameValuePair findMatchingNameValuePair(ConfigurationParameterSettings aCps, String aParamName) throws Exception {
        org.apache.uima.resource.metadata.NameValuePair[] nvp = aCps.getParameterSettings();
        for (int i = 0; nvp != null && i < nvp.length; ++i) {
            if (nvp[i].getName() == null || !nvp[i].getName().equalsIgnoreCase(aParamName)) continue;
            return nvp[i];
        }
        return null;
    }

    private void replacePrimitive(String aType, boolean aMandatoryParam, ConfigurationParameterSettings aCps, NameValuePair aCPE_nvp, String aComponentName) throws Exception {
        boolean newParamSetting = false;
        Object aValueObject = aCPE_nvp.getValue();
        String param_name = aCPE_nvp.getName();
        org.apache.uima.resource.metadata.NameValuePair nvp = this.findMatchingNameValuePair(aCps, param_name.trim());
        if (nvp == null) {
            newParamSetting = true;
            nvp = new NameValuePair_impl();
            nvp.setName(param_name);
        }
        if (aType.equals("String") && aValueObject instanceof String) {
            nvp.setValue(aValueObject);
        } else if (aType.equals("Integer") && aValueObject instanceof Integer) {
            nvp.setValue(aValueObject);
        } else if (aType.equals("Float") && aValueObject instanceof Float) {
            nvp.setValue(aValueObject);
        } else if (aType.equals("Boolean") && aValueObject instanceof Boolean) {
            nvp.setValue(aValueObject);
        }
        if (newParamSetting) {
            aCps.setParameterValue(null, nvp.getName(), nvp.getValue());
        }
    }

    private void replaceArray(String aType, boolean aMandatoryParam, ConfigurationParameterSettings aCps, NameValuePair aCPE_nvp, String aComponentName) throws Exception {
        boolean newParamSetting = false;
        Object valueObject = aCPE_nvp.getValue();
        String param_name = aCPE_nvp.getName();
        org.apache.uima.resource.metadata.NameValuePair nvp = this.findMatchingNameValuePair(aCps, param_name.trim());
        if (nvp == null) {
            newParamSetting = true;
            nvp = new NameValuePair_impl();
            nvp.setName(param_name);
        }
        if (aType.equals("String") && valueObject instanceof String[]) {
            nvp.setValue(valueObject);
        } else if (aType.equals("Integer") && valueObject instanceof Integer[]) {
            nvp.setValue(valueObject);
        } else if (aType.equals("Float") && valueObject instanceof Float[]) {
            nvp.setValue(valueObject);
        } else if (aType.equals("Boolean") && valueObject instanceof Boolean[]) {
            nvp.setValue(valueObject);
        }
        if (newParamSetting) {
            aCps.setParameterValue(null, nvp.getName(), nvp.getValue());
        }
    }

    private boolean overrideParameterIfExists(ResourceSpecifier aResourceSpecifier, NameValuePair aCPE_nvp, String aComponentName) throws Exception {
        String param_name;
        ConfigurationParameterDeclarations cpd = ((ResourceCreationSpecifier)aResourceSpecifier).getMetaData().getConfigurationParameterDeclarations();
        ConfigurationParameter cparam = cpd.getConfigurationParameter(null, param_name = aCPE_nvp.getName().trim());
        if (cparam != null) {
            ConfigurationParameterSettings cps = ((ResourceCreationSpecifier)aResourceSpecifier).getMetaData().getConfigurationParameterSettings();
            boolean isMultiValue = cparam.isMultiValued();
            if (cparam.getName().equals(param_name)) {
                boolean mandatory = cparam.isMandatory();
                if (isMultiValue) {
                    this.replaceArray(cparam.getType(), mandatory, cps, aCPE_nvp, aComponentName);
                } else {
                    this.replacePrimitive(cparam.getType(), mandatory, cps, aCPE_nvp, aComponentName);
                }
                return true;
            }
        }
        return false;
    }

    private void overrideParameterSettings(ResourceSpecifier aResourceSpecifier, CasProcessorConfigurationParameterSettings aCpe_cps, String aComponentName) throws Exception {
        if (aCpe_cps != null && aCpe_cps.getParameterSettings() != null) {
            NameValuePair[] nvp = aCpe_cps.getParameterSettings();
            for (int i = 0; i < nvp.length; ++i) {
                if (nvp[i] == null) continue;
                this.overrideParameterIfExists(aResourceSpecifier, nvp[i], aComponentName);
            }
        }
    }

    private CasProcessor produceIntegratedCasProcessor(CpeCasProcessor aCasProcessorType) throws ResourceConfigurationException {
        AnalysisEngine casProcessor = null;
        ResourceSpecifier resourceSpecifier = null;
        try {
            if (aCasProcessorType != null) {
                URL descriptorUrl = this.getDescriptorURL(aCasProcessorType);
                resourceSpecifier = this.getSpecifier(descriptorUrl);
                CpeSofaMappings sofanamemappings = aCasProcessorType.getSofaNameMappings();
                HashMap<String, String> sofamap = new HashMap<String, String>();
                if (sofanamemappings != null) {
                    CpeSofaMapping[] sofaNameMappingArray = sofanamemappings.getSofaNameMappings();
                    for (int i = 0; sofaNameMappingArray != null && i < sofaNameMappingArray.length; ++i) {
                        CpeSofaMapping aSofaMap = sofaNameMappingArray[i];
                        if (aSofaMap.getComponentSofaName() == null) {
                            aSofaMap.setComponentSofaName("_InitialView");
                        }
                        sofamap.put(aSofaMap.getComponentSofaName(), aSofaMap.getCpeSofaName());
                    }
                }
                this.overrideParameterSettings(resourceSpecifier, aCasProcessorType.getConfigurationParameterSettings(), "CasProcessor:" + aCasProcessorType.getName());
                UimaContextAdmin childContext = this.uimaContext.createChild(aCasProcessorType.getName(), sofamap);
                HashMap<String, UimaContextAdmin> additionalParams = new HashMap<String, UimaContextAdmin>();
                additionalParams.put("UIMA_CONTEXT", childContext);
                if (resourceSpecifier instanceof CasConsumerDescription && !this.isDefinitionInstanceOf(CasConsumer.class, resourceSpecifier, descriptorUrl.toString())) {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_producing_cas_data_consumer__FINEST", new Object[]{Thread.currentThread().getName()});
                    }
                    casProcessor = this.produceCasDataConsumer(CasProcessor.class, resourceSpecifier, additionalParams);
                } else {
                    casProcessor = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)resourceSpecifier, (ResourceManager)this.getResourceManager(), additionalParams);
                }
                if (casProcessor == null) {
                    throw new ResourceConfigurationException((Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_instantiation_exception__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorType.getName()})));
                }
            }
        }
        catch (ResourceConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceConfigurationException("cas_processor_initialize_failed", new Object[]{aCasProcessorType.getName()}, (Throwable)e);
        }
        if (casProcessor != null && aCasProcessorType != null) {
            casProcessor.getProcessingResourceMetaData().setName(aCasProcessorType.getName());
        }
        return casProcessor;
    }

    private CasProcessor produceRemoteCasProcessor(CpeCasProcessor aCasProcessorType) throws ResourceConfigurationException {
        String protocol = DeployFactory.getProtocol(aCasProcessorType, this.getResourceManager());
        Object casProcessor = null;
        casProcessor = "socket".equalsIgnoreCase(protocol) ? new CasObjectNetworkCasProcessorImpl(aCasProcessorType) : new NetworkCasProcessorImpl(aCasProcessorType);
        return casProcessor;
    }

    public CpeConfiguration getCPEConfig() throws InstantiationException {
        try {
            return this.getCpeDescriptor().getCpeConfiguration();
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    public int getProcessingUnitThreadCount() throws ResourceConfigurationException {
        int threadCount;
        try {
            threadCount = this.getCpeDescriptor().getCpeCasProcessors().getConcurrentPUCount();
        }
        catch (Exception e) {
            throw new ResourceConfigurationException("required_attribute_missing", new Object[]{"processingUnitThreadCount"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), "casProcessors", "processingUnitThreadCount", "<casProcessors>"})));
        }
        return threadCount;
    }

    public boolean isDefault() {
        return this.defaultConfig;
    }

    public CpeDescription getCpeDescriptor() {
        return this.cpeDescriptor;
    }

    private void setCpeDescriptor(CpeDescription description) {
        this.cpeDescriptor = description;
    }

    private boolean isUniqueName(String aName) throws CpeDescriptorException {
        int index = 0;
        if (this.getCpeDescriptor().getCpeCasProcessors() != null && this.getCpeDescriptor().getCpeCasProcessors().getAllCpeCasProcessors() != null) {
            index = this.getCpeDescriptor().getCpeCasProcessors().getAllCpeCasProcessors().length;
        }
        for (int i = 0; i < index; ++i) {
            CpeCasProcessor processor = this.getCpeDescriptor().getCpeCasProcessors().getCpeCasProcessor(i);
            String name = processor.getName();
            if (name == null || !name.equalsIgnoreCase(aName)) continue;
            return false;
        }
        return true;
    }

    private void verifyDeploymentParams(String aCasProcessorName, CasProcessorDeploymentParams aDepParams) throws ResourceConfigurationException {
        if (aDepParams == null) {
            throw new ResourceConfigurationException((Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorName, "<deploymentParameters>"})));
        }
        if (aDepParams == null || aDepParams.getAll() == null) {
            return;
        }
        try {
            CasProcessorDeploymentParam param = aDepParams.get("vnsHost");
            if (param == null || param.getParameterValue() == null || param.getParameterValue().trim().length() == 0) {
                throw new ResourceConfigurationException("config_setting_absent", new Object[]{"parameter"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_deploy_params_not_defined__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorName, "vnsHost"})));
            }
            param = aDepParams.get("vnsPort");
            if (param == null || param.getParameterValue() == null || param.getParameterValue().trim().length() == 0) {
                throw new ResourceConfigurationException("config_setting_absent", new Object[]{"parameter"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_deploy_params_not_defined__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorName, "vnsPort"})));
            }
        }
        catch (ResourceConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceConfigurationException((Throwable)e);
        }
    }

    public void addCasProcessor(CasProcessor aCasProcessor) throws ResourceConfigurationException {
        if (!this.initialized) {
            this.addCasProcessor(aCasProcessor.getProcessingResourceMetaData().getName());
        }
    }

    private CpeCasProcessor addCasProcessor(String aCasProcessorName) throws ResourceConfigurationException {
        CpeCasProcessor newProcessor = null;
        try {
            String protocol;
            CpeCasProcessor processor;
            if (!this.isUniqueName(aCasProcessorName)) {
                throw new ResourceConfigurationException((Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_duplicate_name__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorName})));
            }
            int index = this.getCpeDescriptor().getCpeCasProcessors().getAllCpeCasProcessors().length;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_add_cp_with_index__FINEST", new Object[]{Thread.currentThread().getName(), aCasProcessorName, String.valueOf(index)});
            }
            if ((processor = this.getCpeDescriptor().getCpeCasProcessors().getCpeCasProcessor(index - 1)).getCheckpoint() == null) {
                throw new ResourceConfigurationException("element_not_found", new Object[]{"checkpoint", "casProcessor"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorName, "<checkpoint>"})));
            }
            if ("remote".equals(processor.getDeployment()) && "vinci".equals(protocol = DeployFactory.getProtocol(processor, this.getResourceManager()))) {
                this.verifyDeploymentParams(aCasProcessorName, processor.getDeploymentParams());
            }
            if (this.processorCount == 0) {
                newProcessor = processor;
                this.copyCasProcessor(newProcessor, aCasProcessorName);
            } else {
                newProcessor = new CpeIntegratedCasProcessorImpl();
                newProcessor.setDescriptor("href");
                this.copyCasProcessor(newProcessor, aCasProcessorName);
                this.getCpeDescriptor().getCpeCasProcessors().addCpeCasProcessor(newProcessor, this.processorCount);
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "getCpeDescriptor().getCasProcessors().getCasProcessor.getAttributeValue(name)  " + this.getCpeDescriptor().getCpeCasProcessors().getCpeCasProcessor(this.processorCount).getAttributeValue("name"));
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "getCpeDescriptor().getCasProcessors().getCasProcessor(processorCount).getErrorHandling().getMaxConsecutiveRestarts().getAction()  " + this.getCpeDescriptor().getCpeCasProcessors().getCpeCasProcessor(this.processorCount).getErrorHandling().getMaxConsecutiveRestarts().getAction());
            }
            if (!this.casProcessorConfigMap.containsKey(aCasProcessorName)) {
                this.casProcessorConfigMap.put(aCasProcessorName, this.getCpeDescriptor().getCpeCasProcessors().getCpeCasProcessor(this.processorCount));
            }
        }
        catch (Exception e) {
            throw new ResourceConfigurationException((Throwable)e);
        }
        ++this.processorCount;
        return newProcessor;
    }

    public String getDescriptor(List aList) throws ResourceConfigurationException {
        if (aList.size() == 0) {
            return "";
        }
        try {
            String[] colReader = (String[])aList.get(0);
            String[] casInitializer = (String[])aList.get(1);
            this.getCpeDescriptor().getAllCollectionCollectionReaders()[0].getCollectionIterator().getDescriptor().getInclude().set(colReader[0]);
            if (casInitializer[0].length() > 0) {
                this.getCpeDescriptor().getAllCollectionCollectionReaders()[0].getCasInitializer().getDescriptor().getInclude().set(casInitializer[0]);
            } else {
                this.getCpeDescriptor().getAllCollectionCollectionReaders()[0].removeCasInitializer();
            }
            int procIndex = 2;
            boolean create = false;
            int numProcessors = 0;
            CpeCasProcessors processorList = this.getCpeDescriptor().getCpeCasProcessors();
            if (this.processorCount == 0) {
                create = true;
                numProcessors = aList.size() - procIndex;
            } else {
                numProcessors = processorList.getAllCpeCasProcessors().length;
            }
            CpeCasProcessor newProcessor = null;
            for (int i = 0; i < numProcessors; ++i) {
                String[] casProcInfo = (String[])aList.get(procIndex + i);
                if (create) {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_create_new_cp_from_list__FINEST", new Object[]{Thread.currentThread().getName(), casProcInfo[0]});
                    }
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_add_cp_from_list__FINEST", new Object[]{Thread.currentThread().getName(), casProcInfo[0]});
                    }
                    newProcessor = this.addCasProcessor(casProcInfo[0]);
                } else {
                    newProcessor = processorList.getCpeCasProcessor(i);
                }
                if (newProcessor == null) continue;
                newProcessor.setDescriptor(casProcInfo[1]);
            }
            if (create) {
                this.initialized = true;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.getCpeDescriptor().toXML((OutputStream)bos);
            return bos.toString();
        }
        catch (Exception e) {
            throw new ResourceConfigurationException((Throwable)e);
        }
    }

    private void copyCasProcessor(CpeCasProcessor aProcDesc, String aName) {
        try {
            aProcDesc.setName(aName);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cp_deployment__FINEST", new Object[]{Thread.currentThread().getName(), aName, aProcDesc.getDeployment()});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCollectionReader(BaseCollectionReader collectionReader) {
    }

    public ResourceManager getResourceManager() {
        return this.uimaContext.getResourceManager();
    }
}

