/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util.lang;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.myfaces.util.lang.SerializableConsumer;

public class LRULinkedHashMap<K, V>
extends LinkedHashMap<K, V>
implements Serializable {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final int capacity;
    private SerializableConsumer<Map.Entry<K, V>> expiredCallback;

    public LRULinkedHashMap(int capacity) {
        super(capacity + 1, 0.75f, true);
        this.capacity = capacity;
    }

    public LRULinkedHashMap(int capacity, SerializableConsumer<Map.Entry<K, V>> expiredCallback) {
        this(capacity);
        this.expiredCallback = expiredCallback;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean remove;
        boolean bl = remove = this.size() > this.capacity;
        if (remove && this.expiredCallback != null) {
            this.expiredCallback.accept(eldest);
        }
        return remove;
    }
}

