/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.bval.util.ObjectUtils;

public final class StringUtils {
    private StringUtils() {
    }

    public static String capitalize(String str) {
        char newChar;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (firstChar == (newChar = Character.toTitleCase(firstChar))) {
            return str;
        }
        char[] newChars = new char[strLen];
        newChars[0] = newChar;
        str.getChars(1, strLen, newChars, 1);
        return String.valueOf(newChars);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static String[] split(String str) {
        return StringUtils.split(str, null);
    }

    public static String[] split(String str, Character token) {
        if (str == null || str.isEmpty()) {
            return ObjectUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(str.length());
        for (int pos = 0; pos < str.length(); ++pos) {
            char c = str.charAt(pos);
            if (token == null && Character.isWhitespace(c) || token != null && token.equals(Character.valueOf(c))) {
                if (sb.length() <= 0) continue;
                ret.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            ret.add(sb.toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static String valueOf(Object o) {
        if (o instanceof Object[]) {
            return Arrays.toString((Object[])o);
        }
        if (o instanceof byte[]) {
            return Arrays.toString((byte[])o);
        }
        if (o instanceof short[]) {
            return Arrays.toString((short[])o);
        }
        if (o instanceof int[]) {
            return Arrays.toString((int[])o);
        }
        if (o instanceof char[]) {
            return Arrays.toString((char[])o);
        }
        if (o instanceof long[]) {
            return Arrays.toString((long[])o);
        }
        if (o instanceof float[]) {
            return Arrays.toString((float[])o);
        }
        if (o instanceof double[]) {
            return Arrays.toString((double[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.toString((boolean[])o);
        }
        return String.valueOf(o);
    }
}

