/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.commons.internal;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry5.commons.MappedConfiguration;
import org.apache.tapestry5.commons.OrderedConfiguration;
import org.apache.tapestry5.commons.internal.services.AnnotationDataTypeAnalyzer;
import org.apache.tapestry5.commons.internal.services.DefaultDataTypeAnalyzer;
import org.apache.tapestry5.commons.services.DataTypeAnalyzer;
import org.apache.tapestry5.commons.services.PropertyAdapter;

public class BasicDataTypeAnalyzers {
    public static void contributeDataTypeAnalyzer(OrderedConfiguration<DataTypeAnalyzer> configuration, DataTypeAnalyzer defaultDataTypeAnalyzer) {
        configuration.add("Annotation", new AnnotationDataTypeAnalyzer(), new String[0]);
        if (defaultDataTypeAnalyzer == null) {
            defaultDataTypeAnalyzer = BasicDataTypeAnalyzers.createDefaultDataTypeAnalyzer();
        }
        configuration.add("Default", defaultDataTypeAnalyzer, "after:*");
    }

    public static DataTypeAnalyzer createDefaultDataTypeAnalyzer() {
        DefaultDataTypeAnalyzerMappedConfiguration mappedConfiguration = new DefaultDataTypeAnalyzerMappedConfiguration();
        BasicDataTypeAnalyzers.provideDefaultDataTypeAnalyzers(mappedConfiguration);
        return new CombinedDataTypeAnalyzer(new AnnotationDataTypeAnalyzer(), new DefaultDataTypeAnalyzer(mappedConfiguration.getMap()));
    }

    public static void provideDefaultDataTypeAnalyzers(MappedConfiguration<Class, String> configuration) {
        configuration.add(Object.class, "");
        configuration.add(String.class, "text");
        configuration.add(Number.class, "number");
        configuration.add(Enum.class, "enum");
        configuration.add(Boolean.class, "boolean");
        configuration.add(Date.class, "date");
        configuration.add(Calendar.class, "calendar");
    }

    private static final class DefaultDataTypeAnalyzerMappedConfiguration
    implements MappedConfiguration<Class, String> {
        final Map<Class, String> map = new HashMap<Class, String>();

        private DefaultDataTypeAnalyzerMappedConfiguration() {
        }

        @Override
        public void add(Class key, String value) {
            this.map.put(key, value);
        }

        @Override
        public void override(Class key, String value) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void addInstance(Class key, Class<? extends String> clazz) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void overrideInstance(Class key, Class<? extends String> clazz) {
            throw new RuntimeException("Not implemented");
        }

        public Map<Class, String> getMap() {
            return this.map;
        }
    }

    private static final class CombinedDataTypeAnalyzer
    implements DataTypeAnalyzer {
        private final DataTypeAnalyzer[] analyzers;

        public CombinedDataTypeAnalyzer(DataTypeAnalyzer ... analyzers) {
            this.analyzers = analyzers;
        }

        @Override
        public String identifyDataType(PropertyAdapter adapter) {
            DataTypeAnalyzer analyzer;
            String type = null;
            DataTypeAnalyzer[] dataTypeAnalyzerArray = this.analyzers;
            int n = dataTypeAnalyzerArray.length;
            for (int i = 0; i < n && (type = (analyzer = dataTypeAnalyzerArray[i]).identifyDataType(adapter)) == null; ++i) {
            }
            return type;
        }
    }
}

