/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.Collections;
import java.util.Iterator;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.Renderable;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.commons.services.TypeCoercer;
import org.apache.tapestry5.corelib.components.FormFragment;
import org.apache.tapestry5.corelib.internal.AjaxFormLoopContext;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.http.Link;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Heartbeat;
import org.apache.tapestry5.services.PartialMarkupRenderer;
import org.apache.tapestry5.services.PartialMarkupRendererFilter;
import org.apache.tapestry5.services.ajax.AjaxResponseRenderer;
import org.apache.tapestry5.services.compatibility.DeprecationWarning;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@Import(module={"t5/core/ajaxformloop"})
@SupportsInformalParameters
public class AjaxFormLoop {
    @Parameter(defaultPrefix="literal")
    @Property(write=false)
    private String element;
    @Parameter(required=true, autoconnect=true)
    private Iterable source;
    @Parameter(required=true)
    private Object value;
    @Parameter(defaultPrefix="literal")
    private String show;
    @Parameter
    private Object[] context;
    @Parameter(value="block:defaultAddRow", defaultPrefix="literal")
    @Property(write=false)
    private Block addRow;
    @Inject
    private Block tail;
    @Parameter(required=true, allowNull=false)
    private ValueEncoder<Object> encoder;
    @InjectComponent
    private FormFragment fragment;
    @Inject
    private Block ajaxResponse;
    @Inject
    private ComponentResources resources;
    @Environmental
    private FormSupport formSupport;
    @Environmental
    private Heartbeat heartbeat;
    @Inject
    private Environment environment;
    @Inject
    private JavaScriptSupport jsSupport;
    private Iterator iterator;
    private Element wrapper;
    @Inject
    private TypeCoercer typeCoercer;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Inject
    private AjaxResponseRenderer ajaxResponseRenderer;
    @Inject
    private DeprecationWarning deprecationWarning;
    private final AjaxFormLoopContext formLoopContext = new AjaxFormLoopContext(){

        @Override
        public String encodedRowValue() {
            return AjaxFormLoop.this.encoder.toClient(AjaxFormLoop.this.value);
        }
    };
    private static final ComponentAction<AjaxFormLoop> BEGIN_HEARTBEAT = new ComponentAction<AjaxFormLoop>(){

        @Override
        public void execute(AjaxFormLoop component) {
            component.beginHeartbeat();
        }

        public String toString() {
            return "AjaxFormLoop.BeginHeartbeat";
        }
    };
    @Property(write=false)
    private final Renderable beginHeartbeat = new Renderable(){

        @Override
        public void render(MarkupWriter writer) {
            AjaxFormLoop.this.formSupport.storeAndExecute(AjaxFormLoop.this, BEGIN_HEARTBEAT);
        }
    };
    private static final ComponentAction<AjaxFormLoop> END_HEARTBEAT = new ComponentAction<AjaxFormLoop>(){

        @Override
        public void execute(AjaxFormLoop component) {
            component.endHeartbeat();
        }

        public String toString() {
            return "AjaxFormLoop.EndHeartbeat";
        }
    };
    @Property(write=false)
    private final Renderable endHeartbeat = new Renderable(){

        @Override
        public void render(MarkupWriter writer) {
            AjaxFormLoop.this.formSupport.storeAndExecute(AjaxFormLoop.this, END_HEARTBEAT);
        }
    };
    @Property(write=false)
    private final Renderable beforeBody = new Renderable(){

        @Override
        public void render(MarkupWriter writer) {
            AjaxFormLoop.this.beginHeartbeat();
            AjaxFormLoop.this.syncCurrentValue();
        }
    };
    @Property(write=false)
    private final Renderable afterBody = new Renderable(){

        @Override
        public void render(MarkupWriter writer) {
            AjaxFormLoop.this.endHeartbeat();
        }
    };
    @Property(write=false)
    private final Renderable syncValue = new Renderable(){

        @Override
        public void render(MarkupWriter writer) {
            AjaxFormLoop.this.syncCurrentValue();
        }
    };

    void pageLoaded() {
        this.deprecationWarning.ignoredComponentParameters(this.resources, "show");
    }

    ValueEncoder defaultEncoder() {
        return this.defaultProvider.defaultValueEncoder("value", this.resources);
    }

    String defaultElement() {
        return this.resources.getElementName("div");
    }

    private void syncValue(String clientValue) {
        Object value = this.encoder.toValue(clientValue);
        if (value == null) {
            throw new RuntimeException(String.format("Unable to convert client value '%s' back into a server-side object.", clientValue));
        }
        this.value = value;
    }

    private void syncCurrentValue() {
        String id = this.toClientValue();
        this.formSupport.store(this, new SyncValue(id));
    }

    private String toClientValue() {
        return this.encoder.toClient(this.value);
    }

    void setupRender(MarkupWriter writer) {
        this.pushContext();
        this.iterator = this.source == null ? Collections.EMPTY_LIST.iterator() : this.source.iterator();
        Link removeRowLink = this.resources.createEventLink("triggerRemoveRow", this.context);
        Link injectRowLink = this.resources.createEventLink("injectRow", this.context);
        injectRowLink.addParameter("t:formid", this.formSupport.getClientId());
        injectRowLink.addParameter("t:formcomponentid", this.formSupport.getFormComponentId());
        Element element = writer.getElement();
        this.wrapper = element.getAttribute("data-container-type") != null || element.getAttribute("data-remove-row-url") != null || element.getAttribute("data-inject-row-url") != null ? writer.element("div", new Object[0]) : null;
        writer.attributes("data-container-type", "core/AjaxFormLoop", "data-remove-row-url", removeRowLink, "data-inject-row-url", injectRowLink);
    }

    private void pushContext() {
        this.environment.push(AjaxFormLoopContext.class, this.formLoopContext);
    }

    boolean beginRender(MarkupWriter writer) {
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.value = this.iterator.next();
        return true;
    }

    Object afterRender(MarkupWriter writer) {
        if (!this.iterator.hasNext()) {
            return this.tail;
        }
        return false;
    }

    boolean onBeginRender(MarkupWriter writer) {
        this.resources.renderInformalParameters(writer);
        return true;
    }

    void cleanupRender(MarkupWriter writer) {
        if (this.wrapper != null) {
            writer.end();
        }
        this.popContext();
    }

    private void popContext() {
        this.environment.pop(AjaxFormLoopContext.class);
    }

    Object onInjectRow(EventContext context) {
        ComponentEventCallback callback = new ComponentEventCallback(){

            public boolean handleResult(Object result) {
                AjaxFormLoop.this.value = result;
                return true;
            }
        };
        this.resources.triggerContextEvent("addRow", context, callback);
        if (this.value == null) {
            throw new IllegalArgumentException(String.format("Event handler for event 'addRow' from %s should have returned a non-null value.", this.resources.getCompleteId()));
        }
        this.ajaxResponseRenderer.addFilter(new PartialMarkupRendererFilter(){

            @Override
            public void renderMarkup(MarkupWriter writer, JSONObject reply, PartialMarkupRenderer renderer) {
                AjaxFormLoop.this.pushContext();
                renderer.renderMarkup(writer, reply);
                AjaxFormLoop.this.popContext();
            }
        });
        return this.ajaxResponse;
    }

    Object onTriggerRemoveRow(@RequestParameter(value="t:rowvalue") String encodedValue) {
        this.syncValue(encodedValue);
        this.resources.triggerEvent("removeRow", new Object[]{this.value}, null);
        return new JSONObject();
    }

    private void beginHeartbeat() {
        this.heartbeat.begin();
    }

    private void endHeartbeat() {
        this.heartbeat.end();
    }

    static class SyncValue
    implements ComponentAction<AjaxFormLoop> {
        private final String clientValue;

        public SyncValue(String clientValue) {
            this.clientValue = clientValue;
        }

        @Override
        public void execute(AjaxFormLoop component) {
            component.syncValue(this.clientValue);
        }

        public String toString() {
            return String.format("AjaxFormLoop.SyncValue[%s]", this.clientValue);
        }
    }
}

