/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.javadoc;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.TextTree;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.VariableElement;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.javadoc.DocCommentTreeProvider;

public class ParameterDescription {
    public final VariableElement field;
    public final String name;
    public final String type;
    public final String defaultValue;
    public final String defaultPrefix;
    public final boolean required;
    public final boolean allowNull;
    public final boolean cache;
    public final String since;
    public final boolean deprecated;
    private final DocCommentTreeProvider docCommentTreeProvider;
    private static final Pattern SPECIAL_CONTENT = Pattern.compile("(?:</?(\\p{Alpha}+)>)|(?:&\\p{Alpha}+;)");
    private static final Set<String> PASS_THROUGH_TAGS = CollectionFactory.newSet((Object[])new String[]{"b", "em", "i", "code", "strong"});

    public ParameterDescription(VariableElement fieldDoc, String name, String type, String defaultValue, String defaultPrefix, boolean required, boolean allowNull, boolean cache, String since, boolean deprecated, DocCommentTreeProvider docCommentTreeProvider) {
        this.field = fieldDoc;
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.defaultPrefix = defaultPrefix;
        this.required = required;
        this.allowNull = allowNull;
        this.cache = cache;
        this.since = since;
        this.deprecated = deprecated;
        this.docCommentTreeProvider = docCommentTreeProvider;
    }

    public String extractDescription() throws IOException {
        DocCommentTree tree = this.docCommentTreeProvider.getDocCommentTree(this.field);
        if (tree == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (DocTree docTree : tree.getFullBody()) {
            if (docTree.getKind() == DocTree.Kind.TEXT) {
                TextTree textTree = (TextTree)docTree;
                ParameterDescription.appendContentSafe(builder, textTree.getBody());
                continue;
            }
            if (docTree.getKind() == DocTree.Kind.LINK) {
                LinkTree seeTag = (LinkTree)docTree;
                String label = seeTag.getLabel().toString();
                if (StringUtils.isNotEmpty((String)label)) {
                    builder.append(StringEscapeUtils.escapeHtml((String)label));
                    continue;
                }
                if (seeTag.getReference() == null) continue;
                builder.append(StringEscapeUtils.escapeHtml((String)seeTag.getReference().getSignature()));
                continue;
            }
            if (docTree.getKind() != DocTree.Kind.CODE) continue;
            LiteralTree codeTag = (LiteralTree)docTree;
            builder.append("<code>");
            builder.append(StringEscapeUtils.escapeHtml((String)codeTag.getBody().getBody()));
            builder.append("</code>");
        }
        String text = builder.toString();
        return text.trim();
    }

    private static void appendContentSafe(StringBuilder sb, String string) {
        Matcher m = SPECIAL_CONTENT.matcher(string);
        int index = 0;
        while (index < string.length()) {
            boolean match = m.find(index);
            if (match) {
                String tagName;
                if (index != m.start()) {
                    sb.append(StringEscapeUtils.escapeHtml((String)string.substring(index, m.start())));
                }
                if ((tagName = m.group(1)) != null) {
                    if (PASS_THROUGH_TAGS.contains(tagName.toLowerCase(Locale.US))) {
                        sb.append(m.group());
                    }
                } else {
                    sb.append(m.group());
                }
                index = m.end();
                continue;
            }
            sb.append(StringEscapeUtils.escapeHtml((String)string.substring(index)));
            break;
        }
    }
}

