(function() {
  define(["t5/core/dom", "t5/core/ajax", "underscore", "jquery", "t5/core/utils", "t5/core/typeahead"], function(dom, ajax, _, $, arg) {
    var exports, extendURL, init;
    extendURL = arg.extendURL;
    init = function(spec) {
      var $field, dataset, engine;
      $field = $(document.getElementById(spec.id));
      engine = new Bloodhound({
        datumTokenizer: Bloodhound.tokenizers.whitespace,
        queryTokenizer: Bloodhound.tokenizers.whitespace,
        limit: spec.limit,
        remote: {
          url: spec.url,
          replace: function(uri, query) {
            return extendURL(uri, {
              "t:input": query
            });
          },
          filter: function(response) {
            return response.matches;
          }
        }
      });
      engine.initialize();
      dataset = {
        name: spec.id,
        displayKey: _.identity,
        source: engine.ttAdapter()
      };
      $field.typeahead({
        minLength: spec.minChars
      }, dataset);
      $field.prev(".tt-hint").removeAttr("data-validation data-optionality data-required-message");
    };
    return exports = init;
  });

}).call(this);
