# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
"""This module contains data related to countries and is used for geo mapping"""
# pylint: disable=too-many-lines
from typing import Any, Dict, List, Optional

countries: List[Dict[str, Any]] = [
    {
        "name": "Angola",
        "area": 1246700,
        "cioc": "ANG",
        "cca2": "AO",
        "capital": "Luanda",
        "lat": -12.5,
        "lng": 18.5,
        "cca3": "AGO",
    },
    {
        "name": "Algeria",
        "area": 2381741,
        "cioc": "ALG",
        "cca2": "DZ",
        "capital": "Algiers",
        "lat": 28,
        "lng": 3,
        "cca3": "DZA",
    },
    {
        "name": "Egypt",
        "area": 1002450,
        "cioc": "EGY",
        "cca2": "EG",
        "capital": "Cairo",
        "lat": 27,
        "lng": 30,
        "cca3": "EGY",
    },
    {
        "name": "Bangladesh",
        "area": 147570,
        "cioc": "BAN",
        "cca2": "BD",
        "capital": "Dhaka",
        "lat": 24,
        "lng": 90,
        "cca3": "BGD",
    },
    {
        "name": "Niger",
        "area": 1267000,
        "cioc": "NIG",
        "cca2": "NE",
        "capital": "Niamey",
        "lat": 16,
        "lng": 8,
        "cca3": "NER",
    },
    {
        "name": "Liechtenstein",
        "area": 160,
        "cioc": "LIE",
        "cca2": "LI",
        "capital": "Vaduz",
        "lat": 47.26666666,
        "lng": 9.53333333,
        "cca3": "LIE",
    },
    {
        "name": "Namibia",
        "area": 825615,
        "cioc": "NAM",
        "cca2": "NA",
        "capital": "Windhoek",
        "lat": -22,
        "lng": 17,
        "cca3": "NAM",
    },
    {
        "name": "Bulgaria",
        "area": 110879,
        "cioc": "BUL",
        "cca2": "BG",
        "capital": "Sofia",
        "lat": 43,
        "lng": 25,
        "cca3": "BGR",
    },
    {
        "name": "Bolivia",
        "area": 1098581,
        "cioc": "BOL",
        "cca2": "BO",
        "capital": "Sucre",
        "lat": -17,
        "lng": -65,
        "cca3": "BOL",
    },
    {
        "name": "Ghana",
        "area": 238533,
        "cioc": "GHA",
        "cca2": "GH",
        "capital": "Accra",
        "lat": 8,
        "lng": -2,
        "cca3": "GHA",
    },
    {
        "name": "Cocos (Keeling) Islands",
        "area": 14,
        "cioc": "",
        "cca2": "CC",
        "capital": "West Island",
        "lat": -12.5,
        "lng": 96.83333333,
        "cca3": "CCK",
    },
    {
        "name": "Pakistan",
        "area": 881912,
        "cioc": "PAK",
        "cca2": "PK",
        "capital": "Islamabad",
        "lat": 30,
        "lng": 70,
        "cca3": "PAK",
    },
    {
        "name": "Cape Verde",
        "area": 4033,
        "cioc": "CPV",
        "cca2": "CV",
        "capital": "Praia",
        "lat": 16,
        "lng": -24,
        "cca3": "CPV",
    },
    {
        "name": "Jordan",
        "area": 89342,
        "cioc": "JOR",
        "cca2": "JO",
        "capital": "Amman",
        "lat": 31,
        "lng": 36,
        "cca3": "JOR",
    },
    {
        "name": "Liberia",
        "area": 111369,
        "cioc": "LBR",
        "cca2": "LR",
        "capital": "Monrovia",
        "lat": 6.5,
        "lng": -9.5,
        "cca3": "LBR",
    },
    {
        "name": "Libya",
        "area": 1759540,
        "cioc": "LBA",
        "cca2": "LY",
        "capital": "Tripoli",
        "lat": 25,
        "lng": 17,
        "cca3": "LBY",
    },
    {
        "name": "Malaysia",
        "area": 330803,
        "cioc": "MAS",
        "cca2": "MY",
        "capital": "Kuala Lumpur",
        "lat": 2.5,
        "lng": 112.5,
        "cca3": "MYS",
    },
    {
        "name": "Dominican Republic",
        "area": 48671,
        "cioc": "DOM",
        "cca2": "DO",
        "capital": "Santo Domingo",
        "lat": 19,
        "lng": -70.66666666,
        "cca3": "DOM",
    },
    {
        "name": "Puerto Rico",
        "area": 8870,
        "cioc": "PUR",
        "cca2": "PR",
        "capital": "San Juan",
        "lat": 18.25,
        "lng": -66.5,
        "cca3": "PRI",
    },
    {
        "name": "Mayotte",
        "area": 374,
        "cioc": "",
        "cca2": "YT",
        "capital": "Mamoudzou",
        "lat": -12.83333333,
        "lng": 45.16666666,
        "cca3": "MYT",
    },
    {
        "name": "North Korea",
        "area": 120538,
        "cioc": "PRK",
        "cca2": "KP",
        "capital": "Pyongyang",
        "lat": 40,
        "lng": 127,
        "cca3": "PRK",
    },
    {
        "name": "Palestine",
        "area": 6220,
        "cioc": "PLE",
        "cca2": "PS",
        "capital": "Ramallah",
        "lat": 31.9,
        "lng": 35.2,
        "cca3": "PSE",
    },
    {
        "name": "Tanzania",
        "area": 945087,
        "cioc": "TAN",
        "cca2": "TZ",
        "capital": "Dodoma",
        "lat": -6,
        "lng": 35,
        "cca3": "TZA",
    },
    {
        "name": "Botswana",
        "area": 582000,
        "cioc": "BOT",
        "cca2": "BW",
        "capital": "Gaborone",
        "lat": -22,
        "lng": 24,
        "cca3": "BWA",
    },
    {
        "name": "Cambodia",
        "area": 181035,
        "cioc": "CAM",
        "cca2": "KH",
        "capital": "Phnom Penh",
        "lat": 13,
        "lng": 105,
        "cca3": "KHM",
    },
    {
        "name": "Nicaragua",
        "area": 130373,
        "cioc": "NCA",
        "cca2": "NI",
        "capital": "Managua",
        "lat": 13,
        "lng": -85,
        "cca3": "NIC",
    },
    {
        "name": "Trinidad and Tobago",
        "area": 5130,
        "cioc": "TTO",
        "cca2": "TT",
        "capital": "Port of Spain",
        "lat": 11,
        "lng": -61,
        "cca3": "TTO",
    },
    {
        "name": "Ethiopia",
        "area": 1104300,
        "cioc": "ETH",
        "cca2": "ET",
        "capital": "Addis Ababa",
        "lat": 8,
        "lng": 38,
        "cca3": "ETH",
    },
    {
        "name": "Paraguay",
        "area": 406752,
        "cioc": "PAR",
        "cca2": "PY",
        "capital": "Asuncion",
        "lat": -23,
        "lng": -58,
        "cca3": "PRY",
    },
    {
        "name": "Hong Kong",
        "area": 1104,
        "cioc": "HKG",
        "cca2": "HK",
        "capital": "City of Victoria",
        "lat": 22.267,
        "lng": 114.188,
        "cca3": "HKG",
    },
    {
        "name": "Saudi Arabia",
        "area": 2149690,
        "cioc": "KSA",
        "cca2": "SA",
        "capital": "Riyadh",
        "lat": 25,
        "lng": 45,
        "cca3": "SAU",
    },
    {
        "name": "Lebanon",
        "area": 10452,
        "cioc": "LIB",
        "cca2": "LB",
        "capital": "Beirut",
        "lat": 33.83333333,
        "lng": 35.83333333,
        "cca3": "LBN",
    },
    {
        "name": "Slovenia",
        "area": 20273,
        "cioc": "SLO",
        "cca2": "SI",
        "capital": "Ljubljana",
        "lat": 46.11666666,
        "lng": 14.81666666,
        "cca3": "SVN",
    },
    {
        "name": "Burkina Faso",
        "area": 272967,
        "cioc": "BUR",
        "cca2": "BF",
        "capital": "Ouagadougou",
        "lat": 13,
        "lng": -2,
        "cca3": "BFA",
    },
    {
        "name": "Switzerland",
        "area": 41284,
        "cioc": "SUI",
        "cca2": "CH",
        "capital": "Bern",
        "lat": 47,
        "lng": 8,
        "cca3": "CHE",
    },
    {
        "name": "Mauritania",
        "area": 1030700,
        "cioc": "MTN",
        "cca2": "MR",
        "capital": "Nouakchott",
        "lat": 20,
        "lng": -12,
        "cca3": "MRT",
    },
    {
        "name": "Croatia",
        "area": 56594,
        "cioc": "CRO",
        "cca2": "HR",
        "capital": "Zagreb",
        "lat": 45.16666666,
        "lng": 15.5,
        "cca3": "HRV",
    },
    {
        "name": "Chile",
        "area": 756102,
        "cioc": "CHI",
        "cca2": "CL",
        "capital": "Santiago",
        "lat": -30,
        "lng": -71,
        "cca3": "CHL",
    },
    {
        "name": "China",
        "area": 9706961,
        "cioc": "CHN",
        "cca2": "CN",
        "capital": "Beijing",
        "lat": 35,
        "lng": 105,
        "cca3": "CHN",
    },
    {
        "name": "Saint Kitts and Nevis",
        "area": 261,
        "cioc": "SKN",
        "cca2": "KN",
        "capital": "Basseterre",
        "lat": 17.33333333,
        "lng": -62.75,
        "cca3": "KNA",
    },
    {
        "name": "Sierra Leone",
        "area": 71740,
        "cioc": "SLE",
        "cca2": "SL",
        "capital": "Freetown",
        "lat": 8.5,
        "lng": -11.5,
        "cca3": "SLE",
    },
    {
        "name": "Jamaica",
        "area": 10991,
        "cioc": "JAM",
        "cca2": "JM",
        "capital": "Kingston",
        "lat": 18.25,
        "lng": -77.5,
        "cca3": "JAM",
    },
    {
        "name": "San Marino",
        "area": 61,
        "cioc": "SMR",
        "cca2": "SM",
        "capital": "City of San Marino",
        "lat": 43.76666666,
        "lng": 12.41666666,
        "cca3": "SMR",
    },
    {
        "name": "Gibraltar",
        "area": 6,
        "cioc": "",
        "cca2": "GI",
        "capital": "Gibraltar",
        "lat": 36.13333333,
        "lng": -5.35,
        "cca3": "GIB",
    },
    {
        "name": "Djibouti",
        "area": 23200,
        "cioc": "DJI",
        "cca2": "DJ",
        "capital": "Djibouti",
        "lat": 11.5,
        "lng": 43,
        "cca3": "DJI",
    },
    {
        "name": "Guinea",
        "area": 245857,
        "cioc": "GUI",
        "cca2": "GN",
        "capital": "Conakry",
        "lat": 11,
        "lng": -10,
        "cca3": "GIN",
    },
    {
        "name": "Finland",
        "area": 338424,
        "cioc": "FIN",
        "cca2": "FI",
        "capital": "Helsinki",
        "lat": 64,
        "lng": 26,
        "cca3": "FIN",
    },
    {
        "name": "Uruguay",
        "area": 181034,
        "cioc": "URU",
        "cca2": "UY",
        "capital": "Montevideo",
        "lat": -33,
        "lng": -56,
        "cca3": "URY",
    },
    {
        "name": "Thailand",
        "area": 513120,
        "cioc": "THA",
        "cca2": "TH",
        "capital": "Bangkok",
        "lat": 15,
        "lng": 100,
        "cca3": "THA",
    },
    {
        "name": "Sao Tome and Principe",
        "area": 964,
        "cioc": "STP",
        "cca2": "ST",
        "capital": "Sao Tome",
        "lat": 1,
        "lng": 7,
        "cca3": "STP",
    },
    {
        "name": "Seychelles",
        "area": 452,
        "cioc": "SEY",
        "cca2": "SC",
        "capital": "Victoria",
        "lat": -4.58333333,
        "lng": 55.66666666,
        "cca3": "SYC",
    },
    {
        "name": "Nepal",
        "area": 147181,
        "cioc": "NEP",
        "cca2": "NP",
        "capital": "Kathmandu",
        "lat": 28,
        "lng": 84,
        "cca3": "NPL",
    },
    {
        "name": "Christmas Island",
        "area": 135,
        "cioc": "",
        "cca2": "CX",
        "capital": "Flying Fish Cove",
        "lat": -10.5,
        "lng": 105.66666666,
        "cca3": "CXR",
    },
    {
        "name": "Laos",
        "area": 236800,
        "cioc": "LAO",
        "cca2": "LA",
        "capital": "Vientiane",
        "lat": 18,
        "lng": 105,
        "cca3": "LAO",
    },
    {
        "name": "Yemen",
        "area": 527968,
        "cioc": "YEM",
        "cca2": "YE",
        "capital": "Sana'a",
        "lat": 15,
        "lng": 48,
        "cca3": "YEM",
    },
    {
        "name": "Bouvet Island",
        "area": 49,
        "cioc": "",
        "cca2": "BV",
        "capital": "",
        "lat": -54.43333333,
        "lng": 3.4,
        "cca3": "BVT",
    },
    {
        "name": "South Africa",
        "area": 1221037,
        "cioc": "RSA",
        "cca2": "ZA",
        "capital": "Pretoria",
        "lat": -29,
        "lng": 24,
        "cca3": "ZAF",
    },
    {
        "name": "Kiribati",
        "area": 811,
        "cioc": "KIR",
        "cca2": "KI",
        "capital": "South Tarawa",
        "lat": 1.41666666,
        "lng": 173,
        "cca3": "KIR",
    },
    {
        "name": "Philippines",
        "area": 342353,
        "cioc": "PHI",
        "cca2": "PH",
        "capital": "Manila",
        "lat": 13,
        "lng": 122,
        "cca3": "PHL",
    },
    {
        "name": "Sint Maarten",
        "area": 34,
        "cioc": "",
        "cca2": "SX",
        "capital": "Philipsburg",
        "lat": 18.033333,
        "lng": -63.05,
        "cca3": "SXM",
    },
    {
        "name": "Romania",
        "area": 238391,
        "cioc": "ROU",
        "cca2": "RO",
        "capital": "Bucharest",
        "lat": 46,
        "lng": 25,
        "cca3": "ROU",
    },
    {
        "name": "United States Virgin Islands",
        "area": 347,
        "cioc": "ISV",
        "cca2": "VI",
        "capital": "Charlotte Amalie",
        "lat": 18.35,
        "lng": -64.933333,
        "cca3": "VIR",
    },
    {
        "name": "Syria",
        "area": 185180,
        "cioc": "SYR",
        "cca2": "SY",
        "capital": "Damascus",
        "lat": 35,
        "lng": 38,
        "cca3": "SYR",
    },
    {
        "name": "Macau",
        "area": 30,
        "cioc": "",
        "cca2": "MO",
        "capital": "",
        "lat": 22.16666666,
        "lng": 113.55,
        "cca3": "MAC",
    },
    {
        "name": "Saint Martin",
        "area": 53,
        "cioc": "",
        "cca2": "MF",
        "capital": "Marigot",
        "lat": 18.08333333,
        "lng": -63.95,
        "cca3": "MAF",
    },
    {
        "name": "Malta",
        "area": 316,
        "cioc": "MLT",
        "cca2": "MT",
        "capital": "Valletta",
        "lat": 35.83333333,
        "lng": 14.58333333,
        "cca3": "MLT",
    },
    {
        "name": "Kazakhstan",
        "area": 2724900,
        "cioc": "KAZ",
        "cca2": "KZ",
        "capital": "Astana",
        "lat": 48,
        "lng": 68,
        "cca3": "KAZ",
    },
    {
        "name": "Turks and Caicos Islands",
        "area": 948,
        "cioc": "",
        "cca2": "TC",
        "capital": "Cockburn Town",
        "lat": 21.75,
        "lng": -71.58333333,
        "cca3": "TCA",
    },
    {
        "name": "French Polynesia",
        "area": 4167,
        "cioc": "",
        "cca2": "PF",
        "capital": "Papeete",
        "lat": -15,
        "lng": -140,
        "cca3": "PYF",
    },
    {
        "name": "Niue",
        "area": 260,
        "cioc": "",
        "cca2": "NU",
        "capital": "Alofi",
        "lat": -19.03333333,
        "lng": -169.86666666,
        "cca3": "NIU",
    },
    {
        "name": "Dominica",
        "area": 751,
        "cioc": "DMA",
        "cca2": "DM",
        "capital": "Roseau",
        "lat": 15.41666666,
        "lng": -61.33333333,
        "cca3": "DMA",
    },
    {
        "name": "Benin",
        "area": 112622,
        "cioc": "BEN",
        "cca2": "BJ",
        "capital": "Porto-Novo",
        "lat": 9.5,
        "lng": 2.25,
        "cca3": "BEN",
    },
    {
        "name": "French Guiana",
        "area": 83534,
        "cioc": "",
        "cca2": "GF",
        "capital": "Cayenne",
        "lat": 4,
        "lng": -53,
        "cca3": "GUF",
    },
    {
        "name": "Belgium",
        "area": 30528,
        "cioc": "BEL",
        "cca2": "BE",
        "capital": "Brussels",
        "lat": 50.83333333,
        "lng": 4,
        "cca3": "BEL",
    },
    {
        "name": "Montserrat",
        "area": 102,
        "cioc": "",
        "cca2": "MS",
        "capital": "Plymouth",
        "lat": 16.75,
        "lng": -62.2,
        "cca3": "MSR",
    },
    {
        "name": "Togo",
        "area": 56785,
        "cioc": "TOG",
        "cca2": "TG",
        "capital": "Lome",
        "lat": 8,
        "lng": 1.16666666,
        "cca3": "TGO",
    },
    {
        "name": "Germany",
        "area": 357114,
        "cioc": "GER",
        "cca2": "DE",
        "capital": "Berlin",
        "lat": 51,
        "lng": 9,
        "cca3": "DEU",
    },
    {
        "name": "Guam",
        "area": 549,
        "cioc": "GUM",
        "cca2": "GU",
        "capital": "Hagatna",
        "lat": 13.46666666,
        "lng": 144.78333333,
        "cca3": "GUM",
    },
    {
        "name": "Sri Lanka",
        "area": 65610,
        "cioc": "SRI",
        "cca2": "LK",
        "capital": "Colombo",
        "lat": 7,
        "lng": 81,
        "cca3": "LKA",
    },
    {
        "name": "South Sudan",
        "area": 619745,
        "cioc": "",
        "cca2": "SS",
        "capital": "Juba",
        "lat": 7,
        "lng": 30,
        "cca3": "SSD",
    },
    {
        "name": "Falkland Islands",
        "area": 12173,
        "cioc": "",
        "cca2": "FK",
        "capital": "Stanley",
        "lat": -51.75,
        "lng": -59,
        "cca3": "FLK",
    },
    {
        "name": "United Kingdom",
        "area": 242900,
        "cioc": "GBR",
        "cca2": "GB",
        "capital": "London",
        "lat": 54,
        "lng": -2,
        "cca3": "GBR",
    },
    {
        "name": "Guyana",
        "area": 214969,
        "cioc": "GUY",
        "cca2": "GY",
        "capital": "Georgetown",
        "lat": 5,
        "lng": -59,
        "cca3": "GUY",
    },
    {
        "name": "Costa Rica",
        "area": 51100,
        "cioc": "CRC",
        "cca2": "CR",
        "capital": "San Jose",
        "lat": 10,
        "lng": -84,
        "cca3": "CRI",
    },
    {
        "name": "Cameroon",
        "area": 475442,
        "cioc": "CMR",
        "cca2": "CM",
        "capital": "Yaounde",
        "lat": 6,
        "lng": 12,
        "cca3": "CMR",
    },
    {
        "name": "Morocco",
        "area": 446550,
        "cioc": "MAR",
        "cca2": "MA",
        "capital": "Rabat",
        "lat": 32,
        "lng": -5,
        "cca3": "MAR",
    },
    {
        "name": "Northern Mariana Islands",
        "area": 464,
        "cioc": "",
        "cca2": "MP",
        "capital": "Saipan",
        "lat": 15.2,
        "lng": 145.75,
        "cca3": "MNP",
    },
    {
        "name": "Lesotho",
        "area": 30355,
        "cioc": "LES",
        "cca2": "LS",
        "capital": "Maseru",
        "lat": -29.5,
        "lng": 28.5,
        "cca3": "LSO",
    },
    {
        "name": "Hungary",
        "area": 93028,
        "cioc": "HUN",
        "cca2": "HU",
        "capital": "Budapest",
        "lat": 47,
        "lng": 20,
        "cca3": "HUN",
    },
    {
        "name": "Turkmenistan",
        "area": 488100,
        "cioc": "TKM",
        "cca2": "TM",
        "capital": "Ashgabat",
        "lat": 40,
        "lng": 60,
        "cca3": "TKM",
    },
    {
        "name": "Suriname",
        "area": 163820,
        "cioc": "SUR",
        "cca2": "SR",
        "capital": "Paramaribo",
        "lat": 4,
        "lng": -56,
        "cca3": "SUR",
    },
    {
        "name": "Netherlands",
        "area": 41850,
        "cioc": "NED",
        "cca2": "NL",
        "capital": "Amsterdam",
        "lat": 52.5,
        "lng": 5.75,
        "cca3": "NLD",
    },
    {
        "name": "Bermuda",
        "area": 54,
        "cioc": "BER",
        "cca2": "BM",
        "capital": "Hamilton",
        "lat": 32.33333333,
        "lng": -64.75,
        "cca3": "BMU",
    },
    {
        "name": "Heard Island and McDonald Islands",
        "area": 412,
        "cioc": "",
        "cca2": "HM",
        "capital": "",
        "lat": -53.1,
        "lng": 72.51666666,
        "cca3": "HMD",
    },
    {
        "name": "Chad",
        "area": 1284000,
        "cioc": "CHA",
        "cca2": "TD",
        "capital": "N'Djamena",
        "lat": 15,
        "lng": 19,
        "cca3": "TCD",
    },
    {
        "name": "Georgia",
        "area": 69700,
        "cioc": "GEO",
        "cca2": "GE",
        "capital": "Tbilisi",
        "lat": 42,
        "lng": 43.5,
        "cca3": "GEO",
    },
    {
        "name": "Montenegro",
        "area": 13812,
        "cioc": "MNE",
        "cca2": "ME",
        "capital": "Podgorica",
        "lat": 42.5,
        "lng": 19.3,
        "cca3": "MNE",
    },
    {
        "name": "Mongolia",
        "area": 1564110,
        "cioc": "MGL",
        "cca2": "MN",
        "capital": "Ulan Bator",
        "lat": 46,
        "lng": 105,
        "cca3": "MNG",
    },
    {
        "name": "Marshall Islands",
        "area": 181,
        "cioc": "MHL",
        "cca2": "MH",
        "capital": "Majuro",
        "lat": 9,
        "lng": 168,
        "cca3": "MHL",
    },
    {
        "name": "Martinique",
        "area": 1128,
        "cioc": "",
        "cca2": "MQ",
        "capital": "Fort-de-France",
        "lat": 14.666667,
        "lng": -61,
        "cca3": "MTQ",
    },
    {
        "name": "Belize",
        "area": 22966,
        "cioc": "BIZ",
        "cca2": "BZ",
        "capital": "Belmopan",
        "lat": 17.25,
        "lng": -88.75,
        "cca3": "BLZ",
    },
    {
        "name": "Norfolk Island",
        "area": 36,
        "cioc": "",
        "cca2": "NF",
        "capital": "Kingston",
        "lat": -29.03333333,
        "lng": 167.95,
        "cca3": "NFK",
    },
    {
        "name": "Myanmar",
        "area": 676578,
        "cioc": "MYA",
        "cca2": "MM",
        "capital": "Naypyidaw",
        "lat": 22,
        "lng": 98,
        "cca3": "MMR",
    },
    {
        "name": "Afghanistan",
        "area": 652230,
        "cioc": "AFG",
        "cca2": "AF",
        "capital": "Kabul",
        "lat": 33,
        "lng": 65,
        "cca3": "AFG",
    },
    {
        "name": "Burundi",
        "area": 27834,
        "cioc": "BDI",
        "cca2": "BI",
        "capital": "Bujumbura",
        "lat": -3.5,
        "lng": 30,
        "cca3": "BDI",
    },
    {
        "name": "British Virgin Islands",
        "area": 151,
        "cioc": "IVB",
        "cca2": "VG",
        "capital": "Road Town",
        "lat": 18.431383,
        "lng": -64.62305,
        "cca3": "VGB",
    },
    {
        "name": "Belarus",
        "area": 207600,
        "cioc": "BLR",
        "cca2": "BY",
        "capital": "Minsk",
        "lat": 53,
        "lng": 28,
        "cca3": "BLR",
    },
    {
        "name": "Saint Barthelemy",
        "area": 21,
        "cioc": "",
        "cca2": "BL",
        "capital": "Gustavia",
        "lat": 18.5,
        "lng": -63.41666666,
        "cca3": "BLM",
    },
    {
        "name": "Grenada",
        "area": 344,
        "cioc": "GRN",
        "cca2": "GD",
        "capital": "St. George's",
        "lat": 12.11666666,
        "lng": -61.66666666,
        "cca3": "GRD",
    },
    {
        "name": "Tokelau",
        "area": 12,
        "cioc": "",
        "cca2": "TK",
        "capital": "Fakaofo",
        "lat": -9,
        "lng": -172,
        "cca3": "TKL",
    },
    {
        "name": "Greece",
        "area": 131990,
        "cioc": "GRE",
        "cca2": "GR",
        "capital": "Athens",
        "lat": 39,
        "lng": 22,
        "cca3": "GRC",
    },
    {
        "name": "Russia",
        "area": 17098242,
        "cioc": "RUS",
        "cca2": "RU",
        "capital": "Moscow",
        "lat": 60,
        "lng": 100,
        "cca3": "RUS",
    },
    {
        "name": "Greenland",
        "area": 2166086,
        "cioc": "",
        "cca2": "GL",
        "capital": "Nuuk",
        "lat": 72,
        "lng": -40,
        "cca3": "GRL",
    },
    {
        "name": "Andorra",
        "area": 468,
        "cioc": "AND",
        "cca2": "AD",
        "capital": "Andorra la Vella",
        "lat": 42.5,
        "lng": 1.5,
        "cca3": "AND",
    },
    {
        "name": "Mozambique",
        "area": 801590,
        "cioc": "MOZ",
        "cca2": "MZ",
        "capital": "Maputo",
        "lat": -18.25,
        "lng": 35,
        "cca3": "MOZ",
    },
    {
        "name": "Tajikistan",
        "area": 143100,
        "cioc": "TJK",
        "cca2": "TJ",
        "capital": "Dushanbe",
        "lat": 39,
        "lng": 71,
        "cca3": "TJK",
    },
    {
        "name": "Haiti",
        "area": 27750,
        "cioc": "HAI",
        "cca2": "HT",
        "capital": "Port-au-Prince",
        "lat": 19,
        "lng": -72.41666666,
        "cca3": "HTI",
    },
    {
        "name": "Mexico",
        "area": 1964375,
        "cioc": "MEX",
        "cca2": "MX",
        "capital": "Mexico City",
        "lat": 23,
        "lng": -102,
        "cca3": "MEX",
    },
    {
        "name": "Zimbabwe",
        "area": 390757,
        "cioc": "ZIM",
        "cca2": "ZW",
        "capital": "Harare",
        "lat": -20,
        "lng": 30,
        "cca3": "ZWE",
    },
    {
        "name": "Saint Lucia",
        "area": 616,
        "cioc": "LCA",
        "cca2": "LC",
        "capital": "Castries",
        "lat": 13.88333333,
        "lng": -60.96666666,
        "cca3": "LCA",
    },
    {
        "name": "India",
        "area": 3287590,
        "cioc": "IND",
        "cca2": "IN",
        "capital": "New Delhi",
        "lat": 20,
        "lng": 77,
        "cca3": "IND",
    },
    {
        "name": "Latvia",
        "area": 64559,
        "cioc": "LAT",
        "cca2": "LV",
        "capital": "Riga",
        "lat": 57,
        "lng": 25,
        "cca3": "LVA",
    },
    {
        "name": "Bhutan",
        "area": 38394,
        "cioc": "BHU",
        "cca2": "BT",
        "capital": "Thimphu",
        "lat": 27.5,
        "lng": 90.5,
        "cca3": "BTN",
    },
    {
        "name": "Saint Vincent and the Grenadines",
        "area": 389,
        "cioc": "VIN",
        "cca2": "VC",
        "capital": "Kingstown",
        "lat": 13.25,
        "lng": -61.2,
        "cca3": "VCT",
    },
    {
        "name": "Vietnam",
        "area": 331212,
        "cioc": "VIE",
        "cca2": "VN",
        "capital": "Hanoi",
        "lat": 16.16666666,
        "lng": 107.83333333,
        "cca3": "VNM",
    },
    {
        "name": "Norway",
        "area": 323802,
        "cioc": "NOR",
        "cca2": "NO",
        "capital": "Oslo",
        "lat": 62,
        "lng": 10,
        "cca3": "NOR",
    },
    {
        "name": "Czech Republic",
        "area": 78865,
        "cioc": "CZE",
        "cca2": "CZ",
        "capital": "Prague",
        "lat": 49.75,
        "lng": 15.5,
        "cca3": "CZE",
    },
    {
        "name": "French Southern and Antarctic Lands",
        "area": 7747,
        "cioc": "",
        "cca2": "TF",
        "capital": "Port-aux-Francais",
        "lat": -49.25,
        "lng": 69.167,
        "cca3": "ATF",
    },
    {
        "name": "Antigua and Barbuda",
        "area": 442,
        "cioc": "ANT",
        "cca2": "AG",
        "capital": "Saint John's",
        "lat": 17.05,
        "lng": -61.8,
        "cca3": "ATG",
    },
    {
        "name": "Fiji",
        "area": 18272,
        "cioc": "FIJ",
        "cca2": "FJ",
        "capital": "Suva",
        "lat": -18,
        "lng": 175,
        "cca3": "FJI",
    },
    {
        "name": "British Indian Ocean Territory",
        "area": 60,
        "cioc": "",
        "cca2": "IO",
        "capital": "Diego Garcia",
        "lat": -6,
        "lng": 71.5,
        "cca3": "IOT",
    },
    {
        "name": "Honduras",
        "area": 112492,
        "cioc": "HON",
        "cca2": "HN",
        "capital": "Tegucigalpa",
        "lat": 15,
        "lng": -86.5,
        "cca3": "HND",
    },
    {
        "name": "Mauritius",
        "area": 2040,
        "cioc": "MRI",
        "cca2": "MU",
        "capital": "Port Louis",
        "lat": -20.28333333,
        "lng": 57.55,
        "cca3": "MUS",
    },
    {
        "name": "Antarctica",
        "area": 14000000,
        "cioc": "",
        "cca2": "AQ",
        "capital": "",
        "lat": -90,
        "lng": 0,
        "cca3": "ATA",
    },
    {
        "name": "Luxembourg",
        "area": 2586,
        "cioc": "LUX",
        "cca2": "LU",
        "capital": "Luxembourg",
        "lat": 49.75,
        "lng": 6.16666666,
        "cca3": "LUX",
    },
    {
        "name": "Israel",
        "area": 20770,
        "cioc": "ISR",
        "cca2": "IL",
        "capital": "Jerusalem",
        "lat": 31.47,
        "lng": 35.13,
        "cca3": "ISR",
    },
    {
        "name": "Micronesia",
        "area": 702,
        "cioc": "FSM",
        "cca2": "FM",
        "capital": "Palikir",
        "lat": 6.91666666,
        "lng": 158.25,
        "cca3": "FSM",
    },
    {
        "name": "Peru",
        "area": 1285216,
        "cioc": "PER",
        "cca2": "PE",
        "capital": "Lima",
        "lat": -10,
        "lng": -76,
        "cca3": "PER",
    },
    {
        "name": "Reunion",
        "area": 2511,
        "cioc": "",
        "cca2": "RE",
        "capital": "Saint-Denis",
        "lat": -21.15,
        "lng": 55.5,
        "cca3": "REU",
    },
    {
        "name": "Indonesia",
        "area": 1904569,
        "cioc": "INA",
        "cca2": "ID",
        "capital": "Jakarta",
        "lat": -5,
        "lng": 120,
        "cca3": "IDN",
    },
    {
        "name": "Vanuatu",
        "area": 12189,
        "cioc": "VAN",
        "cca2": "VU",
        "capital": "Port Vila",
        "lat": -16,
        "lng": 167,
        "cca3": "VUT",
    },
    {
        "name": "Macedonia",
        "area": 25713,
        "cioc": "MKD",
        "cca2": "MK",
        "capital": "Skopje",
        "lat": 41.83333333,
        "lng": 22,
        "cca3": "MKD",
    },
    {
        "name": "DR Congo",
        "area": 2344858,
        "cioc": "COD",
        "cca2": "CD",
        "capital": "Kinshasa",
        "lat": 0,
        "lng": 25,
        "cca3": "COD",
    },
    {
        "name": "Republic of the Congo",
        "area": 342000,
        "cioc": "CGO",
        "cca2": "CG",
        "capital": "Brazzaville",
        "lat": -1,
        "lng": 15,
        "cca3": "COG",
    },
    {
        "name": "Iceland",
        "area": 103000,
        "cioc": "ISL",
        "cca2": "IS",
        "capital": "Reykjavik",
        "lat": 65,
        "lng": -18,
        "cca3": "ISL",
    },
    {
        "name": "Guadeloupe",
        "area": 1628,
        "cioc": "",
        "cca2": "GP",
        "capital": "Basse-Terre",
        "lat": 16.25,
        "lng": -61.583333,
        "cca3": "GLP",
    },
    {
        "name": "Cook Islands",
        "area": 236,
        "cioc": "COK",
        "cca2": "CK",
        "capital": "Avarua",
        "lat": -21.23333333,
        "lng": -159.76666666,
        "cca3": "COK",
    },
    {
        "name": "Comoros",
        "area": 1862,
        "cioc": "COM",
        "cca2": "KM",
        "capital": "Moroni",
        "lat": -12.16666666,
        "lng": 44.25,
        "cca3": "COM",
    },
    {
        "name": "Colombia",
        "area": 1141748,
        "cioc": "COL",
        "cca2": "CO",
        "capital": "Bogota",
        "lat": 4,
        "lng": -72,
        "cca3": "COL",
    },
    {
        "name": "Nigeria",
        "area": 923768,
        "cioc": "NGR",
        "cca2": "NG",
        "capital": "Abuja",
        "lat": 10,
        "lng": 8,
        "cca3": "NGA",
    },
    {
        "name": "Timor-Leste",
        "area": 14874,
        "cioc": "TLS",
        "cca2": "TL",
        "capital": "Dili",
        "lat": -8.83333333,
        "lng": 125.91666666,
        "cca3": "TLS",
    },
    {
        "name": "Taiwan",
        "area": 36193,
        "cioc": "TPE",
        "cca2": "TW",
        "capital": "Taipei",
        "lat": 23.5,
        "lng": 121,
        "cca3": "TWN",
    },
    {
        "name": "Portugal",
        "area": 92090,
        "cioc": "POR",
        "cca2": "PT",
        "capital": "Lisbon",
        "lat": 39.5,
        "lng": -8,
        "cca3": "PRT",
    },
    {
        "name": "Moldova",
        "area": 33846,
        "cioc": "MDA",
        "cca2": "MD",
        "capital": "Chisinau",
        "lat": 47,
        "lng": 29,
        "cca3": "MDA",
    },
    {
        "name": "Guernsey",
        "area": 78,
        "cioc": "",
        "cca2": "GG",
        "capital": "St. Peter Port",
        "lat": 49.46666666,
        "lng": -2.58333333,
        "cca3": "GGY",
    },
    {
        "name": "Madagascar",
        "area": 587041,
        "cioc": "MAD",
        "cca2": "MG",
        "capital": "Antananarivo",
        "lat": -20,
        "lng": 47,
        "cca3": "MDG",
    },
    {
        "name": "Ecuador",
        "area": 276841,
        "cioc": "ECU",
        "cca2": "EC",
        "capital": "Quito",
        "lat": -2,
        "lng": -77.5,
        "cca3": "ECU",
    },
    {
        "name": "Senegal",
        "area": 196722,
        "cioc": "SEN",
        "cca2": "SN",
        "capital": "Dakar",
        "lat": 14,
        "lng": -14,
        "cca3": "SEN",
    },
    {
        "name": "New Zealand",
        "area": 270467,
        "cioc": "NZL",
        "cca2": "NZ",
        "capital": "Wellington",
        "lat": -41,
        "lng": 174,
        "cca3": "NZL",
    },
    {
        "name": "Maldives",
        "area": 300,
        "cioc": "MDV",
        "cca2": "MV",
        "capital": "Male",
        "lat": 3.25,
        "lng": 73,
        "cca3": "MDV",
    },
    {
        "name": "American Samoa",
        "area": 199,
        "cioc": "ASA",
        "cca2": "AS",
        "capital": "Pago Pago",
        "lat": -14.33333333,
        "lng": -170,
        "cca3": "ASM",
    },
    {
        "name": "Saint Pierre and Miquelon",
        "area": 242,
        "cioc": "",
        "cca2": "PM",
        "capital": "Saint-Pierre",
        "lat": 46.83333333,
        "lng": -56.33333333,
        "cca3": "SPM",
    },
    {
        "name": "Curacao",
        "area": 444,
        "cioc": "",
        "cca2": "CW",
        "capital": "Willemstad",
        "lat": 12.116667,
        "lng": -68.933333,
        "cca3": "CUW",
    },
    {
        "name": "France",
        "area": 551695,
        "cioc": "FRA",
        "cca2": "FR",
        "capital": "Paris",
        "lat": 46,
        "lng": 2,
        "cca3": "FRA",
    },
    {
        "name": "Lithuania",
        "area": 65300,
        "cioc": "LTU",
        "cca2": "LT",
        "capital": "Vilnius",
        "lat": 56,
        "lng": 24,
        "cca3": "LTU",
    },
    {
        "name": "Rwanda",
        "area": 26338,
        "cioc": "RWA",
        "cca2": "RW",
        "capital": "Kigali",
        "lat": -2,
        "lng": 30,
        "cca3": "RWA",
    },
    {
        "name": "Zambia",
        "area": 752612,
        "cioc": "ZAM",
        "cca2": "ZM",
        "capital": "Lusaka",
        "lat": -15,
        "lng": 30,
        "cca3": "ZMB",
    },
    {
        "name": "Gambia",
        "area": 10689,
        "cioc": "GAM",
        "cca2": "GM",
        "capital": "Banjul",
        "lat": 13.46666666,
        "lng": -16.56666666,
        "cca3": "GMB",
    },
    {
        "name": "Wallis and Futuna",
        "area": 142,
        "cioc": "",
        "cca2": "WF",
        "capital": "Mata-Utu",
        "lat": -13.3,
        "lng": -176.2,
        "cca3": "WLF",
    },
    {
        "name": "Jersey",
        "area": 116,
        "cioc": "",
        "cca2": "JE",
        "capital": "Saint Helier",
        "lat": 49.25,
        "lng": -2.16666666,
        "cca3": "JEY",
    },
    {
        "name": "Faroe Islands",
        "area": 1393,
        "cioc": "",
        "cca2": "FO",
        "capital": "Torshavn",
        "lat": 62,
        "lng": -7,
        "cca3": "FRO",
    },
    {
        "name": "Guatemala",
        "area": 108889,
        "cioc": "GUA",
        "cca2": "GT",
        "capital": "Guatemala City",
        "lat": 15.5,
        "lng": -90.25,
        "cca3": "GTM",
    },
    {
        "name": "Denmark",
        "area": 43094,
        "cioc": "DEN",
        "cca2": "DK",
        "capital": "Copenhagen",
        "lat": 56,
        "lng": 10,
        "cca3": "DNK",
    },
    {
        "name": "Isle of Man",
        "area": 572,
        "cioc": "",
        "cca2": "IM",
        "capital": "Douglas",
        "lat": 54.25,
        "lng": -4.5,
        "cca3": "IMN",
    },
    {
        "name": "Australia",
        "area": 7692024,
        "cioc": "AUS",
        "cca2": "AU",
        "capital": "Canberra",
        "lat": -27,
        "lng": 133,
        "cca3": "AUS",
    },
    {
        "name": "Austria",
        "area": 83871,
        "cioc": "AUT",
        "cca2": "AT",
        "capital": "Vienna",
        "lat": 47.33333333,
        "lng": 13.33333333,
        "cca3": "AUT",
    },
    {
        "name": "Svalbard and Jan Mayen",
        "area": -1,
        "cioc": "",
        "cca2": "SJ",
        "capital": "Longyearbyen",
        "lat": 78,
        "lng": 20,
        "cca3": "SJM",
    },
    {
        "name": "Venezuela",
        "area": 916445,
        "cioc": "VEN",
        "cca2": "VE",
        "capital": "Caracas",
        "lat": 8,
        "lng": -66,
        "cca3": "VEN",
    },
    {
        "name": "Kosovo",
        "area": 10908,
        "cioc": "KOS",
        "cca2": "XK",
        "capital": "Pristina",
        "lat": 42.666667,
        "lng": 21.166667,
        "cca3": "UNK",
    },
    {
        "name": "Palau",
        "area": 459,
        "cioc": "PLW",
        "cca2": "PW",
        "capital": "Ngerulmud",
        "lat": 7.5,
        "lng": 134.5,
        "cca3": "PLW",
    },
    {
        "name": "Kenya",
        "area": 580367,
        "cioc": "KEN",
        "cca2": "KE",
        "capital": "Nairobi",
        "lat": 1,
        "lng": 38,
        "cca3": "KEN",
    },
    {
        "name": "Samoa",
        "area": 2842,
        "cioc": "SAM",
        "cca2": "WS",
        "capital": "Apia",
        "lat": -13.58333333,
        "lng": -172.33333333,
        "cca3": "WSM",
    },
    {
        "name": "Turkey",
        "area": 783562,
        "cioc": "TUR",
        "cca2": "TR",
        "capital": "Ankara",
        "lat": 39,
        "lng": 35,
        "cca3": "TUR",
    },
    {
        "name": "Albania",
        "area": 28748,
        "cioc": "ALB",
        "cca2": "AL",
        "capital": "Tirana",
        "lat": 41,
        "lng": 20,
        "cca3": "ALB",
    },
    {
        "name": "Oman",
        "area": 309500,
        "cioc": "OMA",
        "cca2": "OM",
        "capital": "Muscat",
        "lat": 21,
        "lng": 57,
        "cca3": "OMN",
    },
    {
        "name": "Tuvalu",
        "area": 26,
        "cioc": "TUV",
        "cca2": "TV",
        "capital": "Funafuti",
        "lat": -8,
        "lng": 178,
        "cca3": "TUV",
    },
    {
        "name": "Aland Islands",
        "area": 1580,
        "cioc": "",
        "cca2": "AX",
        "capital": "Mariehamn",
        "lat": 60.116667,
        "lng": 19.9,
        "cca3": "ALA",
    },
    {
        "name": "Brunei",
        "area": 5765,
        "cioc": "BRU",
        "cca2": "BN",
        "capital": "Bandar Seri Begawan",
        "lat": 4.5,
        "lng": 114.66666666,
        "cca3": "BRN",
    },
    {
        "name": "Tunisia",
        "area": 163610,
        "cioc": "TUN",
        "cca2": "TN",
        "capital": "Tunis",
        "lat": 34,
        "lng": 9,
        "cca3": "TUN",
    },
    {
        "name": "Pitcairn Islands",
        "area": 47,
        "cioc": "",
        "cca2": "PN",
        "capital": "Adamstown",
        "lat": -25.06666666,
        "lng": -130.1,
        "cca3": "PCN",
    },
    {
        "name": "Barbados",
        "area": 430,
        "cioc": "BAR",
        "cca2": "BB",
        "capital": "Bridgetown",
        "lat": 13.16666666,
        "lng": -59.53333333,
        "cca3": "BRB",
    },
    {
        "name": "Brazil",
        "area": 8515767,
        "cioc": "BRA",
        "cca2": "BR",
        "capital": "Brasilia",
        "lat": -10,
        "lng": -55,
        "cca3": "BRA",
    },
    {
        "name": "Ivory Coast",
        "area": 322463,
        "cioc": "CIV",
        "cca2": "CI",
        "capital": "Yamoussoukro",
        "lat": 8,
        "lng": -5,
        "cca3": "CIV",
    },
    {
        "name": "Serbia",
        "area": 88361,
        "cioc": "SRB",
        "cca2": "RS",
        "capital": "Belgrade",
        "lat": 44,
        "lng": 21,
        "cca3": "SRB",
    },
    {
        "name": "Equatorial Guinea",
        "area": 28051,
        "cioc": "GEQ",
        "cca2": "GQ",
        "capital": "Malabo",
        "lat": 2,
        "lng": 10,
        "cca3": "GNQ",
    },
    {
        "name": "United States",
        "area": 9372610,
        "cioc": "USA",
        "cca2": "US",
        "capital": "Washington D.C.",
        "lat": 38,
        "lng": -97,
        "cca3": "USA",
    },
    {
        "name": "Qatar",
        "area": 11586,
        "cioc": "QAT",
        "cca2": "QA",
        "capital": "Doha",
        "lat": 25.5,
        "lng": 51.25,
        "cca3": "QAT",
    },
    {
        "name": "Sweden",
        "area": 450295,
        "cioc": "SWE",
        "cca2": "SE",
        "capital": "Stockholm",
        "lat": 62,
        "lng": 15,
        "cca3": "SWE",
    },
    {
        "name": "Azerbaijan",
        "area": 86600,
        "cioc": "AZE",
        "cca2": "AZ",
        "capital": "Baku",
        "lat": 40.5,
        "lng": 47.5,
        "cca3": "AZE",
    },
    {
        "name": "Guinea-Bissau",
        "area": 36125,
        "cioc": "GBS",
        "cca2": "GW",
        "capital": "Bissau",
        "lat": 12,
        "lng": -15,
        "cca3": "GNB",
    },
    {
        "name": "Swaziland",
        "area": 17364,
        "cioc": "SWZ",
        "cca2": "SZ",
        "capital": "Lobamba",
        "lat": -26.5,
        "lng": 31.5,
        "cca3": "SWZ",
    },
    {
        "name": "Tonga",
        "area": 747,
        "cioc": "TGA",
        "cca2": "TO",
        "capital": "Nuku'alofa",
        "lat": -20,
        "lng": -175,
        "cca3": "TON",
    },
    {
        "name": "Canada",
        "area": 9984670,
        "cioc": "CAN",
        "cca2": "CA",
        "capital": "Ottawa",
        "lat": 60,
        "lng": -95,
        "cca3": "CAN",
    },
    {
        "name": "Ukraine",
        "area": 603500,
        "cioc": "UKR",
        "cca2": "UA",
        "capital": "Kiev",
        "lat": 49,
        "lng": 32,
        "cca3": "UKR",
    },
    {
        "name": "South Korea",
        "area": 100210,
        "cioc": "KOR",
        "cca2": "KR",
        "capital": "Seoul",
        "lat": 37,
        "lng": 127.5,
        "cca3": "KOR",
    },
    {
        "name": "Anguilla",
        "area": 91,
        "cioc": "",
        "cca2": "AI",
        "capital": "The Valley",
        "lat": 18.25,
        "lng": -63.16666666,
        "cca3": "AIA",
    },
    {
        "name": "Central African Republic",
        "area": 622984,
        "cioc": "CAF",
        "cca2": "CF",
        "capital": "Bangui",
        "lat": 7,
        "lng": 21,
        "cca3": "CAF",
    },
    {
        "name": "Slovakia",
        "area": 49037,
        "cioc": "SVK",
        "cca2": "SK",
        "capital": "Bratislava",
        "lat": 48.66666666,
        "lng": 19.5,
        "cca3": "SVK",
    },
    {
        "name": "Cyprus",
        "area": 9251,
        "cioc": "CYP",
        "cca2": "CY",
        "capital": "Nicosia",
        "lat": 35,
        "lng": 33,
        "cca3": "CYP",
    },
    {
        "name": "Bosnia and Herzegovina",
        "area": 51209,
        "cioc": "BIH",
        "cca2": "BA",
        "capital": "Sarajevo",
        "lat": 44,
        "lng": 18,
        "cca3": "BIH",
    },
    {
        "name": "Singapore",
        "area": 710,
        "cioc": "SIN",
        "cca2": "SG",
        "capital": "Singapore",
        "lat": 1.36666666,
        "lng": 103.8,
        "cca3": "SGP",
    },
    {
        "name": "South Georgia",
        "area": 3903,
        "cioc": "",
        "cca2": "GS",
        "capital": "King Edward Point",
        "lat": -54.5,
        "lng": -37,
        "cca3": "SGS",
    },
    {
        "name": "Somalia",
        "area": 637657,
        "cioc": "SOM",
        "cca2": "SO",
        "capital": "Mogadishu",
        "lat": 10,
        "lng": 49,
        "cca3": "SOM",
    },
    {
        "name": "Uzbekistan",
        "area": 447400,
        "cioc": "UZB",
        "cca2": "UZ",
        "capital": "Tashkent",
        "lat": 41,
        "lng": 64,
        "cca3": "UZB",
    },
    {
        "name": "Eritrea",
        "area": 117600,
        "cioc": "ERI",
        "cca2": "ER",
        "capital": "Asmara",
        "lat": 15,
        "lng": 39,
        "cca3": "ERI",
    },
    {
        "name": "Poland",
        "area": 312679,
        "cioc": "POL",
        "cca2": "PL",
        "capital": "Warsaw",
        "lat": 52,
        "lng": 20,
        "cca3": "POL",
    },
    {
        "name": "Kuwait",
        "area": 17818,
        "cioc": "KUW",
        "cca2": "KW",
        "capital": "Kuwait City",
        "lat": 29.5,
        "lng": 45.75,
        "cca3": "KWT",
    },
    {
        "name": "Gabon",
        "area": 267668,
        "cioc": "GAB",
        "cca2": "GA",
        "capital": "Libreville",
        "lat": -1,
        "lng": 11.75,
        "cca3": "GAB",
    },
    {
        "name": "Cayman Islands",
        "area": 264,
        "cioc": "CAY",
        "cca2": "KY",
        "capital": "George Town",
        "lat": 19.5,
        "lng": -80.5,
        "cca3": "CYM",
    },
    {
        "name": "Vatican City",
        "area": 0.44,
        "cioc": "",
        "cca2": "VA",
        "capital": "Vatican City",
        "lat": 41.9,
        "lng": 12.45,
        "cca3": "VAT",
    },
    {
        "name": "Estonia",
        "area": 45227,
        "cioc": "EST",
        "cca2": "EE",
        "capital": "Tallinn",
        "lat": 59,
        "lng": 26,
        "cca3": "EST",
    },
    {
        "name": "Malawi",
        "area": 118484,
        "cioc": "MAW",
        "cca2": "MW",
        "capital": "Lilongwe",
        "lat": -13.5,
        "lng": 34,
        "cca3": "MWI",
    },
    {
        "name": "Spain",
        "area": 505992,
        "cioc": "ESP",
        "cca2": "ES",
        "capital": "Madrid",
        "lat": 40,
        "lng": -4,
        "cca3": "ESP",
    },
    {
        "name": "Iraq",
        "area": 438317,
        "cioc": "IRQ",
        "cca2": "IQ",
        "capital": "Baghdad",
        "lat": 33,
        "lng": 44,
        "cca3": "IRQ",
    },
    {
        "name": "El Salvador",
        "area": 21041,
        "cioc": "ESA",
        "cca2": "SV",
        "capital": "San Salvador",
        "lat": 13.83333333,
        "lng": -88.91666666,
        "cca3": "SLV",
    },
    {
        "name": "Mali",
        "area": 1240192,
        "cioc": "MLI",
        "cca2": "ML",
        "capital": "Bamako",
        "lat": 17,
        "lng": -4,
        "cca3": "MLI",
    },
    {
        "name": "Ireland",
        "area": 70273,
        "cioc": "IRL",
        "cca2": "IE",
        "capital": "Dublin",
        "lat": 53,
        "lng": -8,
        "cca3": "IRL",
    },
    {
        "name": "Iran",
        "area": 1648195,
        "cioc": "IRI",
        "cca2": "IR",
        "capital": "Tehran",
        "lat": 32,
        "lng": 53,
        "cca3": "IRN",
    },
    {
        "name": "Aruba",
        "area": 180,
        "cioc": "ARU",
        "cca2": "AW",
        "capital": "Oranjestad",
        "lat": 12.5,
        "lng": -69.96666666,
        "cca3": "ABW",
    },
    {
        "name": "Papua New Guinea",
        "area": 462840,
        "cioc": "PNG",
        "cca2": "PG",
        "capital": "Port Moresby",
        "lat": -6,
        "lng": 147,
        "cca3": "PNG",
    },
    {
        "name": "Panama",
        "area": 75417,
        "cioc": "PAN",
        "cca2": "PA",
        "capital": "Panama City",
        "lat": 9,
        "lng": -80,
        "cca3": "PAN",
    },
    {
        "name": "Sudan",
        "area": 1886068,
        "cioc": "SUD",
        "cca2": "SD",
        "capital": "Khartoum",
        "lat": 15,
        "lng": 30,
        "cca3": "SDN",
    },
    {
        "name": "Solomon Islands",
        "area": 28896,
        "cioc": "SOL",
        "cca2": "SB",
        "capital": "Honiara",
        "lat": -8,
        "lng": 159,
        "cca3": "SLB",
    },
    {
        "name": "Western Sahara",
        "area": 266000,
        "cioc": "",
        "cca2": "EH",
        "capital": "El Aaiun",
        "lat": 24.5,
        "lng": -13,
        "cca3": "ESH",
    },
    {
        "name": "Monaco",
        "area": 2.02,
        "cioc": "MON",
        "cca2": "MC",
        "capital": "Monaco",
        "lat": 43.73333333,
        "lng": 7.4,
        "cca3": "MCO",
    },
    {
        "name": "Italy",
        "area": 301336,
        "cioc": "ITA",
        "cca2": "IT",
        "capital": "Rome",
        "lat": 42.83333333,
        "lng": 12.83333333,
        "cca3": "ITA",
    },
    {
        "name": "Japan",
        "area": 377930,
        "cioc": "JPN",
        "cca2": "JP",
        "capital": "Tokyo",
        "lat": 36,
        "lng": 138,
        "cca3": "JPN",
    },
    {
        "name": "Kyrgyzstan",
        "area": 199951,
        "cioc": "KGZ",
        "cca2": "KG",
        "capital": "Bishkek",
        "lat": 41,
        "lng": 75,
        "cca3": "KGZ",
    },
    {
        "name": "Uganda",
        "area": 241550,
        "cioc": "UGA",
        "cca2": "UG",
        "capital": "Kampala",
        "lat": 1,
        "lng": 32,
        "cca3": "UGA",
    },
    {
        "name": "New Caledonia",
        "area": 18575,
        "cioc": "",
        "cca2": "NC",
        "capital": "Noumea",
        "lat": -21.5,
        "lng": 165.5,
        "cca3": "NCL",
    },
    {
        "name": "United Arab Emirates",
        "area": 83600,
        "cioc": "UAE",
        "cca2": "AE",
        "capital": "Abu Dhabi",
        "lat": 24,
        "lng": 54,
        "cca3": "ARE",
    },
    {
        "name": "Argentina",
        "area": 2780400,
        "cioc": "ARG",
        "cca2": "AR",
        "capital": "Buenos Aires",
        "lat": -34,
        "lng": -64,
        "cca3": "ARG",
    },
    {
        "name": "Bahamas",
        "area": 13943,
        "cioc": "BAH",
        "cca2": "BS",
        "capital": "Nassau",
        "lat": 24.25,
        "lng": -76,
        "cca3": "BHS",
    },
    {
        "name": "Bahrain",
        "area": 765,
        "cioc": "BRN",
        "cca2": "BH",
        "capital": "Manama",
        "lat": 26,
        "lng": 50.55,
        "cca3": "BHR",
    },
    {
        "name": "Armenia",
        "area": 29743,
        "cioc": "ARM",
        "cca2": "AM",
        "capital": "Yerevan",
        "lat": 40,
        "lng": 45,
        "cca3": "ARM",
    },
    {
        "name": "Nauru",
        "area": 21,
        "cioc": "NRU",
        "cca2": "NR",
        "capital": "Yaren",
        "lat": -0.53333333,
        "lng": 166.91666666,
        "cca3": "NRU",
    },
    {
        "name": "Cuba",
        "area": 109884,
        "cioc": "CUB",
        "cca2": "CU",
        "capital": "Havana",
        "lat": 21.5,
        "lng": -80,
        "cca3": "CUB",
    },
]

all_lookups: Dict[str, Dict[str, Dict[str, Any]]] = {}
lookups = ["cioc", "cca2", "cca3", "name"]
for lookup in lookups:
    all_lookups[lookup] = {}
    for country in countries:
        all_lookups[lookup][country[lookup].lower()] = country


def get(field: str, symbol: str) -> Optional[Dict[str, Any]]:
    """
    Get country data based on a standard code and a symbol
    """
    return all_lookups[field].get(symbol.lower())
