/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Map;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.InstanceOfAny;
import net.sf.oval.context.OValContext;
import net.sf.oval.internal.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceOfAnyCheck
extends AbstractAnnotationCheck<InstanceOfAny> {
    private static final long serialVersionUID = 1L;
    private Class<?>[] types;

    @Override
    public void configure(InstanceOfAny constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setTypes(constraintAnnotation.value());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        if (this.types.length == 1) {
            messageVariables.put("types", this.types[0].getName());
        } else {
            Object[] classNames = new String[this.types.length];
            int i = 0;
            int l = classNames.length;
            while (i < l) {
                classNames[i] = this.types[i].getName();
                ++i;
            }
            messageVariables.put("types", StringUtils.implode(classNames, ","));
        }
        return messageVariables;
    }

    public Class<?>[] getTypes() {
        return this.types;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        Class<?>[] classArray = this.types;
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (type.isInstance(valueToValidate)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setTypes(Class<?> ... types) {
        this.types = types;
        this.requireMessageVariablesRecreation();
    }
}

