/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.config.provider;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.config.ConfigData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.config.ConfigException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.config.internals.AllowedPaths;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;
import org.apache.skywalking.apm.dependencies.org.slf4j.LoggerFactory;

public class FileConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(FileConfigProvider.class);
    public static final String ALLOWED_PATHS_CONFIG = "allowed.paths";
    public static final String ALLOWED_PATHS_DOC = "A comma separated list of paths that this config provider is allowed to access. If not set, all paths are allowed.";
    private volatile AllowedPaths allowedPaths;

    @Override
    public void configure(Map<String, ?> configs) {
        this.allowedPaths = new AllowedPaths(configs.getOrDefault(ALLOWED_PATHS_CONFIG, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigData get(String path) {
        if (this.allowedPaths == null) {
            throw new IllegalStateException("The provider has not been configured yet.");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        if (path == null) return new ConfigData(data);
        if (path.isEmpty()) {
            return new ConfigData(data);
        }
        Path filePath = this.allowedPaths.parseUntrustedPath(path);
        if (filePath == null) {
            log.warn("The path {} is not allowed to be accessed", (Object)path);
            return new ConfigData(data);
        }
        try (Reader reader = this.reader(filePath);){
            Properties properties = new Properties();
            properties.load(reader);
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                String value = properties.getProperty(key);
                if (value == null) continue;
                data.put(key, value);
            }
            ConfigData configData = new ConfigData(data);
            return configData;
        }
        catch (IOException e) {
            log.error("Could not read properties from file {}", (Object)path, (Object)e);
            throw new ConfigException("Could not read properties from file " + path);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigData get(String path, Set<String> keys) {
        if (this.allowedPaths == null) {
            throw new IllegalStateException("The provider has not been configured yet.");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        if (path == null) return new ConfigData(data);
        if (path.isEmpty()) {
            return new ConfigData(data);
        }
        Path filePath = this.allowedPaths.parseUntrustedPath(path);
        if (filePath == null) {
            log.warn("The path {} is not allowed to be accessed", (Object)path);
            return new ConfigData(data);
        }
        try (Reader reader = this.reader(filePath);){
            Properties properties = new Properties();
            properties.load(reader);
            for (String key : keys) {
                String value = properties.getProperty(key);
                if (value == null) continue;
                data.put(key, value);
            }
            ConfigData configData = new ConfigData(data);
            return configData;
        }
        catch (IOException e) {
            log.error("Could not read properties from file {}", (Object)path, (Object)e);
            throw new ConfigException("Could not read properties from file " + path);
        }
    }

    protected Reader reader(Path path) throws IOException {
        return Files.newBufferedReader(path, StandardCharsets.UTF_8);
    }

    @Override
    public void close() {
    }
}

