/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm.gc;

import java.lang.management.GarbageCollectorMXBean;
import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.jvm.gc.GCMetricAccessor;
import org.apache.skywalking.apm.network.language.agent.v3.GC;
import org.apache.skywalking.apm.network.language.agent.v3.GCPhase;

public class ZGCModule
implements GCMetricAccessor {
    private List<GarbageCollectorMXBean> beans;
    private long lastNormalGCCount = 0L;
    private long lastNormalGCTime = 0L;

    public ZGCModule(List<GarbageCollectorMXBean> beans) {
        this.beans = beans;
    }

    @Override
    public List<GC> getGCList() {
        LinkedList<GC> gcList = new LinkedList<GC>();
        for (GarbageCollectorMXBean bean : this.beans) {
            long collectionCount;
            String name = bean.getName();
            long gcCount = 0L;
            long gcTime = 0L;
            if (name.equals("ZGC")) {
                collectionCount = bean.getCollectionCount();
                gcCount = collectionCount - this.lastNormalGCCount;
                this.lastNormalGCCount = collectionCount;
                long time = bean.getCollectionTime();
                gcTime = time - this.lastNormalGCTime;
                this.lastNormalGCTime = time;
            } else if (name.equals("ZGC Cycles")) {
                collectionCount = bean.getCollectionCount();
                gcCount = collectionCount - this.lastNormalGCCount;
                this.lastNormalGCCount = collectionCount;
            } else {
                if (!name.equals("ZGC Pauses")) continue;
                long time = bean.getCollectionTime();
                gcTime = time - this.lastNormalGCTime;
                this.lastNormalGCTime = time;
            }
            gcList.add(GC.newBuilder().setPhase(GCPhase.NORMAL).setCount(gcCount).setTime(gcTime).build());
        }
        return gcList;
    }
}

