/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.pending.geoapi.temporal.Period;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.temporal.TemporalObjects;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gml.TM_Primitive;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.identification.Usage;
import org.opengis.temporal.TemporalPrimitive;
import org.opengis.util.InternationalString;

@TitleProperty(name="specificUsage")
@XmlType(name="MD_Usage_Type", propOrder={"specificUsage", "usageDate", "usageDates", "userDeterminedLimitations", "userContactInfo", "response", "additionalDocumentations", "issues"})
@XmlRootElement(name="MD_Usage")
public class DefaultUsage
extends ISOMetadata
implements Usage {
    private static final long serialVersionUID = -685588625450110348L;
    private InternationalString specificUsage;
    private Collection<TemporalPrimitive> usageDates;
    private InternationalString userDeterminedLimitations;
    private Collection<ResponsibleParty> userContactInfo;
    private Collection<InternationalString> responses;
    private Collection<Citation> additionalDocumentation;
    private Collection<Citation> identifiedIssues;

    public DefaultUsage() {
    }

    public DefaultUsage(CharSequence specificUsage, ResponsibleParty userContactInfo) {
        this.specificUsage = Types.toInternationalString(specificUsage);
        this.userContactInfo = DefaultUsage.singleton(userContactInfo, ResponsibleParty.class);
    }

    public DefaultUsage(Usage object) {
        super(object);
        if (object != null) {
            this.specificUsage = object.getSpecificUsage();
            this.userDeterminedLimitations = object.getUserDeterminedLimitations();
            this.userContactInfo = DefaultUsage.copyCollection(object.getUserContactInfo(), ResponsibleParty.class);
            if (object instanceof DefaultUsage) {
                DefaultUsage c = (DefaultUsage)object;
                this.usageDates = DefaultUsage.copyCollection(c.getUsageDates(), TemporalPrimitive.class);
                this.responses = DefaultUsage.copyCollection(c.getResponses(), InternationalString.class);
                this.additionalDocumentation = DefaultUsage.copyCollection(c.getAdditionalDocumentation(), Citation.class);
                this.identifiedIssues = DefaultUsage.copyCollection(c.getIdentifiedIssues(), Citation.class);
            } else {
                Date t = object.getUsageDate();
                if (t != null) {
                    this.usageDates = List.of(TemporalObjects.createInstant(TemporalDate.toTemporal(t)));
                }
            }
        }
    }

    public static DefaultUsage castOrCopy(Usage object) {
        if (object == null || object instanceof DefaultUsage) {
            return (DefaultUsage)object;
        }
        return new DefaultUsage(object);
    }

    @XmlElement(name="specificUsage", required=true)
    public InternationalString getSpecificUsage() {
        return this.specificUsage;
    }

    public void setSpecificUsage(InternationalString newValue) {
        this.checkWritePermission(this.specificUsage);
        this.specificUsage = newValue;
    }

    @Deprecated(since="1.5")
    @Dependencies(value={"getUsageDates"})
    @XmlElement(name="usageDateTime", namespace="http://www.isotc211.org/2005/gmd")
    public Date getUsageDate() {
        Collection<TemporalPrimitive> usageDates;
        if (FilterByVersion.LEGACY_METADATA.accept() && (usageDates = this.getUsageDates()) != null) {
            for (TemporalPrimitive t : usageDates) {
                Date p = TemporalDate.toDate(TemporalObjects.getInstant(t));
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    @Deprecated(since="1.5")
    public void setUsageDate(Date newValue) {
        this.setUsageDates(newValue == null ? List.of() : List.of(TemporalObjects.createInstant(TemporalDate.toTemporal(newValue))));
    }

    @XmlElement(name="usageDateTime")
    @XmlJavaTypeAdapter(value=TM_Primitive.Since2014.class)
    @UML(identifier="usageDateTime", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<TemporalPrimitive> getUsageDates() {
        this.usageDates = this.nonNullCollection(this.usageDates, TemporalPrimitive.class);
        return this.usageDates;
    }

    public void setUsageDates(Collection<TemporalPrimitive> newValues) {
        this.usageDates = this.writeCollection(this.usageDates, newValues, TemporalPrimitive.class);
    }

    public void addUsageDates(Temporal beginning, Temporal ending) {
        Period period = TemporalObjects.createPeriod(beginning, ending);
        if (period != null) {
            this.getUsageDates().add(period);
        }
    }

    @XmlElement(name="userDeterminedLimitations")
    public InternationalString getUserDeterminedLimitations() {
        return this.userDeterminedLimitations;
    }

    public void setUserDeterminedLimitations(InternationalString newValue) {
        this.checkWritePermission(this.userDeterminedLimitations);
        this.userDeterminedLimitations = newValue;
    }

    @XmlElement(name="userContactInfo")
    public Collection<ResponsibleParty> getUserContactInfo() {
        this.userContactInfo = this.nonNullCollection(this.userContactInfo, ResponsibleParty.class);
        return this.userContactInfo;
    }

    public void setUserContactInfo(Collection<? extends ResponsibleParty> newValues) {
        this.userContactInfo = this.writeCollection(newValues, this.userContactInfo, ResponsibleParty.class);
    }

    @UML(identifier="response", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<InternationalString> getResponses() {
        this.responses = this.nonNullCollection(this.responses, InternationalString.class);
        return this.responses;
    }

    public void setResponses(Collection<? extends InternationalString> newValues) {
        this.responses = this.writeCollection(newValues, this.responses, InternationalString.class);
    }

    @UML(identifier="additionalDocumentation", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getAdditionalDocumentation() {
        this.additionalDocumentation = this.nonNullCollection(this.additionalDocumentation, Citation.class);
        return this.additionalDocumentation;
    }

    public void setAdditionalDocumentation(Collection<? extends Citation> newValues) {
        this.additionalDocumentation = this.writeCollection(newValues, this.additionalDocumentation, Citation.class);
    }

    @UML(identifier="identifiedIssues", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getIdentifiedIssues() {
        this.identifiedIssues = this.nonNullCollection(this.identifiedIssues, Citation.class);
        return this.identifiedIssues;
    }

    public void setIdentifiedIssues(Collection<? extends Citation> newValues) {
        this.identifiedIssues = this.writeCollection(newValues, this.identifiedIssues, Citation.class);
    }

    @XmlElement(name="response")
    private Collection<InternationalString> getResponse() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getResponses() : null;
    }

    @XmlElement(name="additionalDocumentation")
    private Collection<Citation> getAdditionalDocumentations() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAdditionalDocumentation() : null;
    }

    @XmlElement(name="identifiedIssues")
    private Collection<Citation> getIssues() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getIdentifiedIssues() : null;
    }
}

