/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.http;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class HeaderMap
extends AbstractMap<String, String> {
    public static final String ACCEPT = "Accept";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String USER_AGENT = "User-Agent";
    public static final String CLIENT_META = "X-Elastic-Client-Meta";
    @Nullable
    protected Map<String, String> map;
    public static HeaderMap EMPTY = new HeaderMap(null).locked();

    public HeaderMap() {
        this.map = null;
    }

    public HeaderMap(@Nullable Map<String, String> map) {
        Map<String, String> hmap;
        this.map = map == null || map.isEmpty() ? null : (map instanceof HeaderMap ? ((hmap = ((HeaderMap)map).map) == null ? null : new HashMap<String, String>(hmap)) : new HashMap<String, String>(map));
    }

    @Override
    public int size() {
        return this.map == null ? 0 : this.map.size();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.map == null ? Collections.emptySet() : this.map.entrySet();
    }

    @Override
    public String get(Object object) {
        String key = (String)object;
        if (this.map == null) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        String result;
        if (this.map == null) {
            this.map = new HashMap<String, String>();
            result = null;
        } else {
            result = this.remove(key);
        }
        this.map.put(key, value);
        return result;
    }

    public String add(String key, String value) {
        if (this.map == null) {
            this.map = new HashMap<String, String>();
        } else {
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(key)) continue;
                String current = entry.getValue();
                entry.setValue(current + "; " + value);
                return current;
            }
        }
        return this.map.put(key, value);
    }

    @Override
    public String remove(Object object) {
        String key = (String)object;
        if (this.map == null) {
            return null;
        }
        Iterator<Map.Entry<String, String>> entries = this.map.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            entries.remove();
            return entry.getKey();
        }
        return null;
    }

    public HeaderMap locked() {
        return new Locked(this.map);
    }

    private static class Locked
    extends HeaderMap {
        Locked(Map<String, String> map) {
            super(map);
        }

        private String isLocked() {
            throw new UnsupportedOperationException("HeaderMap is write locked");
        }

        @Override
        public String put(String key, String value) {
            return this.isLocked();
        }

        @Override
        public String add(String key, String value) {
            return this.isLocked();
        }

        @Override
        public String remove(Object object) {
            return this.isLocked();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            if (this.map == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(super.entrySet());
        }
    }
}

