/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.tcp.handler;

import com.google.common.eventbus.EventBus;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.protocol.tcp.BootstrapServer;
import org.apache.shenyu.protocol.tcp.TcpBootstrapServer;
import org.apache.shenyu.protocol.tcp.TcpServerConfiguration;

public final class TcpBootstrapFactory {
    private static final TcpBootstrapFactory SINGLETON = new TcpBootstrapFactory();
    private final Map<String, BootstrapServer> cache = new ConcurrentHashMap<String, BootstrapServer>();

    private TcpBootstrapFactory() {
    }

    public static TcpBootstrapFactory getSingleton() {
        return SINGLETON;
    }

    public BootstrapServer createBootstrapServer(TcpServerConfiguration configuration) {
        EventBus eventBus = new EventBus();
        TcpBootstrapServer bootstrapServer = new TcpBootstrapServer(eventBus);
        bootstrapServer.start(configuration);
        return bootstrapServer;
    }

    public void cache(String selectorName, BootstrapServer bootstrapServer) {
        this.cache.put(selectorName, bootstrapServer);
    }

    public Boolean inCache(String selectorName) {
        return this.cache.containsKey(selectorName);
    }

    public BootstrapServer removeCache(String selectorName) {
        return this.cache.remove(selectorName);
    }

    public BootstrapServer getCache(String selectorName) {
        return this.cache.get(selectorName);
    }
}

