/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http.jetty;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Logger;

public class JettyLoggerAdapter
extends AbstractLogger {
    protected String name;
    private final ErrorTypeAwareLogger logger;
    private static boolean debugEnabled = false;

    public JettyLoggerAdapter() {
        this("org.apache.dubbo.remoting.http.jetty");
    }

    public JettyLoggerAdapter(Class<?> clazz) {
        this(clazz.getName());
    }

    public JettyLoggerAdapter(String name) {
        this.name = name;
        this.logger = LoggerFactory.getErrorTypeAwareLogger(name);
    }

    protected Logger newLogger(String name) {
        return new JettyLoggerAdapter(name);
    }

    public String getName() {
        return this.name;
    }

    public void warn(String msg, Object ... objects) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("0-12", "", "", this.format(msg, objects));
        }
    }

    public void warn(Throwable throwable) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("0-12", "", "", throwable.getMessage(), throwable);
        }
    }

    public void warn(String msg, Throwable throwable) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("0-12", "", "", msg, throwable);
        }
    }

    public void info(String msg, Object ... objects) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format(msg, objects));
        }
    }

    public void info(Throwable throwable) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(throwable);
        }
    }

    public void info(String msg, Throwable throwable) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(msg, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return debugEnabled;
    }

    public void setDebugEnabled(boolean enabled) {
        debugEnabled = enabled;
    }

    public void debug(String msg, Object ... objects) {
        if (debugEnabled && this.logger.isDebugEnabled()) {
            this.logger.debug(this.format(msg, objects));
        }
    }

    public void debug(Throwable throwable) {
        if (debugEnabled && this.logger.isDebugEnabled()) {
            this.logger.debug(throwable);
        }
    }

    public void debug(String msg, Throwable throwable) {
        if (debugEnabled && this.logger.isDebugEnabled()) {
            this.logger.debug(msg, throwable);
        }
    }

    public void ignore(Throwable throwable) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("0-12", "", "", "IGNORED EXCEPTION ", throwable);
        }
    }

    private String format(String msg, Object ... args) {
        msg = String.valueOf(msg);
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = msg.indexOf(braces, start);
            if (bracesIndex < 0) {
                builder.append(msg.substring(start));
                builder.append(' ');
                builder.append(arg);
                start = msg.length();
                continue;
            }
            builder.append(msg, start, bracesIndex);
            builder.append(arg);
            start = bracesIndex + braces.length();
        }
        builder.append(msg.substring(start));
        return builder.toString();
    }
}

