/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.internals;

import com.huaweicloud.lts.producer.internals.LogThread;
import com.huaweicloud.lts.producer.internals.ProducerBatch;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchHandler
extends LogThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchHandler.class);
    private final BlockingQueue<ProducerBatch> batches;
    private final AtomicInteger batchCount;
    private final Semaphore memoryController;
    private volatile boolean closed;

    public BatchHandler(String name, BlockingQueue<ProducerBatch> batches, AtomicInteger batchCount, Semaphore memoryController) {
        super(name, true);
        this.batches = batches;
        this.batchCount = batchCount;
        this.memoryController = memoryController;
        this.closed = false;
    }

    @Override
    public void run() {
        this.loopHandleBatches();
        this.handleRemainingBatches();
    }

    private void loopHandleBatches() {
        while (!this.closed) {
            try {
                ProducerBatch b = this.batches.take();
                this.handle(b);
            }
            catch (InterruptedException e) {
                LOGGER.info("The batch handler has been interrupted");
            }
        }
    }

    private void handleRemainingBatches() {
        ArrayList remainingBatches = new ArrayList();
        this.batches.drainTo(remainingBatches);
        for (ProducerBatch b : remainingBatches) {
            this.handle(b);
        }
    }

    private void handle(ProducerBatch batch) {
        try {
            batch.fireCallbacksAndSetFutures();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle batch, batch={}, e=", (Object)batch, (Object)t);
        }
        finally {
            this.batchCount.decrementAndGet();
            this.memoryController.release(batch.getCurBatchSizeInBytes());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        this.interrupt();
    }
}

