/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.apache.shenyu.common.cache.WindowTinyLFUMap;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.utils.MapUtils;

public final class MatchDataCache {
    private static final MatchDataCache INSTANCE = new MatchDataCache();
    private static final ConcurrentMap<String, Map<String, SelectorData>> SELECTOR_DATA_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, Map<String, RuleData>> RULE_DATA_MAP = Maps.newConcurrentMap();

    private MatchDataCache() {
    }

    public static MatchDataCache getInstance() {
        return INSTANCE;
    }

    public void removeSelectorData(String pluginName) {
        SELECTOR_DATA_MAP.remove(pluginName);
    }

    public void removeSelectorData(String pluginName, String selectorId) {
        Map pathSelectorCache = (Map)SELECTOR_DATA_MAP.get(pluginName);
        if (Objects.isNull(pathSelectorCache) || pathSelectorCache.isEmpty()) {
            return;
        }
        pathSelectorCache.entrySet().removeIf(entry -> selectorId.equals(((SelectorData)entry.getValue()).getId()));
    }

    public void removeEmptySelectorData(String pluginName) {
        Map pathSelectorCache = (Map)SELECTOR_DATA_MAP.get(pluginName);
        if (Objects.isNull(pathSelectorCache) || pathSelectorCache.isEmpty()) {
            return;
        }
        pathSelectorCache.entrySet().removeIf(entry -> Objects.isNull(((SelectorData)entry.getValue()).getId()));
    }

    public void cleanSelectorData() {
        SELECTOR_DATA_MAP.clear();
    }

    public void cacheSelectorData(String path, SelectorData selectorData, int initialCapacity, long maximumSize) {
        ((Map)MapUtils.computeIfAbsent(SELECTOR_DATA_MAP, (Object)selectorData.getPluginName(), map -> new WindowTinyLFUMap(initialCapacity, maximumSize, Boolean.FALSE))).put(path, selectorData);
    }

    public SelectorData obtainSelectorData(String pluginName, String path) {
        Map lruMap = (Map)SELECTOR_DATA_MAP.get(pluginName);
        return (SelectorData)Optional.ofNullable(lruMap).orElse(Maps.newHashMap()).get(path);
    }

    public void cacheRuleData(String path, RuleData ruleData, int initialCapacity, long maximumSize) {
        ((Map)MapUtils.computeIfAbsent(RULE_DATA_MAP, (Object)ruleData.getPluginName(), map -> new WindowTinyLFUMap(initialCapacity, maximumSize, Boolean.FALSE))).put(path, ruleData);
    }

    public void removeRuleData(String pluginName) {
        RULE_DATA_MAP.remove(pluginName);
    }

    public void removeRuleData(String pluginName, String ruleId) {
        Map pathRuleDataCache = (Map)RULE_DATA_MAP.get(pluginName);
        if (Objects.isNull(pathRuleDataCache) || pathRuleDataCache.isEmpty()) {
            return;
        }
        pathRuleDataCache.entrySet().removeIf(entry -> ruleId.equals(((RuleData)entry.getValue()).getId()));
    }

    public void removeRuleDataBySelector(String pluginName, String selectorId) {
        Map pathRuleDataCache = (Map)RULE_DATA_MAP.get(pluginName);
        if (Objects.isNull(pathRuleDataCache) || pathRuleDataCache.isEmpty()) {
            return;
        }
        pathRuleDataCache.entrySet().removeIf(entry -> selectorId.equals(((RuleData)entry.getValue()).getSelectorId()));
    }

    public void removeEmptyRuleData(String pluginName) {
        Map pathRuleDataCache = (Map)RULE_DATA_MAP.get(pluginName);
        if (Objects.isNull(pathRuleDataCache) || pathRuleDataCache.isEmpty()) {
            return;
        }
        pathRuleDataCache.entrySet().removeIf(entry -> Objects.isNull(((RuleData)entry.getValue()).getId()));
    }

    public void cleanRuleDataData() {
        RULE_DATA_MAP.clear();
    }

    public RuleData obtainRuleData(String pluginName, String path) {
        Map lruMap = (Map)RULE_DATA_MAP.get(pluginName);
        return (RuleData)Optional.ofNullable(lruMap).orElse(Maps.newHashMap()).get(path);
    }

    public ConcurrentMap<String, Map<String, SelectorData>> getSelectorMatchCache() {
        return SELECTOR_DATA_MAP;
    }

    public ConcurrentMap<String, Map<String, RuleData>> getRuleMatchCache() {
        return RULE_DATA_MAP;
    }
}

