/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.controller.BrokerHeartbeatManager;
import org.apache.rocketmq.controller.ControllerManager;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.CleanControllerBrokerDataRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.RegisterBrokerToControllerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.RegisterBrokerToControllerResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.namesrv.BrokerHeartbeatRequestHeader;

public class ControllerRequestProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private static final int WAIT_TIMEOUT_OUT = 5;
    private final ControllerManager controllerManager;
    private final BrokerHeartbeatManager heartbeatManager;

    public ControllerRequestProcessor(ControllerManager controllerManager) {
        this.controllerManager = controllerManager;
        this.heartbeatManager = controllerManager.getHeartbeatManager();
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        if (ctx != null) {
            log.debug("Receive request, {} {} {}", new Object[]{request.getCode(), RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), request});
        }
        switch (request.getCode()) {
            case 1001: {
                AlterSyncStateSetRequestHeader controllerRequest = (AlterSyncStateSetRequestHeader)request.decodeCommandCustomHeader(AlterSyncStateSetRequestHeader.class);
                SyncStateSet syncStateSet = (SyncStateSet)RemotingSerializable.decode((byte[])request.getBody(), SyncStateSet.class);
                CompletableFuture<RemotingCommand> future = this.controllerManager.getController().alterSyncStateSet(controllerRequest, syncStateSet);
                if (future == null) break;
                return future.get(5L, TimeUnit.SECONDS);
            }
            case 1002: {
                ElectMasterRequestHeader electMasterRequest = (ElectMasterRequestHeader)request.decodeCommandCustomHeader(ElectMasterRequestHeader.class);
                CompletableFuture<RemotingCommand> future = this.controllerManager.getController().electMaster(electMasterRequest);
                if (future == null) break;
                RemotingCommand response = future.get(5L, TimeUnit.SECONDS);
                ElectMasterResponseHeader responseHeader = (ElectMasterResponseHeader)response.readCustomHeader();
                if (null != responseHeader && this.controllerManager.getControllerConfig().isNotifyBrokerRoleChanged()) {
                    this.controllerManager.notifyBrokerRoleChanged(responseHeader, electMasterRequest.getClusterName());
                }
                return response;
            }
            case 1003: {
                RegisterBrokerToControllerRequestHeader controllerRequest = (RegisterBrokerToControllerRequestHeader)request.decodeCommandCustomHeader(RegisterBrokerToControllerRequestHeader.class);
                CompletableFuture<RemotingCommand> future = this.controllerManager.getController().registerBroker(controllerRequest);
                if (future == null) break;
                RemotingCommand response = future.get(5L, TimeUnit.SECONDS);
                RegisterBrokerToControllerResponseHeader responseHeader = (RegisterBrokerToControllerResponseHeader)response.readCustomHeader();
                if (responseHeader != null && responseHeader.getBrokerId() >= 0L) {
                    this.heartbeatManager.onBrokerHeartbeat(controllerRequest.getClusterName(), controllerRequest.getBrokerName(), controllerRequest.getBrokerAddress(), responseHeader.getBrokerId(), controllerRequest.getHeartbeatTimeoutMillis(), ctx.channel(), controllerRequest.getEpoch(), controllerRequest.getMaxOffset(), controllerRequest.getConfirmOffset(), controllerRequest.getElectionPriority());
                }
                return response;
            }
            case 1004: {
                GetReplicaInfoRequestHeader controllerRequest = (GetReplicaInfoRequestHeader)request.decodeCommandCustomHeader(GetReplicaInfoRequestHeader.class);
                CompletableFuture<RemotingCommand> future = this.controllerManager.getController().getReplicaInfo(controllerRequest);
                if (future == null) break;
                return future.get(5L, TimeUnit.SECONDS);
            }
            case 1005: {
                return this.controllerManager.getController().getControllerMetadata();
            }
            case 904: {
                BrokerHeartbeatRequestHeader requestHeader = (BrokerHeartbeatRequestHeader)request.decodeCommandCustomHeader(BrokerHeartbeatRequestHeader.class);
                this.heartbeatManager.onBrokerHeartbeat(requestHeader.getClusterName(), requestHeader.getBrokerName(), requestHeader.getBrokerAddr(), requestHeader.getBrokerId(), requestHeader.getHeartbeatTimeoutMills(), ctx.channel(), requestHeader.getEpoch(), requestHeader.getMaxOffset(), requestHeader.getConfirmOffset(), requestHeader.getElectionPriority());
                return RemotingCommand.createResponseCommand((int)0, (String)"Heart beat success");
            }
            case 1006: {
                CompletableFuture<RemotingCommand> future;
                List brokerNames;
                if (request.getBody() == null || (brokerNames = (List)RemotingSerializable.decode((byte[])request.getBody(), List.class)) == null || brokerNames.size() <= 0 || (future = this.controllerManager.getController().getSyncStateData(brokerNames)) == null) break;
                return future.get(5L, TimeUnit.SECONDS);
            }
            case 1009: {
                return this.updateControllerConfig(ctx, request);
            }
            case 1010: {
                return this.getControllerConfig(ctx, request);
            }
            case 1011: {
                CleanControllerBrokerDataRequestHeader requestHeader = (CleanControllerBrokerDataRequestHeader)request.decodeCommandCustomHeader(CleanControllerBrokerDataRequestHeader.class);
                CompletableFuture<RemotingCommand> future = this.controllerManager.getController().cleanBrokerData(requestHeader);
                if (null == future) break;
                return future.get(5L, TimeUnit.SECONDS);
            }
            default: {
                String error = " request type " + request.getCode() + " not supported";
                return RemotingCommand.createResponseCommand((int)3, (String)error);
            }
        }
        return RemotingCommand.createResponseCommand(null);
    }

    public boolean rejectRequest() {
        return false;
    }

    private RemotingCommand updateControllerConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        if (ctx != null) {
            log.info("updateConfig called by {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        }
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        byte[] body = request.getBody();
        if (body != null) {
            String bodyStr;
            try {
                bodyStr = new String(body, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("updateConfig byte array to string error: ", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
            Properties properties = MixAll.string2Properties((String)bodyStr);
            if (properties == null) {
                log.error("updateConfig MixAll.string2Properties error {}", (Object)bodyStr);
                response.setCode(1);
                response.setRemark("string2Properties error");
                return response;
            }
            this.controllerManager.getConfiguration().update(properties);
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand getControllerConfig(ChannelHandlerContext ctx, RemotingCommand request) {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        String content = this.controllerManager.getConfiguration().getAllConfigsFormatString();
        if (content != null && content.length() > 0) {
            try {
                response.setBody(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("getConfig error, ", (Throwable)e);
                response.setCode(1);
                response.setRemark("UnsupportedEncodingException " + e);
                return response;
            }
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }
}

