/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.mqclient;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.rocketmq.broker.client.ProducerManager;
import org.apache.rocketmq.client.impl.ClientRemotingProcessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.CheckTransactionStateRequestHeader;

public class ProxyClientRemotingProcessor
extends ClientRemotingProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final ProducerManager producerManager;

    public ProxyClientRemotingProcessor(ProducerManager producerManager) {
        super(null);
        this.producerManager = producerManager;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        if (request.getCode() == 39) {
            return this.checkTransactionState(ctx, request);
        }
        return null;
    }

    public RemotingCommand checkTransactionState(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        String group;
        ByteBuffer byteBuffer = ByteBuffer.wrap(request.getBody());
        MessageExt messageExt = MessageDecoder.decode((ByteBuffer)byteBuffer, (boolean)true, (boolean)false, (boolean)false);
        if (messageExt != null && (group = messageExt.getProperty("PGROUP")) != null) {
            CheckTransactionStateRequestHeader requestHeader = (CheckTransactionStateRequestHeader)request.decodeCommandCustomHeader(CheckTransactionStateRequestHeader.class);
            request.writeCustomHeader((CommandCustomHeader)requestHeader);
            request.addExtField("brokerAddr", NetworkUtil.socketAddress2String((SocketAddress)ctx.channel().remoteAddress()));
            Channel channel = this.producerManager.getAvailableChannel(group);
            if (channel != null) {
                channel.writeAndFlush((Object)request);
            } else {
                log.warn("check transaction failed, channel is empty. groupId={}, requestHeader:{}", (Object)group, (Object)requestHeader);
            }
        }
        return null;
    }
}

