/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.plain;

import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.EndTransactionRequest;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest;
import apache.rocketmq.v2.HeartbeatRequest;
import apache.rocketmq.v2.Message;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.SendMessageRequest;
import apache.rocketmq.v2.Subscription;
import apache.rocketmq.v2.SubscriptionEntry;
import apache.rocketmq.v2.TelemetryCommand;
import com.google.protobuf.GeneratedMessageV3;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.rocketmq.acl.AccessResource;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.acl.common.AuthenticationHeader;
import org.apache.rocketmq.acl.common.AuthorizationHeader;
import org.apache.rocketmq.acl.common.Permission;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategy;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.PlainAccessConfig;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerListByGroupRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.UnregisterClientRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumerData;
import org.apache.rocketmq.remoting.protocol.heartbeat.HeartbeatData;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class PlainAccessResource
implements AccessResource {
    private String accessKey;
    private String secretKey;
    private String whiteRemoteAddress;
    private boolean admin;
    private byte defaultTopicPerm = 1;
    private byte defaultGroupPerm = 1;
    private Map<String, Byte> resourcePermMap;
    private RemoteAddressStrategy remoteAddressStrategy;
    private int requestCode;
    private byte[] content;
    private String signature;
    private String secretToken;
    private String recognition;

    public static PlainAccessResource parse(RemotingCommand request, String remoteAddr) {
        PlainAccessResource accessResource = new PlainAccessResource();
        if (remoteAddr != null && remoteAddr.contains(":")) {
            accessResource.setWhiteRemoteAddress(remoteAddr.substring(0, remoteAddr.lastIndexOf(58)));
        } else {
            accessResource.setWhiteRemoteAddress(remoteAddr);
        }
        accessResource.setRequestCode(request.getCode());
        if (request.getExtFields() == null) {
            return accessResource;
        }
        accessResource.setAccessKey((String)request.getExtFields().get("AccessKey"));
        accessResource.setSignature((String)request.getExtFields().get("Signature"));
        accessResource.setSecretToken((String)request.getExtFields().get("SecurityToken"));
        try {
            switch (request.getCode()) {
                case 10: {
                    String topic = (String)request.getExtFields().get("topic");
                    if (PlainAccessResource.isRetryTopic(topic)) {
                        accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic((String)request.getExtFields().get("group")), (byte)8);
                        break;
                    }
                    accessResource.addResourceAndPerm(topic, (byte)4);
                    break;
                }
                case 310: 
                case 320: {
                    String topicV2 = (String)request.getExtFields().get("b");
                    if (PlainAccessResource.isRetryTopic(topicV2)) {
                        accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic((String)request.getExtFields().get("a")), (byte)8);
                        break;
                    }
                    accessResource.addResourceAndPerm(topicV2, (byte)4);
                    break;
                }
                case 36: {
                    accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic((String)request.getExtFields().get("group")), (byte)8);
                    break;
                }
                case 11: {
                    accessResource.addResourceAndPerm((String)request.getExtFields().get("topic"), (byte)8);
                    accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic((String)request.getExtFields().get("consumerGroup")), (byte)8);
                    break;
                }
                case 12: {
                    accessResource.addResourceAndPerm((String)request.getExtFields().get("topic"), (byte)8);
                    break;
                }
                case 34: {
                    HeartbeatData heartbeatData = (HeartbeatData)HeartbeatData.decode((byte[])request.getBody(), HeartbeatData.class);
                    for (ConsumerData data : heartbeatData.getConsumerDataSet()) {
                        accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic(data.getGroupName()), (byte)8);
                        for (SubscriptionData subscriptionData : data.getSubscriptionDataSet()) {
                            accessResource.addResourceAndPerm(subscriptionData.getTopic(), (byte)8);
                        }
                    }
                    break;
                }
                case 35: {
                    UnregisterClientRequestHeader unregisterClientRequestHeader = (UnregisterClientRequestHeader)request.decodeCommandCustomHeader(UnregisterClientRequestHeader.class);
                    accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic(unregisterClientRequestHeader.getConsumerGroup()), (byte)8);
                    break;
                }
                case 38: {
                    GetConsumerListByGroupRequestHeader getConsumerListByGroupRequestHeader = (GetConsumerListByGroupRequestHeader)request.decodeCommandCustomHeader(GetConsumerListByGroupRequestHeader.class);
                    accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic(getConsumerListByGroupRequestHeader.getConsumerGroup()), (byte)8);
                    break;
                }
                case 15: {
                    UpdateConsumerOffsetRequestHeader updateConsumerOffsetRequestHeader = (UpdateConsumerOffsetRequestHeader)request.decodeCommandCustomHeader(UpdateConsumerOffsetRequestHeader.class);
                    accessResource.addResourceAndPerm(PlainAccessResource.getRetryTopic(updateConsumerOffsetRequestHeader.getConsumerGroup()), (byte)8);
                    accessResource.addResourceAndPerm(updateConsumerOffsetRequestHeader.getTopic(), (byte)8);
                    break;
                }
            }
        }
        catch (Throwable t) {
            throw new AclException(t.getMessage(), t);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Map.Entry entry : request.getExtFields().entrySet()) {
            if (request.getVersion() <= MQVersion.Version.V4_9_3.ordinal() && "_UNIQUE_KEY_QUERY".equals(entry.getKey()) || "Signature".equals(entry.getKey())) continue;
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        accessResource.setContent(AclUtils.combineRequestContent(request, map));
        return accessResource;
    }

    public static PlainAccessResource parse(GeneratedMessageV3 messageV3, AuthenticationHeader header) {
        PlainAccessResource accessResource = new PlainAccessResource();
        String remoteAddress = header.getRemoteAddress();
        if (remoteAddress != null && remoteAddress.contains(":")) {
            accessResource.setWhiteRemoteAddress(RemotingHelper.parseHostFromAddress((String)remoteAddress));
        } else {
            accessResource.setWhiteRemoteAddress(remoteAddress);
        }
        try {
            AuthorizationHeader authorizationHeader = new AuthorizationHeader(header.getAuthorization());
            accessResource.setAccessKey(authorizationHeader.getAccessKey());
            accessResource.setSignature(authorizationHeader.getSignature());
        }
        catch (DecoderException e) {
            throw new AclException(e.getMessage(), e);
        }
        accessResource.setSecretToken(header.getSessionToken());
        accessResource.setRequestCode(header.getRequestCode());
        accessResource.setContent(header.getDatetime().getBytes(StandardCharsets.UTF_8));
        try {
            TelemetryCommand command;
            String rpcFullName = messageV3.getDescriptorForType().getFullName();
            if (HeartbeatRequest.getDescriptor().getFullName().equals(rpcFullName)) {
                HeartbeatRequest request = (HeartbeatRequest)messageV3;
                if (request.hasGroup()) {
                    accessResource.addResourceAndPerm(request.getGroup(), (byte)8);
                }
            } else if (SendMessageRequest.getDescriptor().getFullName().equals(rpcFullName)) {
                SendMessageRequest request = (SendMessageRequest)messageV3;
                if (request.getMessagesCount() <= 0) {
                    throw new AclException("SendMessageRequest, messageCount is zero", 13);
                }
                Resource topic = request.getMessages(0).getTopic();
                for (Message message : request.getMessagesList()) {
                    if (message.getTopic().equals((Object)topic)) continue;
                    throw new AclException("SendMessageRequest, messages' topic is not consistent", 13);
                }
                accessResource.addResourceAndPerm(topic, (byte)4);
            } else if (ReceiveMessageRequest.getDescriptor().getFullName().equals(rpcFullName)) {
                ReceiveMessageRequest request = (ReceiveMessageRequest)messageV3;
                accessResource.addResourceAndPerm(request.getGroup(), (byte)8);
                accessResource.addResourceAndPerm(request.getMessageQueue().getTopic(), (byte)8);
            } else if (AckMessageRequest.getDescriptor().getFullName().equals(rpcFullName)) {
                AckMessageRequest request = (AckMessageRequest)messageV3;
                accessResource.addResourceAndPerm(request.getGroup(), (byte)8);
                accessResource.addResourceAndPerm(request.getTopic(), (byte)8);
            } else if (ForwardMessageToDeadLetterQueueRequest.getDescriptor().getFullName().equals(rpcFullName)) {
                ForwardMessageToDeadLetterQueueRequest request = (ForwardMessageToDeadLetterQueueRequest)messageV3;
                accessResource.addResourceAndPerm(request.getGroup(), (byte)8);
                accessResource.addResourceAndPerm(request.getTopic(), (byte)8);
            } else if (EndTransactionRequest.getDescriptor().getFullName().equals(rpcFullName)) {
                EndTransactionRequest request = (EndTransactionRequest)messageV3;
                accessResource.addResourceAndPerm(request.getTopic(), (byte)4);
            } else if (TelemetryCommand.getDescriptor().getFullName().equals(rpcFullName) && (command = (TelemetryCommand)messageV3).getCommandCase() == TelemetryCommand.CommandCase.SETTINGS) {
                if (command.getSettings().hasPublishing()) {
                    List topicList = command.getSettings().getPublishing().getTopicsList();
                    for (Resource topic : topicList) {
                        accessResource.addResourceAndPerm(topic, (byte)4);
                    }
                }
                if (command.getSettings().hasSubscription()) {
                    Subscription subscription = command.getSettings().getSubscription();
                    accessResource.addResourceAndPerm(subscription.getGroup(), (byte)8);
                    for (SubscriptionEntry entry : subscription.getSubscriptionsList()) {
                        accessResource.addResourceAndPerm(entry.getTopic(), (byte)8);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new AclException(t.getMessage(), t);
        }
        return accessResource;
    }

    private void addResourceAndPerm(Resource resource, byte permission) {
        String resourceName = NamespaceUtil.wrapNamespace((String)resource.getResourceNamespace(), (String)resource.getName());
        this.addResourceAndPerm(resourceName, permission);
    }

    public static PlainAccessResource build(PlainAccessConfig plainAccessConfig, RemoteAddressStrategy remoteAddressStrategy) {
        PlainAccessResource plainAccessResource = new PlainAccessResource();
        plainAccessResource.setAccessKey(plainAccessConfig.getAccessKey());
        plainAccessResource.setSecretKey(plainAccessConfig.getSecretKey());
        plainAccessResource.setWhiteRemoteAddress(plainAccessConfig.getWhiteRemoteAddress());
        plainAccessResource.setAdmin(plainAccessConfig.isAdmin());
        plainAccessResource.setDefaultGroupPerm(Permission.parsePermFromString(plainAccessConfig.getDefaultGroupPerm()));
        plainAccessResource.setDefaultTopicPerm(Permission.parsePermFromString(plainAccessConfig.getDefaultTopicPerm()));
        Permission.parseResourcePerms(plainAccessResource, false, plainAccessConfig.getGroupPerms());
        Permission.parseResourcePerms(plainAccessResource, true, plainAccessConfig.getTopicPerms());
        plainAccessResource.setRemoteAddressStrategy(remoteAddressStrategy);
        return plainAccessResource;
    }

    public static boolean isRetryTopic(String topic) {
        return null != topic && topic.startsWith("%RETRY%");
    }

    public static String printStr(String resource, boolean isGroup) {
        if (resource == null) {
            return null;
        }
        if (isGroup) {
            return String.format("%s:%s", "group", PlainAccessResource.getGroupFromRetryTopic(resource));
        }
        return String.format("%s:%s", "topic", resource);
    }

    public static String getGroupFromRetryTopic(String retryTopic) {
        if (retryTopic == null) {
            return null;
        }
        return retryTopic.substring("%RETRY%".length());
    }

    public static String getRetryTopic(String group) {
        if (group == null) {
            return null;
        }
        return MixAll.getRetryTopic((String)group);
    }

    public void addResourceAndPerm(String resource, byte perm) {
        if (resource == null) {
            return;
        }
        if (this.resourcePermMap == null) {
            this.resourcePermMap = new HashMap<String, Byte>();
        }
        this.resourcePermMap.put(resource, perm);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getWhiteRemoteAddress() {
        return this.whiteRemoteAddress;
    }

    public void setWhiteRemoteAddress(String whiteRemoteAddress) {
        this.whiteRemoteAddress = whiteRemoteAddress;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public byte getDefaultTopicPerm() {
        return this.defaultTopicPerm;
    }

    public void setDefaultTopicPerm(byte defaultTopicPerm) {
        this.defaultTopicPerm = defaultTopicPerm;
    }

    public byte getDefaultGroupPerm() {
        return this.defaultGroupPerm;
    }

    public void setDefaultGroupPerm(byte defaultGroupPerm) {
        this.defaultGroupPerm = defaultGroupPerm;
    }

    public Map<String, Byte> getResourcePermMap() {
        return this.resourcePermMap;
    }

    public String getRecognition() {
        return this.recognition;
    }

    public void setRecognition(String recognition) {
        this.recognition = recognition;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public void setRequestCode(int requestCode) {
        this.requestCode = requestCode;
    }

    public String getSecretToken() {
        return this.secretToken;
    }

    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    public RemoteAddressStrategy getRemoteAddressStrategy() {
        return this.remoteAddressStrategy;
    }

    public void setRemoteAddressStrategy(RemoteAddressStrategy remoteAddressStrategy) {
        this.remoteAddressStrategy = remoteAddressStrategy;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }
}

