/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.alibaba.fastjson.JSON;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.api.common.Attributes;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.filter.ConsumerFilterData;
import org.apache.rocketmq.broker.filter.ConsumerFilterManager;
import org.apache.rocketmq.broker.filter.ExpressionMessageFilter;
import org.apache.rocketmq.broker.longpolling.PopRequest;
import org.apache.rocketmq.broker.metrics.BrokerMetricsManager;
import org.apache.rocketmq.broker.pagecache.ManyMessageTransfer;
import org.apache.rocketmq.broker.processor.PopBufferMergeService;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.PopAckConstants;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.filter.ExpressionType;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.metrics.RemotingMetricsManager;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.RequestTask;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.filter.FilterAPI;
import org.apache.rocketmq.remoting.protocol.header.ExtraInfoUtil;
import org.apache.rocketmq.remoting.protocol.header.PopMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.PopMessageResponseHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.pop.AckMsg;
import org.apache.rocketmq.store.pop.PopCheckPoint;

public class PopMessageProcessor
implements NettyRequestProcessor {
    private static final Logger POP_LOGGER = LoggerFactory.getLogger((String)"RocketmqPop");
    private final BrokerController brokerController;
    private final Random random = new Random(System.currentTimeMillis());
    String reviveTopic;
    private static final String BORN_TIME = "bornTime";
    private static final int POLLING_SUC = 0;
    private static final int POLLING_FULL = 1;
    private static final int POLLING_TIMEOUT = 2;
    private static final int NOT_POLLING = 3;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, Byte>> topicCidMap;
    private ConcurrentLinkedHashMap<String, ConcurrentSkipListSet<PopRequest>> pollingMap;
    private AtomicLong totalPollingNum = new AtomicLong(0L);
    private PopLongPollingService popLongPollingService;
    private PopBufferMergeService popBufferMergeService;
    private QueueLockManager queueLockManager;
    private AtomicLong ckMessageNumber;

    public PopMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.reviveTopic = PopAckConstants.buildClusterReviveTopic((String)this.brokerController.getBrokerConfig().getBrokerClusterName());
        this.topicCidMap = new ConcurrentHashMap(this.brokerController.getBrokerConfig().getPopPollingMapSize());
        this.pollingMap = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)this.brokerController.getBrokerConfig().getPopPollingMapSize()).build();
        this.popLongPollingService = new PopLongPollingService();
        this.queueLockManager = new QueueLockManager();
        this.popBufferMergeService = new PopBufferMergeService(this.brokerController, this);
        this.ckMessageNumber = new AtomicLong();
    }

    public PopLongPollingService getPopLongPollingService() {
        return this.popLongPollingService;
    }

    public PopBufferMergeService getPopBufferMergeService() {
        return this.popBufferMergeService;
    }

    public QueueLockManager getQueueLockManager() {
        return this.queueLockManager;
    }

    public static String genAckUniqueId(AckMsg ackMsg) {
        return ackMsg.getTopic() + "@" + ackMsg.getQueueId() + "@" + ackMsg.getAckOffset() + "@" + ackMsg.getConsumerGroup() + "@" + ackMsg.getPopTime() + "@" + ackMsg.getBrokerName() + "@" + "ack";
    }

    public static String genCkUniqueId(PopCheckPoint ck) {
        return ck.getTopic() + "@" + ck.getQueueId() + "@" + ck.getStartOffset() + "@" + ck.getCId() + "@" + ck.getPopTime() + "@" + ck.getBrokerName() + "@" + "ck";
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        request.addExtField(BORN_TIME, String.valueOf(System.currentTimeMillis()));
        return this.processRequest(ctx.channel(), request);
    }

    public boolean rejectRequest() {
        return false;
    }

    public ConcurrentLinkedHashMap<String, ConcurrentSkipListSet<PopRequest>> getPollingMap() {
        return this.pollingMap;
    }

    public void notifyLongPollingRequestIfNeed(String topic, String group, int queueId) {
        long offset;
        long popBufferOffset = this.brokerController.getPopMessageProcessor().getPopBufferMergeService().getLatestOffset(topic, group, queueId);
        long consumerOffset = this.brokerController.getConsumerOffsetManager().queryOffset(group, topic, queueId);
        long maxOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId);
        if (maxOffset > (offset = Math.max(popBufferOffset, consumerOffset))) {
            boolean notifySuccess = this.brokerController.getPopMessageProcessor().notifyMessageArriving(topic, group, -1);
            if (!notifySuccess) {
                notifySuccess = this.brokerController.getPopMessageProcessor().notifyMessageArriving(topic, group, queueId);
            }
            this.brokerController.getNotificationProcessor().notifyMessageArriving(topic, queueId);
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.info("notify long polling request. topic:{}, group:{}, queueId:{}, success:{}", new Object[]{topic, group, queueId, notifySuccess});
            }
        }
    }

    public void notifyMessageArriving(String topic, int queueId) {
        ConcurrentHashMap<String, Byte> cids = this.topicCidMap.get(topic);
        if (cids == null) {
            return;
        }
        for (Map.Entry<String, Byte> cid : cids.entrySet()) {
            if (queueId >= 0) {
                this.notifyMessageArriving(topic, cid.getKey(), -1);
            }
            this.notifyMessageArriving(topic, cid.getKey(), queueId);
        }
    }

    public boolean notifyMessageArriving(String topic, String cid, int queueId) {
        ConcurrentSkipListSet remotingCommands = (ConcurrentSkipListSet)this.pollingMap.get((Object)KeyBuilder.buildPollingKey((String)topic, (String)cid, (int)queueId));
        if (remotingCommands == null || remotingCommands.isEmpty()) {
            return false;
        }
        PopRequest popRequest = (PopRequest)remotingCommands.pollFirst();
        while (popRequest != null && !popRequest.getChannel().isActive()) {
            this.totalPollingNum.decrementAndGet();
            popRequest = (PopRequest)remotingCommands.pollFirst();
        }
        if (popRequest == null) {
            return false;
        }
        this.totalPollingNum.decrementAndGet();
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("lock release , new msg arrive , wakeUp : {}", (Object)popRequest);
        }
        return this.wakeUp(popRequest);
    }

    private boolean wakeUp(PopRequest request) {
        if (request == null || !request.complete()) {
            return false;
        }
        if (!request.getChannel().isActive()) {
            return false;
        }
        Runnable run = () -> {
            try {
                RemotingCommand response = this.processRequest(request.getChannel(), request.getRemotingCommand());
                if (response != null) {
                    response.setOpaque(request.getRemotingCommand().getOpaque());
                    response.markResponseType();
                    NettyRemotingAbstract.writeResponse((Channel)request.getChannel(), (RemotingCommand)request.getRemotingCommand(), (RemotingCommand)response, future -> {
                        if (!future.isSuccess()) {
                            POP_LOGGER.error("ProcessRequestWrapper response to {} failed", (Object)request.getChannel().remoteAddress(), (Object)future.cause());
                            POP_LOGGER.error(request.toString());
                            POP_LOGGER.error(response.toString());
                        }
                    });
                }
            }
            catch (RemotingCommandException e1) {
                POP_LOGGER.error("ExecuteRequestWhenWakeup run", (Throwable)e1);
            }
        };
        this.brokerController.getPullMessageExecutor().submit((Runnable)new RequestTask(run, request.getChannel(), request.getRemotingCommand()));
        return true;
    }

    private RemotingCommand processRequest(Channel channel, RemotingCommand request) throws RemotingCommandException {
        int queueId;
        int i;
        TopicConfig retryTopicConfig;
        SubscriptionData retrySubscriptionData;
        String retryTopic;
        SubscriptionData subscriptionData;
        RemotingCommand response = RemotingCommand.createResponseCommand(PopMessageResponseHeader.class);
        PopMessageResponseHeader responseHeader = (PopMessageResponseHeader)response.readCustomHeader();
        PopMessageRequestHeader requestHeader = (PopMessageRequestHeader)request.decodeCommandCustomHeader(PopMessageRequestHeader.class);
        StringBuilder startOffsetInfo = new StringBuilder(64);
        StringBuilder msgOffsetInfo = new StringBuilder(64);
        StringBuilder orderCountInfo = null;
        if (requestHeader.isOrder()) {
            orderCountInfo = new StringBuilder(64);
        }
        this.brokerController.getConsumerManager().compensateBasicConsumerInfo(requestHeader.getConsumerGroup(), ConsumeType.CONSUME_POP, MessageModel.CLUSTERING);
        response.setOpaque(request.getOpaque());
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("receive PopMessage request command, {}", (Object)request);
        }
        if (requestHeader.isTimeoutTooMuch()) {
            response.setCode(210);
            response.setRemark(String.format("the broker[%s] poping message is timeout too much", this.brokerController.getBrokerConfig().getBrokerIP1()));
            return response;
        }
        if (!PermName.isReadable((int)this.brokerController.getBrokerConfig().getBrokerPermission())) {
            response.setCode(16);
            response.setRemark(String.format("the broker[%s] poping message is forbidden", this.brokerController.getBrokerConfig().getBrokerIP1()));
            return response;
        }
        if (requestHeader.getMaxMsgNums() > 32) {
            response.setCode(1);
            response.setRemark(String.format("the broker[%s] poping message's num is greater than 32", this.brokerController.getBrokerConfig().getBrokerIP1()));
            return response;
        }
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (null == topicConfig) {
            POP_LOGGER.error("The topic {} not exist, consumer: {} ", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
            response.setCode(17);
            response.setRemark(String.format("topic[%s] not exist, apply first please! %s", requestHeader.getTopic(), FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ")));
            return response;
        }
        if (!PermName.isReadable((int)topicConfig.getPerm())) {
            response.setCode(16);
            response.setRemark("the topic[" + requestHeader.getTopic() + "] peeking message is forbidden");
            return response;
        }
        if (requestHeader.getQueueId() >= topicConfig.getReadQueueNums()) {
            String errorInfo = String.format("queueId[%d] is illegal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress());
            POP_LOGGER.warn(errorInfo);
            response.setCode(1);
            response.setRemark(errorInfo);
            return response;
        }
        SubscriptionGroupConfig subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(requestHeader.getConsumerGroup());
        if (null == subscriptionGroupConfig) {
            response.setCode(26);
            response.setRemark(String.format("subscription group [%s] does not exist, %s", requestHeader.getConsumerGroup(), FAQUrl.suggestTodo((String)"https://rocketmq.apache.org/docs/bestPractice/06FAQ")));
            return response;
        }
        if (!subscriptionGroupConfig.isConsumeEnable()) {
            response.setCode(16);
            response.setRemark("subscription group no permission, " + requestHeader.getConsumerGroup());
            return response;
        }
        ExpressionMessageFilter messageFilter = null;
        if (requestHeader.getExp() != null && requestHeader.getExp().length() > 0) {
            try {
                subscriptionData = FilterAPI.build((String)requestHeader.getTopic(), (String)requestHeader.getExp(), (String)requestHeader.getExpType());
                this.brokerController.getConsumerManager().compensateSubscribeData(requestHeader.getConsumerGroup(), requestHeader.getTopic(), subscriptionData);
                retryTopic = KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup());
                retrySubscriptionData = FilterAPI.build((String)retryTopic, (String)"*", (String)requestHeader.getExpType());
                this.brokerController.getConsumerManager().compensateSubscribeData(requestHeader.getConsumerGroup(), retryTopic, retrySubscriptionData);
                ConsumerFilterData consumerFilterData = null;
                if (!ExpressionType.isTagType((String)subscriptionData.getExpressionType()) && (consumerFilterData = ConsumerFilterManager.build(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getExp(), requestHeader.getExpType(), System.currentTimeMillis())) == null) {
                    POP_LOGGER.warn("Parse the consumer's subscription[{}] failed, group: {}", (Object)requestHeader.getExp(), (Object)requestHeader.getConsumerGroup());
                    response.setCode(23);
                    response.setRemark("parse the consumer's subscription failed");
                    return response;
                }
                messageFilter = new ExpressionMessageFilter(subscriptionData, consumerFilterData, this.brokerController.getConsumerFilterManager());
            }
            catch (Exception e) {
                POP_LOGGER.warn("Parse the consumer's subscription[{}] error, group: {}", (Object)requestHeader.getExp(), (Object)requestHeader.getConsumerGroup());
                response.setCode(23);
                response.setRemark("parse the consumer's subscription failed");
                return response;
            }
        }
        try {
            subscriptionData = FilterAPI.build((String)requestHeader.getTopic(), (String)"*", (String)"TAG");
            this.brokerController.getConsumerManager().compensateSubscribeData(requestHeader.getConsumerGroup(), requestHeader.getTopic(), subscriptionData);
            retryTopic = KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup());
            retrySubscriptionData = FilterAPI.build((String)retryTopic, (String)"*", (String)"TAG");
            this.brokerController.getConsumerManager().compensateSubscribeData(requestHeader.getConsumerGroup(), retryTopic, retrySubscriptionData);
        }
        catch (Exception e) {
            POP_LOGGER.warn("Build default subscription error, group: {}", (Object)requestHeader.getConsumerGroup());
        }
        int randomQ = this.random.nextInt(100);
        int reviveQid = requestHeader.isOrder() ? 999 : (int)Math.abs(this.ckMessageNumber.getAndIncrement() % (long)this.brokerController.getBrokerConfig().getReviveQueueNum());
        int commercialSizePerMsg = this.brokerController.getBrokerConfig().getCommercialSizePerMsg();
        GetMessageResult getMessageResult = new GetMessageResult(commercialSizePerMsg);
        ExpressionMessageFilter finalMessageFilter = messageFilter;
        StringBuilder finalOrderCountInfo = orderCountInfo;
        boolean needRetry = randomQ % 5 == 0;
        long popTime = System.currentTimeMillis();
        CompletionStage<Long> getMessageFuture = CompletableFuture.completedFuture(0L);
        if (needRetry && !requestHeader.isOrder() && (retryTopicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup()))) != null) {
            for (i = 0; i < retryTopicConfig.getReadQueueNums(); ++i) {
                queueId = (randomQ + i) % retryTopicConfig.getReadQueueNums();
                getMessageFuture = ((CompletableFuture)getMessageFuture).thenCompose(restNum -> this.popMsgFromQueue(true, getMessageResult, requestHeader, queueId, (long)restNum, reviveQid, channel, popTime, finalMessageFilter, startOffsetInfo, msgOffsetInfo, finalOrderCountInfo));
            }
        }
        if (requestHeader.getQueueId() < 0) {
            for (int i2 = 0; i2 < topicConfig.getReadQueueNums(); ++i2) {
                int queueId2 = (randomQ + i2) % topicConfig.getReadQueueNums();
                getMessageFuture = ((CompletableFuture)getMessageFuture).thenCompose(restNum -> this.popMsgFromQueue(false, getMessageResult, requestHeader, queueId2, (long)restNum, reviveQid, channel, popTime, finalMessageFilter, startOffsetInfo, msgOffsetInfo, finalOrderCountInfo));
            }
        } else {
            int queueId3 = requestHeader.getQueueId();
            getMessageFuture = ((CompletableFuture)getMessageFuture).thenCompose(restNum -> this.popMsgFromQueue(false, getMessageResult, requestHeader, queueId3, (long)restNum, reviveQid, channel, popTime, finalMessageFilter, startOffsetInfo, msgOffsetInfo, finalOrderCountInfo));
        }
        if (!needRetry && getMessageResult.getMessageMapedList().size() < requestHeader.getMaxMsgNums() && !requestHeader.isOrder() && (retryTopicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup()))) != null) {
            for (i = 0; i < retryTopicConfig.getReadQueueNums(); ++i) {
                queueId = (randomQ + i) % retryTopicConfig.getReadQueueNums();
                getMessageFuture = ((CompletableFuture)getMessageFuture).thenCompose(restNum -> this.popMsgFromQueue(true, getMessageResult, requestHeader, queueId, (long)restNum, reviveQid, channel, popTime, finalMessageFilter, startOffsetInfo, msgOffsetInfo, finalOrderCountInfo));
            }
        }
        RemotingCommand finalResponse = response;
        ((CompletableFuture)((CompletableFuture)getMessageFuture).thenApply(restNum -> {
            if (!getMessageResult.getMessageBufferList().isEmpty()) {
                finalResponse.setCode(0);
                getMessageResult.setStatus(GetMessageStatus.FOUND);
                if (restNum > 0L) {
                    this.notifyMessageArriving(requestHeader.getTopic(), requestHeader.getConsumerGroup(), requestHeader.getQueueId());
                }
            } else {
                int pollingResult = this.polling(channel, request, requestHeader);
                if (0 == pollingResult) {
                    return null;
                }
                if (1 == pollingResult) {
                    finalResponse.setCode(209);
                } else {
                    finalResponse.setCode(210);
                }
                getMessageResult.setStatus(GetMessageStatus.NO_MESSAGE_IN_QUEUE);
            }
            responseHeader.setInvisibleTime(requestHeader.getInvisibleTime());
            responseHeader.setPopTime(popTime);
            responseHeader.setReviveQid(reviveQid);
            responseHeader.setRestNum(restNum.longValue());
            responseHeader.setStartOffsetInfo(startOffsetInfo.toString());
            responseHeader.setMsgOffsetInfo(msgOffsetInfo.toString());
            if (requestHeader.isOrder() && finalOrderCountInfo != null) {
                responseHeader.setOrderCountInfo(finalOrderCountInfo.toString());
            }
            finalResponse.setRemark(getMessageResult.getStatus().name());
            switch (finalResponse.getCode()) {
                case 0: {
                    if (this.brokerController.getBrokerConfig().isTransferMsgByHeap()) {
                        long beginTimeMills = this.brokerController.getMessageStore().now();
                        byte[] r = this.readGetMessageResult(getMessageResult, requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
                        this.brokerController.getBrokerStatsManager().incGroupGetLatency(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId().intValue(), (int)(this.brokerController.getMessageStore().now() - beginTimeMills));
                        finalResponse.setBody(r);
                        break;
                    }
                    GetMessageResult tmpGetMessageResult = getMessageResult;
                    try {
                        ManyMessageTransfer fileRegion = new ManyMessageTransfer(finalResponse.encodeHeader(getMessageResult.getBufferTotalSize()), getMessageResult);
                        channel.writeAndFlush((Object)fileRegion).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                            tmpGetMessageResult.release();
                            Attributes attributes = RemotingMetricsManager.newAttributesBuilder().put("request_code", RemotingMetricsManager.getRequestCodeDesc((int)request.getCode())).put("response_code", RemotingMetricsManager.getResponseCodeDesc((int)finalResponse.getCode())).put("result", RemotingMetricsManager.getWriteAndFlushResult((Future)future)).build();
                            RemotingMetricsManager.rpcLatency.record(request.getProcessTimer().elapsed(TimeUnit.MILLISECONDS), attributes);
                            if (!future.isSuccess()) {
                                POP_LOGGER.error("Fail to transfer messages from page cache to {}", (Object)channel.remoteAddress(), (Object)future.cause());
                            }
                        }));
                    }
                    catch (Throwable e) {
                        POP_LOGGER.error("Error occurred when transferring messages from page cache", e);
                        getMessageResult.release();
                    }
                    return null;
                }
                default: {
                    return finalResponse;
                }
            }
            return finalResponse;
        })).thenAccept(result -> NettyRemotingAbstract.writeResponse((Channel)channel, (RemotingCommand)request, (RemotingCommand)result));
        return null;
    }

    private CompletableFuture<Long> popMsgFromQueue(boolean isRetry, GetMessageResult getMessageResult, PopMessageRequestHeader requestHeader, int queueId, long restNum, int reviveQid, Channel channel, long popTime, ExpressionMessageFilter messageFilter, StringBuilder startOffsetInfo, StringBuilder msgOffsetInfo, StringBuilder orderCountInfo) {
        String topic = isRetry ? KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup()) : requestHeader.getTopic();
        String lockKey = topic + "@" + requestHeader.getConsumerGroup() + "@" + queueId;
        boolean isOrder = requestHeader.isOrder();
        long offset = this.getPopOffset(topic, requestHeader.getConsumerGroup(), queueId, requestHeader.getInitMode(), false, lockKey, false);
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        if (!this.queueLockManager.tryLock(lockKey)) {
            restNum = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId) - offset + restNum;
            future.complete(restNum);
            return future;
        }
        try {
            future.whenComplete((result, throwable) -> this.queueLockManager.unLock(lockKey));
            offset = this.getPopOffset(topic, requestHeader.getConsumerGroup(), queueId, requestHeader.getInitMode(), true, lockKey, true);
            if (isOrder && this.brokerController.getConsumerOrderInfoManager().checkBlock(topic, requestHeader.getConsumerGroup(), queueId, requestHeader.getInvisibleTime())) {
                future.complete(this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId) - offset + restNum);
                return future;
            }
            if (isOrder) {
                this.brokerController.getPopInflightMessageCounter().clearInFlightMessageNum(topic, requestHeader.getConsumerGroup(), queueId);
            }
            if (getMessageResult.getMessageMapedList().size() >= requestHeader.getMaxMsgNums()) {
                restNum = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId) - offset + restNum;
                future.complete(restNum);
                return future;
            }
        }
        catch (Exception e) {
            POP_LOGGER.error("Exception in popMsgFromQueue", (Throwable)e);
            future.complete(restNum);
            return future;
        }
        AtomicLong atomicRestNum = new AtomicLong(restNum);
        AtomicLong atomicOffset = new AtomicLong(offset);
        long finalOffset = offset;
        return ((CompletableFuture)((CompletableFuture)this.brokerController.getMessageStore().getMessageAsync(requestHeader.getConsumerGroup(), topic, queueId, offset, requestHeader.getMaxMsgNums() - getMessageResult.getMessageMapedList().size(), (MessageFilter)messageFilter).thenCompose(result -> {
            if (result == null) {
                return CompletableFuture.completedFuture(null);
            }
            if (GetMessageStatus.OFFSET_TOO_SMALL.equals((Object)result.getStatus()) || GetMessageStatus.OFFSET_OVERFLOW_BADLY.equals((Object)result.getStatus()) || GetMessageStatus.OFFSET_FOUND_NULL.equals((Object)result.getStatus())) {
                POP_LOGGER.warn("Pop initial offset, because store is no correct, {}, {}->{}", new Object[]{lockKey, atomicOffset.get(), result.getNextBeginOffset()});
                this.brokerController.getConsumerOffsetManager().commitOffset(channel.remoteAddress().toString(), requestHeader.getConsumerGroup(), topic, queueId, result.getNextBeginOffset());
                atomicOffset.set(result.getNextBeginOffset());
                return this.brokerController.getMessageStore().getMessageAsync(requestHeader.getConsumerGroup(), topic, queueId, atomicOffset.get(), requestHeader.getMaxMsgNums() - getMessageResult.getMessageMapedList().size(), (MessageFilter)messageFilter);
            }
            return CompletableFuture.completedFuture(result);
        })).thenApply(result -> {
            if (result == null) {
                atomicRestNum.set(this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId) - atomicOffset.get() + atomicRestNum.get());
                return atomicRestNum.get();
            }
            if (!result.getMessageMapedList().isEmpty()) {
                this.brokerController.getBrokerStatsManager().incBrokerGetNums(requestHeader.getTopic(), result.getMessageCount());
                this.brokerController.getBrokerStatsManager().incGroupGetNums(requestHeader.getConsumerGroup(), topic, result.getMessageCount());
                this.brokerController.getBrokerStatsManager().incGroupGetSize(requestHeader.getConsumerGroup(), topic, result.getBufferTotalSize());
                Attributes attributes = BrokerMetricsManager.newAttributesBuilder().put("topic", requestHeader.getTopic()).put("consumer_group", requestHeader.getConsumerGroup()).put("is_system", TopicValidator.isSystemTopic((String)requestHeader.getTopic()) || MixAll.isSysConsumerGroup((String)requestHeader.getConsumerGroup())).put("is_retry", isRetry).build();
                BrokerMetricsManager.messagesOutTotal.add((long)result.getMessageCount(), attributes);
                BrokerMetricsManager.throughputOutTotal.add((long)result.getBufferTotalSize(), attributes);
                if (isOrder) {
                    this.brokerController.getConsumerOrderInfoManager().update(isRetry, topic, requestHeader.getConsumerGroup(), queueId, popTime, requestHeader.getInvisibleTime(), result.getMessageQueueOffset(), orderCountInfo);
                    this.brokerController.getConsumerOffsetManager().commitOffset(channel.remoteAddress().toString(), requestHeader.getConsumerGroup(), topic, queueId, finalOffset);
                } else {
                    this.appendCheckPoint(requestHeader, topic, reviveQid, queueId, finalOffset, (GetMessageResult)result, popTime, this.brokerController.getBrokerConfig().getBrokerName());
                }
                ExtraInfoUtil.buildStartOffsetInfo((StringBuilder)startOffsetInfo, (boolean)isRetry, (int)queueId, (long)finalOffset);
                ExtraInfoUtil.buildMsgOffsetInfo((StringBuilder)msgOffsetInfo, (boolean)isRetry, (int)queueId, (List)result.getMessageQueueOffset());
            } else if ((GetMessageStatus.NO_MATCHED_MESSAGE.equals((Object)result.getStatus()) || GetMessageStatus.OFFSET_FOUND_NULL.equals((Object)result.getStatus()) || GetMessageStatus.MESSAGE_WAS_REMOVING.equals((Object)result.getStatus()) || GetMessageStatus.NO_MATCHED_LOGIC_QUEUE.equals((Object)result.getStatus())) && result.getNextBeginOffset() > -1L) {
                this.popBufferMergeService.addCkMock(requestHeader.getConsumerGroup(), topic, queueId, finalOffset, requestHeader.getInvisibleTime(), popTime, reviveQid, result.getNextBeginOffset(), this.brokerController.getBrokerConfig().getBrokerName());
            }
            atomicRestNum.set(result.getMaxOffset() - result.getNextBeginOffset() + atomicRestNum.get());
            String brokerName = this.brokerController.getBrokerConfig().getBrokerName();
            for (SelectMappedBufferResult mapedBuffer : result.getMessageMapedList()) {
                if (!isRetry) {
                    getMessageResult.addMessage(mapedBuffer);
                    continue;
                }
                List messageExtList = MessageDecoder.decodesBatch((ByteBuffer)mapedBuffer.getByteBuffer(), (boolean)true, (boolean)false, (boolean)true);
                mapedBuffer.release();
                for (MessageExt messageExt : messageExtList) {
                    try {
                        String ckInfo = ExtraInfoUtil.buildExtraInfo((long)finalOffset, (long)popTime, (long)requestHeader.getInvisibleTime(), (int)reviveQid, (String)messageExt.getTopic(), (String)brokerName, (int)messageExt.getQueueId(), (long)messageExt.getQueueOffset());
                        messageExt.getProperties().putIfAbsent("POP_CK", ckInfo);
                        messageExt.setTopic(requestHeader.getTopic());
                        messageExt.setStoreSize(0);
                        byte[] encode = MessageDecoder.encode((MessageExt)messageExt, (boolean)false);
                        ByteBuffer buffer = ByteBuffer.wrap(encode);
                        SelectMappedBufferResult tmpResult = new SelectMappedBufferResult(mapedBuffer.getStartOffset(), buffer, encode.length, null);
                        getMessageResult.addMessage(tmpResult);
                    }
                    catch (Exception e) {
                        POP_LOGGER.error("Exception in recode retry message buffer, topic={}", (Object)topic, (Object)e);
                    }
                }
            }
            this.brokerController.getPopInflightMessageCounter().incrementInFlightMessageNum(topic, requestHeader.getConsumerGroup(), queueId, result.getMessageCount());
            return atomicRestNum.get();
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                POP_LOGGER.error("Pop message error, {}", (Object)lockKey, throwable);
            }
            this.queueLockManager.unLock(lockKey);
        });
    }

    private long getPopOffset(String topic, String group, int queueId, int initMode, boolean init, String lockKey, boolean checkResetOffset) {
        Long resetOffset;
        long offset = this.brokerController.getConsumerOffsetManager().queryOffset(group, topic, queueId);
        if (offset < 0L) {
            if (0 == initMode) {
                offset = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, queueId);
            } else {
                offset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId) - 1L;
                if (offset < 0L) {
                    offset = 0L;
                }
                if (init) {
                    this.brokerController.getConsumerOffsetManager().commitOffset("getPopOffset", group, topic, queueId, offset);
                }
            }
        }
        if (checkResetOffset && (resetOffset = this.resetPopOffset(topic, group, queueId)) != null) {
            return resetOffset;
        }
        long bufferOffset = this.popBufferMergeService.getLatestOffset(lockKey);
        if (bufferOffset < 0L) {
            return offset;
        }
        return Math.max(bufferOffset, offset);
    }

    private int polling(Channel channel, RemotingCommand remotingCommand, PopMessageRequestHeader requestHeader) {
        boolean isFull;
        if (requestHeader.getPollTime() <= 0L || this.popLongPollingService.isStopped()) {
            return 3;
        }
        ConcurrentHashMap<String, Byte> cids = this.topicCidMap.get(requestHeader.getTopic());
        if (cids == null) {
            cids = new ConcurrentHashMap();
            ConcurrentHashMap<String, Byte> old = this.topicCidMap.putIfAbsent(requestHeader.getTopic(), cids);
            if (old != null) {
                cids = old;
            }
        }
        cids.putIfAbsent(requestHeader.getConsumerGroup(), (byte)-128);
        long expired = requestHeader.getBornTime() + requestHeader.getPollTime();
        PopRequest request = new PopRequest(remotingCommand, channel, expired);
        boolean bl = isFull = this.totalPollingNum.get() >= this.brokerController.getBrokerConfig().getMaxPopPollingSize();
        if (isFull) {
            POP_LOGGER.info("polling {}, result POLLING_FULL, total:{}", (Object)remotingCommand, (Object)this.totalPollingNum.get());
            return 1;
        }
        boolean isTimeout = request.isTimeout();
        if (isTimeout) {
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.info("polling {}, result POLLING_TIMEOUT", (Object)remotingCommand);
            }
            return 2;
        }
        String key = KeyBuilder.buildPollingKey((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup(), (int)requestHeader.getQueueId());
        ConcurrentSkipListSet queue = (ConcurrentSkipListSet)this.pollingMap.get((Object)key);
        if (queue == null) {
            queue = new ConcurrentSkipListSet(PopRequest.COMPARATOR);
            ConcurrentSkipListSet old = (ConcurrentSkipListSet)this.pollingMap.putIfAbsent((Object)key, queue);
            if (old != null) {
                queue = old;
            }
        } else {
            int size = queue.size();
            if (size > this.brokerController.getBrokerConfig().getPopPollingSize()) {
                POP_LOGGER.info("polling {}, result POLLING_FULL, singleSize:{}", (Object)remotingCommand, (Object)size);
                return 1;
            }
        }
        if (queue.add((PopRequest)request)) {
            remotingCommand.setSuspended(true);
            this.totalPollingNum.incrementAndGet();
            if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                POP_LOGGER.info("polling {}, result POLLING_SUC", (Object)remotingCommand);
            }
            return 0;
        }
        POP_LOGGER.info("polling {}, result POLLING_FULL, add fail, {}", (Object)request, (Object)queue);
        return 1;
    }

    public final MessageExtBrokerInner buildCkMsg(PopCheckPoint ck, int reviveQid) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(this.reviveTopic);
        msgInner.setBody(JSON.toJSONString((Object)ck).getBytes(DataConverter.charset));
        msgInner.setQueueId(reviveQid);
        msgInner.setTags("ck");
        msgInner.setBornTimestamp(System.currentTimeMillis());
        msgInner.setBornHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setDeliverTimeMs(ck.getReviveTime() - PopAckConstants.ackTimeInterval);
        msgInner.getProperties().put("UNIQ_KEY", PopMessageProcessor.genCkUniqueId(ck));
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        return msgInner;
    }

    private void appendCheckPoint(PopMessageRequestHeader requestHeader, String topic, int reviveQid, int queueId, long offset, GetMessageResult getMessageTmpResult, long popTime, String brokerName) {
        PopCheckPoint ck = new PopCheckPoint();
        ck.setBitMap(0);
        ck.setNum((byte)getMessageTmpResult.getMessageMapedList().size());
        ck.setPopTime(popTime);
        ck.setInvisibleTime(requestHeader.getInvisibleTime());
        ck.setStartOffset(offset);
        ck.setCId(requestHeader.getConsumerGroup());
        ck.setTopic(topic);
        ck.setQueueId(queueId);
        ck.setBrokerName(brokerName);
        for (Long msgQueueOffset : getMessageTmpResult.getMessageQueueOffset()) {
            ck.addDiff((int)(msgQueueOffset - offset));
        }
        boolean addBufferSuc = this.popBufferMergeService.addCk(ck, reviveQid, -1L, getMessageTmpResult.getNextBeginOffset());
        if (addBufferSuc) {
            return;
        }
        this.popBufferMergeService.addCkJustOffset(ck, reviveQid, -1L, getMessageTmpResult.getNextBeginOffset());
    }

    private Long resetPopOffset(String topic, String group, int queueId) {
        String lockKey = topic + "@" + group + "@" + queueId;
        Long resetOffset = this.brokerController.getConsumerOffsetManager().queryThenEraseResetOffset(topic, group, queueId);
        if (resetOffset != null) {
            this.brokerController.getConsumerOrderInfoManager().clearBlock(topic, group, queueId);
            this.getPopBufferMergeService().clearOffsetQueue(lockKey);
            this.brokerController.getConsumerOffsetManager().commitOffset("ResetPopOffset", group, topic, queueId, resetOffset);
        }
        return resetOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readGetMessageResult(GetMessageResult getMessageResult, String group, String topic, int queueId) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(getMessageResult.getBufferTotalSize());
        long storeTimestamp = 0L;
        try {
            List messageBufferList = getMessageResult.getMessageBufferList();
            for (ByteBuffer bb : messageBufferList) {
                byteBuffer.put(bb);
                storeTimestamp = bb.getLong(56);
            }
        }
        finally {
            getMessageResult.release();
        }
        this.brokerController.getBrokerStatsManager().recordDiskFallBehindTime(group, topic, queueId, this.brokerController.getMessageStore().now() - storeTimestamp);
        return byteBuffer.array();
    }

    public class QueueLockManager
    extends ServiceThread {
        private ConcurrentHashMap<String, TimedLock> expiredLocalCache = new ConcurrentHashMap(100000);

        public String buildLockKey(String topic, String consumerGroup, int queueId) {
            return topic + "@" + consumerGroup + "@" + queueId;
        }

        public boolean tryLock(String topic, String consumerGroup, int queueId) {
            return this.tryLock(this.buildLockKey(topic, consumerGroup, queueId));
        }

        public boolean tryLock(String key) {
            TimedLock timedLock = this.expiredLocalCache.get(key);
            if (timedLock == null) {
                TimedLock old = this.expiredLocalCache.putIfAbsent(key, new TimedLock());
                if (old != null) {
                    return false;
                }
                timedLock = this.expiredLocalCache.get(key);
            }
            if (timedLock == null) {
                return false;
            }
            return timedLock.tryLock();
        }

        public int cleanUnusedLock(long usedExpireMillis) {
            Iterator<Map.Entry<String, TimedLock>> iterator = this.expiredLocalCache.entrySet().iterator();
            int total = 0;
            while (iterator.hasNext()) {
                Map.Entry<String, TimedLock> entry = iterator.next();
                if (System.currentTimeMillis() - entry.getValue().getLockTime() > usedExpireMillis) {
                    iterator.remove();
                    POP_LOGGER.info("Remove unused queue lock: {}, {}, {}", new Object[]{entry.getKey(), entry.getValue().getLockTime(), entry.getValue().isLock()});
                }
                ++total;
            }
            return total;
        }

        public void unLock(String topic, String consumerGroup, int queueId) {
            this.unLock(this.buildLockKey(topic, consumerGroup, queueId));
        }

        public void unLock(String key) {
            TimedLock timedLock = this.expiredLocalCache.get(key);
            if (timedLock != null) {
                timedLock.unLock();
            }
        }

        public String getServiceName() {
            if (PopMessageProcessor.this.brokerController.getBrokerConfig().isInBrokerContainer()) {
                return PopMessageProcessor.this.brokerController.getBrokerIdentity().getIdentifier() + QueueLockManager.class.getSimpleName();
            }
            return QueueLockManager.class.getSimpleName();
        }

        public void run() {
            while (!this.isStopped()) {
                try {
                    this.waitForRunning(60000L);
                    int count = this.cleanUnusedLock(60000L);
                    POP_LOGGER.info("QueueLockSize={}", (Object)count);
                }
                catch (Exception e) {
                    POP_LOGGER.error("QueueLockManager run error", (Throwable)e);
                }
            }
        }
    }

    static class TimedLock {
        private final AtomicBoolean lock = new AtomicBoolean(true);
        private volatile long lockTime = System.currentTimeMillis();

        public boolean tryLock() {
            boolean ret = this.lock.compareAndSet(true, false);
            if (ret) {
                this.lockTime = System.currentTimeMillis();
                return true;
            }
            return false;
        }

        public void unLock() {
            this.lock.set(true);
        }

        public boolean isLock() {
            return !this.lock.get();
        }

        public long getLockTime() {
            return this.lockTime;
        }
    }

    public class PopLongPollingService
    extends ServiceThread {
        private long lastCleanTime = 0L;

        public String getServiceName() {
            if (PopMessageProcessor.this.brokerController.getBrokerConfig().isInBrokerContainer()) {
                return PopMessageProcessor.this.brokerController.getBrokerIdentity().getIdentifier() + PopLongPollingService.class.getSimpleName();
            }
            return PopLongPollingService.class.getSimpleName();
        }

        private void cleanUnusedResource() {
            try {
                Map.Entry entry;
                Iterator topicCidMapIter = PopMessageProcessor.this.topicCidMap.entrySet().iterator();
                while (topicCidMapIter.hasNext()) {
                    entry = topicCidMapIter.next();
                    String topic = (String)entry.getKey();
                    if (PopMessageProcessor.this.brokerController.getTopicConfigManager().selectTopicConfig(topic) == null) {
                        POP_LOGGER.info("remove not exit topic {} in topicCidMap!", (Object)topic);
                        topicCidMapIter.remove();
                        continue;
                    }
                    Iterator cidMapIter = ((ConcurrentHashMap)entry.getValue()).entrySet().iterator();
                    while (cidMapIter.hasNext()) {
                        Map.Entry cidEntry = cidMapIter.next();
                        String cid = (String)cidEntry.getKey();
                        if (PopMessageProcessor.this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable().containsKey(cid)) continue;
                        POP_LOGGER.info("remove not exit sub {} of topic {} in topicCidMap!", (Object)cid, (Object)topic);
                        cidMapIter.remove();
                    }
                }
                Iterator pollingMapIter = PopMessageProcessor.this.pollingMap.entrySet().iterator();
                while (pollingMapIter.hasNext()) {
                    String[] keyArray;
                    entry = (Map.Entry)pollingMapIter.next();
                    if (entry.getKey() == null || (keyArray = ((String)entry.getKey()).split("@")) == null || keyArray.length != 3) continue;
                    String topic = keyArray[0];
                    String cid = keyArray[1];
                    if (PopMessageProcessor.this.brokerController.getTopicConfigManager().selectTopicConfig(topic) == null) {
                        POP_LOGGER.info("remove not exit topic {} in pollingMap!", (Object)topic);
                        pollingMapIter.remove();
                        continue;
                    }
                    if (PopMessageProcessor.this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable().containsKey(cid)) continue;
                    POP_LOGGER.info("remove not exit sub {} of topic {} in pollingMap!", (Object)cid, (Object)topic);
                    pollingMapIter.remove();
                }
            }
            catch (Throwable e) {
                POP_LOGGER.error("cleanUnusedResource", e);
            }
            this.lastCleanTime = System.currentTimeMillis();
        }

        public void run() {
            int i = 0;
            while (!this.stopped) {
                try {
                    this.waitForRunning(20L);
                    ++i;
                    if (PopMessageProcessor.this.pollingMap.isEmpty()) continue;
                    long tmpTotalPollingNum = 0L;
                    for (Map.Entry entry : PopMessageProcessor.this.pollingMap.entrySet()) {
                        PopRequest first;
                        String key = (String)entry.getKey();
                        ConcurrentSkipListSet popQ = (ConcurrentSkipListSet)entry.getValue();
                        if (popQ == null) continue;
                        while ((first = (PopRequest)popQ.pollFirst()) != null) {
                            if (!first.isTimeout()) {
                                if (popQ.add(first)) break;
                                POP_LOGGER.info("polling, add fail again: {}", (Object)first);
                            }
                            if (PopMessageProcessor.this.brokerController.getBrokerConfig().isEnablePopLog()) {
                                POP_LOGGER.info("timeout , wakeUp polling : {}", (Object)first);
                            }
                            PopMessageProcessor.this.totalPollingNum.decrementAndGet();
                            PopMessageProcessor.this.wakeUp(first);
                        }
                        if (i < 100) continue;
                        long tmpPollingNum = popQ.size();
                        tmpTotalPollingNum += tmpPollingNum;
                        if (tmpPollingNum <= 100L) continue;
                        POP_LOGGER.info("polling queue {} , size={} ", (Object)key, (Object)tmpPollingNum);
                    }
                    if (i >= 100) {
                        POP_LOGGER.info("pollingMapSize={},tmpTotalSize={},atomicTotalSize={},diffSize={}", new Object[]{PopMessageProcessor.this.pollingMap.size(), tmpTotalPollingNum, PopMessageProcessor.this.totalPollingNum.get(), Math.abs(PopMessageProcessor.this.totalPollingNum.get() - tmpTotalPollingNum)});
                        PopMessageProcessor.this.totalPollingNum.set(tmpTotalPollingNum);
                        i = 0;
                    }
                    if (this.lastCleanTime != 0L && System.currentTimeMillis() - this.lastCleanTime <= 300000L) continue;
                    this.cleanUnusedResource();
                }
                catch (Throwable e) {
                    POP_LOGGER.error("checkPolling error", e);
                }
            }
            try {
                for (Map.Entry entry : PopMessageProcessor.this.pollingMap.entrySet()) {
                    PopRequest first;
                    ConcurrentSkipListSet popQ = (ConcurrentSkipListSet)entry.getValue();
                    while ((first = (PopRequest)popQ.pollFirst()) != null) {
                        PopMessageProcessor.this.wakeUp(first);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

