/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.SumData;

enum PrometheusType {
    GAUGE("gauge"),
    COUNTER("counter"),
    SUMMARY("summary"),
    HISTOGRAM("histogram");

    private final String typeString;

    private PrometheusType(String typeString) {
        this.typeString = typeString;
    }

    static PrometheusType forMetric(MetricData metric) {
        switch (metric.getType()) {
            case LONG_GAUGE: 
            case DOUBLE_GAUGE: {
                return GAUGE;
            }
            case LONG_SUM: {
                SumData longSumData = metric.getLongSumData();
                if (longSumData.isMonotonic() && longSumData.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
                    return COUNTER;
                }
                return GAUGE;
            }
            case DOUBLE_SUM: {
                SumData doubleSumData = metric.getDoubleSumData();
                if (doubleSumData.isMonotonic() && doubleSumData.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
                    return COUNTER;
                }
                return GAUGE;
            }
            case SUMMARY: {
                return SUMMARY;
            }
            case HISTOGRAM: 
            case EXPONENTIAL_HISTOGRAM: {
                return HISTOGRAM;
            }
        }
        throw new IllegalArgumentException("Unsupported metric type, this generally indicates version misalignment among opentelemetry dependencies. Please make sure to use opentelemetry-bom.");
    }

    String getTypeString() {
        return this.typeString;
    }
}

