/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine;

import java.io.IOException;
import java.util.Objects;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ReflectionUtils;

public interface TransactionContext {
    public RaftProtos.RaftPeerRole getServerRole();

    public RaftClientRequest getClientRequest();

    public RaftProtos.StateMachineLogEntryProto getStateMachineLogEntry();

    public TransactionContext setException(Exception var1);

    public Exception getException();

    public TransactionContext setStateMachineContext(Object var1);

    public Object getStateMachineContext();

    public RaftProtos.LogEntryProto initLogEntry(long var1, long var3);

    public RaftProtos.LogEntryProto getLogEntry();

    public TransactionContext setShouldCommit(boolean var1);

    public boolean shouldCommit();

    public TransactionContext preAppendTransaction() throws IOException;

    public TransactionContext cancelTransaction() throws IOException;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private RaftProtos.RaftPeerRole serverRole = RaftProtos.RaftPeerRole.LEADER;
        private StateMachine stateMachine;
        private Object stateMachineContext;
        private RaftClientRequest clientRequest;
        private RaftProtos.LogEntryProto logEntry;
        private RaftProtos.StateMachineLogEntryProto stateMachineLogEntry;
        private ByteString logData;
        private ByteString stateMachineData;
        private static final Class<? extends TransactionContext> IMPL_CLASS = ReflectionUtils.getImplClass(TransactionContext.class);

        public Builder setServerRole(RaftProtos.RaftPeerRole serverRole) {
            this.serverRole = serverRole;
            return this;
        }

        public Builder setStateMachine(StateMachine stateMachine) {
            this.stateMachine = stateMachine;
            return this;
        }

        public Builder setStateMachineContext(Object stateMachineContext) {
            this.stateMachineContext = stateMachineContext;
            return this;
        }

        public Builder setClientRequest(RaftClientRequest clientRequest) {
            this.clientRequest = clientRequest;
            return this;
        }

        public Builder setLogEntry(RaftProtos.LogEntryProto logEntry) {
            this.logEntry = logEntry;
            return this;
        }

        public Builder setStateMachineLogEntry(RaftProtos.StateMachineLogEntryProto stateMachineLogEntry) {
            this.stateMachineLogEntry = stateMachineLogEntry;
            return this;
        }

        public Builder setLogData(ByteString logData) {
            this.logData = logData;
            return this;
        }

        public Builder setStateMachineData(ByteString stateMachineData) {
            this.stateMachineData = stateMachineData;
            return this;
        }

        public TransactionContext build() {
            Objects.requireNonNull(this.serverRole, "serverRole == null");
            Objects.requireNonNull(this.stateMachine, "stateMachine == null");
            if (this.clientRequest != null) {
                Preconditions.assertTrue(this.serverRole == RaftProtos.RaftPeerRole.LEADER, () -> "serverRole MUST be LEADER since clientRequest != null, serverRole is " + this.serverRole);
                Preconditions.assertNull((Object)this.logEntry, () -> "logEntry MUST be null since clientRequest != null");
                return Builder.newTransactionContext(this.stateMachine, this.clientRequest, this.stateMachineLogEntry, this.logData, this.stateMachineData, this.stateMachineContext);
            }
            Objects.requireNonNull(this.logEntry, "logEntry must not be null since clientRequest == null");
            Preconditions.assertTrue(this.logEntry.hasStateMachineLogEntry(), () -> "Unexpected logEntry: stateMachineLogEntry not found, logEntry=" + this.logEntry);
            return Builder.newTransactionContext(this.serverRole, this.stateMachine, this.logEntry);
        }

        private static TransactionContext newTransactionContext(StateMachine stateMachine, RaftClientRequest clientRequest, RaftProtos.StateMachineLogEntryProto stateMachineLogEntry, ByteString logData, ByteString stateMachineData, Object stateMachineContext) {
            Class[] argClasses = new Class[]{RaftClientRequest.class, StateMachine.class, RaftProtos.StateMachineLogEntryProto.class, ByteString.class, ByteString.class, Object.class};
            return ReflectionUtils.newInstance(IMPL_CLASS, argClasses, clientRequest, stateMachine, stateMachineLogEntry, logData, stateMachineData, stateMachineContext);
        }

        private static TransactionContext newTransactionContext(RaftProtos.RaftPeerRole serverRole, StateMachine stateMachine, RaftProtos.LogEntryProto logEntry) {
            Class[] argClasses = new Class[]{RaftProtos.RaftPeerRole.class, StateMachine.class, RaftProtos.LogEntryProto.class};
            return ReflectionUtils.newInstance(IMPL_CLASS, argClasses, serverRole, stateMachine, logEntry);
        }
    }
}

