/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.util.Preconditions;

final class ServerProtoUtils {
    private ServerProtoUtils() {
    }

    private static RaftProtos.RaftRpcReplyProto.Builder toRaftRpcReplyProtoBuilder(RaftPeerId requestorId, RaftGroupMemberId replyId, boolean success) {
        return ClientProtoUtils.toRaftRpcReplyProtoBuilder(requestorId.toByteString(), replyId.getPeerId().toByteString(), replyId.getGroupId(), null, success);
    }

    static RaftProtos.RequestVoteReplyProto toRequestVoteReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, boolean success, long term, boolean shouldShutdown, TermIndex lastEntry) {
        return RaftProtos.RequestVoteReplyProto.newBuilder().setServerReply(ServerProtoUtils.toRaftRpcReplyProtoBuilder(requestorId, replyId, success)).setTerm(term).setShouldShutdown(shouldShutdown).setLastEntry((lastEntry != null ? lastEntry : TermIndex.INITIAL_VALUE).toProto()).build();
    }

    static RaftProtos.RequestVoteRequestProto toRequestVoteRequestProto(RaftGroupMemberId requestorId, RaftPeerId replyId, long term, TermIndex lastEntry, boolean preVote) {
        RaftProtos.RequestVoteRequestProto.Builder b = RaftProtos.RequestVoteRequestProto.newBuilder().setServerRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(requestorId, replyId)).setCandidateTerm(term).setPreVote(preVote);
        Optional.ofNullable(lastEntry).map(TermIndex::toProto).ifPresent(b::setCandidateLastEntry);
        return b.build();
    }

    static RaftProtos.StartLeaderElectionReplyProto toStartLeaderElectionReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, boolean success) {
        return RaftProtos.StartLeaderElectionReplyProto.newBuilder().setServerReply(ServerProtoUtils.toRaftRpcReplyProtoBuilder(requestorId, replyId, success)).build();
    }

    static RaftProtos.StartLeaderElectionRequestProto toStartLeaderElectionRequestProto(RaftGroupMemberId requestorId, RaftPeerId replyId, TermIndex lastEntry) {
        RaftProtos.StartLeaderElectionRequestProto.Builder b = RaftProtos.StartLeaderElectionRequestProto.newBuilder().setServerRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(requestorId, replyId));
        if (lastEntry != null) {
            b.setLeaderLastEntry(lastEntry.toProto());
        }
        return b.build();
    }

    static RaftProtos.InstallSnapshotReplyProto toInstallSnapshotReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, long currentTerm, int requestIndex, RaftProtos.InstallSnapshotResult result) {
        RaftProtos.RaftRpcReplyProto.Builder rb = ServerProtoUtils.toRaftRpcReplyProtoBuilder(requestorId, replyId, ServerProtoUtils.isSuccess(result));
        RaftProtos.InstallSnapshotReplyProto.Builder builder = RaftProtos.InstallSnapshotReplyProto.newBuilder().setServerReply(rb).setTerm(currentTerm).setResult(result).setRequestIndex(requestIndex);
        return builder.build();
    }

    static RaftProtos.InstallSnapshotReplyProto toInstallSnapshotReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, long currentTerm, RaftProtos.InstallSnapshotResult result, long installedSnapshotIndex) {
        boolean success = ServerProtoUtils.isSuccess(result);
        Preconditions.assertTrue(success || installedSnapshotIndex == -1L, () -> "result=" + result + " but installedSnapshotIndex=" + installedSnapshotIndex);
        RaftProtos.RaftRpcReplyProto.Builder rb = ServerProtoUtils.toRaftRpcReplyProtoBuilder(requestorId, replyId, success);
        return RaftProtos.InstallSnapshotReplyProto.newBuilder().setServerReply(rb).setTerm(currentTerm).setResult(result).setSnapshotIndex(installedSnapshotIndex > 0L ? installedSnapshotIndex : 0L).build();
    }

    static RaftProtos.InstallSnapshotReplyProto toInstallSnapshotReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, long currentTerm, RaftProtos.InstallSnapshotResult result) {
        return ServerProtoUtils.toInstallSnapshotReplyProto(requestorId, replyId, currentTerm, result, -1L);
    }

    static RaftProtos.ReadIndexRequestProto toReadIndexRequestProto(RaftClientRequest clientRequest, RaftGroupMemberId requestorId, RaftPeerId replyId) {
        return RaftProtos.ReadIndexRequestProto.newBuilder().setServerRequest(ClientProtoUtils.toRaftRpcRequestProtoBuilder(requestorId, replyId)).setClientRequest(ClientProtoUtils.toRaftClientRequestProto(clientRequest, false)).build();
    }

    static RaftProtos.ReadIndexReplyProto toReadIndexReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, boolean success, long index) {
        return RaftProtos.ReadIndexReplyProto.newBuilder().setServerReply(ServerProtoUtils.toRaftRpcReplyProtoBuilder(requestorId, replyId, success)).setReadIndex(index).build();
    }

    static RaftProtos.ReadIndexReplyProto toReadIndexReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId) {
        return ServerProtoUtils.toReadIndexReplyProto(requestorId, replyId, false, -1L);
    }

    static RaftProtos.AppendEntriesReplyProto toAppendEntriesReplyProto(RaftPeerId requestorId, RaftGroupMemberId replyId, long term, long followerCommit, long nextIndex, RaftProtos.AppendEntriesReplyProto.AppendResult result, long callId, long matchIndex, boolean isHeartbeat) {
        RaftProtos.RaftRpcReplyProto.Builder rpcReply = ServerProtoUtils.toRaftRpcReplyProtoBuilder(requestorId, replyId, result == RaftProtos.AppendEntriesReplyProto.AppendResult.SUCCESS).setCallId(callId);
        return RaftProtos.AppendEntriesReplyProto.newBuilder().setServerReply(rpcReply).setTerm(term).setNextIndex(nextIndex).setMatchIndex(matchIndex).setFollowerCommit(followerCommit).setResult(result).setIsHearbeat(isHeartbeat).build();
    }

    static RaftProtos.AppendEntriesRequestProto toAppendEntriesRequestProto(RaftGroupMemberId requestorId, RaftPeerId replyId, long leaderTerm, List<RaftProtos.LogEntryProto> entries, long leaderCommit, boolean initializing, TermIndex previous, Collection<RaftProtos.CommitInfoProto> commitInfos, long callId) {
        RaftProtos.RaftRpcRequestProto.Builder rpcRequest = ClientProtoUtils.toRaftRpcRequestProtoBuilder(requestorId, replyId).setCallId(callId);
        RaftProtos.AppendEntriesRequestProto.Builder b = RaftProtos.AppendEntriesRequestProto.newBuilder().setServerRequest(rpcRequest).setLeaderTerm(leaderTerm).setLeaderCommit(leaderCommit).setInitializing(initializing);
        if (entries != null && !entries.isEmpty()) {
            b.addAllEntries(entries);
        }
        Optional.ofNullable(previous).map(TermIndex::toProto).ifPresent(b::setPreviousLog);
        Optional.ofNullable(commitInfos).ifPresent(b::addAllCommitInfos);
        return b.build();
    }

    static RaftProtos.ServerRpcProto toServerRpcProto(RaftPeer peer, long delay) {
        if (peer == null) {
            return RaftProtos.ServerRpcProto.getDefaultInstance();
        }
        return RaftProtos.ServerRpcProto.newBuilder().setId(peer.getRaftPeerProto()).setLastRpcElapsedTimeMs(delay).build();
    }

    static boolean isSuccess(RaftProtos.InstallSnapshotResult result) {
        switch (result) {
            case SUCCESS: 
            case SNAPSHOT_INSTALLED: 
            case ALREADY_INSTALLED: {
                return true;
            }
        }
        return false;
    }
}

