/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic.expression;

import java.util.Map;
import java.util.Objects;
import org.apache.ratis.examples.arithmetic.expression.Expression;
import org.apache.ratis.util.Preconditions;

public class DoubleValue
implements Expression {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    public static final DoubleValue ONE = new DoubleValue(1.0);
    private final double value;

    public DoubleValue(double value) {
        this.value = value;
    }

    DoubleValue(byte[] buf, int offset) {
        this(Expression.Utils.bytes2double(buf, offset + 1));
        Preconditions.assertTrue(buf[offset] == Expression.Type.DOUBLE.byteValue());
    }

    @Override
    public int toBytes(byte[] buf, int offset) {
        Preconditions.assertTrue(offset + this.length() <= buf.length);
        buf[offset++] = Expression.Type.DOUBLE.byteValue();
        Expression.Utils.double2bytes(this.value, buf, offset);
        return this.length();
    }

    @Override
    public int length() {
        return 9;
    }

    @Override
    public Double evaluate(Map<String, Double> variableMap) {
        return this.value;
    }

    public String toString() {
        long n = (long)this.value;
        return (double)n == this.value ? String.valueOf(n) : String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleValue that = (DoubleValue)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

